import { HighlightStyle } from '@codemirror/language';
import { Extension } from '@codemirror/state';
import { ITranslator } from '@jupyterlab/translation';
import { IEditorTheme, IEditorThemeRegistry } from './token';
export declare const jupyterEditorTheme: Extension;
export declare const jupyterHighlightStyle: HighlightStyle;
/**
 * JupyterLab CodeMirror 6 theme
 */
export declare const jupyterTheme: Extension;
/**
 * CodeMirror 6 theme registry
 */
export declare class EditorThemeRegistry implements IEditorThemeRegistry {
    /**
     * CodeMirror 6 themes
     */
    private _themeMap;
    /**
     * Get all themes
     */
    get themes(): IEditorTheme[];
    /**
     * Get the default CodeMirror 6 theme for JupyterLab
     *
     * @returns Default theme
     */
    defaultTheme(): Extension;
    /**
     * Register a new theme.
     *
     * @param theme Codemirror 6 theme
     */
    addTheme(theme: IEditorTheme): void;
    /**
     * Get a theme.
     *
     * #### Notes
     * It falls back to the default theme
     *
     * @param name Theme name
     * @returns Theme extension
     */
    getTheme(name: string): Extension;
}
/**
 * EditorThemeRegistry namespace
 */
export declare namespace EditorThemeRegistry {
    /**
     * Get the default editor themes.
     *
     * @param translator Application translator
     * @returns Default CodeMirror 6 themes
     */
    function getDefaultThemes(translator?: ITranslator | null): ReadonlyArray<Readonly<IEditorTheme>>;
}
