/* -----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
import { Token } from '@lumino/coreutils';
/**
 * The rendermime token.
 */
export const IRenderMimeRegistry = new Token('@jupyterlab/rendermime:IRenderMimeRegistry', 'A service for the rendermime registry for the application. Use this to create renderers for various mime-types in your extension. Many times it will be easier to create a "mime renderer extension" rather than using this service directly.');
/**
 * The latex typesetter token.
 */
export const ILatexTypesetter = new Token('@jupyterlab/rendermime:ILatexTypesetter', 'A service for the LaTeX typesetter for the application. Use this if you want to typeset math in your extension.');
/**
 * The markdown parser token.
 */
export const IMarkdownParser = new Token('@jupyterlab/rendermime:IMarkdownParser', 'A service for rendering markdown syntax as HTML content.');
//# sourceMappingURL=tokens.js.map