import { ITranslator } from '@jupyterlab/translation';
import { VDomModel, VDomRenderer } from '@jupyterlab/ui-components';
import { Notebook, NotebookMode } from '.';
/**
 * StatusBar item to display which notebook mode user is in.
 */
export declare class CommandEditStatus extends VDomRenderer<CommandEditStatus.Model> {
    /**
     * Construct a new CommandEdit status item.
     */
    constructor(translator?: ITranslator);
    /**
     * Render the CommandEdit status item.
     */
    render(): JSX.Element | null;
    protected translator: ITranslator;
    private _trans;
    private readonly _modeNames;
}
/**
 * A namespace for CommandEdit statics.
 */
export declare namespace CommandEditStatus {
    /**
     * A VDomModel for the CommandEdit renderer.
     */
    class Model extends VDomModel {
        /**
         * The current mode of the current notebook.
         */
        get notebookMode(): NotebookMode;
        /**
         * Set the current notebook for the model.
         */
        set notebook(notebook: Notebook | null);
        /**
         * On a change to the notebook, update the mode.
         */
        private _onChanged;
        /**
         * Trigger a state change for the renderer.
         */
        private _triggerChange;
        private _notebookMode;
        private _notebook;
    }
}
