amends "../snippetTest.pkl"

local `this` = 42 // keyword
local `that` = 43 // regular identifier
local `quick brown fox` = 44 // irregular identifier

local obj = new {
  `this` = 42
  `that` = 43
  `quick brown fox` = 44
}

examples {
  ["variable"] {
    `this`
    `that`
    `quick brown fox`
  }

  ["property"] {
    obj.`this`
    obj.`that`
    obj.`quick brown fox`
  }

  ["string interpolation"] {
    "\(`this`)"
    "\(`that`)"
    "\(`quick brown fox`)"
  }

  ["multiline string interpolation"] {
    """
    \(`this`)
    """
    """
    \(`that`)
    """
    """
    \(`quick brown fox`)
    """
  }
}


