import "pkl:reflect"
import "BaseModule.pkl"

referenceModule = "BaseModule.pkl"

function MyAnn(message: String): List<BaseModule.MyAnn> = List(new BaseModule.MyAnn {
  text = message
})

function method(m: reflect.Method, paramTypes: List<reflect.Type>, returnType: reflect.Type): Dynamic = new {
  hasExpectedLocation = m.location.displayUri.contains(referenceModule)
  docComment = m.docComment
  annotations = m.annotations
  modifiers = m.modifiers
  name = m.name
  typeParameters = m.typeParameters
  parameterNames = m.parameters.keys
  hasExpectedParameterTypes = m.parameters.values.map((it) -> it.type) == paramTypes
  hasExpectedReturnType = m.returnType == returnType
}

function property(p: reflect.Property, expectedType: reflect.Type): Dynamic = new {
  hasExpectedLocation = p.location.displayUri.contains(referenceModule)
  docComment = p.docComment
  annotations = p.annotations
  modifiers = p.modifiers
  name = p.name
  defaultValue = p.defaultValue
  hasExpectedType = p.type == expectedType
}
