<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/integrations/net_framework.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/metadata.yaml"
sidebar_label: "NET Framework"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Windows Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# NET Framework


<img src="https://netdata.cloud/img/dotnet.svg" width="150"/>


Plugin: windows.plugin
Module: PerflibNetFramework

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors application built with .NET


It queries different NET Framework objects per process from Perflib in order to gather the metrics.


This collector is only supported on the following platforms:

- windows

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The collector automatically detects all of the metrics, no further configuration is required.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Processes running

These metrics refer to NET applications.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| process | The process name. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| netframework.clrexception_thrown | exceptions | exceptions/s |
| netframework.clrexception_filters | filters | filters/s |
| netframework.clrexception_finallys | finallys | finallys/s |
| netframework.clrexception_throw_to_catch_depth | traversed | stack_frames/s |
| netframework.clrinterop_com_callable_wrappers | com_callable_wrappers | ccw/s |
| netframework.clrinterop_interop_marshallings | marshallings | marshallings/s |
| netframework.clrinterop_interop_stubs_created | created | stubs/s |
| netframework.clrjit_methods | jit-compiled | methods/s |
| netframework.clrjit_time | time | percentage |
| netframework.clrjit_standard_failures | failures | failures/s |
| netframework.clrjit_il_bytes | compiled_msil | bytes/s |
| netframework.clrloading_loader_heap_size | committed | bytes |
| netframework.clrloading_appdomains_loaded | loaded | domain/s |
| netframework.clrloading_appdomains_unloaded | unloaded | domain/s |
| netframework.clrloading_assemblies_loaded | loaded | assemblies/s |
| netframework.clrloading_classes_loaded | loaded | classes/s |
| netframework.clrloading_class_load_failures | class_load | failures/s |
| netframework.clrremoting_channels | registered | channels/s |
| netframework.clrremoting_context_bound_classes_loaded | loaded | classes |
| netframework.clrremoting_context_bound_objects | objects | objects/s |
| netframework.clrremoting_context_proxies | contexts | objects/s |
| netframework.clrremoting_remote_calls | rpc | calls/s |
| netframework.clrsecurity_link_time_checks | linktime | checks/s |
| netframework.clrsecurity_checks_time | time | percentage |
| netframework.clrsecurity_stack_walk_depth | stack | depth |
| netframework.clrsecurity_runtime_checks | runtime | checks/s |
| netframework.clrlocksandthreads_queue_length | threads | threads/s |
| netframework.clrlocksandthreads_current_logical_threads | logical | threads |
| netframework.clrlocksandthreads_current_physical_threads | physical | threads |
| netframework.clrlocksandthreads_recognized_threads | threads | threads/s |
| netframework.clrlocksandthreads_contentions | contentions | contentions/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup


### Prerequisites

No action required.

### Configuration

#### Options





| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| update every | Data collection frequency. | 1 | no |




#### via File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:windows:PerflibNetFramework]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```

##### Examples
There are no configuration examples.


