<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/integrations/cloud-notifications/integrations/telegram.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/integrations/cloud-notifications/metadata.yaml"
sidebar_label: "Telegram"
learn_status: "Published"
learn_rel_path: "Alerts & Notifications/Notifications/Centralized Cloud Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# Telegram

<img src="https://netdata.cloud/img/telegram.svg" width="150"/>

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup


### Prerequisites

- A Netdata Cloud account
- Access to the Space as an **Admin**
- The Space needs to be on a paid plan
- The Telegram bot token, chat ID and optionally the topic ID

### Telegram Configuration

- Bot token: To create one bot, contact the [@BotFather](https://t.me/BotFather) bot and send the command `/newbot` and follow the instructions. **Start a conversation with your bot or invite it into the group where you want it to send notifications**.
- To get the chat ID you have two options:
    - Contact the [@myidbot](https://t.me/myidbot) bot and send the `/getid` command to get your personal chat ID, or invite it into a group and use the `/getgroupid` command to get the group chat ID.
    - Alternatively, you can get the chat ID directly from the bot API. Send your bot a command in the chat you want to use, then check `https://api.telegram.org/bot{YourBotToken}/getUpdates`, eg. `https://api.telegram.org/bot111122223:7OpFlFFRzRBbrUUmIjj5HF9Ox2pYJZy5/getUpdates`
- To get the topic ID, the easiest way is this: Post a message to that topic, then right-click on it and select `Copy Message Link`. Paste it on a scratchpad and notice that it has the following structure `https://t.me/c/XXXXXXXXXX/YY/ZZ`. The topic ID is `YY` (integer).

### Netdata Configuration

1. Click on the **Space settings** cog (located above your profile icon)
2. Click on the **Alerts & Notifications** tab
3. Click on the **+ Add configuration** button
4. Add the Telegram Integration
5. A modal will be presented to you to enter the required details to enable the integration:
    - **Notification settings**
      - Configuration name (optional): A name for your configuration in order to easily refer to it
      - Rooms: A list of Rooms for which you want to be notified
      - Notifications: The notification types you want to receive
    - **Integration configuration**
      - Bot Token: The token of your bot
      - Chat ID: The chat id where your bot will deliver messages to
      - Topic ID: The identifier of the chat topic to which your bot will send messages. If omitted or 0, messages will be sent to the General topic. If topics are not supported, messages will be sent to the chat.


