// SPDX-License-Identifier: GPL-3.0-or-later

//go:build linux

package dmcache

import (
	"context"
	"fmt"
	"os/exec"
	"time"

	"github.com/netdata/netdata/go/plugins/logger"
)

type dmsetupCli interface {
	cacheStatus() ([]byte, error)
}

func newDmsetupExec(ndsudoPath string, timeout time.Duration, log *logger.Logger) *dmsetupExec {
	return &dmsetupExec{
		Logger:     log,
		ndsudoPath: ndsudoPath,
		timeout:    timeout,
	}
}

type dmsetupExec struct {
	*logger.Logger

	ndsudoPath string
	timeout    time.Duration
}

func (e *dmsetupExec) cacheStatus() ([]byte, error) {
	ctx, cancel := context.WithTimeout(context.Background(), e.timeout)
	defer cancel()

	cmd := exec.CommandContext(ctx, e.ndsudoPath, "dmsetup-status-cache")
	e.Debugf("executing '%s'", cmd)

	bs, err := cmd.Output()
	if err != nil {
		return nil, fmt.Errorf("error on '%s': %v", cmd, err)
	}

	return bs, nil
}
