/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.sign;

import org.jreleaser.bundle.RB;
import org.jreleaser.engine.sign.CosignSigner;
import org.jreleaser.engine.sign.MinisignSigner;
import org.jreleaser.engine.sign.PgpSigner;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.model.internal.signing.SigningTool;

public final class Signer {
    private Signer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sign(JReleaserContext context) throws SigningException {
        block17: {
            context.getLogger().info(RB.$((String)"signing.header", (Object[])new Object[0]));
            context.getLogger().increaseIndent();
            context.getLogger().setPrefix("sign");
            if (!context.getModel().getSigning().isEnabled()) {
                context.getLogger().info(RB.$((String)"signing.not.enabled", (Object[])new Object[0]));
                context.getLogger().restorePrefix();
                context.getLogger().decreaseIndent();
                return;
            }
            try {
                Signing signing = context.getModel().getSigning();
                if (signing.getPgp().isEnabled()) {
                    try {
                        context.getLogger().setPrefix("gpg");
                        new PgpSigner(context, (SigningTool)signing.getPgp()).sign();
                    }
                    finally {
                        context.getLogger().restorePrefix();
                    }
                }
                if (signing.getCosign().isEnabled()) {
                    try {
                        context.getLogger().setPrefix("cosign");
                        new CosignSigner(context, (SigningTool)signing.getCosign()).sign();
                    }
                    finally {
                        context.getLogger().restorePrefix();
                    }
                }
                if (!signing.getMinisign().isEnabled()) break block17;
                try {
                    context.getLogger().setPrefix("minisign");
                    new MinisignSigner(context, (SigningTool)signing.getMinisign()).sign();
                }
                finally {
                    context.getLogger().restorePrefix();
                }
            }
            finally {
                context.getLogger().restorePrefix();
                context.getLogger().decreaseIndent();
            }
        }
    }
}

