/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.environment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TreeSet;
import org.jreleaser.bundle.RB;
import org.jreleaser.config.JReleaserConfigLoader;
import org.jreleaser.config.JReleaserConfigParser;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public final class Environment {
    private Environment() {
    }

    public static void display(JReleaserLogger logger, Path basedir, Path settings) {
        if (null != settings) {
            if (!Files.isDirectory(settings, new LinkOption[0])) {
                Environment.loadVariables(logger, settings);
            } else {
                logger.warn(RB.$((String)"environment.load.variables.dir", (Object[])new Object[]{settings.toAbsolutePath()}));
                Environment.loadSettings(logger);
            }
        } else {
            Environment.loadSettings(logger);
        }
        Path envFilePath = basedir.resolve(".env");
        if (Files.exists(envFilePath, new LinkOption[0])) {
            Environment.loadVariables(logger, envFilePath);
        }
        TreeSet<String> vars = new TreeSet<String>();
        System.getenv().forEach((k, v) -> {
            if (k.startsWith("JRELEASER_") && StringUtils.isNotBlank((String)v)) {
                vars.add((String)k);
            }
        });
        if (System.getenv().containsKey(Env.envKey((String)"DEFAULT_GIT_REMOTE"))) {
            vars.add(Env.envKey((String)"DEFAULT_GIT_REMOTE"));
        }
        if (!vars.isEmpty()) {
            logger.info(RB.$((String)"environment.variables.env", (Object[])new Object[0]));
            vars.forEach(message -> logger.info("  " + message));
        }
    }

    private static void loadSettings(JReleaserLogger logger) {
        Path configDirectory = null;
        String home = System.getenv("XDG_CONFIG_HOME");
        if (StringUtils.isNotBlank((String)home) && Files.exists(Paths.get(home, new String[0]).resolve("jreleaser"), new LinkOption[0])) {
            configDirectory = Paths.get(home, new String[0]).resolve("jreleaser");
        }
        if (null == configDirectory) {
            home = System.getenv("JRELEASER_USER_HOME");
            if (StringUtils.isBlank((String)home)) {
                home = System.getProperty("user.home") + File.separator + ".jreleaser";
            }
            configDirectory = Paths.get(home, new String[0]);
        }
        Environment.loadVariables(logger, Environment.resolveConfigFileAt(configDirectory).orElse(configDirectory.resolve("config.properties")));
    }

    private static void loadVariables(JReleaserLogger logger, Path file) {
        Properties p;
        TreeSet vars;
        block12: {
            vars = new TreeSet();
            p = new Properties();
            logger.info(RB.$((String)"environment.load.variables", (Object[])new Object[0]), new Object[]{file.toAbsolutePath()});
            if (Files.exists(file, new LinkOption[0])) {
                try {
                    if (file.getFileName().toString().endsWith(".properties") || file.getFileName().toString().equals(".env")) {
                        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                            p.load(in);
                            break block12;
                        }
                    }
                    p.putAll((Map<?, ?>)JReleaserConfigLoader.loadProperties((Path)file));
                }
                catch (IOException e) {
                    logger.debug(RB.$((String)"environment.variables.load.error", (Object[])new Object[0]), new Object[]{file.toAbsolutePath(), e});
                }
            } else {
                logger.warn(RB.$((String)"environment.variables.source.missing", (Object[])new Object[0]), new Object[]{file.toAbsolutePath()});
            }
        }
        p.stringPropertyNames().stream().filter(k -> k.startsWith("JRELEASER_")).forEach(vars::add);
        if (!vars.isEmpty()) {
            logger.info(RB.$((String)"environment.variables.file", (Object[])new Object[]{file.getFileName().toString()}));
            vars.forEach(message -> logger.info("  " + message));
        }
    }

    private static Optional<Path> resolveConfigFileAt(Path directory) {
        ServiceLoader<JReleaserConfigParser> parsers = ServiceLoader.load(JReleaserConfigParser.class, JReleaserConfigParser.class.getClassLoader());
        for (JReleaserConfigParser parser : parsers) {
            Path file = directory.resolve("config." + parser.getPreferredFileExtension());
            if (!Files.exists(file, new LinkOption[0])) continue;
            return Optional.of(file);
        }
        return Optional.empty();
    }
}

