/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jreleaser.assemblers.AbstractAssemblerProcessor;
import org.jreleaser.assemblers.AssemblerUtils;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.Assembler;
import org.jreleaser.model.internal.assemble.JavaAssembler;
import org.jreleaser.model.internal.assemble.JlinkAssembler;
import org.jreleaser.model.internal.assemble.JpackageAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.spi.assemble.AssemblerProcessingException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.templates.TemplateResource;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.version.SemanticVersion;

public class JpackageAssemblerProcessor
extends AbstractAssemblerProcessor<org.jreleaser.model.api.assemble.JpackageAssembler, JpackageAssembler> {
    private static final String FILES_DIRECTORY = "files";

    public JpackageAssemblerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doAssemble(TemplateContext props) throws AssemblerProcessingException {
        JpackageAssembler.PlatformPackager packager = ((JpackageAssembler)this.assembler).getResolvedPlatformPackager();
        if (!packager.getJdk().isActiveAndSelected()) {
            return;
        }
        Path jdkPath = packager.getJdk().getEffectivePath(this.context, this.assembler);
        SemanticVersion jdkVersion = SemanticVersion.of((String)AssemblerUtils.readJavaVersion(jdkPath));
        this.context.getLogger().debug(RB.$((String)"assembler.jpackage.jdk", (Object[])new Object[0]), new Object[]{jdkVersion, jdkPath.toAbsolutePath().toString()});
        if (jdkVersion.getMajor() < 16) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_jpackage_minimum_jdk_required", (Object[])new Object[]{jdkVersion.toString()}));
        }
        String platform = packager.getJdk().getPlatform();
        String platformReplaced = ((JpackageAssembler)this.assembler).getPlatform().applyReplacements(platform);
        Path assembleDirectory = (Path)props.get("distributionAssembleDirectory");
        Path workDirectory = assembleDirectory.resolve("work-" + platformReplaced);
        Path inputsDirectory = workDirectory.resolve("inputs");
        Path filesDirectory = inputsDirectory.resolve(FILES_DIRECTORY);
        this.copyTemplates(this.context, props, filesDirectory);
        this.copyArtifacts(this.context, filesDirectory, platform, true);
        this.copyFiles(this.context, filesDirectory);
        this.copyFileSets(this.context, filesDirectory);
        this.context.getLogger().debug(RB.$((String)"assembler.copy.jars", (Object[])new Object[0]), new Object[]{this.context.relativizeToBasedir(filesDirectory)});
        if (StringUtils.isBlank((String)((JpackageAssembler)this.assembler).getJava().getMainModule())) {
            JlinkAssembler jlink;
            if (StringUtils.isNotBlank((String)((JpackageAssembler)this.assembler).getJlink()) && (jlink = this.context.getModel().getAssemble().findJlink(((JpackageAssembler)this.assembler).getJlink())).getJavaArchive().isSet()) {
                String configuredPath = jlink.getJavaArchive().getPath();
                String archiveFile = Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)configuredPath, (TemplateContext)props);
                Path archivePath = this.context.getBasedir().resolve(Paths.get(archiveFile, new String[0]));
                if (!Files.exists(archivePath, new LinkOption[0])) {
                    throw new AssemblerProcessingException(RB.$((String)"ERROR_path_does_not_exist_2", (Object[])new Object[]{configuredPath, archivePath}));
                }
                Path archiveDirectory = inputsDirectory.resolve("archive");
                try {
                    FileUtils.unpackArchive((Path)archivePath, (Path)archiveDirectory, (boolean)true);
                }
                catch (IOException e) {
                    throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
                }
                String libDirectoryName = Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)jlink.getJavaArchive().getLibDirectoryName(), (TemplateContext)props);
                Path libPath = inputsDirectory.resolve("archive").resolve(libDirectoryName);
                try {
                    FileUtils.copyFiles((JReleaserLogger)this.context.getLogger(), (Path)libPath, (Path)filesDirectory);
                }
                catch (IOException e) {
                    throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
                }
            }
            AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, filesDirectory, "");
            AssemblerUtils.copyJars(this.context, (JavaAssembler)this.assembler, filesDirectory, platform);
        }
        this.copyIcon(this.context, (JpackageAssembler)this.assembler, packager, inputsDirectory, platform, props);
        if (StringUtils.isNotBlank((String)((JpackageAssembler)this.assembler).getJlink())) {
            this.adjustRuntimeImage(this.context, (JpackageAssembler)this.assembler, workDirectory, platform);
        }
        for (String type : packager.getTypes()) {
            this.context.getLogger().info("- " + RB.$((String)"assembler.jpackage.type", (Object[])new Object[0]), new Object[]{type});
            this.jpackage(this.context, type, workDirectory, props);
        }
    }

    private void copyIcon(JReleaserContext context, JpackageAssembler assembler, JpackageAssembler.PlatformPackager packager, Path inputsDirectory, String platform, TemplateContext props) throws AssemblerProcessingException {
        block12: {
            String p = "linux";
            String ext = ".png";
            if (PlatformUtils.isWindows((String)platform)) {
                p = "windows";
                ext = ".ico";
            } else if (PlatformUtils.isMac((String)platform)) {
                p = "osx";
                ext = ".icns";
            }
            String icon = Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)packager.getIcon(), (TemplateContext)props);
            try {
                if (StringUtils.isNotBlank((String)icon) && Files.exists(context.getBasedir().resolve(icon), new LinkOption[0]) && icon.endsWith(ext)) {
                    Path iconPath = context.getBasedir().resolve(icon);
                    Files.copy(iconPath, inputsDirectory.resolve(assembler.getName() + ext), StandardCopyOption.REPLACE_EXISTING);
                    break block12;
                }
                String iconResource = "META-INF/jreleaser/icons/" + p + "/duke" + ext;
                try (TemplateResource templateResource = TemplateUtils.resolveResource((JReleaserLogger)context.getLogger(), (String)iconResource);){
                    this.writeFile(IOUtils.toByteArray((InputStream)templateResource.getInputStream()), inputsDirectory.resolve(assembler.getName() + ext));
                }
            }
            catch (Exception e) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    private void adjustRuntimeImage(JReleaserContext context, JpackageAssembler assembler, Path workDirectory, String platform) throws AssemblerProcessingException {
        Optional runtimeImageByPlatform = assembler.findRuntimeImageByPlatform(platform);
        if (!runtimeImageByPlatform.isPresent()) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_jpackage_runtime_image_not_found", (Object[])new Object[]{platform}));
        }
        Path originalImage = ((Artifact)runtimeImageByPlatform.get()).getEffectivePath(context, (Assembler)assembler);
        Path adjustedImage = workDirectory.resolve("runtime-image");
        try {
            if (!FileUtils.copyFilesRecursive((JReleaserLogger)context.getLogger(), (Path)originalImage, (Path)adjustedImage, path -> {
                String fileName = path.getFileName().toString();
                boolean pathIsJar = fileName.endsWith(FileType.JAR.extension()) && path.getParent().getFileName().toString().equals("jars");
                boolean pathIsExecutable = fileName.equals(context.getModel().getAssemble().findJlink(assembler.getJlink()).getExecutable());
                return pathIsJar || pathIsExecutable;
            })) {
                throw new IOException(RB.$((String)"ERROR_assembler_adjusting_image", (Object[])new Object[]{adjustedImage}));
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        ((Artifact)runtimeImageByPlatform.get()).setPath(adjustedImage.toAbsolutePath().toString());
    }

    private void jpackage(JReleaserContext context, String type, Path workDirectory, TemplateContext props) throws AssemblerProcessingException {
        Object licenseFilePath;
        JpackageAssembler.PlatformPackager packager = ((JpackageAssembler)this.assembler).getResolvedPlatformPackager();
        Path jdkPath = packager.getJdk().getEffectivePath(context, this.assembler);
        String platform = packager.getJdk().getPlatform();
        String platformReplaced = ((JpackageAssembler)this.assembler).getPlatform().applyReplacements(platform);
        Path assembleDirectory = workDirectory.getParent();
        Path packagerDirectory = workDirectory.resolve(type).toAbsolutePath();
        try {
            FileUtils.deleteFiles((Path)packagerDirectory);
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_delete_dir", (Object[])new Object[]{context.relativizeToBasedir(packagerDirectory)}), (Throwable)e);
        }
        Path inputsDirectory = workDirectory.resolve("inputs");
        Optional runtimeImageByPlatform = ((JpackageAssembler)this.assembler).findRuntimeImageByPlatform(platform);
        if (!runtimeImageByPlatform.isPresent()) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_jpackage_runtime_image_not_found", (Object[])new Object[]{platform}));
        }
        String moduleName = Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)((JpackageAssembler)this.assembler).getJava().getMainModule(), (TemplateContext)props);
        String mainClass = Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)((JpackageAssembler)this.assembler).getJava().getMainClass(), (TemplateContext)props);
        String appName = packager.getResolvedAppName(context, (JpackageAssembler)this.assembler);
        String appVersion = ((JpackageAssembler)this.assembler).getApplicationPackage().getResolvedAppVersion(context, (JpackageAssembler)this.assembler);
        String vendor = Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)((JpackageAssembler)this.assembler).getApplicationPackage().getVendor(), (TemplateContext)props);
        String copyright = Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)((JpackageAssembler)this.assembler).getApplicationPackage().getCopyright(), (TemplateContext)props);
        Path jpackageExecutable = jdkPath.resolve("bin").resolve(PlatformUtils.isWindows() ? "jpackage.exe" : "jpackage").toAbsolutePath();
        Command cmd = new Command(jpackageExecutable.toAbsolutePath().toString(), true).arg("--type").arg(type).arg("--dest").arg(assembleDirectory.toAbsolutePath().toString()).arg("--input").arg(inputsDirectory.resolve(FILES_DIRECTORY).toAbsolutePath().toString()).arg("--name").arg(this.maybeQuote(appName)).arg("--runtime-image").arg(this.maybeQuote(((Artifact)runtimeImageByPlatform.get()).getEffectivePath(context, this.assembler).toAbsolutePath().toString())).arg("--app-version").arg(appVersion).arg("--vendor").arg(this.maybeQuote(vendor)).arg("--copyright").arg(this.maybeQuote(copyright)).arg("--description").arg(this.maybeQuote(context.getModel().getProject().getDescription()));
        if (((JpackageAssembler)this.assembler).isVerbose()) {
            cmd.arg("--verbose");
        }
        if (StringUtils.isNotBlank((String)moduleName)) {
            cmd.arg("--module").arg(moduleName + "/" + mainClass);
        } else {
            JlinkAssembler jlink;
            Object mainJarPath = "";
            if (StringUtils.isNotBlank((String)((JpackageAssembler)this.assembler).getMainJar().getPath())) {
                mainJarPath = ((JpackageAssembler)this.assembler).getMainJar().getResolvedPath().getFileName().toString();
            }
            if (StringUtils.isNotBlank((String)((JpackageAssembler)this.assembler).getJlink()) && (jlink = context.getModel().getAssemble().findJlink(((JpackageAssembler)this.assembler).getJlink())).getJavaArchive().isSet()) {
                String mainJarName = Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)jlink.getJavaArchive().getMainJarName(), (TemplateContext)props);
                Path filesDirectory = inputsDirectory.resolve(FILES_DIRECTORY);
                mainJarPath = filesDirectory.resolve(mainJarName).getFileName().toString();
            }
            cmd.arg("--main-class").arg(mainClass).arg("--main-jar").arg(this.maybeQuote((String)mainJarPath));
        }
        for (String argument : ((JpackageAssembler)this.assembler).getLauncher().getArguments()) {
            cmd.arg("--arguments").arg(this.maybeQuote(Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)argument, (TemplateContext)props)));
        }
        for (String javaOption : ((JpackageAssembler)this.assembler).getLauncher().getJavaOptions()) {
            cmd.arg("--java-options").arg(this.maybeQuote(Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)javaOption, (TemplateContext)props)));
        }
        for (String launcher : ((JpackageAssembler)this.assembler).getLauncher().getLaunchers()) {
            cmd.arg("--add-launcher").arg(this.maybeQuote(Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)launcher, (TemplateContext)props)));
        }
        String licenseFile = Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)((JpackageAssembler)this.assembler).getApplicationPackage().getLicenseFile(), (TemplateContext)props);
        if (StringUtils.isNotBlank((String)licenseFile) && Files.exists((Path)(licenseFilePath = context.getBasedir().resolve(licenseFile)), new LinkOption[0])) {
            cmd.arg("--license-file").arg(this.maybeQuote(licenseFilePath.toAbsolutePath().toString()));
        }
        if (!((JpackageAssembler)this.assembler).getApplicationPackage().getFileAssociations().isEmpty()) {
            for (String filename : ((JpackageAssembler)this.assembler).getApplicationPackage().getFileAssociations()) {
                Path path = context.getBasedir().resolve(Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)filename, (TemplateContext)props));
                if (!Files.exists(path, new LinkOption[0])) continue;
                cmd.arg("--file-associations").arg(this.maybeQuote(path.toAbsolutePath().toString()));
            }
        }
        this.customize(type, packager, inputsDirectory, cmd, props);
        context.getLogger().debug(String.join((CharSequence)" ", cmd.getArgs()));
        Command.Result result = this.executeCommand(cmd);
        if (((JpackageAssembler)this.assembler).isVerbose()) {
            context.getLogger().debug(result.getOut());
        }
        if (!PlatformUtils.isLinux((String)platform) && ((JpackageAssembler)this.assembler).isAttachPlatform()) {
            try {
                Optional artifact = FileUtils.listFilesAndProcess((Path)assembleDirectory, files -> files.filter(path -> path.getFileName().toString().endsWith(type)).findFirst().orElse(null));
                if (artifact.isPresent()) {
                    String dest = ((Path)artifact.get()).getFileName().toString().replace("." + type, "-" + platformReplaced + "." + type);
                    Files.move(assembleDirectory.resolve(((Path)artifact.get()).getFileName()), assembleDirectory.resolve(dest), StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                throw new AssemblerProcessingException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    private void customize(String type, JpackageAssembler.PlatformPackager packager, Path inputsDirectory, Command cmd, TemplateContext props) {
        Path resourceDirPath;
        String resourceDir;
        String installDir = Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getInstallDir(), (TemplateContext)props);
        if (StringUtils.isNotBlank((String)installDir)) {
            cmd.arg("--install-dir").arg(this.maybeQuote(installDir));
        }
        if (StringUtils.isNotBlank((String)(resourceDir = Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getResourceDir(), (TemplateContext)props))) && Files.exists(resourceDirPath = this.context.getBasedir().resolve(resourceDir), new LinkOption[0])) {
            cmd.arg("--resource-dir").arg(this.maybeQuote(resourceDirPath.toAbsolutePath().toString()));
        }
        if (packager instanceof JpackageAssembler.Osx) {
            this.customizeOsx((JpackageAssembler.Osx)packager, inputsDirectory, cmd, props);
        } else if (packager instanceof JpackageAssembler.Linux) {
            this.customizeLinux(type, (JpackageAssembler.Linux)packager, inputsDirectory, cmd, props);
        } else if (packager instanceof JpackageAssembler.Windows) {
            this.customizeWindows((JpackageAssembler.Windows)packager, inputsDirectory, cmd, props);
        }
    }

    private void customizeOsx(JpackageAssembler.Osx packager, Path inputsDirectory, Command cmd, TemplateContext props) {
        Path path;
        String signingKeychain;
        if (StringUtils.isNotBlank((String)packager.getPackageName())) {
            cmd.arg("--mac-package-name").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getPackageName(), (TemplateContext)props));
        }
        if (StringUtils.isNotBlank((String)packager.getPackageIdentifier())) {
            cmd.arg("--mac-package-identifier").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getPackageIdentifier(), (TemplateContext)props));
        }
        if (StringUtils.isNotBlank((String)packager.getPackageSigningPrefix())) {
            cmd.arg("--mac-package-signing-prefix").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getPackageSigningPrefix(), (TemplateContext)props));
        }
        if (packager.isSign()) {
            cmd.arg("--mac-sign");
        }
        if (StringUtils.isNotBlank((String)(signingKeychain = Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getSigningKeychain(), (TemplateContext)props))) && Files.exists(path = this.context.getBasedir().resolve(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)signingKeychain, (TemplateContext)props)), new LinkOption[0])) {
            cmd.arg("--mac-signing-keychain").arg(path.toAbsolutePath().toString());
        }
        if (StringUtils.isNotBlank((String)packager.getSigningKeyUsername())) {
            cmd.arg("--mac-signing-key-user-name").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getSigningKeyUsername(), (TemplateContext)props));
        }
        cmd.arg("--icon").arg(inputsDirectory.resolve(((JpackageAssembler)this.assembler).getName() + ".icns").toAbsolutePath().toString());
    }

    private void customizeLinux(String type, JpackageAssembler.Linux packager, Path inputsDirectory, Command cmd, TemplateContext props) {
        if (StringUtils.isNotBlank((String)packager.getPackageName())) {
            cmd.arg("--linux-package-name").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getPackageName(), (TemplateContext)props));
        }
        if (StringUtils.isNotBlank((String)packager.getMenuGroup())) {
            cmd.arg("--linux-menu-group").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getMenuGroup(), (TemplateContext)props));
        }
        if (StringUtils.isNotBlank((String)packager.getAppRelease())) {
            cmd.arg("--linux-app-release").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getAppRelease(), (TemplateContext)props));
        }
        if (StringUtils.isNotBlank((String)packager.getAppCategory())) {
            cmd.arg("--linux-app-category").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getAppCategory(), (TemplateContext)props));
        }
        if (packager.isShortcut()) {
            cmd.arg("--linux-shortcut");
        }
        if (!packager.getPackageDeps().isEmpty()) {
            cmd.arg("--linux-package-deps").arg(packager.getPackageDeps().stream().map(arg -> Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)arg, (TemplateContext)props)).collect(Collectors.joining(",")));
        }
        if ("deb".equals(type)) {
            if (StringUtils.isNotBlank((String)packager.getMaintainer())) {
                cmd.arg("--linux-deb-maintainer").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getMaintainer(), (TemplateContext)props));
            }
        } else if ("rpm".equals(type) && StringUtils.isNotBlank((String)packager.getLicense())) {
            cmd.arg("--linux-rpm-license-type").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getLicense(), (TemplateContext)props));
        }
        cmd.arg("--icon").arg(inputsDirectory.resolve(((JpackageAssembler)this.assembler).getName() + ".png").toAbsolutePath().toString());
    }

    private void customizeWindows(JpackageAssembler.Windows packager, Path inputsDirectory, Command cmd, TemplateContext props) {
        if (packager.isConsole()) {
            cmd.arg("--win-console");
        }
        if (packager.isDirChooser()) {
            cmd.arg("--win-dir-chooser");
        }
        if (packager.isMenu()) {
            cmd.arg("--win-menu");
        }
        if (packager.isPerUserInstall()) {
            cmd.arg("--win-per-user-install");
        }
        if (packager.isShortcut()) {
            cmd.arg("--win-shortcut");
        }
        if (packager.isShortcutPrompt()) {
            cmd.arg("--win-shortcut-prompt");
        }
        if (StringUtils.isNotBlank((String)packager.getMenuGroup())) {
            cmd.arg("--win-menu-group").arg(this.maybeQuote(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getMenuGroup(), (TemplateContext)props)));
        }
        if (StringUtils.isNotBlank((String)packager.getUpgradeUuid())) {
            cmd.arg("--win-upgrade-uuid").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getUpgradeUuid(), (TemplateContext)props));
        }
        if (StringUtils.isNotBlank((String)packager.getHelpUrl())) {
            cmd.arg("--win-help-url").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getHelpUrl(), (TemplateContext)props));
        }
        if (StringUtils.isNotBlank((String)packager.getUpdateUrl())) {
            cmd.arg("--win-update-url").arg(Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)packager.getUpdateUrl(), (TemplateContext)props));
        }
        cmd.arg("--icon").arg(this.maybeQuote(inputsDirectory.resolve(((JpackageAssembler)this.assembler).getName() + ".ico").toAbsolutePath().toString()));
    }
}

