/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.tools;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.StringUtils;

public final class Jbang
extends AbstractModelObject<Jbang>
implements Domain {
    private static final long serialVersionUID = -5302165340574693085L;
    private final List<String> args = new ArrayList<String>();
    private final List<String> jbangArgs = new ArrayList<String>();
    private final List<String> trusts = new ArrayList<String>();
    private String version;
    private String script;
    @JsonIgnore
    private final org.jreleaser.model.api.tools.Jbang immutable = new org.jreleaser.model.api.tools.Jbang(){
        private static final long serialVersionUID = -684610546142494357L;

        public String getVersion() {
            return Jbang.this.version;
        }

        public String getScript() {
            return Jbang.this.script;
        }

        public List<String> getArgs() {
            return Collections.unmodifiableList(Jbang.this.args);
        }

        public List<String> getJbangArgs() {
            return Collections.unmodifiableList(Jbang.this.jbangArgs);
        }

        public List<String> getTrusts() {
            return Collections.unmodifiableList(Jbang.this.trusts);
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(Jbang.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.tools.Jbang asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(Jbang source) {
        this.version = this.merge(this.version, source.version);
        this.script = this.merge(this.script, source.script);
        this.setArgs(this.merge(this.args, source.args));
        this.setJbangArgs(this.merge(this.jbangArgs, source.jbangArgs));
        this.setTrusts(this.merge(this.trusts, source.trusts));
    }

    public boolean isSet() {
        return StringUtils.isNotBlank((String)this.script);
    }

    public String getResolvedScript(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        context.getModel().getRelease().getReleaser().fillProps(props, context);
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.script, (TemplateContext)props);
    }

    public List<String> getResolvedArgs(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        context.getModel().getRelease().getReleaser().fillProps(props, context);
        return this.args.stream().map(s -> Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)s, (TemplateContext)props)).collect(Collectors.toList());
    }

    public List<String> getResolvedJbangArgs(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        context.getModel().getRelease().getReleaser().fillProps(props, context);
        return this.jbangArgs.stream().map(s -> Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)s, (TemplateContext)props)).collect(Collectors.toList());
    }

    public List<String> getResolvedTrusts(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        context.getModel().getRelease().getReleaser().fillProps(props, context);
        return this.trusts.stream().map(s -> Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)s, (TemplateContext)props)).collect(Collectors.toList());
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public List<String> getJbangArgs() {
        return this.jbangArgs;
    }

    public void setJbangArgs(List<String> jbangArgs) {
        this.jbangArgs.clear();
        this.jbangArgs.addAll(jbangArgs);
    }

    public List<String> getTrusts() {
        return this.trusts;
    }

    public void setTrusts(List<String> trusts) {
        this.trusts.clear();
        this.trusts.addAll(trusts);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("version", this.version);
        props.put("script", this.script);
        props.put("args", this.args);
        props.put("jbangArgs", this.jbangArgs);
        props.put("trusts", this.trusts);
        return props;
    }
}

