/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.announce;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.AbstractAnnouncer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.util.StringUtils;

public final class MastodonAnnouncer
extends AbstractAnnouncer<MastodonAnnouncer, org.jreleaser.model.api.announce.MastodonAnnouncer> {
    private static final long serialVersionUID = 9152609285615015647L;
    private final List<String> statuses = new ArrayList<String>();
    private String host;
    private String accessToken;
    private String status;
    private String statusTemplate;
    @JsonIgnore
    private final org.jreleaser.model.api.announce.MastodonAnnouncer immutable = new org.jreleaser.model.api.announce.MastodonAnnouncer(){
        private static final long serialVersionUID = -8926470689255000598L;

        public String getType() {
            return "mastodon";
        }

        public String getHost() {
            return MastodonAnnouncer.this.host;
        }

        public String getAccessToken() {
            return MastodonAnnouncer.this.accessToken;
        }

        public String getStatus() {
            return MastodonAnnouncer.this.status;
        }

        public List<String> getStatuses() {
            return MastodonAnnouncer.this.statuses;
        }

        public String getStatusTemplate() {
            return MastodonAnnouncer.this.statusTemplate;
        }

        public String getName() {
            return MastodonAnnouncer.this.getName();
        }

        public boolean isSnapshotSupported() {
            return MastodonAnnouncer.this.isSnapshotSupported();
        }

        public Active getActive() {
            return MastodonAnnouncer.this.getActive();
        }

        public boolean isEnabled() {
            return MastodonAnnouncer.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(MastodonAnnouncer.this.asMap(full));
        }

        public String getPrefix() {
            return MastodonAnnouncer.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(MastodonAnnouncer.this.getExtraProperties());
        }

        public Integer getConnectTimeout() {
            return MastodonAnnouncer.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return MastodonAnnouncer.this.getReadTimeout();
        }
    };

    public MastodonAnnouncer() {
        super("mastodon");
    }

    @Override
    public org.jreleaser.model.api.announce.MastodonAnnouncer asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(MastodonAnnouncer source) {
        super.merge(source);
        this.host = this.merge(this.host, source.host);
        this.accessToken = this.merge(this.accessToken, source.accessToken);
        this.status = this.merge(this.status, source.status);
        this.setStatuses(this.merge(this.statuses, source.statuses));
        this.statusTemplate = this.merge(this.statusTemplate, source.statusTemplate);
    }

    public String getResolvedStatusTemplate(JReleaserContext context, TemplateContext extraProps) {
        TemplateContext props = context.fullProps();
        context.getChangelog().apply(props);
        MustacheUtils.applyTemplates((JReleaserLogger)context.getLogger(), (TemplateContext)props, this.resolvedExtraProperties());
        props.set("tagName", (Object)context.getModel().getRelease().getReleaser().getEffectiveTagName(context));
        props.set("previousTagName", (Object)context.getModel().getRelease().getReleaser().getResolvedPreviousTagName(context));
        props.setAll(extraProps);
        Path templatePath = context.getBasedir().resolve(this.statusTemplate);
        try {
            BufferedReader reader = Files.newBufferedReader(templatePath);
            return MustacheUtils.applyTemplate((JReleaserLogger)context.getLogger(), (Reader)reader, (TemplateContext)props);
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_reading_template", (Object[])new Object[]{context.relativizeToBasedir(templatePath)}));
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<String> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<String> statuses) {
        this.statuses.clear();
        this.statuses.addAll(statuses);
    }

    public String getStatusTemplate() {
        return this.statusTemplate;
    }

    public void setStatusTemplate(String statusTemplate) {
        this.statusTemplate = statusTemplate;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("host", this.host);
        props.put("accessToken", StringUtils.isNotBlank((String)this.accessToken) ? "************" : "**unset**");
        props.put("status", this.status);
        props.put("statuses", this.statuses);
        props.put("statusTemplate", this.statusTemplate);
    }
}

