/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.sdkman;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.sdk.sdkman.AbstractSdkmanCommand;
import org.jreleaser.sdk.sdkman.SdkmanException;
import org.jreleaser.util.StringUtils;

public class MajorReleaseSdkmanCommand
extends AbstractSdkmanCommand {
    private final boolean skipAnnounce;
    private final String hashtag;
    private final String releaseNotesUrl;
    private final Map<String, String> platforms = new LinkedHashMap<String, String>();

    private MajorReleaseSdkmanCommand(JReleaserContext context, String apiHost, int connectTimeout, int readTimeout, String consumerKey, String consumerToken, String candidate, String version, boolean dryrun, boolean skipAnnounce, String hashtag, String releaseNotesUrl, Map<String, String> platforms) {
        super(context, apiHost, connectTimeout, readTimeout, consumerKey, consumerToken, candidate, version, dryrun);
        this.hashtag = hashtag;
        this.skipAnnounce = skipAnnounce;
        this.releaseNotesUrl = releaseNotesUrl;
        this.platforms.putAll(platforms);
    }

    @Override
    public void execute() throws SdkmanException {
        this.sdkman.majorRelease(this.candidate, this.version, this.platforms, this.hashtag, this.releaseNotesUrl, this.skipAnnounce);
    }

    public static Builder builder(JReleaserContext context) {
        return new Builder(context);
    }

    public static class Builder
    extends AbstractSdkmanCommand.Builder<Builder> {
        private final Map<String, String> platforms = new LinkedHashMap<String, String>();
        private String hashtag;
        private String releaseNotesUrl;
        private String url;

        protected Builder(JReleaserContext context) {
            super(context);
        }

        public Builder hashtag(String hashtag) {
            this.hashtag = hashtag;
            return this;
        }

        public Builder releaseNotesUrl(String releaseNotesUrl) {
            this.releaseNotesUrl = releaseNotesUrl;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder platforms(Map<String, String> platforms) {
            this.platforms.putAll(platforms);
            return this;
        }

        public Builder platform(String platform, String url) {
            this.platforms.put(StringUtils.requireNonBlank((String)platform, (String)"'platform' must not be blank").trim(), StringUtils.requireNonBlank((String)url, (String)"'url' must not be blank").trim());
            return this;
        }

        public MajorReleaseSdkmanCommand build() {
            StringUtils.requireNonBlank((String)this.apiHost, (String)"'apiHost' must not be blank");
            StringUtils.requireNonBlank((String)this.consumerKey, (String)"'consumerKey' must not be blank");
            StringUtils.requireNonBlank((String)this.consumerToken, (String)"'consumerToken' must not be blank");
            StringUtils.requireNonBlank((String)this.candidate, (String)"'candidate' must not be blank");
            StringUtils.requireNonBlank((String)this.version, (String)"'version' must not be blank");
            if (this.platforms.isEmpty() && StringUtils.isBlank((String)this.url)) {
                throw new IllegalArgumentException("Missing url");
            }
            if (StringUtils.isNotBlank((String)this.url)) {
                this.platforms.put("UNIVERSAL", this.url);
            }
            return new MajorReleaseSdkmanCommand(this.context, this.apiHost, this.connectTimeout, this.readTimeout, this.consumerKey, this.consumerToken, this.candidate, this.version, this.dryrun, this.skipAnnounce, this.hashtag, this.releaseNotesUrl, this.platforms);
        }
    }
}

