/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.command.CommandExecutor;
import org.jreleaser.sdk.tool.ToolException;
import org.jreleaser.util.FileUtils;
import org.jreleaser.util.StringUtils;

public class DownloadableTool {
    private static final String BASE_TEMPLATE_PREFIX = "META-INF/jreleaser/tools/";
    private static final String K_DOWNLOAD_URL = "download.url";
    private static final String K_VERSION = "version";
    private static final String K_EXECUTABLE = ".executable";
    private static final String K_FILENAME = ".filename";
    private static final String K_COMMAND_VERSION = "command.version";
    private static final String K_COMMAND_VERIFY = "command.verify";
    private static final String K_EXECUTABLE_PATH = ".executable.path";
    private static final String UNPACK = "unpack";
    private final JReleaserLogger logger;
    private final String name;
    private final String version;
    private final String platform;
    private final boolean enabled;
    private final Properties properties;
    private final boolean verifyErrorOutput;
    private Path executable;

    public DownloadableTool(JReleaserLogger logger, String name, String version, String platform, boolean verifyErrorOutput) throws ToolException {
        this.logger = logger;
        this.name = name;
        this.version = version;
        this.platform = platform;
        this.verifyErrorOutput = verifyErrorOutput;
        String key = name + ".properties";
        try {
            this.properties = new Properties();
            this.properties.load(DownloadableTool.class.getClassLoader().getResourceAsStream(BASE_TEMPLATE_PREFIX + key));
            this.enabled = this.properties.containsKey(this.platformKey(K_EXECUTABLE));
            if (this.enabled) {
                this.executable = Paths.get(this.properties.getProperty(this.platformKey(K_EXECUTABLE)), new String[0]);
            }
        }
        catch (Exception e) {
            throw new ToolException(RB.$((String)"ERROR_unexpected_reading_resource_for", (Object[])new Object[]{key, "classpath"}));
        }
    }

    private String platformKey(String key) {
        String k = this.platform + key;
        if (this.properties.containsKey(k)) {
            return k;
        }
        return key.startsWith(".") ? key.substring(1) : key;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Path getExecutable() {
        return this.executable;
    }

    public boolean verify() {
        if (null != this.executable) {
            return this.verify(this.executable);
        }
        return false;
    }

    private boolean verify(Path executable) {
        Command command = new Command(executable.toString()).arg(this.properties.getProperty(K_COMMAND_VERSION));
        try {
            String verify = this.properties.getProperty(K_COMMAND_VERIFY).trim();
            TemplateContext props = this.props();
            verify = Templates.resolveTemplate((String)verify, (TemplateContext)props);
            Pattern pattern = Pattern.compile(verify);
            Command.Result result = this.executeCommand(command);
            if (result.getExitValue() != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{result.getExitValue()}));
            }
            if (this.verifyErrorOutput) {
                return pattern.matcher(result.getOut()).find() || pattern.matcher(result.getErr()).find();
            }
            return pattern.matcher(result.getOut()).find();
        }
        catch (CommandException e) {
            if (null != e.getCause()) {
                this.logger.debug(e.getCause().getMessage());
            } else {
                this.logger.debug(e.getMessage());
            }
            return false;
        }
    }

    public void download() throws ToolException {
        String filename = this.properties.getProperty(this.platformKey(K_FILENAME));
        if (StringUtils.isBlank((String)filename)) {
            this.executable = null;
            return;
        }
        Path caches = this.resolveJReleaserCacheDir();
        Path dest = caches.resolve(this.name).resolve(this.version);
        boolean unpack = Boolean.parseBoolean(this.properties.getProperty(UNPACK));
        String downloadUrl = this.properties.getProperty(K_DOWNLOAD_URL);
        String executablePath = this.properties.getProperty(this.platformKey(K_EXECUTABLE_PATH));
        String exec = this.properties.getProperty(this.platformKey(K_EXECUTABLE));
        TemplateContext props = this.props();
        filename = Templates.resolveTemplate((String)filename, (TemplateContext)props);
        if (StringUtils.isNotBlank((String)executablePath)) {
            executablePath = Templates.resolveTemplate((String)executablePath, (TemplateContext)props);
        }
        Path test = dest;
        if (unpack && StringUtils.isNotBlank((String)executablePath)) {
            test = dest.resolve(executablePath);
        }
        if (Files.exists(test = test.resolve(exec).toAbsolutePath(), new LinkOption[0])) {
            this.executable = test;
            this.logger.debug(RB.$((String)"tool.cached", (Object[])new Object[]{this.executable}));
            return;
        }
        downloadUrl = Templates.resolveTemplate((String)downloadUrl, (TemplateContext)props) + filename;
        try (InputStream stream = new URI(downloadUrl).toURL().openStream();){
            Path tmp = Files.createTempDirectory("jreleaser", new FileAttribute[0]);
            Path destination = tmp.resolve(filename);
            this.logger.debug(RB.$((String)"tool.located", (Object[])new Object[]{filename}));
            this.logger.debug(RB.$((String)"tool.downloading", (Object[])new Object[]{downloadUrl}));
            Files.copy(stream, destination, StandardCopyOption.REPLACE_EXISTING);
            this.logger.debug(RB.$((String)"tool.downloaded", (Object[])new Object[]{filename}));
            Files.createDirectories(dest, new FileAttribute[0]);
            if (unpack) {
                FileUtils.unpackArchive((Path)destination, (Path)dest, (boolean)false);
                this.logger.debug(RB.$((String)"tool.unpacked", (Object[])new Object[]{filename}));
                this.executable = StringUtils.isNotBlank((String)executablePath) ? dest.resolve(executablePath).resolve(exec).toAbsolutePath() : dest.resolve(exec).toAbsolutePath();
            } else {
                Path executableFile = dest.resolve(exec);
                Files.move(destination, executableFile, new CopyOption[0]);
                FileUtils.grantExecutableAccess((Path)executableFile);
                this.executable = executableFile.toAbsolutePath();
            }
            this.logger.debug(RB.$((String)"tool.cached", (Object[])new Object[]{this.executable}));
        }
        catch (FileNotFoundException e) {
            this.logger.debug(RB.$((String)"tool.not.found", (Object[])new Object[]{filename}));
            throw new ToolException(RB.$((String)"tool.not.found", (Object[])new Object[]{filename}), e);
        }
        catch (Exception e) {
            this.logger.debug(RB.$((String)"tool.download.error", (Object[])new Object[]{filename}));
            throw new ToolException(RB.$((String)"tool.download.error", (Object[])new Object[]{filename}), e);
        }
    }

    public Command asCommand() {
        return new Command(this.executable.toString());
    }

    private TemplateContext props() {
        TemplateContext props = new TemplateContext();
        props.set(K_VERSION, (Object)this.version);
        return props;
    }

    private Command.Result executeCommand(Command command) throws CommandException {
        return new CommandExecutor(this.logger, CommandExecutor.Output.DEBUG).executeCommand(command);
    }

    private Path resolveJReleaserCacheDir() {
        String home = System.getenv("XDG_CACHE_HOME");
        if (StringUtils.isNotBlank((String)home)) {
            return Paths.get(home, new String[0]).resolve("jreleaser");
        }
        home = System.getenv("JRELEASER_USER_HOME");
        if (StringUtils.isBlank((String)home)) {
            home = System.getProperty("user.home") + File.separator + ".jreleaser";
        }
        return Paths.get(home, new String[0]).resolve("caches");
    }
}

