# Users

-----

The following is not intended to be a complete enumeration. Be sure to view the [development version](/dev/community/users/) of this page for an up-to-date listing.

## Projects

[aiogram](https://github.com/aiogram/aiogram/blob/a2e5f9a8b8c994ad65bce05cde9c744760f47c4c/pyproject.toml#L1-L3)
| [Apache Airflow](https://github.com/apache/airflow/blob/ba2ba7f49395b528ea67611c423ddd71b64b8ede/pyproject.toml#L18-L39)
| [argon2-cffi](https://github.com/hynek/argon2-cffi/blob/59c7470af1a65b3b71e18fbf9abeca2cca3d707a/pyproject.toml#L3-L5)
| [attrs](https://github.com/python-attrs/attrs/blob/01413df3db8e64437547f7fa6439a646fa116a98/pyproject.toml#L3-L5)
| [Black](https://github.com/psf/black/blob/f22273a72b3f1c15085f2d4a43e8d785bf48c822/pyproject.toml#L28-L30)
| [coffea](https://github.com/CoffeaTeam/coffea/blob/bab41f66869293f8ba630556f21ac093828788b7/pyproject.toml#L1-L3)
| [Colorama](https://github.com/tartley/colorama/blob/cd653d75be52f4d8c3953eb6942fe597375f8b97/pyproject.toml#L1-L5)
| [Django Anymail](https://github.com/anymail/django-anymail/blob/63e355084c057d60bcce41afa1de315b163b6235/pyproject.toml#L1-L3)
| [Django Debug Toolbar](https://github.com/jazzband/django-debug-toolbar/blob/d04b9d1a666fd6427604c92f86f91380597eae14/pyproject.toml#L1-L5)
| [Django NYT](https://github.com/django-wiki/django-nyt/blob/b87107f5fadc2a77941bb15e7dfb95dba3d7f40d/pyproject.toml#L1-L3)
| [Django OTP](https://github.com/django-otp/django-otp/blob/1cb288fceaab66e7921f80c27f40df475c056811/pyproject.toml#L135-L137)
| [Django OTP Agents](https://github.com/django-otp/django-otp-agents/blob/b9cd473bef9153c05c8768f72208229f2a25951d/pyproject.toml#L118-L120)
| [Django OTP Twilio](https://github.com/django-otp/django-otp-twilio/blob/a0c68a829cbffe373605df03f62e093b3f9d4170/pyproject.toml#L118-L120)
| [Django OTP YubiKey](https://github.com/django-otp/django-otp-yubikey/blob/fbd121dfb0f4890745df10ce2fb129e2b588da24/pyproject.toml#L118-L120)
| [Django Places](https://github.com/oscarmcm/django-places/blob/76630ccc1a45380d40cca1262fa4f9a269cf5112/pyproject.toml#L1-L3)
| [Django Wiki](https://github.com/django-wiki/django-wiki/blob/1b03661c3fe7260b0eb82565cc3812b96de6b674/pyproject.toml#L1-L3)
| [FastAPI](https://github.com/tiangolo/fastapi/blob/1073062c7f2c48bcc28bcedbdc009c18c171f6fb/pyproject.toml#L1-L3)
| [filelock](https://github.com/tox-dev/filelock/blob/c06aa983616804c349007c7a536c361d0e1a8cff/pyproject.toml#L1-L6)
| [Fluentd](https://github.com/fluent/fluent-logger-python/blob/1e58a7e8b62b435d42f80f7b8ca264012925edce/pyproject.toml#L1-L3)
| [github3.py](https://github.com/sigmavirus24/github3.py/blob/94541f8adee67e39f3061c6b29db3e39cef5ce05/pyproject.toml#L1-L3)
| [Gradio](https://github.com/gradio-app/gradio/blob/f43481c18ac6468fbf30bf9a80981b7eab453961/pyproject.toml#L1-L3)
| [HTTPX](https://github.com/encode/httpx/blob/45b7cfaad3a8987ea35fa5bf092bbdda485444fd/pyproject.toml#L1-L3)
| [iCalendar for Humans](https://github.com/ics-py/ics-py/blob/133a0955f6efbb83ff0eae45ad0bbe6902a8f2f1/pyproject.toml#L61-L63)
| [LinkChecker](https://github.com/linkchecker/linkchecker/blob/de40321b57a2271e90e696b5320c0409faaa895d/pyproject.toml#L29-L34)
| [Litestar](https://github.com/litestar-org/litestar/blob/f9e3f727e8ae71e4b58a518240fb6c66e83c10de/pyproject.toml#L181-L183)
| [Material for MkDocs](https://github.com/squidfunk/mkdocs-material/blob/7ca1c1d623b4750d4aaa0cfd673b0ed2c6050c2b/pyproject.toml#L21-L23)
| [MicroPython](https://github.com/micropython/micropython/blob/30a9ccf4caa72c62cb8656a1572518fef34b08a4/tools/mpremote/pyproject.toml#L1-L7)
| [MkDocs](https://github.com/mkdocs/mkdocs/blob/65c24c21f0057ec4717d20d14d5fb7af22fe8caf/pyproject.toml#L1-L3)
| [openSUSE](https://github.com/openSUSE/py2pack/blob/25be8cdb53ee6966213474e3399fe451f33993f6/pyproject.toml#L1-L3)
| [Nox](https://github.com/wntrblm/nox/blob/cc710bde9d6a8781833144bac02a5f4581d9eca7/pyproject.toml#L1-L5)
| [Packit](https://github.com/packit/packit/blob/6e286a7b4d0f79cd2a8213a8ae978788be5219c5/pyproject.toml#L1-L3)
| [pipx](https://github.com/pypa/pipx/blob/bc7dd03c4d872c443257685109a650ec3d524814/pyproject.toml#L1-L3)
| [platformdirs](https://github.com/platformdirs/platformdirs/blob/382e961c436f9974e56dc69ce105b6fd8945c343/pyproject.toml#L1-L3)
| [Pydantic](https://github.com/pydantic/pydantic/blob/f341049b9e5538a125751d75b4e44c1609b53df6/pyproject.toml#L1-L3)
| [Pygments](https://github.com/pygments/pygments/blob/0f3ddb3a6e3ed99957fe20aab695446f85835387/pyproject.toml#L1-L3)
| [PyHamcrest](https://github.com/hamcrest/PyHamcrest/blob/07a787207619a7f7d51088d36051a632432a0144/pyproject.toml#L1-L3)
| [PyMdown Extensions](https://github.com/facelessuser/pymdown-extensions/blob/72390ce2d0b40df638e31b75f1f02f45659724de/pyproject.toml#L1-L5)
| [Python JSON Schema](https://github.com/python-jsonschema/jsonschema/blob/afc22f09e74d696ab00be8a711bbc5c2a15327b7/pyproject.toml#L1-L3)
| [Rye](https://github.com/mitsuhiko/rye/blob/92b571bfd42e5748d2e535174d78fc7311a889a3/pyproject.toml#L20-L22)
| [SALib](https://github.com/SALib/SALib/blob/7490a686e959b436f7db9bc9cf6fa4b2e7bfa3fc/pyproject.toml#L1-L3)
| [Spack](https://github.com/spack/spack/blob/7a5e527cab5980cb4732bb3504fab77d75286a19/pyproject.toml#L36-L38)
| [Starlette](https://github.com/encode/starlette/blob/31164e346b9bd1ce17d968e1301c3bb2c23bb418/pyproject.toml#L1-L3)
| [structlog](https://github.com/hynek/structlog/blob/6e2e8c6025fb90484c5e6c5ff2fd3e96a61854cf/pyproject.toml#L3-L5)
| [tox](https://github.com/tox-dev/tox/blob/f2b4a4a6f5e8bbc8f9f0cff3dd5d17c50e874172/pyproject.toml#L1-L3)
| [Twisted](https://github.com/twisted/twisted/blob/960e26bb1f4c67b3f7819553d0c45b25e6db4aae/pyproject.toml#L1-L7)
| [urllib3](https://github.com/urllib3/urllib3/blob/8dda1974ae51839304f8517ab7993006c0d9db2e/pyproject.toml#L3-L5)
| [Uvicorn](https://github.com/encode/uvicorn/blob/ccd1aae48e49dd8c9365600fd79e886efe88be1d/pyproject.toml#L1-L3)
| [virtualenv](https://github.com/pypa/virtualenv/blob/69664d522d98899c21dcf0e88a0af3efcb0c71e7/pyproject.toml#L1-L6)
| [Voilà](https://github.com/voila-dashboards/voila/blob/71292e4124b1f4a6f91c8b4e16ea9ad6b5ef500b/pyproject.toml#L1-L7)
| [XGBoost](https://github.com/dmlc/xgboost/blob/62571b79eb08398a031873c3704da4e9cfd2c301/python-package/pyproject.toml#L1-L6)
| [Ypy](https://github.com/y-crdt/ypy/tree/b9241a9e7ca248b6c44b62707d719b1ef20eef74#using-hatch)
| [yt-dlp](https://github.com/yt-dlp/yt-dlp/blob/111b61ddef305584d45a48e7b7c73ffcedf062a2/pyproject.toml#L1-L3)

## Industry

- [Anaconda](https://www.anaconda.com) <sup>\[[1](https://github.com/ContinuumIO/dask-awkward/blob/105275b1937cce9a80a352af0b200d4e264f27f7/pyproject.toml#L1-L3)|[2](https://github.com/conda-incubator/ensureconda/blob/b20dbcf7166009ff4e9270f35ed75da7afc3db60/pyproject.toml#L1-L3)|[3](https://github.com/conda-incubator/conda-lock/blob/9187487698f9afbb08e131cd585a17bba82ce9f2/pyproject.toml#L1-L3)|[4](https://github.com/conda-incubator/conda-auth/blob/437ca609ea8bf4b8bd91d32dd427abe8294f6a3b/pyproject.toml#L1-L3)|[5](https://github.com/conda/conda-content-trust/blob/f72a50b04126177f37b965c25d02564223b7acf8/pyproject.toml#L1-L6)|[6](https://github.com/conda/conda-build/blob/37ab8d3de084d32b907b726ba2ad4570e91d326b/pyproject.toml#L1-L6)|[7](https://github.com/conda/conda/blob/0c38f5660f7eca66434827af910beddf9f7e462d/pyproject.toml#L1-L6)\]</sup>
- [Airbnb](https://www.airbnb.com) <sup>\[[1](https://github.com/airbnb/omniduct/blob/98c66e10b493c83d42f69bc6b97fab7a8c91eab1/pyproject.toml#L1-L3)\]</sup>
- [Astronomer](https://www.astronomer.io) <sup>\[[1](https://github.com/astronomer/astronomer-cosmos/blob/29886492a46cf1dccd4c17a1643010975cb8094a/pyproject.toml#L1-L3)|[2](https://github.com/astronomer/astro-provider-databricks/blob/3e1ca039a024a98f9079d178478aa24702e15453/pyproject.toml#L1-L3)|[3](https://github.com/astronomer/astro-providers-template/blob/5be542eb5763f3d9accc7d6d7bc35c9214d15904/pyproject.toml#L1-L3)\]</sup>
- [Bitwarden](https://bitwarden.com) <sup>\[[1](https://github.com/bitwarden/gh-actions/blob/c3bc6a192283618c6ae92f33bde7c2f28e198539/lint-workflow-v2/pyproject.toml#L1-L3)\]</sup>
- [Bloomberg](https://www.bloomberg.com) <sup>\[[1](https://github.com/bloomberg/ipydatagrid/blob/04b73fe67bf33d054e69036fe2794ac72057b105/pyproject.toml#L1-L6)|[2](https://github.com/bloomberg/pytest-memray/blob/4ea6a7608adb0de4572d35768fbd370aee016627/pyproject.toml#L1-L3)\]</sup>
- [Blue Robotics](https://bluerobotics.com) <sup>\[[1](https://github.com/bluerobotics/navigator-lib/blob/1d8afadb0804ffbbf32147232b1c627e92786c07/pyproject.toml#L26-L38)\]</sup>
- [Cars.com](https://www.cars.com) <sup>\[[1](https://github.com/carsdotcom/cars-forge/blob/ba14db991a5c7cb3c5adc3a4a364121e43f6aa0e/pyproject.toml#L63-L65)\]</sup>
- [Cisco](https://www.cisco.com) <sup>\[[1](https://github.com/CiscoDevNet/sastre/blob/76da836c9df01f1d3d40df5475c0d2caff4db566/pyproject.toml#L1-L3)|[2](https://github.com/CiscoDevNet/sdwan-devops/blob/bb6dde778af881be257fab722b12196599f63ddf/sdwan_config_builder/pyproject.toml#L1-L3)\]</sup>
- [Databricks](https://www.databricks.com) <sup>\[[1](https://github.com/databrickslabs/ucx/blob/80145a4f2b6dccf65c1ad048fdb4d1e2622afa09/pyproject.toml#L1-L3)|[2](https://github.com/databricks-industry-solutions/many-model-forecasting/blob/a9e347b0444354bf836a8f528e4deb547e7bdd05/pyproject.toml#L35-L37)|[3](https://github.com/databrickslabs/pylint-plugin/blob/3b33c79dea74bdaac011488e16ad0121db4150b1/pyproject.toml#L34-L36)\]</sup>
- [Datadog](https://www.datadoghq.com) <sup>\[[1](https://github.com/DataDog/datadogpy/blob/63d0c01b5bbcb8158cf3ddab153639951ab44945/pyproject.toml#L1-L3)|[2](https://github.com/DataDog/integrations-core/pulls?q=is%3Apr+author%3Aofek+in%3Atitle+Add+pyproject.toml+file)|[3](https://github.com/DataDog/integrations-extras/pulls?q=is%3Apr+author%3Aofek+in%3Atitle+Add+pyproject.toml+file)|[4](https://github.com/DataDog/mkdocs-click/blob/434925323f3bb187595d4c7f6a2c80b790015109/pyproject.toml#L1-L3)\]</sup>
- [deepset](https://www.deepset.ai) <sup>\[[1](https://github.com/deepset-ai/haystack/blob/728383a14968111b0a032480ac276d6e3313332b/pyproject.toml#L1-L5)|[2](https://github.com/deepset-ai/deepset-cloud-sdk/blob/18c76d4b7a3863040fac0d9e6f47c765f266d7fa/pyproject.toml#L1-L3)\]</sup>
- [Elastic](https://www.elastic.co) <sup>\[[1](https://github.com/elastic/rally/blob/8ba7980bb25b85f25fe20f3fd5dd8e12b9b1214b/pyproject.toml#L1-L3)|[2](https://github.com/elastic/rally-tracks/blob/33840005cd3e2a6191d73a567e5c2c0858169270/pyproject.toml#L1-L3)|[3](https://github.com/elastic/curator/blob/b41743a061ad790820affe7acee5f71abe819357/pyproject.toml#L1-L3)\]</sup>
- [Google](https://about.google) <sup>\[[1](https://github.com/google/latexify_py/blob/9307e6e70df0d0a5f7d524833a85e2c25ffe66ef/pyproject.toml#L1-L5)|[2](https://github.com/google/gcp_scanner/blob/93dc594a6d920d1aff9bc8fef780a32056c12e27/pyproject.toml#L1-L3)|[3](https://github.com/GoogleCloudPlatform/cloud-build-samples/blob/a66407bc412a2726781f30063923a49bb6789064/python-example-noncontainer-artifacts/pyproject.toml#L1-L3)|[4](https://github.com/google/visualblocks/blob/3809f598253cdad2d93ed82b1e2623c10b4a5a0b/python/pyproject.toml#L1-L3)|[5](https://github.com/google/jaxtyping/blob/1acc0d7153f3881870b0376496d8efa27689cb3b/pyproject.toml#L29-L31)|[6](https://github.com/GoogleCloudPlatform/database-assessment/blob/d14d587cb2cab55cc0b1b92d79d0b30f12807b42/pyproject.toml#L126-L128)\]</sup>
- [IBM](https://www.ibm.com) <sup>\[[1](https://github.com/IBM/python-log-router/blob/b0fc624cde262c6faadd5cb2e780e1ed7847f6c2/pyproject.toml#L1-L3)\]</sup>
- [JPMorgan Chase](https://www.jpmorganchase.com) <sup>\[[1](https://github.com/jpmorganchase/jupyter-fs/blob/e7ea3ced16e8f7f1297ac8bed3f028b641558256/pyproject.toml#L1-L7)\]</sup>
- [Intel Corporation](https://www.intel.com) <sup>\[[1](https://github.com/intel/neural-compressor/blob/5f6f38b96d45d0253b8de239df51c09b2471a8fb/neural_coder/extensions/neurl_compressor_ext_lab_alibaba/pyproject.toml#L1-L3)|[2](https://github.com/intel/tdx-tools/blob/ba4ba1796f21388d15cb14ecf673747c303ea0ae/utils/ovmfkeyenroll/pyproject.toml#L1-L3)|[3](https://github.com/intel/open-domain-question-and-answer/blob/6d8e90acb738ea3fe33d400c549c45ee05461afc/pyproject.toml#L1-L5)\]</sup>
- [McKinsey](https://www.mckinsey.com) <sup>\[[1](https://github.com/mckinsey/vizro/blob/a7e88f19b7f50df19f9e0981ae19b36ccd83bc52/vizro-core/pyproject.toml#L1-L3)|[2](https://github.com/mckinsey/vizro/blob/a7e88f19b7f50df19f9e0981ae19b36ccd83bc52/vizro-ai/pyproject.toml#L1-L3)\]</sup>
- [Meta](https://about.facebook.com) <sup>\[[1](https://github.com/facebook/usort/blob/b3d1dc49abac0c06ac29f1ceb332d2b86a50e850/pyproject.toml#L1-L3)|[2](https://github.com/Instagram/Fixit/blob/c95b0ef9f8c02adfd6a541b55f22f0bd6a922706/pyproject.toml#L1-L3)|[3](https://github.com/meta-llama/llama-recipes/blob/44b66374bec23ad77c00af4348197e6641a8d2e3/pyproject.toml#L1-L3)\]</sup>
- [Microsoft](https://www.microsoft.com) <sup>\[[1](https://github.com/microsoft/qsharp/blob/2ef271eea86f6cc4dff3c79526aaa79422489fcd/jupyterlab/pyproject.toml#L1-L3)|[2](https://github.com/microsoft/responsible-ai-toolbox-tracker/blob/4e37f81726ba7ccf76d0539a5edc3ba6a988c3a5/pyproject.toml#L1-L7)|[3](https://github.com/microsoft/CoML/blob/9a4d670c3f7ff7710556b8d75e502824f74664ce/pyproject.toml#L1-L3)|[4](https://github.com/microsoft/microxcaling/blob/142efb98622df68e4a4c01ca77d2fc02dfdec261/pyproject.toml#L18-L20)|[5](https://github.com/microsoft/sca-fuzzer/blob/c0d42786e06115daf8281e40e5475e8e69f6b10e/pyproject.toml#L1-L3)|[6](https://github.com/microsoft/TypeChat/blob/f53b971179d0136424a75d67287903a2421af98b/python/pyproject.toml#L1-L3)\]</sup>
- [OpenAI](https://openai.com) <sup>\[[1](https://github.com/openai/openai-python/blob/e36956673d9049713c91bca6ce7aebe58638f483/pyproject.toml#L88-L90)\]</sup>
- [Oracle](https://www.oracle.com) <sup>\[[1](https://github.com/oracle/graalpython/blob/9b41424fd80727614878b5903f9d8ae0447bfd4e/graalpy_virtualenv/pyproject.toml#L40-L42)\]</sup>
- [Palo Alto Networks](https://www.paloaltonetworks.com) <sup>\[[1](https://github.com/PaloAltoNetworks/pc-python-integration/blob/a3e29d71c6704dfb07cf85d592dec15a9ea575b7/pyproject.toml#L1-L3)\]</sup>
- [Quansight](https://quansight.com) <sup>\[[1](https://github.com/Quansight-Labs/jupyter-a11y-testing/blob/f36bf5b2e8cb87613c637fc5aa03401c92ec58d0/pyproject.toml#L3-L6)\]</sup>
- [Red Hat](https://www.redhat.com) <sup>\[[1](https://github.com/RedHatQE/wrapanapi/blob/036f85a7fa97b86eee732804f61cfe574c571a6e/pyproject.toml#L1-L3)|[2](https://github.com/RedHatQE/widgetastic.core/blob/c40d7f50f3e55c9ac9f0da1b91a56f89949bbe0c/pyproject.toml#L52-L54)|[3](https://github.com/RedHatQE/widgetastic.patternfly4/blob/5b19fcdc123732639edc8cf715dbe5fc64f3bd28/pyproject.toml#L38-L40)|[4](https://github.com/redhat-developer/devspaces-images/blob/db8de2f54466e37986ce64d96436b566c75b0677/devspaces-udi/build/python/requirements-build.in#L12)|[5](https://github.com/RedHatQE/Sentaku/blob/19dc91c00b70cb2054e0c28d69906e894fa8c104/pyproject.toml#L1-L6)\]</sup>
- [Salesforce](https://www.salesforce.com) <sup>\[[1](https://github.com/SalesforceAIResearch/uni2ts/blob/ce27c2f9a0c6ee9119997e8ef0026388f143dcd6/pyproject.toml#L1-L3)\]</sup>
- [Snowflake](https://www.snowflake.com) <sup>\[[1](https://github.com/Snowflake-Labs/snowcli/blob/a8cafe80ef81969655a4391425b0f45c2874d1a4/pyproject.toml#L1-L3)\]</sup>
- [Splunk](https://www.splunk.com) <sup>\[[1](https://github.com/splunk/splunk-mltk-container-docker/blob/e13ae55a4a16ea459092ee9c1e9ba9772cbe6bf2/package-dsdlsupport/pyproject.toml#L1-L3)\]</sup>
- [The Westervelt Company](https://westervelt.com) <sup>\[[1](https://github.com/westerveltco/django-twc-project/blob/f20768d4d42761ec0ce44f3f2283b66e47f2c8f8/pyproject.toml#L1-L3)|[2](https://github.com/westerveltco/django-email-relay/blob/e576c0561408f3c27babc9035b7284fd580a69c2/pyproject.toml#L1-L3)|[3](https://github.com/westerveltco/django-simple-nav/blob/4c0dfd5ee4bfa28fd6696e1394e6bbe2e119bfcc/pyproject.toml#L1-L3)|[4](https://github.com/westerveltco/django-q-registry/blob/59ae52978a8d900b05a50465f40e2834a16f4303/pyproject.toml#L1-L3)|[5](https://github.com/westerveltco/wagtail-heroicons/blob/a8b8985ec3994156b85c07a440a30c8ad2f21263/pyproject.toml#L1-L3)|[6](https://github.com/westerveltco/django-opfield/blob/7818ce3cdc56d25807cd5bc8f613eb12de2c6177/pyproject.toml#L1-L3)\]</sup>
- [Virtru](https://www.virtru.com) <sup>\[[1](https://github.com/virtru/access-pdp/blob/46089e8a2ef691b80f92bbd6777bdfbcff1c1671/clients/python/accesspdp/pyproject.toml#L24-L26)|[2](https://github.com/virtru/access-pdp/blob/46089e8a2ef691b80f92bbd6777bdfbcff1c1671/clients/python/attributes/pyproject.toml#L21-L23)\]</sup>
- [VMware](https://www.vmware.com) <sup>\[[1](https://github.com/vmware/versatile-data-kit/blob/f77faec3e9ccd840b6dc6fdc95af8a434e822e71/projects/vdk-plugins/vdk-jupyter/vdk-jupyterlab-extension/pyproject.toml#L1-L3)|[2](https://github.com/vmware/repository-service-tuf-cli/blob/374f1ac0c2a4ada6d7a7c26fba55e811f2998be8/pyproject.toml#L1-L4)|[3](https://github.com/vmware/vhpc-toolkit/blob/b8429bc4753caa302a4fc8bb160cca89e84cfd45/pyproject.toml#L20-L22)\]</sup>
- [Volvo Group](https://www.volvogroup.com) <sup>\[[1](https://github.com/VolvoGroup/dymoval/blob/75261b85635dce594719b01c5fc33ad951ce55b0/pyproject.toml#L1-L3)\]</sup>

## Organizations

- [Free Ebook Foundation](https://ebookfoundation.org) <sup>\[[1](https://github.com/EbookFoundation/alt-text/blob/00433b1a971309a441ef4822322cc6ea6347d9b2/pyproject.toml#L1-L3)\]</sup>
- [Greater Paris University Hospitals (AP-HP)](https://www.aphp.fr) <sup>\[[1](https://github.com/aphp/edspdf/blob/ec083ed7fedddbdbb398c6feee530e05273f7dbb/pyproject.toml#L195-L197)\]</sup>
- [Massachusetts General Hospital](https://www.massgeneral.org) <sup>\[[1](https://github.com/pinellolab/DNA-Diffusion/blob/6530de4ae4e0ff95f6e0852cd0d77ee763fb8833/pyproject.toml#L1-L3)\]</sup>
- [Let's Encrypt](https://letsencrypt.org) <sup>\[[1](https://github.com/letsencrypt/mariadb-sequential-partition-manager-py/blob/666de864bcd3e17001513cd14f8919b01be7dd58/pyproject.toml#L1-L3)\]</sup>
- [Max Planck Society](https://www.mpg.de/en) <sup>\[[1](https://github.com/center-for-humans-and-machines/transformer-heads/blob/0a362a6654a9a0e357d759700c08991017b39fec/pyproject.toml#L1-L3)\]</sup>
- [OpenTelemetry](https://opentelemetry.io) <sup>\[[1](https://github.com/open-telemetry/opentelemetry-python/issues/2884#issuecomment-1229539511)|[2](https://github.com/open-telemetry/opentelemetry-python-contrib/issues/1259#issuecomment-1235028860)\]</sup>
- [Smithsonian Institution](https://www.si.edu) <sup>\[[1](https://github.com/Smithsonian/ngehtutil/blob/02921f3a2ce11eb3f1555a0b9d3b177592d2be37/pyproject.toml#L1-L3)\]</sup>
- [The New York Public Library](https://www.nypl.org) <sup>\[[1](https://github.com/NYPL/python-utils/blob/79b6d1b98d35b318af23c2af2f4f25e2c8162b15/pyproject.toml#L1-L3)\]</sup>

## Government

- [European Molecular Biology Laboratory](https://www.embl.org)
    - [European Bioinformatics Institute](https://www.ebi.ac.uk) <sup>\[[1](https://github.com/MarioniLab/oor_benchmark/blob/9117c354bb780b3cb5a73a30e68aa26fc68efdb5/pyproject.toml#L1-L3)\]</sup>
- [Germany](https://en.wikipedia.org/wiki/Germany)
    - [Berlin Institute of Health](https://www.bihealth.org/en/) <sup>\[[1](https://github.com/BIH-CEI/napkon-string-matching/blob/48d0d0ade9f1f173df9a2881a71412bbe73a006b/pyproject.toml#L25-L27)\]</sup>
    - [Helmholtz Munich](https://www.helmholtz-munich.de/en) <sup>\[[1](https://github.com/theislab/moscot/blob/545d8ac7c6a648931699cddaa757ea47b63d9b5e/pyproject.toml#L1-L3)|[2](https://github.com/theislab/multigrate/blob/1974d5901d2894573acd823c3d4d3c4ba23aba7a/pyproject.toml#L1-L3)\]</sup>
- [Norway](https://en.wikipedia.org/wiki/Norway)
    - [Statistics Norway](https://www.ssb.no/en/) <sup>\[[1](https://github.com/statisticsnorway/dapla-hurtigstart-jupyter-extension/blob/96ac7441c46ed92684a8850df5cc72be15446289/pyproject.toml#L1-L3)\]</sup>
- [United Kingdom](https://en.wikipedia.org/wiki/United_Kingdom)
    - [The Alan Turing Institute](https://www.turing.ac.uk) <sup>\[[1](https://github.com/alan-turing-institute/bureau/blob/6ed1882eaeb2410814549c4ffc2c1860c1acf7ca/build/pyproject.toml#L1-L3)\]</sup>
    - [Department for Business and Trade](https://www.gov.uk/government/organisations/department-for-business-and-trade) <sup>\[[1](https://github.com/uktrade/mirror-git-to-s3/blob/ce38c7c689f5dba1f3c9de4e10b8889afc8e44b7/pyproject.toml#L1-L3)\]</sup>
    - [The National Archives](https://www.nationalarchives.gov.uk) <sup>\[[1](https://github.com/nationalarchives/da-ayr-webapp/blob/1e62d38c0fe14f7d391835c704ba715241affcdb/pyproject.toml#L1-L3)\]</sup>
- [United States](https://en.wikipedia.org/wiki/United_States)
    - [NASA](https://www.nasa.gov) <sup>\[[1](https://github.com/spacetelescope/hstaxe/blob/c6a73c8211c3eac71f0aa6eb4125f5be227ae7c4/pyproject.toml#L1-L3)\]</sup>
    - [National Institute of Standards and Technology](https://www.nist.gov) <sup>\[[1](https://github.com/usnistgov/thermoextrap/blob/536bb94b5c08814171dccfe9569d16854a5404bc/pyproject.toml#L1-L7)|[2](https://github.com/usnistgov/labbench/blob/fc5762fc155b8eb30ba32b487b5244ed6ff78739/pyproject.toml#L99-L101)|[3](https://github.com/NERSC/sfapi_client/blob/685c4988501cd10ec3cb495368e2839d3b648124/pyproject.toml#L1-L3)|[4](https://github.com/usnistgov/cmomy/blob/1689a97c65d00fc6d48221e128b789839c56b034/pyproject.toml#L1-L7)|[5](https://github.com/usnistgov/tmmc-lnpy/blob/ee6e16e21aef5824352f214042ed52ba252bd588/pyproject.toml#L1-L7)\]</sup>
    - [National Security Agency](https://www.nsa.gov) <sup>\[[1](https://github.com/NationalSecurityAgency/ghidra/blob/6242fda158fed6c7dbbd6928a4a74371a212c373/Ghidra/Debug/Debugger-agent-lldb/src/main/py/pyproject.toml#L1-L3)|[2](https://github.com/NationalSecurityAgency/ghidra/blob/6242fda158fed6c7dbbd6928a4a74371a212c373/Ghidra/Debug/Debugger-agent-gdb/src/main/py/pyproject.toml#L1-L3)\]</sup>
    - [National Telecommunications and Information Administration](https://www.ntia.gov) <sup>\[[1](https://github.com/NTIA/scos-tekrsa/blob/73090a737fdc0bd3a6c7c08deb170e00018d9ceb/pyproject.toml#L1-L3)|[2](https://github.com/NTIA/scos-actions/blob/a388aa46d414c7b5e67f76f8982bff2f534014f7/pyproject.toml#L1-L3)|[3](https://github.com/NTIA/tekrsa-api-wrap/blob/edce621075f053809c1640c6197c46bbc6456a10/pyproject.toml#L1-L3)|[4](https://github.com/NTIA/Preselector/pull/10)\]</sup>

## Academia

- [Brown University](https://www.brown.edu)
    - [Carney Institute for Brain Science](https://www.brown.edu/carney/) <sup>\[[1](https://github.com/AutoResearch/sourpea/blob/f3007a58d3e5a647ccfb37fee24e44468d5ec707/pyproject.toml#L1-L3)\]</sup>
- [Carnegie Mellon University](https://www.cmu.edu)
    - [Department of Chemical Engineering](https://www.cheme.engineering.cmu.edu/) <sup>\[[1](https://github.com/FAIR-Chem/fairchem/blob/e344dc83f9e295c4be3830118302daf96e8a9b78/packages/fairchem-core/pyproject.toml#L1-L3)|[2](https://github.com/FAIR-Chem/fairchem/blob/e344dc83f9e295c4be3830118302daf96e8a9b78/packages/fairchem-data-oc/pyproject.toml#L1-L3)|[3](https://github.com/FAIR-Chem/fairchem/blob/e344dc83f9e295c4be3830118302daf96e8a9b78/packages/fairchem-data-om/pyproject.toml#L1-L3)|[4](https://github.com/FAIR-Chem/fairchem/blob/e344dc83f9e295c4be3830118302daf96e8a9b78/packages/fairchem-demo-ocpapi/pyproject.toml#L1-L3)|[5](https://github.com/FAIR-Chem/fairchem/blob/e344dc83f9e295c4be3830118302daf96e8a9b78/packages/fairchem-applications-AdsorbML/pyproject.toml#L1-L3)|[6](https://github.com/FAIR-Chem/fairchem/blob/e344dc83f9e295c4be3830118302daf96e8a9b78/packages/fairchem-applications-cattsunami/pyproject.toml#L1-L3)\]</sup>
- [Chinese Academy of Sciences](https://english.cas.cn)
    - [Academy of Mathematics and Systems Science](http://english.amss.cas.cn) <sup>\[[1](https://github.com/zhanglabtools/ConsTADs/blob/db732cf820569564f933cd290736ad83b9c99dea/pyproject.toml#L1-L3)\]</sup>
- [Georgia Institute of Technology](https://www.gatech.edu)
    - [Georgia Tech Database Group](https://db.cc.gatech.edu) <sup>\[[1](https://github.com/georgia-tech-db/sqlfuzz/blob/e85895dae1c92a223cbc13b12d4a19f297c410ab/pyproject.toml#L1-L3)\]</sup>
- [Harvard University](https://www.harvard.edu)
    - [Department of Molecular and Cellular Biology](https://www.mcb.harvard.edu) <sup>\[[1](https://github.com/Hekstra-Lab/raman-analysis/blob/4b548b5ea935e52a7bd1f0ec8f4a00c822b81ede/pyproject.toml#L2-L4)\]</sup>
- [Heidelberg University](https://www.uni-heidelberg.de)
    - [Center for Molecular Biology](https://www.zmbh.uni-heidelberg.de) <sup>\[[1](https://github.com/anders-biostat/pymetdense/blob/a1d210f2c03d2919b549f2fed1e4db986d01c8d5/pyproject.toml#L1-L3)\]</sup>
- [Leiden University](https://www.universiteitleiden.nl/en)
    - [Leiden University Libraries](https://www.library.universiteitleiden.nl) <sup>\[[1](https://github.com/LeidenUniversityLibrary/maps-tools/blob/d7a9fc683be919d4f5538f6a6c80319558064968/pyproject.toml#L3-L5)|[2](https://github.com/LeidenUniversityLibrary/archminer/blob/61465dc36924ffe593653aa5888a27617c93860e/pyproject.toml#L1-L3)\]</sup>
- [Maastricht University](https://www.maastrichtuniversity.nl)
    - [Institute of Data Science](https://www.maastrichtuniversity.nl/research/institute-data-science) <sup>\[[1](https://github.com/MaastrichtU-IDS/fair-test/blob/9c88c18cb1b0fa8d37336cdd2b7b132cb979a83a/pyproject.toml#L95-L97)|[2](https://github.com/MaastrichtU-IDS/fair-enough-metrics/blob/dad29ef1f99f5e01a76799d909e538565ae2ed4e/pyproject.toml#L50-L52)|[3](https://github.com/MaastrichtU-IDS/cookiecutter-python-package/blob/1eda79b6ca64c27b4b12407464b3c2dc2511af94/%7B%7Bcookiecutter.package_name%7D%7D/pyproject.toml#L70-L72)|[4](https://github.com/MaastrichtU-IDS/translator-openpredict/blob/b6e0f5f5100129d3038618f86e4c2c05d62d51f4/pyproject.toml#L1-L3)|[5](https://github.com/MaastrichtU-IDS/cookiecutter-trapi-predict-kit/blob/a329c6d66c1b96b53e9fd02501c762aee32a69fb/%7B%7Bcookiecutter.package_name%7D%7D/pyproject.toml#L1-L3)|[6](https://github.com/MaastrichtU-IDS/sparql-profiler/blob/ac70a9e8575f9c9769eb1caf140e2f81b136835c/pyproject.toml#L1-L3)|[7](https://github.com/MaastrichtU-IDS/knowledge-collaboratory/blob/8263d69e7b8e485b0aff7e88a3a7aed3cceaa253/backend/pyproject.toml#L1-L3)|[8](https://github.com/MaastrichtU-IDS/LUCE/blob/94c9a0dda840a3d81828a89aefcfb19fee51cd60/pyproject.toml#L1-L3)\]</sup>
- [Massachusetts Institute of Technology](https://www.mit.edu)
    - [Computer Science and Artificial Intelligence Laboratory](https://www.csail.mit.edu) <sup>\[[1](https://github.com/Learning-and-Intelligent-Systems/lisdf/blob/d49a85a3924909f1d10fef40463757b141f47f90/pyproject.toml#L1-L3)\]</sup>
    - [Digital Humanities](https://digitalhumanities.mit.edu) <sup>\[[1](https://github.com/cuthbertLab/music21/blob/5417b3ce6415ab016a39564e21e29799387263e9/pyproject.toml#L1-L5)\]</sup>
- [Medical University of Innsbruck](https://www.i-med.ac.at/mypoint/index.xml.en)
    - [Institute of Bioinformatics](https://icbi.i-med.ac.at) <sup>\[[1](https://github.com/icbi-lab/infercnvpy/blob/12c103f4062860d5d91152222163eb7d22340146/pyproject.toml#L1-L3)\]</sup>
- [Polytechnique Montréal](https://www.polymtl.ca/en/)
    - [Department of Computer Engineering and Software Engineering](https://www.polymtl.ca/gigl/) <sup>\[[1](https://github.com/corail-research/seahorse/blob/e876042f92c704180c16055a6720ef828c21e0ae/pyproject.toml#L1-L3)\]</sup>
- [Siberian Branch of the Russian Academy of Sciences](https://www.sbras.ru/en/)
    - [Institute of Cytology and Genetics](https://www.icgbio.ru/en/) <sup>\[[1](https://github.com/genomech/FastContext/blob/f8ff7f4bbea9d6d3cdf2e3a361f72e9283b04f67/pyproject.toml#L1-L3)|[2](https://github.com/genomech/exoclasma-index/blob/2e0555c3e86d731f3aa8c978b23b586d3a0c492e/pyproject.toml#L1-L3)|[3](https://github.com/genomech/exoclasma-fastq/blob/80ea3eddf603d2b54bb02b5ada6d275a9436f287/pyproject.toml#L1-L3)|[4](https://github.com/genomech/exoclasma-pipe/blob/fbe365dd9301eec51879ef53b1704be66813bb8b/pyproject.toml#L1-L3)\]</sup>
- [Stanford University](https://www.stanford.edu)
    - [Empirical Security Research Group](https://esrg.stanford.edu/) <sup>\[[1](https://github.com/stanford-esrg/gps/blob/66f803bfd4726cd9d1b3e1724abfd34a36079530/pyproject.toml#L1-L3)\]</sup>
- [University of British Columbia](https://www.ubc.ca)
    - [Department of Earth, Ocean and Atmospheric Sciences](https://www.eoas.ubc.ca) <sup>\[[1](https://github.com/UBC-MOAD/cookiecutter-MOAD-pypkg/blob/75441f962a6e7b87c09bcae031fdfaec3cf75f74/%7B%7Bcookiecutter.package_name%7D%7D/pyproject.toml#L18-L20)|[2](https://github.com/SalishSeaCast/NEMO-Cmd/blob/be5425d49eaf845eaba8f1611455f2de75aa194b/pyproject.toml#L19-L21)|[3](https://github.com/SalishSeaCast/SalishSeaNowcast/blob/1a850c1368b7f3504e5804101647ab481fbe7048/pyproject.toml#L19-L21)\]</sup>
- [University of California, Berkeley](https://www.berkeley.edu)
    - [Center for Computational Biology](https://ccb.berkeley.edu) <sup>\[[1](https://github.com/YosefLab/scib-metrics/blob/4dcbf55d80e21cf141332ba718fc5c0eb012eac1/pyproject.toml#L1-L3)\]</sup>
- [University of California, Santa Barbara](https://www.ucsb.edu)
    - [Department of Computer Science](https://www.cs.ucsb.edu) <sup>\[[1](https://github.com/UCSBarchlab/PyRTL/blob/46b0f3d2ff0e334d9cf3a04ef5b090bd55fcc177/pyproject.toml#L10-L12)\]</sup>
- [University of Freiburg](https://uni-freiburg.de)
    - [Freiburg Center for Data Analysis and Modeling](https://www.fdm.uni-freiburg.de) <sup>\[[1](https://github.com/Spatial-Systems-Biology-Freiburg/FisInMa/blob/b9c5a980ae03d6f577e17242e6bce7822f665f94/pyproject.toml#L1-L3)\]</sup>
- [University of Illinois Urbana-Champaign](https://illinois.edu)
    - [Grainger College of Engineering](https://grainger.illinois.edu) <sup>\[[1](https://github.com/SPI2Py/SPI2Py/blob/feefd7bb003b42f4790982d68e7e4e5fdb6ca8ad/pyproject.toml#L1-L3)\]</sup>
- [University of Lausanne](https://www.unil.ch/central/en/home.html)
    - [Department of Computational Biology](https://www.unil.ch/dbc/en/home.html) <sup>\[[1](https://github.com/CSOgroup/cellcharter/blob/00b4cd44f13702bd8832ed6705614efda048b7b7/pyproject.toml#L1-L3)\]</sup>
- [University of Ljubljana](https://www.uni-lj.si/eng/)
    - [Faculty of Mechanical Engineering](https://www.uni-lj.si/academies_and_faculties/faculties/2013071111460582/) <sup>\[[1](https://github.com/ladisk/speckle_pattern/blob/055f45b66c7985564a9fa400d8d2f41ddd181d31/pyproject.toml#L1-L3)\]</sup>
- [University of Massachusetts Amherst](https://www.umass.edu)
    - [College of Information and Computer Sciences](https://www.cics.umass.edu) <sup>\[[1](https://github.com/plasma-umass/ChatDBG/blob/1bc32332464afe2f3932b0a9f586a88c8fb7a357/pyproject.toml#L1-L3)\]</sup>
- [University of Oxford](https://www.ox.ac.uk)
    - [Oxford Research Software Engineering](https://www.rse.ox.ac.uk) <sup>\[[1](https://github.com/OxfordRSE/oxrse_unit_conv/blob/e4cb7d15bbc8ba4ab7ff816d3bbdfb65fbda3f76/pyproject.toml#L21-L23)\]</sup>
- [University of Pennsylvania](https://www.upenn.edu)
    - [Lifespan Informatics and Neuroimaging Center](https://www.pennlinc.io) <sup>\[[1](https://github.com/PennLINC/qsiprep/blob/f0d661589cc2efd9a787b2c1b3db397a897daa98/pyproject.toml#L1-L3)|[2](https://github.com/PennLINC/xcp_d/blob/e68c802604ac9ca2c179ca2f164ceb4db7c1fe66/pyproject.toml#L1-L3)|[3](https://github.com/PennLINC/aslprep/blob/aeee1a22fce8f8f1bd922de6d822124fb7b3343f/pyproject.toml#L1-L3)|[4](https://github.com/PennLINC/CuBIDS/blob/fac73803b7c6d6ab938af142783c8159a6df6c60/pyproject.toml#L1-L3)\]</sup>
- [University of Regensburg](https://www.uni-regensburg.de/en)
    - [Spang Lab](https://www.spang-lab.de) <sup>\[[1](https://github.com/spang-lab/adadmire/blob/14f169a4d493952433224e518c4ed2484d6cc2bd/pyproject.toml#L1-L3)\]</sup>
- [University of Sussex](https://www.sussex.ac.uk)
    - [Predictive Analytics Lab](https://wearepal.ai) <sup>\[[1](https://github.com/wearepal/teext/blob/9253c9412b4ca340c42c0b9de0e8ac8f5ccdd0e3/pyproject.toml#L1-L3)\]</sup>
- [University of Toronto Scarborough](https://www.utsc.utoronto.ca/home/)
    - [utsc-networking](https://github.com/utsc-networking) <sup>\[[1](https://github.com/utsc-networking/utsc-tools/blob/02a79d48d133470a4394fced138b40c660cf111c/projects/core/pyproject.toml#L1-L3)|[2](https://github.com/utsc-networking/utsc-tools/blob/02a79d48d133470a4394fced138b40c660cf111c/projects/nautobot/pyproject.toml#L1-L3)|[3](https://github.com/utsc-networking/utsc-tools/blob/02a79d48d133470a4394fced138b40c660cf111c/projects/switchconfig/pyproject.toml#L1-L3)|[4](https://github.com/utsc-networking/utsc-tools/blob/02a79d48d133470a4394fced138b40c660cf111c/projects/scripts/pyproject.toml#L1-L3)\]</sup>
- [University of Washington](https://www.washington.edu)
    - [Interactive Data Lab](https://idl.cs.washington.edu) <sup>\[[1](https://github.com/uwdata/mosaic/blob/a3b78fef28fcc3e711bb922c97c3113aa6cf9122/packages/widget/pyproject.toml#L1-L3)\]</sup>
    - [Virtual Brain Lab](https://github.com/VirtualBrainLab) <sup>\[[1](https://github.com/VirtualBrainLab/ephys-link/blob/ebdf3a1488f1010faa19f22397f10d6be4d29d6f/pyproject.toml#L1-L3)\]</sup>
- [University of Wisconsin-Madison](https://www.wisc.edu)
    - [Data Science Institute](https://datascience.wisc.edu/institute/) <sup>\[[1](https://github.com/UW-Madison-DSI/ask-xDD/blob/ae62d038303927b69dba9dadfef94b55b55731b3/pyproject.toml#L20-L22)\]</sup>
- [Waseda University](https://www.waseda.jp/top/en/)
    - [Tackeuchi Laboratory](https://www.f.waseda.jp/atacke/) <sup>\[[1](https://github.com/wasedatakeuchilab/python-project-template-hatch/blob/58949ab351d81b67f14aa45abf7c70b87394e2dc/pyproject.toml#L1-L3)|[2](https://github.com/wasedatakeuchilab/webapp-photo-luminescence/blob/864d1019650a2b057f761aa91ed9a6cbe6c1b455/pyproject.toml#L1-L3)|[3](https://github.com/wasedatakeuchilab/tlab-analysis/blob/72f0a710e35613e8996f473a80e5cb6c3f8c523e/pyproject.toml#L1-L3)|[4](https://github.com/wasedatakeuchilab/tlab-pptx/blob/ef331176906447dbbcf33e46f060b60ac3c007c5/pyproject.toml#L1-L3)|[5](https://github.com/wasedatakeuchilab/tlab-google/blob/53ae597611a146c90116b3b9277430832e1d04c9/pyproject.toml#L1-L3)\]</sup>
- [Wellcome Sanger Institute](https://www.sanger.ac.uk) <sup>\[[1](https://github.com/sanger/lab-share-lib/blob/b3290b1922aabc29ac256dc034b8cfcc7b30f143/pyproject.toml#L25-L27)\]</sup>

## Research

- [Clariah](https://www.clariah.nl) <sup>\[[1](https://github.com/CLARIAH/pure3d/blob/3f93d62cb1f5223836c9ebf4c058e6f491de71b9/pyproject.toml#L1-L3)\]</sup>
- [CloudDrift](https://cloud-drift.github.io/clouddrift/) <sup>\[[1](https://github.com/Cloud-Drift/clouddrift/blob/5e654569c869a027fe0a486f06917b358837d41e/pyproject.toml#L1-L3)\]</sup>
- [Dask](https://www.dask.org) <sup>\[[1](https://github.com/dask/dask-ml/blob/b95ba909c6dcd37c566f5193ba0b918396edaaee/pyproject.toml#L1-L3)|[2](https://github.com/dask/dask-labextension/blob/39b69ac5b8bfdb726347aabe3da86a15cb201b77/pyproject.toml#L1-L3)\]</sup>
- [GAMA](https://gama-platform.org) <sup>\[[1](https://github.com/gama-platform/Gama-client-python/blob/d9fecae0dff9050f39a011c4f4bdb02f5137b241/pyproject.toml#L1-L3)\]</sup>
- [IPython](https://ipython.org) <sup>\[[1](https://github.com/ipython/ipykernel/blob/dd0a9863e07c1d49f5aaf72c0c62670acee71b55/pyproject.toml#L1-L3)|[2](https://github.com/ipython/ipyparallel/blob/06f5d3df1f6e858a83c3af29438ae6d5af801267/pyproject.toml#L1-L6)|[3](https://github.com/ipython/traitlets/blob/ac13bbb885c275fd446f85a9d2e74d8058c2b3c1/pyproject.toml#L1-L3)\]</sup>
- [MNE](https://mne.tools) <sup>\[[1](https://github.com/mne-tools/mne-python/blob/8af33df490f94c3dd628cfc23beafed1a6cc6361/pyproject.toml#L1-L3)|[2](https://github.com/mne-tools/mne-bids-pipeline/blob/a6995abc39fab333ab957baa45b0026bdb12a3f9/pyproject.toml#L1-L3)|[3](https://github.com/mne-tools/mne-bids/blob/8321aef66e1c920bd4df748e326e06b0bf696e4c/pyproject.toml#L1-L3)\]</sup>
- [NIPY](https://nipy.org) <sup>\[[1](https://github.com/nipy/nibabel/blob/298788070a36e8d8616df36ebed0d4339f00e43b/pyproject.toml#L1-L3)|[2](https://github.com/nipy/quickshear/blob/83b362b794d52183ff40ec5dcc98239b94c5633a/pyproject.toml#L1-L3)\]</sup>
- [Project Jupyter](https://jupyter.org)
    - [Jupyter](https://github.com/jupyter) <sup>\[[1](https://github.com/jupyter/notebook/blob/b9bab689c9a2f33eb3b2cca1383c2d99baa7a2e8/pyproject.toml#L1-L3)|[2](https://github.com/jupyter/jupyter_core/blob/2a6fb6d2b28ca712268eee15d7b907a3a73271d8/pyproject.toml#L1-L3)|[3](https://github.com/jupyter/jupyter_client/blob/e526895a29e0331a167167070b1603f20a4b2840/pyproject.toml#L1-L3)|[4](https://github.com/jupyter/nbconvert/blob/af70c9fa83bee4d0c92e06b4ede4ef5ea7c920b0/pyproject.toml#L1-L3)\]</sup>
    - [JupyterLab](https://github.com/jupyterlab) <sup>\[[1](https://github.com/jupyterlab/hatch_jupyter_builder)|[2](https://github.com/jupyterlab/jupyterlab/pull/12606)|[3](https://github.com/jupyterlab/maintainer-tools/blob/0e95a837469f5325e5a840bd194fe8273087d2f6/pyproject.toml#L1-L3)|[4](https://github.com/jupyterlab/pytest-check-links/blob/b07e705d590e9fce22dc21191018f4f72ec7215b/pyproject.toml#L1-L3)|[5](https://github.com/jupyterlab/extension-cookiecutter-js/pull/41)\]</sup>
    - [Jupyter Server](https://github.com/jupyter-server) <sup>\[[1](https://github.com/jupyter-server/jupyter_server/blob/061d846fbd0cf2f0be50d12c4a15feffd3214774/pyproject.toml#L1-L3)|[2](https://github.com/jupyter-server/enterprise_gateway/blob/b45a81ae70680be7f8e0d1e3daed1df3063667fa/pyproject.toml#L1-L3)|[3](https://github.com/jupyter-server/jupyter_server_terminals/blob/4b32ceb34b9b6ae9c677424cc65c9c3bfe243719/pyproject.toml#L1-L3)|[4](https://github.com/jupyter-server/synchronizer/blob/5809e9ffd188beff743874a434884662867bb573/pyproject.toml#L1-L3)\]</sup>
- [RAPIDS](https://rapids.ai) <sup>\[[1](https://github.com/rapidsai/jupyterlab-nvdashboard/blob/578b58b4fd0ec31a7cc02ac6d2795622c00ef478/pyproject.toml#L3-L9)\]
- [Scikit-HEP](https://scikit-hep.org) <sup>\[[1](https://github.com/scikit-hep/uproot-browser/blob/f41ce3f3887057f5ec9a6cd164c3c41d1ec3d633/pyproject.toml#L1-L3)|[2](https://github.com/scikit-hep/uhi/blob/95ad870218a6fd7f2ab02f3d2b5c421e93a1f03f/pyproject.toml#L1-L3)|[3](https://github.com/scikit-hep/repo-review/blob/007026a62c6c61914ec49e111be587104f59b8ae/pyproject.toml#L1-L3)|[4](https://github.com/scikit-hep/hist/blob/768ea7de75f20c06caa6ded72d70bd132e4c9467/pyproject.toml#L1-L3)|[5](https://github.com/scikit-hep/vector/blob/cac88a2e0f1c4bf7bceaafbea6e234b3147e3ca3/pyproject.toml#L1-L6)|[6](https://github.com/scikit-hep/uproot5/blob/f9213e0f8c29435890e5aa72e336330bb7a785fe/pyproject.toml#L1-L5)|[7](https://github.com/scikit-hep/particle/blob/723c1618c7058feb0a914a6738d8b8018a5df1bd/pyproject.toml#L1-L3)|[8](https://github.com/scikit-hep/hepunits/blob/bd1302cbb85ed486c057f8b078ad4e026d65bb1c/pyproject.toml#L1-L3)|[9](https://github.com/scikit-hep/decaylanguage/blob/eae09aee69acef2d1c19f55665c5ca8b28588e01/pyproject.toml#L1-L6)|[10](https://github.com/scikit-hep/pyhf/blob/efbf201b57345063afec66c254aace3148f1f055/pyproject.toml#L1-L3)\]</sup>
- [scverse](https://scverse.org) <sup>\[[1](https://github.com/scverse/spatialdata-io/blob/15c395de859d6d06e5032016c9406acae5cac454/pyproject.toml#L1-L3)|[2](https://github.com/scverse/spatialdata-notebooks/blob/2b539a1d23b06b509a46a6bf3cb6594f1952f830/pyproject.toml#L1-L3)|[3](https://github.com/scverse/cookiecutter-scverse/blob/2892e1ddf0dd558cb9b547b47a7c2d0a156c9ef1/%7B%7Bcookiecutter.project_name%7D%7D/pyproject.toml#L1-L3)\]</sup>
- [Spyder](https://www.spyder-ide.org) <sup>\[[1](https://github.com/spyder-ide/envs-manager/blob/9c487532cbb4804c94d7cf23dcec9404b2a1c7ec/pyproject.toml#L1-L3)\]</sup>

## Security

- [Armory](https://github.com/twosixlabs/armory/blob/330caa23d54ce82886606810f103ce1a0eec98ce/pyproject.toml#L129-L134)
- [in-toto](https://github.com/in-toto/in-toto/blob/2768904b8a3892529aba8f8a605461fd178d9a58/pyproject.toml#L1-L3)
- [The Update Framework](https://github.com/theupdateframework/python-tuf/blob/72424a958b60817155fcacfed1216163790b26f7/pyproject.toml#L2-L4)

## Crypto

- [Ocean Protocol](https://oceanprotocol.com) <sup>\[[1](https://github.com/oceanprotocol/pybundlr/blob/484c755d96be2da35cda83f01861745867cdb2d4/pyproject.toml#L1-L6)\]</sup>
