/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.Collection;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesEntry;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;

public class LoggingAttributeMatchingExplanationBuilder
implements AttributeMatchingExplanationBuilder {
    private static final AttributeMatchingExplanationBuilder INSTANCE = new LoggingAttributeMatchingExplanationBuilder();
    private static final Logger LOGGER = Logging.getLogger(LoggingAttributeMatchingExplanationBuilder.class);

    static AttributeMatchingExplanationBuilder logging() {
        if (LOGGER.isDebugEnabled()) {
            return INSTANCE;
        }
        return AttributeMatchingExplanationBuilder.NO_OP;
    }

    @Override
    public void noCandidates(ImmutableAttributes requested) {
        LOGGER.debug("No candidates for {}. Select nothing.", (Object)requested);
    }

    @Override
    public void singleMatch(ImmutableAttributes candidate, Collection<ImmutableAttributes> candidates, AttributeContainerInternal requested) {
        LOGGER.debug("Selected match {} from candidates {} for {}", new Object[]{candidate, candidates, requested});
    }

    @Override
    public void candidateDoesNotMatchAttributes(ImmutableAttributes candidate, AttributeContainerInternal requested) {
        LOGGER.debug("Candidate {} doesn't match attributes {}", (Object)candidate, (Object)requested);
    }

    @Override
    public void candidateAttributeDoesNotMatch(ImmutableAttributes candidate, Attribute<?> attribute, Object requestedValue, ImmutableAttributesEntry<?> candidateEntry) {
        LOGGER.debug("Candidate {} attribute {} value {} doesn't requested value {}", new Object[]{candidate, attribute, candidateEntry, requestedValue});
    }

    @Override
    public void candidateAttributeMissing(ImmutableAttributes candidate, Attribute<?> attribute, Object requestedValue) {
        LOGGER.debug("Candidate {} doesn't have attribute {}", (Object)candidate, attribute);
    }

    @Override
    public void candidateIsSuperSetOfAllOthers(ImmutableAttributes candidate) {
        LOGGER.debug("Candidate {} selected because its attributes are a superset of all other candidate attributes", (Object)candidate);
    }
}

