/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.jvm.toolchain.JavaToolchainDownload;
import org.gradle.jvm.toolchain.JavaToolchainRequest;
import org.gradle.jvm.toolchain.JavaToolchainResolver;
import org.gradle.jvm.toolchain.internal.JavaToolchainResolverRegistryInternal;
import org.gradle.jvm.toolchain.internal.JavaToolchainResolverService;
import org.gradle.jvm.toolchain.internal.RealizedJavaToolchainRepository;
import org.gradle.jvm.toolchain.internal.install.exceptions.ToolchainProvisioningException;

public class DefaultJavaToolchainResolverService
implements JavaToolchainResolverService {
    private final JavaToolchainResolverRegistryInternal toolchainResolverRegistry;

    @Inject
    public DefaultJavaToolchainResolverService(JavaToolchainResolverRegistryInternal toolchainResolverRegistry) {
        this.toolchainResolverRegistry = toolchainResolverRegistry;
    }

    public Optional<JavaToolchainDownload> tryResolve(JavaToolchainRequest request) {
        List repositories = this.toolchainResolverRegistry.requestedRepositories();
        if (repositories.isEmpty()) {
            throw new ToolchainProvisioningException(request.getJavaToolchainSpec(), "Toolchain download repositories have not been configured.", new String[]{ToolchainProvisioningException.AUTO_DETECTION_RESOLUTION, ToolchainProvisioningException.DOWNLOAD_REPOSITORIES_RESOLUTION});
        }
        for (RealizedJavaToolchainRepository repository : repositories) {
            JavaToolchainResolver resolver = repository.getResolver();
            Optional download = resolver.resolve(request);
            if (!download.isPresent()) continue;
            return download;
        }
        return Optional.empty();
    }

    public boolean hasConfiguredToolchainRepositories() {
        return !this.toolchainResolverRegistry.requestedRepositories().isEmpty();
    }
}

