//
// Code generated by rdl 1.5.2 DO NOT EDIT.
//

package zts

import (
	"encoding/json"
	"fmt"
	rdl "github.com/ardielle/ardielle-go/rdl"
)

var _ = rdl.Version
var _ = json.Marshal
var _ = fmt.Printf

//
// SimpleName - Copyright 2016 Yahoo Inc. Licensed under the terms of the
// Apache version 2.0 license. See LICENSE file for terms. Common name types
// used by several API definitions A simple identifier, an element of compound
// name.
//
type SimpleName string

//
// CompoundName - A compound name. Most names in this API are compound names.
//
type CompoundName string

//
// DomainName - A domain name is the general qualifier prefix, as its
// uniqueness is managed.
//
type DomainName string

//
// EntityName - An entity name is a short form of a resource name, including
// only the domain and entity.
//
type EntityName string

//
// EntityList - An Entity list is comma separated compound Names
//
type EntityList string

//
// ServiceName - A service name will generally be a unique subdomain.
//
type ServiceName string

//
// ActionName - An action (operation) name.
//
type ActionName string

//
// ResourceName - A resource name Note that the EntityName part is optional,
// that is, a domain name followed by a colon is valid resource name.
//
type ResourceName string

//
// YBase64 - The Y-specific URL-safe Base64 variant.
//
type YBase64 string

//
// YEncoded - YEncoded includes ybase64 chars, as well as = and %. This can
// represent a user cookie and URL-encoded values.
//
type YEncoded string

//
// AuthorityName - Used as the prefix in a signed assertion. This uniquely
// identifies a signing authority.
//
type AuthorityName string

//
// SignedToken - A signed assertion if identity. i.e. the user cookie value.
// This token will only make sense to the authority that generated it, so it is
// beneficial to have something in the value that is cheaply recognized to
// quickly reject if it belongs to another authority. In addition to the
// YEncoded set our token includes ; to separate components and , to separate
// roles
//
type SignedToken string

//
// PathElement - A uri-safe path element
//
type PathElement string

//
// CertType - CertType denotes various types of certs issued by Athenz
//
type CertType int

//
// CertType constants
//
const (
	_ CertType = iota
	X509
	SSH_HOST
	SSH_USER
)

var namesCertType = []string{
	X509:     "X509",
	SSH_HOST: "SSH_HOST",
	SSH_USER: "SSH_USER",
}

//
// NewCertType - return a string representation of the enum
//
func NewCertType(init ...interface{}) CertType {
	if len(init) == 1 {
		switch v := init[0].(type) {
		case CertType:
			return v
		case int:
			return CertType(v)
		case int32:
			return CertType(v)
		case string:
			for i, s := range namesCertType {
				if s == v {
					return CertType(i)
				}
			}
		default:
			panic("Bad init value for CertType enum")
		}
	}
	return CertType(0) //default to the first enum value
}

//
// String - return a string representation of the enum
//
func (e CertType) String() string {
	return namesCertType[e]
}

//
// SymbolSet - return an array of all valid string representations (symbols) of the enum
//
func (e CertType) SymbolSet() []string {
	return namesCertType
}

//
// MarshalJSON is defined for proper JSON encoding of a CertType
//
func (e CertType) MarshalJSON() ([]byte, error) {
	return json.Marshal(e.String())
}

//
// UnmarshalJSON is defined for proper JSON decoding of a CertType
//
func (e *CertType) UnmarshalJSON(b []byte) error {
	var j string
	err := json.Unmarshal(b, &j)
	if err == nil {
		s := string(j)
		for v, s2 := range namesCertType {
			if s == s2 {
				*e = CertType(v)
				return nil
			}
		}
		err = fmt.Errorf("Bad enum symbol for type CertType: %s", s)
	}
	return err
}

//
// ResourceAccess - ResourceAccess can be checked and returned as this
// resource. (same as ZMS.Access)
//
type ResourceAccess struct {

	//
	// true (allowed) or false (denied)
	//
	Granted bool `json:"granted"`
}

//
// NewResourceAccess - creates an initialized ResourceAccess instance, returns a pointer to it
//
func NewResourceAccess(init ...*ResourceAccess) *ResourceAccess {
	var o *ResourceAccess
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(ResourceAccess)
	}
	return o
}

type rawResourceAccess ResourceAccess

//
// UnmarshalJSON is defined for proper JSON decoding of a ResourceAccess
//
func (self *ResourceAccess) UnmarshalJSON(b []byte) error {
	var m rawResourceAccess
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := ResourceAccess(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *ResourceAccess) Validate() error {
	return nil
}

//
// PublicKeyEntry - The representation of the public key in a service identity
// object.
//
type PublicKeyEntry struct {

	//
	// the public key for the service
	//
	Key string `json:"key"`

	//
	// the key identifier (version or zone name)
	//
	Id string `json:"id"`
}

//
// NewPublicKeyEntry - creates an initialized PublicKeyEntry instance, returns a pointer to it
//
func NewPublicKeyEntry(init ...*PublicKeyEntry) *PublicKeyEntry {
	var o *PublicKeyEntry
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(PublicKeyEntry)
	}
	return o
}

type rawPublicKeyEntry PublicKeyEntry

//
// UnmarshalJSON is defined for proper JSON decoding of a PublicKeyEntry
//
func (self *PublicKeyEntry) UnmarshalJSON(b []byte) error {
	var m rawPublicKeyEntry
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := PublicKeyEntry(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *PublicKeyEntry) Validate() error {
	if self.Key == "" {
		return fmt.Errorf("PublicKeyEntry.key is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Key)
		if !val.Valid {
			return fmt.Errorf("PublicKeyEntry.key does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Id == "" {
		return fmt.Errorf("PublicKeyEntry.id is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Id)
		if !val.Valid {
			return fmt.Errorf("PublicKeyEntry.id does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// ServiceIdentity - The representation of the service identity object.
//
type ServiceIdentity struct {

	//
	// the full name of the service, i.e. "sports.storage"
	//
	Name ServiceName `json:"name"`

	//
	// array of public keys for key rotation
	//
	PublicKeys []*PublicKeyEntry `json:"publicKeys,omitempty" rdl:"optional"`

	//
	// if present, then this service can provision tenants via this endpoint.
	//
	ProviderEndpoint string `json:"providerEndpoint,omitempty" rdl:"optional"`

	//
	// the timestamp when this entry was last modified
	//
	Modified *rdl.Timestamp `json:"modified,omitempty" rdl:"optional"`

	//
	// the path of the executable that runs the service
	//
	Executable string `json:"executable,omitempty" rdl:"optional"`

	//
	// list of host names that this service can run on
	//
	Hosts []string `json:"hosts,omitempty" rdl:"optional"`

	//
	// local (unix) user name this service can run as
	//
	User string `json:"user,omitempty" rdl:"optional"`

	//
	// local (unix) group name this service can run as
	//
	Group string `json:"group,omitempty" rdl:"optional"`
}

//
// NewServiceIdentity - creates an initialized ServiceIdentity instance, returns a pointer to it
//
func NewServiceIdentity(init ...*ServiceIdentity) *ServiceIdentity {
	var o *ServiceIdentity
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(ServiceIdentity)
	}
	return o
}

type rawServiceIdentity ServiceIdentity

//
// UnmarshalJSON is defined for proper JSON decoding of a ServiceIdentity
//
func (self *ServiceIdentity) UnmarshalJSON(b []byte) error {
	var m rawServiceIdentity
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := ServiceIdentity(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *ServiceIdentity) Validate() error {
	if self.Name == "" {
		return fmt.Errorf("ServiceIdentity.name is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "ServiceName", self.Name)
		if !val.Valid {
			return fmt.Errorf("ServiceIdentity.name does not contain a valid ServiceName (%v)", val.Error)
		}
	}
	if self.ProviderEndpoint != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.ProviderEndpoint)
		if !val.Valid {
			return fmt.Errorf("ServiceIdentity.providerEndpoint does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Executable != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Executable)
		if !val.Valid {
			return fmt.Errorf("ServiceIdentity.executable does not contain a valid String (%v)", val.Error)
		}
	}
	if self.User != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.User)
		if !val.Valid {
			return fmt.Errorf("ServiceIdentity.user does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Group != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Group)
		if !val.Valid {
			return fmt.Errorf("ServiceIdentity.group does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// ServiceIdentityList - The representation for an enumeration of services in
// the namespace.
//
type ServiceIdentityList struct {

	//
	// list of service names
	//
	Names []EntityName `json:"names"`
}

//
// NewServiceIdentityList - creates an initialized ServiceIdentityList instance, returns a pointer to it
//
func NewServiceIdentityList(init ...*ServiceIdentityList) *ServiceIdentityList {
	var o *ServiceIdentityList
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(ServiceIdentityList)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *ServiceIdentityList) Init() *ServiceIdentityList {
	if self.Names == nil {
		self.Names = make([]EntityName, 0)
	}
	return self
}

type rawServiceIdentityList ServiceIdentityList

//
// UnmarshalJSON is defined for proper JSON decoding of a ServiceIdentityList
//
func (self *ServiceIdentityList) UnmarshalJSON(b []byte) error {
	var m rawServiceIdentityList
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := ServiceIdentityList(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *ServiceIdentityList) Validate() error {
	if self.Names == nil {
		return fmt.Errorf("ServiceIdentityList: Missing required field: names")
	}
	return nil
}

//
// HostServices - The representation for an enumeration of services authorized
// to run on a specific host.
//
type HostServices struct {

	//
	// name of the host
	//
	Host string `json:"host"`

	//
	// list of service names authorized to run on this host
	//
	Names []EntityName `json:"names"`
}

//
// NewHostServices - creates an initialized HostServices instance, returns a pointer to it
//
func NewHostServices(init ...*HostServices) *HostServices {
	var o *HostServices
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(HostServices)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *HostServices) Init() *HostServices {
	if self.Names == nil {
		self.Names = make([]EntityName, 0)
	}
	return self
}

type rawHostServices HostServices

//
// UnmarshalJSON is defined for proper JSON decoding of a HostServices
//
func (self *HostServices) UnmarshalJSON(b []byte) error {
	var m rawHostServices
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := HostServices(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *HostServices) Validate() error {
	if self.Host == "" {
		return fmt.Errorf("HostServices.host is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Host)
		if !val.Valid {
			return fmt.Errorf("HostServices.host does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Names == nil {
		return fmt.Errorf("HostServices: Missing required field: names")
	}
	return nil
}

//
// AssertionEffect - Every assertion can have the effect of ALLOW or DENY.
//
type AssertionEffect int

//
// AssertionEffect constants
//
const (
	_ AssertionEffect = iota
	ALLOW
	DENY
)

var namesAssertionEffect = []string{
	ALLOW: "ALLOW",
	DENY:  "DENY",
}

//
// NewAssertionEffect - return a string representation of the enum
//
func NewAssertionEffect(init ...interface{}) AssertionEffect {
	if len(init) == 1 {
		switch v := init[0].(type) {
		case AssertionEffect:
			return v
		case int:
			return AssertionEffect(v)
		case int32:
			return AssertionEffect(v)
		case string:
			for i, s := range namesAssertionEffect {
				if s == v {
					return AssertionEffect(i)
				}
			}
		default:
			panic("Bad init value for AssertionEffect enum")
		}
	}
	return AssertionEffect(0) //default to the first enum value
}

//
// String - return a string representation of the enum
//
func (e AssertionEffect) String() string {
	return namesAssertionEffect[e]
}

//
// SymbolSet - return an array of all valid string representations (symbols) of the enum
//
func (e AssertionEffect) SymbolSet() []string {
	return namesAssertionEffect
}

//
// MarshalJSON is defined for proper JSON encoding of a AssertionEffect
//
func (e AssertionEffect) MarshalJSON() ([]byte, error) {
	return json.Marshal(e.String())
}

//
// UnmarshalJSON is defined for proper JSON decoding of a AssertionEffect
//
func (e *AssertionEffect) UnmarshalJSON(b []byte) error {
	var j string
	err := json.Unmarshal(b, &j)
	if err == nil {
		s := string(j)
		for v, s2 := range namesAssertionEffect {
			if s == s2 {
				*e = AssertionEffect(v)
				return nil
			}
		}
		err = fmt.Errorf("Bad enum symbol for type AssertionEffect: %s", s)
	}
	return err
}

//
// Assertion - A representation for the encapsulation of an action to be
// performed on a resource by a principal.
//
type Assertion struct {

	//
	// the subject of the assertion, a role
	//
	Role string `json:"role"`

	//
	// the object of the assertion. Must be in the local namespace. Can contain
	// wildcards
	//
	Resource string `json:"resource"`

	//
	// the predicate of the assertion. Can contain wildcards
	//
	Action string `json:"action"`

	//
	// the effect of the assertion in the policy language
	//
	Effect *AssertionEffect `json:"effect,omitempty" rdl:"optional"`

	//
	// assertion id - auto generated by server
	//
	Id *int64 `json:"id,omitempty" rdl:"optional"`

	//
	// If true, we should store action and resource in their original case
	//
	CaseSensitive *bool `json:"caseSensitive,omitempty" rdl:"optional"`
}

//
// NewAssertion - creates an initialized Assertion instance, returns a pointer to it
//
func NewAssertion(init ...*Assertion) *Assertion {
	var o *Assertion
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(Assertion)
	}
	return o
}

type rawAssertion Assertion

//
// UnmarshalJSON is defined for proper JSON decoding of a Assertion
//
func (self *Assertion) UnmarshalJSON(b []byte) error {
	var m rawAssertion
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := Assertion(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *Assertion) Validate() error {
	if self.Role == "" {
		return fmt.Errorf("Assertion.role is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Role)
		if !val.Valid {
			return fmt.Errorf("Assertion.role does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Resource == "" {
		return fmt.Errorf("Assertion.resource is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Resource)
		if !val.Valid {
			return fmt.Errorf("Assertion.resource does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Action == "" {
		return fmt.Errorf("Assertion.action is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Action)
		if !val.Valid {
			return fmt.Errorf("Assertion.action does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// Policy - The representation for a Policy with set of assertions.
//
type Policy struct {

	//
	// name of the policy
	//
	Name ResourceName `json:"name"`

	//
	// last modification timestamp of this policy
	//
	Modified *rdl.Timestamp `json:"modified,omitempty" rdl:"optional"`

	//
	// list of defined assertions for this policy
	//
	Assertions []*Assertion `json:"assertions"`

	//
	// If true, we should store action and resource in their original case
	//
	CaseSensitive *bool `json:"caseSensitive,omitempty" rdl:"optional"`

	//
	// optional version string, defaults to 0
	//
	Version SimpleName `json:"version,omitempty" rdl:"optional"`

	//
	// if multi-version policy then indicates active version
	//
	Active *bool `json:"active,omitempty" rdl:"optional"`
}

//
// NewPolicy - creates an initialized Policy instance, returns a pointer to it
//
func NewPolicy(init ...*Policy) *Policy {
	var o *Policy
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(Policy)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *Policy) Init() *Policy {
	if self.Assertions == nil {
		self.Assertions = make([]*Assertion, 0)
	}
	return self
}

type rawPolicy Policy

//
// UnmarshalJSON is defined for proper JSON decoding of a Policy
//
func (self *Policy) UnmarshalJSON(b []byte) error {
	var m rawPolicy
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := Policy(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *Policy) Validate() error {
	if self.Name == "" {
		return fmt.Errorf("Policy.name is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "ResourceName", self.Name)
		if !val.Valid {
			return fmt.Errorf("Policy.name does not contain a valid ResourceName (%v)", val.Error)
		}
	}
	if self.Assertions == nil {
		return fmt.Errorf("Policy: Missing required field: assertions")
	}
	if self.Version != "" {
		val := rdl.Validate(ZTSSchema(), "SimpleName", self.Version)
		if !val.Valid {
			return fmt.Errorf("Policy.version does not contain a valid SimpleName (%v)", val.Error)
		}
	}
	return nil
}

//
// PolicyData -
//
type PolicyData struct {

	//
	// name of the domain
	//
	Domain DomainName `json:"domain"`

	//
	// list of policies defined in this server
	//
	Policies []*Policy `json:"policies"`
}

//
// NewPolicyData - creates an initialized PolicyData instance, returns a pointer to it
//
func NewPolicyData(init ...*PolicyData) *PolicyData {
	var o *PolicyData
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(PolicyData)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *PolicyData) Init() *PolicyData {
	if self.Policies == nil {
		self.Policies = make([]*Policy, 0)
	}
	return self
}

type rawPolicyData PolicyData

//
// UnmarshalJSON is defined for proper JSON decoding of a PolicyData
//
func (self *PolicyData) UnmarshalJSON(b []byte) error {
	var m rawPolicyData
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := PolicyData(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *PolicyData) Validate() error {
	if self.Domain == "" {
		return fmt.Errorf("PolicyData.domain is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "DomainName", self.Domain)
		if !val.Valid {
			return fmt.Errorf("PolicyData.domain does not contain a valid DomainName (%v)", val.Error)
		}
	}
	if self.Policies == nil {
		return fmt.Errorf("PolicyData: Missing required field: policies")
	}
	return nil
}

//
// SignedPolicyData - A representation of policies object defined in a given
// server.
//
type SignedPolicyData struct {

	//
	// list of policies defined in a domain
	//
	PolicyData *PolicyData `json:"policyData"`

	//
	// zms signature generated based on the domain policies object
	//
	ZmsSignature string `json:"zmsSignature,omitempty" rdl:"optional"`

	//
	// the identifier of the zms key used to generate the signature
	//
	ZmsKeyId string `json:"zmsKeyId,omitempty" rdl:"optional"`

	//
	// when the domain itself was last modified
	//
	Modified rdl.Timestamp `json:"modified"`

	//
	// timestamp specifying the expiration time for using this set of policies
	//
	Expires rdl.Timestamp `json:"expires"`
}

//
// NewSignedPolicyData - creates an initialized SignedPolicyData instance, returns a pointer to it
//
func NewSignedPolicyData(init ...*SignedPolicyData) *SignedPolicyData {
	var o *SignedPolicyData
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(SignedPolicyData)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *SignedPolicyData) Init() *SignedPolicyData {
	if self.PolicyData == nil {
		self.PolicyData = NewPolicyData()
	}
	return self
}

type rawSignedPolicyData SignedPolicyData

//
// UnmarshalJSON is defined for proper JSON decoding of a SignedPolicyData
//
func (self *SignedPolicyData) UnmarshalJSON(b []byte) error {
	var m rawSignedPolicyData
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := SignedPolicyData(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *SignedPolicyData) Validate() error {
	if self.PolicyData == nil {
		return fmt.Errorf("SignedPolicyData: Missing required field: policyData")
	}
	if self.ZmsSignature != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.ZmsSignature)
		if !val.Valid {
			return fmt.Errorf("SignedPolicyData.zmsSignature does not contain a valid String (%v)", val.Error)
		}
	}
	if self.ZmsKeyId != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.ZmsKeyId)
		if !val.Valid {
			return fmt.Errorf("SignedPolicyData.zmsKeyId does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Modified.IsZero() {
		return fmt.Errorf("SignedPolicyData: Missing required field: modified")
	}
	if self.Expires.IsZero() {
		return fmt.Errorf("SignedPolicyData: Missing required field: expires")
	}
	return nil
}

//
// DomainSignedPolicyData - A signed bulk transfer of policies. The data is
// signed with server's private key.
//
type DomainSignedPolicyData struct {

	//
	// policy data signed by ZMS
	//
	SignedPolicyData *SignedPolicyData `json:"signedPolicyData"`

	//
	// signature generated based on the domain policies object
	//
	Signature string `json:"signature"`

	//
	// the identifier of the key used to generate the signature
	//
	KeyId string `json:"keyId"`
}

//
// NewDomainSignedPolicyData - creates an initialized DomainSignedPolicyData instance, returns a pointer to it
//
func NewDomainSignedPolicyData(init ...*DomainSignedPolicyData) *DomainSignedPolicyData {
	var o *DomainSignedPolicyData
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(DomainSignedPolicyData)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *DomainSignedPolicyData) Init() *DomainSignedPolicyData {
	if self.SignedPolicyData == nil {
		self.SignedPolicyData = NewSignedPolicyData()
	}
	return self
}

type rawDomainSignedPolicyData DomainSignedPolicyData

//
// UnmarshalJSON is defined for proper JSON decoding of a DomainSignedPolicyData
//
func (self *DomainSignedPolicyData) UnmarshalJSON(b []byte) error {
	var m rawDomainSignedPolicyData
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := DomainSignedPolicyData(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *DomainSignedPolicyData) Validate() error {
	if self.SignedPolicyData == nil {
		return fmt.Errorf("DomainSignedPolicyData: Missing required field: signedPolicyData")
	}
	if self.Signature == "" {
		return fmt.Errorf("DomainSignedPolicyData.signature is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Signature)
		if !val.Valid {
			return fmt.Errorf("DomainSignedPolicyData.signature does not contain a valid String (%v)", val.Error)
		}
	}
	if self.KeyId == "" {
		return fmt.Errorf("DomainSignedPolicyData.keyId is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.KeyId)
		if !val.Valid {
			return fmt.Errorf("DomainSignedPolicyData.keyId does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// JWSPolicyData - SignedPolicyData using flattened JWS JSON Serialization
// syntax. https://tools.ietf.org/html/rfc7515#section-7.2.2
//
type JWSPolicyData struct {
	Payload   string            `json:"payload"`
	Protected string            `json:"protected"`
	Header    map[string]string `json:"header"`
	Signature string            `json:"signature"`
}

//
// NewJWSPolicyData - creates an initialized JWSPolicyData instance, returns a pointer to it
//
func NewJWSPolicyData(init ...*JWSPolicyData) *JWSPolicyData {
	var o *JWSPolicyData
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(JWSPolicyData)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *JWSPolicyData) Init() *JWSPolicyData {
	if self.Header == nil {
		self.Header = make(map[string]string)
	}
	return self
}

type rawJWSPolicyData JWSPolicyData

//
// UnmarshalJSON is defined for proper JSON decoding of a JWSPolicyData
//
func (self *JWSPolicyData) UnmarshalJSON(b []byte) error {
	var m rawJWSPolicyData
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := JWSPolicyData(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *JWSPolicyData) Validate() error {
	if self.Payload == "" {
		return fmt.Errorf("JWSPolicyData.payload is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Payload)
		if !val.Valid {
			return fmt.Errorf("JWSPolicyData.payload does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Protected == "" {
		return fmt.Errorf("JWSPolicyData.protected is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Protected)
		if !val.Valid {
			return fmt.Errorf("JWSPolicyData.protected does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Header == nil {
		return fmt.Errorf("JWSPolicyData: Missing required field: header")
	}
	if self.Signature == "" {
		return fmt.Errorf("JWSPolicyData.signature is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Signature)
		if !val.Valid {
			return fmt.Errorf("JWSPolicyData.signature does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// SignedPolicyRequest -
//
type SignedPolicyRequest struct {
	PolicyVersions map[string]string `json:"policyVersions"`

	//
	// true if signature must be in P1363 format instead of ASN.1 DER
	//
	SignatureP1363Format bool `json:"signatureP1363Format"`
}

//
// NewSignedPolicyRequest - creates an initialized SignedPolicyRequest instance, returns a pointer to it
//
func NewSignedPolicyRequest(init ...*SignedPolicyRequest) *SignedPolicyRequest {
	var o *SignedPolicyRequest
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(SignedPolicyRequest)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *SignedPolicyRequest) Init() *SignedPolicyRequest {
	if self.PolicyVersions == nil {
		self.PolicyVersions = make(map[string]string)
	}
	return self
}

type rawSignedPolicyRequest SignedPolicyRequest

//
// UnmarshalJSON is defined for proper JSON decoding of a SignedPolicyRequest
//
func (self *SignedPolicyRequest) UnmarshalJSON(b []byte) error {
	var m rawSignedPolicyRequest
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := SignedPolicyRequest(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *SignedPolicyRequest) Validate() error {
	if self.PolicyVersions == nil {
		return fmt.Errorf("SignedPolicyRequest: Missing required field: policyVersions")
	}
	return nil
}

//
// RoleCertificate - Copyright Athenz Authors Licensed under the terms of the
// Apache version 2.0 license. See LICENSE file for terms. RoleCertificate - a
// role certificate
//
type RoleCertificate struct {
	X509Certificate string `json:"x509Certificate"`
}

//
// NewRoleCertificate - creates an initialized RoleCertificate instance, returns a pointer to it
//
func NewRoleCertificate(init ...*RoleCertificate) *RoleCertificate {
	var o *RoleCertificate
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(RoleCertificate)
	}
	return o
}

type rawRoleCertificate RoleCertificate

//
// UnmarshalJSON is defined for proper JSON decoding of a RoleCertificate
//
func (self *RoleCertificate) UnmarshalJSON(b []byte) error {
	var m rawRoleCertificate
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := RoleCertificate(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *RoleCertificate) Validate() error {
	if self.X509Certificate == "" {
		return fmt.Errorf("RoleCertificate.x509Certificate is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.X509Certificate)
		if !val.Valid {
			return fmt.Errorf("RoleCertificate.x509Certificate does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// RoleCertificateRequest - RoleCertificateRequest - a certificate signing
// request. By including the optional previous Certificate NotBefore and
// NotAfter dates would all the server to correctly prioritize this request in
// case the certificate signer is under heavy load and it can't sign all
// submitted requests from the Athenz Server.
//
type RoleCertificateRequest struct {

	//
	// role certificate singing request
	//
	Csr string `json:"csr"`

	//
	// this request is proxy for this principal
	//
	ProxyForPrincipal EntityName `json:"proxyForPrincipal,omitempty" rdl:"optional"`

	//
	// request an expiry time for the role certificate
	//
	ExpiryTime int64 `json:"expiryTime"`

	//
	// previous role certificate not before date
	//
	PrevCertNotBefore *rdl.Timestamp `json:"prevCertNotBefore,omitempty" rdl:"optional"`

	//
	// previous role certificate not after date
	//
	PrevCertNotAfter *rdl.Timestamp `json:"prevCertNotAfter,omitempty" rdl:"optional"`
}

//
// NewRoleCertificateRequest - creates an initialized RoleCertificateRequest instance, returns a pointer to it
//
func NewRoleCertificateRequest(init ...*RoleCertificateRequest) *RoleCertificateRequest {
	var o *RoleCertificateRequest
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(RoleCertificateRequest)
	}
	return o
}

type rawRoleCertificateRequest RoleCertificateRequest

//
// UnmarshalJSON is defined for proper JSON decoding of a RoleCertificateRequest
//
func (self *RoleCertificateRequest) UnmarshalJSON(b []byte) error {
	var m rawRoleCertificateRequest
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := RoleCertificateRequest(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *RoleCertificateRequest) Validate() error {
	if self.Csr == "" {
		return fmt.Errorf("RoleCertificateRequest.csr is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Csr)
		if !val.Valid {
			return fmt.Errorf("RoleCertificateRequest.csr does not contain a valid String (%v)", val.Error)
		}
	}
	if self.ProxyForPrincipal != "" {
		val := rdl.Validate(ZTSSchema(), "EntityName", self.ProxyForPrincipal)
		if !val.Valid {
			return fmt.Errorf("RoleCertificateRequest.proxyForPrincipal does not contain a valid EntityName (%v)", val.Error)
		}
	}
	return nil
}

//
// RoleAccess -
//
type RoleAccess struct {
	Roles []EntityName `json:"roles"`
}

//
// NewRoleAccess - creates an initialized RoleAccess instance, returns a pointer to it
//
func NewRoleAccess(init ...*RoleAccess) *RoleAccess {
	var o *RoleAccess
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(RoleAccess)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *RoleAccess) Init() *RoleAccess {
	if self.Roles == nil {
		self.Roles = make([]EntityName, 0)
	}
	return self
}

type rawRoleAccess RoleAccess

//
// UnmarshalJSON is defined for proper JSON decoding of a RoleAccess
//
func (self *RoleAccess) UnmarshalJSON(b []byte) error {
	var m rawRoleAccess
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := RoleAccess(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *RoleAccess) Validate() error {
	if self.Roles == nil {
		return fmt.Errorf("RoleAccess: Missing required field: roles")
	}
	return nil
}

//
// RoleToken - A representation of a signed RoleToken
//
type RoleToken struct {
	Token      string `json:"token"`
	ExpiryTime int64  `json:"expiryTime"`
}

//
// NewRoleToken - creates an initialized RoleToken instance, returns a pointer to it
//
func NewRoleToken(init ...*RoleToken) *RoleToken {
	var o *RoleToken
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(RoleToken)
	}
	return o
}

type rawRoleToken RoleToken

//
// UnmarshalJSON is defined for proper JSON decoding of a RoleToken
//
func (self *RoleToken) UnmarshalJSON(b []byte) error {
	var m rawRoleToken
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := RoleToken(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *RoleToken) Validate() error {
	if self.Token == "" {
		return fmt.Errorf("RoleToken.token is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Token)
		if !val.Valid {
			return fmt.Errorf("RoleToken.token does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// Access - Access can be checked and returned as this resource.
//
type Access struct {

	//
	// true (allowed) or false (denied)
	//
	Granted bool `json:"granted"`
}

//
// NewAccess - creates an initialized Access instance, returns a pointer to it
//
func NewAccess(init ...*Access) *Access {
	var o *Access
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(Access)
	}
	return o
}

type rawAccess Access

//
// UnmarshalJSON is defined for proper JSON decoding of a Access
//
func (self *Access) UnmarshalJSON(b []byte) error {
	var m rawAccess
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := Access(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *Access) Validate() error {
	return nil
}

//
// TenantDomains -
//
type TenantDomains struct {
	TenantDomainNames []DomainName `json:"tenantDomainNames"`
}

//
// NewTenantDomains - creates an initialized TenantDomains instance, returns a pointer to it
//
func NewTenantDomains(init ...*TenantDomains) *TenantDomains {
	var o *TenantDomains
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(TenantDomains)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *TenantDomains) Init() *TenantDomains {
	if self.TenantDomainNames == nil {
		self.TenantDomainNames = make([]DomainName, 0)
	}
	return self
}

type rawTenantDomains TenantDomains

//
// UnmarshalJSON is defined for proper JSON decoding of a TenantDomains
//
func (self *TenantDomains) UnmarshalJSON(b []byte) error {
	var m rawTenantDomains
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := TenantDomains(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *TenantDomains) Validate() error {
	if self.TenantDomainNames == nil {
		return fmt.Errorf("TenantDomains: Missing required field: tenantDomainNames")
	}
	return nil
}

//
// Identity - Identity - a signed assertion of service or human identity, the
// response could be either a client certificate or just a regular NToken
// (depending if the request contained a csr or not).
//
type Identity struct {

	//
	// name of the identity, fully qualified, i.e. my.domain.service1, or
	// aws.1232321321312.myusername
	//
	Name CompoundName `json:"name"`

	//
	// a certificate usable for both client and server in TLS connections
	//
	Certificate string `json:"certificate,omitempty" rdl:"optional"`

	//
	// the CA certificate chain to use with all IMS-generated certs
	//
	CaCertBundle string `json:"caCertBundle,omitempty" rdl:"optional"`

	//
	// the SSH certificate, signed by the CA (user or host)
	//
	SshCertificate string `json:"sshCertificate,omitempty" rdl:"optional"`

	//
	// the SSH CA's public key for the sshCertificate (user or host)
	//
	SshCertificateSigner string `json:"sshCertificateSigner,omitempty" rdl:"optional"`

	//
	// service token instead of TLS certificate
	//
	ServiceToken SignedToken `json:"serviceToken,omitempty" rdl:"optional"`

	//
	// other config-like attributes determined at boot time
	//
	Attributes map[string]string `json:"attributes,omitempty" rdl:"optional"`
}

//
// NewIdentity - creates an initialized Identity instance, returns a pointer to it
//
func NewIdentity(init ...*Identity) *Identity {
	var o *Identity
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(Identity)
	}
	return o
}

type rawIdentity Identity

//
// UnmarshalJSON is defined for proper JSON decoding of a Identity
//
func (self *Identity) UnmarshalJSON(b []byte) error {
	var m rawIdentity
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := Identity(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *Identity) Validate() error {
	if self.Name == "" {
		return fmt.Errorf("Identity.name is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "CompoundName", self.Name)
		if !val.Valid {
			return fmt.Errorf("Identity.name does not contain a valid CompoundName (%v)", val.Error)
		}
	}
	if self.Certificate != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Certificate)
		if !val.Valid {
			return fmt.Errorf("Identity.certificate does not contain a valid String (%v)", val.Error)
		}
	}
	if self.CaCertBundle != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.CaCertBundle)
		if !val.Valid {
			return fmt.Errorf("Identity.caCertBundle does not contain a valid String (%v)", val.Error)
		}
	}
	if self.SshCertificate != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.SshCertificate)
		if !val.Valid {
			return fmt.Errorf("Identity.sshCertificate does not contain a valid String (%v)", val.Error)
		}
	}
	if self.SshCertificateSigner != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.SshCertificateSigner)
		if !val.Valid {
			return fmt.Errorf("Identity.sshCertificateSigner does not contain a valid String (%v)", val.Error)
		}
	}
	if self.ServiceToken != "" {
		val := rdl.Validate(ZTSSchema(), "SignedToken", self.ServiceToken)
		if !val.Valid {
			return fmt.Errorf("Identity.serviceToken does not contain a valid SignedToken (%v)", val.Error)
		}
	}
	return nil
}

//
// InstanceRefreshRequest - InstanceRefreshRequest - a certificate refresh
// request
//
type InstanceRefreshRequest struct {

	//
	// Cert CSR signed by the service's private key (public key registered in ZMS)
	//
	Csr string `json:"csr"`

	//
	// in minutes how long token should be valid for
	//
	ExpiryTime *int32 `json:"expiryTime,omitempty" rdl:"optional"`

	//
	// public key identifier
	//
	KeyId string `json:"keyId,omitempty" rdl:"optional"`
}

//
// NewInstanceRefreshRequest - creates an initialized InstanceRefreshRequest instance, returns a pointer to it
//
func NewInstanceRefreshRequest(init ...*InstanceRefreshRequest) *InstanceRefreshRequest {
	var o *InstanceRefreshRequest
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(InstanceRefreshRequest)
	}
	return o
}

type rawInstanceRefreshRequest InstanceRefreshRequest

//
// UnmarshalJSON is defined for proper JSON decoding of a InstanceRefreshRequest
//
func (self *InstanceRefreshRequest) UnmarshalJSON(b []byte) error {
	var m rawInstanceRefreshRequest
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := InstanceRefreshRequest(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *InstanceRefreshRequest) Validate() error {
	if self.Csr == "" {
		return fmt.Errorf("InstanceRefreshRequest.csr is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Csr)
		if !val.Valid {
			return fmt.Errorf("InstanceRefreshRequest.csr does not contain a valid String (%v)", val.Error)
		}
	}
	if self.KeyId != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.KeyId)
		if !val.Valid {
			return fmt.Errorf("InstanceRefreshRequest.keyId does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// AWSRoleName - AWS role name without the path
//
type AWSRoleName string

//
// AWSRolePathElement - AWS role path single element
//
type AWSRolePathElement string

//
// AWSRolePath - AWS role path
//
type AWSRolePath string

//
// AWSArnRoleName - AWS full role name with path
//
type AWSArnRoleName string

//
// AWSTemporaryCredentials -
//
type AWSTemporaryCredentials struct {
	AccessKeyId     string        `json:"accessKeyId"`
	SecretAccessKey string        `json:"secretAccessKey"`
	SessionToken    string        `json:"sessionToken"`
	Expiration      rdl.Timestamp `json:"expiration"`
}

//
// NewAWSTemporaryCredentials - creates an initialized AWSTemporaryCredentials instance, returns a pointer to it
//
func NewAWSTemporaryCredentials(init ...*AWSTemporaryCredentials) *AWSTemporaryCredentials {
	var o *AWSTemporaryCredentials
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(AWSTemporaryCredentials)
	}
	return o
}

type rawAWSTemporaryCredentials AWSTemporaryCredentials

//
// UnmarshalJSON is defined for proper JSON decoding of a AWSTemporaryCredentials
//
func (self *AWSTemporaryCredentials) UnmarshalJSON(b []byte) error {
	var m rawAWSTemporaryCredentials
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := AWSTemporaryCredentials(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *AWSTemporaryCredentials) Validate() error {
	if self.AccessKeyId == "" {
		return fmt.Errorf("AWSTemporaryCredentials.accessKeyId is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.AccessKeyId)
		if !val.Valid {
			return fmt.Errorf("AWSTemporaryCredentials.accessKeyId does not contain a valid String (%v)", val.Error)
		}
	}
	if self.SecretAccessKey == "" {
		return fmt.Errorf("AWSTemporaryCredentials.secretAccessKey is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.SecretAccessKey)
		if !val.Valid {
			return fmt.Errorf("AWSTemporaryCredentials.secretAccessKey does not contain a valid String (%v)", val.Error)
		}
	}
	if self.SessionToken == "" {
		return fmt.Errorf("AWSTemporaryCredentials.sessionToken is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.SessionToken)
		if !val.Valid {
			return fmt.Errorf("AWSTemporaryCredentials.sessionToken does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Expiration.IsZero() {
		return fmt.Errorf("AWSTemporaryCredentials: Missing required field: expiration")
	}
	return nil
}

//
// InstanceRegisterInformation -
//
type InstanceRegisterInformation struct {

	//
	// the provider service name (i.e. "aws.us-west-2", "sys.openstack.cluster1")
	//
	Provider ServiceName `json:"provider"`

	//
	// the domain of the instance
	//
	Domain DomainName `json:"domain"`

	//
	// the service this instance is supposed to run
	//
	Service SimpleName `json:"service"`

	//
	// identity attestation data including document with its signature containing
	// attributes like IP address, instance-id, account#, etc.
	//
	AttestationData string `json:"attestationData"`

	//
	// the Certificate Signing Request for the expected X.509 certificate in the
	// response
	//
	Csr string `json:"csr"`

	//
	// if present, return an SSH host certificate. Format is JSON.
	//
	Ssh string `json:"ssh,omitempty" rdl:"optional"`

	//
	// if true, return a service token signed by ZTS for this service
	//
	Token *bool `json:"token,omitempty" rdl:"optional"`

	//
	// expiry time in minutes for the certificate (server enforces max expiry)
	//
	ExpiryTime *int32 `json:"expiryTime,omitempty" rdl:"optional"`

	//
	// optional hostname in case included in the csr SAN dnsName attribute
	//
	Hostname DomainName `json:"hostname,omitempty" rdl:"optional"`

	//
	// optional host CNAMEs included in the csr SAN dnsName attribute
	//
	HostCnames []DomainName `json:"hostCnames,omitempty" rdl:"optional"`
}

//
// NewInstanceRegisterInformation - creates an initialized InstanceRegisterInformation instance, returns a pointer to it
//
func NewInstanceRegisterInformation(init ...*InstanceRegisterInformation) *InstanceRegisterInformation {
	var o *InstanceRegisterInformation
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(InstanceRegisterInformation)
	}
	return o
}

type rawInstanceRegisterInformation InstanceRegisterInformation

//
// UnmarshalJSON is defined for proper JSON decoding of a InstanceRegisterInformation
//
func (self *InstanceRegisterInformation) UnmarshalJSON(b []byte) error {
	var m rawInstanceRegisterInformation
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := InstanceRegisterInformation(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *InstanceRegisterInformation) Validate() error {
	if self.Provider == "" {
		return fmt.Errorf("InstanceRegisterInformation.provider is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "ServiceName", self.Provider)
		if !val.Valid {
			return fmt.Errorf("InstanceRegisterInformation.provider does not contain a valid ServiceName (%v)", val.Error)
		}
	}
	if self.Domain == "" {
		return fmt.Errorf("InstanceRegisterInformation.domain is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "DomainName", self.Domain)
		if !val.Valid {
			return fmt.Errorf("InstanceRegisterInformation.domain does not contain a valid DomainName (%v)", val.Error)
		}
	}
	if self.Service == "" {
		return fmt.Errorf("InstanceRegisterInformation.service is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "SimpleName", self.Service)
		if !val.Valid {
			return fmt.Errorf("InstanceRegisterInformation.service does not contain a valid SimpleName (%v)", val.Error)
		}
	}
	if self.AttestationData == "" {
		return fmt.Errorf("InstanceRegisterInformation.attestationData is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.AttestationData)
		if !val.Valid {
			return fmt.Errorf("InstanceRegisterInformation.attestationData does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Csr == "" {
		return fmt.Errorf("InstanceRegisterInformation.csr is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Csr)
		if !val.Valid {
			return fmt.Errorf("InstanceRegisterInformation.csr does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Ssh != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Ssh)
		if !val.Valid {
			return fmt.Errorf("InstanceRegisterInformation.ssh does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Hostname != "" {
		val := rdl.Validate(ZTSSchema(), "DomainName", self.Hostname)
		if !val.Valid {
			return fmt.Errorf("InstanceRegisterInformation.hostname does not contain a valid DomainName (%v)", val.Error)
		}
	}
	return nil
}

//
// InstanceRefreshInformation -
//
type InstanceRefreshInformation struct {

	//
	// identity attestation data including document with its signature containing
	// attributes like IP address, instance-id, account#, etc.
	//
	AttestationData string `json:"attestationData,omitempty" rdl:"optional"`

	//
	// the Certificate Signing Request for the expected X.509 certificate in the
	// response
	//
	Csr string `json:"csr,omitempty" rdl:"optional"`

	//
	// if present, return an SSH host certificate. Format is JSON.
	//
	Ssh string `json:"ssh,omitempty" rdl:"optional"`

	//
	// if true, return a service token signed by ZTS for this service
	//
	Token *bool `json:"token,omitempty" rdl:"optional"`

	//
	// expiry time in minutes for the certificate (server enforces max expiry)
	//
	ExpiryTime *int32 `json:"expiryTime,omitempty" rdl:"optional"`

	//
	// optional hostname in case included in the csr SAN dnsName attribute
	//
	Hostname DomainName `json:"hostname,omitempty" rdl:"optional"`

	//
	// optional host CNAMEs included in the csr SAN dnsName attribute
	//
	HostCnames []DomainName `json:"hostCnames,omitempty" rdl:"optional"`
}

//
// NewInstanceRefreshInformation - creates an initialized InstanceRefreshInformation instance, returns a pointer to it
//
func NewInstanceRefreshInformation(init ...*InstanceRefreshInformation) *InstanceRefreshInformation {
	var o *InstanceRefreshInformation
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(InstanceRefreshInformation)
	}
	return o
}

type rawInstanceRefreshInformation InstanceRefreshInformation

//
// UnmarshalJSON is defined for proper JSON decoding of a InstanceRefreshInformation
//
func (self *InstanceRefreshInformation) UnmarshalJSON(b []byte) error {
	var m rawInstanceRefreshInformation
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := InstanceRefreshInformation(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *InstanceRefreshInformation) Validate() error {
	if self.AttestationData != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.AttestationData)
		if !val.Valid {
			return fmt.Errorf("InstanceRefreshInformation.attestationData does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Csr != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Csr)
		if !val.Valid {
			return fmt.Errorf("InstanceRefreshInformation.csr does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Ssh != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Ssh)
		if !val.Valid {
			return fmt.Errorf("InstanceRefreshInformation.ssh does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Hostname != "" {
		val := rdl.Validate(ZTSSchema(), "DomainName", self.Hostname)
		if !val.Valid {
			return fmt.Errorf("InstanceRefreshInformation.hostname does not contain a valid DomainName (%v)", val.Error)
		}
	}
	return nil
}

//
// InstanceRegisterToken -
//
type InstanceRegisterToken struct {

	//
	// provider service name
	//
	Provider ServiceName `json:"provider"`

	//
	// the domain of the instance
	//
	Domain DomainName `json:"domain"`

	//
	// the service this instance is supposed to run
	//
	Service SimpleName `json:"service"`

	//
	// identity attestation data including document with its signature containing
	// attributes like IP address, instance-id, account#, etc.
	//
	AttestationData string `json:"attestationData"`

	//
	// additional non-signed attributes that assist in attestation. I.e. "keyId",
	// "accessKey", etc
	//
	Attributes map[string]string `json:"attributes,omitempty" rdl:"optional"`
}

//
// NewInstanceRegisterToken - creates an initialized InstanceRegisterToken instance, returns a pointer to it
//
func NewInstanceRegisterToken(init ...*InstanceRegisterToken) *InstanceRegisterToken {
	var o *InstanceRegisterToken
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(InstanceRegisterToken)
	}
	return o
}

type rawInstanceRegisterToken InstanceRegisterToken

//
// UnmarshalJSON is defined for proper JSON decoding of a InstanceRegisterToken
//
func (self *InstanceRegisterToken) UnmarshalJSON(b []byte) error {
	var m rawInstanceRegisterToken
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := InstanceRegisterToken(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *InstanceRegisterToken) Validate() error {
	if self.Provider == "" {
		return fmt.Errorf("InstanceRegisterToken.provider is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "ServiceName", self.Provider)
		if !val.Valid {
			return fmt.Errorf("InstanceRegisterToken.provider does not contain a valid ServiceName (%v)", val.Error)
		}
	}
	if self.Domain == "" {
		return fmt.Errorf("InstanceRegisterToken.domain is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "DomainName", self.Domain)
		if !val.Valid {
			return fmt.Errorf("InstanceRegisterToken.domain does not contain a valid DomainName (%v)", val.Error)
		}
	}
	if self.Service == "" {
		return fmt.Errorf("InstanceRegisterToken.service is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "SimpleName", self.Service)
		if !val.Valid {
			return fmt.Errorf("InstanceRegisterToken.service does not contain a valid SimpleName (%v)", val.Error)
		}
	}
	if self.AttestationData == "" {
		return fmt.Errorf("InstanceRegisterToken.attestationData is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.AttestationData)
		if !val.Valid {
			return fmt.Errorf("InstanceRegisterToken.attestationData does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// InstanceIdentity -
//
type InstanceIdentity struct {

	//
	// the provider service name (i.e. "aws.us-west-2", "sys.openstack.cluster1")
	//
	Provider ServiceName `json:"provider"`

	//
	// name of the identity, fully qualified, i.e. my.domain.service1
	//
	Name ServiceName `json:"name"`

	//
	// unique instance id within provider's namespace
	//
	InstanceId PathElement `json:"instanceId"`

	//
	// an X.509 certificate usable for both client and server in TLS connections
	//
	X509Certificate string `json:"x509Certificate,omitempty" rdl:"optional"`

	//
	// the CA certificate chain to verify all generated X.509 certs
	//
	X509CertificateSigner string `json:"x509CertificateSigner,omitempty" rdl:"optional"`

	//
	// the SSH certificate, signed by the CA (user or host)
	//
	SshCertificate string `json:"sshCertificate,omitempty" rdl:"optional"`

	//
	// the SSH CA's public key for the sshCertificate (user or host)
	//
	SshCertificateSigner string `json:"sshCertificateSigner,omitempty" rdl:"optional"`

	//
	// service token instead of TLS certificate
	//
	ServiceToken SignedToken `json:"serviceToken,omitempty" rdl:"optional"`

	//
	// other config-like attributes determined at boot time
	//
	Attributes map[string]string `json:"attributes,omitempty" rdl:"optional"`
}

//
// NewInstanceIdentity - creates an initialized InstanceIdentity instance, returns a pointer to it
//
func NewInstanceIdentity(init ...*InstanceIdentity) *InstanceIdentity {
	var o *InstanceIdentity
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(InstanceIdentity)
	}
	return o
}

type rawInstanceIdentity InstanceIdentity

//
// UnmarshalJSON is defined for proper JSON decoding of a InstanceIdentity
//
func (self *InstanceIdentity) UnmarshalJSON(b []byte) error {
	var m rawInstanceIdentity
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := InstanceIdentity(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *InstanceIdentity) Validate() error {
	if self.Provider == "" {
		return fmt.Errorf("InstanceIdentity.provider is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "ServiceName", self.Provider)
		if !val.Valid {
			return fmt.Errorf("InstanceIdentity.provider does not contain a valid ServiceName (%v)", val.Error)
		}
	}
	if self.Name == "" {
		return fmt.Errorf("InstanceIdentity.name is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "ServiceName", self.Name)
		if !val.Valid {
			return fmt.Errorf("InstanceIdentity.name does not contain a valid ServiceName (%v)", val.Error)
		}
	}
	if self.InstanceId == "" {
		return fmt.Errorf("InstanceIdentity.instanceId is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "PathElement", self.InstanceId)
		if !val.Valid {
			return fmt.Errorf("InstanceIdentity.instanceId does not contain a valid PathElement (%v)", val.Error)
		}
	}
	if self.X509Certificate != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.X509Certificate)
		if !val.Valid {
			return fmt.Errorf("InstanceIdentity.x509Certificate does not contain a valid String (%v)", val.Error)
		}
	}
	if self.X509CertificateSigner != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.X509CertificateSigner)
		if !val.Valid {
			return fmt.Errorf("InstanceIdentity.x509CertificateSigner does not contain a valid String (%v)", val.Error)
		}
	}
	if self.SshCertificate != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.SshCertificate)
		if !val.Valid {
			return fmt.Errorf("InstanceIdentity.sshCertificate does not contain a valid String (%v)", val.Error)
		}
	}
	if self.SshCertificateSigner != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.SshCertificateSigner)
		if !val.Valid {
			return fmt.Errorf("InstanceIdentity.sshCertificateSigner does not contain a valid String (%v)", val.Error)
		}
	}
	if self.ServiceToken != "" {
		val := rdl.Validate(ZTSSchema(), "SignedToken", self.ServiceToken)
		if !val.Valid {
			return fmt.Errorf("InstanceIdentity.serviceToken does not contain a valid SignedToken (%v)", val.Error)
		}
	}
	return nil
}

//
// CertificateAuthorityBundle -
//
type CertificateAuthorityBundle struct {

	//
	// name of the bundle
	//
	Name SimpleName `json:"name"`

	//
	// set of certificates included in the bundle
	//
	Certs string `json:"certs"`
}

//
// NewCertificateAuthorityBundle - creates an initialized CertificateAuthorityBundle instance, returns a pointer to it
//
func NewCertificateAuthorityBundle(init ...*CertificateAuthorityBundle) *CertificateAuthorityBundle {
	var o *CertificateAuthorityBundle
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(CertificateAuthorityBundle)
	}
	return o
}

type rawCertificateAuthorityBundle CertificateAuthorityBundle

//
// UnmarshalJSON is defined for proper JSON decoding of a CertificateAuthorityBundle
//
func (self *CertificateAuthorityBundle) UnmarshalJSON(b []byte) error {
	var m rawCertificateAuthorityBundle
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := CertificateAuthorityBundle(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *CertificateAuthorityBundle) Validate() error {
	if self.Name == "" {
		return fmt.Errorf("CertificateAuthorityBundle.name is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "SimpleName", self.Name)
		if !val.Valid {
			return fmt.Errorf("CertificateAuthorityBundle.name does not contain a valid SimpleName (%v)", val.Error)
		}
	}
	if self.Certs == "" {
		return fmt.Errorf("CertificateAuthorityBundle.certs is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Certs)
		if !val.Valid {
			return fmt.Errorf("CertificateAuthorityBundle.certs does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// DomainMetricType - zpe metric attributes
//
type DomainMetricType int

//
// DomainMetricType constants
//
const (
	_ DomainMetricType = iota
	ACCESS_ALLOWED
	ACCESS_ALLOWED_DENY
	ACCESS_ALLOWED_DENY_NO_MATCH
	ACCESS_ALLOWED_ALLOW
	ACCESS_ALLOWED_ERROR
	ACCESS_ALLOWED_TOKEN_INVALID
	ACCESS_Allowed_TOKEN_EXPIRED
	ACCESS_ALLOWED_DOMAIN_NOT_FOUND
	ACCESS_ALLOWED_DOMAIN_MISMATCH
	ACCESS_ALLOWED_DOMAIN_EXPIRED
	ACCESS_ALLOWED_DOMAIN_EMPTY
	ACCESS_ALLOWED_TOKEN_CACHE_FAILURE
	ACCESS_ALLOWED_TOKEN_CACHE_NOT_FOUND
	ACCESS_ALLOWED_TOKEN_CACHE_SUCCESS
	ACCESS_ALLOWED_TOKEN_VALIDATE
	LOAD_FILE_FAIL
	LOAD_FILE_GOOD
	LOAD_DOMAIN_GOOD
)

var namesDomainMetricType = []string{
	ACCESS_ALLOWED:                       "ACCESS_ALLOWED",
	ACCESS_ALLOWED_DENY:                  "ACCESS_ALLOWED_DENY",
	ACCESS_ALLOWED_DENY_NO_MATCH:         "ACCESS_ALLOWED_DENY_NO_MATCH",
	ACCESS_ALLOWED_ALLOW:                 "ACCESS_ALLOWED_ALLOW",
	ACCESS_ALLOWED_ERROR:                 "ACCESS_ALLOWED_ERROR",
	ACCESS_ALLOWED_TOKEN_INVALID:         "ACCESS_ALLOWED_TOKEN_INVALID",
	ACCESS_Allowed_TOKEN_EXPIRED:         "ACCESS_Allowed_TOKEN_EXPIRED",
	ACCESS_ALLOWED_DOMAIN_NOT_FOUND:      "ACCESS_ALLOWED_DOMAIN_NOT_FOUND",
	ACCESS_ALLOWED_DOMAIN_MISMATCH:       "ACCESS_ALLOWED_DOMAIN_MISMATCH",
	ACCESS_ALLOWED_DOMAIN_EXPIRED:        "ACCESS_ALLOWED_DOMAIN_EXPIRED",
	ACCESS_ALLOWED_DOMAIN_EMPTY:          "ACCESS_ALLOWED_DOMAIN_EMPTY",
	ACCESS_ALLOWED_TOKEN_CACHE_FAILURE:   "ACCESS_ALLOWED_TOKEN_CACHE_FAILURE",
	ACCESS_ALLOWED_TOKEN_CACHE_NOT_FOUND: "ACCESS_ALLOWED_TOKEN_CACHE_NOT_FOUND",
	ACCESS_ALLOWED_TOKEN_CACHE_SUCCESS:   "ACCESS_ALLOWED_TOKEN_CACHE_SUCCESS",
	ACCESS_ALLOWED_TOKEN_VALIDATE:        "ACCESS_ALLOWED_TOKEN_VALIDATE",
	LOAD_FILE_FAIL:                       "LOAD_FILE_FAIL",
	LOAD_FILE_GOOD:                       "LOAD_FILE_GOOD",
	LOAD_DOMAIN_GOOD:                     "LOAD_DOMAIN_GOOD",
}

//
// NewDomainMetricType - return a string representation of the enum
//
func NewDomainMetricType(init ...interface{}) DomainMetricType {
	if len(init) == 1 {
		switch v := init[0].(type) {
		case DomainMetricType:
			return v
		case int:
			return DomainMetricType(v)
		case int32:
			return DomainMetricType(v)
		case string:
			for i, s := range namesDomainMetricType {
				if s == v {
					return DomainMetricType(i)
				}
			}
		default:
			panic("Bad init value for DomainMetricType enum")
		}
	}
	return DomainMetricType(0) //default to the first enum value
}

//
// String - return a string representation of the enum
//
func (e DomainMetricType) String() string {
	return namesDomainMetricType[e]
}

//
// SymbolSet - return an array of all valid string representations (symbols) of the enum
//
func (e DomainMetricType) SymbolSet() []string {
	return namesDomainMetricType
}

//
// MarshalJSON is defined for proper JSON encoding of a DomainMetricType
//
func (e DomainMetricType) MarshalJSON() ([]byte, error) {
	return json.Marshal(e.String())
}

//
// UnmarshalJSON is defined for proper JSON decoding of a DomainMetricType
//
func (e *DomainMetricType) UnmarshalJSON(b []byte) error {
	var j string
	err := json.Unmarshal(b, &j)
	if err == nil {
		s := string(j)
		for v, s2 := range namesDomainMetricType {
			if s == s2 {
				*e = DomainMetricType(v)
				return nil
			}
		}
		err = fmt.Errorf("Bad enum symbol for type DomainMetricType: %s", s)
	}
	return err
}

//
// DomainMetric -
//
type DomainMetric struct {
	MetricType DomainMetricType `json:"metricType"`
	MetricVal  int32            `json:"metricVal"`
}

//
// NewDomainMetric - creates an initialized DomainMetric instance, returns a pointer to it
//
func NewDomainMetric(init ...*DomainMetric) *DomainMetric {
	var o *DomainMetric
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(DomainMetric)
	}
	return o
}

type rawDomainMetric DomainMetric

//
// UnmarshalJSON is defined for proper JSON decoding of a DomainMetric
//
func (self *DomainMetric) UnmarshalJSON(b []byte) error {
	var m rawDomainMetric
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := DomainMetric(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *DomainMetric) Validate() error {
	return nil
}

//
// DomainMetrics -
//
type DomainMetrics struct {

	//
	// name of the domain the metrics pertain to
	//
	DomainName DomainName `json:"domainName"`

	//
	// list of the domains metrics
	//
	MetricList []*DomainMetric `json:"metricList"`
}

//
// NewDomainMetrics - creates an initialized DomainMetrics instance, returns a pointer to it
//
func NewDomainMetrics(init ...*DomainMetrics) *DomainMetrics {
	var o *DomainMetrics
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(DomainMetrics)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *DomainMetrics) Init() *DomainMetrics {
	if self.MetricList == nil {
		self.MetricList = make([]*DomainMetric, 0)
	}
	return self
}

type rawDomainMetrics DomainMetrics

//
// UnmarshalJSON is defined for proper JSON decoding of a DomainMetrics
//
func (self *DomainMetrics) UnmarshalJSON(b []byte) error {
	var m rawDomainMetrics
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := DomainMetrics(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *DomainMetrics) Validate() error {
	if self.DomainName == "" {
		return fmt.Errorf("DomainMetrics.domainName is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "DomainName", self.DomainName)
		if !val.Valid {
			return fmt.Errorf("DomainMetrics.domainName does not contain a valid DomainName (%v)", val.Error)
		}
	}
	if self.MetricList == nil {
		return fmt.Errorf("DomainMetrics: Missing required field: metricList")
	}
	return nil
}

//
// Status - The representation for a status object
//
type Status struct {

	//
	// status message code
	//
	Code int32 `json:"code"`

	//
	// status message of the server
	//
	Message string `json:"message"`
}

//
// NewStatus - creates an initialized Status instance, returns a pointer to it
//
func NewStatus(init ...*Status) *Status {
	var o *Status
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(Status)
	}
	return o
}

type rawStatus Status

//
// UnmarshalJSON is defined for proper JSON decoding of a Status
//
func (self *Status) UnmarshalJSON(b []byte) error {
	var m rawStatus
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := Status(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *Status) Validate() error {
	if self.Message == "" {
		return fmt.Errorf("Status.message is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Message)
		if !val.Valid {
			return fmt.Errorf("Status.message does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// SSHCertRequestData -
//
type SSHCertRequestData struct {

	//
	// principals in the ssh certificate (usually only one)
	//
	Principals []string `json:"principals"`

	//
	// source FQDNs or ip addresses
	//
	Sources []string `json:"sources,omitempty" rdl:"optional"`

	//
	// destination FQDNs or ip addresses
	//
	Destinations []string `json:"destinations,omitempty" rdl:"optional"`

	//
	// public key for ssh certificate
	//
	PublicKey string `json:"publicKey,omitempty" rdl:"optional"`

	//
	// yubikey/touch public key for ssh certificate
	//
	TouchPublicKey string `json:"touchPublicKey,omitempty" rdl:"optional"`
}

//
// NewSSHCertRequestData - creates an initialized SSHCertRequestData instance, returns a pointer to it
//
func NewSSHCertRequestData(init ...*SSHCertRequestData) *SSHCertRequestData {
	var o *SSHCertRequestData
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(SSHCertRequestData)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *SSHCertRequestData) Init() *SSHCertRequestData {
	if self.Principals == nil {
		self.Principals = make([]string, 0)
	}
	return self
}

type rawSSHCertRequestData SSHCertRequestData

//
// UnmarshalJSON is defined for proper JSON decoding of a SSHCertRequestData
//
func (self *SSHCertRequestData) UnmarshalJSON(b []byte) error {
	var m rawSSHCertRequestData
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := SSHCertRequestData(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *SSHCertRequestData) Validate() error {
	if self.Principals == nil {
		return fmt.Errorf("SSHCertRequestData: Missing required field: principals")
	}
	if self.PublicKey != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.PublicKey)
		if !val.Valid {
			return fmt.Errorf("SSHCertRequestData.publicKey does not contain a valid String (%v)", val.Error)
		}
	}
	if self.TouchPublicKey != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.TouchPublicKey)
		if !val.Valid {
			return fmt.Errorf("SSHCertRequestData.touchPublicKey does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// SSHCertRequestMeta -
//
type SSHCertRequestMeta struct {

	//
	// requesting user
	//
	Requestor string `json:"requestor"`

	//
	// origin FQDN or ip
	//
	Origin string `json:"origin"`

	//
	// client info
	//
	ClientInfo string `json:"clientInfo,omitempty" rdl:"optional"`

	//
	// ssh client version
	//
	SshClientVersion string `json:"sshClientVersion,omitempty" rdl:"optional"`

	//
	// cert type - user or host
	//
	CertType string `json:"certType"`

	//
	// ssh host cert request is for this athenz service
	//
	AthenzService EntityName `json:"athenzService,omitempty" rdl:"optional"`

	//
	// ssh host cert request is for this instance id
	//
	InstanceId PathElement `json:"instanceId,omitempty" rdl:"optional"`

	//
	// previous ssh certificate validity from date
	//
	PrevCertValidFrom *rdl.Timestamp `json:"prevCertValidFrom,omitempty" rdl:"optional"`

	//
	// previous ssh certificate validity to date
	//
	PrevCertValidTo *rdl.Timestamp `json:"prevCertValidTo,omitempty" rdl:"optional"`
}

//
// NewSSHCertRequestMeta - creates an initialized SSHCertRequestMeta instance, returns a pointer to it
//
func NewSSHCertRequestMeta(init ...*SSHCertRequestMeta) *SSHCertRequestMeta {
	var o *SSHCertRequestMeta
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(SSHCertRequestMeta)
	}
	return o
}

type rawSSHCertRequestMeta SSHCertRequestMeta

//
// UnmarshalJSON is defined for proper JSON decoding of a SSHCertRequestMeta
//
func (self *SSHCertRequestMeta) UnmarshalJSON(b []byte) error {
	var m rawSSHCertRequestMeta
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := SSHCertRequestMeta(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *SSHCertRequestMeta) Validate() error {
	if self.Requestor == "" {
		return fmt.Errorf("SSHCertRequestMeta.requestor is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Requestor)
		if !val.Valid {
			return fmt.Errorf("SSHCertRequestMeta.requestor does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Origin == "" {
		return fmt.Errorf("SSHCertRequestMeta.origin is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Origin)
		if !val.Valid {
			return fmt.Errorf("SSHCertRequestMeta.origin does not contain a valid String (%v)", val.Error)
		}
	}
	if self.ClientInfo != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.ClientInfo)
		if !val.Valid {
			return fmt.Errorf("SSHCertRequestMeta.clientInfo does not contain a valid String (%v)", val.Error)
		}
	}
	if self.SshClientVersion != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.SshClientVersion)
		if !val.Valid {
			return fmt.Errorf("SSHCertRequestMeta.sshClientVersion does not contain a valid String (%v)", val.Error)
		}
	}
	if self.CertType == "" {
		return fmt.Errorf("SSHCertRequestMeta.certType is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.CertType)
		if !val.Valid {
			return fmt.Errorf("SSHCertRequestMeta.certType does not contain a valid String (%v)", val.Error)
		}
	}
	if self.AthenzService != "" {
		val := rdl.Validate(ZTSSchema(), "EntityName", self.AthenzService)
		if !val.Valid {
			return fmt.Errorf("SSHCertRequestMeta.athenzService does not contain a valid EntityName (%v)", val.Error)
		}
	}
	if self.InstanceId != "" {
		val := rdl.Validate(ZTSSchema(), "PathElement", self.InstanceId)
		if !val.Valid {
			return fmt.Errorf("SSHCertRequestMeta.instanceId does not contain a valid PathElement (%v)", val.Error)
		}
	}
	return nil
}

//
// SSHCertRequest -
//
type SSHCertRequest struct {

	//
	// ssh certificate request data
	//
	CertRequestData *SSHCertRequestData `json:"certRequestData"`

	//
	// ssh certificate request meta
	//
	CertRequestMeta *SSHCertRequestMeta `json:"certRequestMeta"`

	//
	// free-form csr if not using data/meta fields.
	//
	Csr string `json:"csr,omitempty" rdl:"optional"`
}

//
// NewSSHCertRequest - creates an initialized SSHCertRequest instance, returns a pointer to it
//
func NewSSHCertRequest(init ...*SSHCertRequest) *SSHCertRequest {
	var o *SSHCertRequest
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(SSHCertRequest)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *SSHCertRequest) Init() *SSHCertRequest {
	if self.CertRequestData == nil {
		self.CertRequestData = NewSSHCertRequestData()
	}
	if self.CertRequestMeta == nil {
		self.CertRequestMeta = NewSSHCertRequestMeta()
	}
	return self
}

type rawSSHCertRequest SSHCertRequest

//
// UnmarshalJSON is defined for proper JSON decoding of a SSHCertRequest
//
func (self *SSHCertRequest) UnmarshalJSON(b []byte) error {
	var m rawSSHCertRequest
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := SSHCertRequest(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *SSHCertRequest) Validate() error {
	if self.CertRequestData == nil {
		return fmt.Errorf("SSHCertRequest: Missing required field: certRequestData")
	}
	if self.CertRequestMeta == nil {
		return fmt.Errorf("SSHCertRequest: Missing required field: certRequestMeta")
	}
	if self.Csr != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Csr)
		if !val.Valid {
			return fmt.Errorf("SSHCertRequest.csr does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// SSHCertificate -
//
type SSHCertificate struct {

	//
	// the SSH certificate, signed by the CA
	//
	Certificate string `json:"certificate"`

	//
	// certificate public key if generated by SSH RA
	//
	PublicKey string `json:"publicKey,omitempty" rdl:"optional"`

	//
	// certificate private key if generated by SSH Agent
	//
	PrivateKey string `json:"privateKey,omitempty" rdl:"optional"`
}

//
// NewSSHCertificate - creates an initialized SSHCertificate instance, returns a pointer to it
//
func NewSSHCertificate(init ...*SSHCertificate) *SSHCertificate {
	var o *SSHCertificate
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(SSHCertificate)
	}
	return o
}

type rawSSHCertificate SSHCertificate

//
// UnmarshalJSON is defined for proper JSON decoding of a SSHCertificate
//
func (self *SSHCertificate) UnmarshalJSON(b []byte) error {
	var m rawSSHCertificate
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := SSHCertificate(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *SSHCertificate) Validate() error {
	if self.Certificate == "" {
		return fmt.Errorf("SSHCertificate.certificate is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Certificate)
		if !val.Valid {
			return fmt.Errorf("SSHCertificate.certificate does not contain a valid String (%v)", val.Error)
		}
	}
	if self.PublicKey != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.PublicKey)
		if !val.Valid {
			return fmt.Errorf("SSHCertificate.publicKey does not contain a valid String (%v)", val.Error)
		}
	}
	if self.PrivateKey != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.PrivateKey)
		if !val.Valid {
			return fmt.Errorf("SSHCertificate.privateKey does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// SSHCertificates -
//
type SSHCertificates struct {

	//
	// set of user ssh certificates
	//
	Certificates []*SSHCertificate `json:"certificates"`

	//
	// the SSH CA's public key for the sshCertificate (user or host)
	//
	CertificateSigner string `json:"certificateSigner,omitempty" rdl:"optional"`
}

//
// NewSSHCertificates - creates an initialized SSHCertificates instance, returns a pointer to it
//
func NewSSHCertificates(init ...*SSHCertificates) *SSHCertificates {
	var o *SSHCertificates
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(SSHCertificates)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *SSHCertificates) Init() *SSHCertificates {
	if self.Certificates == nil {
		self.Certificates = make([]*SSHCertificate, 0)
	}
	return self
}

type rawSSHCertificates SSHCertificates

//
// UnmarshalJSON is defined for proper JSON decoding of a SSHCertificates
//
func (self *SSHCertificates) UnmarshalJSON(b []byte) error {
	var m rawSSHCertificates
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := SSHCertificates(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *SSHCertificates) Validate() error {
	if self.Certificates == nil {
		return fmt.Errorf("SSHCertificates: Missing required field: certificates")
	}
	if self.CertificateSigner != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.CertificateSigner)
		if !val.Valid {
			return fmt.Errorf("SSHCertificates.certificateSigner does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// AccessTokenResponse -
//
type AccessTokenResponse struct {

	//
	// access token
	//
	Access_token string `json:"access_token"`

	//
	// token type e.g. Bearer
	//
	Token_type string `json:"token_type"`

	//
	// expiration in seconds
	//
	Expires_in *int32 `json:"expires_in,omitempty" rdl:"optional"`

	//
	// scope of the access token e.g. openid
	//
	Scope string `json:"scope,omitempty" rdl:"optional"`

	//
	// refresh token
	//
	Refresh_token string `json:"refresh_token,omitempty" rdl:"optional"`

	//
	// id token
	//
	Id_token string `json:"id_token,omitempty" rdl:"optional"`
}

//
// NewAccessTokenResponse - creates an initialized AccessTokenResponse instance, returns a pointer to it
//
func NewAccessTokenResponse(init ...*AccessTokenResponse) *AccessTokenResponse {
	var o *AccessTokenResponse
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(AccessTokenResponse)
	}
	return o
}

type rawAccessTokenResponse AccessTokenResponse

//
// UnmarshalJSON is defined for proper JSON decoding of a AccessTokenResponse
//
func (self *AccessTokenResponse) UnmarshalJSON(b []byte) error {
	var m rawAccessTokenResponse
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := AccessTokenResponse(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *AccessTokenResponse) Validate() error {
	if self.Access_token == "" {
		return fmt.Errorf("AccessTokenResponse.access_token is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Access_token)
		if !val.Valid {
			return fmt.Errorf("AccessTokenResponse.access_token does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Token_type == "" {
		return fmt.Errorf("AccessTokenResponse.token_type is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Token_type)
		if !val.Valid {
			return fmt.Errorf("AccessTokenResponse.token_type does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Scope != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Scope)
		if !val.Valid {
			return fmt.Errorf("AccessTokenResponse.scope does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Refresh_token != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Refresh_token)
		if !val.Valid {
			return fmt.Errorf("AccessTokenResponse.refresh_token does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Id_token != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Id_token)
		if !val.Valid {
			return fmt.Errorf("AccessTokenResponse.id_token does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// JWK -
//
type JWK struct {

	//
	// key type: EC or RSA
	//
	Kty string `json:"kty"`

	//
	// identifier
	//
	Kid string `json:"kid"`

	//
	// key algorithm
	//
	Alg string `json:"alg,omitempty" rdl:"optional"`

	//
	// usage: sig or enc
	//
	Use string `json:"use,omitempty" rdl:"optional"`

	//
	// ec curve name
	//
	Crv string `json:"crv,omitempty" rdl:"optional"`

	//
	// ec x value
	//
	X string `json:"x,omitempty" rdl:"optional"`

	//
	// ec y value
	//
	Y string `json:"y,omitempty" rdl:"optional"`

	//
	// rsa modulus value
	//
	N string `json:"n,omitempty" rdl:"optional"`

	//
	// rsa public exponent value
	//
	E string `json:"e,omitempty" rdl:"optional"`
}

//
// NewJWK - creates an initialized JWK instance, returns a pointer to it
//
func NewJWK(init ...*JWK) *JWK {
	var o *JWK
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(JWK)
	}
	return o
}

type rawJWK JWK

//
// UnmarshalJSON is defined for proper JSON decoding of a JWK
//
func (self *JWK) UnmarshalJSON(b []byte) error {
	var m rawJWK
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := JWK(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *JWK) Validate() error {
	if self.Kty == "" {
		return fmt.Errorf("JWK.kty is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Kty)
		if !val.Valid {
			return fmt.Errorf("JWK.kty does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Kid == "" {
		return fmt.Errorf("JWK.kid is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Kid)
		if !val.Valid {
			return fmt.Errorf("JWK.kid does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Alg != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Alg)
		if !val.Valid {
			return fmt.Errorf("JWK.alg does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Use != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Use)
		if !val.Valid {
			return fmt.Errorf("JWK.use does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Crv != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Crv)
		if !val.Valid {
			return fmt.Errorf("JWK.crv does not contain a valid String (%v)", val.Error)
		}
	}
	if self.X != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.X)
		if !val.Valid {
			return fmt.Errorf("JWK.x does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Y != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.Y)
		if !val.Valid {
			return fmt.Errorf("JWK.y does not contain a valid String (%v)", val.Error)
		}
	}
	if self.N != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.N)
		if !val.Valid {
			return fmt.Errorf("JWK.n does not contain a valid String (%v)", val.Error)
		}
	}
	if self.E != "" {
		val := rdl.Validate(ZTSSchema(), "String", self.E)
		if !val.Valid {
			return fmt.Errorf("JWK.e does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// JWKList - JSON Web Key (JWK) List
//
type JWKList struct {

	//
	// array of JWKs
	//
	Keys []*JWK `json:"keys"`
}

//
// NewJWKList - creates an initialized JWKList instance, returns a pointer to it
//
func NewJWKList(init ...*JWKList) *JWKList {
	var o *JWKList
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(JWKList)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *JWKList) Init() *JWKList {
	if self.Keys == nil {
		self.Keys = make([]*JWK, 0)
	}
	return self
}

type rawJWKList JWKList

//
// UnmarshalJSON is defined for proper JSON decoding of a JWKList
//
func (self *JWKList) UnmarshalJSON(b []byte) error {
	var m rawJWKList
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := JWKList(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *JWKList) Validate() error {
	if self.Keys == nil {
		return fmt.Errorf("JWKList: Missing required field: keys")
	}
	return nil
}

//
// AccessTokenRequest -
//
type AccessTokenRequest string

//
// Workload -
//
type Workload struct {

	//
	// name of the domain, optional for getWorkloadsByService API call
	//
	DomainName DomainName `json:"domainName"`

	//
	// name of the service, , optional for getWorkloadsByService API call
	//
	ServiceName EntityName `json:"serviceName"`

	//
	// unique identifier for the workload, usually defined by provider
	//
	Uuid string `json:"uuid"`

	//
	// list of IP addresses associated with the workload, optional for
	// getWorkloadsByIP API call
	//
	IpAddresses []string `json:"ipAddresses"`

	//
	// hostname associated with the workload
	//
	Hostname string `json:"hostname"`

	//
	// infrastructure provider e.g. k8s, AWS, Azure, openstack etc.
	//
	Provider string `json:"provider"`

	//
	// most recent update timestamp in the backend
	//
	UpdateTime rdl.Timestamp `json:"updateTime"`

	//
	// certificate expiry time (ex: getNotAfter)
	//
	CertExpiryTime rdl.Timestamp `json:"certExpiryTime"`
}

//
// NewWorkload - creates an initialized Workload instance, returns a pointer to it
//
func NewWorkload(init ...*Workload) *Workload {
	var o *Workload
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(Workload)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *Workload) Init() *Workload {
	if self.IpAddresses == nil {
		self.IpAddresses = make([]string, 0)
	}
	return self
}

type rawWorkload Workload

//
// UnmarshalJSON is defined for proper JSON decoding of a Workload
//
func (self *Workload) UnmarshalJSON(b []byte) error {
	var m rawWorkload
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := Workload(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *Workload) Validate() error {
	if self.DomainName == "" {
		return fmt.Errorf("Workload.domainName is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "DomainName", self.DomainName)
		if !val.Valid {
			return fmt.Errorf("Workload.domainName does not contain a valid DomainName (%v)", val.Error)
		}
	}
	if self.ServiceName == "" {
		return fmt.Errorf("Workload.serviceName is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "EntityName", self.ServiceName)
		if !val.Valid {
			return fmt.Errorf("Workload.serviceName does not contain a valid EntityName (%v)", val.Error)
		}
	}
	if self.Uuid == "" {
		return fmt.Errorf("Workload.uuid is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Uuid)
		if !val.Valid {
			return fmt.Errorf("Workload.uuid does not contain a valid String (%v)", val.Error)
		}
	}
	if self.IpAddresses == nil {
		return fmt.Errorf("Workload: Missing required field: ipAddresses")
	}
	if self.Hostname == "" {
		return fmt.Errorf("Workload.hostname is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Hostname)
		if !val.Valid {
			return fmt.Errorf("Workload.hostname does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Provider == "" {
		return fmt.Errorf("Workload.provider is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Provider)
		if !val.Valid {
			return fmt.Errorf("Workload.provider does not contain a valid String (%v)", val.Error)
		}
	}
	if self.UpdateTime.IsZero() {
		return fmt.Errorf("Workload: Missing required field: updateTime")
	}
	if self.CertExpiryTime.IsZero() {
		return fmt.Errorf("Workload: Missing required field: certExpiryTime")
	}
	return nil
}

//
// Workloads -
//
type Workloads struct {

	//
	// list of workloads
	//
	WorkloadList []*Workload `json:"workloadList"`
}

//
// NewWorkloads - creates an initialized Workloads instance, returns a pointer to it
//
func NewWorkloads(init ...*Workloads) *Workloads {
	var o *Workloads
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(Workloads)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *Workloads) Init() *Workloads {
	if self.WorkloadList == nil {
		self.WorkloadList = make([]*Workload, 0)
	}
	return self
}

type rawWorkloads Workloads

//
// UnmarshalJSON is defined for proper JSON decoding of a Workloads
//
func (self *Workloads) UnmarshalJSON(b []byte) error {
	var m rawWorkloads
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := Workloads(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *Workloads) Validate() error {
	if self.WorkloadList == nil {
		return fmt.Errorf("Workloads: Missing required field: workloadList")
	}
	return nil
}

//
// TransportDirection - Copyright The Athenz Authors Licensed under the terms
// of the Apache version 2.0 license. See LICENSE file for terms.
//
type TransportDirection int

//
// TransportDirection constants
//
const (
	_ TransportDirection = iota
	IN
	OUT
)

var namesTransportDirection = []string{
	IN:  "IN",
	OUT: "OUT",
}

//
// NewTransportDirection - return a string representation of the enum
//
func NewTransportDirection(init ...interface{}) TransportDirection {
	if len(init) == 1 {
		switch v := init[0].(type) {
		case TransportDirection:
			return v
		case int:
			return TransportDirection(v)
		case int32:
			return TransportDirection(v)
		case string:
			for i, s := range namesTransportDirection {
				if s == v {
					return TransportDirection(i)
				}
			}
		default:
			panic("Bad init value for TransportDirection enum")
		}
	}
	return TransportDirection(0) //default to the first enum value
}

//
// String - return a string representation of the enum
//
func (e TransportDirection) String() string {
	return namesTransportDirection[e]
}

//
// SymbolSet - return an array of all valid string representations (symbols) of the enum
//
func (e TransportDirection) SymbolSet() []string {
	return namesTransportDirection
}

//
// MarshalJSON is defined for proper JSON encoding of a TransportDirection
//
func (e TransportDirection) MarshalJSON() ([]byte, error) {
	return json.Marshal(e.String())
}

//
// UnmarshalJSON is defined for proper JSON decoding of a TransportDirection
//
func (e *TransportDirection) UnmarshalJSON(b []byte) error {
	var j string
	err := json.Unmarshal(b, &j)
	if err == nil {
		s := string(j)
		for v, s2 := range namesTransportDirection {
			if s == s2 {
				*e = TransportDirection(v)
				return nil
			}
		}
		err = fmt.Errorf("Bad enum symbol for type TransportDirection: %s", s)
	}
	return err
}

//
// TransportRule -
//
type TransportRule struct {

	//
	// source or destination endpoints defined in terms of CIDR notation
	//
	EndPoint string `json:"endPoint"`

	//
	// range of port numbers for incoming connections
	//
	SourcePortRange string `json:"sourcePortRange"`

	//
	// destination / listener port of the service
	//
	Port int32 `json:"port"`

	//
	// protocol of the connection
	//
	Protocol string `json:"protocol"`

	//
	// transport direction
	//
	Direction TransportDirection `json:"direction"`
}

//
// NewTransportRule - creates an initialized TransportRule instance, returns a pointer to it
//
func NewTransportRule(init ...*TransportRule) *TransportRule {
	var o *TransportRule
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(TransportRule)
	}
	return o
}

type rawTransportRule TransportRule

//
// UnmarshalJSON is defined for proper JSON decoding of a TransportRule
//
func (self *TransportRule) UnmarshalJSON(b []byte) error {
	var m rawTransportRule
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := TransportRule(m)
		*self = o
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *TransportRule) Validate() error {
	if self.EndPoint == "" {
		return fmt.Errorf("TransportRule.endPoint is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.EndPoint)
		if !val.Valid {
			return fmt.Errorf("TransportRule.endPoint does not contain a valid String (%v)", val.Error)
		}
	}
	if self.SourcePortRange == "" {
		return fmt.Errorf("TransportRule.sourcePortRange is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.SourcePortRange)
		if !val.Valid {
			return fmt.Errorf("TransportRule.sourcePortRange does not contain a valid String (%v)", val.Error)
		}
	}
	if self.Protocol == "" {
		return fmt.Errorf("TransportRule.protocol is missing but is a required field")
	} else {
		val := rdl.Validate(ZTSSchema(), "String", self.Protocol)
		if !val.Valid {
			return fmt.Errorf("TransportRule.protocol does not contain a valid String (%v)", val.Error)
		}
	}
	return nil
}

//
// TransportRules -
//
type TransportRules struct {
	IngressRules []*TransportRule `json:"ingressRules"`
	EgressRules  []*TransportRule `json:"egressRules"`
}

//
// NewTransportRules - creates an initialized TransportRules instance, returns a pointer to it
//
func NewTransportRules(init ...*TransportRules) *TransportRules {
	var o *TransportRules
	if len(init) == 1 {
		o = init[0]
	} else {
		o = new(TransportRules)
	}
	return o.Init()
}

//
// Init - sets up the instance according to its default field values, if any
//
func (self *TransportRules) Init() *TransportRules {
	if self.IngressRules == nil {
		self.IngressRules = make([]*TransportRule, 0)
	}
	if self.EgressRules == nil {
		self.EgressRules = make([]*TransportRule, 0)
	}
	return self
}

type rawTransportRules TransportRules

//
// UnmarshalJSON is defined for proper JSON decoding of a TransportRules
//
func (self *TransportRules) UnmarshalJSON(b []byte) error {
	var m rawTransportRules
	err := json.Unmarshal(b, &m)
	if err == nil {
		o := TransportRules(m)
		*self = *((&o).Init())
		err = self.Validate()
	}
	return err
}

//
// Validate - checks for missing required fields, etc
//
func (self *TransportRules) Validate() error {
	if self.IngressRules == nil {
		return fmt.Errorf("TransportRules: Missing required field: ingressRules")
	}
	if self.EgressRules == nil {
		return fmt.Errorf("TransportRules: Missing required field: egressRules")
	}
	return nil
}
