/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: k8s.io/kops/protokube/pkg/gossip/mesh/mesh.proto

package mesh

import (
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"

	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type KVState struct {
	Records              map[string]*KVStateRecord `protobuf:"bytes,1,rep,name=records,proto3" json:"records,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *KVState) Reset()      { *m = KVState{} }
func (*KVState) ProtoMessage() {}
func (*KVState) Descriptor() ([]byte, []int) {
	return fileDescriptor_808dfa59f6a93494, []int{0}
}
func (m *KVState) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KVState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KVState.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KVState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KVState.Merge(m, src)
}
func (m *KVState) XXX_Size() int {
	return m.Size()
}
func (m *KVState) XXX_DiscardUnknown() {
	xxx_messageInfo_KVState.DiscardUnknown(m)
}

var xxx_messageInfo_KVState proto.InternalMessageInfo

func (m *KVState) GetRecords() map[string]*KVStateRecord {
	if m != nil {
		return m.Records
	}
	return nil
}

type KVStateRecord struct {
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	Tombstone            bool     `protobuf:"varint,2,opt,name=tombstone,proto3" json:"tombstone,omitempty"`
	Version              uint64   `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KVStateRecord) Reset()      { *m = KVStateRecord{} }
func (*KVStateRecord) ProtoMessage() {}
func (*KVStateRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_808dfa59f6a93494, []int{1}
}
func (m *KVStateRecord) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *KVStateRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_KVStateRecord.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *KVStateRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KVStateRecord.Merge(m, src)
}
func (m *KVStateRecord) XXX_Size() int {
	return m.Size()
}
func (m *KVStateRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_KVStateRecord.DiscardUnknown(m)
}

var xxx_messageInfo_KVStateRecord proto.InternalMessageInfo

func (m *KVStateRecord) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *KVStateRecord) GetTombstone() bool {
	if m != nil {
		return m.Tombstone
	}
	return false
}

func (m *KVStateRecord) GetVersion() uint64 {
	if m != nil {
		return m.Version
	}
	return 0
}

func init() {
	proto.RegisterType((*KVState)(nil), "mesh.KVState")
	proto.RegisterMapType((map[string]*KVStateRecord)(nil), "mesh.KVState.RecordsEntry")
	proto.RegisterType((*KVStateRecord)(nil), "mesh.KVStateRecord")
}

func init() {
	proto.RegisterFile("k8s.io/kops/protokube/pkg/gossip/mesh/mesh.proto", fileDescriptor_808dfa59f6a93494)
}

var fileDescriptor_808dfa59f6a93494 = []byte{
	// 289 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x54, 0x90, 0xb1, 0x4e, 0xc3, 0x30,
	0x18, 0x84, 0xfb, 0xb7, 0x81, 0x50, 0xb7, 0x48, 0xc8, 0x2c, 0x51, 0x54, 0x59, 0x51, 0xa7, 0x30,
	0x10, 0xa3, 0xc2, 0x50, 0x31, 0x22, 0x31, 0x31, 0x20, 0x19, 0x89, 0x85, 0x29, 0x69, 0x4d, 0x1a,
	0x85, 0xe4, 0x8f, 0x62, 0xa7, 0x52, 0x37, 0x1e, 0xa1, 0x8f, 0xd5, 0x91, 0x91, 0x91, 0x86, 0x17,
	0x41, 0xb5, 0xa9, 0xa0, 0x8b, 0x75, 0xe7, 0xef, 0xee, 0x86, 0x9f, 0x5c, 0xe5, 0x53, 0x15, 0x65,
	0xc8, 0x73, 0xac, 0x14, 0xaf, 0x6a, 0xd4, 0x98, 0x37, 0x89, 0xe4, 0x55, 0x9e, 0xf2, 0x14, 0x95,
	0xca, 0x2a, 0x5e, 0x48, 0xb5, 0x30, 0x4f, 0x64, 0x30, 0x75, 0x76, 0xda, 0xbf, 0x4c, 0x33, 0xbd,
	0x68, 0x92, 0x68, 0x86, 0x05, 0x4f, 0x31, 0x45, 0xdb, 0x4d, 0x9a, 0x57, 0xe3, 0x8c, 0x31, 0xca,
	0x96, 0xc6, 0x6b, 0x20, 0xee, 0xc3, 0xf3, 0x93, 0x8e, 0xb5, 0xa4, 0x37, 0xc4, 0xad, 0xe5, 0x0c,
	0xeb, 0xb9, 0xf2, 0x20, 0xe8, 0x85, 0x83, 0x89, 0x1f, 0x99, 0xf9, 0x5f, 0x1e, 0x09, 0x0b, 0xef,
	0x4b, 0x5d, 0xaf, 0xc4, 0x3e, 0xea, 0x3f, 0x92, 0xe1, 0x7f, 0x40, 0xcf, 0x48, 0x2f, 0x97, 0x2b,
	0x0f, 0x02, 0x08, 0xfb, 0x62, 0x27, 0xe9, 0x05, 0x39, 0x5a, 0xc6, 0x6f, 0x8d, 0xf4, 0xba, 0x01,
	0x84, 0x83, 0xc9, 0xf9, 0xc1, 0xaa, 0xed, 0x0a, 0x9b, 0xb8, 0xed, 0x4e, 0x61, 0xfc, 0x42, 0x4e,
	0x0f, 0x18, 0xa5, 0xc4, 0x99, 0xc7, 0x3a, 0x36, 0x93, 0x43, 0x61, 0x34, 0x1d, 0x91, 0xbe, 0xc6,
	0x22, 0x51, 0x1a, 0x4b, 0xbb, 0x7b, 0x22, 0xfe, 0x3e, 0xa8, 0x47, 0xdc, 0xa5, 0xac, 0x55, 0x86,
	0xa5, 0xd7, 0x0b, 0x20, 0x74, 0xc4, 0xde, 0xde, 0x8d, 0x36, 0x5b, 0x06, 0x9f, 0x5b, 0xd6, 0x79,
	0x6f, 0x19, 0x6c, 0x5a, 0x06, 0x1f, 0x2d, 0x83, 0xaf, 0x96, 0xc1, 0xfa, 0x9b, 0x75, 0x92, 0x63,
	0x73, 0x94, 0xeb, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x70, 0x31, 0x0d, 0x30, 0x7d, 0x01, 0x00,
	0x00,
}

func (m *KVState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KVState) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KVState) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Records) > 0 {
		for k := range m.Records {
			v := m.Records[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintMesh(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintMesh(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintMesh(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *KVStateRecord) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KVStateRecord) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *KVStateRecord) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Version != 0 {
		i = encodeVarintMesh(dAtA, i, uint64(m.Version))
		i--
		dAtA[i] = 0x18
	}
	if m.Tombstone {
		i--
		if m.Tombstone {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Data) > 0 {
		i -= len(m.Data)
		copy(dAtA[i:], m.Data)
		i = encodeVarintMesh(dAtA, i, uint64(len(m.Data)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintMesh(dAtA []byte, offset int, v uint64) int {
	offset -= sovMesh(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *KVState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Records) > 0 {
		for k, v := range m.Records {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovMesh(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovMesh(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovMesh(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *KVStateRecord) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Data)
	if l > 0 {
		n += 1 + l + sovMesh(uint64(l))
	}
	if m.Tombstone {
		n += 2
	}
	if m.Version != 0 {
		n += 1 + sovMesh(uint64(m.Version))
	}
	return n
}

func sovMesh(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMesh(x uint64) (n int) {
	return sovMesh(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *KVState) String() string {
	if this == nil {
		return "nil"
	}
	keysForRecords := make([]string, 0, len(this.Records))
	for k := range this.Records {
		keysForRecords = append(keysForRecords, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForRecords)
	mapStringForRecords := "map[string]*KVStateRecord{"
	for _, k := range keysForRecords {
		mapStringForRecords += fmt.Sprintf("%v: %v,", k, this.Records[k])
	}
	mapStringForRecords += "}"
	s := strings.Join([]string{`&KVState{`,
		`Records:` + mapStringForRecords + `,`,
		`}`,
	}, "")
	return s
}
func (this *KVStateRecord) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&KVStateRecord{`,
		`Data:` + fmt.Sprintf("%v", this.Data) + `,`,
		`Tombstone:` + fmt.Sprintf("%v", this.Tombstone) + `,`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringMesh(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *KVState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesh
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KVState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KVState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Records", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMesh
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMesh
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Records == nil {
				m.Records = make(map[string]*KVStateRecord)
			}
			var mapkey string
			var mapvalue *KVStateRecord
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMesh
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMesh
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMesh
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMesh
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMesh
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthMesh
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthMesh
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &KVStateRecord{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMesh(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMesh
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Records[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMesh(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesh
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMesh
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KVStateRecord) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMesh
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KVStateRecord: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KVStateRecord: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMesh
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthMesh
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tombstone", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Tombstone = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMesh(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMesh
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMesh
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMesh(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMesh
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMesh
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMesh
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMesh
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMesh
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMesh        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMesh          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMesh = fmt.Errorf("proto: unexpected end of group")
)
