// Code generated by ifacemaker; DO NOT EDIT.

package hcloud

import (
	"context"
)

// IVolumeClient ...
type IVolumeClient interface {
	// GetByID retrieves a volume by its ID. If the volume does not exist, nil is returned.
	GetByID(ctx context.Context, id int64) (*Volume, *Response, error)
	// GetByName retrieves a volume by its name. If the volume does not exist, nil is returned.
	GetByName(ctx context.Context, name string) (*Volume, *Response, error)
	// Get retrieves a volume by its ID if the input can be parsed as an integer, otherwise it
	// retrieves a volume by its name. If the volume does not exist, nil is returned.
	Get(ctx context.Context, idOrName string) (*Volume, *Response, error)
	// List returns a list of volumes for a specific page.
	//
	// Please note that filters specified in opts are not taken into account
	// when their value corresponds to their zero value or when they are empty.
	List(ctx context.Context, opts VolumeListOpts) ([]*Volume, *Response, error)
	// All returns all volumes.
	All(ctx context.Context) ([]*Volume, error)
	// AllWithOpts returns all volumes with the given options.
	AllWithOpts(ctx context.Context, opts VolumeListOpts) ([]*Volume, error)
	// Create creates a new volume with the given options.
	Create(ctx context.Context, opts VolumeCreateOpts) (VolumeCreateResult, *Response, error)
	// Delete deletes a volume.
	Delete(ctx context.Context, volume *Volume) (*Response, error)
	// Update updates a volume.
	Update(ctx context.Context, volume *Volume, opts VolumeUpdateOpts) (*Volume, *Response, error)
	// AttachWithOpts attaches a volume to a server.
	AttachWithOpts(ctx context.Context, volume *Volume, opts VolumeAttachOpts) (*Action, *Response, error)
	// Attach attaches a volume to a server.
	Attach(ctx context.Context, volume *Volume, server *Server) (*Action, *Response, error)
	// Detach detaches a volume from a server.
	Detach(ctx context.Context, volume *Volume) (*Action, *Response, error)
	// ChangeProtection changes the resource protection level of a volume.
	ChangeProtection(ctx context.Context, volume *Volume, opts VolumeChangeProtectionOpts) (*Action, *Response, error)
	// Resize changes the size of a volume.
	Resize(ctx context.Context, volume *Volume, size int) (*Action, *Response, error)
}
