//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armauthorization

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ScopeAccessReviewHistoryDefinitionClient contains the methods for the ScopeAccessReviewHistoryDefinition group.
// Don't use this type directly, use NewScopeAccessReviewHistoryDefinitionClient() instead.
type ScopeAccessReviewHistoryDefinitionClient struct {
	internal *arm.Client
}

// NewScopeAccessReviewHistoryDefinitionClient creates a new instance of ScopeAccessReviewHistoryDefinitionClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewScopeAccessReviewHistoryDefinitionClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ScopeAccessReviewHistoryDefinitionClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ScopeAccessReviewHistoryDefinitionClient{
		internal: cl,
	}
	return client, nil
}

// Create - Create a scheduled or one-time Access Review History Definition
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01-preview
//   - scope - The scope of the resource.
//   - historyDefinitionID - The id of the access review history definition.
//   - properties - Access review history definition properties.
//   - options - ScopeAccessReviewHistoryDefinitionClientCreateOptions contains the optional parameters for the ScopeAccessReviewHistoryDefinitionClient.Create
//     method.
func (client *ScopeAccessReviewHistoryDefinitionClient) Create(ctx context.Context, scope string, historyDefinitionID string, properties AccessReviewHistoryDefinitionProperties, options *ScopeAccessReviewHistoryDefinitionClientCreateOptions) (ScopeAccessReviewHistoryDefinitionClientCreateResponse, error) {
	var err error
	const operationName = "ScopeAccessReviewHistoryDefinitionClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, scope, historyDefinitionID, properties, options)
	if err != nil {
		return ScopeAccessReviewHistoryDefinitionClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScopeAccessReviewHistoryDefinitionClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ScopeAccessReviewHistoryDefinitionClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *ScopeAccessReviewHistoryDefinitionClient) createCreateRequest(ctx context.Context, scope string, historyDefinitionID string, properties AccessReviewHistoryDefinitionProperties, options *ScopeAccessReviewHistoryDefinitionClientCreateOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/accessReviewHistoryDefinitions/{historyDefinitionId}"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if historyDefinitionID == "" {
		return nil, errors.New("parameter historyDefinitionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{historyDefinitionId}", url.PathEscape(historyDefinitionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *ScopeAccessReviewHistoryDefinitionClient) createHandleResponse(resp *http.Response) (ScopeAccessReviewHistoryDefinitionClientCreateResponse, error) {
	result := ScopeAccessReviewHistoryDefinitionClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AccessReviewHistoryDefinition); err != nil {
		return ScopeAccessReviewHistoryDefinitionClientCreateResponse{}, err
	}
	return result, nil
}

// DeleteByID - Delete an access review history definition
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-12-01-preview
//   - scope - The scope of the resource.
//   - historyDefinitionID - The id of the access review history definition.
//   - options - ScopeAccessReviewHistoryDefinitionClientDeleteByIDOptions contains the optional parameters for the ScopeAccessReviewHistoryDefinitionClient.DeleteByID
//     method.
func (client *ScopeAccessReviewHistoryDefinitionClient) DeleteByID(ctx context.Context, scope string, historyDefinitionID string, options *ScopeAccessReviewHistoryDefinitionClientDeleteByIDOptions) (ScopeAccessReviewHistoryDefinitionClientDeleteByIDResponse, error) {
	var err error
	const operationName = "ScopeAccessReviewHistoryDefinitionClient.DeleteByID"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteByIDCreateRequest(ctx, scope, historyDefinitionID, options)
	if err != nil {
		return ScopeAccessReviewHistoryDefinitionClientDeleteByIDResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScopeAccessReviewHistoryDefinitionClientDeleteByIDResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ScopeAccessReviewHistoryDefinitionClientDeleteByIDResponse{}, err
	}
	return ScopeAccessReviewHistoryDefinitionClientDeleteByIDResponse{}, nil
}

// deleteByIDCreateRequest creates the DeleteByID request.
func (client *ScopeAccessReviewHistoryDefinitionClient) deleteByIDCreateRequest(ctx context.Context, scope string, historyDefinitionID string, options *ScopeAccessReviewHistoryDefinitionClientDeleteByIDOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/accessReviewHistoryDefinitions/{historyDefinitionId}"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if historyDefinitionID == "" {
		return nil, errors.New("parameter historyDefinitionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{historyDefinitionId}", url.PathEscape(historyDefinitionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-12-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}
