---
id: ipsw
title: ipsw
hide_title: true
hide_table_of_contents: true
sidebar_label: ipsw
description: Download and Parse IPSWs (and SO much more)
---
## ipsw

Download and Parse IPSWs (and SO much more)

### Options

```
      --color           colorize output
      --config string   config file (default is $HOME/.config/ipsw/config.yaml)
  -h, --help            help for ipsw
      --no-color        disable colorize output
  -V, --verbose         verbose output
```

### SEE ALSO

* [ipsw appstore](/docs/cli/ipsw/appstore)	 - Interact with the App Store Connect API
* [ipsw class-dump](/docs/cli/ipsw/class-dump)	 - ObjC class-dump a dylib from a DSC or MachO
* [ipsw comp](/docs/cli/ipsw/comp)	 - Compress files using libcompression
* [ipsw decomp](/docs/cli/ipsw/decomp)	 - Decompress files using libcompression
* [ipsw device-info](/docs/cli/ipsw/device-info)	 - Lookup device info
* [ipsw device-list](/docs/cli/ipsw/device-list)	 - List all iOS devices
* [ipsw diff](/docs/cli/ipsw/diff)	 - Diff IPSWs
* [ipsw disk](/docs/cli/ipsw/disk)	 - Disk commands
* [ipsw download](/docs/cli/ipsw/download)	 - Download Apple Firmware files (and more)
* [ipsw dtree](/docs/cli/ipsw/dtree)	 - Parse DeviceTree
* [ipsw dyld](/docs/cli/ipsw/dyld)	 - Parse dyld_shared_cache
* [ipsw ent](/docs/cli/ipsw/ent)	 - Manage and search entitlements database
* [ipsw extract](/docs/cli/ipsw/extract)	 - Extract kernelcache, dyld_shared_cache or DeviceTree from IPSW/OTA
* [ipsw fw](/docs/cli/ipsw/fw)	 - Firmware commands
* [ipsw idev](/docs/cli/ipsw/idev)	 - USB connected device commands
* [ipsw img3](/docs/cli/ipsw/img3)	 - Parse Img3
* [ipsw img4](/docs/cli/ipsw/img4)	 - Parse and manipulate IMG4 files
* [ipsw info](/docs/cli/ipsw/info)	 - Display IPSW/OTA Info
* [ipsw kernel](/docs/cli/ipsw/kernel)	 - Parse kernelcache
* [ipsw lsbom](/docs/cli/ipsw/lsbom)	 - List contents of a BOM file
* [ipsw macho](/docs/cli/ipsw/macho)	 - Parse MachO
* [ipsw mdevs](/docs/cli/ipsw/mdevs)	 - List all MobileDevices in IPSW
* [ipsw mount](/docs/cli/ipsw/mount)	 - Mount DMG from IPSW
* [ipsw ota](/docs/cli/ipsw/ota)	 - Parse OTAs
* [ipsw pbzx](/docs/cli/ipsw/pbzx)	 - Decompess pbzx files
* [ipsw pkg](/docs/cli/ipsw/pkg)	 - 🚧 List contents of a DMG/PKG file
* [ipsw plist](/docs/cli/ipsw/plist)	 - Dump plist as JSON
* [ipsw ssh](/docs/cli/ipsw/ssh)	 - SSH into a jailbroken device
* [ipsw swift-dump](/docs/cli/ipsw/swift-dump)	 - 🚧 Swift class-dump a dylib from a DSC or MachO
* [ipsw symbolicate](/docs/cli/ipsw/symbolicate)	 - Symbolicate ARM 64-bit crash logs (similar to Apple's symbolicatecrash)
* [ipsw version](/docs/cli/ipsw/version)	 - Print the version number of ipsw
* [ipsw watch](/docs/cli/ipsw/watch)	 - Watch Github Commits

