// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/storageinsights/v1/storageinsights.proto

package storageinsightspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	date "google.golang.org/genproto/googleapis/type/date"
	datetime "google.golang.org/genproto/googleapis/type/datetime"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This ENUM specifies possible frequencies of report generation.
type FrequencyOptions_Frequency int32

const (
	// Unspecified.
	FrequencyOptions_FREQUENCY_UNSPECIFIED FrequencyOptions_Frequency = 0
	// Report will be generated daily.
	FrequencyOptions_DAILY FrequencyOptions_Frequency = 1
	// Report will be generated weekly.
	FrequencyOptions_WEEKLY FrequencyOptions_Frequency = 2
)

// Enum value maps for FrequencyOptions_Frequency.
var (
	FrequencyOptions_Frequency_name = map[int32]string{
		0: "FREQUENCY_UNSPECIFIED",
		1: "DAILY",
		2: "WEEKLY",
	}
	FrequencyOptions_Frequency_value = map[string]int32{
		"FREQUENCY_UNSPECIFIED": 0,
		"DAILY":                 1,
		"WEEKLY":                2,
	}
)

func (x FrequencyOptions_Frequency) Enum() *FrequencyOptions_Frequency {
	p := new(FrequencyOptions_Frequency)
	*p = x
	return p
}

func (x FrequencyOptions_Frequency) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FrequencyOptions_Frequency) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_enumTypes[0].Descriptor()
}

func (FrequencyOptions_Frequency) Type() protoreflect.EnumType {
	return &file_google_cloud_storageinsights_v1_storageinsights_proto_enumTypes[0]
}

func (x FrequencyOptions_Frequency) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FrequencyOptions_Frequency.Descriptor instead.
func (FrequencyOptions_Frequency) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{11, 0}
}

// Message for requesting list of ReportConfigs
type ListReportConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListReportConfigsRequest
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListReportConfigsRequest) Reset() {
	*x = ListReportConfigsRequest{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReportConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReportConfigsRequest) ProtoMessage() {}

func (x *ListReportConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReportConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListReportConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{0}
}

func (x *ListReportConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReportConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReportConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListReportConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListReportConfigsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing ReportConfigs
type ListReportConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of ReportConfig
	ReportConfigs []*ReportConfig `protobuf:"bytes,1,rep,name=report_configs,json=reportConfigs,proto3" json:"report_configs,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListReportConfigsResponse) Reset() {
	*x = ListReportConfigsResponse{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReportConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReportConfigsResponse) ProtoMessage() {}

func (x *ListReportConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReportConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListReportConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{1}
}

func (x *ListReportConfigsResponse) GetReportConfigs() []*ReportConfig {
	if x != nil {
		return x.ReportConfigs
	}
	return nil
}

func (x *ListReportConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListReportConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a ReportConfig
type GetReportConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReportConfigRequest) Reset() {
	*x = GetReportConfigRequest{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetReportConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReportConfigRequest) ProtoMessage() {}

func (x *GetReportConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReportConfigRequest.ProtoReflect.Descriptor instead.
func (*GetReportConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{2}
}

func (x *GetReportConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating a ReportConfig
type CreateReportConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The resource being created
	ReportConfig *ReportConfig `protobuf:"bytes,3,opt,name=report_config,json=reportConfig,proto3" json:"report_config,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateReportConfigRequest) Reset() {
	*x = CreateReportConfigRequest{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateReportConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReportConfigRequest) ProtoMessage() {}

func (x *CreateReportConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReportConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateReportConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{3}
}

func (x *CreateReportConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReportConfigRequest) GetReportConfig() *ReportConfig {
	if x != nil {
		return x.ReportConfig
	}
	return nil
}

func (x *CreateReportConfigRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for updating a ReportConfig
type UpdateReportConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// ReportConfig resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The resource being updated
	ReportConfig *ReportConfig `protobuf:"bytes,2,opt,name=report_config,json=reportConfig,proto3" json:"report_config,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateReportConfigRequest) Reset() {
	*x = UpdateReportConfigRequest{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateReportConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateReportConfigRequest) ProtoMessage() {}

func (x *UpdateReportConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateReportConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateReportConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateReportConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateReportConfigRequest) GetReportConfig() *ReportConfig {
	if x != nil {
		return x.ReportConfig
	}
	return nil
}

func (x *UpdateReportConfigRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting a ReportConfig
type DeleteReportConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If set, all ReportDetails for this ReportConfig will be deleted.
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteReportConfigRequest) Reset() {
	*x = DeleteReportConfigRequest{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteReportConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteReportConfigRequest) ProtoMessage() {}

func (x *DeleteReportConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteReportConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteReportConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteReportConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteReportConfigRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *DeleteReportConfigRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message describing ReportDetail object. ReportDetail represents metadata of
// generated reports for a ReportConfig.
// Next ID: 10
type ReportDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of resource. It will be of form
	// projects/<project>/locations/<location>/reportConfigs/<report-config-id>/reportDetails/<report-detail-id>.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The snapshot time.
	// All the report data is referenced at this point of time.
	SnapshotTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=snapshot_time,json=snapshotTime,proto3" json:"snapshot_time,omitempty"`
	// Prefix of the object name of each report's shard. This will have full
	// prefix except the "extension" and "shard_id".
	// For example, if the `destination_path` is
	// `{{report-config-id}}/dt={{datetime}}`, the shard object name would be
	// `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_5.csv`
	// and the value of `report_path_prefix` field would be
	// `gs://my-insights/1A34-F2E456-12B456-1C3D/dt=2022-05-20T06:35/1A34-F2E456-12B456-1C3D_2022-05-20T06:35_`.
	ReportPathPrefix string `protobuf:"bytes,8,opt,name=report_path_prefix,json=reportPathPrefix,proto3" json:"report_path_prefix,omitempty"`
	// Total shards generated for the report.
	ShardsCount int64 `protobuf:"varint,9,opt,name=shards_count,json=shardsCount,proto3" json:"shards_count,omitempty"`
	// Status of the ReportDetail.
	Status *status.Status `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
	// Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The date for which report is generated. The time part of target_datetime
	// will be zero till we support multiple reports per day.
	TargetDatetime *datetime.DateTime `protobuf:"bytes,6,opt,name=target_datetime,json=targetDatetime,proto3" json:"target_datetime,omitempty"`
	// Metrics of the report.
	ReportMetrics *ReportDetail_Metrics `protobuf:"bytes,7,opt,name=report_metrics,json=reportMetrics,proto3" json:"report_metrics,omitempty"`
}

func (x *ReportDetail) Reset() {
	*x = ReportDetail{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReportDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportDetail) ProtoMessage() {}

func (x *ReportDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportDetail.ProtoReflect.Descriptor instead.
func (*ReportDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{6}
}

func (x *ReportDetail) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReportDetail) GetSnapshotTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SnapshotTime
	}
	return nil
}

func (x *ReportDetail) GetReportPathPrefix() string {
	if x != nil {
		return x.ReportPathPrefix
	}
	return ""
}

func (x *ReportDetail) GetShardsCount() int64 {
	if x != nil {
		return x.ShardsCount
	}
	return 0
}

func (x *ReportDetail) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ReportDetail) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ReportDetail) GetTargetDatetime() *datetime.DateTime {
	if x != nil {
		return x.TargetDatetime
	}
	return nil
}

func (x *ReportDetail) GetReportMetrics() *ReportDetail_Metrics {
	if x != nil {
		return x.ReportMetrics
	}
	return nil
}

// Message for requesting list of ReportDetails
type ListReportDetailsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListReportDetailsRequest
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListReportDetailsRequest) Reset() {
	*x = ListReportDetailsRequest{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReportDetailsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReportDetailsRequest) ProtoMessage() {}

func (x *ListReportDetailsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReportDetailsRequest.ProtoReflect.Descriptor instead.
func (*ListReportDetailsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{7}
}

func (x *ListReportDetailsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReportDetailsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReportDetailsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListReportDetailsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListReportDetailsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing ReportDetails
type ListReportDetailsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of ReportDetail
	ReportDetails []*ReportDetail `protobuf:"bytes,1,rep,name=report_details,json=reportDetails,proto3" json:"report_details,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListReportDetailsResponse) Reset() {
	*x = ListReportDetailsResponse{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReportDetailsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReportDetailsResponse) ProtoMessage() {}

func (x *ListReportDetailsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReportDetailsResponse.ProtoReflect.Descriptor instead.
func (*ListReportDetailsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{8}
}

func (x *ListReportDetailsResponse) GetReportDetails() []*ReportDetail {
	if x != nil {
		return x.ReportDetails
	}
	return nil
}

func (x *ListReportDetailsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListReportDetailsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Message for getting a ReportDetail
type GetReportDetailRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReportDetailRequest) Reset() {
	*x = GetReportDetailRequest{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetReportDetailRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReportDetailRequest) ProtoMessage() {}

func (x *GetReportDetailRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReportDetailRequest.ProtoReflect.Descriptor instead.
func (*GetReportDetailRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{9}
}

func (x *GetReportDetailRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have been cancelled successfully
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{10}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// ReportConfig Resource:
//
// Options to setup frequency of report generation.
type FrequencyOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Frequency of report generation.
	Frequency FrequencyOptions_Frequency `protobuf:"varint,1,opt,name=frequency,proto3,enum=google.cloud.storageinsights.v1.FrequencyOptions_Frequency" json:"frequency,omitempty"`
	// The date from which report generation should start.
	// UTC time zone.
	StartDate *date.Date `protobuf:"bytes,2,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// The date on which report generation should stop (Inclusive).
	// UTC time zone.
	EndDate *date.Date `protobuf:"bytes,3,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
}

func (x *FrequencyOptions) Reset() {
	*x = FrequencyOptions{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FrequencyOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FrequencyOptions) ProtoMessage() {}

func (x *FrequencyOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FrequencyOptions.ProtoReflect.Descriptor instead.
func (*FrequencyOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{11}
}

func (x *FrequencyOptions) GetFrequency() FrequencyOptions_Frequency {
	if x != nil {
		return x.Frequency
	}
	return FrequencyOptions_FREQUENCY_UNSPECIFIED
}

func (x *FrequencyOptions) GetStartDate() *date.Date {
	if x != nil {
		return x.StartDate
	}
	return nil
}

func (x *FrequencyOptions) GetEndDate() *date.Date {
	if x != nil {
		return x.EndDate
	}
	return nil
}

// Options to configure CSV formatted reports.
type CSVOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Record separator characters in CSV.
	RecordSeparator string `protobuf:"bytes,1,opt,name=record_separator,json=recordSeparator,proto3" json:"record_separator,omitempty"`
	// Delimiter characters in CSV.
	Delimiter string `protobuf:"bytes,2,opt,name=delimiter,proto3" json:"delimiter,omitempty"`
	// If set, will include a header row in the CSV report.
	HeaderRequired bool `protobuf:"varint,3,opt,name=header_required,json=headerRequired,proto3" json:"header_required,omitempty"`
}

func (x *CSVOptions) Reset() {
	*x = CSVOptions{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CSVOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CSVOptions) ProtoMessage() {}

func (x *CSVOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CSVOptions.ProtoReflect.Descriptor instead.
func (*CSVOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{12}
}

func (x *CSVOptions) GetRecordSeparator() string {
	if x != nil {
		return x.RecordSeparator
	}
	return ""
}

func (x *CSVOptions) GetDelimiter() string {
	if x != nil {
		return x.Delimiter
	}
	return ""
}

func (x *CSVOptions) GetHeaderRequired() bool {
	if x != nil {
		return x.HeaderRequired
	}
	return false
}

// Options to configure Parquet formatted reports.
type ParquetOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ParquetOptions) Reset() {
	*x = ParquetOptions{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ParquetOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParquetOptions) ProtoMessage() {}

func (x *ParquetOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParquetOptions.ProtoReflect.Descriptor instead.
func (*ParquetOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{13}
}

// Options to filter data on storage systems.
// Next ID: 2
type CloudStorageFilters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bucket for which the report will be generated.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
}

func (x *CloudStorageFilters) Reset() {
	*x = CloudStorageFilters{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudStorageFilters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageFilters) ProtoMessage() {}

func (x *CloudStorageFilters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageFilters.ProtoReflect.Descriptor instead.
func (*CloudStorageFilters) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{14}
}

func (x *CloudStorageFilters) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

// Options to store reports in storage systems.
// Next ID: 3
type CloudStorageDestinationOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Destination bucket.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Destination path is the path in the bucket where the report should be
	// generated.
	DestinationPath string `protobuf:"bytes,2,opt,name=destination_path,json=destinationPath,proto3" json:"destination_path,omitempty"`
}

func (x *CloudStorageDestinationOptions) Reset() {
	*x = CloudStorageDestinationOptions{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloudStorageDestinationOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudStorageDestinationOptions) ProtoMessage() {}

func (x *CloudStorageDestinationOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudStorageDestinationOptions.ProtoReflect.Descriptor instead.
func (*CloudStorageDestinationOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{15}
}

func (x *CloudStorageDestinationOptions) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *CloudStorageDestinationOptions) GetDestinationPath() string {
	if x != nil {
		return x.DestinationPath
	}
	return ""
}

// Report specification for exporting object metadata.
// Next ID: 4
type ObjectMetadataReportOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata fields to be included in the report.
	MetadataFields []string `protobuf:"bytes,1,rep,name=metadata_fields,json=metadataFields,proto3" json:"metadata_fields,omitempty"`
	// Filter options for storage systems.
	//
	// Types that are assignable to Filter:
	//
	//	*ObjectMetadataReportOptions_StorageFilters
	Filter isObjectMetadataReportOptions_Filter `protobuf_oneof:"filter"`
	// Options on destination for storage systems.
	//
	// Types that are assignable to DestinationOptions:
	//
	//	*ObjectMetadataReportOptions_StorageDestinationOptions
	DestinationOptions isObjectMetadataReportOptions_DestinationOptions `protobuf_oneof:"destination_options"`
}

func (x *ObjectMetadataReportOptions) Reset() {
	*x = ObjectMetadataReportOptions{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ObjectMetadataReportOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectMetadataReportOptions) ProtoMessage() {}

func (x *ObjectMetadataReportOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectMetadataReportOptions.ProtoReflect.Descriptor instead.
func (*ObjectMetadataReportOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{16}
}

func (x *ObjectMetadataReportOptions) GetMetadataFields() []string {
	if x != nil {
		return x.MetadataFields
	}
	return nil
}

func (m *ObjectMetadataReportOptions) GetFilter() isObjectMetadataReportOptions_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (x *ObjectMetadataReportOptions) GetStorageFilters() *CloudStorageFilters {
	if x, ok := x.GetFilter().(*ObjectMetadataReportOptions_StorageFilters); ok {
		return x.StorageFilters
	}
	return nil
}

func (m *ObjectMetadataReportOptions) GetDestinationOptions() isObjectMetadataReportOptions_DestinationOptions {
	if m != nil {
		return m.DestinationOptions
	}
	return nil
}

func (x *ObjectMetadataReportOptions) GetStorageDestinationOptions() *CloudStorageDestinationOptions {
	if x, ok := x.GetDestinationOptions().(*ObjectMetadataReportOptions_StorageDestinationOptions); ok {
		return x.StorageDestinationOptions
	}
	return nil
}

type isObjectMetadataReportOptions_Filter interface {
	isObjectMetadataReportOptions_Filter()
}

type ObjectMetadataReportOptions_StorageFilters struct {
	// Cloud Storage as the storage system.
	StorageFilters *CloudStorageFilters `protobuf:"bytes,2,opt,name=storage_filters,json=storageFilters,proto3,oneof"`
}

func (*ObjectMetadataReportOptions_StorageFilters) isObjectMetadataReportOptions_Filter() {}

type isObjectMetadataReportOptions_DestinationOptions interface {
	isObjectMetadataReportOptions_DestinationOptions()
}

type ObjectMetadataReportOptions_StorageDestinationOptions struct {
	// Cloud Storage as the storage system.
	StorageDestinationOptions *CloudStorageDestinationOptions `protobuf:"bytes,3,opt,name=storage_destination_options,json=storageDestinationOptions,proto3,oneof"`
}

func (*ObjectMetadataReportOptions_StorageDestinationOptions) isObjectMetadataReportOptions_DestinationOptions() {
}

// Message describing ReportConfig object. ReportConfig is the configuration to
// generate reports.
// See
// https://cloud.google.com/storage/docs/insights/using-inventory-reports#create-config-rest
// for more details on how to set various fields.
// Next ID: 12
type ReportConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// name of resource. It will be of form
	// projects/<project>/locations/<location>/reportConfigs/<report-config-id>.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. [Output only] Create time stamp
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. [Output only] Update time stamp
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The frequency of report generation.
	FrequencyOptions *FrequencyOptions `protobuf:"bytes,5,opt,name=frequency_options,json=frequencyOptions,proto3" json:"frequency_options,omitempty"`
	// Format in which report will be published.
	//
	// Types that are assignable to ReportFormat:
	//
	//	*ReportConfig_CsvOptions
	//	*ReportConfig_ParquetOptions
	ReportFormat isReportConfig_ReportFormat `protobuf_oneof:"report_format"`
	// Configuration options for report contents.
	//
	// Types that are assignable to ReportKind:
	//
	//	*ReportConfig_ObjectMetadataReportOptions
	ReportKind isReportConfig_ReportKind `protobuf_oneof:"report_kind"`
	// Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// User provided display name which can be empty and limited to 256 characters
	// that is editable.
	DisplayName string `protobuf:"bytes,11,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *ReportConfig) Reset() {
	*x = ReportConfig{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReportConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportConfig) ProtoMessage() {}

func (x *ReportConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportConfig.ProtoReflect.Descriptor instead.
func (*ReportConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{17}
}

func (x *ReportConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReportConfig) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ReportConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ReportConfig) GetFrequencyOptions() *FrequencyOptions {
	if x != nil {
		return x.FrequencyOptions
	}
	return nil
}

func (m *ReportConfig) GetReportFormat() isReportConfig_ReportFormat {
	if m != nil {
		return m.ReportFormat
	}
	return nil
}

func (x *ReportConfig) GetCsvOptions() *CSVOptions {
	if x, ok := x.GetReportFormat().(*ReportConfig_CsvOptions); ok {
		return x.CsvOptions
	}
	return nil
}

func (x *ReportConfig) GetParquetOptions() *ParquetOptions {
	if x, ok := x.GetReportFormat().(*ReportConfig_ParquetOptions); ok {
		return x.ParquetOptions
	}
	return nil
}

func (m *ReportConfig) GetReportKind() isReportConfig_ReportKind {
	if m != nil {
		return m.ReportKind
	}
	return nil
}

func (x *ReportConfig) GetObjectMetadataReportOptions() *ObjectMetadataReportOptions {
	if x, ok := x.GetReportKind().(*ReportConfig_ObjectMetadataReportOptions); ok {
		return x.ObjectMetadataReportOptions
	}
	return nil
}

func (x *ReportConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ReportConfig) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

type isReportConfig_ReportFormat interface {
	isReportConfig_ReportFormat()
}

type ReportConfig_CsvOptions struct {
	// Options for CSV formatted reports.
	CsvOptions *CSVOptions `protobuf:"bytes,6,opt,name=csv_options,json=csvOptions,proto3,oneof"`
}

type ReportConfig_ParquetOptions struct {
	// Options for Parquet formatted reports.
	ParquetOptions *ParquetOptions `protobuf:"bytes,7,opt,name=parquet_options,json=parquetOptions,proto3,oneof"`
}

func (*ReportConfig_CsvOptions) isReportConfig_ReportFormat() {}

func (*ReportConfig_ParquetOptions) isReportConfig_ReportFormat() {}

type isReportConfig_ReportKind interface {
	isReportConfig_ReportKind()
}

type ReportConfig_ObjectMetadataReportOptions struct {
	// Report for exporting object metadata.
	ObjectMetadataReportOptions *ObjectMetadataReportOptions `protobuf:"bytes,8,opt,name=object_metadata_report_options,json=objectMetadataReportOptions,proto3,oneof"`
}

func (*ReportConfig_ObjectMetadataReportOptions) isReportConfig_ReportKind() {}

// Different metrics associated with the generated report.
type ReportDetail_Metrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Count of Cloud Storage objects which are part of the report.
	ProcessedRecordsCount int64 `protobuf:"varint,1,opt,name=processed_records_count,json=processedRecordsCount,proto3" json:"processed_records_count,omitempty"`
}

func (x *ReportDetail_Metrics) Reset() {
	*x = ReportDetail_Metrics{}
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReportDetail_Metrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportDetail_Metrics) ProtoMessage() {}

func (x *ReportDetail_Metrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportDetail_Metrics.ProtoReflect.Descriptor instead.
func (*ReportDetail_Metrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP(), []int{6, 0}
}

func (x *ReportDetail_Metrics) GetProcessedRecordsCount() int64 {
	if x != nil {
		return x.ProcessedRecordsCount
	}
	return 0
}

var File_google_cloud_storageinsights_v1_storageinsights_proto protoreflect.FileDescriptor

var file_google_cloud_storageinsights_v1_storageinsights_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2f, 0x76,
	0x31, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd6, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xbb, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x54, 0x0a, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x61, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xe5, 0x01, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a,
	0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67,
	0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xda, 0x01, 0x0a, 0x19, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x57, 0x0a, 0x0d, 0x72, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xa3, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19,
	0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xe8, 0x05,
	0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x0d, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x10, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x61, 0x74, 0x68, 0x50, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x73, 0x68, 0x61, 0x72, 0x64, 0x73, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x51, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x3e, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x61,
	0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x52, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x61, 0x74, 0x65, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x1a, 0x41, 0x0a, 0x07, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x36, 0x0a, 0x17,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x96, 0x01, 0xea, 0x41, 0x92, 0x01, 0x0a, 0x2b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x12, 0x63, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x7d, 0x22, 0xd6, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xbb, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x54, 0x0a, 0x0e, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x61, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x02, 0x0a, 0x10, 0x46,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x59, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x52,
	0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x30, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74,
	0x65, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74,
	0x65, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x22, 0x3d, 0x0a, 0x09, 0x46, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x19, 0x0a, 0x15, 0x46, 0x52, 0x45, 0x51, 0x55,
	0x45, 0x4e, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x41, 0x49, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x57, 0x45, 0x45, 0x4b, 0x4c, 0x59, 0x10, 0x02, 0x22, 0x7e, 0x0a, 0x0a, 0x43, 0x53, 0x56,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x5f, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x53, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x72,
	0x12, 0x27, 0x0a, 0x0f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x22, 0x10, 0x0a, 0x0e, 0x50, 0x61, 0x72,
	0x71, 0x75, 0x65, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x2d, 0x0a, 0x13, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x22, 0x63, 0x0a, 0x1e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x16, 0x0a, 0x06,
	0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x22,
	0xcc, 0x02, 0x0a, 0x1b, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x27, 0x0a, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x5f, 0x0a, 0x0f, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x81, 0x01, 0x0a, 0x1b, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x48, 0x01, 0x52, 0x19, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x08, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x15, 0x0a, 0x13, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x82,
	0x07, 0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5e, 0x0a, 0x11, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x10, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4e, 0x0a, 0x0b, 0x63, 0x73, 0x76, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x53, 0x56, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x73, 0x76,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x71, 0x75,
	0x65, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x71, 0x75, 0x65, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x48, 0x00, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x71, 0x75, 0x65, 0x74, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x1e, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x01, 0x52, 0x1b, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x51, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x77, 0xea, 0x41, 0x74, 0x0a,
	0x2b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x45, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x7d, 0x42, 0x0f, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x42, 0x0d, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6b,
	0x69, 0x6e, 0x64, 0x32, 0xa9, 0x0c, 0x0a, 0x0f, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x12, 0xce, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xbb, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe0, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5f, 0xda, 0x41, 0x14, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xf3, 0x01, 0x0a, 0x12, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x72, 0xda, 0x41, 0x19,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x3a,
	0x0d, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0x3f,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xaa, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73,
	0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xde, 0x01, 0x0a,
	0x11, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0xcb, 0x01,
	0x0a, 0x0f, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0x50, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43, 0x12, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x52, 0xca, 0x41, 0x1e,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0xe8, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69,
	0x67, 0x68, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x07, 0x56, 0x31, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x70, 0x62, 0x3b,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x70,
	0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x73,
	0x2e, 0x56, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68,
	0x74, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e,
	0x73, 0x69, 0x67, 0x68, 0x74, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescOnce sync.Once
	file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescData = file_google_cloud_storageinsights_v1_storageinsights_proto_rawDesc
)

func file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescGZIP() []byte {
	file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescOnce.Do(func() {
		file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescData)
	})
	return file_google_cloud_storageinsights_v1_storageinsights_proto_rawDescData
}

var file_google_cloud_storageinsights_v1_storageinsights_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_google_cloud_storageinsights_v1_storageinsights_proto_goTypes = []any{
	(FrequencyOptions_Frequency)(0),        // 0: google.cloud.storageinsights.v1.FrequencyOptions.Frequency
	(*ListReportConfigsRequest)(nil),       // 1: google.cloud.storageinsights.v1.ListReportConfigsRequest
	(*ListReportConfigsResponse)(nil),      // 2: google.cloud.storageinsights.v1.ListReportConfigsResponse
	(*GetReportConfigRequest)(nil),         // 3: google.cloud.storageinsights.v1.GetReportConfigRequest
	(*CreateReportConfigRequest)(nil),      // 4: google.cloud.storageinsights.v1.CreateReportConfigRequest
	(*UpdateReportConfigRequest)(nil),      // 5: google.cloud.storageinsights.v1.UpdateReportConfigRequest
	(*DeleteReportConfigRequest)(nil),      // 6: google.cloud.storageinsights.v1.DeleteReportConfigRequest
	(*ReportDetail)(nil),                   // 7: google.cloud.storageinsights.v1.ReportDetail
	(*ListReportDetailsRequest)(nil),       // 8: google.cloud.storageinsights.v1.ListReportDetailsRequest
	(*ListReportDetailsResponse)(nil),      // 9: google.cloud.storageinsights.v1.ListReportDetailsResponse
	(*GetReportDetailRequest)(nil),         // 10: google.cloud.storageinsights.v1.GetReportDetailRequest
	(*OperationMetadata)(nil),              // 11: google.cloud.storageinsights.v1.OperationMetadata
	(*FrequencyOptions)(nil),               // 12: google.cloud.storageinsights.v1.FrequencyOptions
	(*CSVOptions)(nil),                     // 13: google.cloud.storageinsights.v1.CSVOptions
	(*ParquetOptions)(nil),                 // 14: google.cloud.storageinsights.v1.ParquetOptions
	(*CloudStorageFilters)(nil),            // 15: google.cloud.storageinsights.v1.CloudStorageFilters
	(*CloudStorageDestinationOptions)(nil), // 16: google.cloud.storageinsights.v1.CloudStorageDestinationOptions
	(*ObjectMetadataReportOptions)(nil),    // 17: google.cloud.storageinsights.v1.ObjectMetadataReportOptions
	(*ReportConfig)(nil),                   // 18: google.cloud.storageinsights.v1.ReportConfig
	(*ReportDetail_Metrics)(nil),           // 19: google.cloud.storageinsights.v1.ReportDetail.Metrics
	nil,                                    // 20: google.cloud.storageinsights.v1.ReportDetail.LabelsEntry
	nil,                                    // 21: google.cloud.storageinsights.v1.ReportConfig.LabelsEntry
	(*fieldmaskpb.FieldMask)(nil),          // 22: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),          // 23: google.protobuf.Timestamp
	(*status.Status)(nil),                  // 24: google.rpc.Status
	(*datetime.DateTime)(nil),              // 25: google.type.DateTime
	(*date.Date)(nil),                      // 26: google.type.Date
	(*emptypb.Empty)(nil),                  // 27: google.protobuf.Empty
}
var file_google_cloud_storageinsights_v1_storageinsights_proto_depIdxs = []int32{
	18, // 0: google.cloud.storageinsights.v1.ListReportConfigsResponse.report_configs:type_name -> google.cloud.storageinsights.v1.ReportConfig
	18, // 1: google.cloud.storageinsights.v1.CreateReportConfigRequest.report_config:type_name -> google.cloud.storageinsights.v1.ReportConfig
	22, // 2: google.cloud.storageinsights.v1.UpdateReportConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	18, // 3: google.cloud.storageinsights.v1.UpdateReportConfigRequest.report_config:type_name -> google.cloud.storageinsights.v1.ReportConfig
	23, // 4: google.cloud.storageinsights.v1.ReportDetail.snapshot_time:type_name -> google.protobuf.Timestamp
	24, // 5: google.cloud.storageinsights.v1.ReportDetail.status:type_name -> google.rpc.Status
	20, // 6: google.cloud.storageinsights.v1.ReportDetail.labels:type_name -> google.cloud.storageinsights.v1.ReportDetail.LabelsEntry
	25, // 7: google.cloud.storageinsights.v1.ReportDetail.target_datetime:type_name -> google.type.DateTime
	19, // 8: google.cloud.storageinsights.v1.ReportDetail.report_metrics:type_name -> google.cloud.storageinsights.v1.ReportDetail.Metrics
	7,  // 9: google.cloud.storageinsights.v1.ListReportDetailsResponse.report_details:type_name -> google.cloud.storageinsights.v1.ReportDetail
	23, // 10: google.cloud.storageinsights.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	23, // 11: google.cloud.storageinsights.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	0,  // 12: google.cloud.storageinsights.v1.FrequencyOptions.frequency:type_name -> google.cloud.storageinsights.v1.FrequencyOptions.Frequency
	26, // 13: google.cloud.storageinsights.v1.FrequencyOptions.start_date:type_name -> google.type.Date
	26, // 14: google.cloud.storageinsights.v1.FrequencyOptions.end_date:type_name -> google.type.Date
	15, // 15: google.cloud.storageinsights.v1.ObjectMetadataReportOptions.storage_filters:type_name -> google.cloud.storageinsights.v1.CloudStorageFilters
	16, // 16: google.cloud.storageinsights.v1.ObjectMetadataReportOptions.storage_destination_options:type_name -> google.cloud.storageinsights.v1.CloudStorageDestinationOptions
	23, // 17: google.cloud.storageinsights.v1.ReportConfig.create_time:type_name -> google.protobuf.Timestamp
	23, // 18: google.cloud.storageinsights.v1.ReportConfig.update_time:type_name -> google.protobuf.Timestamp
	12, // 19: google.cloud.storageinsights.v1.ReportConfig.frequency_options:type_name -> google.cloud.storageinsights.v1.FrequencyOptions
	13, // 20: google.cloud.storageinsights.v1.ReportConfig.csv_options:type_name -> google.cloud.storageinsights.v1.CSVOptions
	14, // 21: google.cloud.storageinsights.v1.ReportConfig.parquet_options:type_name -> google.cloud.storageinsights.v1.ParquetOptions
	17, // 22: google.cloud.storageinsights.v1.ReportConfig.object_metadata_report_options:type_name -> google.cloud.storageinsights.v1.ObjectMetadataReportOptions
	21, // 23: google.cloud.storageinsights.v1.ReportConfig.labels:type_name -> google.cloud.storageinsights.v1.ReportConfig.LabelsEntry
	1,  // 24: google.cloud.storageinsights.v1.StorageInsights.ListReportConfigs:input_type -> google.cloud.storageinsights.v1.ListReportConfigsRequest
	3,  // 25: google.cloud.storageinsights.v1.StorageInsights.GetReportConfig:input_type -> google.cloud.storageinsights.v1.GetReportConfigRequest
	4,  // 26: google.cloud.storageinsights.v1.StorageInsights.CreateReportConfig:input_type -> google.cloud.storageinsights.v1.CreateReportConfigRequest
	5,  // 27: google.cloud.storageinsights.v1.StorageInsights.UpdateReportConfig:input_type -> google.cloud.storageinsights.v1.UpdateReportConfigRequest
	6,  // 28: google.cloud.storageinsights.v1.StorageInsights.DeleteReportConfig:input_type -> google.cloud.storageinsights.v1.DeleteReportConfigRequest
	8,  // 29: google.cloud.storageinsights.v1.StorageInsights.ListReportDetails:input_type -> google.cloud.storageinsights.v1.ListReportDetailsRequest
	10, // 30: google.cloud.storageinsights.v1.StorageInsights.GetReportDetail:input_type -> google.cloud.storageinsights.v1.GetReportDetailRequest
	2,  // 31: google.cloud.storageinsights.v1.StorageInsights.ListReportConfigs:output_type -> google.cloud.storageinsights.v1.ListReportConfigsResponse
	18, // 32: google.cloud.storageinsights.v1.StorageInsights.GetReportConfig:output_type -> google.cloud.storageinsights.v1.ReportConfig
	18, // 33: google.cloud.storageinsights.v1.StorageInsights.CreateReportConfig:output_type -> google.cloud.storageinsights.v1.ReportConfig
	18, // 34: google.cloud.storageinsights.v1.StorageInsights.UpdateReportConfig:output_type -> google.cloud.storageinsights.v1.ReportConfig
	27, // 35: google.cloud.storageinsights.v1.StorageInsights.DeleteReportConfig:output_type -> google.protobuf.Empty
	9,  // 36: google.cloud.storageinsights.v1.StorageInsights.ListReportDetails:output_type -> google.cloud.storageinsights.v1.ListReportDetailsResponse
	7,  // 37: google.cloud.storageinsights.v1.StorageInsights.GetReportDetail:output_type -> google.cloud.storageinsights.v1.ReportDetail
	31, // [31:38] is the sub-list for method output_type
	24, // [24:31] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_cloud_storageinsights_v1_storageinsights_proto_init() }
func file_google_cloud_storageinsights_v1_storageinsights_proto_init() {
	if File_google_cloud_storageinsights_v1_storageinsights_proto != nil {
		return
	}
	file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[16].OneofWrappers = []any{
		(*ObjectMetadataReportOptions_StorageFilters)(nil),
		(*ObjectMetadataReportOptions_StorageDestinationOptions)(nil),
	}
	file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes[17].OneofWrappers = []any{
		(*ReportConfig_CsvOptions)(nil),
		(*ReportConfig_ParquetOptions)(nil),
		(*ReportConfig_ObjectMetadataReportOptions)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_storageinsights_v1_storageinsights_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_storageinsights_v1_storageinsights_proto_goTypes,
		DependencyIndexes: file_google_cloud_storageinsights_v1_storageinsights_proto_depIdxs,
		EnumInfos:         file_google_cloud_storageinsights_v1_storageinsights_proto_enumTypes,
		MessageInfos:      file_google_cloud_storageinsights_v1_storageinsights_proto_msgTypes,
	}.Build()
	File_google_cloud_storageinsights_v1_storageinsights_proto = out.File
	file_google_cloud_storageinsights_v1_storageinsights_proto_rawDesc = nil
	file_google_cloud_storageinsights_v1_storageinsights_proto_goTypes = nil
	file_google_cloud_storageinsights_v1_storageinsights_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// StorageInsightsClient is the client API for StorageInsights service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StorageInsightsClient interface {
	// Lists ReportConfigs in a given project and location.
	ListReportConfigs(ctx context.Context, in *ListReportConfigsRequest, opts ...grpc.CallOption) (*ListReportConfigsResponse, error)
	// Gets details of a single ReportConfig.
	GetReportConfig(ctx context.Context, in *GetReportConfigRequest, opts ...grpc.CallOption) (*ReportConfig, error)
	// Creates a new ReportConfig in a given project and location.
	CreateReportConfig(ctx context.Context, in *CreateReportConfigRequest, opts ...grpc.CallOption) (*ReportConfig, error)
	// Updates the parameters of a single ReportConfig.
	UpdateReportConfig(ctx context.Context, in *UpdateReportConfigRequest, opts ...grpc.CallOption) (*ReportConfig, error)
	// Deletes a single ReportConfig.
	DeleteReportConfig(ctx context.Context, in *DeleteReportConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists ReportDetails in a given project and location.
	ListReportDetails(ctx context.Context, in *ListReportDetailsRequest, opts ...grpc.CallOption) (*ListReportDetailsResponse, error)
	// Gets details of a single ReportDetail.
	GetReportDetail(ctx context.Context, in *GetReportDetailRequest, opts ...grpc.CallOption) (*ReportDetail, error)
}

type storageInsightsClient struct {
	cc grpc.ClientConnInterface
}

func NewStorageInsightsClient(cc grpc.ClientConnInterface) StorageInsightsClient {
	return &storageInsightsClient{cc}
}

func (c *storageInsightsClient) ListReportConfigs(ctx context.Context, in *ListReportConfigsRequest, opts ...grpc.CallOption) (*ListReportConfigsResponse, error) {
	out := new(ListReportConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.storageinsights.v1.StorageInsights/ListReportConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageInsightsClient) GetReportConfig(ctx context.Context, in *GetReportConfigRequest, opts ...grpc.CallOption) (*ReportConfig, error) {
	out := new(ReportConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.storageinsights.v1.StorageInsights/GetReportConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageInsightsClient) CreateReportConfig(ctx context.Context, in *CreateReportConfigRequest, opts ...grpc.CallOption) (*ReportConfig, error) {
	out := new(ReportConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.storageinsights.v1.StorageInsights/CreateReportConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageInsightsClient) UpdateReportConfig(ctx context.Context, in *UpdateReportConfigRequest, opts ...grpc.CallOption) (*ReportConfig, error) {
	out := new(ReportConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.storageinsights.v1.StorageInsights/UpdateReportConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageInsightsClient) DeleteReportConfig(ctx context.Context, in *DeleteReportConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.storageinsights.v1.StorageInsights/DeleteReportConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageInsightsClient) ListReportDetails(ctx context.Context, in *ListReportDetailsRequest, opts ...grpc.CallOption) (*ListReportDetailsResponse, error) {
	out := new(ListReportDetailsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.storageinsights.v1.StorageInsights/ListReportDetails", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *storageInsightsClient) GetReportDetail(ctx context.Context, in *GetReportDetailRequest, opts ...grpc.CallOption) (*ReportDetail, error) {
	out := new(ReportDetail)
	err := c.cc.Invoke(ctx, "/google.cloud.storageinsights.v1.StorageInsights/GetReportDetail", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// StorageInsightsServer is the server API for StorageInsights service.
type StorageInsightsServer interface {
	// Lists ReportConfigs in a given project and location.
	ListReportConfigs(context.Context, *ListReportConfigsRequest) (*ListReportConfigsResponse, error)
	// Gets details of a single ReportConfig.
	GetReportConfig(context.Context, *GetReportConfigRequest) (*ReportConfig, error)
	// Creates a new ReportConfig in a given project and location.
	CreateReportConfig(context.Context, *CreateReportConfigRequest) (*ReportConfig, error)
	// Updates the parameters of a single ReportConfig.
	UpdateReportConfig(context.Context, *UpdateReportConfigRequest) (*ReportConfig, error)
	// Deletes a single ReportConfig.
	DeleteReportConfig(context.Context, *DeleteReportConfigRequest) (*emptypb.Empty, error)
	// Lists ReportDetails in a given project and location.
	ListReportDetails(context.Context, *ListReportDetailsRequest) (*ListReportDetailsResponse, error)
	// Gets details of a single ReportDetail.
	GetReportDetail(context.Context, *GetReportDetailRequest) (*ReportDetail, error)
}

// UnimplementedStorageInsightsServer can be embedded to have forward compatible implementations.
type UnimplementedStorageInsightsServer struct {
}

func (*UnimplementedStorageInsightsServer) ListReportConfigs(context.Context, *ListReportConfigsRequest) (*ListReportConfigsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListReportConfigs not implemented")
}
func (*UnimplementedStorageInsightsServer) GetReportConfig(context.Context, *GetReportConfigRequest) (*ReportConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetReportConfig not implemented")
}
func (*UnimplementedStorageInsightsServer) CreateReportConfig(context.Context, *CreateReportConfigRequest) (*ReportConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateReportConfig not implemented")
}
func (*UnimplementedStorageInsightsServer) UpdateReportConfig(context.Context, *UpdateReportConfigRequest) (*ReportConfig, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateReportConfig not implemented")
}
func (*UnimplementedStorageInsightsServer) DeleteReportConfig(context.Context, *DeleteReportConfigRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteReportConfig not implemented")
}
func (*UnimplementedStorageInsightsServer) ListReportDetails(context.Context, *ListReportDetailsRequest) (*ListReportDetailsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListReportDetails not implemented")
}
func (*UnimplementedStorageInsightsServer) GetReportDetail(context.Context, *GetReportDetailRequest) (*ReportDetail, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetReportDetail not implemented")
}

func RegisterStorageInsightsServer(s *grpc.Server, srv StorageInsightsServer) {
	s.RegisterService(&_StorageInsights_serviceDesc, srv)
}

func _StorageInsights_ListReportConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReportConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageInsightsServer).ListReportConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.storageinsights.v1.StorageInsights/ListReportConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageInsightsServer).ListReportConfigs(ctx, req.(*ListReportConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageInsights_GetReportConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReportConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageInsightsServer).GetReportConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.storageinsights.v1.StorageInsights/GetReportConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageInsightsServer).GetReportConfig(ctx, req.(*GetReportConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageInsights_CreateReportConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReportConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageInsightsServer).CreateReportConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.storageinsights.v1.StorageInsights/CreateReportConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageInsightsServer).CreateReportConfig(ctx, req.(*CreateReportConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageInsights_UpdateReportConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReportConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageInsightsServer).UpdateReportConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.storageinsights.v1.StorageInsights/UpdateReportConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageInsightsServer).UpdateReportConfig(ctx, req.(*UpdateReportConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageInsights_DeleteReportConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReportConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageInsightsServer).DeleteReportConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.storageinsights.v1.StorageInsights/DeleteReportConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageInsightsServer).DeleteReportConfig(ctx, req.(*DeleteReportConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageInsights_ListReportDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReportDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageInsightsServer).ListReportDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.storageinsights.v1.StorageInsights/ListReportDetails",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageInsightsServer).ListReportDetails(ctx, req.(*ListReportDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _StorageInsights_GetReportDetail_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReportDetailRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(StorageInsightsServer).GetReportDetail(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.storageinsights.v1.StorageInsights/GetReportDetail",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(StorageInsightsServer).GetReportDetail(ctx, req.(*GetReportDetailRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _StorageInsights_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.storageinsights.v1.StorageInsights",
	HandlerType: (*StorageInsightsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListReportConfigs",
			Handler:    _StorageInsights_ListReportConfigs_Handler,
		},
		{
			MethodName: "GetReportConfig",
			Handler:    _StorageInsights_GetReportConfig_Handler,
		},
		{
			MethodName: "CreateReportConfig",
			Handler:    _StorageInsights_CreateReportConfig_Handler,
		},
		{
			MethodName: "UpdateReportConfig",
			Handler:    _StorageInsights_UpdateReportConfig_Handler,
		},
		{
			MethodName: "DeleteReportConfig",
			Handler:    _StorageInsights_DeleteReportConfig_Handler,
		},
		{
			MethodName: "ListReportDetails",
			Handler:    _StorageInsights_ListReportDetails_Handler,
		},
		{
			MethodName: "GetReportDetail",
			Handler:    _StorageInsights_GetReportDetail_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/storageinsights/v1/storageinsights.proto",
}
