// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/reviews/v1beta/productreviews.proto

package reviewspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for the GetProductReview method.
type GetProductReviewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the merchant review.
	// Format: accounts/{account}/productReviews/{productReview}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetProductReviewRequest) Reset() {
	*x = GetProductReviewRequest{}
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetProductReviewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetProductReviewRequest) ProtoMessage() {}

func (x *GetProductReviewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetProductReviewRequest.ProtoReflect.Descriptor instead.
func (*GetProductReviewRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescGZIP(), []int{0}
}

func (x *GetProductReviewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `DeleteProductReview` method.
type DeleteProductReviewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the Product review.
	// Format: accounts/{account}/productReviews/{productReview}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteProductReviewRequest) Reset() {
	*x = DeleteProductReviewRequest{}
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteProductReviewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteProductReviewRequest) ProtoMessage() {}

func (x *DeleteProductReviewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteProductReviewRequest.ProtoReflect.Descriptor instead.
func (*DeleteProductReviewRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescGZIP(), []int{1}
}

func (x *DeleteProductReviewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the ListProductReviews method.
type ListProductReviewsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account to list product reviews for.
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of products to return. The service may return
	// fewer than this value.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListProductReviews` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListProductReviews`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListProductReviewsRequest) Reset() {
	*x = ListProductReviewsRequest{}
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListProductReviewsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductReviewsRequest) ProtoMessage() {}

func (x *ListProductReviewsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductReviewsRequest.ProtoReflect.Descriptor instead.
func (*ListProductReviewsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescGZIP(), []int{2}
}

func (x *ListProductReviewsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListProductReviewsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListProductReviewsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Request message for the `InsertProductReview` method.
type InsertProductReviewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account where the product review will be inserted.
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The product review to insert.
	ProductReview *ProductReview `protobuf:"bytes,2,opt,name=product_review,json=productReview,proto3" json:"product_review,omitempty"`
	// Required. Format:
	// `accounts/{account}/dataSources/{datasource}`.
	DataSource string `protobuf:"bytes,3,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
}

func (x *InsertProductReviewRequest) Reset() {
	*x = InsertProductReviewRequest{}
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InsertProductReviewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertProductReviewRequest) ProtoMessage() {}

func (x *InsertProductReviewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertProductReviewRequest.ProtoReflect.Descriptor instead.
func (*InsertProductReviewRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescGZIP(), []int{3}
}

func (x *InsertProductReviewRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *InsertProductReviewRequest) GetProductReview() *ProductReview {
	if x != nil {
		return x.ProductReview
	}
	return nil
}

func (x *InsertProductReviewRequest) GetDataSource() string {
	if x != nil {
		return x.DataSource
	}
	return ""
}

// response message for the ListProductReviews method.
type ListProductReviewsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The product review.
	ProductReviews []*ProductReview `protobuf:"bytes,1,rep,name=product_reviews,json=productReviews,proto3" json:"product_reviews,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListProductReviewsResponse) Reset() {
	*x = ListProductReviewsResponse{}
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListProductReviewsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListProductReviewsResponse) ProtoMessage() {}

func (x *ListProductReviewsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListProductReviewsResponse.ProtoReflect.Descriptor instead.
func (*ListProductReviewsResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescGZIP(), []int{4}
}

func (x *ListProductReviewsResponse) GetProductReviews() []*ProductReview {
	if x != nil {
		return x.ProductReviews
	}
	return nil
}

func (x *ListProductReviewsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A review for a product. For more information, see
// [Introduction to Product Review
// Feeds](https://developers.google.com/product-review-feeds)
type ProductReview struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the product review.
	// Format:
	// `"{productreview.name=accounts/{account}/productReviews/{productReview}}"`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The permanent, unique identifier for the product review in the
	// publisher’s system.
	ProductReviewId string `protobuf:"bytes,2,opt,name=product_review_id,json=productReviewId,proto3" json:"product_review_id,omitempty"`
	// Optional. A list of product review attributes.
	Attributes *ProductReviewAttributes `protobuf:"bytes,3,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// Optional. A list of custom (merchant-provided) attributes.
	CustomAttributes []*typepb.CustomAttribute `protobuf:"bytes,4,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty"`
	// Output only. The primary data source of the product review.
	DataSource string `protobuf:"bytes,5,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
	// Output only. The status of a product review, data validation issues, that
	// is, information about a product review computed asynchronously.
	ProductReviewStatus *ProductReviewStatus `protobuf:"bytes,6,opt,name=product_review_status,json=productReviewStatus,proto3" json:"product_review_status,omitempty"`
}

func (x *ProductReview) Reset() {
	*x = ProductReview{}
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProductReview) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProductReview) ProtoMessage() {}

func (x *ProductReview) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProductReview.ProtoReflect.Descriptor instead.
func (*ProductReview) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescGZIP(), []int{5}
}

func (x *ProductReview) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ProductReview) GetProductReviewId() string {
	if x != nil {
		return x.ProductReviewId
	}
	return ""
}

func (x *ProductReview) GetAttributes() *ProductReviewAttributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *ProductReview) GetCustomAttributes() []*typepb.CustomAttribute {
	if x != nil {
		return x.CustomAttributes
	}
	return nil
}

func (x *ProductReview) GetDataSource() string {
	if x != nil {
		return x.DataSource
	}
	return ""
}

func (x *ProductReview) GetProductReviewStatus() *ProductReviewStatus {
	if x != nil {
		return x.ProductReviewStatus
	}
	return nil
}

var File_google_shopping_merchant_reviews_v1beta_productreviews_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x5f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x74, 0x79,
	0x70, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x5f,
	0x0a, 0x17, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x62, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xc3, 0x01, 0x0a, 0x1a, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x62, 0x0a,
	0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5f, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xb7, 0x04, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x11, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x49, 0x64, 0x12, 0x65, 0x0a, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x12, 0x57, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x75, 0x0a, 0x15, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x3a, 0x7f, 0xea, 0x41, 0x7c, 0x0a, 0x28, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x31, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x7d, 0x2a, 0x0e, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x32, 0x0d, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x32, 0xb7, 0x07, 0x0a, 0x15, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x12, 0xcf, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x34, 0x12, 0x32, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe2, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0xe5, 0x01, 0x0a, 0x13, 0x49,
	0x6e, 0x73, 0x65, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73,
	0x65, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x22,
	0x51, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x22, 0x39, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x3a, 0x69, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x12, 0xb5, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x42, 0x93, 0x02, 0x0a, 0x2b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x42, 0x13, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4b, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x70, 0x62, 0x3b, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74,
	0x61, 0xca, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x53, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x5c, 0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x5c, 0x52, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x2b, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x53, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x3a, 0x3a,
	0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x3a, 0x3a, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescData = file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDesc
)

func file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescData)
	})
	return file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDescData
}

var file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_shopping_merchant_reviews_v1beta_productreviews_proto_goTypes = []any{
	(*GetProductReviewRequest)(nil),    // 0: google.shopping.merchant.reviews.v1beta.GetProductReviewRequest
	(*DeleteProductReviewRequest)(nil), // 1: google.shopping.merchant.reviews.v1beta.DeleteProductReviewRequest
	(*ListProductReviewsRequest)(nil),  // 2: google.shopping.merchant.reviews.v1beta.ListProductReviewsRequest
	(*InsertProductReviewRequest)(nil), // 3: google.shopping.merchant.reviews.v1beta.InsertProductReviewRequest
	(*ListProductReviewsResponse)(nil), // 4: google.shopping.merchant.reviews.v1beta.ListProductReviewsResponse
	(*ProductReview)(nil),              // 5: google.shopping.merchant.reviews.v1beta.ProductReview
	(*ProductReviewAttributes)(nil),    // 6: google.shopping.merchant.reviews.v1beta.ProductReviewAttributes
	(*typepb.CustomAttribute)(nil),     // 7: google.shopping.type.CustomAttribute
	(*ProductReviewStatus)(nil),        // 8: google.shopping.merchant.reviews.v1beta.ProductReviewStatus
	(*emptypb.Empty)(nil),              // 9: google.protobuf.Empty
}
var file_google_shopping_merchant_reviews_v1beta_productreviews_proto_depIdxs = []int32{
	5, // 0: google.shopping.merchant.reviews.v1beta.InsertProductReviewRequest.product_review:type_name -> google.shopping.merchant.reviews.v1beta.ProductReview
	5, // 1: google.shopping.merchant.reviews.v1beta.ListProductReviewsResponse.product_reviews:type_name -> google.shopping.merchant.reviews.v1beta.ProductReview
	6, // 2: google.shopping.merchant.reviews.v1beta.ProductReview.attributes:type_name -> google.shopping.merchant.reviews.v1beta.ProductReviewAttributes
	7, // 3: google.shopping.merchant.reviews.v1beta.ProductReview.custom_attributes:type_name -> google.shopping.type.CustomAttribute
	8, // 4: google.shopping.merchant.reviews.v1beta.ProductReview.product_review_status:type_name -> google.shopping.merchant.reviews.v1beta.ProductReviewStatus
	0, // 5: google.shopping.merchant.reviews.v1beta.ProductReviewsService.GetProductReview:input_type -> google.shopping.merchant.reviews.v1beta.GetProductReviewRequest
	2, // 6: google.shopping.merchant.reviews.v1beta.ProductReviewsService.ListProductReviews:input_type -> google.shopping.merchant.reviews.v1beta.ListProductReviewsRequest
	3, // 7: google.shopping.merchant.reviews.v1beta.ProductReviewsService.InsertProductReview:input_type -> google.shopping.merchant.reviews.v1beta.InsertProductReviewRequest
	1, // 8: google.shopping.merchant.reviews.v1beta.ProductReviewsService.DeleteProductReview:input_type -> google.shopping.merchant.reviews.v1beta.DeleteProductReviewRequest
	5, // 9: google.shopping.merchant.reviews.v1beta.ProductReviewsService.GetProductReview:output_type -> google.shopping.merchant.reviews.v1beta.ProductReview
	4, // 10: google.shopping.merchant.reviews.v1beta.ProductReviewsService.ListProductReviews:output_type -> google.shopping.merchant.reviews.v1beta.ListProductReviewsResponse
	5, // 11: google.shopping.merchant.reviews.v1beta.ProductReviewsService.InsertProductReview:output_type -> google.shopping.merchant.reviews.v1beta.ProductReview
	9, // 12: google.shopping.merchant.reviews.v1beta.ProductReviewsService.DeleteProductReview:output_type -> google.protobuf.Empty
	9, // [9:13] is the sub-list for method output_type
	5, // [5:9] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_reviews_v1beta_productreviews_proto_init() }
func file_google_shopping_merchant_reviews_v1beta_productreviews_proto_init() {
	if File_google_shopping_merchant_reviews_v1beta_productreviews_proto != nil {
		return
	}
	file_google_shopping_merchant_reviews_v1beta_productreviews_common_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_reviews_v1beta_productreviews_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_reviews_v1beta_productreviews_proto_depIdxs,
		MessageInfos:      file_google_shopping_merchant_reviews_v1beta_productreviews_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_reviews_v1beta_productreviews_proto = out.File
	file_google_shopping_merchant_reviews_v1beta_productreviews_proto_rawDesc = nil
	file_google_shopping_merchant_reviews_v1beta_productreviews_proto_goTypes = nil
	file_google_shopping_merchant_reviews_v1beta_productreviews_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ProductReviewsServiceClient is the client API for ProductReviewsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ProductReviewsServiceClient interface {
	// Gets a product review.
	GetProductReview(ctx context.Context, in *GetProductReviewRequest, opts ...grpc.CallOption) (*ProductReview, error)
	// Lists product reviews.
	ListProductReviews(ctx context.Context, in *ListProductReviewsRequest, opts ...grpc.CallOption) (*ListProductReviewsResponse, error)
	// Inserts a product review.
	InsertProductReview(ctx context.Context, in *InsertProductReviewRequest, opts ...grpc.CallOption) (*ProductReview, error)
	// Deletes a product review.
	DeleteProductReview(ctx context.Context, in *DeleteProductReviewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type productReviewsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewProductReviewsServiceClient(cc grpc.ClientConnInterface) ProductReviewsServiceClient {
	return &productReviewsServiceClient{cc}
}

func (c *productReviewsServiceClient) GetProductReview(ctx context.Context, in *GetProductReviewRequest, opts ...grpc.CallOption) (*ProductReview, error) {
	out := new(ProductReview)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.reviews.v1beta.ProductReviewsService/GetProductReview", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productReviewsServiceClient) ListProductReviews(ctx context.Context, in *ListProductReviewsRequest, opts ...grpc.CallOption) (*ListProductReviewsResponse, error) {
	out := new(ListProductReviewsResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.reviews.v1beta.ProductReviewsService/ListProductReviews", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productReviewsServiceClient) InsertProductReview(ctx context.Context, in *InsertProductReviewRequest, opts ...grpc.CallOption) (*ProductReview, error) {
	out := new(ProductReview)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.reviews.v1beta.ProductReviewsService/InsertProductReview", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *productReviewsServiceClient) DeleteProductReview(ctx context.Context, in *DeleteProductReviewRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.reviews.v1beta.ProductReviewsService/DeleteProductReview", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProductReviewsServiceServer is the server API for ProductReviewsService service.
type ProductReviewsServiceServer interface {
	// Gets a product review.
	GetProductReview(context.Context, *GetProductReviewRequest) (*ProductReview, error)
	// Lists product reviews.
	ListProductReviews(context.Context, *ListProductReviewsRequest) (*ListProductReviewsResponse, error)
	// Inserts a product review.
	InsertProductReview(context.Context, *InsertProductReviewRequest) (*ProductReview, error)
	// Deletes a product review.
	DeleteProductReview(context.Context, *DeleteProductReviewRequest) (*emptypb.Empty, error)
}

// UnimplementedProductReviewsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedProductReviewsServiceServer struct {
}

func (*UnimplementedProductReviewsServiceServer) GetProductReview(context.Context, *GetProductReviewRequest) (*ProductReview, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProductReview not implemented")
}
func (*UnimplementedProductReviewsServiceServer) ListProductReviews(context.Context, *ListProductReviewsRequest) (*ListProductReviewsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProductReviews not implemented")
}
func (*UnimplementedProductReviewsServiceServer) InsertProductReview(context.Context, *InsertProductReviewRequest) (*ProductReview, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertProductReview not implemented")
}
func (*UnimplementedProductReviewsServiceServer) DeleteProductReview(context.Context, *DeleteProductReviewRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteProductReview not implemented")
}

func RegisterProductReviewsServiceServer(s *grpc.Server, srv ProductReviewsServiceServer) {
	s.RegisterService(&_ProductReviewsService_serviceDesc, srv)
}

func _ProductReviewsService_GetProductReview_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProductReviewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductReviewsServiceServer).GetProductReview(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.reviews.v1beta.ProductReviewsService/GetProductReview",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductReviewsServiceServer).GetProductReview(ctx, req.(*GetProductReviewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductReviewsService_ListProductReviews_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProductReviewsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductReviewsServiceServer).ListProductReviews(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.reviews.v1beta.ProductReviewsService/ListProductReviews",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductReviewsServiceServer).ListProductReviews(ctx, req.(*ListProductReviewsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductReviewsService_InsertProductReview_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertProductReviewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductReviewsServiceServer).InsertProductReview(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.reviews.v1beta.ProductReviewsService/InsertProductReview",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductReviewsServiceServer).InsertProductReview(ctx, req.(*InsertProductReviewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProductReviewsService_DeleteProductReview_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteProductReviewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProductReviewsServiceServer).DeleteProductReview(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.reviews.v1beta.ProductReviewsService/DeleteProductReview",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProductReviewsServiceServer).DeleteProductReview(ctx, req.(*DeleteProductReviewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ProductReviewsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.reviews.v1beta.ProductReviewsService",
	HandlerType: (*ProductReviewsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetProductReview",
			Handler:    _ProductReviewsService_GetProductReview_Handler,
		},
		{
			MethodName: "ListProductReviews",
			Handler:    _ProductReviewsService_ListProductReviews_Handler,
		},
		{
			MethodName: "InsertProductReview",
			Handler:    _ProductReviewsService_InsertProductReview_Handler,
		},
		{
			MethodName: "DeleteProductReview",
			Handler:    _ProductReviewsService_DeleteProductReview_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/reviews/v1beta/productreviews.proto",
}
