// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/promotions/v1beta/promotions.proto

package promotionspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Represents a promotion. See the following articles for more details.
//
// Required promotion input attributes to pass data validation checks are
// primarily defined below:
//
// * [Promotions data
// specification](https://support.google.com/merchants/answer/2906014)
// * [Local promotions data
// specification](https://support.google.com/merchants/answer/10146130)
//
// After inserting, updating a promotion input, it may take several minutes
// before the final promotion can be retrieved.
type Promotion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the promotion.
	// Format: `accounts/{account}/promotions/{promotion}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The user provided promotion ID to uniquely identify the
	// promotion. Follow [minimum
	// requirements](https://support.google.com/merchants/answer/7050148?ref_topic=7322920&sjid=871860036916537104-NC#minimum_requirements)
	// to prevent promotion disapprovals.
	PromotionId string `protobuf:"bytes,2,opt,name=promotion_id,json=promotionId,proto3" json:"promotion_id,omitempty"`
	// Required. The two-letter [ISO
	// 639-1](http://en.wikipedia.org/wiki/ISO_639-1) language code for the
	// promotion.
	//
	// Promotions is only for [selected
	// languages](https://support.google.com/merchants/answer/4588281?ref_topic=6396150&sjid=18314938579342094533-NC#option3&zippy=).
	ContentLanguage string `protobuf:"bytes,3,opt,name=content_language,json=contentLanguage,proto3" json:"content_language,omitempty"`
	// Required. The target country used as part of the unique identifier.
	// Represented as a [CLDR territory
	// code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml).
	//
	// Promotions are only available in selected
	// countries, [Free Listings and Shopping
	// ads](https://support.google.com/merchants/answer/4588460) [Local Inventory
	// ads](https://support.google.com/merchants/answer/10146326)
	TargetCountry string `protobuf:"bytes,4,opt,name=target_country,json=targetCountry,proto3" json:"target_country,omitempty"`
	// Required. [Redemption
	// channel](https://support.google.com/merchants/answer/13837674?ref_topic=13773355&sjid=17642868584668136159-NC)
	// for the promotion. At least one channel is required.
	RedemptionChannel []RedemptionChannel `protobuf:"varint,5,rep,packed,name=redemption_channel,json=redemptionChannel,proto3,enum=google.shopping.merchant.promotions.v1beta.RedemptionChannel" json:"redemption_channel,omitempty"`
	// Output only. The primary data source of the promotion.
	DataSource string `protobuf:"bytes,6,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
	// Optional. A list of promotion attributes.
	Attributes *Attributes `protobuf:"bytes,7,opt,name=attributes,proto3" json:"attributes,omitempty"`
	// Optional. A list of custom (merchant-provided) attributes. It can also be
	// used for submitting any attribute of the data specification in its generic
	// form (for example,
	// `{ "name": "size type", "value": "regular" }`).
	// This is useful for submitting attributes not explicitly exposed by the
	// API.
	CustomAttributes []*typepb.CustomAttribute `protobuf:"bytes,8,rep,name=custom_attributes,json=customAttributes,proto3" json:"custom_attributes,omitempty"`
	// Output only. The [status of a
	// promotion](https://support.google.com/merchants/answer/3398326?ref_topic=7322924&sjid=5155774230887277618-NC),
	// data validation issues, that is, information about a promotion computed
	// asynchronously.
	PromotionStatus *PromotionStatus `protobuf:"bytes,9,opt,name=promotion_status,json=promotionStatus,proto3" json:"promotion_status,omitempty"`
	// Optional. Represents the existing version (freshness) of the promotion,
	// which can be used to preserve the right order when multiple updates are
	// done at the same time.
	//
	// If set, the insertion is prevented when version number is lower than
	// the current version number of the existing promotion. Re-insertion (for
	// example, promotion refresh after 30 days) can be performed with the current
	// `version_number`.
	//
	// If the operation is prevented, the aborted exception will be
	// thrown.
	VersionNumber *int64 `protobuf:"varint,10,opt,name=version_number,json=versionNumber,proto3,oneof" json:"version_number,omitempty"`
}

func (x *Promotion) Reset() {
	*x = Promotion{}
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Promotion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Promotion) ProtoMessage() {}

func (x *Promotion) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Promotion.ProtoReflect.Descriptor instead.
func (*Promotion) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDescGZIP(), []int{0}
}

func (x *Promotion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Promotion) GetPromotionId() string {
	if x != nil {
		return x.PromotionId
	}
	return ""
}

func (x *Promotion) GetContentLanguage() string {
	if x != nil {
		return x.ContentLanguage
	}
	return ""
}

func (x *Promotion) GetTargetCountry() string {
	if x != nil {
		return x.TargetCountry
	}
	return ""
}

func (x *Promotion) GetRedemptionChannel() []RedemptionChannel {
	if x != nil {
		return x.RedemptionChannel
	}
	return nil
}

func (x *Promotion) GetDataSource() string {
	if x != nil {
		return x.DataSource
	}
	return ""
}

func (x *Promotion) GetAttributes() *Attributes {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *Promotion) GetCustomAttributes() []*typepb.CustomAttribute {
	if x != nil {
		return x.CustomAttributes
	}
	return nil
}

func (x *Promotion) GetPromotionStatus() *PromotionStatus {
	if x != nil {
		return x.PromotionStatus
	}
	return nil
}

func (x *Promotion) GetVersionNumber() int64 {
	if x != nil && x.VersionNumber != nil {
		return *x.VersionNumber
	}
	return 0
}

// Request message for the `InsertPromotion` method.
type InsertPromotionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account where the promotion will be inserted.
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The promotion to insert.
	Promotion *Promotion `protobuf:"bytes,2,opt,name=promotion,proto3" json:"promotion,omitempty"`
	// Required. The data source of the
	// [promotion](https://support.google.com/merchants/answer/6396268?sjid=5155774230887277618-NC)
	// Format:
	// `accounts/{account}/dataSources/{datasource}`.
	DataSource string `protobuf:"bytes,3,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
}

func (x *InsertPromotionRequest) Reset() {
	*x = InsertPromotionRequest{}
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InsertPromotionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertPromotionRequest) ProtoMessage() {}

func (x *InsertPromotionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertPromotionRequest.ProtoReflect.Descriptor instead.
func (*InsertPromotionRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDescGZIP(), []int{1}
}

func (x *InsertPromotionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *InsertPromotionRequest) GetPromotion() *Promotion {
	if x != nil {
		return x.Promotion
	}
	return nil
}

func (x *InsertPromotionRequest) GetDataSource() string {
	if x != nil {
		return x.DataSource
	}
	return ""
}

// Request message for the `GetPromotion` method.
type GetPromotionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the promotion to retrieve.
	// Format: `accounts/{account}/promotions/{promotions}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPromotionRequest) Reset() {
	*x = GetPromotionRequest{}
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPromotionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPromotionRequest) ProtoMessage() {}

func (x *GetPromotionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPromotionRequest.ProtoReflect.Descriptor instead.
func (*GetPromotionRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDescGZIP(), []int{2}
}

func (x *GetPromotionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for the `ListPromotions` method.
type ListPromotionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The account to list processed promotions for.
	// Format: `accounts/{account}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Output only. The maximum number of promotions to return. The service may
	// return fewer than this value. The maximum value is 1000; values above 1000
	// will be coerced to 1000. If unspecified, the maximum number of promotions
	// will be returned.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Output only. A page token, received from a previous `ListPromotions` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListPromotions` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPromotionsRequest) Reset() {
	*x = ListPromotionsRequest{}
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPromotionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPromotionsRequest) ProtoMessage() {}

func (x *ListPromotionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPromotionsRequest.ProtoReflect.Descriptor instead.
func (*ListPromotionsRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDescGZIP(), []int{3}
}

func (x *ListPromotionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPromotionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPromotionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for the `ListPromotions` method.
type ListPromotionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The processed promotions from the specified account.
	Promotions []*Promotion `protobuf:"bytes,1,rep,name=promotions,proto3" json:"promotions,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPromotionsResponse) Reset() {
	*x = ListPromotionsResponse{}
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPromotionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPromotionsResponse) ProtoMessage() {}

func (x *ListPromotionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPromotionsResponse.ProtoReflect.Descriptor instead.
func (*ListPromotionsResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDescGZIP(), []int{4}
}

func (x *ListPromotionsResponse) GetPromotions() []*Promotion {
	if x != nil {
		return x.Promotions
	}
	return nil
}

func (x *ListPromotionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_shopping_merchant_promotions_v1beta_promotions_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x42, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x95, 0x06, 0x0a, 0x09, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x2e, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x72, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x71, 0x0a,
	0x12, 0x72, 0x65, 0x64, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65, 0x64, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x72,
	0x65, 0x64, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x12, 0x24, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5b, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x6b, 0x0a, 0x10,
	0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x2f, 0x0a, 0x0e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x88, 0x01, 0x01, 0x3a, 0x6b, 0xea, 0x41, 0x68, 0x0a,
	0x24, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6d,
	0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2a, 0x0a, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x09, 0x70, 0x72,
	0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0xb5, 0x01, 0x0a, 0x16, 0x49,
	0x6e, 0x73, 0x65, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x58, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0x57, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a,
	0x24, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6d,
	0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7a, 0x0a, 0x15, 0x4c,
	0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x97, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x55, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x70,
	0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x32, 0xd9, 0x05, 0x0a, 0x11, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xd1, 0x01, 0x0a, 0x0f, 0x49, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x50,
	0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x43, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01,
	0x2a, 0x22, 0x38, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x12, 0xc8, 0x01, 0x0a, 0x0c,
	0x47, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e,
	0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdb, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72,
	0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x42, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x33, 0x12, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0xd4, 0x01,
	0xea, 0x41, 0x38, 0x0a, 0x22, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x12, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x0a, 0x2e, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0f, 0x50, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x54,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x62, 0x3b, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDescData = file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDesc
)

func file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDescData)
	})
	return file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDescData
}

var file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_shopping_merchant_promotions_v1beta_promotions_proto_goTypes = []any{
	(*Promotion)(nil),              // 0: google.shopping.merchant.promotions.v1beta.Promotion
	(*InsertPromotionRequest)(nil), // 1: google.shopping.merchant.promotions.v1beta.InsertPromotionRequest
	(*GetPromotionRequest)(nil),    // 2: google.shopping.merchant.promotions.v1beta.GetPromotionRequest
	(*ListPromotionsRequest)(nil),  // 3: google.shopping.merchant.promotions.v1beta.ListPromotionsRequest
	(*ListPromotionsResponse)(nil), // 4: google.shopping.merchant.promotions.v1beta.ListPromotionsResponse
	(RedemptionChannel)(0),         // 5: google.shopping.merchant.promotions.v1beta.RedemptionChannel
	(*Attributes)(nil),             // 6: google.shopping.merchant.promotions.v1beta.Attributes
	(*typepb.CustomAttribute)(nil), // 7: google.shopping.type.CustomAttribute
	(*PromotionStatus)(nil),        // 8: google.shopping.merchant.promotions.v1beta.PromotionStatus
}
var file_google_shopping_merchant_promotions_v1beta_promotions_proto_depIdxs = []int32{
	5, // 0: google.shopping.merchant.promotions.v1beta.Promotion.redemption_channel:type_name -> google.shopping.merchant.promotions.v1beta.RedemptionChannel
	6, // 1: google.shopping.merchant.promotions.v1beta.Promotion.attributes:type_name -> google.shopping.merchant.promotions.v1beta.Attributes
	7, // 2: google.shopping.merchant.promotions.v1beta.Promotion.custom_attributes:type_name -> google.shopping.type.CustomAttribute
	8, // 3: google.shopping.merchant.promotions.v1beta.Promotion.promotion_status:type_name -> google.shopping.merchant.promotions.v1beta.PromotionStatus
	0, // 4: google.shopping.merchant.promotions.v1beta.InsertPromotionRequest.promotion:type_name -> google.shopping.merchant.promotions.v1beta.Promotion
	0, // 5: google.shopping.merchant.promotions.v1beta.ListPromotionsResponse.promotions:type_name -> google.shopping.merchant.promotions.v1beta.Promotion
	1, // 6: google.shopping.merchant.promotions.v1beta.PromotionsService.InsertPromotion:input_type -> google.shopping.merchant.promotions.v1beta.InsertPromotionRequest
	2, // 7: google.shopping.merchant.promotions.v1beta.PromotionsService.GetPromotion:input_type -> google.shopping.merchant.promotions.v1beta.GetPromotionRequest
	3, // 8: google.shopping.merchant.promotions.v1beta.PromotionsService.ListPromotions:input_type -> google.shopping.merchant.promotions.v1beta.ListPromotionsRequest
	0, // 9: google.shopping.merchant.promotions.v1beta.PromotionsService.InsertPromotion:output_type -> google.shopping.merchant.promotions.v1beta.Promotion
	0, // 10: google.shopping.merchant.promotions.v1beta.PromotionsService.GetPromotion:output_type -> google.shopping.merchant.promotions.v1beta.Promotion
	4, // 11: google.shopping.merchant.promotions.v1beta.PromotionsService.ListPromotions:output_type -> google.shopping.merchant.promotions.v1beta.ListPromotionsResponse
	9, // [9:12] is the sub-list for method output_type
	6, // [6:9] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_promotions_v1beta_promotions_proto_init() }
func file_google_shopping_merchant_promotions_v1beta_promotions_proto_init() {
	if File_google_shopping_merchant_promotions_v1beta_promotions_proto != nil {
		return
	}
	file_google_shopping_merchant_promotions_v1beta_promotions_common_proto_init()
	file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_promotions_v1beta_promotions_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_promotions_v1beta_promotions_proto_depIdxs,
		MessageInfos:      file_google_shopping_merchant_promotions_v1beta_promotions_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_promotions_v1beta_promotions_proto = out.File
	file_google_shopping_merchant_promotions_v1beta_promotions_proto_rawDesc = nil
	file_google_shopping_merchant_promotions_v1beta_promotions_proto_goTypes = nil
	file_google_shopping_merchant_promotions_v1beta_promotions_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PromotionsServiceClient is the client API for PromotionsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PromotionsServiceClient interface {
	// Inserts a promotion for your Merchant Center account. If the promotion
	// already exists, then it updates the promotion instead.
	InsertPromotion(ctx context.Context, in *InsertPromotionRequest, opts ...grpc.CallOption) (*Promotion, error)
	// Retrieves the promotion from your Merchant Center account.
	//
	// After inserting or updating a promotion input, it may take several
	// minutes before the updated promotion can be retrieved.
	GetPromotion(ctx context.Context, in *GetPromotionRequest, opts ...grpc.CallOption) (*Promotion, error)
	// Lists the promotions in your Merchant Center account. The
	// response might contain fewer items than specified by `pageSize`. Rely on
	// `pageToken` to determine if there are more items to be requested.
	//
	// After inserting or updating a promotion, it may take several minutes before
	// the updated processed promotion can be retrieved.
	ListPromotions(ctx context.Context, in *ListPromotionsRequest, opts ...grpc.CallOption) (*ListPromotionsResponse, error)
}

type promotionsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPromotionsServiceClient(cc grpc.ClientConnInterface) PromotionsServiceClient {
	return &promotionsServiceClient{cc}
}

func (c *promotionsServiceClient) InsertPromotion(ctx context.Context, in *InsertPromotionRequest, opts ...grpc.CallOption) (*Promotion, error) {
	out := new(Promotion)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.promotions.v1beta.PromotionsService/InsertPromotion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *promotionsServiceClient) GetPromotion(ctx context.Context, in *GetPromotionRequest, opts ...grpc.CallOption) (*Promotion, error) {
	out := new(Promotion)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.promotions.v1beta.PromotionsService/GetPromotion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *promotionsServiceClient) ListPromotions(ctx context.Context, in *ListPromotionsRequest, opts ...grpc.CallOption) (*ListPromotionsResponse, error) {
	out := new(ListPromotionsResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.promotions.v1beta.PromotionsService/ListPromotions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PromotionsServiceServer is the server API for PromotionsService service.
type PromotionsServiceServer interface {
	// Inserts a promotion for your Merchant Center account. If the promotion
	// already exists, then it updates the promotion instead.
	InsertPromotion(context.Context, *InsertPromotionRequest) (*Promotion, error)
	// Retrieves the promotion from your Merchant Center account.
	//
	// After inserting or updating a promotion input, it may take several
	// minutes before the updated promotion can be retrieved.
	GetPromotion(context.Context, *GetPromotionRequest) (*Promotion, error)
	// Lists the promotions in your Merchant Center account. The
	// response might contain fewer items than specified by `pageSize`. Rely on
	// `pageToken` to determine if there are more items to be requested.
	//
	// After inserting or updating a promotion, it may take several minutes before
	// the updated processed promotion can be retrieved.
	ListPromotions(context.Context, *ListPromotionsRequest) (*ListPromotionsResponse, error)
}

// UnimplementedPromotionsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPromotionsServiceServer struct {
}

func (*UnimplementedPromotionsServiceServer) InsertPromotion(context.Context, *InsertPromotionRequest) (*Promotion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertPromotion not implemented")
}
func (*UnimplementedPromotionsServiceServer) GetPromotion(context.Context, *GetPromotionRequest) (*Promotion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPromotion not implemented")
}
func (*UnimplementedPromotionsServiceServer) ListPromotions(context.Context, *ListPromotionsRequest) (*ListPromotionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPromotions not implemented")
}

func RegisterPromotionsServiceServer(s *grpc.Server, srv PromotionsServiceServer) {
	s.RegisterService(&_PromotionsService_serviceDesc, srv)
}

func _PromotionsService_InsertPromotion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertPromotionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PromotionsServiceServer).InsertPromotion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.promotions.v1beta.PromotionsService/InsertPromotion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PromotionsServiceServer).InsertPromotion(ctx, req.(*InsertPromotionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PromotionsService_GetPromotion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPromotionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PromotionsServiceServer).GetPromotion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.promotions.v1beta.PromotionsService/GetPromotion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PromotionsServiceServer).GetPromotion(ctx, req.(*GetPromotionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PromotionsService_ListPromotions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPromotionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PromotionsServiceServer).ListPromotions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.promotions.v1beta.PromotionsService/ListPromotions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PromotionsServiceServer).ListPromotions(ctx, req.(*ListPromotionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PromotionsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.promotions.v1beta.PromotionsService",
	HandlerType: (*PromotionsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "InsertPromotion",
			Handler:    _PromotionsService_InsertPromotion_Handler,
		},
		{
			MethodName: "GetPromotion",
			Handler:    _PromotionsService_GetPromotion_Handler,
		},
		{
			MethodName: "ListPromotions",
			Handler:    _PromotionsService_ListPromotions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/promotions/v1beta/promotions.proto",
}
