// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/shopping/merchant/lfp/v1beta/lfpsale.proto

package lfppb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	typepb "cloud.google.com/go/shopping/type/typepb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A sale for the merchant.
type LfpSale struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The name of the `LfpSale` resource.
	// Format:
	// `accounts/{account}/lfpSales/{sale}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The Merchant Center ID of the merchant to submit the sale for.
	TargetAccount int64 `protobuf:"varint,2,opt,name=target_account,json=targetAccount,proto3" json:"target_account,omitempty"`
	// Required. The identifier of the merchant's store. Either a `storeCode`
	// inserted through the API or the code of the store in the Business Profile.
	StoreCode string `protobuf:"bytes,3,opt,name=store_code,json=storeCode,proto3" json:"store_code,omitempty"`
	// Required. A unique identifier for the product. If both inventories and
	// sales are submitted for a merchant, this id should match for the same
	// product.
	//
	// **Note**: if the merchant sells the same product new and used, they should
	// have different IDs.
	OfferId string `protobuf:"bytes,4,opt,name=offer_id,json=offerId,proto3" json:"offer_id,omitempty"`
	// Required. The [CLDR territory
	// code](https://github.com/unicode-org/cldr/blob/latest/common/main/en.xml)
	// for the country where the product is sold.
	RegionCode string `protobuf:"bytes,5,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	// Required. The two-letter ISO 639-1 language code for the item.
	ContentLanguage string `protobuf:"bytes,6,opt,name=content_language,json=contentLanguage,proto3" json:"content_language,omitempty"`
	// Required. The Global Trade Item Number of the sold product.
	Gtin string `protobuf:"bytes,7,opt,name=gtin,proto3" json:"gtin,omitempty"`
	// Required. The unit price of the product.
	Price *typepb.Price `protobuf:"bytes,8,opt,name=price,proto3" json:"price,omitempty"`
	// Required. The relative change of the available quantity. Negative for items
	// returned.
	Quantity int64 `protobuf:"varint,9,opt,name=quantity,proto3" json:"quantity,omitempty"`
	// Required. The timestamp for the sale.
	SaleTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=sale_time,json=saleTime,proto3" json:"sale_time,omitempty"`
	// Output only. System generated globally unique ID for the `LfpSale`.
	Uid *string `protobuf:"bytes,11,opt,name=uid,proto3,oneof" json:"uid,omitempty"`
	// Optional. The [feed
	// label](https://developers.google.com/shopping-content/guides/products/feed-labels)
	// for the product. If this is not set, it will default to `regionCode`.
	FeedLabel *string `protobuf:"bytes,12,opt,name=feed_label,json=feedLabel,proto3,oneof" json:"feed_label,omitempty"`
}

func (x *LfpSale) Reset() {
	*x = LfpSale{}
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LfpSale) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LfpSale) ProtoMessage() {}

func (x *LfpSale) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LfpSale.ProtoReflect.Descriptor instead.
func (*LfpSale) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDescGZIP(), []int{0}
}

func (x *LfpSale) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LfpSale) GetTargetAccount() int64 {
	if x != nil {
		return x.TargetAccount
	}
	return 0
}

func (x *LfpSale) GetStoreCode() string {
	if x != nil {
		return x.StoreCode
	}
	return ""
}

func (x *LfpSale) GetOfferId() string {
	if x != nil {
		return x.OfferId
	}
	return ""
}

func (x *LfpSale) GetRegionCode() string {
	if x != nil {
		return x.RegionCode
	}
	return ""
}

func (x *LfpSale) GetContentLanguage() string {
	if x != nil {
		return x.ContentLanguage
	}
	return ""
}

func (x *LfpSale) GetGtin() string {
	if x != nil {
		return x.Gtin
	}
	return ""
}

func (x *LfpSale) GetPrice() *typepb.Price {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *LfpSale) GetQuantity() int64 {
	if x != nil {
		return x.Quantity
	}
	return 0
}

func (x *LfpSale) GetSaleTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SaleTime
	}
	return nil
}

func (x *LfpSale) GetUid() string {
	if x != nil && x.Uid != nil {
		return *x.Uid
	}
	return ""
}

func (x *LfpSale) GetFeedLabel() string {
	if x != nil && x.FeedLabel != nil {
		return *x.FeedLabel
	}
	return ""
}

// Request message for the InsertLfpSale method.
type InsertLfpSaleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The LFP provider account.
	// Format: `accounts/{lfp_partner}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The sale to insert.
	LfpSale *LfpSale `protobuf:"bytes,2,opt,name=lfp_sale,json=lfpSale,proto3" json:"lfp_sale,omitempty"`
}

func (x *InsertLfpSaleRequest) Reset() {
	*x = InsertLfpSaleRequest{}
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InsertLfpSaleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InsertLfpSaleRequest) ProtoMessage() {}

func (x *InsertLfpSaleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InsertLfpSaleRequest.ProtoReflect.Descriptor instead.
func (*InsertLfpSaleRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDescGZIP(), []int{1}
}

func (x *InsertLfpSaleRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *InsertLfpSaleRequest) GetLfpSale() *LfpSale {
	if x != nil {
		return x.LfpSale
	}
	return nil
}

var File_google_shopping_merchant_lfp_v1beta_lfpsale_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x6c, 0x66, 0x70, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6c, 0x66, 0x70, 0x73, 0x61, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6c, 0x66,
	0x70, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xdf, 0x04, 0x0a, 0x07,
	0x4c, 0x66, 0x70, 0x53, 0x61, 0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x22, 0x0a, 0x0a, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6f, 0x66, 0x66, 0x65,
	0x72, 0x49, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x2e, 0x0a, 0x10, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x67, 0x74, 0x69,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x67, 0x74,
	0x69, 0x6e, 0x12, 0x36, 0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x71, 0x75,
	0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x3c, 0x0a, 0x09, 0x73,
	0x61, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x73, 0x61, 0x6c, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x03, 0x75, 0x69, 0x64,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08,
	0x02, 0x08, 0x01, 0x48, 0x00, 0x52, 0x03, 0x75, 0x69, 0x64, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a,
	0x0a, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x09, 0x66, 0x65, 0x65, 0x64, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x3a, 0x5e, 0xea, 0x41, 0x5b, 0x0a, 0x22, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x66, 0x70, 0x53, 0x61, 0x6c, 0x65, 0x12,
	0x22, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x7d, 0x2f, 0x6c, 0x66, 0x70, 0x53, 0x61, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x61,
	0x6c, 0x65, 0x7d, 0x2a, 0x08, 0x6c, 0x66, 0x70, 0x53, 0x61, 0x6c, 0x65, 0x73, 0x32, 0x07, 0x6c,
	0x66, 0x70, 0x53, 0x61, 0x6c, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x75, 0x69, 0x64, 0x42, 0x0d,
	0x0a, 0x0b, 0x5f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x81, 0x01,
	0x0a, 0x14, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4c, 0x66, 0x70, 0x53, 0x61, 0x6c, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x4c, 0x0a, 0x08, 0x6c, 0x66, 0x70, 0x5f, 0x73, 0x61, 0x6c, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x6c, 0x66, 0x70, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x66, 0x70, 0x53,
	0x61, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6c, 0x66, 0x70, 0x53, 0x61, 0x6c,
	0x65, 0x32, 0x97, 0x02, 0x0a, 0x0e, 0x4c, 0x66, 0x70, 0x53, 0x61, 0x6c, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xbb, 0x01, 0x0a, 0x0d, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x4c,
	0x66, 0x70, 0x53, 0x61, 0x6c, 0x65, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
	0x74, 0x2e, 0x6c, 0x66, 0x70, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73,
	0x65, 0x72, 0x74, 0x4c, 0x66, 0x70, 0x53, 0x61, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6c, 0x66, 0x70,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x66, 0x70, 0x53, 0x61, 0x6c, 0x65, 0x22,
	0x41, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x08, 0x6c, 0x66, 0x70, 0x5f, 0x73, 0x61, 0x6c,
	0x65, 0x22, 0x2f, 0x2f, 0x6c, 0x66, 0x70, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x6c, 0x66, 0x70, 0x53, 0x61, 0x6c, 0x65, 0x73, 0x3a, 0x69, 0x6e, 0x73, 0x65,
	0x72, 0x74, 0x1a, 0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61,
	0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x7a, 0x0a, 0x27, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x6c, 0x66, 0x70, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0c, 0x4c, 0x66, 0x70, 0x53, 0x61, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x6c, 0x66,
	0x70, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6c, 0x66, 0x70, 0x70,
	0x62, 0x3b, 0x6c, 0x66, 0x70, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDescData = file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDesc
)

func file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDescData)
	})
	return file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDescData
}

var file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_goTypes = []any{
	(*LfpSale)(nil),               // 0: google.shopping.merchant.lfp.v1beta.LfpSale
	(*InsertLfpSaleRequest)(nil),  // 1: google.shopping.merchant.lfp.v1beta.InsertLfpSaleRequest
	(*typepb.Price)(nil),          // 2: google.shopping.type.Price
	(*timestamppb.Timestamp)(nil), // 3: google.protobuf.Timestamp
}
var file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_depIdxs = []int32{
	2, // 0: google.shopping.merchant.lfp.v1beta.LfpSale.price:type_name -> google.shopping.type.Price
	3, // 1: google.shopping.merchant.lfp.v1beta.LfpSale.sale_time:type_name -> google.protobuf.Timestamp
	0, // 2: google.shopping.merchant.lfp.v1beta.InsertLfpSaleRequest.lfp_sale:type_name -> google.shopping.merchant.lfp.v1beta.LfpSale
	1, // 3: google.shopping.merchant.lfp.v1beta.LfpSaleService.InsertLfpSale:input_type -> google.shopping.merchant.lfp.v1beta.InsertLfpSaleRequest
	0, // 4: google.shopping.merchant.lfp.v1beta.LfpSaleService.InsertLfpSale:output_type -> google.shopping.merchant.lfp.v1beta.LfpSale
	4, // [4:5] is the sub-list for method output_type
	3, // [3:4] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_init() }
func file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_init() {
	if File_google_shopping_merchant_lfp_v1beta_lfpsale_proto != nil {
		return
	}
	file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_depIdxs,
		MessageInfos:      file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_lfp_v1beta_lfpsale_proto = out.File
	file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_rawDesc = nil
	file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_goTypes = nil
	file_google_shopping_merchant_lfp_v1beta_lfpsale_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// LfpSaleServiceClient is the client API for LfpSaleService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LfpSaleServiceClient interface {
	// Inserts a `LfpSale` for the given merchant.
	InsertLfpSale(ctx context.Context, in *InsertLfpSaleRequest, opts ...grpc.CallOption) (*LfpSale, error)
}

type lfpSaleServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLfpSaleServiceClient(cc grpc.ClientConnInterface) LfpSaleServiceClient {
	return &lfpSaleServiceClient{cc}
}

func (c *lfpSaleServiceClient) InsertLfpSale(ctx context.Context, in *InsertLfpSaleRequest, opts ...grpc.CallOption) (*LfpSale, error) {
	out := new(LfpSale)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.lfp.v1beta.LfpSaleService/InsertLfpSale", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LfpSaleServiceServer is the server API for LfpSaleService service.
type LfpSaleServiceServer interface {
	// Inserts a `LfpSale` for the given merchant.
	InsertLfpSale(context.Context, *InsertLfpSaleRequest) (*LfpSale, error)
}

// UnimplementedLfpSaleServiceServer can be embedded to have forward compatible implementations.
type UnimplementedLfpSaleServiceServer struct {
}

func (*UnimplementedLfpSaleServiceServer) InsertLfpSale(context.Context, *InsertLfpSaleRequest) (*LfpSale, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InsertLfpSale not implemented")
}

func RegisterLfpSaleServiceServer(s *grpc.Server, srv LfpSaleServiceServer) {
	s.RegisterService(&_LfpSaleService_serviceDesc, srv)
}

func _LfpSaleService_InsertLfpSale_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertLfpSaleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LfpSaleServiceServer).InsertLfpSale(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.lfp.v1beta.LfpSaleService/InsertLfpSale",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LfpSaleServiceServer).InsertLfpSale(ctx, req.(*InsertLfpSaleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LfpSaleService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.lfp.v1beta.LfpSaleService",
	HandlerType: (*LfpSaleServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "InsertLfpSale",
			Handler:    _LfpSaleService_InsertLfpSale_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/lfp/v1beta/lfpsale.proto",
}
