// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/oracledatabase/v1/oracledatabase.proto

package oracledatabasepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The request for `CloudExadataInfrastructures.List`.
type ListCloudExadataInfrastructuresRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent value for CloudExadataInfrastructure in the following
	// format: projects/{project}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If unspecified, at most 50 Exadata infrastructures will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListCloudExadataInfrastructuresRequest) Reset() {
	*x = ListCloudExadataInfrastructuresRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCloudExadataInfrastructuresRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudExadataInfrastructuresRequest) ProtoMessage() {}

func (x *ListCloudExadataInfrastructuresRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudExadataInfrastructuresRequest.ProtoReflect.Descriptor instead.
func (*ListCloudExadataInfrastructuresRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{0}
}

func (x *ListCloudExadataInfrastructuresRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCloudExadataInfrastructuresRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCloudExadataInfrastructuresRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for `CloudExadataInfrastructures.list`.
type ListCloudExadataInfrastructuresResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Exadata Infrastructures.
	CloudExadataInfrastructures []*CloudExadataInfrastructure `protobuf:"bytes,1,rep,name=cloud_exadata_infrastructures,json=cloudExadataInfrastructures,proto3" json:"cloud_exadata_infrastructures,omitempty"`
	// A token for fetching next page of response.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCloudExadataInfrastructuresResponse) Reset() {
	*x = ListCloudExadataInfrastructuresResponse{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCloudExadataInfrastructuresResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudExadataInfrastructuresResponse) ProtoMessage() {}

func (x *ListCloudExadataInfrastructuresResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudExadataInfrastructuresResponse.ProtoReflect.Descriptor instead.
func (*ListCloudExadataInfrastructuresResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{1}
}

func (x *ListCloudExadataInfrastructuresResponse) GetCloudExadataInfrastructures() []*CloudExadataInfrastructure {
	if x != nil {
		return x.CloudExadataInfrastructures
	}
	return nil
}

func (x *ListCloudExadataInfrastructuresResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for `CloudExadataInfrastructure.Get`.
type GetCloudExadataInfrastructureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Cloud Exadata Infrastructure in the following
	// format:
	// projects/{project}/locations/{location}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCloudExadataInfrastructureRequest) Reset() {
	*x = GetCloudExadataInfrastructureRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCloudExadataInfrastructureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCloudExadataInfrastructureRequest) ProtoMessage() {}

func (x *GetCloudExadataInfrastructureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCloudExadataInfrastructureRequest.ProtoReflect.Descriptor instead.
func (*GetCloudExadataInfrastructureRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{2}
}

func (x *GetCloudExadataInfrastructureRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for `CloudExadataInfrastructure.Create`.
type CreateCloudExadataInfrastructureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent value for CloudExadataInfrastructure in the following
	// format: projects/{project}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the Exadata Infrastructure to create. This value is
	// restricted to (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum of
	// 63 characters in length. The value must start with a letter and end with a
	// letter or a number.
	CloudExadataInfrastructureId string `protobuf:"bytes,2,opt,name=cloud_exadata_infrastructure_id,json=cloudExadataInfrastructureId,proto3" json:"cloud_exadata_infrastructure_id,omitempty"`
	// Required. Details of the Exadata Infrastructure instance to create.
	CloudExadataInfrastructure *CloudExadataInfrastructure `protobuf:"bytes,3,opt,name=cloud_exadata_infrastructure,json=cloudExadataInfrastructure,proto3" json:"cloud_exadata_infrastructure,omitempty"`
	// Optional. An optional ID to identify the request. This value is used to
	// identify duplicate requests. If you make a request with the same request ID
	// and the original request is still in progress or completed, the server
	// ignores the second request. This prevents clients from
	// accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateCloudExadataInfrastructureRequest) Reset() {
	*x = CreateCloudExadataInfrastructureRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCloudExadataInfrastructureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCloudExadataInfrastructureRequest) ProtoMessage() {}

func (x *CreateCloudExadataInfrastructureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCloudExadataInfrastructureRequest.ProtoReflect.Descriptor instead.
func (*CreateCloudExadataInfrastructureRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{3}
}

func (x *CreateCloudExadataInfrastructureRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCloudExadataInfrastructureRequest) GetCloudExadataInfrastructureId() string {
	if x != nil {
		return x.CloudExadataInfrastructureId
	}
	return ""
}

func (x *CreateCloudExadataInfrastructureRequest) GetCloudExadataInfrastructure() *CloudExadataInfrastructure {
	if x != nil {
		return x.CloudExadataInfrastructure
	}
	return nil
}

func (x *CreateCloudExadataInfrastructureRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request for `CloudExadataInfrastructure.Delete`.
type DeleteCloudExadataInfrastructureRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Cloud Exadata Infrastructure in the following
	// format:
	// projects/{project}/locations/{location}/cloudExadataInfrastructures/{cloud_exadata_infrastructure}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional ID to identify the request. This value is used to
	// identify duplicate requests. If you make a request with the same request ID
	// and the original request is still in progress or completed, the server
	// ignores the second request. This prevents clients from
	// accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, all VM clusters for this Exadata Infrastructure
	// will be deleted. An Exadata Infrastructure can only be deleted once all its
	// VM clusters have been deleted.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteCloudExadataInfrastructureRequest) Reset() {
	*x = DeleteCloudExadataInfrastructureRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteCloudExadataInfrastructureRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCloudExadataInfrastructureRequest) ProtoMessage() {}

func (x *DeleteCloudExadataInfrastructureRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCloudExadataInfrastructureRequest.ProtoReflect.Descriptor instead.
func (*DeleteCloudExadataInfrastructureRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteCloudExadataInfrastructureRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteCloudExadataInfrastructureRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteCloudExadataInfrastructureRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The request for `CloudVmCluster.List`.
type ListCloudVmClustersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent in the following format:
	// projects/{project}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The number of VM clusters to return.
	// If unspecified, at most 50 VM clusters will be returned.
	// The maximum value is 1,000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying the page of results the server returns.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. An expression for filtering the results of the request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListCloudVmClustersRequest) Reset() {
	*x = ListCloudVmClustersRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCloudVmClustersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudVmClustersRequest) ProtoMessage() {}

func (x *ListCloudVmClustersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudVmClustersRequest.ProtoReflect.Descriptor instead.
func (*ListCloudVmClustersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{5}
}

func (x *ListCloudVmClustersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCloudVmClustersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCloudVmClustersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCloudVmClustersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response for `CloudVmCluster.List`.
type ListCloudVmClustersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of VM Clusters.
	CloudVmClusters []*CloudVmCluster `protobuf:"bytes,1,rep,name=cloud_vm_clusters,json=cloudVmClusters,proto3" json:"cloud_vm_clusters,omitempty"`
	// A token to fetch the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListCloudVmClustersResponse) Reset() {
	*x = ListCloudVmClustersResponse{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCloudVmClustersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloudVmClustersResponse) ProtoMessage() {}

func (x *ListCloudVmClustersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloudVmClustersResponse.ProtoReflect.Descriptor instead.
func (*ListCloudVmClustersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{6}
}

func (x *ListCloudVmClustersResponse) GetCloudVmClusters() []*CloudVmCluster {
	if x != nil {
		return x.CloudVmClusters
	}
	return nil
}

func (x *ListCloudVmClustersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for `CloudVmCluster.Get`.
type GetCloudVmClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Cloud VM Cluster in the following format:
	// projects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluster}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCloudVmClusterRequest) Reset() {
	*x = GetCloudVmClusterRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCloudVmClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCloudVmClusterRequest) ProtoMessage() {}

func (x *GetCloudVmClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCloudVmClusterRequest.ProtoReflect.Descriptor instead.
func (*GetCloudVmClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{7}
}

func (x *GetCloudVmClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for `CloudVmCluster.Create`.
type CreateCloudVmClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent in the following format:
	// projects/{project}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the VM Cluster to create. This value is restricted
	// to (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum of 63
	// characters in length. The value must start with a letter and end with
	// a letter or a number.
	CloudVmClusterId string `protobuf:"bytes,2,opt,name=cloud_vm_cluster_id,json=cloudVmClusterId,proto3" json:"cloud_vm_cluster_id,omitempty"`
	// Required. The resource being created
	CloudVmCluster *CloudVmCluster `protobuf:"bytes,3,opt,name=cloud_vm_cluster,json=cloudVmCluster,proto3" json:"cloud_vm_cluster,omitempty"`
	// Optional. An optional ID to identify the request. This value is used to
	// identify duplicate requests. If you make a request with the same request ID
	// and the original request is still in progress or completed, the server
	// ignores the second request. This prevents clients from
	// accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateCloudVmClusterRequest) Reset() {
	*x = CreateCloudVmClusterRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCloudVmClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCloudVmClusterRequest) ProtoMessage() {}

func (x *CreateCloudVmClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCloudVmClusterRequest.ProtoReflect.Descriptor instead.
func (*CreateCloudVmClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{8}
}

func (x *CreateCloudVmClusterRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCloudVmClusterRequest) GetCloudVmClusterId() string {
	if x != nil {
		return x.CloudVmClusterId
	}
	return ""
}

func (x *CreateCloudVmClusterRequest) GetCloudVmCluster() *CloudVmCluster {
	if x != nil {
		return x.CloudVmCluster
	}
	return nil
}

func (x *CreateCloudVmClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request for `CloudVmCluster.Delete`.
type DeleteCloudVmClusterRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Cloud VM Cluster in the following format:
	// projects/{project}/locations/{location}/cloudVmClusters/{cloud_vm_cluster}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional ID to identify the request. This value is used to
	// identify duplicate requests. If you make a request with the same request ID
	// and the original request is still in progress or completed, the server
	// ignores the second request. This prevents clients from
	// accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, all child resources for the VM Cluster will be
	// deleted. A VM Cluster can only be deleted once all its child resources have
	// been deleted.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteCloudVmClusterRequest) Reset() {
	*x = DeleteCloudVmClusterRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteCloudVmClusterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCloudVmClusterRequest) ProtoMessage() {}

func (x *DeleteCloudVmClusterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCloudVmClusterRequest.ProtoReflect.Descriptor instead.
func (*DeleteCloudVmClusterRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteCloudVmClusterRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteCloudVmClusterRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteCloudVmClusterRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The request for `Entitlement.List`.
type ListEntitlementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent value for the entitlement in the following format:
	// projects/{project}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If unspecified, a maximum of 50 entitlements will be returned.
	// The maximum value is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListEntitlementsRequest) Reset() {
	*x = ListEntitlementsRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntitlementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntitlementsRequest) ProtoMessage() {}

func (x *ListEntitlementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntitlementsRequest.ProtoReflect.Descriptor instead.
func (*ListEntitlementsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{10}
}

func (x *ListEntitlementsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntitlementsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntitlementsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for `Entitlement.List`.
type ListEntitlementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Entitlements
	Entitlements []*Entitlement `protobuf:"bytes,1,rep,name=entitlements,proto3" json:"entitlements,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntitlementsResponse) Reset() {
	*x = ListEntitlementsResponse{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntitlementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntitlementsResponse) ProtoMessage() {}

func (x *ListEntitlementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntitlementsResponse.ProtoReflect.Descriptor instead.
func (*ListEntitlementsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{11}
}

func (x *ListEntitlementsResponse) GetEntitlements() []*Entitlement {
	if x != nil {
		return x.Entitlements
	}
	return nil
}

func (x *ListEntitlementsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for `DbServer.List`.
type ListDbServersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent value for database server in the following format:
	// projects/{project}/locations/{location}/cloudExadataInfrastructures/{cloudExadataInfrastructure}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If unspecified, a maximum of 50 db servers will be returned.
	// The maximum value is 1000; values above 1000 will be reset to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDbServersRequest) Reset() {
	*x = ListDbServersRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDbServersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDbServersRequest) ProtoMessage() {}

func (x *ListDbServersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDbServersRequest.ProtoReflect.Descriptor instead.
func (*ListDbServersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{12}
}

func (x *ListDbServersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDbServersRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDbServersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for `DbServer.List`.
type ListDbServersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of database servers.
	DbServers []*DbServer `protobuf:"bytes,1,rep,name=db_servers,json=dbServers,proto3" json:"db_servers,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDbServersResponse) Reset() {
	*x = ListDbServersResponse{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDbServersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDbServersResponse) ProtoMessage() {}

func (x *ListDbServersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDbServersResponse.ProtoReflect.Descriptor instead.
func (*ListDbServersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{13}
}

func (x *ListDbServersResponse) GetDbServers() []*DbServer {
	if x != nil {
		return x.DbServers
	}
	return nil
}

func (x *ListDbServersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for `DbNode.List`.
type ListDbNodesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent value for database node in the following format:
	// projects/{project}/locations/{location}/cloudVmClusters/{cloudVmCluster}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If unspecified, at most 50 db nodes will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the node should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDbNodesRequest) Reset() {
	*x = ListDbNodesRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDbNodesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDbNodesRequest) ProtoMessage() {}

func (x *ListDbNodesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDbNodesRequest.ProtoReflect.Descriptor instead.
func (*ListDbNodesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{14}
}

func (x *ListDbNodesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDbNodesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDbNodesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for `DbNode.List`.
type ListDbNodesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of DB Nodes
	DbNodes []*DbNode `protobuf:"bytes,1,rep,name=db_nodes,json=dbNodes,proto3" json:"db_nodes,omitempty"`
	// A token identifying a page of results the node should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDbNodesResponse) Reset() {
	*x = ListDbNodesResponse{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDbNodesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDbNodesResponse) ProtoMessage() {}

func (x *ListDbNodesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDbNodesResponse.ProtoReflect.Descriptor instead.
func (*ListDbNodesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{15}
}

func (x *ListDbNodesResponse) GetDbNodes() []*DbNode {
	if x != nil {
		return x.DbNodes
	}
	return nil
}

func (x *ListDbNodesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for `GiVersion.List`.
type ListGiVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent value for Grid Infrastructure Version in the following
	// format: Format: projects/{project}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If unspecified, a maximum of 50 Oracle Grid Infrastructure (GI) versions
	// will be returned. The maximum value is 1000; values above 1000 will be
	// reset to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListGiVersionsRequest) Reset() {
	*x = ListGiVersionsRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGiVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGiVersionsRequest) ProtoMessage() {}

func (x *ListGiVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGiVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListGiVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{16}
}

func (x *ListGiVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGiVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGiVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for `GiVersion.List`.
type ListGiVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Oracle Grid Infrastructure (GI) versions.
	GiVersions []*GiVersion `protobuf:"bytes,1,rep,name=gi_versions,json=giVersions,proto3" json:"gi_versions,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListGiVersionsResponse) Reset() {
	*x = ListGiVersionsResponse{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGiVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGiVersionsResponse) ProtoMessage() {}

func (x *ListGiVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGiVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListGiVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{17}
}

func (x *ListGiVersionsResponse) GetGiVersions() []*GiVersion {
	if x != nil {
		return x.GiVersions
	}
	return nil
}

func (x *ListGiVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for `DbSystemShape.List`.
type ListDbSystemShapesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent value for Database System Shapes in the following
	// format: projects/{project}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If unspecified, at most 50 database system shapes will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDbSystemShapesRequest) Reset() {
	*x = ListDbSystemShapesRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDbSystemShapesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDbSystemShapesRequest) ProtoMessage() {}

func (x *ListDbSystemShapesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDbSystemShapesRequest.ProtoReflect.Descriptor instead.
func (*ListDbSystemShapesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{18}
}

func (x *ListDbSystemShapesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDbSystemShapesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDbSystemShapesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for `DbSystemShape.List`.
type ListDbSystemShapesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Database System shapes.
	DbSystemShapes []*DbSystemShape `protobuf:"bytes,1,rep,name=db_system_shapes,json=dbSystemShapes,proto3" json:"db_system_shapes,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDbSystemShapesResponse) Reset() {
	*x = ListDbSystemShapesResponse{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDbSystemShapesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDbSystemShapesResponse) ProtoMessage() {}

func (x *ListDbSystemShapesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDbSystemShapesResponse.ProtoReflect.Descriptor instead.
func (*ListDbSystemShapesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{19}
}

func (x *ListDbSystemShapesResponse) GetDbSystemShapes() []*DbSystemShape {
	if x != nil {
		return x.DbSystemShapes
	}
	return nil
}

func (x *ListDbSystemShapesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. The status of the operation.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have been cancelled successfully
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	// Output only. An estimated percentage of the operation that has been
	// completed at a given moment of time, between 0 and 100.
	PercentComplete float64 `protobuf:"fixed64,8,opt,name=percent_complete,json=percentComplete,proto3" json:"percent_complete,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{20}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

func (x *OperationMetadata) GetPercentComplete() float64 {
	if x != nil {
		return x.PercentComplete
	}
	return 0
}

// The request for `AutonomousDatabase.List`.
type ListAutonomousDatabasesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent value for the Autonomous Database in the following
	// format: projects/{project}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If unspecified, at most 50 Autonomous Database will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. An expression for filtering the results of the request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. An expression for ordering the results of the request.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListAutonomousDatabasesRequest) Reset() {
	*x = ListAutonomousDatabasesRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAutonomousDatabasesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAutonomousDatabasesRequest) ProtoMessage() {}

func (x *ListAutonomousDatabasesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAutonomousDatabasesRequest.ProtoReflect.Descriptor instead.
func (*ListAutonomousDatabasesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{21}
}

func (x *ListAutonomousDatabasesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAutonomousDatabasesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAutonomousDatabasesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAutonomousDatabasesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAutonomousDatabasesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response for `AutonomousDatabase.List`.
type ListAutonomousDatabasesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Autonomous Databases.
	AutonomousDatabases []*AutonomousDatabase `protobuf:"bytes,1,rep,name=autonomous_databases,json=autonomousDatabases,proto3" json:"autonomous_databases,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAutonomousDatabasesResponse) Reset() {
	*x = ListAutonomousDatabasesResponse{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAutonomousDatabasesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAutonomousDatabasesResponse) ProtoMessage() {}

func (x *ListAutonomousDatabasesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAutonomousDatabasesResponse.ProtoReflect.Descriptor instead.
func (*ListAutonomousDatabasesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{22}
}

func (x *ListAutonomousDatabasesResponse) GetAutonomousDatabases() []*AutonomousDatabase {
	if x != nil {
		return x.AutonomousDatabases
	}
	return nil
}

func (x *ListAutonomousDatabasesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for `AutonomousDatabase.Get`.
type GetAutonomousDatabaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Autonomous Database in the following format:
	// projects/{project}/locations/{location}/autonomousDatabases/{autonomous_database}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAutonomousDatabaseRequest) Reset() {
	*x = GetAutonomousDatabaseRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAutonomousDatabaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAutonomousDatabaseRequest) ProtoMessage() {}

func (x *GetAutonomousDatabaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAutonomousDatabaseRequest.ProtoReflect.Descriptor instead.
func (*GetAutonomousDatabaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{23}
}

func (x *GetAutonomousDatabaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for `AutonomousDatabase.Create`.
type CreateAutonomousDatabaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the parent in the following format:
	// projects/{project}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the Autonomous Database to create. This value is
	// restricted to (^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$) and must be a maximum of
	// 63 characters in length. The value must start with a letter and end with a
	// letter or a number.
	AutonomousDatabaseId string `protobuf:"bytes,2,opt,name=autonomous_database_id,json=autonomousDatabaseId,proto3" json:"autonomous_database_id,omitempty"`
	// Required. The Autonomous Database being created.
	AutonomousDatabase *AutonomousDatabase `protobuf:"bytes,3,opt,name=autonomous_database,json=autonomousDatabase,proto3" json:"autonomous_database,omitempty"`
	// Optional. An optional ID to identify the request. This value is used to
	// identify duplicate requests. If you make a request with the same request ID
	// and the original request is still in progress or completed, the server
	// ignores the second request. This prevents clients from
	// accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateAutonomousDatabaseRequest) Reset() {
	*x = CreateAutonomousDatabaseRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAutonomousDatabaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAutonomousDatabaseRequest) ProtoMessage() {}

func (x *CreateAutonomousDatabaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAutonomousDatabaseRequest.ProtoReflect.Descriptor instead.
func (*CreateAutonomousDatabaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{24}
}

func (x *CreateAutonomousDatabaseRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAutonomousDatabaseRequest) GetAutonomousDatabaseId() string {
	if x != nil {
		return x.AutonomousDatabaseId
	}
	return ""
}

func (x *CreateAutonomousDatabaseRequest) GetAutonomousDatabase() *AutonomousDatabase {
	if x != nil {
		return x.AutonomousDatabase
	}
	return nil
}

func (x *CreateAutonomousDatabaseRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request for `AutonomousDatabase.Delete`.
type DeleteAutonomousDatabaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the resource in the following format:
	// projects/{project}/locations/{location}/autonomousDatabases/{autonomous_database}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional ID to identify the request. This value is used to
	// identify duplicate requests. If you make a request with the same request ID
	// and the original request is still in progress or completed, the server
	// ignores the second request. This prevents clients from
	// accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteAutonomousDatabaseRequest) Reset() {
	*x = DeleteAutonomousDatabaseRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAutonomousDatabaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAutonomousDatabaseRequest) ProtoMessage() {}

func (x *DeleteAutonomousDatabaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAutonomousDatabaseRequest.ProtoReflect.Descriptor instead.
func (*DeleteAutonomousDatabaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{25}
}

func (x *DeleteAutonomousDatabaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAutonomousDatabaseRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// The request for `AutonomousDatabase.Restore`.
type RestoreAutonomousDatabaseRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Autonomous Database in the following format:
	// projects/{project}/locations/{location}/autonomousDatabases/{autonomous_database}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The time and date to restore the database to.
	RestoreTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=restore_time,json=restoreTime,proto3" json:"restore_time,omitempty"`
}

func (x *RestoreAutonomousDatabaseRequest) Reset() {
	*x = RestoreAutonomousDatabaseRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RestoreAutonomousDatabaseRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreAutonomousDatabaseRequest) ProtoMessage() {}

func (x *RestoreAutonomousDatabaseRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreAutonomousDatabaseRequest.ProtoReflect.Descriptor instead.
func (*RestoreAutonomousDatabaseRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{26}
}

func (x *RestoreAutonomousDatabaseRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RestoreAutonomousDatabaseRequest) GetRestoreTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RestoreTime
	}
	return nil
}

// The request for `AutonomousDatabase.GenerateWallet`.
type GenerateAutonomousDatabaseWalletRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Autonomous Database in the following format:
	// projects/{project}/locations/{location}/autonomousDatabases/{autonomous_database}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The type of wallet generation for the Autonomous Database. The
	// default value is SINGLE.
	Type GenerateType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.oracledatabase.v1.GenerateType" json:"type,omitempty"`
	// Optional. True when requesting regional connection strings in PDB connect
	// info, applicable to cross-region Data Guard only.
	IsRegional bool `protobuf:"varint,3,opt,name=is_regional,json=isRegional,proto3" json:"is_regional,omitempty"`
	// Required. The password used to encrypt the keys inside the wallet. The
	// password must be a minimum of 8 characters.
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
}

func (x *GenerateAutonomousDatabaseWalletRequest) Reset() {
	*x = GenerateAutonomousDatabaseWalletRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateAutonomousDatabaseWalletRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAutonomousDatabaseWalletRequest) ProtoMessage() {}

func (x *GenerateAutonomousDatabaseWalletRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAutonomousDatabaseWalletRequest.ProtoReflect.Descriptor instead.
func (*GenerateAutonomousDatabaseWalletRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{27}
}

func (x *GenerateAutonomousDatabaseWalletRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GenerateAutonomousDatabaseWalletRequest) GetType() GenerateType {
	if x != nil {
		return x.Type
	}
	return GenerateType_GENERATE_TYPE_UNSPECIFIED
}

func (x *GenerateAutonomousDatabaseWalletRequest) GetIsRegional() bool {
	if x != nil {
		return x.IsRegional
	}
	return false
}

func (x *GenerateAutonomousDatabaseWalletRequest) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

// The response for `AutonomousDatabase.GenerateWallet`.
type GenerateAutonomousDatabaseWalletResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The base64 encoded wallet files.
	ArchiveContent []byte `protobuf:"bytes,1,opt,name=archive_content,json=archiveContent,proto3" json:"archive_content,omitempty"`
}

func (x *GenerateAutonomousDatabaseWalletResponse) Reset() {
	*x = GenerateAutonomousDatabaseWalletResponse{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateAutonomousDatabaseWalletResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateAutonomousDatabaseWalletResponse) ProtoMessage() {}

func (x *GenerateAutonomousDatabaseWalletResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateAutonomousDatabaseWalletResponse.ProtoReflect.Descriptor instead.
func (*GenerateAutonomousDatabaseWalletResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{28}
}

func (x *GenerateAutonomousDatabaseWalletResponse) GetArchiveContent() []byte {
	if x != nil {
		return x.ArchiveContent
	}
	return nil
}

// The request for `AutonomousDbVersion.List`.
type ListAutonomousDbVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent value for the Autonomous Database in the following
	// format: projects/{project}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If unspecified, at most 50 Autonomous DB Versions will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAutonomousDbVersionsRequest) Reset() {
	*x = ListAutonomousDbVersionsRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAutonomousDbVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAutonomousDbVersionsRequest) ProtoMessage() {}

func (x *ListAutonomousDbVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAutonomousDbVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListAutonomousDbVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{29}
}

func (x *ListAutonomousDbVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAutonomousDbVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAutonomousDbVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for `AutonomousDbVersion.List`.
type ListAutonomousDbVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Autonomous Database versions.
	AutonomousDbVersions []*AutonomousDbVersion `protobuf:"bytes,1,rep,name=autonomous_db_versions,json=autonomousDbVersions,proto3" json:"autonomous_db_versions,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAutonomousDbVersionsResponse) Reset() {
	*x = ListAutonomousDbVersionsResponse{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAutonomousDbVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAutonomousDbVersionsResponse) ProtoMessage() {}

func (x *ListAutonomousDbVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAutonomousDbVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListAutonomousDbVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{30}
}

func (x *ListAutonomousDbVersionsResponse) GetAutonomousDbVersions() []*AutonomousDbVersion {
	if x != nil {
		return x.AutonomousDbVersions
	}
	return nil
}

func (x *ListAutonomousDbVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for `AutonomousDatabaseCharacterSet.List`.
type ListAutonomousDatabaseCharacterSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent value for the Autonomous Database in the following
	// format: projects/{project}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If unspecified, at most 50 Autonomous DB Character Sets will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. An expression for filtering the results of the request. Only the
	// **character_set_type** field is supported in the following format:
	// `character_set_type="{characterSetType}"`. Accepted values include
	// `DATABASE` and `NATIONAL`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListAutonomousDatabaseCharacterSetsRequest) Reset() {
	*x = ListAutonomousDatabaseCharacterSetsRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAutonomousDatabaseCharacterSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAutonomousDatabaseCharacterSetsRequest) ProtoMessage() {}

func (x *ListAutonomousDatabaseCharacterSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAutonomousDatabaseCharacterSetsRequest.ProtoReflect.Descriptor instead.
func (*ListAutonomousDatabaseCharacterSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{31}
}

func (x *ListAutonomousDatabaseCharacterSetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAutonomousDatabaseCharacterSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAutonomousDatabaseCharacterSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAutonomousDatabaseCharacterSetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response for `AutonomousDatabaseCharacterSet.List`.
type ListAutonomousDatabaseCharacterSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Autonomous Database Character Sets.
	AutonomousDatabaseCharacterSets []*AutonomousDatabaseCharacterSet `protobuf:"bytes,1,rep,name=autonomous_database_character_sets,json=autonomousDatabaseCharacterSets,proto3" json:"autonomous_database_character_sets,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAutonomousDatabaseCharacterSetsResponse) Reset() {
	*x = ListAutonomousDatabaseCharacterSetsResponse{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAutonomousDatabaseCharacterSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAutonomousDatabaseCharacterSetsResponse) ProtoMessage() {}

func (x *ListAutonomousDatabaseCharacterSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAutonomousDatabaseCharacterSetsResponse.ProtoReflect.Descriptor instead.
func (*ListAutonomousDatabaseCharacterSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{32}
}

func (x *ListAutonomousDatabaseCharacterSetsResponse) GetAutonomousDatabaseCharacterSets() []*AutonomousDatabaseCharacterSet {
	if x != nil {
		return x.AutonomousDatabaseCharacterSets
	}
	return nil
}

func (x *ListAutonomousDatabaseCharacterSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for `AutonomousDatabaseBackup.List`.
type ListAutonomousDatabaseBackupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent value for ListAutonomousDatabaseBackups in the
	// following format: projects/{project}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. An expression for filtering the results of the request. Only the
	// **autonomous_database_id** field is supported in the following format:
	// `autonomous_database_id="{autonomous_database_id}"`. The accepted values
	// must be a valid Autonomous Database ID, limited to the naming
	// restrictions of the ID: ^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$).
	// The ID must start with a letter, end with a letter or a number, and be
	// a maximum of 63 characters.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of items to return.
	// If unspecified, at most 50 Autonomous DB Backups will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAutonomousDatabaseBackupsRequest) Reset() {
	*x = ListAutonomousDatabaseBackupsRequest{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAutonomousDatabaseBackupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAutonomousDatabaseBackupsRequest) ProtoMessage() {}

func (x *ListAutonomousDatabaseBackupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAutonomousDatabaseBackupsRequest.ProtoReflect.Descriptor instead.
func (*ListAutonomousDatabaseBackupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{33}
}

func (x *ListAutonomousDatabaseBackupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAutonomousDatabaseBackupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAutonomousDatabaseBackupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAutonomousDatabaseBackupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for `AutonomousDatabaseBackup.List`.
type ListAutonomousDatabaseBackupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Autonomous Database Backups.
	AutonomousDatabaseBackups []*AutonomousDatabaseBackup `protobuf:"bytes,1,rep,name=autonomous_database_backups,json=autonomousDatabaseBackups,proto3" json:"autonomous_database_backups,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAutonomousDatabaseBackupsResponse) Reset() {
	*x = ListAutonomousDatabaseBackupsResponse{}
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAutonomousDatabaseBackupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAutonomousDatabaseBackupsResponse) ProtoMessage() {}

func (x *ListAutonomousDatabaseBackupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAutonomousDatabaseBackupsResponse.ProtoReflect.Descriptor instead.
func (*ListAutonomousDatabaseBackupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP(), []int{34}
}

func (x *ListAutonomousDatabaseBackupsResponse) GetAutonomousDatabaseBackups() []*AutonomousDatabaseBackup {
	if x != nil {
		return x.AutonomousDatabaseBackups
	}
	return nil
}

func (x *ListAutonomousDatabaseBackupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_cloud_oracledatabase_v1_oracledatabase_proto protoreflect.FileDescriptor

var file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f,
	0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f,
	0x75, 0x73, 0x5f, 0x64, 0x62, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x62,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64,
	0x62, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x62, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x62, 0x5f,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6e, 0x66,
	0x72, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x67, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x6d, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc8, 0x01,
	0x0a, 0x26, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x40, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3a,
	0x12, 0x38, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72,
	0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd1, 0x01, 0x0a, 0x27, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66,
	0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7e, 0x0a, 0x1d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x65, 0x78,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x1b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x7c, 0x0a, 0x24,
	0x47, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49,
	0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x40, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3a, 0x0a, 0x38, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45,
	0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xff, 0x02, 0x0a, 0x27, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x58, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x40, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3a, 0x12, 0x38,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x4a, 0x0a, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x65, 0x78, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1c,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72,
	0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x49, 0x64, 0x12, 0x81, 0x01, 0x0a,
	0x1c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x65, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69,
	0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x1a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xc6, 0x01, 0x0a,
	0x27, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x54, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x40, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3a, 0x0a, 0x38,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xcd, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa1, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x11, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x76,
	0x6d, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x0f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x64, 0x0a, 0x18, 0x47, 0x65, 0x74,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xaa, 0x02, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56,
	0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x32, 0x0a,
	0x13, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x76, 0x6d, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x5d, 0x0a, 0x10, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x76, 0x6d, 0x5f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xae, 0x01, 0x0a,
	0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2e, 0x0a, 0x2c, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2,
	0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xaa, 0x01,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2b, 0x12, 0x29, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x93, 0x01, 0x0a, 0x18, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xa4, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x12, 0x26, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x88, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x47, 0x0a, 0x0a, 0x64, 0x62, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x52,
	0x09, 0x64, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xa0, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62, 0x4e, 0x6f, 0x64,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x12, 0x24, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x62, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x80, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62,
	0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a,
	0x08, 0x64, 0x62, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x62, 0x4e, 0x6f, 0x64, 0x65, 0x52, 0x07, 0x64, 0x62, 0x4e, 0x6f, 0x64, 0x65, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa6, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73,
	0x74, 0x47, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x69, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x8c, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x69, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0b,
	0x67, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x67, 0x69,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xae, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62, 0x53, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x53, 0x68, 0x61, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x62, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x53, 0x68,
	0x61, 0x70, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a,
	0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x9d, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62, 0x53, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x53, 0x68, 0x61, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x57, 0x0a, 0x10, 0x64, 0x62, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x73, 0x68,
	0x61, 0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x62, 0x53, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x53, 0x68, 0x61, 0x70, 0x65, 0x52, 0x0e, 0x64, 0x62, 0x53, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x53, 0x68, 0x61, 0x70, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0x85, 0x03, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61,
	0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x65, 0x72,
	0x63, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x22, 0xf5, 0x01, 0x0a, 0x1e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xb0, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d,
	0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d,
	0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x6c, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e,
	0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xc4, 0x02, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74,
	0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75,
	0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x16, 0x61, 0x75, 0x74, 0x6f,
	0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x61,
	0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x49, 0x64, 0x12, 0x68, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75,
	0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x6e,
	0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x2a, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x9b, 0x01, 0x0a, 0x1f, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x32, 0x0a, 0x30, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xb4, 0x01, 0x0a, 0x20, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x32, 0x0a, 0x30, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x85,
	0x02, 0x0a, 0x27, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6e,
	0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x57, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32,
	0x0a, 0x30, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x24, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x69, 0x73, 0x52, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x61,
	0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x58, 0x0a, 0x28, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x22, 0xba, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d,
	0x6f, 0x75, 0x73, 0x44, 0x62, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x33, 0x12, 0x31, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f,
	0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x62, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb5, 0x01,
	0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73,
	0x44, 0x62, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x69, 0x0a, 0x16, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73,
	0x5f, 0x64, 0x62, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x62,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d,
	0x6f, 0x75, 0x73, 0x44, 0x62, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xed, 0x01, 0x0a, 0x2a, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75,
	0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x5c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x44, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3e, 0x12, 0x3c, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f,
	0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x68,
	0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xe3, 0x01, 0x0a, 0x2b, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75,
	0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x8b, 0x01, 0x0a, 0x22, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x68,
	0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53,
	0x65, 0x74, 0x52, 0x1f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53,
	0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xe1, 0x01, 0x0a, 0x24,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x3e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x38, 0x12, 0x36, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f,
	0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0xc9, 0x01, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f,
	0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x78, 0x0a, 0x1b, 0x61, 0x75, 0x74,
	0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x19, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0x8c, 0x2b, 0x0a, 0x0e,
	0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x84,
	0x02, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72,
	0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x50, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x45,
	0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0xf1, 0x01, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x22, 0x4e, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xea, 0x02, 0x0a, 0x20, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x47,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xdd, 0x01, 0xca, 0x41, 0x2f, 0x0a, 0x1a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x43, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x65, 0x78, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x65, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5f, 0x3a, 0x1c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x65,
	0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x87, 0x02, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66,
	0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49,
	0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x7b, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x2a,
	0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x45, 0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e,
	0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xd4, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56,
	0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x44, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0xc1, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x42, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d,
	0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x96, 0x02, 0x0a, 0x14,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xa1, 0x01, 0xca, 0x41, 0x23, 0x0a, 0x0e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x2b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x76, 0x6d, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x76, 0x6d, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a, 0x10, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x76, 0x6d, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22,
	0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x12, 0xe3, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6f, 0xca, 0x41, 0x2a, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc8, 0x01, 0x0a, 0x10, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xda, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4d, 0x12, 0x4b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x45,
	0x78, 0x61, 0x64, 0x61, 0x74, 0x61, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x62, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x73, 0x12, 0xc6, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62, 0x4e, 0x6f, 0x64,
	0x65, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62, 0x4e, 0x6f,
	0x64, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0xda, 0x41, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x56, 0x6d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x62, 0x4e, 0x6f, 0x64, 0x65, 0x73, 0x12, 0xc0, 0x01, 0x0a, 0x0e,
	0x4c, 0x69, 0x73, 0x74, 0x47, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x47, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x69, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3f, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xd0,
	0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x53,
	0x68, 0x61, 0x70, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62, 0x53, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x53, 0x68, 0x61, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x62, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x53, 0x68,
	0x61, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x64, 0x62, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x53, 0x68, 0x61, 0x70, 0x65,
	0x73, 0x12, 0xe4, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x12, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x48,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12,
	0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x12, 0xd1, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74,
	0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x22, 0x46, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaf, 0x02, 0x0a,
	0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb2, 0x01, 0xca, 0x41, 0x27, 0x0a,
	0x12, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x31, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2c, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e,
	0x3a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e,
	0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x12, 0xef,
	0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d,
	0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c,
	0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0xca, 0x41, 0x2a,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x2a, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x87, 0x02, 0x0a, 0x19, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x75, 0x74, 0x6f,
	0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x88, 0x01, 0xca, 0x41, 0x27, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x11, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x6f,
	0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0xa9, 0x02, 0x0a, 0x20, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x12,
	0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d,
	0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x57, 0x61, 0x6c, 0x6c, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x72, 0xda, 0x41, 0x1e, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x74, 0x79, 0x70, 0x65,
	0x2c, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x2c, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x01, 0x2a, 0x22, 0x46,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x12, 0xe8, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x62, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d,
	0x6f, 0x75, 0x73, 0x44, 0x62, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x44, 0x62, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x49, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x75, 0x74,
	0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x62, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x94, 0x02, 0x0a, 0x23, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x72,
	0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x73, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e,
	0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61,
	0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x54, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d,
	0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61,
	0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x73, 0x12, 0xfc, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x12, 0x3d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x75,
	0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x1a, 0x51, 0xca, 0x41, 0x1d, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xb6, 0x02, 0xea, 0x41, 0x4e,
	0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x12, 0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x7d, 0x0a, 0x22,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x42, 0x0b, 0x56, 0x31, 0x6d, 0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70, 0x62, 0x3b, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x1e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02,
	0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4f, 0x72,
	0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescOnce sync.Once
	file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescData = file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDesc
)

func file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescGZIP() []byte {
	file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescOnce.Do(func() {
		file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescData)
	})
	return file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDescData
}

var file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes = make([]protoimpl.MessageInfo, 35)
var file_google_cloud_oracledatabase_v1_oracledatabase_proto_goTypes = []any{
	(*ListCloudExadataInfrastructuresRequest)(nil),      // 0: google.cloud.oracledatabase.v1.ListCloudExadataInfrastructuresRequest
	(*ListCloudExadataInfrastructuresResponse)(nil),     // 1: google.cloud.oracledatabase.v1.ListCloudExadataInfrastructuresResponse
	(*GetCloudExadataInfrastructureRequest)(nil),        // 2: google.cloud.oracledatabase.v1.GetCloudExadataInfrastructureRequest
	(*CreateCloudExadataInfrastructureRequest)(nil),     // 3: google.cloud.oracledatabase.v1.CreateCloudExadataInfrastructureRequest
	(*DeleteCloudExadataInfrastructureRequest)(nil),     // 4: google.cloud.oracledatabase.v1.DeleteCloudExadataInfrastructureRequest
	(*ListCloudVmClustersRequest)(nil),                  // 5: google.cloud.oracledatabase.v1.ListCloudVmClustersRequest
	(*ListCloudVmClustersResponse)(nil),                 // 6: google.cloud.oracledatabase.v1.ListCloudVmClustersResponse
	(*GetCloudVmClusterRequest)(nil),                    // 7: google.cloud.oracledatabase.v1.GetCloudVmClusterRequest
	(*CreateCloudVmClusterRequest)(nil),                 // 8: google.cloud.oracledatabase.v1.CreateCloudVmClusterRequest
	(*DeleteCloudVmClusterRequest)(nil),                 // 9: google.cloud.oracledatabase.v1.DeleteCloudVmClusterRequest
	(*ListEntitlementsRequest)(nil),                     // 10: google.cloud.oracledatabase.v1.ListEntitlementsRequest
	(*ListEntitlementsResponse)(nil),                    // 11: google.cloud.oracledatabase.v1.ListEntitlementsResponse
	(*ListDbServersRequest)(nil),                        // 12: google.cloud.oracledatabase.v1.ListDbServersRequest
	(*ListDbServersResponse)(nil),                       // 13: google.cloud.oracledatabase.v1.ListDbServersResponse
	(*ListDbNodesRequest)(nil),                          // 14: google.cloud.oracledatabase.v1.ListDbNodesRequest
	(*ListDbNodesResponse)(nil),                         // 15: google.cloud.oracledatabase.v1.ListDbNodesResponse
	(*ListGiVersionsRequest)(nil),                       // 16: google.cloud.oracledatabase.v1.ListGiVersionsRequest
	(*ListGiVersionsResponse)(nil),                      // 17: google.cloud.oracledatabase.v1.ListGiVersionsResponse
	(*ListDbSystemShapesRequest)(nil),                   // 18: google.cloud.oracledatabase.v1.ListDbSystemShapesRequest
	(*ListDbSystemShapesResponse)(nil),                  // 19: google.cloud.oracledatabase.v1.ListDbSystemShapesResponse
	(*OperationMetadata)(nil),                           // 20: google.cloud.oracledatabase.v1.OperationMetadata
	(*ListAutonomousDatabasesRequest)(nil),              // 21: google.cloud.oracledatabase.v1.ListAutonomousDatabasesRequest
	(*ListAutonomousDatabasesResponse)(nil),             // 22: google.cloud.oracledatabase.v1.ListAutonomousDatabasesResponse
	(*GetAutonomousDatabaseRequest)(nil),                // 23: google.cloud.oracledatabase.v1.GetAutonomousDatabaseRequest
	(*CreateAutonomousDatabaseRequest)(nil),             // 24: google.cloud.oracledatabase.v1.CreateAutonomousDatabaseRequest
	(*DeleteAutonomousDatabaseRequest)(nil),             // 25: google.cloud.oracledatabase.v1.DeleteAutonomousDatabaseRequest
	(*RestoreAutonomousDatabaseRequest)(nil),            // 26: google.cloud.oracledatabase.v1.RestoreAutonomousDatabaseRequest
	(*GenerateAutonomousDatabaseWalletRequest)(nil),     // 27: google.cloud.oracledatabase.v1.GenerateAutonomousDatabaseWalletRequest
	(*GenerateAutonomousDatabaseWalletResponse)(nil),    // 28: google.cloud.oracledatabase.v1.GenerateAutonomousDatabaseWalletResponse
	(*ListAutonomousDbVersionsRequest)(nil),             // 29: google.cloud.oracledatabase.v1.ListAutonomousDbVersionsRequest
	(*ListAutonomousDbVersionsResponse)(nil),            // 30: google.cloud.oracledatabase.v1.ListAutonomousDbVersionsResponse
	(*ListAutonomousDatabaseCharacterSetsRequest)(nil),  // 31: google.cloud.oracledatabase.v1.ListAutonomousDatabaseCharacterSetsRequest
	(*ListAutonomousDatabaseCharacterSetsResponse)(nil), // 32: google.cloud.oracledatabase.v1.ListAutonomousDatabaseCharacterSetsResponse
	(*ListAutonomousDatabaseBackupsRequest)(nil),        // 33: google.cloud.oracledatabase.v1.ListAutonomousDatabaseBackupsRequest
	(*ListAutonomousDatabaseBackupsResponse)(nil),       // 34: google.cloud.oracledatabase.v1.ListAutonomousDatabaseBackupsResponse
	(*CloudExadataInfrastructure)(nil),                  // 35: google.cloud.oracledatabase.v1.CloudExadataInfrastructure
	(*CloudVmCluster)(nil),                              // 36: google.cloud.oracledatabase.v1.CloudVmCluster
	(*Entitlement)(nil),                                 // 37: google.cloud.oracledatabase.v1.Entitlement
	(*DbServer)(nil),                                    // 38: google.cloud.oracledatabase.v1.DbServer
	(*DbNode)(nil),                                      // 39: google.cloud.oracledatabase.v1.DbNode
	(*GiVersion)(nil),                                   // 40: google.cloud.oracledatabase.v1.GiVersion
	(*DbSystemShape)(nil),                               // 41: google.cloud.oracledatabase.v1.DbSystemShape
	(*timestamppb.Timestamp)(nil),                       // 42: google.protobuf.Timestamp
	(*AutonomousDatabase)(nil),                          // 43: google.cloud.oracledatabase.v1.AutonomousDatabase
	(GenerateType)(0),                                   // 44: google.cloud.oracledatabase.v1.GenerateType
	(*AutonomousDbVersion)(nil),                         // 45: google.cloud.oracledatabase.v1.AutonomousDbVersion
	(*AutonomousDatabaseCharacterSet)(nil),              // 46: google.cloud.oracledatabase.v1.AutonomousDatabaseCharacterSet
	(*AutonomousDatabaseBackup)(nil),                    // 47: google.cloud.oracledatabase.v1.AutonomousDatabaseBackup
	(*longrunningpb.Operation)(nil),                     // 48: google.longrunning.Operation
}
var file_google_cloud_oracledatabase_v1_oracledatabase_proto_depIdxs = []int32{
	35, // 0: google.cloud.oracledatabase.v1.ListCloudExadataInfrastructuresResponse.cloud_exadata_infrastructures:type_name -> google.cloud.oracledatabase.v1.CloudExadataInfrastructure
	35, // 1: google.cloud.oracledatabase.v1.CreateCloudExadataInfrastructureRequest.cloud_exadata_infrastructure:type_name -> google.cloud.oracledatabase.v1.CloudExadataInfrastructure
	36, // 2: google.cloud.oracledatabase.v1.ListCloudVmClustersResponse.cloud_vm_clusters:type_name -> google.cloud.oracledatabase.v1.CloudVmCluster
	36, // 3: google.cloud.oracledatabase.v1.CreateCloudVmClusterRequest.cloud_vm_cluster:type_name -> google.cloud.oracledatabase.v1.CloudVmCluster
	37, // 4: google.cloud.oracledatabase.v1.ListEntitlementsResponse.entitlements:type_name -> google.cloud.oracledatabase.v1.Entitlement
	38, // 5: google.cloud.oracledatabase.v1.ListDbServersResponse.db_servers:type_name -> google.cloud.oracledatabase.v1.DbServer
	39, // 6: google.cloud.oracledatabase.v1.ListDbNodesResponse.db_nodes:type_name -> google.cloud.oracledatabase.v1.DbNode
	40, // 7: google.cloud.oracledatabase.v1.ListGiVersionsResponse.gi_versions:type_name -> google.cloud.oracledatabase.v1.GiVersion
	41, // 8: google.cloud.oracledatabase.v1.ListDbSystemShapesResponse.db_system_shapes:type_name -> google.cloud.oracledatabase.v1.DbSystemShape
	42, // 9: google.cloud.oracledatabase.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	42, // 10: google.cloud.oracledatabase.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	43, // 11: google.cloud.oracledatabase.v1.ListAutonomousDatabasesResponse.autonomous_databases:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabase
	43, // 12: google.cloud.oracledatabase.v1.CreateAutonomousDatabaseRequest.autonomous_database:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabase
	42, // 13: google.cloud.oracledatabase.v1.RestoreAutonomousDatabaseRequest.restore_time:type_name -> google.protobuf.Timestamp
	44, // 14: google.cloud.oracledatabase.v1.GenerateAutonomousDatabaseWalletRequest.type:type_name -> google.cloud.oracledatabase.v1.GenerateType
	45, // 15: google.cloud.oracledatabase.v1.ListAutonomousDbVersionsResponse.autonomous_db_versions:type_name -> google.cloud.oracledatabase.v1.AutonomousDbVersion
	46, // 16: google.cloud.oracledatabase.v1.ListAutonomousDatabaseCharacterSetsResponse.autonomous_database_character_sets:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseCharacterSet
	47, // 17: google.cloud.oracledatabase.v1.ListAutonomousDatabaseBackupsResponse.autonomous_database_backups:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseBackup
	0,  // 18: google.cloud.oracledatabase.v1.OracleDatabase.ListCloudExadataInfrastructures:input_type -> google.cloud.oracledatabase.v1.ListCloudExadataInfrastructuresRequest
	2,  // 19: google.cloud.oracledatabase.v1.OracleDatabase.GetCloudExadataInfrastructure:input_type -> google.cloud.oracledatabase.v1.GetCloudExadataInfrastructureRequest
	3,  // 20: google.cloud.oracledatabase.v1.OracleDatabase.CreateCloudExadataInfrastructure:input_type -> google.cloud.oracledatabase.v1.CreateCloudExadataInfrastructureRequest
	4,  // 21: google.cloud.oracledatabase.v1.OracleDatabase.DeleteCloudExadataInfrastructure:input_type -> google.cloud.oracledatabase.v1.DeleteCloudExadataInfrastructureRequest
	5,  // 22: google.cloud.oracledatabase.v1.OracleDatabase.ListCloudVmClusters:input_type -> google.cloud.oracledatabase.v1.ListCloudVmClustersRequest
	7,  // 23: google.cloud.oracledatabase.v1.OracleDatabase.GetCloudVmCluster:input_type -> google.cloud.oracledatabase.v1.GetCloudVmClusterRequest
	8,  // 24: google.cloud.oracledatabase.v1.OracleDatabase.CreateCloudVmCluster:input_type -> google.cloud.oracledatabase.v1.CreateCloudVmClusterRequest
	9,  // 25: google.cloud.oracledatabase.v1.OracleDatabase.DeleteCloudVmCluster:input_type -> google.cloud.oracledatabase.v1.DeleteCloudVmClusterRequest
	10, // 26: google.cloud.oracledatabase.v1.OracleDatabase.ListEntitlements:input_type -> google.cloud.oracledatabase.v1.ListEntitlementsRequest
	12, // 27: google.cloud.oracledatabase.v1.OracleDatabase.ListDbServers:input_type -> google.cloud.oracledatabase.v1.ListDbServersRequest
	14, // 28: google.cloud.oracledatabase.v1.OracleDatabase.ListDbNodes:input_type -> google.cloud.oracledatabase.v1.ListDbNodesRequest
	16, // 29: google.cloud.oracledatabase.v1.OracleDatabase.ListGiVersions:input_type -> google.cloud.oracledatabase.v1.ListGiVersionsRequest
	18, // 30: google.cloud.oracledatabase.v1.OracleDatabase.ListDbSystemShapes:input_type -> google.cloud.oracledatabase.v1.ListDbSystemShapesRequest
	21, // 31: google.cloud.oracledatabase.v1.OracleDatabase.ListAutonomousDatabases:input_type -> google.cloud.oracledatabase.v1.ListAutonomousDatabasesRequest
	23, // 32: google.cloud.oracledatabase.v1.OracleDatabase.GetAutonomousDatabase:input_type -> google.cloud.oracledatabase.v1.GetAutonomousDatabaseRequest
	24, // 33: google.cloud.oracledatabase.v1.OracleDatabase.CreateAutonomousDatabase:input_type -> google.cloud.oracledatabase.v1.CreateAutonomousDatabaseRequest
	25, // 34: google.cloud.oracledatabase.v1.OracleDatabase.DeleteAutonomousDatabase:input_type -> google.cloud.oracledatabase.v1.DeleteAutonomousDatabaseRequest
	26, // 35: google.cloud.oracledatabase.v1.OracleDatabase.RestoreAutonomousDatabase:input_type -> google.cloud.oracledatabase.v1.RestoreAutonomousDatabaseRequest
	27, // 36: google.cloud.oracledatabase.v1.OracleDatabase.GenerateAutonomousDatabaseWallet:input_type -> google.cloud.oracledatabase.v1.GenerateAutonomousDatabaseWalletRequest
	29, // 37: google.cloud.oracledatabase.v1.OracleDatabase.ListAutonomousDbVersions:input_type -> google.cloud.oracledatabase.v1.ListAutonomousDbVersionsRequest
	31, // 38: google.cloud.oracledatabase.v1.OracleDatabase.ListAutonomousDatabaseCharacterSets:input_type -> google.cloud.oracledatabase.v1.ListAutonomousDatabaseCharacterSetsRequest
	33, // 39: google.cloud.oracledatabase.v1.OracleDatabase.ListAutonomousDatabaseBackups:input_type -> google.cloud.oracledatabase.v1.ListAutonomousDatabaseBackupsRequest
	1,  // 40: google.cloud.oracledatabase.v1.OracleDatabase.ListCloudExadataInfrastructures:output_type -> google.cloud.oracledatabase.v1.ListCloudExadataInfrastructuresResponse
	35, // 41: google.cloud.oracledatabase.v1.OracleDatabase.GetCloudExadataInfrastructure:output_type -> google.cloud.oracledatabase.v1.CloudExadataInfrastructure
	48, // 42: google.cloud.oracledatabase.v1.OracleDatabase.CreateCloudExadataInfrastructure:output_type -> google.longrunning.Operation
	48, // 43: google.cloud.oracledatabase.v1.OracleDatabase.DeleteCloudExadataInfrastructure:output_type -> google.longrunning.Operation
	6,  // 44: google.cloud.oracledatabase.v1.OracleDatabase.ListCloudVmClusters:output_type -> google.cloud.oracledatabase.v1.ListCloudVmClustersResponse
	36, // 45: google.cloud.oracledatabase.v1.OracleDatabase.GetCloudVmCluster:output_type -> google.cloud.oracledatabase.v1.CloudVmCluster
	48, // 46: google.cloud.oracledatabase.v1.OracleDatabase.CreateCloudVmCluster:output_type -> google.longrunning.Operation
	48, // 47: google.cloud.oracledatabase.v1.OracleDatabase.DeleteCloudVmCluster:output_type -> google.longrunning.Operation
	11, // 48: google.cloud.oracledatabase.v1.OracleDatabase.ListEntitlements:output_type -> google.cloud.oracledatabase.v1.ListEntitlementsResponse
	13, // 49: google.cloud.oracledatabase.v1.OracleDatabase.ListDbServers:output_type -> google.cloud.oracledatabase.v1.ListDbServersResponse
	15, // 50: google.cloud.oracledatabase.v1.OracleDatabase.ListDbNodes:output_type -> google.cloud.oracledatabase.v1.ListDbNodesResponse
	17, // 51: google.cloud.oracledatabase.v1.OracleDatabase.ListGiVersions:output_type -> google.cloud.oracledatabase.v1.ListGiVersionsResponse
	19, // 52: google.cloud.oracledatabase.v1.OracleDatabase.ListDbSystemShapes:output_type -> google.cloud.oracledatabase.v1.ListDbSystemShapesResponse
	22, // 53: google.cloud.oracledatabase.v1.OracleDatabase.ListAutonomousDatabases:output_type -> google.cloud.oracledatabase.v1.ListAutonomousDatabasesResponse
	43, // 54: google.cloud.oracledatabase.v1.OracleDatabase.GetAutonomousDatabase:output_type -> google.cloud.oracledatabase.v1.AutonomousDatabase
	48, // 55: google.cloud.oracledatabase.v1.OracleDatabase.CreateAutonomousDatabase:output_type -> google.longrunning.Operation
	48, // 56: google.cloud.oracledatabase.v1.OracleDatabase.DeleteAutonomousDatabase:output_type -> google.longrunning.Operation
	48, // 57: google.cloud.oracledatabase.v1.OracleDatabase.RestoreAutonomousDatabase:output_type -> google.longrunning.Operation
	28, // 58: google.cloud.oracledatabase.v1.OracleDatabase.GenerateAutonomousDatabaseWallet:output_type -> google.cloud.oracledatabase.v1.GenerateAutonomousDatabaseWalletResponse
	30, // 59: google.cloud.oracledatabase.v1.OracleDatabase.ListAutonomousDbVersions:output_type -> google.cloud.oracledatabase.v1.ListAutonomousDbVersionsResponse
	32, // 60: google.cloud.oracledatabase.v1.OracleDatabase.ListAutonomousDatabaseCharacterSets:output_type -> google.cloud.oracledatabase.v1.ListAutonomousDatabaseCharacterSetsResponse
	34, // 61: google.cloud.oracledatabase.v1.OracleDatabase.ListAutonomousDatabaseBackups:output_type -> google.cloud.oracledatabase.v1.ListAutonomousDatabaseBackupsResponse
	40, // [40:62] is the sub-list for method output_type
	18, // [18:40] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_google_cloud_oracledatabase_v1_oracledatabase_proto_init() }
func file_google_cloud_oracledatabase_v1_oracledatabase_proto_init() {
	if File_google_cloud_oracledatabase_v1_oracledatabase_proto != nil {
		return
	}
	file_google_cloud_oracledatabase_v1_autonomous_database_proto_init()
	file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_init()
	file_google_cloud_oracledatabase_v1_autonomous_db_backup_proto_init()
	file_google_cloud_oracledatabase_v1_autonomous_db_version_proto_init()
	file_google_cloud_oracledatabase_v1_db_node_proto_init()
	file_google_cloud_oracledatabase_v1_db_server_proto_init()
	file_google_cloud_oracledatabase_v1_db_system_shape_proto_init()
	file_google_cloud_oracledatabase_v1_entitlement_proto_init()
	file_google_cloud_oracledatabase_v1_exadata_infra_proto_init()
	file_google_cloud_oracledatabase_v1_gi_version_proto_init()
	file_google_cloud_oracledatabase_v1_vm_cluster_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   35,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_oracledatabase_v1_oracledatabase_proto_goTypes,
		DependencyIndexes: file_google_cloud_oracledatabase_v1_oracledatabase_proto_depIdxs,
		MessageInfos:      file_google_cloud_oracledatabase_v1_oracledatabase_proto_msgTypes,
	}.Build()
	File_google_cloud_oracledatabase_v1_oracledatabase_proto = out.File
	file_google_cloud_oracledatabase_v1_oracledatabase_proto_rawDesc = nil
	file_google_cloud_oracledatabase_v1_oracledatabase_proto_goTypes = nil
	file_google_cloud_oracledatabase_v1_oracledatabase_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// OracleDatabaseClient is the client API for OracleDatabase service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type OracleDatabaseClient interface {
	// Lists Exadata Infrastructures in a given project and location.
	ListCloudExadataInfrastructures(ctx context.Context, in *ListCloudExadataInfrastructuresRequest, opts ...grpc.CallOption) (*ListCloudExadataInfrastructuresResponse, error)
	// Gets details of a single Exadata Infrastructure.
	GetCloudExadataInfrastructure(ctx context.Context, in *GetCloudExadataInfrastructureRequest, opts ...grpc.CallOption) (*CloudExadataInfrastructure, error)
	// Creates a new Exadata Infrastructure in a given project and location.
	CreateCloudExadataInfrastructure(ctx context.Context, in *CreateCloudExadataInfrastructureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Exadata Infrastructure.
	DeleteCloudExadataInfrastructure(ctx context.Context, in *DeleteCloudExadataInfrastructureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the VM Clusters in a given project and location.
	ListCloudVmClusters(ctx context.Context, in *ListCloudVmClustersRequest, opts ...grpc.CallOption) (*ListCloudVmClustersResponse, error)
	// Gets details of a single VM Cluster.
	GetCloudVmCluster(ctx context.Context, in *GetCloudVmClusterRequest, opts ...grpc.CallOption) (*CloudVmCluster, error)
	// Creates a new VM Cluster in a given project and location.
	CreateCloudVmCluster(ctx context.Context, in *CreateCloudVmClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single VM Cluster.
	DeleteCloudVmCluster(ctx context.Context, in *DeleteCloudVmClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the entitlements in a given project.
	ListEntitlements(ctx context.Context, in *ListEntitlementsRequest, opts ...grpc.CallOption) (*ListEntitlementsResponse, error)
	// Lists the database servers of an Exadata Infrastructure instance.
	ListDbServers(ctx context.Context, in *ListDbServersRequest, opts ...grpc.CallOption) (*ListDbServersResponse, error)
	// Lists the database nodes of a VM Cluster.
	ListDbNodes(ctx context.Context, in *ListDbNodesRequest, opts ...grpc.CallOption) (*ListDbNodesResponse, error)
	// Lists all the valid Oracle Grid Infrastructure (GI) versions for the given
	// project and location.
	ListGiVersions(ctx context.Context, in *ListGiVersionsRequest, opts ...grpc.CallOption) (*ListGiVersionsResponse, error)
	// Lists the database system shapes available for the project and location.
	ListDbSystemShapes(ctx context.Context, in *ListDbSystemShapesRequest, opts ...grpc.CallOption) (*ListDbSystemShapesResponse, error)
	// Lists the Autonomous Databases in a given project and location.
	ListAutonomousDatabases(ctx context.Context, in *ListAutonomousDatabasesRequest, opts ...grpc.CallOption) (*ListAutonomousDatabasesResponse, error)
	// Gets the details of a single Autonomous Database.
	GetAutonomousDatabase(ctx context.Context, in *GetAutonomousDatabaseRequest, opts ...grpc.CallOption) (*AutonomousDatabase, error)
	// Creates a new Autonomous Database in a given project and location.
	CreateAutonomousDatabase(ctx context.Context, in *CreateAutonomousDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Autonomous Database.
	DeleteAutonomousDatabase(ctx context.Context, in *DeleteAutonomousDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Restores a single Autonomous Database.
	RestoreAutonomousDatabase(ctx context.Context, in *RestoreAutonomousDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Generates a wallet for an Autonomous Database.
	GenerateAutonomousDatabaseWallet(ctx context.Context, in *GenerateAutonomousDatabaseWalletRequest, opts ...grpc.CallOption) (*GenerateAutonomousDatabaseWalletResponse, error)
	// Lists all the available Autonomous Database versions for a project and
	// location.
	ListAutonomousDbVersions(ctx context.Context, in *ListAutonomousDbVersionsRequest, opts ...grpc.CallOption) (*ListAutonomousDbVersionsResponse, error)
	// Lists Autonomous Database Character Sets in a given project and location.
	ListAutonomousDatabaseCharacterSets(ctx context.Context, in *ListAutonomousDatabaseCharacterSetsRequest, opts ...grpc.CallOption) (*ListAutonomousDatabaseCharacterSetsResponse, error)
	// Lists the long-term and automatic backups of an Autonomous Database.
	ListAutonomousDatabaseBackups(ctx context.Context, in *ListAutonomousDatabaseBackupsRequest, opts ...grpc.CallOption) (*ListAutonomousDatabaseBackupsResponse, error)
}

type oracleDatabaseClient struct {
	cc grpc.ClientConnInterface
}

func NewOracleDatabaseClient(cc grpc.ClientConnInterface) OracleDatabaseClient {
	return &oracleDatabaseClient{cc}
}

func (c *oracleDatabaseClient) ListCloudExadataInfrastructures(ctx context.Context, in *ListCloudExadataInfrastructuresRequest, opts ...grpc.CallOption) (*ListCloudExadataInfrastructuresResponse, error) {
	out := new(ListCloudExadataInfrastructuresResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/ListCloudExadataInfrastructures", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) GetCloudExadataInfrastructure(ctx context.Context, in *GetCloudExadataInfrastructureRequest, opts ...grpc.CallOption) (*CloudExadataInfrastructure, error) {
	out := new(CloudExadataInfrastructure)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/GetCloudExadataInfrastructure", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) CreateCloudExadataInfrastructure(ctx context.Context, in *CreateCloudExadataInfrastructureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/CreateCloudExadataInfrastructure", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) DeleteCloudExadataInfrastructure(ctx context.Context, in *DeleteCloudExadataInfrastructureRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/DeleteCloudExadataInfrastructure", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) ListCloudVmClusters(ctx context.Context, in *ListCloudVmClustersRequest, opts ...grpc.CallOption) (*ListCloudVmClustersResponse, error) {
	out := new(ListCloudVmClustersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/ListCloudVmClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) GetCloudVmCluster(ctx context.Context, in *GetCloudVmClusterRequest, opts ...grpc.CallOption) (*CloudVmCluster, error) {
	out := new(CloudVmCluster)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/GetCloudVmCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) CreateCloudVmCluster(ctx context.Context, in *CreateCloudVmClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/CreateCloudVmCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) DeleteCloudVmCluster(ctx context.Context, in *DeleteCloudVmClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/DeleteCloudVmCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) ListEntitlements(ctx context.Context, in *ListEntitlementsRequest, opts ...grpc.CallOption) (*ListEntitlementsResponse, error) {
	out := new(ListEntitlementsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/ListEntitlements", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) ListDbServers(ctx context.Context, in *ListDbServersRequest, opts ...grpc.CallOption) (*ListDbServersResponse, error) {
	out := new(ListDbServersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/ListDbServers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) ListDbNodes(ctx context.Context, in *ListDbNodesRequest, opts ...grpc.CallOption) (*ListDbNodesResponse, error) {
	out := new(ListDbNodesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/ListDbNodes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) ListGiVersions(ctx context.Context, in *ListGiVersionsRequest, opts ...grpc.CallOption) (*ListGiVersionsResponse, error) {
	out := new(ListGiVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/ListGiVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) ListDbSystemShapes(ctx context.Context, in *ListDbSystemShapesRequest, opts ...grpc.CallOption) (*ListDbSystemShapesResponse, error) {
	out := new(ListDbSystemShapesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/ListDbSystemShapes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) ListAutonomousDatabases(ctx context.Context, in *ListAutonomousDatabasesRequest, opts ...grpc.CallOption) (*ListAutonomousDatabasesResponse, error) {
	out := new(ListAutonomousDatabasesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/ListAutonomousDatabases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) GetAutonomousDatabase(ctx context.Context, in *GetAutonomousDatabaseRequest, opts ...grpc.CallOption) (*AutonomousDatabase, error) {
	out := new(AutonomousDatabase)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/GetAutonomousDatabase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) CreateAutonomousDatabase(ctx context.Context, in *CreateAutonomousDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/CreateAutonomousDatabase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) DeleteAutonomousDatabase(ctx context.Context, in *DeleteAutonomousDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/DeleteAutonomousDatabase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) RestoreAutonomousDatabase(ctx context.Context, in *RestoreAutonomousDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/RestoreAutonomousDatabase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) GenerateAutonomousDatabaseWallet(ctx context.Context, in *GenerateAutonomousDatabaseWalletRequest, opts ...grpc.CallOption) (*GenerateAutonomousDatabaseWalletResponse, error) {
	out := new(GenerateAutonomousDatabaseWalletResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/GenerateAutonomousDatabaseWallet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) ListAutonomousDbVersions(ctx context.Context, in *ListAutonomousDbVersionsRequest, opts ...grpc.CallOption) (*ListAutonomousDbVersionsResponse, error) {
	out := new(ListAutonomousDbVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/ListAutonomousDbVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) ListAutonomousDatabaseCharacterSets(ctx context.Context, in *ListAutonomousDatabaseCharacterSetsRequest, opts ...grpc.CallOption) (*ListAutonomousDatabaseCharacterSetsResponse, error) {
	out := new(ListAutonomousDatabaseCharacterSetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/ListAutonomousDatabaseCharacterSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *oracleDatabaseClient) ListAutonomousDatabaseBackups(ctx context.Context, in *ListAutonomousDatabaseBackupsRequest, opts ...grpc.CallOption) (*ListAutonomousDatabaseBackupsResponse, error) {
	out := new(ListAutonomousDatabaseBackupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.oracledatabase.v1.OracleDatabase/ListAutonomousDatabaseBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OracleDatabaseServer is the server API for OracleDatabase service.
type OracleDatabaseServer interface {
	// Lists Exadata Infrastructures in a given project and location.
	ListCloudExadataInfrastructures(context.Context, *ListCloudExadataInfrastructuresRequest) (*ListCloudExadataInfrastructuresResponse, error)
	// Gets details of a single Exadata Infrastructure.
	GetCloudExadataInfrastructure(context.Context, *GetCloudExadataInfrastructureRequest) (*CloudExadataInfrastructure, error)
	// Creates a new Exadata Infrastructure in a given project and location.
	CreateCloudExadataInfrastructure(context.Context, *CreateCloudExadataInfrastructureRequest) (*longrunningpb.Operation, error)
	// Deletes a single Exadata Infrastructure.
	DeleteCloudExadataInfrastructure(context.Context, *DeleteCloudExadataInfrastructureRequest) (*longrunningpb.Operation, error)
	// Lists the VM Clusters in a given project and location.
	ListCloudVmClusters(context.Context, *ListCloudVmClustersRequest) (*ListCloudVmClustersResponse, error)
	// Gets details of a single VM Cluster.
	GetCloudVmCluster(context.Context, *GetCloudVmClusterRequest) (*CloudVmCluster, error)
	// Creates a new VM Cluster in a given project and location.
	CreateCloudVmCluster(context.Context, *CreateCloudVmClusterRequest) (*longrunningpb.Operation, error)
	// Deletes a single VM Cluster.
	DeleteCloudVmCluster(context.Context, *DeleteCloudVmClusterRequest) (*longrunningpb.Operation, error)
	// Lists the entitlements in a given project.
	ListEntitlements(context.Context, *ListEntitlementsRequest) (*ListEntitlementsResponse, error)
	// Lists the database servers of an Exadata Infrastructure instance.
	ListDbServers(context.Context, *ListDbServersRequest) (*ListDbServersResponse, error)
	// Lists the database nodes of a VM Cluster.
	ListDbNodes(context.Context, *ListDbNodesRequest) (*ListDbNodesResponse, error)
	// Lists all the valid Oracle Grid Infrastructure (GI) versions for the given
	// project and location.
	ListGiVersions(context.Context, *ListGiVersionsRequest) (*ListGiVersionsResponse, error)
	// Lists the database system shapes available for the project and location.
	ListDbSystemShapes(context.Context, *ListDbSystemShapesRequest) (*ListDbSystemShapesResponse, error)
	// Lists the Autonomous Databases in a given project and location.
	ListAutonomousDatabases(context.Context, *ListAutonomousDatabasesRequest) (*ListAutonomousDatabasesResponse, error)
	// Gets the details of a single Autonomous Database.
	GetAutonomousDatabase(context.Context, *GetAutonomousDatabaseRequest) (*AutonomousDatabase, error)
	// Creates a new Autonomous Database in a given project and location.
	CreateAutonomousDatabase(context.Context, *CreateAutonomousDatabaseRequest) (*longrunningpb.Operation, error)
	// Deletes a single Autonomous Database.
	DeleteAutonomousDatabase(context.Context, *DeleteAutonomousDatabaseRequest) (*longrunningpb.Operation, error)
	// Restores a single Autonomous Database.
	RestoreAutonomousDatabase(context.Context, *RestoreAutonomousDatabaseRequest) (*longrunningpb.Operation, error)
	// Generates a wallet for an Autonomous Database.
	GenerateAutonomousDatabaseWallet(context.Context, *GenerateAutonomousDatabaseWalletRequest) (*GenerateAutonomousDatabaseWalletResponse, error)
	// Lists all the available Autonomous Database versions for a project and
	// location.
	ListAutonomousDbVersions(context.Context, *ListAutonomousDbVersionsRequest) (*ListAutonomousDbVersionsResponse, error)
	// Lists Autonomous Database Character Sets in a given project and location.
	ListAutonomousDatabaseCharacterSets(context.Context, *ListAutonomousDatabaseCharacterSetsRequest) (*ListAutonomousDatabaseCharacterSetsResponse, error)
	// Lists the long-term and automatic backups of an Autonomous Database.
	ListAutonomousDatabaseBackups(context.Context, *ListAutonomousDatabaseBackupsRequest) (*ListAutonomousDatabaseBackupsResponse, error)
}

// UnimplementedOracleDatabaseServer can be embedded to have forward compatible implementations.
type UnimplementedOracleDatabaseServer struct {
}

func (*UnimplementedOracleDatabaseServer) ListCloudExadataInfrastructures(context.Context, *ListCloudExadataInfrastructuresRequest) (*ListCloudExadataInfrastructuresResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCloudExadataInfrastructures not implemented")
}
func (*UnimplementedOracleDatabaseServer) GetCloudExadataInfrastructure(context.Context, *GetCloudExadataInfrastructureRequest) (*CloudExadataInfrastructure, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCloudExadataInfrastructure not implemented")
}
func (*UnimplementedOracleDatabaseServer) CreateCloudExadataInfrastructure(context.Context, *CreateCloudExadataInfrastructureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCloudExadataInfrastructure not implemented")
}
func (*UnimplementedOracleDatabaseServer) DeleteCloudExadataInfrastructure(context.Context, *DeleteCloudExadataInfrastructureRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCloudExadataInfrastructure not implemented")
}
func (*UnimplementedOracleDatabaseServer) ListCloudVmClusters(context.Context, *ListCloudVmClustersRequest) (*ListCloudVmClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCloudVmClusters not implemented")
}
func (*UnimplementedOracleDatabaseServer) GetCloudVmCluster(context.Context, *GetCloudVmClusterRequest) (*CloudVmCluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCloudVmCluster not implemented")
}
func (*UnimplementedOracleDatabaseServer) CreateCloudVmCluster(context.Context, *CreateCloudVmClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCloudVmCluster not implemented")
}
func (*UnimplementedOracleDatabaseServer) DeleteCloudVmCluster(context.Context, *DeleteCloudVmClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCloudVmCluster not implemented")
}
func (*UnimplementedOracleDatabaseServer) ListEntitlements(context.Context, *ListEntitlementsRequest) (*ListEntitlementsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntitlements not implemented")
}
func (*UnimplementedOracleDatabaseServer) ListDbServers(context.Context, *ListDbServersRequest) (*ListDbServersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDbServers not implemented")
}
func (*UnimplementedOracleDatabaseServer) ListDbNodes(context.Context, *ListDbNodesRequest) (*ListDbNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDbNodes not implemented")
}
func (*UnimplementedOracleDatabaseServer) ListGiVersions(context.Context, *ListGiVersionsRequest) (*ListGiVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGiVersions not implemented")
}
func (*UnimplementedOracleDatabaseServer) ListDbSystemShapes(context.Context, *ListDbSystemShapesRequest) (*ListDbSystemShapesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDbSystemShapes not implemented")
}
func (*UnimplementedOracleDatabaseServer) ListAutonomousDatabases(context.Context, *ListAutonomousDatabasesRequest) (*ListAutonomousDatabasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAutonomousDatabases not implemented")
}
func (*UnimplementedOracleDatabaseServer) GetAutonomousDatabase(context.Context, *GetAutonomousDatabaseRequest) (*AutonomousDatabase, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAutonomousDatabase not implemented")
}
func (*UnimplementedOracleDatabaseServer) CreateAutonomousDatabase(context.Context, *CreateAutonomousDatabaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAutonomousDatabase not implemented")
}
func (*UnimplementedOracleDatabaseServer) DeleteAutonomousDatabase(context.Context, *DeleteAutonomousDatabaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAutonomousDatabase not implemented")
}
func (*UnimplementedOracleDatabaseServer) RestoreAutonomousDatabase(context.Context, *RestoreAutonomousDatabaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreAutonomousDatabase not implemented")
}
func (*UnimplementedOracleDatabaseServer) GenerateAutonomousDatabaseWallet(context.Context, *GenerateAutonomousDatabaseWalletRequest) (*GenerateAutonomousDatabaseWalletResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAutonomousDatabaseWallet not implemented")
}
func (*UnimplementedOracleDatabaseServer) ListAutonomousDbVersions(context.Context, *ListAutonomousDbVersionsRequest) (*ListAutonomousDbVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAutonomousDbVersions not implemented")
}
func (*UnimplementedOracleDatabaseServer) ListAutonomousDatabaseCharacterSets(context.Context, *ListAutonomousDatabaseCharacterSetsRequest) (*ListAutonomousDatabaseCharacterSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAutonomousDatabaseCharacterSets not implemented")
}
func (*UnimplementedOracleDatabaseServer) ListAutonomousDatabaseBackups(context.Context, *ListAutonomousDatabaseBackupsRequest) (*ListAutonomousDatabaseBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAutonomousDatabaseBackups not implemented")
}

func RegisterOracleDatabaseServer(s *grpc.Server, srv OracleDatabaseServer) {
	s.RegisterService(&_OracleDatabase_serviceDesc, srv)
}

func _OracleDatabase_ListCloudExadataInfrastructures_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCloudExadataInfrastructuresRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).ListCloudExadataInfrastructures(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/ListCloudExadataInfrastructures",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).ListCloudExadataInfrastructures(ctx, req.(*ListCloudExadataInfrastructuresRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_GetCloudExadataInfrastructure_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCloudExadataInfrastructureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).GetCloudExadataInfrastructure(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/GetCloudExadataInfrastructure",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).GetCloudExadataInfrastructure(ctx, req.(*GetCloudExadataInfrastructureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_CreateCloudExadataInfrastructure_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCloudExadataInfrastructureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).CreateCloudExadataInfrastructure(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/CreateCloudExadataInfrastructure",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).CreateCloudExadataInfrastructure(ctx, req.(*CreateCloudExadataInfrastructureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_DeleteCloudExadataInfrastructure_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCloudExadataInfrastructureRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).DeleteCloudExadataInfrastructure(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/DeleteCloudExadataInfrastructure",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).DeleteCloudExadataInfrastructure(ctx, req.(*DeleteCloudExadataInfrastructureRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_ListCloudVmClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCloudVmClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).ListCloudVmClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/ListCloudVmClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).ListCloudVmClusters(ctx, req.(*ListCloudVmClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_GetCloudVmCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCloudVmClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).GetCloudVmCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/GetCloudVmCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).GetCloudVmCluster(ctx, req.(*GetCloudVmClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_CreateCloudVmCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCloudVmClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).CreateCloudVmCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/CreateCloudVmCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).CreateCloudVmCluster(ctx, req.(*CreateCloudVmClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_DeleteCloudVmCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCloudVmClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).DeleteCloudVmCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/DeleteCloudVmCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).DeleteCloudVmCluster(ctx, req.(*DeleteCloudVmClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_ListEntitlements_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntitlementsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).ListEntitlements(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/ListEntitlements",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).ListEntitlements(ctx, req.(*ListEntitlementsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_ListDbServers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDbServersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).ListDbServers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/ListDbServers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).ListDbServers(ctx, req.(*ListDbServersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_ListDbNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDbNodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).ListDbNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/ListDbNodes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).ListDbNodes(ctx, req.(*ListDbNodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_ListGiVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGiVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).ListGiVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/ListGiVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).ListGiVersions(ctx, req.(*ListGiVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_ListDbSystemShapes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDbSystemShapesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).ListDbSystemShapes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/ListDbSystemShapes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).ListDbSystemShapes(ctx, req.(*ListDbSystemShapesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_ListAutonomousDatabases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutonomousDatabasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).ListAutonomousDatabases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/ListAutonomousDatabases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).ListAutonomousDatabases(ctx, req.(*ListAutonomousDatabasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_GetAutonomousDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutonomousDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).GetAutonomousDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/GetAutonomousDatabase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).GetAutonomousDatabase(ctx, req.(*GetAutonomousDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_CreateAutonomousDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAutonomousDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).CreateAutonomousDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/CreateAutonomousDatabase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).CreateAutonomousDatabase(ctx, req.(*CreateAutonomousDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_DeleteAutonomousDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAutonomousDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).DeleteAutonomousDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/DeleteAutonomousDatabase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).DeleteAutonomousDatabase(ctx, req.(*DeleteAutonomousDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_RestoreAutonomousDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreAutonomousDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).RestoreAutonomousDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/RestoreAutonomousDatabase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).RestoreAutonomousDatabase(ctx, req.(*RestoreAutonomousDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_GenerateAutonomousDatabaseWallet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAutonomousDatabaseWalletRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).GenerateAutonomousDatabaseWallet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/GenerateAutonomousDatabaseWallet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).GenerateAutonomousDatabaseWallet(ctx, req.(*GenerateAutonomousDatabaseWalletRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_ListAutonomousDbVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutonomousDbVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).ListAutonomousDbVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/ListAutonomousDbVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).ListAutonomousDbVersions(ctx, req.(*ListAutonomousDbVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_ListAutonomousDatabaseCharacterSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutonomousDatabaseCharacterSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).ListAutonomousDatabaseCharacterSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/ListAutonomousDatabaseCharacterSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).ListAutonomousDatabaseCharacterSets(ctx, req.(*ListAutonomousDatabaseCharacterSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OracleDatabase_ListAutonomousDatabaseBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutonomousDatabaseBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OracleDatabaseServer).ListAutonomousDatabaseBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.oracledatabase.v1.OracleDatabase/ListAutonomousDatabaseBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OracleDatabaseServer).ListAutonomousDatabaseBackups(ctx, req.(*ListAutonomousDatabaseBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OracleDatabase_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.oracledatabase.v1.OracleDatabase",
	HandlerType: (*OracleDatabaseServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListCloudExadataInfrastructures",
			Handler:    _OracleDatabase_ListCloudExadataInfrastructures_Handler,
		},
		{
			MethodName: "GetCloudExadataInfrastructure",
			Handler:    _OracleDatabase_GetCloudExadataInfrastructure_Handler,
		},
		{
			MethodName: "CreateCloudExadataInfrastructure",
			Handler:    _OracleDatabase_CreateCloudExadataInfrastructure_Handler,
		},
		{
			MethodName: "DeleteCloudExadataInfrastructure",
			Handler:    _OracleDatabase_DeleteCloudExadataInfrastructure_Handler,
		},
		{
			MethodName: "ListCloudVmClusters",
			Handler:    _OracleDatabase_ListCloudVmClusters_Handler,
		},
		{
			MethodName: "GetCloudVmCluster",
			Handler:    _OracleDatabase_GetCloudVmCluster_Handler,
		},
		{
			MethodName: "CreateCloudVmCluster",
			Handler:    _OracleDatabase_CreateCloudVmCluster_Handler,
		},
		{
			MethodName: "DeleteCloudVmCluster",
			Handler:    _OracleDatabase_DeleteCloudVmCluster_Handler,
		},
		{
			MethodName: "ListEntitlements",
			Handler:    _OracleDatabase_ListEntitlements_Handler,
		},
		{
			MethodName: "ListDbServers",
			Handler:    _OracleDatabase_ListDbServers_Handler,
		},
		{
			MethodName: "ListDbNodes",
			Handler:    _OracleDatabase_ListDbNodes_Handler,
		},
		{
			MethodName: "ListGiVersions",
			Handler:    _OracleDatabase_ListGiVersions_Handler,
		},
		{
			MethodName: "ListDbSystemShapes",
			Handler:    _OracleDatabase_ListDbSystemShapes_Handler,
		},
		{
			MethodName: "ListAutonomousDatabases",
			Handler:    _OracleDatabase_ListAutonomousDatabases_Handler,
		},
		{
			MethodName: "GetAutonomousDatabase",
			Handler:    _OracleDatabase_GetAutonomousDatabase_Handler,
		},
		{
			MethodName: "CreateAutonomousDatabase",
			Handler:    _OracleDatabase_CreateAutonomousDatabase_Handler,
		},
		{
			MethodName: "DeleteAutonomousDatabase",
			Handler:    _OracleDatabase_DeleteAutonomousDatabase_Handler,
		},
		{
			MethodName: "RestoreAutonomousDatabase",
			Handler:    _OracleDatabase_RestoreAutonomousDatabase_Handler,
		},
		{
			MethodName: "GenerateAutonomousDatabaseWallet",
			Handler:    _OracleDatabase_GenerateAutonomousDatabaseWallet_Handler,
		},
		{
			MethodName: "ListAutonomousDbVersions",
			Handler:    _OracleDatabase_ListAutonomousDbVersions_Handler,
		},
		{
			MethodName: "ListAutonomousDatabaseCharacterSets",
			Handler:    _OracleDatabase_ListAutonomousDatabaseCharacterSets_Handler,
		},
		{
			MethodName: "ListAutonomousDatabaseBackups",
			Handler:    _OracleDatabase_ListAutonomousDatabaseBackups_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/oracledatabase/v1/oracledatabase.proto",
}
