// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/networkservices/v1/http_route.proto

package networkservicespb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Supported HTTP response code.
type HttpRoute_Redirect_ResponseCode int32

const (
	// Default value
	HttpRoute_Redirect_RESPONSE_CODE_UNSPECIFIED HttpRoute_Redirect_ResponseCode = 0
	// Corresponds to 301.
	HttpRoute_Redirect_MOVED_PERMANENTLY_DEFAULT HttpRoute_Redirect_ResponseCode = 1
	// Corresponds to 302.
	HttpRoute_Redirect_FOUND HttpRoute_Redirect_ResponseCode = 2
	// Corresponds to 303.
	HttpRoute_Redirect_SEE_OTHER HttpRoute_Redirect_ResponseCode = 3
	// Corresponds to 307. In this case, the request method will be retained.
	HttpRoute_Redirect_TEMPORARY_REDIRECT HttpRoute_Redirect_ResponseCode = 4
	// Corresponds to 308. In this case, the request method will be retained.
	HttpRoute_Redirect_PERMANENT_REDIRECT HttpRoute_Redirect_ResponseCode = 5
)

// Enum value maps for HttpRoute_Redirect_ResponseCode.
var (
	HttpRoute_Redirect_ResponseCode_name = map[int32]string{
		0: "RESPONSE_CODE_UNSPECIFIED",
		1: "MOVED_PERMANENTLY_DEFAULT",
		2: "FOUND",
		3: "SEE_OTHER",
		4: "TEMPORARY_REDIRECT",
		5: "PERMANENT_REDIRECT",
	}
	HttpRoute_Redirect_ResponseCode_value = map[string]int32{
		"RESPONSE_CODE_UNSPECIFIED": 0,
		"MOVED_PERMANENTLY_DEFAULT": 1,
		"FOUND":                     2,
		"SEE_OTHER":                 3,
		"TEMPORARY_REDIRECT":        4,
		"PERMANENT_REDIRECT":        5,
	}
)

func (x HttpRoute_Redirect_ResponseCode) Enum() *HttpRoute_Redirect_ResponseCode {
	p := new(HttpRoute_Redirect_ResponseCode)
	*p = x
	return p
}

func (x HttpRoute_Redirect_ResponseCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HttpRoute_Redirect_ResponseCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_networkservices_v1_http_route_proto_enumTypes[0].Descriptor()
}

func (HttpRoute_Redirect_ResponseCode) Type() protoreflect.EnumType {
	return &file_google_cloud_networkservices_v1_http_route_proto_enumTypes[0]
}

func (x HttpRoute_Redirect_ResponseCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HttpRoute_Redirect_ResponseCode.Descriptor instead.
func (HttpRoute_Redirect_ResponseCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 4, 0}
}

// HttpRoute is the resource defining how HTTP traffic should be routed by a
// Mesh or Gateway resource.
type HttpRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the HttpRoute resource. It matches pattern
	// `projects/*/locations/global/httpRoutes/http_route_name>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server-defined URL of this resource
	SelfLink string `protobuf:"bytes,11,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// Optional. A free-text description of the resource. Max length 1024
	// characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The timestamp when the resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Hostnames define a set of hosts that should match against the
	// HTTP host header to select a HttpRoute to process the request. Hostname is
	// the fully qualified domain name of a network host, as defined by RFC 1123
	// with the exception that:
	//   - IPs are not allowed.
	//   - A hostname may be prefixed with a wildcard label (`*.`). The wildcard
	//     label must appear by itself as the first label.
	//
	// Hostname can be "precise" which is a domain name without the terminating
	// dot of a network host (e.g. `foo.example.com`) or "wildcard", which is a
	// domain name prefixed with a single wildcard label (e.g. `*.example.com`).
	//
	// Note that as per RFC1035 and RFC1123, a label must consist of lower case
	// alphanumeric characters or '-', and must start and end with an alphanumeric
	// character. No other punctuation is allowed.
	//
	// The routes associated with a Mesh or Gateways  must have unique hostnames.
	// If you attempt to attach multiple routes with conflicting hostnames,
	// the configuration will be rejected.
	//
	// For example, while it is acceptable for routes for the hostnames
	// `*.foo.bar.com` and `*.bar.com` to be associated with the same Mesh (or
	// Gateways under the same scope), it is not possible to associate two routes
	// both with `*.bar.com` or both with `bar.com`.
	Hostnames []string `protobuf:"bytes,5,rep,name=hostnames,proto3" json:"hostnames,omitempty"`
	// Optional. Meshes defines a list of meshes this HttpRoute is attached to, as
	// one of the routing rules to route the requests served by the mesh.
	//
	// Each mesh reference should match the pattern:
	// `projects/*/locations/global/meshes/<mesh_name>`
	//
	// The attached Mesh should be of a type SIDECAR
	Meshes []string `protobuf:"bytes,8,rep,name=meshes,proto3" json:"meshes,omitempty"`
	// Optional. Gateways defines a list of gateways this HttpRoute is attached
	// to, as one of the routing rules to route the requests served by the
	// gateway.
	//
	// Each gateway reference should match the pattern:
	// `projects/*/locations/global/gateways/<gateway_name>`
	Gateways []string `protobuf:"bytes,9,rep,name=gateways,proto3" json:"gateways,omitempty"`
	// Optional. Set of label tags associated with the HttpRoute resource.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Rules that define how traffic is routed and handled.
	// Rules will be matched sequentially based on the RouteMatch specified for
	// the rule.
	Rules []*HttpRoute_RouteRule `protobuf:"bytes,6,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *HttpRoute) Reset() {
	*x = HttpRoute{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute) ProtoMessage() {}

func (x *HttpRoute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute.ProtoReflect.Descriptor instead.
func (*HttpRoute) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0}
}

func (x *HttpRoute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HttpRoute) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *HttpRoute) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *HttpRoute) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *HttpRoute) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *HttpRoute) GetHostnames() []string {
	if x != nil {
		return x.Hostnames
	}
	return nil
}

func (x *HttpRoute) GetMeshes() []string {
	if x != nil {
		return x.Meshes
	}
	return nil
}

func (x *HttpRoute) GetGateways() []string {
	if x != nil {
		return x.Gateways
	}
	return nil
}

func (x *HttpRoute) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *HttpRoute) GetRules() []*HttpRoute_RouteRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// Request used with the ListHttpRoutes method.
type ListHttpRoutesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the HttpRoutes should be
	// listed, specified in the format `projects/*/locations/global`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of HttpRoutes to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListHttpRoutesResponse`
	// Indicates that this is a continuation of a prior `ListHttpRoutes` call,
	// and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListHttpRoutesRequest) Reset() {
	*x = ListHttpRoutesRequest{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListHttpRoutesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHttpRoutesRequest) ProtoMessage() {}

func (x *ListHttpRoutesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHttpRoutesRequest.ProtoReflect.Descriptor instead.
func (*ListHttpRoutesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{1}
}

func (x *ListHttpRoutesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListHttpRoutesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListHttpRoutesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response returned by the ListHttpRoutes method.
type ListHttpRoutesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of HttpRoute resources.
	HttpRoutes []*HttpRoute `protobuf:"bytes,1,rep,name=http_routes,json=httpRoutes,proto3" json:"http_routes,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListHttpRoutesResponse) Reset() {
	*x = ListHttpRoutesResponse{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListHttpRoutesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListHttpRoutesResponse) ProtoMessage() {}

func (x *ListHttpRoutesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListHttpRoutesResponse.ProtoReflect.Descriptor instead.
func (*ListHttpRoutesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{2}
}

func (x *ListHttpRoutesResponse) GetHttpRoutes() []*HttpRoute {
	if x != nil {
		return x.HttpRoutes
	}
	return nil
}

func (x *ListHttpRoutesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request used by the GetHttpRoute method.
type GetHttpRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the HttpRoute to get. Must be in the format
	// `projects/*/locations/global/httpRoutes/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetHttpRouteRequest) Reset() {
	*x = GetHttpRouteRequest{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetHttpRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetHttpRouteRequest) ProtoMessage() {}

func (x *GetHttpRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetHttpRouteRequest.ProtoReflect.Descriptor instead.
func (*GetHttpRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{3}
}

func (x *GetHttpRouteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request used by the HttpRoute method.
type CreateHttpRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the HttpRoute. Must be in the
	// format `projects/*/locations/global`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Short name of the HttpRoute resource to be created.
	HttpRouteId string `protobuf:"bytes,2,opt,name=http_route_id,json=httpRouteId,proto3" json:"http_route_id,omitempty"`
	// Required. HttpRoute resource to be created.
	HttpRoute *HttpRoute `protobuf:"bytes,3,opt,name=http_route,json=httpRoute,proto3" json:"http_route,omitempty"`
}

func (x *CreateHttpRouteRequest) Reset() {
	*x = CreateHttpRouteRequest{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateHttpRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateHttpRouteRequest) ProtoMessage() {}

func (x *CreateHttpRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateHttpRouteRequest.ProtoReflect.Descriptor instead.
func (*CreateHttpRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{4}
}

func (x *CreateHttpRouteRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateHttpRouteRequest) GetHttpRouteId() string {
	if x != nil {
		return x.HttpRouteId
	}
	return ""
}

func (x *CreateHttpRouteRequest) GetHttpRoute() *HttpRoute {
	if x != nil {
		return x.HttpRoute
	}
	return nil
}

// Request used by the UpdateHttpRoute method.
type UpdateHttpRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// HttpRoute resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Updated HttpRoute resource.
	HttpRoute *HttpRoute `protobuf:"bytes,2,opt,name=http_route,json=httpRoute,proto3" json:"http_route,omitempty"`
}

func (x *UpdateHttpRouteRequest) Reset() {
	*x = UpdateHttpRouteRequest{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateHttpRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateHttpRouteRequest) ProtoMessage() {}

func (x *UpdateHttpRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateHttpRouteRequest.ProtoReflect.Descriptor instead.
func (*UpdateHttpRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateHttpRouteRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateHttpRouteRequest) GetHttpRoute() *HttpRoute {
	if x != nil {
		return x.HttpRoute
	}
	return nil
}

// Request used by the DeleteHttpRoute method.
type DeleteHttpRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the HttpRoute to delete. Must be in the format
	// `projects/*/locations/global/httpRoutes/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteHttpRouteRequest) Reset() {
	*x = DeleteHttpRouteRequest{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteHttpRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteHttpRouteRequest) ProtoMessage() {}

func (x *DeleteHttpRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteHttpRouteRequest.ProtoReflect.Descriptor instead.
func (*DeleteHttpRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteHttpRouteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Specifies how to select a route rule based on HTTP request headers.
type HttpRoute_HeaderMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to MatchType:
	//
	//	*HttpRoute_HeaderMatch_ExactMatch
	//	*HttpRoute_HeaderMatch_RegexMatch
	//	*HttpRoute_HeaderMatch_PrefixMatch
	//	*HttpRoute_HeaderMatch_PresentMatch
	//	*HttpRoute_HeaderMatch_SuffixMatch
	//	*HttpRoute_HeaderMatch_RangeMatch
	MatchType isHttpRoute_HeaderMatch_MatchType `protobuf_oneof:"MatchType"`
	// The name of the HTTP header to match against.
	Header string `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// If specified, the match result will be inverted before checking. Default
	// value is set to false.
	InvertMatch bool `protobuf:"varint,8,opt,name=invert_match,json=invertMatch,proto3" json:"invert_match,omitempty"`
}

func (x *HttpRoute_HeaderMatch) Reset() {
	*x = HttpRoute_HeaderMatch{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_HeaderMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_HeaderMatch) ProtoMessage() {}

func (x *HttpRoute_HeaderMatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_HeaderMatch.ProtoReflect.Descriptor instead.
func (*HttpRoute_HeaderMatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 0}
}

func (m *HttpRoute_HeaderMatch) GetMatchType() isHttpRoute_HeaderMatch_MatchType {
	if m != nil {
		return m.MatchType
	}
	return nil
}

func (x *HttpRoute_HeaderMatch) GetExactMatch() string {
	if x, ok := x.GetMatchType().(*HttpRoute_HeaderMatch_ExactMatch); ok {
		return x.ExactMatch
	}
	return ""
}

func (x *HttpRoute_HeaderMatch) GetRegexMatch() string {
	if x, ok := x.GetMatchType().(*HttpRoute_HeaderMatch_RegexMatch); ok {
		return x.RegexMatch
	}
	return ""
}

func (x *HttpRoute_HeaderMatch) GetPrefixMatch() string {
	if x, ok := x.GetMatchType().(*HttpRoute_HeaderMatch_PrefixMatch); ok {
		return x.PrefixMatch
	}
	return ""
}

func (x *HttpRoute_HeaderMatch) GetPresentMatch() bool {
	if x, ok := x.GetMatchType().(*HttpRoute_HeaderMatch_PresentMatch); ok {
		return x.PresentMatch
	}
	return false
}

func (x *HttpRoute_HeaderMatch) GetSuffixMatch() string {
	if x, ok := x.GetMatchType().(*HttpRoute_HeaderMatch_SuffixMatch); ok {
		return x.SuffixMatch
	}
	return ""
}

func (x *HttpRoute_HeaderMatch) GetRangeMatch() *HttpRoute_HeaderMatch_IntegerRange {
	if x, ok := x.GetMatchType().(*HttpRoute_HeaderMatch_RangeMatch); ok {
		return x.RangeMatch
	}
	return nil
}

func (x *HttpRoute_HeaderMatch) GetHeader() string {
	if x != nil {
		return x.Header
	}
	return ""
}

func (x *HttpRoute_HeaderMatch) GetInvertMatch() bool {
	if x != nil {
		return x.InvertMatch
	}
	return false
}

type isHttpRoute_HeaderMatch_MatchType interface {
	isHttpRoute_HeaderMatch_MatchType()
}

type HttpRoute_HeaderMatch_ExactMatch struct {
	// The value of the header should match exactly the content of
	// exact_match.
	ExactMatch string `protobuf:"bytes,2,opt,name=exact_match,json=exactMatch,proto3,oneof"`
}

type HttpRoute_HeaderMatch_RegexMatch struct {
	// The value of the header must match the regular expression specified in
	// regex_match. For regular expression grammar, please see:
	// https://github.com/google/re2/wiki/Syntax
	RegexMatch string `protobuf:"bytes,3,opt,name=regex_match,json=regexMatch,proto3,oneof"`
}

type HttpRoute_HeaderMatch_PrefixMatch struct {
	// The value of the header must start with the contents of prefix_match.
	PrefixMatch string `protobuf:"bytes,4,opt,name=prefix_match,json=prefixMatch,proto3,oneof"`
}

type HttpRoute_HeaderMatch_PresentMatch struct {
	// A header with header_name must exist. The match takes place whether or
	// not the header has a value.
	PresentMatch bool `protobuf:"varint,5,opt,name=present_match,json=presentMatch,proto3,oneof"`
}

type HttpRoute_HeaderMatch_SuffixMatch struct {
	// The value of the header must end with the contents of suffix_match.
	SuffixMatch string `protobuf:"bytes,6,opt,name=suffix_match,json=suffixMatch,proto3,oneof"`
}

type HttpRoute_HeaderMatch_RangeMatch struct {
	// If specified, the rule will match if the request header value is within
	// the range.
	RangeMatch *HttpRoute_HeaderMatch_IntegerRange `protobuf:"bytes,7,opt,name=range_match,json=rangeMatch,proto3,oneof"`
}

func (*HttpRoute_HeaderMatch_ExactMatch) isHttpRoute_HeaderMatch_MatchType() {}

func (*HttpRoute_HeaderMatch_RegexMatch) isHttpRoute_HeaderMatch_MatchType() {}

func (*HttpRoute_HeaderMatch_PrefixMatch) isHttpRoute_HeaderMatch_MatchType() {}

func (*HttpRoute_HeaderMatch_PresentMatch) isHttpRoute_HeaderMatch_MatchType() {}

func (*HttpRoute_HeaderMatch_SuffixMatch) isHttpRoute_HeaderMatch_MatchType() {}

func (*HttpRoute_HeaderMatch_RangeMatch) isHttpRoute_HeaderMatch_MatchType() {}

// Specifications to match a query parameter in the request.
type HttpRoute_QueryParameterMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to MatchType:
	//
	//	*HttpRoute_QueryParameterMatch_ExactMatch
	//	*HttpRoute_QueryParameterMatch_RegexMatch
	//	*HttpRoute_QueryParameterMatch_PresentMatch
	MatchType isHttpRoute_QueryParameterMatch_MatchType `protobuf_oneof:"MatchType"`
	// The name of the query parameter to match.
	QueryParameter string `protobuf:"bytes,1,opt,name=query_parameter,json=queryParameter,proto3" json:"query_parameter,omitempty"`
}

func (x *HttpRoute_QueryParameterMatch) Reset() {
	*x = HttpRoute_QueryParameterMatch{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_QueryParameterMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_QueryParameterMatch) ProtoMessage() {}

func (x *HttpRoute_QueryParameterMatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_QueryParameterMatch.ProtoReflect.Descriptor instead.
func (*HttpRoute_QueryParameterMatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 1}
}

func (m *HttpRoute_QueryParameterMatch) GetMatchType() isHttpRoute_QueryParameterMatch_MatchType {
	if m != nil {
		return m.MatchType
	}
	return nil
}

func (x *HttpRoute_QueryParameterMatch) GetExactMatch() string {
	if x, ok := x.GetMatchType().(*HttpRoute_QueryParameterMatch_ExactMatch); ok {
		return x.ExactMatch
	}
	return ""
}

func (x *HttpRoute_QueryParameterMatch) GetRegexMatch() string {
	if x, ok := x.GetMatchType().(*HttpRoute_QueryParameterMatch_RegexMatch); ok {
		return x.RegexMatch
	}
	return ""
}

func (x *HttpRoute_QueryParameterMatch) GetPresentMatch() bool {
	if x, ok := x.GetMatchType().(*HttpRoute_QueryParameterMatch_PresentMatch); ok {
		return x.PresentMatch
	}
	return false
}

func (x *HttpRoute_QueryParameterMatch) GetQueryParameter() string {
	if x != nil {
		return x.QueryParameter
	}
	return ""
}

type isHttpRoute_QueryParameterMatch_MatchType interface {
	isHttpRoute_QueryParameterMatch_MatchType()
}

type HttpRoute_QueryParameterMatch_ExactMatch struct {
	// The value of the query parameter must exactly match the contents of
	// exact_match.
	//
	// Only one of exact_match, regex_match, or present_match must be set.
	ExactMatch string `protobuf:"bytes,2,opt,name=exact_match,json=exactMatch,proto3,oneof"`
}

type HttpRoute_QueryParameterMatch_RegexMatch struct {
	// The value of the query parameter must match the regular expression
	// specified by regex_match. For regular expression grammar, please see
	// https://github.com/google/re2/wiki/Syntax
	//
	// Only one of exact_match, regex_match, or present_match must be set.
	RegexMatch string `protobuf:"bytes,3,opt,name=regex_match,json=regexMatch,proto3,oneof"`
}

type HttpRoute_QueryParameterMatch_PresentMatch struct {
	// Specifies that the QueryParameterMatcher matches if request contains
	// query parameter, irrespective of whether the parameter has a value or
	// not.
	//
	// Only one of exact_match, regex_match, or present_match must be set.
	PresentMatch bool `protobuf:"varint,4,opt,name=present_match,json=presentMatch,proto3,oneof"`
}

func (*HttpRoute_QueryParameterMatch_ExactMatch) isHttpRoute_QueryParameterMatch_MatchType() {}

func (*HttpRoute_QueryParameterMatch_RegexMatch) isHttpRoute_QueryParameterMatch_MatchType() {}

func (*HttpRoute_QueryParameterMatch_PresentMatch) isHttpRoute_QueryParameterMatch_MatchType() {}

// RouteMatch defines specifications used to match requests. If multiple match
// types are set, this RouteMatch will match if ALL type of matches are
// matched.
type HttpRoute_RouteMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to PathMatch:
	//
	//	*HttpRoute_RouteMatch_FullPathMatch
	//	*HttpRoute_RouteMatch_PrefixMatch
	//	*HttpRoute_RouteMatch_RegexMatch
	PathMatch isHttpRoute_RouteMatch_PathMatch `protobuf_oneof:"PathMatch"`
	// Specifies if prefix_match and full_path_match matches are case sensitive.
	// The default value is false.
	IgnoreCase bool `protobuf:"varint,4,opt,name=ignore_case,json=ignoreCase,proto3" json:"ignore_case,omitempty"`
	// Specifies a list of HTTP request headers to match against. ALL of the
	// supplied headers must be matched.
	Headers []*HttpRoute_HeaderMatch `protobuf:"bytes,5,rep,name=headers,proto3" json:"headers,omitempty"`
	// Specifies a list of query parameters to match against. ALL of the query
	// parameters must be matched.
	QueryParameters []*HttpRoute_QueryParameterMatch `protobuf:"bytes,6,rep,name=query_parameters,json=queryParameters,proto3" json:"query_parameters,omitempty"`
}

func (x *HttpRoute_RouteMatch) Reset() {
	*x = HttpRoute_RouteMatch{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_RouteMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_RouteMatch) ProtoMessage() {}

func (x *HttpRoute_RouteMatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_RouteMatch.ProtoReflect.Descriptor instead.
func (*HttpRoute_RouteMatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 2}
}

func (m *HttpRoute_RouteMatch) GetPathMatch() isHttpRoute_RouteMatch_PathMatch {
	if m != nil {
		return m.PathMatch
	}
	return nil
}

func (x *HttpRoute_RouteMatch) GetFullPathMatch() string {
	if x, ok := x.GetPathMatch().(*HttpRoute_RouteMatch_FullPathMatch); ok {
		return x.FullPathMatch
	}
	return ""
}

func (x *HttpRoute_RouteMatch) GetPrefixMatch() string {
	if x, ok := x.GetPathMatch().(*HttpRoute_RouteMatch_PrefixMatch); ok {
		return x.PrefixMatch
	}
	return ""
}

func (x *HttpRoute_RouteMatch) GetRegexMatch() string {
	if x, ok := x.GetPathMatch().(*HttpRoute_RouteMatch_RegexMatch); ok {
		return x.RegexMatch
	}
	return ""
}

func (x *HttpRoute_RouteMatch) GetIgnoreCase() bool {
	if x != nil {
		return x.IgnoreCase
	}
	return false
}

func (x *HttpRoute_RouteMatch) GetHeaders() []*HttpRoute_HeaderMatch {
	if x != nil {
		return x.Headers
	}
	return nil
}

func (x *HttpRoute_RouteMatch) GetQueryParameters() []*HttpRoute_QueryParameterMatch {
	if x != nil {
		return x.QueryParameters
	}
	return nil
}

type isHttpRoute_RouteMatch_PathMatch interface {
	isHttpRoute_RouteMatch_PathMatch()
}

type HttpRoute_RouteMatch_FullPathMatch struct {
	// The HTTP request path value should exactly match this value.
	//
	// Only one of full_path_match, prefix_match, or regex_match should be
	// used.
	FullPathMatch string `protobuf:"bytes,1,opt,name=full_path_match,json=fullPathMatch,proto3,oneof"`
}

type HttpRoute_RouteMatch_PrefixMatch struct {
	// The HTTP request path value must begin with specified prefix_match.
	// prefix_match must begin with a /.
	//
	// Only one of full_path_match, prefix_match, or regex_match should be
	// used.
	PrefixMatch string `protobuf:"bytes,2,opt,name=prefix_match,json=prefixMatch,proto3,oneof"`
}

type HttpRoute_RouteMatch_RegexMatch struct {
	// The HTTP request path value must satisfy the regular expression
	// specified by regex_match after removing any query parameters and anchor
	// supplied with the original URL. For regular expression grammar, please
	// see https://github.com/google/re2/wiki/Syntax
	//
	// Only one of full_path_match, prefix_match, or regex_match should be
	// used.
	RegexMatch string `protobuf:"bytes,3,opt,name=regex_match,json=regexMatch,proto3,oneof"`
}

func (*HttpRoute_RouteMatch_FullPathMatch) isHttpRoute_RouteMatch_PathMatch() {}

func (*HttpRoute_RouteMatch_PrefixMatch) isHttpRoute_RouteMatch_PathMatch() {}

func (*HttpRoute_RouteMatch_RegexMatch) isHttpRoute_RouteMatch_PathMatch() {}

// Specifications of a destination to which the request should be routed to.
type HttpRoute_Destination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URL of a BackendService to route traffic to.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// Specifies the proportion of requests forwarded to the backend referenced
	// by the serviceName field. This is computed as:
	// - weight/Sum(weights in this destination list).
	// For non-zero values, there may be some epsilon from the exact proportion
	// defined here depending on the precision an implementation supports.
	//
	// If only one serviceName is specified and it has a weight greater than 0,
	// 100% of the traffic is forwarded to that backend.
	//
	// If weights are specified for any one service name, they need to be
	// specified for all of them.
	//
	// If weights are unspecified for all services, then, traffic is distributed
	// in equal proportions to all of them.
	Weight int32 `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
}

func (x *HttpRoute_Destination) Reset() {
	*x = HttpRoute_Destination{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_Destination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_Destination) ProtoMessage() {}

func (x *HttpRoute_Destination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_Destination.ProtoReflect.Descriptor instead.
func (*HttpRoute_Destination) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 3}
}

func (x *HttpRoute_Destination) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *HttpRoute_Destination) GetWeight() int32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

// The specification for redirecting traffic.
type HttpRoute_Redirect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The host that will be used in the redirect response instead of the one
	// that was supplied in the request.
	HostRedirect string `protobuf:"bytes,1,opt,name=host_redirect,json=hostRedirect,proto3" json:"host_redirect,omitempty"`
	// The path that will be used in the redirect response instead of the one
	// that was supplied in the request.
	// path_redirect can not be supplied together with prefix_redirect. Supply
	// one alone or neither. If neither is supplied, the path of the original
	// request will be used for the redirect.
	PathRedirect string `protobuf:"bytes,2,opt,name=path_redirect,json=pathRedirect,proto3" json:"path_redirect,omitempty"`
	// Indicates that during redirection, the matched prefix (or path) should be
	// swapped with this value. This option allows URLs be dynamically created
	// based on the request.
	PrefixRewrite string `protobuf:"bytes,3,opt,name=prefix_rewrite,json=prefixRewrite,proto3" json:"prefix_rewrite,omitempty"`
	// The HTTP Status code to use for the redirect.
	ResponseCode HttpRoute_Redirect_ResponseCode `protobuf:"varint,4,opt,name=response_code,json=responseCode,proto3,enum=google.cloud.networkservices.v1.HttpRoute_Redirect_ResponseCode" json:"response_code,omitempty"`
	// If set to true, the URL scheme in the redirected request is set to https.
	// If set to false, the URL scheme of the redirected request will remain the
	// same as that of the request.
	//
	// The default is set to false.
	HttpsRedirect bool `protobuf:"varint,5,opt,name=https_redirect,json=httpsRedirect,proto3" json:"https_redirect,omitempty"`
	// if set to true, any accompanying query portion of the original URL is
	// removed prior to redirecting the request. If set to false, the query
	// portion of the original URL is retained.
	//
	// The default is set to false.
	StripQuery bool `protobuf:"varint,6,opt,name=strip_query,json=stripQuery,proto3" json:"strip_query,omitempty"`
	// The port that will be used in the redirected request instead of the one
	// that was supplied in the request.
	PortRedirect int32 `protobuf:"varint,7,opt,name=port_redirect,json=portRedirect,proto3" json:"port_redirect,omitempty"`
}

func (x *HttpRoute_Redirect) Reset() {
	*x = HttpRoute_Redirect{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_Redirect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_Redirect) ProtoMessage() {}

func (x *HttpRoute_Redirect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_Redirect.ProtoReflect.Descriptor instead.
func (*HttpRoute_Redirect) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 4}
}

func (x *HttpRoute_Redirect) GetHostRedirect() string {
	if x != nil {
		return x.HostRedirect
	}
	return ""
}

func (x *HttpRoute_Redirect) GetPathRedirect() string {
	if x != nil {
		return x.PathRedirect
	}
	return ""
}

func (x *HttpRoute_Redirect) GetPrefixRewrite() string {
	if x != nil {
		return x.PrefixRewrite
	}
	return ""
}

func (x *HttpRoute_Redirect) GetResponseCode() HttpRoute_Redirect_ResponseCode {
	if x != nil {
		return x.ResponseCode
	}
	return HttpRoute_Redirect_RESPONSE_CODE_UNSPECIFIED
}

func (x *HttpRoute_Redirect) GetHttpsRedirect() bool {
	if x != nil {
		return x.HttpsRedirect
	}
	return false
}

func (x *HttpRoute_Redirect) GetStripQuery() bool {
	if x != nil {
		return x.StripQuery
	}
	return false
}

func (x *HttpRoute_Redirect) GetPortRedirect() int32 {
	if x != nil {
		return x.PortRedirect
	}
	return 0
}

// The specification for fault injection introduced into traffic to test the
// resiliency of clients to destination service failure. As part of fault
// injection, when clients send requests to a destination, delays can be
// introduced by client proxy on a percentage of requests before sending those
// requests to the destination service. Similarly requests can be aborted by
// client proxy for a percentage of requests.
type HttpRoute_FaultInjectionPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The specification for injecting delay to client requests.
	Delay *HttpRoute_FaultInjectionPolicy_Delay `protobuf:"bytes,1,opt,name=delay,proto3" json:"delay,omitempty"`
	// The specification for aborting to client requests.
	Abort *HttpRoute_FaultInjectionPolicy_Abort `protobuf:"bytes,2,opt,name=abort,proto3" json:"abort,omitempty"`
}

func (x *HttpRoute_FaultInjectionPolicy) Reset() {
	*x = HttpRoute_FaultInjectionPolicy{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_FaultInjectionPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_FaultInjectionPolicy) ProtoMessage() {}

func (x *HttpRoute_FaultInjectionPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_FaultInjectionPolicy.ProtoReflect.Descriptor instead.
func (*HttpRoute_FaultInjectionPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 5}
}

func (x *HttpRoute_FaultInjectionPolicy) GetDelay() *HttpRoute_FaultInjectionPolicy_Delay {
	if x != nil {
		return x.Delay
	}
	return nil
}

func (x *HttpRoute_FaultInjectionPolicy) GetAbort() *HttpRoute_FaultInjectionPolicy_Abort {
	if x != nil {
		return x.Abort
	}
	return nil
}

// The specification for modifying HTTP header in HTTP request and HTTP
// response.
type HttpRoute_HeaderModifier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Completely overwrite/replace the headers with given map where key is the
	// name of the header, value is the value of the header.
	Set map[string]string `protobuf:"bytes,1,rep,name=set,proto3" json:"set,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Add the headers with given map where key is the name of the header, value
	// is the value of the header.
	Add map[string]string `protobuf:"bytes,2,rep,name=add,proto3" json:"add,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Remove headers (matching by header names) specified in the list.
	Remove []string `protobuf:"bytes,3,rep,name=remove,proto3" json:"remove,omitempty"`
}

func (x *HttpRoute_HeaderModifier) Reset() {
	*x = HttpRoute_HeaderModifier{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_HeaderModifier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_HeaderModifier) ProtoMessage() {}

func (x *HttpRoute_HeaderModifier) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_HeaderModifier.ProtoReflect.Descriptor instead.
func (*HttpRoute_HeaderModifier) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 6}
}

func (x *HttpRoute_HeaderModifier) GetSet() map[string]string {
	if x != nil {
		return x.Set
	}
	return nil
}

func (x *HttpRoute_HeaderModifier) GetAdd() map[string]string {
	if x != nil {
		return x.Add
	}
	return nil
}

func (x *HttpRoute_HeaderModifier) GetRemove() []string {
	if x != nil {
		return x.Remove
	}
	return nil
}

// The specification for modifying the URL of the request, prior to forwarding
// the request to the destination.
type HttpRoute_URLRewrite struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Prior to forwarding the request to the selected destination, the matching
	// portion of the requests path is replaced by this value.
	PathPrefixRewrite string `protobuf:"bytes,1,opt,name=path_prefix_rewrite,json=pathPrefixRewrite,proto3" json:"path_prefix_rewrite,omitempty"`
	// Prior to forwarding the request to the selected destination, the requests
	// host header is replaced by this value.
	HostRewrite string `protobuf:"bytes,2,opt,name=host_rewrite,json=hostRewrite,proto3" json:"host_rewrite,omitempty"`
}

func (x *HttpRoute_URLRewrite) Reset() {
	*x = HttpRoute_URLRewrite{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_URLRewrite) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_URLRewrite) ProtoMessage() {}

func (x *HttpRoute_URLRewrite) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_URLRewrite.ProtoReflect.Descriptor instead.
func (*HttpRoute_URLRewrite) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 7}
}

func (x *HttpRoute_URLRewrite) GetPathPrefixRewrite() string {
	if x != nil {
		return x.PathPrefixRewrite
	}
	return ""
}

func (x *HttpRoute_URLRewrite) GetHostRewrite() string {
	if x != nil {
		return x.HostRewrite
	}
	return ""
}

// The specifications for retries.
type HttpRoute_RetryPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies one or more conditions when this retry policy applies. Valid
	// values are:
	//
	//	5xx: Proxy will attempt a retry if the destination service responds
	//	  with any 5xx response code, of if the destination service does not
	//	  respond at all, example: disconnect, reset, read timeout, connection
	//	  failure and refused streams.
	//
	//	gateway-error: Similar to 5xx, but only applies to response codes 502,
	//	  503, 504.
	//
	//	reset: Proxy will attempt a retry if the destination service does not
	//	  respond at all (disconnect/reset/read timeout)
	//
	//	connect-failure: Proxy will retry on failures connecting to destination
	//	  for example due to connection timeouts.
	//
	//	retriable-4xx: Proxy will retry fro retriable 4xx response codes.
	//	  Currently the only retriable error supported is 409.
	//
	//	refused-stream: Proxy will retry if the destination resets the stream
	//	  with a REFUSED_STREAM error code. This reset type indicates that it
	//	  is safe to retry.
	RetryConditions []string `protobuf:"bytes,1,rep,name=retry_conditions,json=retryConditions,proto3" json:"retry_conditions,omitempty"`
	// Specifies the allowed number of retries. This number must be > 0. If not
	// specified, default to 1.
	NumRetries int32 `protobuf:"varint,2,opt,name=num_retries,json=numRetries,proto3" json:"num_retries,omitempty"`
	// Specifies a non-zero timeout per retry attempt.
	PerTryTimeout *durationpb.Duration `protobuf:"bytes,3,opt,name=per_try_timeout,json=perTryTimeout,proto3" json:"per_try_timeout,omitempty"`
}

func (x *HttpRoute_RetryPolicy) Reset() {
	*x = HttpRoute_RetryPolicy{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_RetryPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_RetryPolicy) ProtoMessage() {}

func (x *HttpRoute_RetryPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_RetryPolicy.ProtoReflect.Descriptor instead.
func (*HttpRoute_RetryPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 8}
}

func (x *HttpRoute_RetryPolicy) GetRetryConditions() []string {
	if x != nil {
		return x.RetryConditions
	}
	return nil
}

func (x *HttpRoute_RetryPolicy) GetNumRetries() int32 {
	if x != nil {
		return x.NumRetries
	}
	return 0
}

func (x *HttpRoute_RetryPolicy) GetPerTryTimeout() *durationpb.Duration {
	if x != nil {
		return x.PerTryTimeout
	}
	return nil
}

// Specifies the policy on how requests are shadowed to a separate mirrored
// destination service. The proxy does not wait for responses from the
// shadow service. Prior to sending traffic to the shadow service, the
// host/authority header is suffixed with -shadow.
type HttpRoute_RequestMirrorPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The destination the requests will be mirrored to. The weight of the
	// destination will be ignored.
	Destination *HttpRoute_Destination `protobuf:"bytes,1,opt,name=destination,proto3" json:"destination,omitempty"`
}

func (x *HttpRoute_RequestMirrorPolicy) Reset() {
	*x = HttpRoute_RequestMirrorPolicy{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_RequestMirrorPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_RequestMirrorPolicy) ProtoMessage() {}

func (x *HttpRoute_RequestMirrorPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_RequestMirrorPolicy.ProtoReflect.Descriptor instead.
func (*HttpRoute_RequestMirrorPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 9}
}

func (x *HttpRoute_RequestMirrorPolicy) GetDestination() *HttpRoute_Destination {
	if x != nil {
		return x.Destination
	}
	return nil
}

// The Specification for allowing client side cross-origin requests.
type HttpRoute_CorsPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the list of origins that will be allowed to do CORS requests.
	// An origin is allowed if it matches either an item in allow_origins or
	// an item in allow_origin_regexes.
	AllowOrigins []string `protobuf:"bytes,1,rep,name=allow_origins,json=allowOrigins,proto3" json:"allow_origins,omitempty"`
	// Specifies the regular expression patterns that match allowed origins. For
	// regular expression grammar, please see
	// https://github.com/google/re2/wiki/Syntax.
	AllowOriginRegexes []string `protobuf:"bytes,2,rep,name=allow_origin_regexes,json=allowOriginRegexes,proto3" json:"allow_origin_regexes,omitempty"`
	// Specifies the content for Access-Control-Allow-Methods header.
	AllowMethods []string `protobuf:"bytes,3,rep,name=allow_methods,json=allowMethods,proto3" json:"allow_methods,omitempty"`
	// Specifies the content for Access-Control-Allow-Headers header.
	AllowHeaders []string `protobuf:"bytes,4,rep,name=allow_headers,json=allowHeaders,proto3" json:"allow_headers,omitempty"`
	// Specifies the content for Access-Control-Expose-Headers header.
	ExposeHeaders []string `protobuf:"bytes,5,rep,name=expose_headers,json=exposeHeaders,proto3" json:"expose_headers,omitempty"`
	// Specifies how long result of a preflight request can be cached in
	// seconds. This translates to the Access-Control-Max-Age header.
	MaxAge string `protobuf:"bytes,6,opt,name=max_age,json=maxAge,proto3" json:"max_age,omitempty"`
	// In response to a preflight request, setting this to true indicates that
	// the actual request can include user credentials. This translates to the
	// Access-Control-Allow-Credentials header.
	//
	// Default value is false.
	AllowCredentials bool `protobuf:"varint,7,opt,name=allow_credentials,json=allowCredentials,proto3" json:"allow_credentials,omitempty"`
	// If true, the CORS policy is disabled. The default value is false, which
	// indicates that the CORS policy is in effect.
	Disabled bool `protobuf:"varint,8,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *HttpRoute_CorsPolicy) Reset() {
	*x = HttpRoute_CorsPolicy{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_CorsPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_CorsPolicy) ProtoMessage() {}

func (x *HttpRoute_CorsPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_CorsPolicy.ProtoReflect.Descriptor instead.
func (*HttpRoute_CorsPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 10}
}

func (x *HttpRoute_CorsPolicy) GetAllowOrigins() []string {
	if x != nil {
		return x.AllowOrigins
	}
	return nil
}

func (x *HttpRoute_CorsPolicy) GetAllowOriginRegexes() []string {
	if x != nil {
		return x.AllowOriginRegexes
	}
	return nil
}

func (x *HttpRoute_CorsPolicy) GetAllowMethods() []string {
	if x != nil {
		return x.AllowMethods
	}
	return nil
}

func (x *HttpRoute_CorsPolicy) GetAllowHeaders() []string {
	if x != nil {
		return x.AllowHeaders
	}
	return nil
}

func (x *HttpRoute_CorsPolicy) GetExposeHeaders() []string {
	if x != nil {
		return x.ExposeHeaders
	}
	return nil
}

func (x *HttpRoute_CorsPolicy) GetMaxAge() string {
	if x != nil {
		return x.MaxAge
	}
	return ""
}

func (x *HttpRoute_CorsPolicy) GetAllowCredentials() bool {
	if x != nil {
		return x.AllowCredentials
	}
	return false
}

func (x *HttpRoute_CorsPolicy) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

// The specifications for routing traffic and applying associated policies.
type HttpRoute_RouteAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The destination to which traffic should be forwarded.
	Destinations []*HttpRoute_Destination `protobuf:"bytes,1,rep,name=destinations,proto3" json:"destinations,omitempty"`
	// If set, the request is directed as configured by this field.
	Redirect *HttpRoute_Redirect `protobuf:"bytes,2,opt,name=redirect,proto3" json:"redirect,omitempty"`
	// The specification for fault injection introduced into traffic to test the
	// resiliency of clients to backend service failure. As part of fault
	// injection, when clients send requests to a backend service, delays can be
	// introduced  on a percentage of requests before sending those requests to
	// the backend service. Similarly requests from clients can be aborted for a
	// percentage of requests.
	//
	// timeout and retry_policy will be ignored by clients that are configured
	// with a fault_injection_policy
	FaultInjectionPolicy *HttpRoute_FaultInjectionPolicy `protobuf:"bytes,4,opt,name=fault_injection_policy,json=faultInjectionPolicy,proto3" json:"fault_injection_policy,omitempty"`
	// The specification for modifying the headers of a matching request prior
	// to delivery of the request to the destination. If HeaderModifiers are set
	// on both the Destination and the RouteAction, they will be merged.
	// Conflicts between the two will not be resolved on the configuration.
	RequestHeaderModifier *HttpRoute_HeaderModifier `protobuf:"bytes,5,opt,name=request_header_modifier,json=requestHeaderModifier,proto3" json:"request_header_modifier,omitempty"`
	// The specification for modifying the headers of a response prior to
	// sending the response back to the client. If HeaderModifiers are set
	// on both the Destination and the RouteAction, they will be merged.
	// Conflicts between the two will not be resolved on the configuration.
	ResponseHeaderModifier *HttpRoute_HeaderModifier `protobuf:"bytes,6,opt,name=response_header_modifier,json=responseHeaderModifier,proto3" json:"response_header_modifier,omitempty"`
	// The specification for rewrite URL before forwarding requests to the
	// destination.
	UrlRewrite *HttpRoute_URLRewrite `protobuf:"bytes,7,opt,name=url_rewrite,json=urlRewrite,proto3" json:"url_rewrite,omitempty"`
	// Specifies the timeout for selected route. Timeout is computed from the
	// time the request has been fully processed (i.e. end of stream) up until
	// the response has been completely processed. Timeout includes all retries.
	Timeout *durationpb.Duration `protobuf:"bytes,8,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Specifies the retry policy associated with this route.
	RetryPolicy *HttpRoute_RetryPolicy `protobuf:"bytes,9,opt,name=retry_policy,json=retryPolicy,proto3" json:"retry_policy,omitempty"`
	// Specifies the policy on how requests intended for the routes destination
	// are shadowed to a separate mirrored destination. Proxy will not wait for
	// the shadow destination to respond before returning the response. Prior to
	// sending traffic to the shadow service, the host/authority header is
	// suffixed with -shadow.
	RequestMirrorPolicy *HttpRoute_RequestMirrorPolicy `protobuf:"bytes,10,opt,name=request_mirror_policy,json=requestMirrorPolicy,proto3" json:"request_mirror_policy,omitempty"`
	// The specification for allowing client side cross-origin requests.
	CorsPolicy *HttpRoute_CorsPolicy `protobuf:"bytes,11,opt,name=cors_policy,json=corsPolicy,proto3" json:"cors_policy,omitempty"`
}

func (x *HttpRoute_RouteAction) Reset() {
	*x = HttpRoute_RouteAction{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_RouteAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_RouteAction) ProtoMessage() {}

func (x *HttpRoute_RouteAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_RouteAction.ProtoReflect.Descriptor instead.
func (*HttpRoute_RouteAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 11}
}

func (x *HttpRoute_RouteAction) GetDestinations() []*HttpRoute_Destination {
	if x != nil {
		return x.Destinations
	}
	return nil
}

func (x *HttpRoute_RouteAction) GetRedirect() *HttpRoute_Redirect {
	if x != nil {
		return x.Redirect
	}
	return nil
}

func (x *HttpRoute_RouteAction) GetFaultInjectionPolicy() *HttpRoute_FaultInjectionPolicy {
	if x != nil {
		return x.FaultInjectionPolicy
	}
	return nil
}

func (x *HttpRoute_RouteAction) GetRequestHeaderModifier() *HttpRoute_HeaderModifier {
	if x != nil {
		return x.RequestHeaderModifier
	}
	return nil
}

func (x *HttpRoute_RouteAction) GetResponseHeaderModifier() *HttpRoute_HeaderModifier {
	if x != nil {
		return x.ResponseHeaderModifier
	}
	return nil
}

func (x *HttpRoute_RouteAction) GetUrlRewrite() *HttpRoute_URLRewrite {
	if x != nil {
		return x.UrlRewrite
	}
	return nil
}

func (x *HttpRoute_RouteAction) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *HttpRoute_RouteAction) GetRetryPolicy() *HttpRoute_RetryPolicy {
	if x != nil {
		return x.RetryPolicy
	}
	return nil
}

func (x *HttpRoute_RouteAction) GetRequestMirrorPolicy() *HttpRoute_RequestMirrorPolicy {
	if x != nil {
		return x.RequestMirrorPolicy
	}
	return nil
}

func (x *HttpRoute_RouteAction) GetCorsPolicy() *HttpRoute_CorsPolicy {
	if x != nil {
		return x.CorsPolicy
	}
	return nil
}

// Specifies how to match traffic and how to route traffic when traffic is
// matched.
type HttpRoute_RouteRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of matches define conditions used for matching the rule against
	// incoming HTTP requests. Each match is independent, i.e. this rule will be
	// matched if ANY one of the matches is satisfied.
	//
	// If no matches field is specified, this rule will unconditionally match
	// traffic.
	//
	// If a default rule is desired to be configured, add a rule with no matches
	// specified to the end of the rules list.
	Matches []*HttpRoute_RouteMatch `protobuf:"bytes,1,rep,name=matches,proto3" json:"matches,omitempty"`
	// The detailed rule defining how to route matched traffic.
	Action *HttpRoute_RouteAction `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
}

func (x *HttpRoute_RouteRule) Reset() {
	*x = HttpRoute_RouteRule{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_RouteRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_RouteRule) ProtoMessage() {}

func (x *HttpRoute_RouteRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_RouteRule.ProtoReflect.Descriptor instead.
func (*HttpRoute_RouteRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 12}
}

func (x *HttpRoute_RouteRule) GetMatches() []*HttpRoute_RouteMatch {
	if x != nil {
		return x.Matches
	}
	return nil
}

func (x *HttpRoute_RouteRule) GetAction() *HttpRoute_RouteAction {
	if x != nil {
		return x.Action
	}
	return nil
}

// Represents an integer value range.
type HttpRoute_HeaderMatch_IntegerRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Start of the range (inclusive)
	Start int32 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	// End of the range (exclusive)
	End int32 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *HttpRoute_HeaderMatch_IntegerRange) Reset() {
	*x = HttpRoute_HeaderMatch_IntegerRange{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_HeaderMatch_IntegerRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_HeaderMatch_IntegerRange) ProtoMessage() {}

func (x *HttpRoute_HeaderMatch_IntegerRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_HeaderMatch_IntegerRange.ProtoReflect.Descriptor instead.
func (*HttpRoute_HeaderMatch_IntegerRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *HttpRoute_HeaderMatch_IntegerRange) GetStart() int32 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *HttpRoute_HeaderMatch_IntegerRange) GetEnd() int32 {
	if x != nil {
		return x.End
	}
	return 0
}

// Specification of how client requests are delayed as part of fault
// injection before being sent to a destination.
type HttpRoute_FaultInjectionPolicy_Delay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify a fixed delay before forwarding the request.
	FixedDelay *durationpb.Duration `protobuf:"bytes,1,opt,name=fixed_delay,json=fixedDelay,proto3" json:"fixed_delay,omitempty"`
	// The percentage of traffic on which delay will be injected.
	//
	// The value must be between [0, 100]
	Percentage int32 `protobuf:"varint,2,opt,name=percentage,proto3" json:"percentage,omitempty"`
}

func (x *HttpRoute_FaultInjectionPolicy_Delay) Reset() {
	*x = HttpRoute_FaultInjectionPolicy_Delay{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_FaultInjectionPolicy_Delay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_FaultInjectionPolicy_Delay) ProtoMessage() {}

func (x *HttpRoute_FaultInjectionPolicy_Delay) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_FaultInjectionPolicy_Delay.ProtoReflect.Descriptor instead.
func (*HttpRoute_FaultInjectionPolicy_Delay) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 5, 0}
}

func (x *HttpRoute_FaultInjectionPolicy_Delay) GetFixedDelay() *durationpb.Duration {
	if x != nil {
		return x.FixedDelay
	}
	return nil
}

func (x *HttpRoute_FaultInjectionPolicy_Delay) GetPercentage() int32 {
	if x != nil {
		return x.Percentage
	}
	return 0
}

// Specification of how client requests are aborted as part of fault
// injection before being sent to a destination.
type HttpRoute_FaultInjectionPolicy_Abort struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The HTTP status code used to abort the request.
	//
	// The value must be between 200 and 599 inclusive.
	HttpStatus int32 `protobuf:"varint,1,opt,name=http_status,json=httpStatus,proto3" json:"http_status,omitempty"`
	// The percentage of traffic which will be aborted.
	//
	// The value must be between [0, 100]
	Percentage int32 `protobuf:"varint,2,opt,name=percentage,proto3" json:"percentage,omitempty"`
}

func (x *HttpRoute_FaultInjectionPolicy_Abort) Reset() {
	*x = HttpRoute_FaultInjectionPolicy_Abort{}
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HttpRoute_FaultInjectionPolicy_Abort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HttpRoute_FaultInjectionPolicy_Abort) ProtoMessage() {}

func (x *HttpRoute_FaultInjectionPolicy_Abort) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_http_route_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HttpRoute_FaultInjectionPolicy_Abort.ProtoReflect.Descriptor instead.
func (*HttpRoute_FaultInjectionPolicy_Abort) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP(), []int{0, 5, 1}
}

func (x *HttpRoute_FaultInjectionPolicy_Abort) GetHttpStatus() int32 {
	if x != nil {
		return x.HttpStatus
	}
	return 0
}

func (x *HttpRoute_FaultInjectionPolicy_Abort) GetPercentage() int32 {
	if x != nil {
		return x.Percentage
	}
	return 0
}

var File_google_cloud_networkservices_v1_http_route_proto protoreflect.FileDescriptor

var file_google_cloud_networkservices_v1_http_route_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76,
	0x31, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x9f, 0x26, 0x0a, 0x09, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x65, 0x6c,
	0x66, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x25, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x43, 0x0a, 0x06, 0x6d, 0x65, 0x73,
	0x68, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x25, 0x0a, 0x23, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x68, 0x52, 0x06, 0x6d, 0x65, 0x73, 0x68, 0x65, 0x73, 0x12, 0x4a,
	0x0a, 0x08, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x2e, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x52, 0x08, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x12, 0x53, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74,
	0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x4f, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x1a, 0xac, 0x03, 0x0a, 0x0b, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x12, 0x21, 0x0a, 0x0b, 0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x65, 0x78, 0x61, 0x63, 0x74, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x12, 0x21, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x65, 0x78, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x65,
	0x78, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x23, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x25, 0x0a, 0x0d, 0x70,
	0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x00, 0x52, 0x0c, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x75, 0x66, 0x66,
	0x69, 0x78, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x66, 0x0a, 0x0b, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x48, 0x00, 0x52, 0x0a, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12,
	0x16, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x6e, 0x76, 0x65, 0x72,
	0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x69,
	0x6e, 0x76, 0x65, 0x72, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x1a, 0x36, 0x0a, 0x0c, 0x49, 0x6e,
	0x74, 0x65, 0x67, 0x65, 0x72, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x65,
	0x6e, 0x64, 0x42, 0x0b, 0x0a, 0x09, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x1a,
	0xb8, 0x01, 0x0a, 0x13, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x21, 0x0a, 0x0b, 0x65, 0x78, 0x61, 0x63, 0x74,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a,
	0x65, 0x78, 0x61, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x21, 0x0a, 0x0b, 0x72, 0x65,
	0x67, 0x65, 0x78, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x65, 0x78, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x25, 0x0a,
	0x0d, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0c, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x12, 0x27, 0x0a, 0x0f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x42, 0x0b, 0x0a,
	0x09, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xe9, 0x02, 0x0a, 0x0a, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x28, 0x0a, 0x0f, 0x66, 0x75, 0x6c,
	0x6c, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0d, 0x66, 0x75, 0x6c, 0x6c, 0x50, 0x61, 0x74, 0x68, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x12, 0x23, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x21, 0x0a, 0x0b, 0x72, 0x65, 0x67, 0x65,
	0x78, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0a, 0x72, 0x65, 0x67, 0x65, 0x78, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x1f, 0x0a, 0x0b, 0x69,
	0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x43, 0x61, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x07,
	0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x07, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x69,
	0x0a, 0x10, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x0f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x50, 0x61, 0x74,
	0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x1a, 0x74, 0x0a, 0x0b, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xfa, 0x41, 0x27,
	0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x1a, 0xe8, 0x03, 0x0a,
	0x08, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x68, 0x6f, 0x73,
	0x74, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x68, 0x6f, 0x73, 0x74, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x12, 0x23,
	0x0a, 0x0d, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x61, 0x74, 0x68, 0x52, 0x65, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x72, 0x65,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x12, 0x65, 0x0a, 0x0d, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x65,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x25, 0x0a, 0x0e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x69,
	0x70, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73,
	0x74, 0x72, 0x69, 0x70, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0c, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x22, 0x96,
	0x01, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x5f, 0x43, 0x4f, 0x44, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d,
	0x0a, 0x19, 0x4d, 0x4f, 0x56, 0x45, 0x44, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x41, 0x4e, 0x45, 0x4e,
	0x54, 0x4c, 0x59, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x01, 0x12, 0x09, 0x0a,
	0x05, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x45, 0x45, 0x5f,
	0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x03, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x45, 0x4d, 0x50, 0x4f,
	0x52, 0x41, 0x52, 0x59, 0x5f, 0x52, 0x45, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x10, 0x04, 0x12,
	0x16, 0x0a, 0x12, 0x50, 0x45, 0x52, 0x4d, 0x41, 0x4e, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x44,
	0x49, 0x52, 0x45, 0x43, 0x54, 0x10, 0x05, 0x1a, 0xff, 0x02, 0x0a, 0x14, 0x46, 0x61, 0x75, 0x6c,
	0x74, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x5b, 0x0a, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x46, 0x61, 0x75, 0x6c,
	0x74, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x5b, 0x0a,
	0x05, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x49, 0x6e,
	0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x41, 0x62,
	0x6f, 0x72, 0x74, 0x52, 0x05, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x1a, 0x63, 0x0a, 0x05, 0x44, 0x65,
	0x6c, 0x61, 0x79, 0x12, 0x3a, 0x0a, 0x0b, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x6c,
	0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x66, 0x69, 0x78, 0x65, 0x64, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x12,
	0x1e, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x1a,
	0x48, 0x0a, 0x05, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x68, 0x74, 0x74, 0x70,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x68,
	0x74, 0x74, 0x70, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x65, 0x72,
	0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x70,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x1a, 0xc4, 0x02, 0x0a, 0x0e, 0x48, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x54, 0x0a, 0x03,
	0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x2e, 0x53, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x03, 0x73,
	0x65, 0x74, 0x12, 0x54, 0x0a, 0x03, 0x61, 0x64, 0x64, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x2e, 0x41, 0x64, 0x64, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x03, 0x61, 0x64, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f,
	0x76, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65,
	0x1a, 0x36, 0x0a, 0x08, 0x53, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x36, 0x0a, 0x08, 0x41, 0x64, 0x64, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x5f, 0x0a, 0x0a, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x12, 0x2e,
	0x0a, 0x13, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x72, 0x65,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x70, 0x61, 0x74,
	0x68, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x68, 0x6f, 0x73, 0x74, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74,
	0x65, 0x1a, 0x9c, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65, 0x74,
	0x72, 0x79, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x6e, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0a, 0x6e, 0x75, 0x6d, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x41, 0x0a,
	0x0f, 0x70, 0x65, 0x72, 0x5f, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x70, 0x65, 0x72, 0x54, 0x72, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x1a, 0x6f, 0x0a, 0x13, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x69, 0x72, 0x72, 0x6f,
	0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x58, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48,
	0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0xb6, 0x02, 0x0a, 0x0a, 0x43, 0x6f, 0x72, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x5f, 0x72, 0x65, 0x67, 0x65, 0x78, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x12, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x52, 0x65, 0x67, 0x65, 0x78, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0x23, 0x0a, 0x0d,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x5f, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x6f, 0x73,
	0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x6d, 0x61, 0x78, 0x5f,
	0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6d, 0x61, 0x78, 0x41, 0x67,
	0x65, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x1a,
	0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0xcd, 0x07, 0x0a, 0x0b, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x0c, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4f, 0x0a, 0x08, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x08, 0x72,
	0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x12, 0x75, 0x0a, 0x16, 0x66, 0x61, 0x75, 0x6c, 0x74,
	0x5f, 0x69, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x2e, 0x46, 0x61, 0x75, 0x6c, 0x74, 0x49, 0x6e, 0x6a, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x14, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x49,
	0x6e, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x71,
	0x0a, 0x17, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x12, 0x73, 0x0a, 0x18, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x16,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4d, 0x6f,
	0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x56, 0x0a, 0x0b, 0x75, 0x72, 0x6c, 0x5f, 0x72, 0x65,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74,
	0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x55, 0x52, 0x4c, 0x52, 0x65, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x52, 0x0a, 0x75, 0x72, 0x6c, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x12, 0x33,
	0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x12, 0x59, 0x0a, 0x0c, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x0b, 0x72, 0x65, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x72,
	0x0a, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x72, 0x72, 0x6f, 0x72,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x4d, 0x69, 0x72, 0x72, 0x6f, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x13, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4d, 0x69, 0x72, 0x72, 0x6f, 0x72, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x56, 0x0a, 0x0b, 0x63, 0x6f, 0x72, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x2e, 0x43, 0x6f, 0x72, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0a,
	0x63, 0x6f, 0x72, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a, 0xac, 0x01, 0x0a, 0x09, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x4f, 0x0a, 0x07, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x52, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x06, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x3a, 0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x68, 0x74, 0x74,
	0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x6f,
	0x75, 0x74, 0x65, 0x7d, 0x22, 0x9d, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x74, 0x74,
	0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8d, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x74, 0x74,
	0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x4b, 0x0a, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x52, 0x0a, 0x68, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5b, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x48, 0x74, 0x74, 0x70, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xdb, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x74, 0x74, 0x70,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0d, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x49, 0x64, 0x12,
	0x4e, 0x0a, 0x0a, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x68, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x22,
	0xaa, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4e, 0x0a, 0x0a,
	0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x68, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x22, 0x5e, 0x0a, 0x16,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x48, 0x74, 0x74,
	0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0xef, 0x01, 0x0a,
	0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x48, 0x74, 0x74, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkservices_v1_http_route_proto_rawDescOnce sync.Once
	file_google_cloud_networkservices_v1_http_route_proto_rawDescData = file_google_cloud_networkservices_v1_http_route_proto_rawDesc
)

func file_google_cloud_networkservices_v1_http_route_proto_rawDescGZIP() []byte {
	file_google_cloud_networkservices_v1_http_route_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkservices_v1_http_route_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkservices_v1_http_route_proto_rawDescData)
	})
	return file_google_cloud_networkservices_v1_http_route_proto_rawDescData
}

var file_google_cloud_networkservices_v1_http_route_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_networkservices_v1_http_route_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_google_cloud_networkservices_v1_http_route_proto_goTypes = []any{
	(HttpRoute_Redirect_ResponseCode)(0),         // 0: google.cloud.networkservices.v1.HttpRoute.Redirect.ResponseCode
	(*HttpRoute)(nil),                            // 1: google.cloud.networkservices.v1.HttpRoute
	(*ListHttpRoutesRequest)(nil),                // 2: google.cloud.networkservices.v1.ListHttpRoutesRequest
	(*ListHttpRoutesResponse)(nil),               // 3: google.cloud.networkservices.v1.ListHttpRoutesResponse
	(*GetHttpRouteRequest)(nil),                  // 4: google.cloud.networkservices.v1.GetHttpRouteRequest
	(*CreateHttpRouteRequest)(nil),               // 5: google.cloud.networkservices.v1.CreateHttpRouteRequest
	(*UpdateHttpRouteRequest)(nil),               // 6: google.cloud.networkservices.v1.UpdateHttpRouteRequest
	(*DeleteHttpRouteRequest)(nil),               // 7: google.cloud.networkservices.v1.DeleteHttpRouteRequest
	(*HttpRoute_HeaderMatch)(nil),                // 8: google.cloud.networkservices.v1.HttpRoute.HeaderMatch
	(*HttpRoute_QueryParameterMatch)(nil),        // 9: google.cloud.networkservices.v1.HttpRoute.QueryParameterMatch
	(*HttpRoute_RouteMatch)(nil),                 // 10: google.cloud.networkservices.v1.HttpRoute.RouteMatch
	(*HttpRoute_Destination)(nil),                // 11: google.cloud.networkservices.v1.HttpRoute.Destination
	(*HttpRoute_Redirect)(nil),                   // 12: google.cloud.networkservices.v1.HttpRoute.Redirect
	(*HttpRoute_FaultInjectionPolicy)(nil),       // 13: google.cloud.networkservices.v1.HttpRoute.FaultInjectionPolicy
	(*HttpRoute_HeaderModifier)(nil),             // 14: google.cloud.networkservices.v1.HttpRoute.HeaderModifier
	(*HttpRoute_URLRewrite)(nil),                 // 15: google.cloud.networkservices.v1.HttpRoute.URLRewrite
	(*HttpRoute_RetryPolicy)(nil),                // 16: google.cloud.networkservices.v1.HttpRoute.RetryPolicy
	(*HttpRoute_RequestMirrorPolicy)(nil),        // 17: google.cloud.networkservices.v1.HttpRoute.RequestMirrorPolicy
	(*HttpRoute_CorsPolicy)(nil),                 // 18: google.cloud.networkservices.v1.HttpRoute.CorsPolicy
	(*HttpRoute_RouteAction)(nil),                // 19: google.cloud.networkservices.v1.HttpRoute.RouteAction
	(*HttpRoute_RouteRule)(nil),                  // 20: google.cloud.networkservices.v1.HttpRoute.RouteRule
	nil,                                          // 21: google.cloud.networkservices.v1.HttpRoute.LabelsEntry
	(*HttpRoute_HeaderMatch_IntegerRange)(nil),   // 22: google.cloud.networkservices.v1.HttpRoute.HeaderMatch.IntegerRange
	(*HttpRoute_FaultInjectionPolicy_Delay)(nil), // 23: google.cloud.networkservices.v1.HttpRoute.FaultInjectionPolicy.Delay
	(*HttpRoute_FaultInjectionPolicy_Abort)(nil), // 24: google.cloud.networkservices.v1.HttpRoute.FaultInjectionPolicy.Abort
	nil,                           // 25: google.cloud.networkservices.v1.HttpRoute.HeaderModifier.SetEntry
	nil,                           // 26: google.cloud.networkservices.v1.HttpRoute.HeaderModifier.AddEntry
	(*timestamppb.Timestamp)(nil), // 27: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil), // 28: google.protobuf.FieldMask
	(*durationpb.Duration)(nil),   // 29: google.protobuf.Duration
}
var file_google_cloud_networkservices_v1_http_route_proto_depIdxs = []int32{
	27, // 0: google.cloud.networkservices.v1.HttpRoute.create_time:type_name -> google.protobuf.Timestamp
	27, // 1: google.cloud.networkservices.v1.HttpRoute.update_time:type_name -> google.protobuf.Timestamp
	21, // 2: google.cloud.networkservices.v1.HttpRoute.labels:type_name -> google.cloud.networkservices.v1.HttpRoute.LabelsEntry
	20, // 3: google.cloud.networkservices.v1.HttpRoute.rules:type_name -> google.cloud.networkservices.v1.HttpRoute.RouteRule
	1,  // 4: google.cloud.networkservices.v1.ListHttpRoutesResponse.http_routes:type_name -> google.cloud.networkservices.v1.HttpRoute
	1,  // 5: google.cloud.networkservices.v1.CreateHttpRouteRequest.http_route:type_name -> google.cloud.networkservices.v1.HttpRoute
	28, // 6: google.cloud.networkservices.v1.UpdateHttpRouteRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 7: google.cloud.networkservices.v1.UpdateHttpRouteRequest.http_route:type_name -> google.cloud.networkservices.v1.HttpRoute
	22, // 8: google.cloud.networkservices.v1.HttpRoute.HeaderMatch.range_match:type_name -> google.cloud.networkservices.v1.HttpRoute.HeaderMatch.IntegerRange
	8,  // 9: google.cloud.networkservices.v1.HttpRoute.RouteMatch.headers:type_name -> google.cloud.networkservices.v1.HttpRoute.HeaderMatch
	9,  // 10: google.cloud.networkservices.v1.HttpRoute.RouteMatch.query_parameters:type_name -> google.cloud.networkservices.v1.HttpRoute.QueryParameterMatch
	0,  // 11: google.cloud.networkservices.v1.HttpRoute.Redirect.response_code:type_name -> google.cloud.networkservices.v1.HttpRoute.Redirect.ResponseCode
	23, // 12: google.cloud.networkservices.v1.HttpRoute.FaultInjectionPolicy.delay:type_name -> google.cloud.networkservices.v1.HttpRoute.FaultInjectionPolicy.Delay
	24, // 13: google.cloud.networkservices.v1.HttpRoute.FaultInjectionPolicy.abort:type_name -> google.cloud.networkservices.v1.HttpRoute.FaultInjectionPolicy.Abort
	25, // 14: google.cloud.networkservices.v1.HttpRoute.HeaderModifier.set:type_name -> google.cloud.networkservices.v1.HttpRoute.HeaderModifier.SetEntry
	26, // 15: google.cloud.networkservices.v1.HttpRoute.HeaderModifier.add:type_name -> google.cloud.networkservices.v1.HttpRoute.HeaderModifier.AddEntry
	29, // 16: google.cloud.networkservices.v1.HttpRoute.RetryPolicy.per_try_timeout:type_name -> google.protobuf.Duration
	11, // 17: google.cloud.networkservices.v1.HttpRoute.RequestMirrorPolicy.destination:type_name -> google.cloud.networkservices.v1.HttpRoute.Destination
	11, // 18: google.cloud.networkservices.v1.HttpRoute.RouteAction.destinations:type_name -> google.cloud.networkservices.v1.HttpRoute.Destination
	12, // 19: google.cloud.networkservices.v1.HttpRoute.RouteAction.redirect:type_name -> google.cloud.networkservices.v1.HttpRoute.Redirect
	13, // 20: google.cloud.networkservices.v1.HttpRoute.RouteAction.fault_injection_policy:type_name -> google.cloud.networkservices.v1.HttpRoute.FaultInjectionPolicy
	14, // 21: google.cloud.networkservices.v1.HttpRoute.RouteAction.request_header_modifier:type_name -> google.cloud.networkservices.v1.HttpRoute.HeaderModifier
	14, // 22: google.cloud.networkservices.v1.HttpRoute.RouteAction.response_header_modifier:type_name -> google.cloud.networkservices.v1.HttpRoute.HeaderModifier
	15, // 23: google.cloud.networkservices.v1.HttpRoute.RouteAction.url_rewrite:type_name -> google.cloud.networkservices.v1.HttpRoute.URLRewrite
	29, // 24: google.cloud.networkservices.v1.HttpRoute.RouteAction.timeout:type_name -> google.protobuf.Duration
	16, // 25: google.cloud.networkservices.v1.HttpRoute.RouteAction.retry_policy:type_name -> google.cloud.networkservices.v1.HttpRoute.RetryPolicy
	17, // 26: google.cloud.networkservices.v1.HttpRoute.RouteAction.request_mirror_policy:type_name -> google.cloud.networkservices.v1.HttpRoute.RequestMirrorPolicy
	18, // 27: google.cloud.networkservices.v1.HttpRoute.RouteAction.cors_policy:type_name -> google.cloud.networkservices.v1.HttpRoute.CorsPolicy
	10, // 28: google.cloud.networkservices.v1.HttpRoute.RouteRule.matches:type_name -> google.cloud.networkservices.v1.HttpRoute.RouteMatch
	19, // 29: google.cloud.networkservices.v1.HttpRoute.RouteRule.action:type_name -> google.cloud.networkservices.v1.HttpRoute.RouteAction
	29, // 30: google.cloud.networkservices.v1.HttpRoute.FaultInjectionPolicy.Delay.fixed_delay:type_name -> google.protobuf.Duration
	31, // [31:31] is the sub-list for method output_type
	31, // [31:31] is the sub-list for method input_type
	31, // [31:31] is the sub-list for extension type_name
	31, // [31:31] is the sub-list for extension extendee
	0,  // [0:31] is the sub-list for field type_name
}

func init() { file_google_cloud_networkservices_v1_http_route_proto_init() }
func file_google_cloud_networkservices_v1_http_route_proto_init() {
	if File_google_cloud_networkservices_v1_http_route_proto != nil {
		return
	}
	file_google_cloud_networkservices_v1_http_route_proto_msgTypes[7].OneofWrappers = []any{
		(*HttpRoute_HeaderMatch_ExactMatch)(nil),
		(*HttpRoute_HeaderMatch_RegexMatch)(nil),
		(*HttpRoute_HeaderMatch_PrefixMatch)(nil),
		(*HttpRoute_HeaderMatch_PresentMatch)(nil),
		(*HttpRoute_HeaderMatch_SuffixMatch)(nil),
		(*HttpRoute_HeaderMatch_RangeMatch)(nil),
	}
	file_google_cloud_networkservices_v1_http_route_proto_msgTypes[8].OneofWrappers = []any{
		(*HttpRoute_QueryParameterMatch_ExactMatch)(nil),
		(*HttpRoute_QueryParameterMatch_RegexMatch)(nil),
		(*HttpRoute_QueryParameterMatch_PresentMatch)(nil),
	}
	file_google_cloud_networkservices_v1_http_route_proto_msgTypes[9].OneofWrappers = []any{
		(*HttpRoute_RouteMatch_FullPathMatch)(nil),
		(*HttpRoute_RouteMatch_PrefixMatch)(nil),
		(*HttpRoute_RouteMatch_RegexMatch)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkservices_v1_http_route_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_networkservices_v1_http_route_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkservices_v1_http_route_proto_depIdxs,
		EnumInfos:         file_google_cloud_networkservices_v1_http_route_proto_enumTypes,
		MessageInfos:      file_google_cloud_networkservices_v1_http_route_proto_msgTypes,
	}.Build()
	File_google_cloud_networkservices_v1_http_route_proto = out.File
	file_google_cloud_networkservices_v1_http_route_proto_rawDesc = nil
	file_google_cloud_networkservices_v1_http_route_proto_goTypes = nil
	file_google_cloud_networkservices_v1_http_route_proto_depIdxs = nil
}
