// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/netapp/v1/kms.proto

package netapppb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The KmsConfig States
type KmsConfig_State int32

const (
	// Unspecified KmsConfig State
	KmsConfig_STATE_UNSPECIFIED KmsConfig_State = 0
	// KmsConfig State is Ready
	KmsConfig_READY KmsConfig_State = 1
	// KmsConfig State is Creating
	KmsConfig_CREATING KmsConfig_State = 2
	// KmsConfig State is Deleting
	KmsConfig_DELETING KmsConfig_State = 3
	// KmsConfig State is Updating
	KmsConfig_UPDATING KmsConfig_State = 4
	// KmsConfig State is In Use.
	KmsConfig_IN_USE KmsConfig_State = 5
	// KmsConfig State is Error
	KmsConfig_ERROR KmsConfig_State = 6
	// KmsConfig State is Pending to verify crypto key access.
	KmsConfig_KEY_CHECK_PENDING KmsConfig_State = 7
	// KmsConfig State is Not accessbile by the SDE service account to the
	// crypto key.
	KmsConfig_KEY_NOT_REACHABLE KmsConfig_State = 8
	// KmsConfig State is Disabling.
	KmsConfig_DISABLING KmsConfig_State = 9
	// KmsConfig State is Disabled.
	KmsConfig_DISABLED KmsConfig_State = 10
	// KmsConfig State is Migrating.
	// The existing volumes are migrating from SMEK to CMEK.
	KmsConfig_MIGRATING KmsConfig_State = 11
)

// Enum value maps for KmsConfig_State.
var (
	KmsConfig_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "READY",
		2:  "CREATING",
		3:  "DELETING",
		4:  "UPDATING",
		5:  "IN_USE",
		6:  "ERROR",
		7:  "KEY_CHECK_PENDING",
		8:  "KEY_NOT_REACHABLE",
		9:  "DISABLING",
		10: "DISABLED",
		11: "MIGRATING",
	}
	KmsConfig_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"READY":             1,
		"CREATING":          2,
		"DELETING":          3,
		"UPDATING":          4,
		"IN_USE":            5,
		"ERROR":             6,
		"KEY_CHECK_PENDING": 7,
		"KEY_NOT_REACHABLE": 8,
		"DISABLING":         9,
		"DISABLED":          10,
		"MIGRATING":         11,
	}
)

func (x KmsConfig_State) Enum() *KmsConfig_State {
	p := new(KmsConfig_State)
	*p = x
	return p
}

func (x KmsConfig_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (KmsConfig_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_kms_proto_enumTypes[0].Descriptor()
}

func (KmsConfig_State) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_kms_proto_enumTypes[0]
}

func (x KmsConfig_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use KmsConfig_State.Descriptor instead.
func (KmsConfig_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_kms_proto_rawDescGZIP(), []int{9, 0}
}

// GetKmsConfigRequest gets a KMS Config.
type GetKmsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the KmsConfig
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetKmsConfigRequest) Reset() {
	*x = GetKmsConfigRequest{}
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetKmsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetKmsConfigRequest) ProtoMessage() {}

func (x *GetKmsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetKmsConfigRequest.ProtoReflect.Descriptor instead.
func (*GetKmsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_kms_proto_rawDescGZIP(), []int{0}
}

func (x *GetKmsConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListKmsConfigsRequest lists KMS Configs.
type ListKmsConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value to use if there are additional
	// results to retrieve for this list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Sort results. Supported values are "name", "name desc" or "" (unsorted).
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// List filter.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListKmsConfigsRequest) Reset() {
	*x = ListKmsConfigsRequest{}
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListKmsConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListKmsConfigsRequest) ProtoMessage() {}

func (x *ListKmsConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListKmsConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListKmsConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_kms_proto_rawDescGZIP(), []int{1}
}

func (x *ListKmsConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListKmsConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListKmsConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListKmsConfigsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListKmsConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// ListKmsConfigsResponse is the response to a ListKmsConfigsRequest.
type ListKmsConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of KmsConfigs
	KmsConfigs []*KmsConfig `protobuf:"bytes,1,rep,name=kms_configs,json=kmsConfigs,proto3" json:"kms_configs,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListKmsConfigsResponse) Reset() {
	*x = ListKmsConfigsResponse{}
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListKmsConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListKmsConfigsResponse) ProtoMessage() {}

func (x *ListKmsConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListKmsConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListKmsConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_kms_proto_rawDescGZIP(), []int{2}
}

func (x *ListKmsConfigsResponse) GetKmsConfigs() []*KmsConfig {
	if x != nil {
		return x.KmsConfigs
	}
	return nil
}

func (x *ListKmsConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListKmsConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// CreateKmsConfigRequest creates a KMS Config.
type CreateKmsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting KmsConfig. Must be unique within the parent
	// resource. Must contain only letters, numbers and hyphen, with the first
	// character a letter, the last a letter or a
	// number, and a 63 character maximum.
	KmsConfigId string `protobuf:"bytes,2,opt,name=kms_config_id,json=kmsConfigId,proto3" json:"kms_config_id,omitempty"`
	// Required. The required parameters to create a new KmsConfig.
	KmsConfig *KmsConfig `protobuf:"bytes,3,opt,name=kms_config,json=kmsConfig,proto3" json:"kms_config,omitempty"`
}

func (x *CreateKmsConfigRequest) Reset() {
	*x = CreateKmsConfigRequest{}
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateKmsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateKmsConfigRequest) ProtoMessage() {}

func (x *CreateKmsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateKmsConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateKmsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_kms_proto_rawDescGZIP(), []int{3}
}

func (x *CreateKmsConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateKmsConfigRequest) GetKmsConfigId() string {
	if x != nil {
		return x.KmsConfigId
	}
	return ""
}

func (x *CreateKmsConfigRequest) GetKmsConfig() *KmsConfig {
	if x != nil {
		return x.KmsConfig
	}
	return nil
}

// UpdateKmsConfigRequest updates a KMS Config.
type UpdateKmsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// KmsConfig resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The KmsConfig being updated
	KmsConfig *KmsConfig `protobuf:"bytes,2,opt,name=kms_config,json=kmsConfig,proto3" json:"kms_config,omitempty"`
}

func (x *UpdateKmsConfigRequest) Reset() {
	*x = UpdateKmsConfigRequest{}
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateKmsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateKmsConfigRequest) ProtoMessage() {}

func (x *UpdateKmsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateKmsConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateKmsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_kms_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateKmsConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateKmsConfigRequest) GetKmsConfig() *KmsConfig {
	if x != nil {
		return x.KmsConfig
	}
	return nil
}

// DeleteKmsConfigRequest deletes a KMS Config.
type DeleteKmsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the KmsConfig.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteKmsConfigRequest) Reset() {
	*x = DeleteKmsConfigRequest{}
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteKmsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteKmsConfigRequest) ProtoMessage() {}

func (x *DeleteKmsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteKmsConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteKmsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_kms_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteKmsConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// EncryptVolumesRequest specifies the KMS config to encrypt existing volumes.
type EncryptVolumesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the KmsConfig.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *EncryptVolumesRequest) Reset() {
	*x = EncryptVolumesRequest{}
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EncryptVolumesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptVolumesRequest) ProtoMessage() {}

func (x *EncryptVolumesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptVolumesRequest.ProtoReflect.Descriptor instead.
func (*EncryptVolumesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_kms_proto_rawDescGZIP(), []int{6}
}

func (x *EncryptVolumesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// VerifyKmsConfigRequest specifies the KMS config to be validated.
type VerifyKmsConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the KMS Config to be verified.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *VerifyKmsConfigRequest) Reset() {
	*x = VerifyKmsConfigRequest{}
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VerifyKmsConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyKmsConfigRequest) ProtoMessage() {}

func (x *VerifyKmsConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyKmsConfigRequest.ProtoReflect.Descriptor instead.
func (*VerifyKmsConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_kms_proto_rawDescGZIP(), []int{7}
}

func (x *VerifyKmsConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// VerifyKmsConfigResponse contains the information if the config is correctly
// and error message.
type VerifyKmsConfigResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. If the customer key configured correctly to the encrypt
	// volume.
	Healthy bool `protobuf:"varint,1,opt,name=healthy,proto3" json:"healthy,omitempty"`
	// Output only. Error message if config is not healthy.
	HealthError string `protobuf:"bytes,2,opt,name=health_error,json=healthError,proto3" json:"health_error,omitempty"`
	// Output only. Instructions for the customers to provide the access to the
	// encryption key.
	Instructions string `protobuf:"bytes,3,opt,name=instructions,proto3" json:"instructions,omitempty"`
}

func (x *VerifyKmsConfigResponse) Reset() {
	*x = VerifyKmsConfigResponse{}
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VerifyKmsConfigResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyKmsConfigResponse) ProtoMessage() {}

func (x *VerifyKmsConfigResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyKmsConfigResponse.ProtoReflect.Descriptor instead.
func (*VerifyKmsConfigResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_kms_proto_rawDescGZIP(), []int{8}
}

func (x *VerifyKmsConfigResponse) GetHealthy() bool {
	if x != nil {
		return x.Healthy
	}
	return false
}

func (x *VerifyKmsConfigResponse) GetHealthError() string {
	if x != nil {
		return x.HealthError
	}
	return ""
}

func (x *VerifyKmsConfigResponse) GetInstructions() string {
	if x != nil {
		return x.Instructions
	}
	return ""
}

// KmsConfig is the customer managed encryption key(CMEK) configuration.
type KmsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Name of the KmsConfig.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Customer managed crypto key resource full name. Format:
	// projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{key}.
	CryptoKeyName string `protobuf:"bytes,2,opt,name=crypto_key_name,json=cryptoKeyName,proto3" json:"crypto_key_name,omitempty"`
	// Output only. State of the KmsConfig.
	State KmsConfig_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.netapp.v1.KmsConfig_State" json:"state,omitempty"`
	// Output only. State details of the KmsConfig.
	StateDetails string `protobuf:"bytes,4,opt,name=state_details,json=stateDetails,proto3" json:"state_details,omitempty"`
	// Output only. Create time of the KmsConfig.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Description of the KmsConfig.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Instructions to provide the access to the customer provided
	// encryption key.
	Instructions string `protobuf:"bytes,8,opt,name=instructions,proto3" json:"instructions,omitempty"`
	// Output only. The Service account which will have access to the customer
	// provided encryption key.
	ServiceAccount string `protobuf:"bytes,9,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
}

func (x *KmsConfig) Reset() {
	*x = KmsConfig{}
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KmsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KmsConfig) ProtoMessage() {}

func (x *KmsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_kms_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KmsConfig.ProtoReflect.Descriptor instead.
func (*KmsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_kms_proto_rawDescGZIP(), []int{9}
}

func (x *KmsConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *KmsConfig) GetCryptoKeyName() string {
	if x != nil {
		return x.CryptoKeyName
	}
	return ""
}

func (x *KmsConfig) GetState() KmsConfig_State {
	if x != nil {
		return x.State
	}
	return KmsConfig_STATE_UNSPECIFIED
}

func (x *KmsConfig) GetStateDetails() string {
	if x != nil {
		return x.StateDetails
	}
	return ""
}

func (x *KmsConfig) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *KmsConfig) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *KmsConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *KmsConfig) GetInstructions() string {
	if x != nil {
		return x.Instructions
	}
	return ""
}

func (x *KmsConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

var File_google_cloud_netapp_v1_kms_proto protoreflect.FileDescriptor

var file_google_cloud_netapp_v1_kms_proto_rawDesc = []byte{
	0x0a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x6b, 0x6d, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x52, 0x0a, 0x13, 0x47, 0x65, 0x74,
	0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x6d,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc7, 0x01,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x12,
	0x1f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa6, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74,
	0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x42, 0x0a, 0x0b, 0x6b, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0xc9, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4b, 0x6d, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x21, 0x12, 0x1f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x6d, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0d,
	0x6b, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6b, 0x6d, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x0a, 0x6b, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x6b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa1, 0x01, 0x0a,
	0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x45, 0x0a, 0x0a, 0x6b, 0x6d, 0x73,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x55, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x0a, 0x1f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x54, 0x0a, 0x15, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x6d,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x55, 0x0a,
	0x16, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x89, 0x01, 0x0a, 0x17, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4b,
	0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x1d, 0x0a, 0x07, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x12,
	0x26, 0x0a, 0x0c, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x68, 0x65, 0x61, 0x6c,
	0x74, 0x68, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x27, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xc1, 0x06, 0x0a, 0x09, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x6d, 0x73,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x27, 0x0a,
	0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0xc4, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c,
	0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4e, 0x5f, 0x55, 0x53, 0x45, 0x10,
	0x05, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x06, 0x12, 0x15, 0x0a, 0x11,
	0x4b, 0x45, 0x59, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x10, 0x07, 0x12, 0x15, 0x0a, 0x11, 0x4b, 0x45, 0x59, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x52,
	0x45, 0x41, 0x43, 0x48, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x08, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x49,
	0x53, 0x41, 0x42, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x09, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53,
	0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x0a, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x49, 0x47, 0x52, 0x41,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x0b, 0x3a, 0x7c, 0xea, 0x41, 0x79, 0x0a, 0x1f, 0x6e, 0x65, 0x74,
	0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x2f, 0x7b, 0x6b, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x2a, 0x0a, 0x6b,
	0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x32, 0x09, 0x6b, 0x6d, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0xaa, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2e, 0x76, 0x31, 0x42, 0x08, 0x4b, 0x6d, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x61, 0x70,
	0x70, 0x70, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x41,
	0x70, 0x70, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_netapp_v1_kms_proto_rawDescOnce sync.Once
	file_google_cloud_netapp_v1_kms_proto_rawDescData = file_google_cloud_netapp_v1_kms_proto_rawDesc
)

func file_google_cloud_netapp_v1_kms_proto_rawDescGZIP() []byte {
	file_google_cloud_netapp_v1_kms_proto_rawDescOnce.Do(func() {
		file_google_cloud_netapp_v1_kms_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_netapp_v1_kms_proto_rawDescData)
	})
	return file_google_cloud_netapp_v1_kms_proto_rawDescData
}

var file_google_cloud_netapp_v1_kms_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_netapp_v1_kms_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_netapp_v1_kms_proto_goTypes = []any{
	(KmsConfig_State)(0),            // 0: google.cloud.netapp.v1.KmsConfig.State
	(*GetKmsConfigRequest)(nil),     // 1: google.cloud.netapp.v1.GetKmsConfigRequest
	(*ListKmsConfigsRequest)(nil),   // 2: google.cloud.netapp.v1.ListKmsConfigsRequest
	(*ListKmsConfigsResponse)(nil),  // 3: google.cloud.netapp.v1.ListKmsConfigsResponse
	(*CreateKmsConfigRequest)(nil),  // 4: google.cloud.netapp.v1.CreateKmsConfigRequest
	(*UpdateKmsConfigRequest)(nil),  // 5: google.cloud.netapp.v1.UpdateKmsConfigRequest
	(*DeleteKmsConfigRequest)(nil),  // 6: google.cloud.netapp.v1.DeleteKmsConfigRequest
	(*EncryptVolumesRequest)(nil),   // 7: google.cloud.netapp.v1.EncryptVolumesRequest
	(*VerifyKmsConfigRequest)(nil),  // 8: google.cloud.netapp.v1.VerifyKmsConfigRequest
	(*VerifyKmsConfigResponse)(nil), // 9: google.cloud.netapp.v1.VerifyKmsConfigResponse
	(*KmsConfig)(nil),               // 10: google.cloud.netapp.v1.KmsConfig
	nil,                             // 11: google.cloud.netapp.v1.KmsConfig.LabelsEntry
	(*fieldmaskpb.FieldMask)(nil),   // 12: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),   // 13: google.protobuf.Timestamp
}
var file_google_cloud_netapp_v1_kms_proto_depIdxs = []int32{
	10, // 0: google.cloud.netapp.v1.ListKmsConfigsResponse.kms_configs:type_name -> google.cloud.netapp.v1.KmsConfig
	10, // 1: google.cloud.netapp.v1.CreateKmsConfigRequest.kms_config:type_name -> google.cloud.netapp.v1.KmsConfig
	12, // 2: google.cloud.netapp.v1.UpdateKmsConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	10, // 3: google.cloud.netapp.v1.UpdateKmsConfigRequest.kms_config:type_name -> google.cloud.netapp.v1.KmsConfig
	0,  // 4: google.cloud.netapp.v1.KmsConfig.state:type_name -> google.cloud.netapp.v1.KmsConfig.State
	13, // 5: google.cloud.netapp.v1.KmsConfig.create_time:type_name -> google.protobuf.Timestamp
	11, // 6: google.cloud.netapp.v1.KmsConfig.labels:type_name -> google.cloud.netapp.v1.KmsConfig.LabelsEntry
	7,  // [7:7] is the sub-list for method output_type
	7,  // [7:7] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_netapp_v1_kms_proto_init() }
func file_google_cloud_netapp_v1_kms_proto_init() {
	if File_google_cloud_netapp_v1_kms_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_netapp_v1_kms_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_netapp_v1_kms_proto_goTypes,
		DependencyIndexes: file_google_cloud_netapp_v1_kms_proto_depIdxs,
		EnumInfos:         file_google_cloud_netapp_v1_kms_proto_enumTypes,
		MessageInfos:      file_google_cloud_netapp_v1_kms_proto_msgTypes,
	}.Build()
	File_google_cloud_netapp_v1_kms_proto = out.File
	file_google_cloud_netapp_v1_kms_proto_rawDesc = nil
	file_google_cloud_netapp_v1_kms_proto_goTypes = nil
	file_google_cloud_netapp_v1_kms_proto_depIdxs = nil
}
