// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/memorystore/v1beta/memorystore.proto

package memorystorepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Status of the PSC connection.
type PscConnectionStatus int32

const (
	// PSC connection status is not specified.
	PscConnectionStatus_PSC_CONNECTION_STATUS_UNSPECIFIED PscConnectionStatus = 0
	// The connection is active
	PscConnectionStatus_ACTIVE PscConnectionStatus = 1
	// Connection not found
	PscConnectionStatus_NOT_FOUND PscConnectionStatus = 2
)

// Enum value maps for PscConnectionStatus.
var (
	PscConnectionStatus_name = map[int32]string{
		0: "PSC_CONNECTION_STATUS_UNSPECIFIED",
		1: "ACTIVE",
		2: "NOT_FOUND",
	}
	PscConnectionStatus_value = map[string]int32{
		"PSC_CONNECTION_STATUS_UNSPECIFIED": 0,
		"ACTIVE":                            1,
		"NOT_FOUND":                         2,
	}
)

func (x PscConnectionStatus) Enum() *PscConnectionStatus {
	p := new(PscConnectionStatus)
	*p = x
	return p
}

func (x PscConnectionStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PscConnectionStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[0].Descriptor()
}

func (PscConnectionStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[0]
}

func (x PscConnectionStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PscConnectionStatus.Descriptor instead.
func (PscConnectionStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{0}
}

// Type of a PSC connection
type ConnectionType int32

const (
	// Connection Type is not set
	ConnectionType_CONNECTION_TYPE_UNSPECIFIED ConnectionType = 0
	// Connection that will be used for topology discovery.
	ConnectionType_CONNECTION_TYPE_DISCOVERY ConnectionType = 1
	// Connection that will be used as primary endpoint to access primary.
	ConnectionType_CONNECTION_TYPE_PRIMARY ConnectionType = 2
	// Connection that will be used as reader endpoint to access replicas.
	ConnectionType_CONNECTION_TYPE_READER ConnectionType = 3
)

// Enum value maps for ConnectionType.
var (
	ConnectionType_name = map[int32]string{
		0: "CONNECTION_TYPE_UNSPECIFIED",
		1: "CONNECTION_TYPE_DISCOVERY",
		2: "CONNECTION_TYPE_PRIMARY",
		3: "CONNECTION_TYPE_READER",
	}
	ConnectionType_value = map[string]int32{
		"CONNECTION_TYPE_UNSPECIFIED": 0,
		"CONNECTION_TYPE_DISCOVERY":   1,
		"CONNECTION_TYPE_PRIMARY":     2,
		"CONNECTION_TYPE_READER":      3,
	}
)

func (x ConnectionType) Enum() *ConnectionType {
	p := new(ConnectionType)
	*p = x
	return p
}

func (x ConnectionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnectionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[1].Descriptor()
}

func (ConnectionType) Type() protoreflect.EnumType {
	return &file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[1]
}

func (x ConnectionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnectionType.Descriptor instead.
func (ConnectionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{1}
}

// Possible states of the instance.
type Instance_State int32

const (
	// Not set.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// Instance is being created.
	Instance_CREATING Instance_State = 1
	// Instance has been created and is usable.
	Instance_ACTIVE Instance_State = 2
	// Instance is being updated.
	Instance_UPDATING Instance_State = 3
	// Instance is being deleted.
	Instance_DELETING Instance_State = 4
)

// Enum value maps for Instance_State.
var (
	Instance_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
	}
	Instance_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"UPDATING":          3,
		"DELETING":          4,
	}
)

func (x Instance_State) Enum() *Instance_State {
	p := new(Instance_State)
	*p = x
	return p
}

func (x Instance_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[2].Descriptor()
}

func (Instance_State) Type() protoreflect.EnumType {
	return &file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[2]
}

func (x Instance_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_State.Descriptor instead.
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{0, 0}
}

// Possible authorization modes of the instance.
type Instance_AuthorizationMode int32

const (
	// Not set.
	Instance_AUTHORIZATION_MODE_UNSPECIFIED Instance_AuthorizationMode = 0
	// Authorization disabled.
	Instance_AUTH_DISABLED Instance_AuthorizationMode = 1
	// IAM basic authorization.
	Instance_IAM_AUTH Instance_AuthorizationMode = 2
)

// Enum value maps for Instance_AuthorizationMode.
var (
	Instance_AuthorizationMode_name = map[int32]string{
		0: "AUTHORIZATION_MODE_UNSPECIFIED",
		1: "AUTH_DISABLED",
		2: "IAM_AUTH",
	}
	Instance_AuthorizationMode_value = map[string]int32{
		"AUTHORIZATION_MODE_UNSPECIFIED": 0,
		"AUTH_DISABLED":                  1,
		"IAM_AUTH":                       2,
	}
)

func (x Instance_AuthorizationMode) Enum() *Instance_AuthorizationMode {
	p := new(Instance_AuthorizationMode)
	*p = x
	return p
}

func (x Instance_AuthorizationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_AuthorizationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[3].Descriptor()
}

func (Instance_AuthorizationMode) Type() protoreflect.EnumType {
	return &file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[3]
}

func (x Instance_AuthorizationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_AuthorizationMode.Descriptor instead.
func (Instance_AuthorizationMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{0, 1}
}

// Possible in-transit encryption modes of the instance.
type Instance_TransitEncryptionMode int32

const (
	// Not set.
	Instance_TRANSIT_ENCRYPTION_MODE_UNSPECIFIED Instance_TransitEncryptionMode = 0
	// In-transit encryption is disabled.
	Instance_TRANSIT_ENCRYPTION_DISABLED Instance_TransitEncryptionMode = 1
	// Server-managed encryption is used for in-transit encryption.
	Instance_SERVER_AUTHENTICATION Instance_TransitEncryptionMode = 2
)

// Enum value maps for Instance_TransitEncryptionMode.
var (
	Instance_TransitEncryptionMode_name = map[int32]string{
		0: "TRANSIT_ENCRYPTION_MODE_UNSPECIFIED",
		1: "TRANSIT_ENCRYPTION_DISABLED",
		2: "SERVER_AUTHENTICATION",
	}
	Instance_TransitEncryptionMode_value = map[string]int32{
		"TRANSIT_ENCRYPTION_MODE_UNSPECIFIED": 0,
		"TRANSIT_ENCRYPTION_DISABLED":         1,
		"SERVER_AUTHENTICATION":               2,
	}
)

func (x Instance_TransitEncryptionMode) Enum() *Instance_TransitEncryptionMode {
	p := new(Instance_TransitEncryptionMode)
	*p = x
	return p
}

func (x Instance_TransitEncryptionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_TransitEncryptionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[4].Descriptor()
}

func (Instance_TransitEncryptionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[4]
}

func (x Instance_TransitEncryptionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_TransitEncryptionMode.Descriptor instead.
func (Instance_TransitEncryptionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{0, 2}
}

// Possible node types of the instance. See
// https://cloud.google.com/memorystore/docs/valkey/instance-node-specification
// for more information.
type Instance_NodeType int32

const (
	// Not set.
	Instance_NODE_TYPE_UNSPECIFIED Instance_NodeType = 0
	// Shared core nano.
	Instance_SHARED_CORE_NANO Instance_NodeType = 1
	// High memory medium.
	Instance_HIGHMEM_MEDIUM Instance_NodeType = 2
	// High memory extra large.
	Instance_HIGHMEM_XLARGE Instance_NodeType = 3
	// Standard small.
	Instance_STANDARD_SMALL Instance_NodeType = 4
)

// Enum value maps for Instance_NodeType.
var (
	Instance_NodeType_name = map[int32]string{
		0: "NODE_TYPE_UNSPECIFIED",
		1: "SHARED_CORE_NANO",
		2: "HIGHMEM_MEDIUM",
		3: "HIGHMEM_XLARGE",
		4: "STANDARD_SMALL",
	}
	Instance_NodeType_value = map[string]int32{
		"NODE_TYPE_UNSPECIFIED": 0,
		"SHARED_CORE_NANO":      1,
		"HIGHMEM_MEDIUM":        2,
		"HIGHMEM_XLARGE":        3,
		"STANDARD_SMALL":        4,
	}
)

func (x Instance_NodeType) Enum() *Instance_NodeType {
	p := new(Instance_NodeType)
	*p = x
	return p
}

func (x Instance_NodeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_NodeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[5].Descriptor()
}

func (Instance_NodeType) Type() protoreflect.EnumType {
	return &file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[5]
}

func (x Instance_NodeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_NodeType.Descriptor instead.
func (Instance_NodeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{0, 3}
}

// The mode config, which is used to enable/disable cluster mode.
type Instance_Mode int32

const (
	// Mode is not specified.
	Instance_MODE_UNSPECIFIED Instance_Mode = 0
	// Deprecated: Use CLUSTER_DISABLED instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/memorystore/v1beta/memorystore.proto.
	Instance_STANDALONE Instance_Mode = 1
	// Instance is in cluster mode.
	Instance_CLUSTER Instance_Mode = 2
	// Cluster mode is disabled for the instance.
	Instance_CLUSTER_DISABLED Instance_Mode = 4
)

// Enum value maps for Instance_Mode.
var (
	Instance_Mode_name = map[int32]string{
		0: "MODE_UNSPECIFIED",
		1: "STANDALONE",
		2: "CLUSTER",
		4: "CLUSTER_DISABLED",
	}
	Instance_Mode_value = map[string]int32{
		"MODE_UNSPECIFIED": 0,
		"STANDALONE":       1,
		"CLUSTER":          2,
		"CLUSTER_DISABLED": 4,
	}
)

func (x Instance_Mode) Enum() *Instance_Mode {
	p := new(Instance_Mode)
	*p = x
	return p
}

func (x Instance_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[6].Descriptor()
}

func (Instance_Mode) Type() protoreflect.EnumType {
	return &file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[6]
}

func (x Instance_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_Mode.Descriptor instead.
func (Instance_Mode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{0, 4}
}

// Possible persistence modes.
type PersistenceConfig_PersistenceMode int32

const (
	// Not set.
	PersistenceConfig_PERSISTENCE_MODE_UNSPECIFIED PersistenceConfig_PersistenceMode = 0
	// Persistence is disabled, and any snapshot data is deleted.
	PersistenceConfig_DISABLED PersistenceConfig_PersistenceMode = 1
	// RDB based persistence is enabled.
	PersistenceConfig_RDB PersistenceConfig_PersistenceMode = 2
	// AOF based persistence is enabled.
	PersistenceConfig_AOF PersistenceConfig_PersistenceMode = 3
)

// Enum value maps for PersistenceConfig_PersistenceMode.
var (
	PersistenceConfig_PersistenceMode_name = map[int32]string{
		0: "PERSISTENCE_MODE_UNSPECIFIED",
		1: "DISABLED",
		2: "RDB",
		3: "AOF",
	}
	PersistenceConfig_PersistenceMode_value = map[string]int32{
		"PERSISTENCE_MODE_UNSPECIFIED": 0,
		"DISABLED":                     1,
		"RDB":                          2,
		"AOF":                          3,
	}
)

func (x PersistenceConfig_PersistenceMode) Enum() *PersistenceConfig_PersistenceMode {
	p := new(PersistenceConfig_PersistenceMode)
	*p = x
	return p
}

func (x PersistenceConfig_PersistenceMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PersistenceConfig_PersistenceMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[7].Descriptor()
}

func (PersistenceConfig_PersistenceMode) Type() protoreflect.EnumType {
	return &file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[7]
}

func (x PersistenceConfig_PersistenceMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PersistenceConfig_PersistenceMode.Descriptor instead.
func (PersistenceConfig_PersistenceMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{4, 0}
}

// Possible snapshot periods.
type PersistenceConfig_RDBConfig_SnapshotPeriod int32

const (
	// Not set.
	PersistenceConfig_RDBConfig_SNAPSHOT_PERIOD_UNSPECIFIED PersistenceConfig_RDBConfig_SnapshotPeriod = 0
	// One hour.
	PersistenceConfig_RDBConfig_ONE_HOUR PersistenceConfig_RDBConfig_SnapshotPeriod = 1
	// Six hours.
	PersistenceConfig_RDBConfig_SIX_HOURS PersistenceConfig_RDBConfig_SnapshotPeriod = 2
	// Twelve hours.
	PersistenceConfig_RDBConfig_TWELVE_HOURS PersistenceConfig_RDBConfig_SnapshotPeriod = 3
	// Twenty four hours.
	PersistenceConfig_RDBConfig_TWENTY_FOUR_HOURS PersistenceConfig_RDBConfig_SnapshotPeriod = 4
)

// Enum value maps for PersistenceConfig_RDBConfig_SnapshotPeriod.
var (
	PersistenceConfig_RDBConfig_SnapshotPeriod_name = map[int32]string{
		0: "SNAPSHOT_PERIOD_UNSPECIFIED",
		1: "ONE_HOUR",
		2: "SIX_HOURS",
		3: "TWELVE_HOURS",
		4: "TWENTY_FOUR_HOURS",
	}
	PersistenceConfig_RDBConfig_SnapshotPeriod_value = map[string]int32{
		"SNAPSHOT_PERIOD_UNSPECIFIED": 0,
		"ONE_HOUR":                    1,
		"SIX_HOURS":                   2,
		"TWELVE_HOURS":                3,
		"TWENTY_FOUR_HOURS":           4,
	}
)

func (x PersistenceConfig_RDBConfig_SnapshotPeriod) Enum() *PersistenceConfig_RDBConfig_SnapshotPeriod {
	p := new(PersistenceConfig_RDBConfig_SnapshotPeriod)
	*p = x
	return p
}

func (x PersistenceConfig_RDBConfig_SnapshotPeriod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PersistenceConfig_RDBConfig_SnapshotPeriod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[8].Descriptor()
}

func (PersistenceConfig_RDBConfig_SnapshotPeriod) Type() protoreflect.EnumType {
	return &file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[8]
}

func (x PersistenceConfig_RDBConfig_SnapshotPeriod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PersistenceConfig_RDBConfig_SnapshotPeriod.Descriptor instead.
func (PersistenceConfig_RDBConfig_SnapshotPeriod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{4, 0, 0}
}

// Possible fsync modes.
type PersistenceConfig_AOFConfig_AppendFsync int32

const (
	// Not set. Default: EVERY_SEC
	PersistenceConfig_AOFConfig_APPEND_FSYNC_UNSPECIFIED PersistenceConfig_AOFConfig_AppendFsync = 0
	// Never fsync. Normally Linux will flush data every 30 seconds with this
	// configuration, but it's up to the kernel's exact tuning.
	PersistenceConfig_AOFConfig_NEVER PersistenceConfig_AOFConfig_AppendFsync = 1
	// Fsync every second. You may lose 1 second of data if there is a
	// disaster.
	PersistenceConfig_AOFConfig_EVERY_SEC PersistenceConfig_AOFConfig_AppendFsync = 2
	// Fsync every time new write commands are appended to the AOF. The best
	// data loss protection at the cost of performance.
	PersistenceConfig_AOFConfig_ALWAYS PersistenceConfig_AOFConfig_AppendFsync = 3
)

// Enum value maps for PersistenceConfig_AOFConfig_AppendFsync.
var (
	PersistenceConfig_AOFConfig_AppendFsync_name = map[int32]string{
		0: "APPEND_FSYNC_UNSPECIFIED",
		1: "NEVER",
		2: "EVERY_SEC",
		3: "ALWAYS",
	}
	PersistenceConfig_AOFConfig_AppendFsync_value = map[string]int32{
		"APPEND_FSYNC_UNSPECIFIED": 0,
		"NEVER":                    1,
		"EVERY_SEC":                2,
		"ALWAYS":                   3,
	}
)

func (x PersistenceConfig_AOFConfig_AppendFsync) Enum() *PersistenceConfig_AOFConfig_AppendFsync {
	p := new(PersistenceConfig_AOFConfig_AppendFsync)
	*p = x
	return p
}

func (x PersistenceConfig_AOFConfig_AppendFsync) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PersistenceConfig_AOFConfig_AppendFsync) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[9].Descriptor()
}

func (PersistenceConfig_AOFConfig_AppendFsync) Type() protoreflect.EnumType {
	return &file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[9]
}

func (x PersistenceConfig_AOFConfig_AppendFsync) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PersistenceConfig_AOFConfig_AppendFsync.Descriptor instead.
func (PersistenceConfig_AOFConfig_AppendFsync) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{4, 1, 0}
}

// Possible zone distribution modes.
type ZoneDistributionConfig_ZoneDistributionMode int32

const (
	// Not Set. Default: MULTI_ZONE
	ZoneDistributionConfig_ZONE_DISTRIBUTION_MODE_UNSPECIFIED ZoneDistributionConfig_ZoneDistributionMode = 0
	// Distribute resources across 3 zones picked at random within the
	// region.
	ZoneDistributionConfig_MULTI_ZONE ZoneDistributionConfig_ZoneDistributionMode = 1
	// Provision resources in a single zone. Zone field must be specified.
	ZoneDistributionConfig_SINGLE_ZONE ZoneDistributionConfig_ZoneDistributionMode = 2
)

// Enum value maps for ZoneDistributionConfig_ZoneDistributionMode.
var (
	ZoneDistributionConfig_ZoneDistributionMode_name = map[int32]string{
		0: "ZONE_DISTRIBUTION_MODE_UNSPECIFIED",
		1: "MULTI_ZONE",
		2: "SINGLE_ZONE",
	}
	ZoneDistributionConfig_ZoneDistributionMode_value = map[string]int32{
		"ZONE_DISTRIBUTION_MODE_UNSPECIFIED": 0,
		"MULTI_ZONE":                         1,
		"SINGLE_ZONE":                        2,
	}
)

func (x ZoneDistributionConfig_ZoneDistributionMode) Enum() *ZoneDistributionConfig_ZoneDistributionMode {
	p := new(ZoneDistributionConfig_ZoneDistributionMode)
	*p = x
	return p
}

func (x ZoneDistributionConfig_ZoneDistributionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ZoneDistributionConfig_ZoneDistributionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[10].Descriptor()
}

func (ZoneDistributionConfig_ZoneDistributionMode) Type() protoreflect.EnumType {
	return &file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes[10]
}

func (x ZoneDistributionConfig_ZoneDistributionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ZoneDistributionConfig_ZoneDistributionMode.Descriptor instead.
func (ZoneDistributionConfig_ZoneDistributionMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{6, 0}
}

// A Memorystore instance.
type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Unique name of the instance.
	// Format: projects/{project}/locations/{location}/instances/{instance}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Creation timestamp of the instance.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Latest update timestamp of the instance.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Labels to represent user-provided metadata.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Current state of the instance.
	State Instance_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.memorystore.v1beta.Instance_State" json:"state,omitempty"`
	// Output only. Additional information about the state of the instance.
	StateInfo *Instance_StateInfo `protobuf:"bytes,6,opt,name=state_info,json=stateInfo,proto3" json:"state_info,omitempty"`
	// Output only. System assigned, unique identifier for the instance.
	Uid string `protobuf:"bytes,7,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. Number of replica nodes per shard. If omitted the default is 0
	// replicas.
	ReplicaCount *int32 `protobuf:"varint,8,opt,name=replica_count,json=replicaCount,proto3,oneof" json:"replica_count,omitempty"`
	// Optional. Immutable. Authorization mode of the instance.
	AuthorizationMode Instance_AuthorizationMode `protobuf:"varint,9,opt,name=authorization_mode,json=authorizationMode,proto3,enum=google.cloud.memorystore.v1beta.Instance_AuthorizationMode" json:"authorization_mode,omitempty"`
	// Optional. Immutable. In-transit encryption mode of the instance.
	TransitEncryptionMode Instance_TransitEncryptionMode `protobuf:"varint,10,opt,name=transit_encryption_mode,json=transitEncryptionMode,proto3,enum=google.cloud.memorystore.v1beta.Instance_TransitEncryptionMode" json:"transit_encryption_mode,omitempty"`
	// Optional. Number of shards for the instance.
	ShardCount int32 `protobuf:"varint,11,opt,name=shard_count,json=shardCount,proto3" json:"shard_count,omitempty"`
	// Output only. Endpoints clients can connect to the instance through.
	// Currently only one discovery endpoint is supported.
	DiscoveryEndpoints []*DiscoveryEndpoint `protobuf:"bytes,12,rep,name=discovery_endpoints,json=discoveryEndpoints,proto3" json:"discovery_endpoints,omitempty"`
	// Optional. Immutable. Machine type for individual nodes of the instance.
	NodeType Instance_NodeType `protobuf:"varint,13,opt,name=node_type,json=nodeType,proto3,enum=google.cloud.memorystore.v1beta.Instance_NodeType" json:"node_type,omitempty"`
	// Optional. Persistence configuration of the instance.
	PersistenceConfig *PersistenceConfig `protobuf:"bytes,14,opt,name=persistence_config,json=persistenceConfig,proto3" json:"persistence_config,omitempty"`
	// Optional. Immutable. Engine version of the instance.
	EngineVersion string `protobuf:"bytes,15,opt,name=engine_version,json=engineVersion,proto3" json:"engine_version,omitempty"`
	// Optional. User-provided engine configurations for the instance.
	EngineConfigs map[string]string `protobuf:"bytes,16,rep,name=engine_configs,json=engineConfigs,proto3" json:"engine_configs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Configuration of individual nodes of the instance.
	NodeConfig *NodeConfig `protobuf:"bytes,17,opt,name=node_config,json=nodeConfig,proto3" json:"node_config,omitempty"`
	// Optional. Immutable. Zone distribution configuration of the instance for
	// node allocation.
	ZoneDistributionConfig *ZoneDistributionConfig `protobuf:"bytes,18,opt,name=zone_distribution_config,json=zoneDistributionConfig,proto3" json:"zone_distribution_config,omitempty"`
	// Optional. If set to true deletion of the instance will fail.
	DeletionProtectionEnabled *bool `protobuf:"varint,19,opt,name=deletion_protection_enabled,json=deletionProtectionEnabled,proto3,oneof" json:"deletion_protection_enabled,omitempty"`
	// Required. Immutable. User inputs and resource details of the auto-created
	// PSC connections.
	PscAutoConnections []*PscAutoConnection `protobuf:"bytes,20,rep,name=psc_auto_connections,json=pscAutoConnections,proto3" json:"psc_auto_connections,omitempty"`
	// Optional. Endpoints for the instance.
	Endpoints []*Instance_InstanceEndpoint `protobuf:"bytes,25,rep,name=endpoints,proto3" json:"endpoints,omitempty"`
	// Optional. The mode config for the instance.
	Mode Instance_Mode `protobuf:"varint,26,opt,name=mode,proto3,enum=google.cloud.memorystore.v1beta.Instance_Mode" json:"mode,omitempty"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{0}
}

func (x *Instance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Instance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Instance) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Instance) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Instance) GetState() Instance_State {
	if x != nil {
		return x.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (x *Instance) GetStateInfo() *Instance_StateInfo {
	if x != nil {
		return x.StateInfo
	}
	return nil
}

func (x *Instance) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Instance) GetReplicaCount() int32 {
	if x != nil && x.ReplicaCount != nil {
		return *x.ReplicaCount
	}
	return 0
}

func (x *Instance) GetAuthorizationMode() Instance_AuthorizationMode {
	if x != nil {
		return x.AuthorizationMode
	}
	return Instance_AUTHORIZATION_MODE_UNSPECIFIED
}

func (x *Instance) GetTransitEncryptionMode() Instance_TransitEncryptionMode {
	if x != nil {
		return x.TransitEncryptionMode
	}
	return Instance_TRANSIT_ENCRYPTION_MODE_UNSPECIFIED
}

func (x *Instance) GetShardCount() int32 {
	if x != nil {
		return x.ShardCount
	}
	return 0
}

func (x *Instance) GetDiscoveryEndpoints() []*DiscoveryEndpoint {
	if x != nil {
		return x.DiscoveryEndpoints
	}
	return nil
}

func (x *Instance) GetNodeType() Instance_NodeType {
	if x != nil {
		return x.NodeType
	}
	return Instance_NODE_TYPE_UNSPECIFIED
}

func (x *Instance) GetPersistenceConfig() *PersistenceConfig {
	if x != nil {
		return x.PersistenceConfig
	}
	return nil
}

func (x *Instance) GetEngineVersion() string {
	if x != nil {
		return x.EngineVersion
	}
	return ""
}

func (x *Instance) GetEngineConfigs() map[string]string {
	if x != nil {
		return x.EngineConfigs
	}
	return nil
}

func (x *Instance) GetNodeConfig() *NodeConfig {
	if x != nil {
		return x.NodeConfig
	}
	return nil
}

func (x *Instance) GetZoneDistributionConfig() *ZoneDistributionConfig {
	if x != nil {
		return x.ZoneDistributionConfig
	}
	return nil
}

func (x *Instance) GetDeletionProtectionEnabled() bool {
	if x != nil && x.DeletionProtectionEnabled != nil {
		return *x.DeletionProtectionEnabled
	}
	return false
}

func (x *Instance) GetPscAutoConnections() []*PscAutoConnection {
	if x != nil {
		return x.PscAutoConnections
	}
	return nil
}

func (x *Instance) GetEndpoints() []*Instance_InstanceEndpoint {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (x *Instance) GetMode() Instance_Mode {
	if x != nil {
		return x.Mode
	}
	return Instance_MODE_UNSPECIFIED
}

// Details of consumer resources in a PSC connection.
type PscAutoConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ports of the exposed endpoint.
	//
	// Types that are assignable to Ports:
	//
	//	*PscAutoConnection_Port
	Ports isPscAutoConnection_Ports `protobuf_oneof:"ports"`
	// Output only. The PSC connection id of the forwarding rule connected to the
	// service attachment.
	PscConnectionId string `protobuf:"bytes,1,opt,name=psc_connection_id,json=pscConnectionId,proto3" json:"psc_connection_id,omitempty"`
	// Output only. The IP allocated on the consumer network for the PSC
	// forwarding rule.
	IpAddress string `protobuf:"bytes,2,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// Output only. The URI of the consumer side forwarding rule.
	// Format:
	// projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
	ForwardingRule string `protobuf:"bytes,3,opt,name=forwarding_rule,json=forwardingRule,proto3" json:"forwarding_rule,omitempty"`
	// Required. The consumer project_id where PSC connections are established.
	// This should be the same project_id that the instance is being created in.
	ProjectId string `protobuf:"bytes,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The network where the PSC endpoints are created, in the form of
	// projects/{project_id}/global/networks/{network_id}.
	Network string `protobuf:"bytes,5,opt,name=network,proto3" json:"network,omitempty"`
	// Output only. The service attachment which is the target of the PSC
	// connection, in the form of
	// projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
	ServiceAttachment string `protobuf:"bytes,6,opt,name=service_attachment,json=serviceAttachment,proto3" json:"service_attachment,omitempty"`
	// Output only. The status of the PSC connection: whether a connection exists
	// and ACTIVE or it no longer exists. Please note that this value is updated
	// periodically. Please use Private Service Connect APIs for the latest
	// status.
	PscConnectionStatus PscConnectionStatus `protobuf:"varint,7,opt,name=psc_connection_status,json=pscConnectionStatus,proto3,enum=google.cloud.memorystore.v1beta.PscConnectionStatus" json:"psc_connection_status,omitempty"`
	// Output only. Type of the PSC connection.
	ConnectionType ConnectionType `protobuf:"varint,8,opt,name=connection_type,json=connectionType,proto3,enum=google.cloud.memorystore.v1beta.ConnectionType" json:"connection_type,omitempty"`
}

func (x *PscAutoConnection) Reset() {
	*x = PscAutoConnection{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PscAutoConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PscAutoConnection) ProtoMessage() {}

func (x *PscAutoConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PscAutoConnection.ProtoReflect.Descriptor instead.
func (*PscAutoConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{1}
}

func (m *PscAutoConnection) GetPorts() isPscAutoConnection_Ports {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (x *PscAutoConnection) GetPort() int32 {
	if x, ok := x.GetPorts().(*PscAutoConnection_Port); ok {
		return x.Port
	}
	return 0
}

func (x *PscAutoConnection) GetPscConnectionId() string {
	if x != nil {
		return x.PscConnectionId
	}
	return ""
}

func (x *PscAutoConnection) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *PscAutoConnection) GetForwardingRule() string {
	if x != nil {
		return x.ForwardingRule
	}
	return ""
}

func (x *PscAutoConnection) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *PscAutoConnection) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *PscAutoConnection) GetServiceAttachment() string {
	if x != nil {
		return x.ServiceAttachment
	}
	return ""
}

func (x *PscAutoConnection) GetPscConnectionStatus() PscConnectionStatus {
	if x != nil {
		return x.PscConnectionStatus
	}
	return PscConnectionStatus_PSC_CONNECTION_STATUS_UNSPECIFIED
}

func (x *PscAutoConnection) GetConnectionType() ConnectionType {
	if x != nil {
		return x.ConnectionType
	}
	return ConnectionType_CONNECTION_TYPE_UNSPECIFIED
}

type isPscAutoConnection_Ports interface {
	isPscAutoConnection_Ports()
}

type PscAutoConnection_Port struct {
	// Optional. Output only. port will only be set for Primary/Reader or
	// Discovery endpoint.
	Port int32 `protobuf:"varint,9,opt,name=port,proto3,oneof"`
}

func (*PscAutoConnection_Port) isPscAutoConnection_Ports() {}

// User created Psc connection configuration.
type PscConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The PSC connection id of the forwarding rule connected to the
	// service attachment.
	PscConnectionId string `protobuf:"bytes,1,opt,name=psc_connection_id,json=pscConnectionId,proto3" json:"psc_connection_id,omitempty"`
	// Required. The IP allocated on the consumer network for the PSC forwarding
	// rule.
	IpAddress string `protobuf:"bytes,2,opt,name=ip_address,json=ipAddress,proto3" json:"ip_address,omitempty"`
	// Required. The URI of the consumer side forwarding rule.
	// Format:
	// projects/{project}/regions/{region}/forwardingRules/{forwarding_rule}
	ForwardingRule string `protobuf:"bytes,3,opt,name=forwarding_rule,json=forwardingRule,proto3" json:"forwarding_rule,omitempty"`
	// Output only. The consumer project_id where the forwarding rule is created
	// from.
	ProjectId string `protobuf:"bytes,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The consumer network where the IP address resides, in the form of
	// projects/{project_id}/global/networks/{network_id}.
	Network string `protobuf:"bytes,5,opt,name=network,proto3" json:"network,omitempty"`
	// Required. The service attachment which is the target of the PSC connection,
	// in the form of
	// projects/{project-id}/regions/{region}/serviceAttachments/{service-attachment-id}.
	ServiceAttachment string `protobuf:"bytes,6,opt,name=service_attachment,json=serviceAttachment,proto3" json:"service_attachment,omitempty"`
	// Output only. The status of the PSC connection: whether a connection exists
	// and ACTIVE or it no longer exists. Please note that this value is updated
	// periodically. Please use Private Service Connect APIs for the latest
	// status.
	PscConnectionStatus PscConnectionStatus `protobuf:"varint,7,opt,name=psc_connection_status,json=pscConnectionStatus,proto3,enum=google.cloud.memorystore.v1beta.PscConnectionStatus" json:"psc_connection_status,omitempty"`
	// Output only. Type of the PSC connection.
	ConnectionType ConnectionType `protobuf:"varint,8,opt,name=connection_type,json=connectionType,proto3,enum=google.cloud.memorystore.v1beta.ConnectionType" json:"connection_type,omitempty"`
}

func (x *PscConnection) Reset() {
	*x = PscConnection{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PscConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PscConnection) ProtoMessage() {}

func (x *PscConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PscConnection.ProtoReflect.Descriptor instead.
func (*PscConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{2}
}

func (x *PscConnection) GetPscConnectionId() string {
	if x != nil {
		return x.PscConnectionId
	}
	return ""
}

func (x *PscConnection) GetIpAddress() string {
	if x != nil {
		return x.IpAddress
	}
	return ""
}

func (x *PscConnection) GetForwardingRule() string {
	if x != nil {
		return x.ForwardingRule
	}
	return ""
}

func (x *PscConnection) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *PscConnection) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *PscConnection) GetServiceAttachment() string {
	if x != nil {
		return x.ServiceAttachment
	}
	return ""
}

func (x *PscConnection) GetPscConnectionStatus() PscConnectionStatus {
	if x != nil {
		return x.PscConnectionStatus
	}
	return PscConnectionStatus_PSC_CONNECTION_STATUS_UNSPECIFIED
}

func (x *PscConnection) GetConnectionType() ConnectionType {
	if x != nil {
		return x.ConnectionType
	}
	return ConnectionType_CONNECTION_TYPE_UNSPECIFIED
}

// Represents an endpoint for clients to connect to the instance.
type DiscoveryEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. IP address of the exposed endpoint clients connect to.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Output only. The port number of the exposed endpoint.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Output only. The network where the IP address of the discovery endpoint
	// will be reserved, in the form of
	// projects/{network_project}/global/networks/{network_id}.
	Network string `protobuf:"bytes,4,opt,name=network,proto3" json:"network,omitempty"`
}

func (x *DiscoveryEndpoint) Reset() {
	*x = DiscoveryEndpoint{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiscoveryEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiscoveryEndpoint) ProtoMessage() {}

func (x *DiscoveryEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiscoveryEndpoint.ProtoReflect.Descriptor instead.
func (*DiscoveryEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{3}
}

func (x *DiscoveryEndpoint) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *DiscoveryEndpoint) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *DiscoveryEndpoint) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

// Represents persistence configuration for a instance.
type PersistenceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Current persistence mode.
	Mode PersistenceConfig_PersistenceMode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.memorystore.v1beta.PersistenceConfig_PersistenceMode" json:"mode,omitempty"`
	// Optional. RDB configuration. This field will be ignored if mode is not RDB.
	RdbConfig *PersistenceConfig_RDBConfig `protobuf:"bytes,2,opt,name=rdb_config,json=rdbConfig,proto3" json:"rdb_config,omitempty"`
	// Optional. AOF configuration. This field will be ignored if mode is not AOF.
	AofConfig *PersistenceConfig_AOFConfig `protobuf:"bytes,3,opt,name=aof_config,json=aofConfig,proto3" json:"aof_config,omitempty"`
}

func (x *PersistenceConfig) Reset() {
	*x = PersistenceConfig{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PersistenceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersistenceConfig) ProtoMessage() {}

func (x *PersistenceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersistenceConfig.ProtoReflect.Descriptor instead.
func (*PersistenceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{4}
}

func (x *PersistenceConfig) GetMode() PersistenceConfig_PersistenceMode {
	if x != nil {
		return x.Mode
	}
	return PersistenceConfig_PERSISTENCE_MODE_UNSPECIFIED
}

func (x *PersistenceConfig) GetRdbConfig() *PersistenceConfig_RDBConfig {
	if x != nil {
		return x.RdbConfig
	}
	return nil
}

func (x *PersistenceConfig) GetAofConfig() *PersistenceConfig_AOFConfig {
	if x != nil {
		return x.AofConfig
	}
	return nil
}

// Represents configuration for nodes of the instance.
type NodeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Memory size in GB of the node.
	SizeGb float64 `protobuf:"fixed64,1,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
}

func (x *NodeConfig) Reset() {
	*x = NodeConfig{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeConfig) ProtoMessage() {}

func (x *NodeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeConfig.ProtoReflect.Descriptor instead.
func (*NodeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{5}
}

func (x *NodeConfig) GetSizeGb() float64 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

// Zone distribution configuration for allocation of instance resources.
type ZoneDistributionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Defines zone where all resources will be allocated with
	// SINGLE_ZONE mode. Ignored for MULTI_ZONE mode.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Optional. Current zone distribution mode. Defaults to MULTI_ZONE.
	Mode ZoneDistributionConfig_ZoneDistributionMode `protobuf:"varint,1,opt,name=mode,proto3,enum=google.cloud.memorystore.v1beta.ZoneDistributionConfig_ZoneDistributionMode" json:"mode,omitempty"`
}

func (x *ZoneDistributionConfig) Reset() {
	*x = ZoneDistributionConfig{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ZoneDistributionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ZoneDistributionConfig) ProtoMessage() {}

func (x *ZoneDistributionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ZoneDistributionConfig.ProtoReflect.Descriptor instead.
func (*ZoneDistributionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{6}
}

func (x *ZoneDistributionConfig) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *ZoneDistributionConfig) GetMode() ZoneDistributionConfig_ZoneDistributionMode {
	if x != nil {
		return x.Mode
	}
	return ZoneDistributionConfig_ZONE_DISTRIBUTION_MODE_UNSPECIFIED
}

// Request message for [ListInstances][].
type ListInstancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent to list instances from.
	// Format: projects/{project}/locations/{location}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Expression for filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Sort results by a defined order. Supported values: "name",
	// "create_time".
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListInstancesRequest) Reset() {
	*x = ListInstancesRequest{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancesRequest) ProtoMessage() {}

func (x *ListInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancesRequest.ProtoReflect.Descriptor instead.
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{7}
}

func (x *ListInstancesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstancesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstancesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInstancesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListInstancesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for [ListInstances][].
type ListInstancesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If the {location} requested was "-" the response contains a list of
	// instances from all locations. Instances in unreachable locations will be
	// omitted.
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListInstancesResponse) Reset() {
	*x = ListInstancesResponse{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListInstancesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancesResponse) ProtoMessage() {}

func (x *ListInstancesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancesResponse.ProtoReflect.Descriptor instead.
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{8}
}

func (x *ListInstancesResponse) GetInstances() []*Instance {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *ListInstancesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListInstancesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for [GetInstance][].
type GetInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the instance to retrieve.
	// Format: projects/{project}/locations/{location}/instances/{instance}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInstanceRequest) Reset() {
	*x = GetInstanceRequest{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInstanceRequest) ProtoMessage() {}

func (x *GetInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInstanceRequest.ProtoReflect.Descriptor instead.
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{9}
}

func (x *GetInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for [CreateInstance][].
type CreateInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this instance will be created.
	// Format: projects/{project}/locations/{location}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to use for the instance, which will become the final
	// component of the instance's resource name.
	//
	// This value is subject to the following restrictions:
	//
	// * Must be 4-63 characters in length
	// * Must begin with a letter or digit
	// * Must contain only lowercase letters, digits, and hyphens
	// * Must not end with a hyphen
	// * Must be unique within a location
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. The instance to create.
	Instance *Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateInstanceRequest) Reset() {
	*x = CreateInstanceRequest{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstanceRequest) ProtoMessage() {}

func (x *CreateInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstanceRequest.ProtoReflect.Descriptor instead.
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{10}
}

func (x *CreateInstanceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateInstanceRequest) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *CreateInstanceRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *CreateInstanceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [UpdateInstance][].
type UpdateInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The list of fields to be updated on the instance. At least one
	// field must be specified.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The instance to update.
	Instance *Instance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateInstanceRequest) Reset() {
	*x = UpdateInstanceRequest{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstanceRequest) ProtoMessage() {}

func (x *UpdateInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstanceRequest.ProtoReflect.Descriptor instead.
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateInstanceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateInstanceRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *UpdateInstanceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [DeleteInstance][].
type DeleteInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the instance to delete.
	// Format: projects/{project}/locations/{location}/instances/{instance}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteInstanceRequest) Reset() {
	*x = DeleteInstanceRequest{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteInstanceRequest) ProtoMessage() {}

func (x *DeleteInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteInstanceRequest.ProtoReflect.Descriptor instead.
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteInstanceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for [GetCertificateAuthority][].
type GetCertificateAuthorityRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the certificate authority.
	// Format:
	// projects/{project}/locations/{location}/instances/{instance}/certificateAuthority
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCertificateAuthorityRequest) Reset() {
	*x = GetCertificateAuthorityRequest{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCertificateAuthorityRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCertificateAuthorityRequest) ProtoMessage() {}

func (x *GetCertificateAuthorityRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCertificateAuthorityRequest.ProtoReflect.Descriptor instead.
func (*GetCertificateAuthorityRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{13}
}

func (x *GetCertificateAuthorityRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A certificate authority for an instance.
type CertificateAuthority struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about the server certificate authority.
	//
	// Types that are assignable to ServerCa:
	//
	//	*CertificateAuthority_ManagedServerCa
	ServerCa isCertificateAuthority_ServerCa `protobuf_oneof:"server_ca"`
	// Identifier. Unique name of the certificate authority.
	// Format:
	// projects/{project}/locations/{location}/instances/{instance}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CertificateAuthority) Reset() {
	*x = CertificateAuthority{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateAuthority) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority) ProtoMessage() {}

func (x *CertificateAuthority) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority.ProtoReflect.Descriptor instead.
func (*CertificateAuthority) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{14}
}

func (m *CertificateAuthority) GetServerCa() isCertificateAuthority_ServerCa {
	if m != nil {
		return m.ServerCa
	}
	return nil
}

func (x *CertificateAuthority) GetManagedServerCa() *CertificateAuthority_ManagedCertificateAuthority {
	if x, ok := x.GetServerCa().(*CertificateAuthority_ManagedServerCa); ok {
		return x.ManagedServerCa
	}
	return nil
}

func (x *CertificateAuthority) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type isCertificateAuthority_ServerCa interface {
	isCertificateAuthority_ServerCa()
}

type CertificateAuthority_ManagedServerCa struct {
	// A managed server certificate authority.
	ManagedServerCa *CertificateAuthority_ManagedCertificateAuthority `protobuf:"bytes,2,opt,name=managed_server_ca,json=managedServerCa,proto3,oneof"`
}

func (*CertificateAuthority_ManagedServerCa) isCertificateAuthority_ServerCa() {}

// Represents the metadata of a long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have been cancelled successfully
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{15}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Additional information about the state of the instance.
type Instance_StateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Info:
	//
	//	*Instance_StateInfo_UpdateInfo_
	Info isInstance_StateInfo_Info `protobuf_oneof:"info"`
}

func (x *Instance_StateInfo) Reset() {
	*x = Instance_StateInfo{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_StateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_StateInfo) ProtoMessage() {}

func (x *Instance_StateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_StateInfo.ProtoReflect.Descriptor instead.
func (*Instance_StateInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{0, 0}
}

func (m *Instance_StateInfo) GetInfo() isInstance_StateInfo_Info {
	if m != nil {
		return m.Info
	}
	return nil
}

func (x *Instance_StateInfo) GetUpdateInfo() *Instance_StateInfo_UpdateInfo {
	if x, ok := x.GetInfo().(*Instance_StateInfo_UpdateInfo_); ok {
		return x.UpdateInfo
	}
	return nil
}

type isInstance_StateInfo_Info interface {
	isInstance_StateInfo_Info()
}

type Instance_StateInfo_UpdateInfo_ struct {
	// Output only. Describes ongoing update when instance state is UPDATING.
	UpdateInfo *Instance_StateInfo_UpdateInfo `protobuf:"bytes,1,opt,name=update_info,json=updateInfo,proto3,oneof"`
}

func (*Instance_StateInfo_UpdateInfo_) isInstance_StateInfo_Info() {}

// InstanceEndpoint consists of PSC connections that are created
// as a group in each VPC network for accessing the instance. In each group,
// there shall be one connection for each service attachment in the cluster.
type Instance_InstanceEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A group of PSC connections. They are created in the same VPC
	// network, one for each service attachment in the cluster.
	Connections []*Instance_ConnectionDetail `protobuf:"bytes,1,rep,name=connections,proto3" json:"connections,omitempty"`
}

func (x *Instance_InstanceEndpoint) Reset() {
	*x = Instance_InstanceEndpoint{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_InstanceEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_InstanceEndpoint) ProtoMessage() {}

func (x *Instance_InstanceEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_InstanceEndpoint.ProtoReflect.Descriptor instead.
func (*Instance_InstanceEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Instance_InstanceEndpoint) GetConnections() []*Instance_ConnectionDetail {
	if x != nil {
		return x.Connections
	}
	return nil
}

// Information of each PSC connection.
type Instance_ConnectionDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A PSC connection to an instance could either be created through Service
	// Connectivity Automation (auto connection) during the cluster creation,
	// or it could be created by customer themeslves (user-created connection).
	//
	// Types that are assignable to Connection:
	//
	//	*Instance_ConnectionDetail_PscAutoConnection
	//	*Instance_ConnectionDetail_PscConnection
	Connection isInstance_ConnectionDetail_Connection `protobuf_oneof:"connection"`
}

func (x *Instance_ConnectionDetail) Reset() {
	*x = Instance_ConnectionDetail{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_ConnectionDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_ConnectionDetail) ProtoMessage() {}

func (x *Instance_ConnectionDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_ConnectionDetail.ProtoReflect.Descriptor instead.
func (*Instance_ConnectionDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{0, 2}
}

func (m *Instance_ConnectionDetail) GetConnection() isInstance_ConnectionDetail_Connection {
	if m != nil {
		return m.Connection
	}
	return nil
}

func (x *Instance_ConnectionDetail) GetPscAutoConnection() *PscAutoConnection {
	if x, ok := x.GetConnection().(*Instance_ConnectionDetail_PscAutoConnection); ok {
		return x.PscAutoConnection
	}
	return nil
}

func (x *Instance_ConnectionDetail) GetPscConnection() *PscConnection {
	if x, ok := x.GetConnection().(*Instance_ConnectionDetail_PscConnection); ok {
		return x.PscConnection
	}
	return nil
}

type isInstance_ConnectionDetail_Connection interface {
	isInstance_ConnectionDetail_Connection()
}

type Instance_ConnectionDetail_PscAutoConnection struct {
	// Detailed information of a PSC connection that is created through
	// service connectivity automation.
	PscAutoConnection *PscAutoConnection `protobuf:"bytes,1,opt,name=psc_auto_connection,json=pscAutoConnection,proto3,oneof"`
}

type Instance_ConnectionDetail_PscConnection struct {
	// Detailed information of a PSC connection that is created by the user.
	PscConnection *PscConnection `protobuf:"bytes,2,opt,name=psc_connection,json=pscConnection,proto3,oneof"`
}

func (*Instance_ConnectionDetail_PscAutoConnection) isInstance_ConnectionDetail_Connection() {}

func (*Instance_ConnectionDetail_PscConnection) isInstance_ConnectionDetail_Connection() {}

// Represents information about instance with state UPDATING.
type Instance_StateInfo_UpdateInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Target number of shards for the instance.
	TargetShardCount *int32 `protobuf:"varint,1,opt,name=target_shard_count,json=targetShardCount,proto3,oneof" json:"target_shard_count,omitempty"`
	// Output only. Target number of replica nodes per shard for the instance.
	TargetReplicaCount *int32 `protobuf:"varint,2,opt,name=target_replica_count,json=targetReplicaCount,proto3,oneof" json:"target_replica_count,omitempty"`
}

func (x *Instance_StateInfo_UpdateInfo) Reset() {
	*x = Instance_StateInfo_UpdateInfo{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Instance_StateInfo_UpdateInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance_StateInfo_UpdateInfo) ProtoMessage() {}

func (x *Instance_StateInfo_UpdateInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance_StateInfo_UpdateInfo.ProtoReflect.Descriptor instead.
func (*Instance_StateInfo_UpdateInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Instance_StateInfo_UpdateInfo) GetTargetShardCount() int32 {
	if x != nil && x.TargetShardCount != nil {
		return *x.TargetShardCount
	}
	return 0
}

func (x *Instance_StateInfo_UpdateInfo) GetTargetReplicaCount() int32 {
	if x != nil && x.TargetReplicaCount != nil {
		return *x.TargetReplicaCount
	}
	return 0
}

// Configuration for RDB based persistence.
type PersistenceConfig_RDBConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Period between RDB snapshots.
	RdbSnapshotPeriod PersistenceConfig_RDBConfig_SnapshotPeriod `protobuf:"varint,1,opt,name=rdb_snapshot_period,json=rdbSnapshotPeriod,proto3,enum=google.cloud.memorystore.v1beta.PersistenceConfig_RDBConfig_SnapshotPeriod" json:"rdb_snapshot_period,omitempty"`
	// Optional. Time that the first snapshot was/will be attempted, and to
	// which future snapshots will be aligned. If not provided, the current time
	// will be used.
	RdbSnapshotStartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=rdb_snapshot_start_time,json=rdbSnapshotStartTime,proto3" json:"rdb_snapshot_start_time,omitempty"`
}

func (x *PersistenceConfig_RDBConfig) Reset() {
	*x = PersistenceConfig_RDBConfig{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PersistenceConfig_RDBConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersistenceConfig_RDBConfig) ProtoMessage() {}

func (x *PersistenceConfig_RDBConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersistenceConfig_RDBConfig.ProtoReflect.Descriptor instead.
func (*PersistenceConfig_RDBConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{4, 0}
}

func (x *PersistenceConfig_RDBConfig) GetRdbSnapshotPeriod() PersistenceConfig_RDBConfig_SnapshotPeriod {
	if x != nil {
		return x.RdbSnapshotPeriod
	}
	return PersistenceConfig_RDBConfig_SNAPSHOT_PERIOD_UNSPECIFIED
}

func (x *PersistenceConfig_RDBConfig) GetRdbSnapshotStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RdbSnapshotStartTime
	}
	return nil
}

// Configuration for AOF based persistence.
type PersistenceConfig_AOFConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The fsync mode.
	AppendFsync PersistenceConfig_AOFConfig_AppendFsync `protobuf:"varint,1,opt,name=append_fsync,json=appendFsync,proto3,enum=google.cloud.memorystore.v1beta.PersistenceConfig_AOFConfig_AppendFsync" json:"append_fsync,omitempty"`
}

func (x *PersistenceConfig_AOFConfig) Reset() {
	*x = PersistenceConfig_AOFConfig{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PersistenceConfig_AOFConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersistenceConfig_AOFConfig) ProtoMessage() {}

func (x *PersistenceConfig_AOFConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersistenceConfig_AOFConfig.ProtoReflect.Descriptor instead.
func (*PersistenceConfig_AOFConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{4, 1}
}

func (x *PersistenceConfig_AOFConfig) GetAppendFsync() PersistenceConfig_AOFConfig_AppendFsync {
	if x != nil {
		return x.AppendFsync
	}
	return PersistenceConfig_AOFConfig_APPEND_FSYNC_UNSPECIFIED
}

// A managed certificate authority.
type CertificateAuthority_ManagedCertificateAuthority struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PEM encoded CA certificate chains for managed server authentication.
	CaCerts []*CertificateAuthority_ManagedCertificateAuthority_CertChain `protobuf:"bytes,1,rep,name=ca_certs,json=caCerts,proto3" json:"ca_certs,omitempty"`
}

func (x *CertificateAuthority_ManagedCertificateAuthority) Reset() {
	*x = CertificateAuthority_ManagedCertificateAuthority{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateAuthority_ManagedCertificateAuthority) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_ManagedCertificateAuthority) ProtoMessage() {}

func (x *CertificateAuthority_ManagedCertificateAuthority) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_ManagedCertificateAuthority.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_ManagedCertificateAuthority) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{14, 0}
}

func (x *CertificateAuthority_ManagedCertificateAuthority) GetCaCerts() []*CertificateAuthority_ManagedCertificateAuthority_CertChain {
	if x != nil {
		return x.CaCerts
	}
	return nil
}

// A certificate chain.
type CertificateAuthority_ManagedCertificateAuthority_CertChain struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The certificates that form the CA chain in order of leaf to root.
	Certificates []string `protobuf:"bytes,1,rep,name=certificates,proto3" json:"certificates,omitempty"`
}

func (x *CertificateAuthority_ManagedCertificateAuthority_CertChain) Reset() {
	*x = CertificateAuthority_ManagedCertificateAuthority_CertChain{}
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateAuthority_ManagedCertificateAuthority_CertChain) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateAuthority_ManagedCertificateAuthority_CertChain) ProtoMessage() {}

func (x *CertificateAuthority_ManagedCertificateAuthority_CertChain) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateAuthority_ManagedCertificateAuthority_CertChain.ProtoReflect.Descriptor instead.
func (*CertificateAuthority_ManagedCertificateAuthority_CertChain) Descriptor() ([]byte, []int) {
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP(), []int{14, 0, 0}
}

func (x *CertificateAuthority_ManagedCertificateAuthority_CertChain) GetCertificates() []string {
	if x != nil {
		return x.Certificates
	}
	return nil
}

var File_google_cloud_memorystore_v1beta_memorystore_proto protoreflect.FileDescriptor

var file_google_cloud_memorystore_v1beta_memorystore_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xad, 0x19, 0x0a, 0x08, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x57, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1d, 0x0a, 0x03,
	0x75, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c,
	0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x2d, 0x0a, 0x0d, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x72, 0x0a, 0x12, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x6f, 0x64, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x52, 0x11, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x7f,
	0x0a, 0x17, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x69, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x52, 0x15, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69,
	0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x24, 0x0a, 0x0b, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x68, 0x0a, 0x13, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12,
	0x57, 0x0a, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4e, 0x6f,
	0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x52, 0x08,
	0x6e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x66, 0x0a, 0x12, 0x70, 0x65, 0x72, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x70,
	0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x2d, 0x0a, 0x0e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05,
	0x52, 0x0d, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x68, 0x0a, 0x0e, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x51, 0x0a, 0x0b, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x79, 0x0a, 0x18,
	0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x52,
	0x16, 0x7a, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x48, 0x0a, 0x1b, 0x64, 0x65, 0x6c, 0x65, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x01, 0x52, 0x19, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x88, 0x01,
	0x01, 0x12, 0x6c, 0x0a, 0x14, 0x70, 0x73, 0x63, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x50, 0x73, 0x63, 0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x12, 0x70, 0x73, 0x63,
	0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x5d, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x19, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x47,
	0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x1a, 0xae, 0x02, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x66, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0xb0, 0x01,
	0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x36, 0x0a, 0x12,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x68, 0x61, 0x72, 0x64, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x3a, 0x0a, 0x14, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01,
	0x42, 0x15, 0x0a, 0x13, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x42, 0x06, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x75, 0x0a, 0x10, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x61, 0x0a, 0x0b,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a,
	0xdf, 0x01, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x12, 0x64, 0x0a, 0x13, 0x70, 0x73, 0x63, 0x5f, 0x61, 0x75, 0x74, 0x6f,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x50, 0x73, 0x63, 0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x70, 0x73, 0x63, 0x41, 0x75, 0x74, 0x6f,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x57, 0x0a, 0x0e, 0x70, 0x73,
	0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x40, 0x0a, 0x12,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x54,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x22, 0x58, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x41, 0x55, 0x54,
	0x48, 0x4f, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a,
	0x0d, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x0c, 0x0a, 0x08, 0x49, 0x41, 0x4d, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x10, 0x02, 0x22, 0x7c,
	0x0a, 0x15, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x54, 0x52, 0x41, 0x4e, 0x53,
	0x49, 0x54, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f,
	0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x1f, 0x0a, 0x1b, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x49, 0x54, 0x5f, 0x45, 0x4e, 0x43, 0x52,
	0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10,
	0x01, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x41, 0x55, 0x54, 0x48,
	0x45, 0x4e, 0x54, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0x77, 0x0a, 0x08,
	0x4e, 0x6f, 0x64, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x4e, 0x4f, 0x44, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x48, 0x41, 0x52, 0x45, 0x44, 0x5f, 0x43, 0x4f,
	0x52, 0x45, 0x5f, 0x4e, 0x41, 0x4e, 0x4f, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x49, 0x47,
	0x48, 0x4d, 0x45, 0x4d, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x12, 0x0a,
	0x0e, 0x48, 0x49, 0x47, 0x48, 0x4d, 0x45, 0x4d, 0x5f, 0x58, 0x4c, 0x41, 0x52, 0x47, 0x45, 0x10,
	0x03, 0x12, 0x12, 0x0a, 0x0e, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x5f, 0x53, 0x4d,
	0x41, 0x4c, 0x4c, 0x10, 0x04, 0x22, 0x53, 0x0a, 0x04, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0a, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x4c, 0x4f, 0x4e,
	0x45, 0x10, 0x01, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4c, 0x55, 0x53, 0x54,
	0x45, 0x52, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f,
	0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x7b, 0xea, 0x41, 0x78, 0x0a,
	0x23, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x7d, 0x2a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x32, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x64, 0x65,
	0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x84, 0x05, 0x0a, 0x11, 0x50, 0x73,
	0x63, 0x41, 0x75, 0x74, 0x6f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1c, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x42, 0x06, 0xe0,
	0x41, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x2f, 0x0a,
	0x11, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70,
	0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2a,
	0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x02, 0x52,
	0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x56, 0x0a, 0x0f, 0x66, 0x6f,
	0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75,
	0x6c, 0x65, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75,
	0x6c, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a,
	0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52,
	0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5f, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6d, 0x0a, 0x15, 0x70, 0x73, 0x63,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x73, 0x63, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x13, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5d, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x22, 0xd9, 0x04, 0x0a, 0x0d, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x11, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0f, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0a, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x02, 0xe2, 0x8c, 0xcf, 0xd7,
	0x08, 0x02, 0x08, 0x02, 0x52, 0x09, 0x69, 0x70, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12,
	0x56, 0x0a, 0x0f, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27,
	0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x0e, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x07, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5f, 0x0a,
	0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x6d,
	0x0a, 0x15, 0x70, 0x73, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x70, 0x73, 0x63, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x5d, 0x0a,
	0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x22, 0x8d, 0x01, 0x0a,
	0x11, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0xbe, 0x07, 0x0a,
	0x11, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x5b, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12,
	0x60, 0x0a, 0x0a, 0x72, 0x64, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x44, 0x42, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x64, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x60, 0x0a, 0x0a, 0x61, 0x6f, 0x66, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x4f, 0x46, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x61, 0x6f, 0x66, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x1a, 0xdf, 0x02, 0x0a, 0x09, 0x52, 0x44, 0x42, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x80, 0x01, 0x0a, 0x13, 0x72, 0x64, 0x62, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x52, 0x44, 0x42, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x11, 0x72, 0x64, 0x62, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x12, 0x56, 0x0a, 0x17, 0x72, 0x64, 0x62, 0x5f, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x72, 0x64, 0x62, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x53, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x77, 0x0a, 0x0e,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x12, 0x1f,
	0x0a, 0x1b, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x5f, 0x50, 0x45, 0x52, 0x49, 0x4f,
	0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x4f, 0x4e, 0x45, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x10, 0x01, 0x12, 0x0d, 0x0a,
	0x09, 0x53, 0x49, 0x58, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c,
	0x54, 0x57, 0x45, 0x4c, 0x56, 0x45, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x03, 0x12, 0x15,
	0x0a, 0x11, 0x54, 0x57, 0x45, 0x4e, 0x54, 0x59, 0x5f, 0x46, 0x4f, 0x55, 0x52, 0x5f, 0x48, 0x4f,
	0x55, 0x52, 0x53, 0x10, 0x04, 0x1a, 0xd0, 0x01, 0x0a, 0x09, 0x41, 0x4f, 0x46, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x0c, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x5f, 0x66, 0x73,
	0x79, 0x6e, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x65, 0x72, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x4f,
	0x46, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x46, 0x73,
	0x79, 0x6e, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64,
	0x46, 0x73, 0x79, 0x6e, 0x63, 0x22, 0x51, 0x0a, 0x0b, 0x41, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x46,
	0x73, 0x79, 0x6e, 0x63, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x50, 0x50, 0x45, 0x4e, 0x44, 0x5f, 0x46,
	0x53, 0x59, 0x4e, 0x43, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x4e, 0x45, 0x56, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0d, 0x0a,
	0x09, 0x45, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x53, 0x45, 0x43, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x10, 0x03, 0x22, 0x53, 0x0a, 0x0f, 0x50, 0x65, 0x72, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x50,
	0x45, 0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x52,
	0x44, 0x42, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x4f, 0x46, 0x10, 0x03, 0x22, 0x2a, 0x0a,
	0x0a, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1c, 0x0a, 0x07, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x22, 0xf9, 0x01, 0x0a, 0x16, 0x5a, 0x6f,
	0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x65, 0x0a,
	0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x5a, 0x6f,
	0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x5a, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x6d, 0x6f, 0x64, 0x65, 0x22, 0x5f, 0x0a, 0x14, 0x5a, 0x6f, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x26, 0x0a, 0x22,
	0x5a, 0x4f, 0x4e, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x54, 0x52, 0x49, 0x42, 0x55, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f, 0x5a, 0x4f,
	0x4e, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x5f, 0x5a,
	0x4f, 0x4e, 0x45, 0x10, 0x02, 0x22, 0xde, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xaa, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x47, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x22, 0x55, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xfa, 0x01, 0x0a, 0x15, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x12, 0x23, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x4a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xd1, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x4a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x84, 0x01, 0x0a, 0x15,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2,
	0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x61, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbf, 0x04, 0x0a, 0x14, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x7f,
	0x0a, 0x11, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x5f, 0x63, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0f,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x61, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0xc6, 0x01, 0x0a, 0x1b, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x76, 0x0a, 0x08, 0x63, 0x61, 0x5f, 0x63,
	0x65, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x2e, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x43, 0x65,
	0x72, 0x74, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x52, 0x07, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x73,
	0x1a, 0x2f, 0x0a, 0x09, 0x43, 0x65, 0x72, 0x74, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x22, 0x0a,
	0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x73, 0x3a, 0xb6, 0x01, 0xea, 0x41, 0xb2, 0x01, 0x0a, 0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x2a, 0x16, 0x63, 0x65,
	0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x32, 0x14, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x42, 0x0b, 0x0a, 0x09, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72,
	0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a,
	0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x2a,
	0x57, 0x0a, 0x13, 0x50, 0x73, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x25, 0x0a, 0x21, 0x50, 0x53, 0x43, 0x5f, 0x43, 0x4f,
	0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x4f, 0x54,
	0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x10, 0x02, 0x2a, 0x89, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x43,
	0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19,
	0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x43,
	0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50,
	0x52, 0x49, 0x4d, 0x41, 0x52, 0x59, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x43, 0x4f, 0x4e, 0x4e,
	0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x41, 0x44,
	0x45, 0x52, 0x10, 0x03, 0x32, 0xf6, 0x0a, 0x0a, 0x0b, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x12, 0xc2, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xaf, 0x01, 0x0a, 0x0b, 0x47, 0x65,
	0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x40, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xeb, 0x01, 0x0a, 0x0e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x01, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xed, 0x01, 0x0a, 0x0e, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x14, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x46, 0x3a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x32, 0x3a, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd6, 0x01, 0x0a, 0x0e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x6d, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x2a,
	0x31, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xe8, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x47, 0x65, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x22, 0x55, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x1a, 0x4e, 0xca,
	0x41, 0x1a, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xa0, 0x04,
	0xea, 0x41, 0x6e, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x72, 0x77,
	0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x45, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x2f,
	0x7b, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65,
	0x7d, 0xea, 0x41, 0x4e, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x12, 0x2c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x7d, 0xea, 0x41, 0x77, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x4b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x67,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x0a, 0x23, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x42, 0x0b, 0x56, 0x31, 0x6d, 0x61, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x45, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x6d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x70, 0x62, 0x3b, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x22, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescOnce sync.Once
	file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescData = file_google_cloud_memorystore_v1beta_memorystore_proto_rawDesc
)

func file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescGZIP() []byte {
	file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescOnce.Do(func() {
		file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescData)
	})
	return file_google_cloud_memorystore_v1beta_memorystore_proto_rawDescData
}

var file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_google_cloud_memorystore_v1beta_memorystore_proto_goTypes = []any{
	(PscConnectionStatus)(0),                                 // 0: google.cloud.memorystore.v1beta.PscConnectionStatus
	(ConnectionType)(0),                                      // 1: google.cloud.memorystore.v1beta.ConnectionType
	(Instance_State)(0),                                      // 2: google.cloud.memorystore.v1beta.Instance.State
	(Instance_AuthorizationMode)(0),                          // 3: google.cloud.memorystore.v1beta.Instance.AuthorizationMode
	(Instance_TransitEncryptionMode)(0),                      // 4: google.cloud.memorystore.v1beta.Instance.TransitEncryptionMode
	(Instance_NodeType)(0),                                   // 5: google.cloud.memorystore.v1beta.Instance.NodeType
	(Instance_Mode)(0),                                       // 6: google.cloud.memorystore.v1beta.Instance.Mode
	(PersistenceConfig_PersistenceMode)(0),                   // 7: google.cloud.memorystore.v1beta.PersistenceConfig.PersistenceMode
	(PersistenceConfig_RDBConfig_SnapshotPeriod)(0),          // 8: google.cloud.memorystore.v1beta.PersistenceConfig.RDBConfig.SnapshotPeriod
	(PersistenceConfig_AOFConfig_AppendFsync)(0),             // 9: google.cloud.memorystore.v1beta.PersistenceConfig.AOFConfig.AppendFsync
	(ZoneDistributionConfig_ZoneDistributionMode)(0),         // 10: google.cloud.memorystore.v1beta.ZoneDistributionConfig.ZoneDistributionMode
	(*Instance)(nil),                                         // 11: google.cloud.memorystore.v1beta.Instance
	(*PscAutoConnection)(nil),                                // 12: google.cloud.memorystore.v1beta.PscAutoConnection
	(*PscConnection)(nil),                                    // 13: google.cloud.memorystore.v1beta.PscConnection
	(*DiscoveryEndpoint)(nil),                                // 14: google.cloud.memorystore.v1beta.DiscoveryEndpoint
	(*PersistenceConfig)(nil),                                // 15: google.cloud.memorystore.v1beta.PersistenceConfig
	(*NodeConfig)(nil),                                       // 16: google.cloud.memorystore.v1beta.NodeConfig
	(*ZoneDistributionConfig)(nil),                           // 17: google.cloud.memorystore.v1beta.ZoneDistributionConfig
	(*ListInstancesRequest)(nil),                             // 18: google.cloud.memorystore.v1beta.ListInstancesRequest
	(*ListInstancesResponse)(nil),                            // 19: google.cloud.memorystore.v1beta.ListInstancesResponse
	(*GetInstanceRequest)(nil),                               // 20: google.cloud.memorystore.v1beta.GetInstanceRequest
	(*CreateInstanceRequest)(nil),                            // 21: google.cloud.memorystore.v1beta.CreateInstanceRequest
	(*UpdateInstanceRequest)(nil),                            // 22: google.cloud.memorystore.v1beta.UpdateInstanceRequest
	(*DeleteInstanceRequest)(nil),                            // 23: google.cloud.memorystore.v1beta.DeleteInstanceRequest
	(*GetCertificateAuthorityRequest)(nil),                   // 24: google.cloud.memorystore.v1beta.GetCertificateAuthorityRequest
	(*CertificateAuthority)(nil),                             // 25: google.cloud.memorystore.v1beta.CertificateAuthority
	(*OperationMetadata)(nil),                                // 26: google.cloud.memorystore.v1beta.OperationMetadata
	(*Instance_StateInfo)(nil),                               // 27: google.cloud.memorystore.v1beta.Instance.StateInfo
	(*Instance_InstanceEndpoint)(nil),                        // 28: google.cloud.memorystore.v1beta.Instance.InstanceEndpoint
	(*Instance_ConnectionDetail)(nil),                        // 29: google.cloud.memorystore.v1beta.Instance.ConnectionDetail
	nil,                                                      // 30: google.cloud.memorystore.v1beta.Instance.LabelsEntry
	nil,                                                      // 31: google.cloud.memorystore.v1beta.Instance.EngineConfigsEntry
	(*Instance_StateInfo_UpdateInfo)(nil),                    // 32: google.cloud.memorystore.v1beta.Instance.StateInfo.UpdateInfo
	(*PersistenceConfig_RDBConfig)(nil),                      // 33: google.cloud.memorystore.v1beta.PersistenceConfig.RDBConfig
	(*PersistenceConfig_AOFConfig)(nil),                      // 34: google.cloud.memorystore.v1beta.PersistenceConfig.AOFConfig
	(*CertificateAuthority_ManagedCertificateAuthority)(nil), // 35: google.cloud.memorystore.v1beta.CertificateAuthority.ManagedCertificateAuthority
	(*CertificateAuthority_ManagedCertificateAuthority_CertChain)(nil), // 36: google.cloud.memorystore.v1beta.CertificateAuthority.ManagedCertificateAuthority.CertChain
	(*timestamppb.Timestamp)(nil),                                      // 37: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),                                      // 38: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),                                    // 39: google.longrunning.Operation
}
var file_google_cloud_memorystore_v1beta_memorystore_proto_depIdxs = []int32{
	37, // 0: google.cloud.memorystore.v1beta.Instance.create_time:type_name -> google.protobuf.Timestamp
	37, // 1: google.cloud.memorystore.v1beta.Instance.update_time:type_name -> google.protobuf.Timestamp
	30, // 2: google.cloud.memorystore.v1beta.Instance.labels:type_name -> google.cloud.memorystore.v1beta.Instance.LabelsEntry
	2,  // 3: google.cloud.memorystore.v1beta.Instance.state:type_name -> google.cloud.memorystore.v1beta.Instance.State
	27, // 4: google.cloud.memorystore.v1beta.Instance.state_info:type_name -> google.cloud.memorystore.v1beta.Instance.StateInfo
	3,  // 5: google.cloud.memorystore.v1beta.Instance.authorization_mode:type_name -> google.cloud.memorystore.v1beta.Instance.AuthorizationMode
	4,  // 6: google.cloud.memorystore.v1beta.Instance.transit_encryption_mode:type_name -> google.cloud.memorystore.v1beta.Instance.TransitEncryptionMode
	14, // 7: google.cloud.memorystore.v1beta.Instance.discovery_endpoints:type_name -> google.cloud.memorystore.v1beta.DiscoveryEndpoint
	5,  // 8: google.cloud.memorystore.v1beta.Instance.node_type:type_name -> google.cloud.memorystore.v1beta.Instance.NodeType
	15, // 9: google.cloud.memorystore.v1beta.Instance.persistence_config:type_name -> google.cloud.memorystore.v1beta.PersistenceConfig
	31, // 10: google.cloud.memorystore.v1beta.Instance.engine_configs:type_name -> google.cloud.memorystore.v1beta.Instance.EngineConfigsEntry
	16, // 11: google.cloud.memorystore.v1beta.Instance.node_config:type_name -> google.cloud.memorystore.v1beta.NodeConfig
	17, // 12: google.cloud.memorystore.v1beta.Instance.zone_distribution_config:type_name -> google.cloud.memorystore.v1beta.ZoneDistributionConfig
	12, // 13: google.cloud.memorystore.v1beta.Instance.psc_auto_connections:type_name -> google.cloud.memorystore.v1beta.PscAutoConnection
	28, // 14: google.cloud.memorystore.v1beta.Instance.endpoints:type_name -> google.cloud.memorystore.v1beta.Instance.InstanceEndpoint
	6,  // 15: google.cloud.memorystore.v1beta.Instance.mode:type_name -> google.cloud.memorystore.v1beta.Instance.Mode
	0,  // 16: google.cloud.memorystore.v1beta.PscAutoConnection.psc_connection_status:type_name -> google.cloud.memorystore.v1beta.PscConnectionStatus
	1,  // 17: google.cloud.memorystore.v1beta.PscAutoConnection.connection_type:type_name -> google.cloud.memorystore.v1beta.ConnectionType
	0,  // 18: google.cloud.memorystore.v1beta.PscConnection.psc_connection_status:type_name -> google.cloud.memorystore.v1beta.PscConnectionStatus
	1,  // 19: google.cloud.memorystore.v1beta.PscConnection.connection_type:type_name -> google.cloud.memorystore.v1beta.ConnectionType
	7,  // 20: google.cloud.memorystore.v1beta.PersistenceConfig.mode:type_name -> google.cloud.memorystore.v1beta.PersistenceConfig.PersistenceMode
	33, // 21: google.cloud.memorystore.v1beta.PersistenceConfig.rdb_config:type_name -> google.cloud.memorystore.v1beta.PersistenceConfig.RDBConfig
	34, // 22: google.cloud.memorystore.v1beta.PersistenceConfig.aof_config:type_name -> google.cloud.memorystore.v1beta.PersistenceConfig.AOFConfig
	10, // 23: google.cloud.memorystore.v1beta.ZoneDistributionConfig.mode:type_name -> google.cloud.memorystore.v1beta.ZoneDistributionConfig.ZoneDistributionMode
	11, // 24: google.cloud.memorystore.v1beta.ListInstancesResponse.instances:type_name -> google.cloud.memorystore.v1beta.Instance
	11, // 25: google.cloud.memorystore.v1beta.CreateInstanceRequest.instance:type_name -> google.cloud.memorystore.v1beta.Instance
	38, // 26: google.cloud.memorystore.v1beta.UpdateInstanceRequest.update_mask:type_name -> google.protobuf.FieldMask
	11, // 27: google.cloud.memorystore.v1beta.UpdateInstanceRequest.instance:type_name -> google.cloud.memorystore.v1beta.Instance
	35, // 28: google.cloud.memorystore.v1beta.CertificateAuthority.managed_server_ca:type_name -> google.cloud.memorystore.v1beta.CertificateAuthority.ManagedCertificateAuthority
	37, // 29: google.cloud.memorystore.v1beta.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	37, // 30: google.cloud.memorystore.v1beta.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	32, // 31: google.cloud.memorystore.v1beta.Instance.StateInfo.update_info:type_name -> google.cloud.memorystore.v1beta.Instance.StateInfo.UpdateInfo
	29, // 32: google.cloud.memorystore.v1beta.Instance.InstanceEndpoint.connections:type_name -> google.cloud.memorystore.v1beta.Instance.ConnectionDetail
	12, // 33: google.cloud.memorystore.v1beta.Instance.ConnectionDetail.psc_auto_connection:type_name -> google.cloud.memorystore.v1beta.PscAutoConnection
	13, // 34: google.cloud.memorystore.v1beta.Instance.ConnectionDetail.psc_connection:type_name -> google.cloud.memorystore.v1beta.PscConnection
	8,  // 35: google.cloud.memorystore.v1beta.PersistenceConfig.RDBConfig.rdb_snapshot_period:type_name -> google.cloud.memorystore.v1beta.PersistenceConfig.RDBConfig.SnapshotPeriod
	37, // 36: google.cloud.memorystore.v1beta.PersistenceConfig.RDBConfig.rdb_snapshot_start_time:type_name -> google.protobuf.Timestamp
	9,  // 37: google.cloud.memorystore.v1beta.PersistenceConfig.AOFConfig.append_fsync:type_name -> google.cloud.memorystore.v1beta.PersistenceConfig.AOFConfig.AppendFsync
	36, // 38: google.cloud.memorystore.v1beta.CertificateAuthority.ManagedCertificateAuthority.ca_certs:type_name -> google.cloud.memorystore.v1beta.CertificateAuthority.ManagedCertificateAuthority.CertChain
	18, // 39: google.cloud.memorystore.v1beta.Memorystore.ListInstances:input_type -> google.cloud.memorystore.v1beta.ListInstancesRequest
	20, // 40: google.cloud.memorystore.v1beta.Memorystore.GetInstance:input_type -> google.cloud.memorystore.v1beta.GetInstanceRequest
	21, // 41: google.cloud.memorystore.v1beta.Memorystore.CreateInstance:input_type -> google.cloud.memorystore.v1beta.CreateInstanceRequest
	22, // 42: google.cloud.memorystore.v1beta.Memorystore.UpdateInstance:input_type -> google.cloud.memorystore.v1beta.UpdateInstanceRequest
	23, // 43: google.cloud.memorystore.v1beta.Memorystore.DeleteInstance:input_type -> google.cloud.memorystore.v1beta.DeleteInstanceRequest
	24, // 44: google.cloud.memorystore.v1beta.Memorystore.GetCertificateAuthority:input_type -> google.cloud.memorystore.v1beta.GetCertificateAuthorityRequest
	19, // 45: google.cloud.memorystore.v1beta.Memorystore.ListInstances:output_type -> google.cloud.memorystore.v1beta.ListInstancesResponse
	11, // 46: google.cloud.memorystore.v1beta.Memorystore.GetInstance:output_type -> google.cloud.memorystore.v1beta.Instance
	39, // 47: google.cloud.memorystore.v1beta.Memorystore.CreateInstance:output_type -> google.longrunning.Operation
	39, // 48: google.cloud.memorystore.v1beta.Memorystore.UpdateInstance:output_type -> google.longrunning.Operation
	39, // 49: google.cloud.memorystore.v1beta.Memorystore.DeleteInstance:output_type -> google.longrunning.Operation
	25, // 50: google.cloud.memorystore.v1beta.Memorystore.GetCertificateAuthority:output_type -> google.cloud.memorystore.v1beta.CertificateAuthority
	45, // [45:51] is the sub-list for method output_type
	39, // [39:45] is the sub-list for method input_type
	39, // [39:39] is the sub-list for extension type_name
	39, // [39:39] is the sub-list for extension extendee
	0,  // [0:39] is the sub-list for field type_name
}

func init() { file_google_cloud_memorystore_v1beta_memorystore_proto_init() }
func file_google_cloud_memorystore_v1beta_memorystore_proto_init() {
	if File_google_cloud_memorystore_v1beta_memorystore_proto != nil {
		return
	}
	file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[1].OneofWrappers = []any{
		(*PscAutoConnection_Port)(nil),
	}
	file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[14].OneofWrappers = []any{
		(*CertificateAuthority_ManagedServerCa)(nil),
	}
	file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[16].OneofWrappers = []any{
		(*Instance_StateInfo_UpdateInfo_)(nil),
	}
	file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[18].OneofWrappers = []any{
		(*Instance_ConnectionDetail_PscAutoConnection)(nil),
		(*Instance_ConnectionDetail_PscConnection)(nil),
	}
	file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes[21].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_memorystore_v1beta_memorystore_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_memorystore_v1beta_memorystore_proto_goTypes,
		DependencyIndexes: file_google_cloud_memorystore_v1beta_memorystore_proto_depIdxs,
		EnumInfos:         file_google_cloud_memorystore_v1beta_memorystore_proto_enumTypes,
		MessageInfos:      file_google_cloud_memorystore_v1beta_memorystore_proto_msgTypes,
	}.Build()
	File_google_cloud_memorystore_v1beta_memorystore_proto = out.File
	file_google_cloud_memorystore_v1beta_memorystore_proto_rawDesc = nil
	file_google_cloud_memorystore_v1beta_memorystore_proto_goTypes = nil
	file_google_cloud_memorystore_v1beta_memorystore_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// MemorystoreClient is the client API for Memorystore service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MemorystoreClient interface {
	// Lists Instances in a given project and location.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets details of a single Instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates a new Instance in a given project and location.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Instance.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Instance.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details about the certificate authority for an Instance.
	GetCertificateAuthority(ctx context.Context, in *GetCertificateAuthorityRequest, opts ...grpc.CallOption) (*CertificateAuthority, error)
}

type memorystoreClient struct {
	cc grpc.ClientConnInterface
}

func NewMemorystoreClient(cc grpc.ClientConnInterface) MemorystoreClient {
	return &memorystoreClient{cc}
}

func (c *memorystoreClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.memorystore.v1beta.Memorystore/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *memorystoreClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.cloud.memorystore.v1beta.Memorystore/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *memorystoreClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.memorystore.v1beta.Memorystore/CreateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *memorystoreClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.memorystore.v1beta.Memorystore/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *memorystoreClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.memorystore.v1beta.Memorystore/DeleteInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *memorystoreClient) GetCertificateAuthority(ctx context.Context, in *GetCertificateAuthorityRequest, opts ...grpc.CallOption) (*CertificateAuthority, error) {
	out := new(CertificateAuthority)
	err := c.cc.Invoke(ctx, "/google.cloud.memorystore.v1beta.Memorystore/GetCertificateAuthority", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MemorystoreServer is the server API for Memorystore service.
type MemorystoreServer interface {
	// Lists Instances in a given project and location.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets details of a single Instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates a new Instance in a given project and location.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Instance.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error)
	// Deletes a single Instance.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error)
	// Gets details about the certificate authority for an Instance.
	GetCertificateAuthority(context.Context, *GetCertificateAuthorityRequest) (*CertificateAuthority, error)
}

// UnimplementedMemorystoreServer can be embedded to have forward compatible implementations.
type UnimplementedMemorystoreServer struct {
}

func (*UnimplementedMemorystoreServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (*UnimplementedMemorystoreServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (*UnimplementedMemorystoreServer) CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (*UnimplementedMemorystoreServer) UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (*UnimplementedMemorystoreServer) DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (*UnimplementedMemorystoreServer) GetCertificateAuthority(context.Context, *GetCertificateAuthorityRequest) (*CertificateAuthority, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCertificateAuthority not implemented")
}

func RegisterMemorystoreServer(s *grpc.Server, srv MemorystoreServer) {
	s.RegisterService(&_Memorystore_serviceDesc, srv)
}

func _Memorystore_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemorystoreServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memorystore.v1beta.Memorystore/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemorystoreServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Memorystore_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemorystoreServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memorystore.v1beta.Memorystore/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemorystoreServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Memorystore_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemorystoreServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memorystore.v1beta.Memorystore/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemorystoreServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Memorystore_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemorystoreServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memorystore.v1beta.Memorystore/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemorystoreServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Memorystore_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemorystoreServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memorystore.v1beta.Memorystore/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemorystoreServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Memorystore_GetCertificateAuthority_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCertificateAuthorityRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MemorystoreServer).GetCertificateAuthority(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.memorystore.v1beta.Memorystore/GetCertificateAuthority",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MemorystoreServer).GetCertificateAuthority(ctx, req.(*GetCertificateAuthorityRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Memorystore_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.memorystore.v1beta.Memorystore",
	HandlerType: (*MemorystoreServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _Memorystore_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _Memorystore_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _Memorystore_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _Memorystore_UpdateInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _Memorystore_DeleteInstance_Handler,
		},
		{
			MethodName: "GetCertificateAuthority",
			Handler:    _Memorystore_GetCertificateAuthority_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/memorystore/v1beta/memorystore.proto",
}
