// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/financialservices/v1/backtest_result.proto

package financialservicespb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The possible states of a resource.
type BacktestResult_State int32

const (
	// State is unspecified, should not occur.
	BacktestResult_STATE_UNSPECIFIED BacktestResult_State = 0
	// The resource has not finished being created.
	BacktestResult_CREATING BacktestResult_State = 1
	// The resource is active/ready to be used.
	BacktestResult_ACTIVE BacktestResult_State = 2
	// The resource is in the process of being updated.
	BacktestResult_UPDATING BacktestResult_State = 3
	// The resource is in the process of being deleted.
	BacktestResult_DELETING BacktestResult_State = 4
)

// Enum value maps for BacktestResult_State.
var (
	BacktestResult_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
	}
	BacktestResult_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"UPDATING":          3,
		"DELETING":          4,
	}
)

func (x BacktestResult_State) Enum() *BacktestResult_State {
	p := new(BacktestResult_State)
	*p = x
	return p
}

func (x BacktestResult_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BacktestResult_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_financialservices_v1_backtest_result_proto_enumTypes[0].Descriptor()
}

func (BacktestResult_State) Type() protoreflect.EnumType {
	return &file_google_cloud_financialservices_v1_backtest_result_proto_enumTypes[0]
}

func (x BacktestResult_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BacktestResult_State.Descriptor instead.
func (BacktestResult_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_backtest_result_proto_rawDescGZIP(), []int{0, 0}
}

// BacktestResult is created to test the performance of a model on a dataset.
type BacktestResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the BacktestResult.
	// format:
	// "/projects/{project_num}/locations/{location}/instances/{instance}/backtestResults/{backtest_result}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp of creation of this resource.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp of the most recent update of this resource.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Labels
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. State of the BacktestResult (creating, active, deleting, etc.)
	State BacktestResult_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.financialservices.v1.BacktestResult_State" json:"state,omitempty"`
	// Required. The resource name of the Dataset to backtest on
	// Format:
	// "/projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}"
	Dataset string `protobuf:"bytes,6,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The resource name of the Model to use or to backtest.
	// Format:
	// "/projects/{project_num}/locations/{location}/instances/{instance}/models/{model}"
	Model string `protobuf:"bytes,7,opt,name=model,proto3" json:"model,omitempty"`
	// Required. End_time specifies the latest time from which labels are used and
	// from which data is used to generate features for backtesting.  End_time
	// should be no later than the end of the date_range of the primary dataset.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The number of consecutive months to conduct backtesting for, ending with
	// the last full month prior to the end_time according to the dataset's
	// timezone.
	BacktestPeriods int32 `protobuf:"varint,10,opt,name=backtest_periods,json=backtestPeriods,proto3" json:"backtest_periods,omitempty"`
	// Required. PerformanceTarget gives information on how the test will be
	// evaluated.
	PerformanceTarget *BacktestResult_PerformanceTarget `protobuf:"bytes,11,opt,name=performance_target,json=performanceTarget,proto3" json:"performance_target,omitempty"`
	// Output only. The line of business (Retail/Commercial) this backtest is for.
	// Determined by Model, cannot be set by user.
	LineOfBusiness LineOfBusiness `protobuf:"varint,12,opt,name=line_of_business,json=lineOfBusiness,proto3,enum=google.cloud.financialservices.v1.LineOfBusiness" json:"line_of_business,omitempty"`
}

func (x *BacktestResult) Reset() {
	*x = BacktestResult{}
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BacktestResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BacktestResult) ProtoMessage() {}

func (x *BacktestResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BacktestResult.ProtoReflect.Descriptor instead.
func (*BacktestResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_backtest_result_proto_rawDescGZIP(), []int{0}
}

func (x *BacktestResult) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BacktestResult) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BacktestResult) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BacktestResult) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *BacktestResult) GetState() BacktestResult_State {
	if x != nil {
		return x.State
	}
	return BacktestResult_STATE_UNSPECIFIED
}

func (x *BacktestResult) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *BacktestResult) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *BacktestResult) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *BacktestResult) GetBacktestPeriods() int32 {
	if x != nil {
		return x.BacktestPeriods
	}
	return 0
}

func (x *BacktestResult) GetPerformanceTarget() *BacktestResult_PerformanceTarget {
	if x != nil {
		return x.PerformanceTarget
	}
	return nil
}

func (x *BacktestResult) GetLineOfBusiness() LineOfBusiness {
	if x != nil {
		return x.LineOfBusiness
	}
	return LineOfBusiness_LINE_OF_BUSINESS_UNSPECIFIED
}

// Request for retrieving a paginated list of BacktestResult resources that
// meet the specified criteria.
type ListBacktestResultsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent of the BacktestResult is the Instance.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The number of resources to be included in the response. The response
	// contains a next_page_token, which can be used to retrieve the next page of
	// resources.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// In case of paginated results, this is the token that was returned in the
	// previous ListBacktestResultsResponse. It should be copied here to
	// retrieve the next page of resources. Empty will give the first page of
	// ListBacktestResultsRequest, and the last page will return an empty
	// page_token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Specify a filter to narrow search results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Specify a field to use for ordering.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListBacktestResultsRequest) Reset() {
	*x = ListBacktestResultsRequest{}
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBacktestResultsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBacktestResultsRequest) ProtoMessage() {}

func (x *ListBacktestResultsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBacktestResultsRequest.ProtoReflect.Descriptor instead.
func (*ListBacktestResultsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_backtest_result_proto_rawDescGZIP(), []int{1}
}

func (x *ListBacktestResultsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBacktestResultsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBacktestResultsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBacktestResultsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBacktestResultsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for retrieving a list of BacktestResults
type ListBacktestResultsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of BacktestResult resources
	BacktestResults []*BacktestResult `protobuf:"bytes,1,rep,name=backtest_results,json=backtestResults,proto3" json:"backtest_results,omitempty"`
	// This token should be passed to the next ListBacktestResultsRequest to
	// retrieve the next page of BacktestResults (empty indicates we are
	// done).
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBacktestResultsResponse) Reset() {
	*x = ListBacktestResultsResponse{}
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBacktestResultsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBacktestResultsResponse) ProtoMessage() {}

func (x *ListBacktestResultsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBacktestResultsResponse.ProtoReflect.Descriptor instead.
func (*ListBacktestResultsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_backtest_result_proto_rawDescGZIP(), []int{2}
}

func (x *ListBacktestResultsResponse) GetBacktestResults() []*BacktestResult {
	if x != nil {
		return x.BacktestResults
	}
	return nil
}

func (x *ListBacktestResultsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBacktestResultsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for retrieving a specific BacktestResult resource.
type GetBacktestResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the BacktestResult
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBacktestResultRequest) Reset() {
	*x = GetBacktestResultRequest{}
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBacktestResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBacktestResultRequest) ProtoMessage() {}

func (x *GetBacktestResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBacktestResultRequest.ProtoReflect.Descriptor instead.
func (*GetBacktestResultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_backtest_result_proto_rawDescGZIP(), []int{3}
}

func (x *GetBacktestResultRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for creating a BacktestResult resource.
type CreateBacktestResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent of the BacktestResult is the Instance.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The resource id of the BacktestResult
	BacktestResultId string `protobuf:"bytes,2,opt,name=backtest_result_id,json=backtestResultId,proto3" json:"backtest_result_id,omitempty"`
	// Required. The BacktestResult that will be created.
	BacktestResult *BacktestResult `protobuf:"bytes,3,opt,name=backtest_result,json=backtestResult,proto3" json:"backtest_result,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateBacktestResultRequest) Reset() {
	*x = CreateBacktestResultRequest{}
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateBacktestResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBacktestResultRequest) ProtoMessage() {}

func (x *CreateBacktestResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBacktestResultRequest.ProtoReflect.Descriptor instead.
func (*CreateBacktestResultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_backtest_result_proto_rawDescGZIP(), []int{4}
}

func (x *CreateBacktestResultRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBacktestResultRequest) GetBacktestResultId() string {
	if x != nil {
		return x.BacktestResultId
	}
	return ""
}

func (x *CreateBacktestResultRequest) GetBacktestResult() *BacktestResult {
	if x != nil {
		return x.BacktestResult
	}
	return nil
}

func (x *CreateBacktestResultRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for updating a BacktestResult
type UpdateBacktestResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// BacktestResult resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The new value of the BacktestResult fields that will be updated
	// according to the update_mask.
	BacktestResult *BacktestResult `protobuf:"bytes,2,opt,name=backtest_result,json=backtestResult,proto3" json:"backtest_result,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateBacktestResultRequest) Reset() {
	*x = UpdateBacktestResultRequest{}
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBacktestResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBacktestResultRequest) ProtoMessage() {}

func (x *UpdateBacktestResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBacktestResultRequest.ProtoReflect.Descriptor instead.
func (*UpdateBacktestResultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_backtest_result_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateBacktestResultRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateBacktestResultRequest) GetBacktestResult() *BacktestResult {
	if x != nil {
		return x.BacktestResult
	}
	return nil
}

func (x *UpdateBacktestResultRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for deleting a BacktestResult.
type DeleteBacktestResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the BacktestResult.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteBacktestResultRequest) Reset() {
	*x = DeleteBacktestResultRequest{}
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBacktestResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBacktestResultRequest) ProtoMessage() {}

func (x *DeleteBacktestResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBacktestResultRequest.ProtoReflect.Descriptor instead.
func (*DeleteBacktestResultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_backtest_result_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteBacktestResultRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteBacktestResultRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request for exporting BacktestResult metadata.
type ExportBacktestResultMetadataRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the BacktestResult.
	BacktestResult string `protobuf:"bytes,1,opt,name=backtest_result,json=backtestResult,proto3" json:"backtest_result,omitempty"`
	// Required. BigQuery output where the metadata will be written.
	StructuredMetadataDestination *BigQueryDestination `protobuf:"bytes,2,opt,name=structured_metadata_destination,json=structuredMetadataDestination,proto3" json:"structured_metadata_destination,omitempty"`
}

func (x *ExportBacktestResultMetadataRequest) Reset() {
	*x = ExportBacktestResultMetadataRequest{}
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportBacktestResultMetadataRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportBacktestResultMetadataRequest) ProtoMessage() {}

func (x *ExportBacktestResultMetadataRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportBacktestResultMetadataRequest.ProtoReflect.Descriptor instead.
func (*ExportBacktestResultMetadataRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_backtest_result_proto_rawDescGZIP(), []int{7}
}

func (x *ExportBacktestResultMetadataRequest) GetBacktestResult() string {
	if x != nil {
		return x.BacktestResult
	}
	return ""
}

func (x *ExportBacktestResultMetadataRequest) GetStructuredMetadataDestination() *BigQueryDestination {
	if x != nil {
		return x.StructuredMetadataDestination
	}
	return nil
}

// Response for exporting BacktestResult metadata.
type ExportBacktestResultMetadataResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExportBacktestResultMetadataResponse) Reset() {
	*x = ExportBacktestResultMetadataResponse{}
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportBacktestResultMetadataResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportBacktestResultMetadataResponse) ProtoMessage() {}

func (x *ExportBacktestResultMetadataResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportBacktestResultMetadataResponse.ProtoReflect.Descriptor instead.
func (*ExportBacktestResultMetadataResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_backtest_result_proto_rawDescGZIP(), []int{8}
}

// PerformanceTarget gives hints on how to evaluate the performance of a
// model.
type BacktestResult_PerformanceTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A number that gives the tuner a hint on the number of parties
	// from this data that will be investigated per period (monthly). This is
	// used to control how the model is evaluated. For example, when trying AML
	// AI for the first time, we recommend setting this to the number of parties
	// investigated in an average month, based on alerts from your existing
	// automated alerting system.
	PartyInvestigationsPerPeriodHint int64 `protobuf:"varint,1,opt,name=party_investigations_per_period_hint,json=partyInvestigationsPerPeriodHint,proto3" json:"party_investigations_per_period_hint,omitempty"`
}

func (x *BacktestResult_PerformanceTarget) Reset() {
	*x = BacktestResult_PerformanceTarget{}
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BacktestResult_PerformanceTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BacktestResult_PerformanceTarget) ProtoMessage() {}

func (x *BacktestResult_PerformanceTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BacktestResult_PerformanceTarget.ProtoReflect.Descriptor instead.
func (*BacktestResult_PerformanceTarget) Descriptor() ([]byte, []int) {
	return file_google_cloud_financialservices_v1_backtest_result_proto_rawDescGZIP(), []int{0, 0}
}

func (x *BacktestResult_PerformanceTarget) GetPartyInvestigationsPerPeriodHint() int64 {
	if x != nil {
		return x.PartyInvestigationsPerPeriodHint
	}
	return 0
}

var File_google_cloud_financialservices_v1_backtest_result_proto protoreflect.FileDescriptor

var file_google_cloud_financialservices_v1_backtest_result_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66,
	0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61,
	0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f,
	0x66, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xc3, 0x09, 0x0a, 0x0e, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x55, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x52, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69,
	0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4a,
	0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69,
	0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x44, 0x0a, 0x05, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x28, 0x0a, 0x26, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10,
	0x62, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x73,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74,
	0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x73, 0x12, 0x77, 0x0a, 0x12, 0x70, 0x65, 0x72, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e,
	0x63, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x70,
	0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x60, 0x0a, 0x10, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x62, 0x75, 0x73, 0x69,
	0x6e, 0x65, 0x73, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63,
	0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x6e, 0x65, 0x4f, 0x66, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0e, 0x6c, 0x69, 0x6e, 0x65, 0x4f, 0x66, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65,
	0x73, 0x73, 0x1a, 0x68, 0x0a, 0x11, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x53, 0x0a, 0x24, 0x70, 0x61, 0x72, 0x74, 0x79,
	0x5f, 0x69, 0x6e, 0x76, 0x65, 0x73, 0x74, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x20, 0x70, 0x61, 0x72, 0x74,
	0x79, 0x49, 0x6e, 0x76, 0x65, 0x73, 0x74, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x50,
	0x65, 0x72, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x48, 0x69, 0x6e, 0x74, 0x1a, 0x39, 0x0a, 0x0b,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10,
	0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x3a, 0x99, 0x01,
	0xea, 0x41, 0x95, 0x01, 0x0a, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x62, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x7d, 0x22, 0xd6, 0x01, 0x0a, 0x1a, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b,
	0x0a, 0x29, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0xc5, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x74,
	0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61,
	0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x0f, 0x62, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x67, 0x0a, 0x18, 0x47, 0x65,
	0x74, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x66, 0x69,
	0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa0, 0x02, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x66, 0x69, 0x6e,
	0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x31,
	0x0a, 0x12, 0x62, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x10, 0x62, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x49,
	0x64, 0x12, 0x5f, 0x0a, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63,
	0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xe4, 0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x5f, 0x0a, 0x0f, 0x62, 0x61, 0x63, 0x6b,
	0x74, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x74,
	0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x8e, 0x01,
	0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x8d,
	0x02, 0x0a, 0x23, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73,
	0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x74, 0x65,
	0x73, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69,
	0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x74, 0x65,
	0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x83, 0x01, 0x0a, 0x1f, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x1d, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x26,
	0x0a, 0x24, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x93, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6e, 0x61,
	0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x42, 0x13, 0x42, 0x61, 0x63, 0x6b, 0x74, 0x65, 0x73, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x53, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x66, 0x69, 0x6e,
	0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x2f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69,
	0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_financialservices_v1_backtest_result_proto_rawDescOnce sync.Once
	file_google_cloud_financialservices_v1_backtest_result_proto_rawDescData = file_google_cloud_financialservices_v1_backtest_result_proto_rawDesc
)

func file_google_cloud_financialservices_v1_backtest_result_proto_rawDescGZIP() []byte {
	file_google_cloud_financialservices_v1_backtest_result_proto_rawDescOnce.Do(func() {
		file_google_cloud_financialservices_v1_backtest_result_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_financialservices_v1_backtest_result_proto_rawDescData)
	})
	return file_google_cloud_financialservices_v1_backtest_result_proto_rawDescData
}

var file_google_cloud_financialservices_v1_backtest_result_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_financialservices_v1_backtest_result_proto_goTypes = []any{
	(BacktestResult_State)(0),                    // 0: google.cloud.financialservices.v1.BacktestResult.State
	(*BacktestResult)(nil),                       // 1: google.cloud.financialservices.v1.BacktestResult
	(*ListBacktestResultsRequest)(nil),           // 2: google.cloud.financialservices.v1.ListBacktestResultsRequest
	(*ListBacktestResultsResponse)(nil),          // 3: google.cloud.financialservices.v1.ListBacktestResultsResponse
	(*GetBacktestResultRequest)(nil),             // 4: google.cloud.financialservices.v1.GetBacktestResultRequest
	(*CreateBacktestResultRequest)(nil),          // 5: google.cloud.financialservices.v1.CreateBacktestResultRequest
	(*UpdateBacktestResultRequest)(nil),          // 6: google.cloud.financialservices.v1.UpdateBacktestResultRequest
	(*DeleteBacktestResultRequest)(nil),          // 7: google.cloud.financialservices.v1.DeleteBacktestResultRequest
	(*ExportBacktestResultMetadataRequest)(nil),  // 8: google.cloud.financialservices.v1.ExportBacktestResultMetadataRequest
	(*ExportBacktestResultMetadataResponse)(nil), // 9: google.cloud.financialservices.v1.ExportBacktestResultMetadataResponse
	(*BacktestResult_PerformanceTarget)(nil),     // 10: google.cloud.financialservices.v1.BacktestResult.PerformanceTarget
	nil,                                          // 11: google.cloud.financialservices.v1.BacktestResult.LabelsEntry
	(*timestamppb.Timestamp)(nil),                // 12: google.protobuf.Timestamp
	(LineOfBusiness)(0),                          // 13: google.cloud.financialservices.v1.LineOfBusiness
	(*fieldmaskpb.FieldMask)(nil),                // 14: google.protobuf.FieldMask
	(*BigQueryDestination)(nil),                  // 15: google.cloud.financialservices.v1.BigQueryDestination
}
var file_google_cloud_financialservices_v1_backtest_result_proto_depIdxs = []int32{
	12, // 0: google.cloud.financialservices.v1.BacktestResult.create_time:type_name -> google.protobuf.Timestamp
	12, // 1: google.cloud.financialservices.v1.BacktestResult.update_time:type_name -> google.protobuf.Timestamp
	11, // 2: google.cloud.financialservices.v1.BacktestResult.labels:type_name -> google.cloud.financialservices.v1.BacktestResult.LabelsEntry
	0,  // 3: google.cloud.financialservices.v1.BacktestResult.state:type_name -> google.cloud.financialservices.v1.BacktestResult.State
	12, // 4: google.cloud.financialservices.v1.BacktestResult.end_time:type_name -> google.protobuf.Timestamp
	10, // 5: google.cloud.financialservices.v1.BacktestResult.performance_target:type_name -> google.cloud.financialservices.v1.BacktestResult.PerformanceTarget
	13, // 6: google.cloud.financialservices.v1.BacktestResult.line_of_business:type_name -> google.cloud.financialservices.v1.LineOfBusiness
	1,  // 7: google.cloud.financialservices.v1.ListBacktestResultsResponse.backtest_results:type_name -> google.cloud.financialservices.v1.BacktestResult
	1,  // 8: google.cloud.financialservices.v1.CreateBacktestResultRequest.backtest_result:type_name -> google.cloud.financialservices.v1.BacktestResult
	14, // 9: google.cloud.financialservices.v1.UpdateBacktestResultRequest.update_mask:type_name -> google.protobuf.FieldMask
	1,  // 10: google.cloud.financialservices.v1.UpdateBacktestResultRequest.backtest_result:type_name -> google.cloud.financialservices.v1.BacktestResult
	15, // 11: google.cloud.financialservices.v1.ExportBacktestResultMetadataRequest.structured_metadata_destination:type_name -> google.cloud.financialservices.v1.BigQueryDestination
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_financialservices_v1_backtest_result_proto_init() }
func file_google_cloud_financialservices_v1_backtest_result_proto_init() {
	if File_google_cloud_financialservices_v1_backtest_result_proto != nil {
		return
	}
	file_google_cloud_financialservices_v1_bigquery_destination_proto_init()
	file_google_cloud_financialservices_v1_line_of_business_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_financialservices_v1_backtest_result_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_financialservices_v1_backtest_result_proto_goTypes,
		DependencyIndexes: file_google_cloud_financialservices_v1_backtest_result_proto_depIdxs,
		EnumInfos:         file_google_cloud_financialservices_v1_backtest_result_proto_enumTypes,
		MessageInfos:      file_google_cloud_financialservices_v1_backtest_result_proto_msgTypes,
	}.Build()
	File_google_cloud_financialservices_v1_backtest_result_proto = out.File
	file_google_cloud_financialservices_v1_backtest_result_proto_rawDesc = nil
	file_google_cloud_financialservices_v1_backtest_result_proto_goTypes = nil
	file_google_cloud_financialservices_v1_backtest_result_proto_depIdxs = nil
}
