// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package financialservices

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	financialservicespb "cloud.google.com/go/financialservices/apiv1/financialservicespb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newAMLClientHook clientHook

// AMLCallOptions contains the retry settings for each method of AMLClient.
type AMLCallOptions struct {
	ListInstances                  []gax.CallOption
	GetInstance                    []gax.CallOption
	CreateInstance                 []gax.CallOption
	UpdateInstance                 []gax.CallOption
	DeleteInstance                 []gax.CallOption
	ImportRegisteredParties        []gax.CallOption
	ExportRegisteredParties        []gax.CallOption
	ListDatasets                   []gax.CallOption
	GetDataset                     []gax.CallOption
	CreateDataset                  []gax.CallOption
	UpdateDataset                  []gax.CallOption
	DeleteDataset                  []gax.CallOption
	ListModels                     []gax.CallOption
	GetModel                       []gax.CallOption
	CreateModel                    []gax.CallOption
	UpdateModel                    []gax.CallOption
	ExportModelMetadata            []gax.CallOption
	DeleteModel                    []gax.CallOption
	ListEngineConfigs              []gax.CallOption
	GetEngineConfig                []gax.CallOption
	CreateEngineConfig             []gax.CallOption
	UpdateEngineConfig             []gax.CallOption
	ExportEngineConfigMetadata     []gax.CallOption
	DeleteEngineConfig             []gax.CallOption
	GetEngineVersion               []gax.CallOption
	ListEngineVersions             []gax.CallOption
	ListPredictionResults          []gax.CallOption
	GetPredictionResult            []gax.CallOption
	CreatePredictionResult         []gax.CallOption
	UpdatePredictionResult         []gax.CallOption
	ExportPredictionResultMetadata []gax.CallOption
	DeletePredictionResult         []gax.CallOption
	ListBacktestResults            []gax.CallOption
	GetBacktestResult              []gax.CallOption
	CreateBacktestResult           []gax.CallOption
	UpdateBacktestResult           []gax.CallOption
	ExportBacktestResultMetadata   []gax.CallOption
	DeleteBacktestResult           []gax.CallOption
	GetLocation                    []gax.CallOption
	ListLocations                  []gax.CallOption
	CancelOperation                []gax.CallOption
	DeleteOperation                []gax.CallOption
	GetOperation                   []gax.CallOption
	ListOperations                 []gax.CallOption
}

func defaultAMLGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("financialservices.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("financialservices.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("financialservices.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://financialservices.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultAMLCallOptions() *AMLCallOptions {
	return &AMLCallOptions{
		ListInstances: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		GetInstance: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		CreateInstance: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		UpdateInstance: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		DeleteInstance: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ImportRegisteredParties: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ExportRegisteredParties: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ListDatasets: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		GetDataset: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		CreateDataset: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		UpdateDataset: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		DeleteDataset: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ListModels: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		GetModel: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		CreateModel: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		UpdateModel: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ExportModelMetadata: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		DeleteModel: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ListEngineConfigs: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		GetEngineConfig: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		CreateEngineConfig: []gax.CallOption{},
		UpdateEngineConfig: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ExportEngineConfigMetadata: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		DeleteEngineConfig: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		GetEngineVersion: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		ListEngineVersions: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		ListPredictionResults: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		GetPredictionResult: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		CreatePredictionResult: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		UpdatePredictionResult: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ExportPredictionResultMetadata: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		DeletePredictionResult: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ListBacktestResults: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		GetBacktestResult: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		CreateBacktestResult: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		UpdateBacktestResult: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ExportBacktestResultMetadata: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		DeleteBacktestResult: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		GetLocation:     []gax.CallOption{},
		ListLocations:   []gax.CallOption{},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

func defaultAMLRESTCallOptions() *AMLCallOptions {
	return &AMLCallOptions{
		ListInstances: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		GetInstance: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		CreateInstance: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		UpdateInstance: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		DeleteInstance: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ImportRegisteredParties: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ExportRegisteredParties: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ListDatasets: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		GetDataset: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		CreateDataset: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		UpdateDataset: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		DeleteDataset: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ListModels: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		GetModel: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		CreateModel: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		UpdateModel: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ExportModelMetadata: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		DeleteModel: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ListEngineConfigs: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		GetEngineConfig: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		CreateEngineConfig: []gax.CallOption{},
		UpdateEngineConfig: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ExportEngineConfigMetadata: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		DeleteEngineConfig: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		GetEngineVersion: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		ListEngineVersions: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		ListPredictionResults: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		GetPredictionResult: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		CreatePredictionResult: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		UpdatePredictionResult: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ExportPredictionResultMetadata: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		DeletePredictionResult: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ListBacktestResults: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		GetBacktestResult: []gax.CallOption{
			gax.WithTimeout(10000 * time.Millisecond),
		},
		CreateBacktestResult: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		UpdateBacktestResult: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		ExportBacktestResultMetadata: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		DeleteBacktestResult: []gax.CallOption{
			gax.WithTimeout(120000 * time.Millisecond),
		},
		GetLocation:     []gax.CallOption{},
		ListLocations:   []gax.CallOption{},
		CancelOperation: []gax.CallOption{},
		DeleteOperation: []gax.CallOption{},
		GetOperation:    []gax.CallOption{},
		ListOperations:  []gax.CallOption{},
	}
}

// internalAMLClient is an interface that defines the methods available from Financial Services API.
type internalAMLClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListInstances(context.Context, *financialservicespb.ListInstancesRequest, ...gax.CallOption) *InstanceIterator
	GetInstance(context.Context, *financialservicespb.GetInstanceRequest, ...gax.CallOption) (*financialservicespb.Instance, error)
	CreateInstance(context.Context, *financialservicespb.CreateInstanceRequest, ...gax.CallOption) (*CreateInstanceOperation, error)
	CreateInstanceOperation(name string) *CreateInstanceOperation
	UpdateInstance(context.Context, *financialservicespb.UpdateInstanceRequest, ...gax.CallOption) (*UpdateInstanceOperation, error)
	UpdateInstanceOperation(name string) *UpdateInstanceOperation
	DeleteInstance(context.Context, *financialservicespb.DeleteInstanceRequest, ...gax.CallOption) (*DeleteInstanceOperation, error)
	DeleteInstanceOperation(name string) *DeleteInstanceOperation
	ImportRegisteredParties(context.Context, *financialservicespb.ImportRegisteredPartiesRequest, ...gax.CallOption) (*ImportRegisteredPartiesOperation, error)
	ImportRegisteredPartiesOperation(name string) *ImportRegisteredPartiesOperation
	ExportRegisteredParties(context.Context, *financialservicespb.ExportRegisteredPartiesRequest, ...gax.CallOption) (*ExportRegisteredPartiesOperation, error)
	ExportRegisteredPartiesOperation(name string) *ExportRegisteredPartiesOperation
	ListDatasets(context.Context, *financialservicespb.ListDatasetsRequest, ...gax.CallOption) *DatasetIterator
	GetDataset(context.Context, *financialservicespb.GetDatasetRequest, ...gax.CallOption) (*financialservicespb.Dataset, error)
	CreateDataset(context.Context, *financialservicespb.CreateDatasetRequest, ...gax.CallOption) (*CreateDatasetOperation, error)
	CreateDatasetOperation(name string) *CreateDatasetOperation
	UpdateDataset(context.Context, *financialservicespb.UpdateDatasetRequest, ...gax.CallOption) (*UpdateDatasetOperation, error)
	UpdateDatasetOperation(name string) *UpdateDatasetOperation
	DeleteDataset(context.Context, *financialservicespb.DeleteDatasetRequest, ...gax.CallOption) (*DeleteDatasetOperation, error)
	DeleteDatasetOperation(name string) *DeleteDatasetOperation
	ListModels(context.Context, *financialservicespb.ListModelsRequest, ...gax.CallOption) *ModelIterator
	GetModel(context.Context, *financialservicespb.GetModelRequest, ...gax.CallOption) (*financialservicespb.Model, error)
	CreateModel(context.Context, *financialservicespb.CreateModelRequest, ...gax.CallOption) (*CreateModelOperation, error)
	CreateModelOperation(name string) *CreateModelOperation
	UpdateModel(context.Context, *financialservicespb.UpdateModelRequest, ...gax.CallOption) (*UpdateModelOperation, error)
	UpdateModelOperation(name string) *UpdateModelOperation
	ExportModelMetadata(context.Context, *financialservicespb.ExportModelMetadataRequest, ...gax.CallOption) (*ExportModelMetadataOperation, error)
	ExportModelMetadataOperation(name string) *ExportModelMetadataOperation
	DeleteModel(context.Context, *financialservicespb.DeleteModelRequest, ...gax.CallOption) (*DeleteModelOperation, error)
	DeleteModelOperation(name string) *DeleteModelOperation
	ListEngineConfigs(context.Context, *financialservicespb.ListEngineConfigsRequest, ...gax.CallOption) *EngineConfigIterator
	GetEngineConfig(context.Context, *financialservicespb.GetEngineConfigRequest, ...gax.CallOption) (*financialservicespb.EngineConfig, error)
	CreateEngineConfig(context.Context, *financialservicespb.CreateEngineConfigRequest, ...gax.CallOption) (*CreateEngineConfigOperation, error)
	CreateEngineConfigOperation(name string) *CreateEngineConfigOperation
	UpdateEngineConfig(context.Context, *financialservicespb.UpdateEngineConfigRequest, ...gax.CallOption) (*UpdateEngineConfigOperation, error)
	UpdateEngineConfigOperation(name string) *UpdateEngineConfigOperation
	ExportEngineConfigMetadata(context.Context, *financialservicespb.ExportEngineConfigMetadataRequest, ...gax.CallOption) (*ExportEngineConfigMetadataOperation, error)
	ExportEngineConfigMetadataOperation(name string) *ExportEngineConfigMetadataOperation
	DeleteEngineConfig(context.Context, *financialservicespb.DeleteEngineConfigRequest, ...gax.CallOption) (*DeleteEngineConfigOperation, error)
	DeleteEngineConfigOperation(name string) *DeleteEngineConfigOperation
	GetEngineVersion(context.Context, *financialservicespb.GetEngineVersionRequest, ...gax.CallOption) (*financialservicespb.EngineVersion, error)
	ListEngineVersions(context.Context, *financialservicespb.ListEngineVersionsRequest, ...gax.CallOption) *EngineVersionIterator
	ListPredictionResults(context.Context, *financialservicespb.ListPredictionResultsRequest, ...gax.CallOption) *PredictionResultIterator
	GetPredictionResult(context.Context, *financialservicespb.GetPredictionResultRequest, ...gax.CallOption) (*financialservicespb.PredictionResult, error)
	CreatePredictionResult(context.Context, *financialservicespb.CreatePredictionResultRequest, ...gax.CallOption) (*CreatePredictionResultOperation, error)
	CreatePredictionResultOperation(name string) *CreatePredictionResultOperation
	UpdatePredictionResult(context.Context, *financialservicespb.UpdatePredictionResultRequest, ...gax.CallOption) (*UpdatePredictionResultOperation, error)
	UpdatePredictionResultOperation(name string) *UpdatePredictionResultOperation
	ExportPredictionResultMetadata(context.Context, *financialservicespb.ExportPredictionResultMetadataRequest, ...gax.CallOption) (*ExportPredictionResultMetadataOperation, error)
	ExportPredictionResultMetadataOperation(name string) *ExportPredictionResultMetadataOperation
	DeletePredictionResult(context.Context, *financialservicespb.DeletePredictionResultRequest, ...gax.CallOption) (*DeletePredictionResultOperation, error)
	DeletePredictionResultOperation(name string) *DeletePredictionResultOperation
	ListBacktestResults(context.Context, *financialservicespb.ListBacktestResultsRequest, ...gax.CallOption) *BacktestResultIterator
	GetBacktestResult(context.Context, *financialservicespb.GetBacktestResultRequest, ...gax.CallOption) (*financialservicespb.BacktestResult, error)
	CreateBacktestResult(context.Context, *financialservicespb.CreateBacktestResultRequest, ...gax.CallOption) (*CreateBacktestResultOperation, error)
	CreateBacktestResultOperation(name string) *CreateBacktestResultOperation
	UpdateBacktestResult(context.Context, *financialservicespb.UpdateBacktestResultRequest, ...gax.CallOption) (*UpdateBacktestResultOperation, error)
	UpdateBacktestResultOperation(name string) *UpdateBacktestResultOperation
	ExportBacktestResultMetadata(context.Context, *financialservicespb.ExportBacktestResultMetadataRequest, ...gax.CallOption) (*ExportBacktestResultMetadataOperation, error)
	ExportBacktestResultMetadataOperation(name string) *ExportBacktestResultMetadataOperation
	DeleteBacktestResult(context.Context, *financialservicespb.DeleteBacktestResultRequest, ...gax.CallOption) (*DeleteBacktestResultOperation, error)
	DeleteBacktestResultOperation(name string) *DeleteBacktestResultOperation
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// AMLClient is a client for interacting with Financial Services API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The AML (Anti Money Laundering) service allows users to perform REST
// operations on aml.
type AMLClient struct {
	// The internal transport-dependent client.
	internalClient internalAMLClient

	// The call options for this service.
	CallOptions *AMLCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *AMLClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *AMLClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *AMLClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListInstances lists instances.
func (c *AMLClient) ListInstances(ctx context.Context, req *financialservicespb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	return c.internalClient.ListInstances(ctx, req, opts...)
}

// GetInstance gets an instance.
func (c *AMLClient) GetInstance(ctx context.Context, req *financialservicespb.GetInstanceRequest, opts ...gax.CallOption) (*financialservicespb.Instance, error) {
	return c.internalClient.GetInstance(ctx, req, opts...)
}

// CreateInstance creates an instance.
func (c *AMLClient) CreateInstance(ctx context.Context, req *financialservicespb.CreateInstanceRequest, opts ...gax.CallOption) (*CreateInstanceOperation, error) {
	return c.internalClient.CreateInstance(ctx, req, opts...)
}

// CreateInstanceOperation returns a new CreateInstanceOperation from a given name.
// The name must be that of a previously created CreateInstanceOperation, possibly from a different process.
func (c *AMLClient) CreateInstanceOperation(name string) *CreateInstanceOperation {
	return c.internalClient.CreateInstanceOperation(name)
}

// UpdateInstance updates the parameters of a single Instance.
func (c *AMLClient) UpdateInstance(ctx context.Context, req *financialservicespb.UpdateInstanceRequest, opts ...gax.CallOption) (*UpdateInstanceOperation, error) {
	return c.internalClient.UpdateInstance(ctx, req, opts...)
}

// UpdateInstanceOperation returns a new UpdateInstanceOperation from a given name.
// The name must be that of a previously created UpdateInstanceOperation, possibly from a different process.
func (c *AMLClient) UpdateInstanceOperation(name string) *UpdateInstanceOperation {
	return c.internalClient.UpdateInstanceOperation(name)
}

// DeleteInstance deletes an instance.
func (c *AMLClient) DeleteInstance(ctx context.Context, req *financialservicespb.DeleteInstanceRequest, opts ...gax.CallOption) (*DeleteInstanceOperation, error) {
	return c.internalClient.DeleteInstance(ctx, req, opts...)
}

// DeleteInstanceOperation returns a new DeleteInstanceOperation from a given name.
// The name must be that of a previously created DeleteInstanceOperation, possibly from a different process.
func (c *AMLClient) DeleteInstanceOperation(name string) *DeleteInstanceOperation {
	return c.internalClient.DeleteInstanceOperation(name)
}

// ImportRegisteredParties imports the list of registered parties. See
// Create and manage
// instances (at https://cloud.google.com/financial-services/anti-money-laundering/docs/create-and-manage-instances#import-registered-parties)
// for information on the input schema and response for this method.
func (c *AMLClient) ImportRegisteredParties(ctx context.Context, req *financialservicespb.ImportRegisteredPartiesRequest, opts ...gax.CallOption) (*ImportRegisteredPartiesOperation, error) {
	return c.internalClient.ImportRegisteredParties(ctx, req, opts...)
}

// ImportRegisteredPartiesOperation returns a new ImportRegisteredPartiesOperation from a given name.
// The name must be that of a previously created ImportRegisteredPartiesOperation, possibly from a different process.
func (c *AMLClient) ImportRegisteredPartiesOperation(name string) *ImportRegisteredPartiesOperation {
	return c.internalClient.ImportRegisteredPartiesOperation(name)
}

// ExportRegisteredParties exports the list of registered parties. See
// Create and manage
// instances (at https://cloud.google.com/financial-services/anti-money-laundering/docs/create-and-manage-instances#export-registered-parties)
// for information on the output schema for this method.
func (c *AMLClient) ExportRegisteredParties(ctx context.Context, req *financialservicespb.ExportRegisteredPartiesRequest, opts ...gax.CallOption) (*ExportRegisteredPartiesOperation, error) {
	return c.internalClient.ExportRegisteredParties(ctx, req, opts...)
}

// ExportRegisteredPartiesOperation returns a new ExportRegisteredPartiesOperation from a given name.
// The name must be that of a previously created ExportRegisteredPartiesOperation, possibly from a different process.
func (c *AMLClient) ExportRegisteredPartiesOperation(name string) *ExportRegisteredPartiesOperation {
	return c.internalClient.ExportRegisteredPartiesOperation(name)
}

// ListDatasets lists datasets.
func (c *AMLClient) ListDatasets(ctx context.Context, req *financialservicespb.ListDatasetsRequest, opts ...gax.CallOption) *DatasetIterator {
	return c.internalClient.ListDatasets(ctx, req, opts...)
}

// GetDataset gets a dataset.
func (c *AMLClient) GetDataset(ctx context.Context, req *financialservicespb.GetDatasetRequest, opts ...gax.CallOption) (*financialservicespb.Dataset, error) {
	return c.internalClient.GetDataset(ctx, req, opts...)
}

// CreateDataset creates a dataset.
func (c *AMLClient) CreateDataset(ctx context.Context, req *financialservicespb.CreateDatasetRequest, opts ...gax.CallOption) (*CreateDatasetOperation, error) {
	return c.internalClient.CreateDataset(ctx, req, opts...)
}

// CreateDatasetOperation returns a new CreateDatasetOperation from a given name.
// The name must be that of a previously created CreateDatasetOperation, possibly from a different process.
func (c *AMLClient) CreateDatasetOperation(name string) *CreateDatasetOperation {
	return c.internalClient.CreateDatasetOperation(name)
}

// UpdateDataset updates the parameters of a single Dataset.
func (c *AMLClient) UpdateDataset(ctx context.Context, req *financialservicespb.UpdateDatasetRequest, opts ...gax.CallOption) (*UpdateDatasetOperation, error) {
	return c.internalClient.UpdateDataset(ctx, req, opts...)
}

// UpdateDatasetOperation returns a new UpdateDatasetOperation from a given name.
// The name must be that of a previously created UpdateDatasetOperation, possibly from a different process.
func (c *AMLClient) UpdateDatasetOperation(name string) *UpdateDatasetOperation {
	return c.internalClient.UpdateDatasetOperation(name)
}

// DeleteDataset deletes a dataset.
func (c *AMLClient) DeleteDataset(ctx context.Context, req *financialservicespb.DeleteDatasetRequest, opts ...gax.CallOption) (*DeleteDatasetOperation, error) {
	return c.internalClient.DeleteDataset(ctx, req, opts...)
}

// DeleteDatasetOperation returns a new DeleteDatasetOperation from a given name.
// The name must be that of a previously created DeleteDatasetOperation, possibly from a different process.
func (c *AMLClient) DeleteDatasetOperation(name string) *DeleteDatasetOperation {
	return c.internalClient.DeleteDatasetOperation(name)
}

// ListModels lists models.
func (c *AMLClient) ListModels(ctx context.Context, req *financialservicespb.ListModelsRequest, opts ...gax.CallOption) *ModelIterator {
	return c.internalClient.ListModels(ctx, req, opts...)
}

// GetModel gets a model.
func (c *AMLClient) GetModel(ctx context.Context, req *financialservicespb.GetModelRequest, opts ...gax.CallOption) (*financialservicespb.Model, error) {
	return c.internalClient.GetModel(ctx, req, opts...)
}

// CreateModel creates a model.
func (c *AMLClient) CreateModel(ctx context.Context, req *financialservicespb.CreateModelRequest, opts ...gax.CallOption) (*CreateModelOperation, error) {
	return c.internalClient.CreateModel(ctx, req, opts...)
}

// CreateModelOperation returns a new CreateModelOperation from a given name.
// The name must be that of a previously created CreateModelOperation, possibly from a different process.
func (c *AMLClient) CreateModelOperation(name string) *CreateModelOperation {
	return c.internalClient.CreateModelOperation(name)
}

// UpdateModel updates the parameters of a single Model.
func (c *AMLClient) UpdateModel(ctx context.Context, req *financialservicespb.UpdateModelRequest, opts ...gax.CallOption) (*UpdateModelOperation, error) {
	return c.internalClient.UpdateModel(ctx, req, opts...)
}

// UpdateModelOperation returns a new UpdateModelOperation from a given name.
// The name must be that of a previously created UpdateModelOperation, possibly from a different process.
func (c *AMLClient) UpdateModelOperation(name string) *UpdateModelOperation {
	return c.internalClient.UpdateModelOperation(name)
}

// ExportModelMetadata export governance information for a Model resource. For
// information on the exported fields, see
// AML output data
// model (at https://cloud.google.com/financial-services/anti-money-laundering/docs/reference/schemas/aml-output-data-model#model).
func (c *AMLClient) ExportModelMetadata(ctx context.Context, req *financialservicespb.ExportModelMetadataRequest, opts ...gax.CallOption) (*ExportModelMetadataOperation, error) {
	return c.internalClient.ExportModelMetadata(ctx, req, opts...)
}

// ExportModelMetadataOperation returns a new ExportModelMetadataOperation from a given name.
// The name must be that of a previously created ExportModelMetadataOperation, possibly from a different process.
func (c *AMLClient) ExportModelMetadataOperation(name string) *ExportModelMetadataOperation {
	return c.internalClient.ExportModelMetadataOperation(name)
}

// DeleteModel deletes a model.
func (c *AMLClient) DeleteModel(ctx context.Context, req *financialservicespb.DeleteModelRequest, opts ...gax.CallOption) (*DeleteModelOperation, error) {
	return c.internalClient.DeleteModel(ctx, req, opts...)
}

// DeleteModelOperation returns a new DeleteModelOperation from a given name.
// The name must be that of a previously created DeleteModelOperation, possibly from a different process.
func (c *AMLClient) DeleteModelOperation(name string) *DeleteModelOperation {
	return c.internalClient.DeleteModelOperation(name)
}

// ListEngineConfigs lists engine configs.
func (c *AMLClient) ListEngineConfigs(ctx context.Context, req *financialservicespb.ListEngineConfigsRequest, opts ...gax.CallOption) *EngineConfigIterator {
	return c.internalClient.ListEngineConfigs(ctx, req, opts...)
}

// GetEngineConfig gets an engine config.
func (c *AMLClient) GetEngineConfig(ctx context.Context, req *financialservicespb.GetEngineConfigRequest, opts ...gax.CallOption) (*financialservicespb.EngineConfig, error) {
	return c.internalClient.GetEngineConfig(ctx, req, opts...)
}

// CreateEngineConfig creates an engine config.
func (c *AMLClient) CreateEngineConfig(ctx context.Context, req *financialservicespb.CreateEngineConfigRequest, opts ...gax.CallOption) (*CreateEngineConfigOperation, error) {
	return c.internalClient.CreateEngineConfig(ctx, req, opts...)
}

// CreateEngineConfigOperation returns a new CreateEngineConfigOperation from a given name.
// The name must be that of a previously created CreateEngineConfigOperation, possibly from a different process.
func (c *AMLClient) CreateEngineConfigOperation(name string) *CreateEngineConfigOperation {
	return c.internalClient.CreateEngineConfigOperation(name)
}

// UpdateEngineConfig updates the parameters of a single EngineConfig.
func (c *AMLClient) UpdateEngineConfig(ctx context.Context, req *financialservicespb.UpdateEngineConfigRequest, opts ...gax.CallOption) (*UpdateEngineConfigOperation, error) {
	return c.internalClient.UpdateEngineConfig(ctx, req, opts...)
}

// UpdateEngineConfigOperation returns a new UpdateEngineConfigOperation from a given name.
// The name must be that of a previously created UpdateEngineConfigOperation, possibly from a different process.
func (c *AMLClient) UpdateEngineConfigOperation(name string) *UpdateEngineConfigOperation {
	return c.internalClient.UpdateEngineConfigOperation(name)
}

// ExportEngineConfigMetadata export governance information for an EngineConfig resource. For
// information on the exported fields, see
// AML output data
// model (at https://cloud.google.com/financial-services/anti-money-laundering/docs/reference/schemas/aml-output-data-model#engine-config).
func (c *AMLClient) ExportEngineConfigMetadata(ctx context.Context, req *financialservicespb.ExportEngineConfigMetadataRequest, opts ...gax.CallOption) (*ExportEngineConfigMetadataOperation, error) {
	return c.internalClient.ExportEngineConfigMetadata(ctx, req, opts...)
}

// ExportEngineConfigMetadataOperation returns a new ExportEngineConfigMetadataOperation from a given name.
// The name must be that of a previously created ExportEngineConfigMetadataOperation, possibly from a different process.
func (c *AMLClient) ExportEngineConfigMetadataOperation(name string) *ExportEngineConfigMetadataOperation {
	return c.internalClient.ExportEngineConfigMetadataOperation(name)
}

// DeleteEngineConfig deletes an engine config.
func (c *AMLClient) DeleteEngineConfig(ctx context.Context, req *financialservicespb.DeleteEngineConfigRequest, opts ...gax.CallOption) (*DeleteEngineConfigOperation, error) {
	return c.internalClient.DeleteEngineConfig(ctx, req, opts...)
}

// DeleteEngineConfigOperation returns a new DeleteEngineConfigOperation from a given name.
// The name must be that of a previously created DeleteEngineConfigOperation, possibly from a different process.
func (c *AMLClient) DeleteEngineConfigOperation(name string) *DeleteEngineConfigOperation {
	return c.internalClient.DeleteEngineConfigOperation(name)
}

// GetEngineVersion gets a single EngineVersion.
func (c *AMLClient) GetEngineVersion(ctx context.Context, req *financialservicespb.GetEngineVersionRequest, opts ...gax.CallOption) (*financialservicespb.EngineVersion, error) {
	return c.internalClient.GetEngineVersion(ctx, req, opts...)
}

// ListEngineVersions lists EngineVersions for given location.
func (c *AMLClient) ListEngineVersions(ctx context.Context, req *financialservicespb.ListEngineVersionsRequest, opts ...gax.CallOption) *EngineVersionIterator {
	return c.internalClient.ListEngineVersions(ctx, req, opts...)
}

// ListPredictionResults list PredictionResults.
func (c *AMLClient) ListPredictionResults(ctx context.Context, req *financialservicespb.ListPredictionResultsRequest, opts ...gax.CallOption) *PredictionResultIterator {
	return c.internalClient.ListPredictionResults(ctx, req, opts...)
}

// GetPredictionResult gets a PredictionResult.
func (c *AMLClient) GetPredictionResult(ctx context.Context, req *financialservicespb.GetPredictionResultRequest, opts ...gax.CallOption) (*financialservicespb.PredictionResult, error) {
	return c.internalClient.GetPredictionResult(ctx, req, opts...)
}

// CreatePredictionResult create a PredictionResult.
func (c *AMLClient) CreatePredictionResult(ctx context.Context, req *financialservicespb.CreatePredictionResultRequest, opts ...gax.CallOption) (*CreatePredictionResultOperation, error) {
	return c.internalClient.CreatePredictionResult(ctx, req, opts...)
}

// CreatePredictionResultOperation returns a new CreatePredictionResultOperation from a given name.
// The name must be that of a previously created CreatePredictionResultOperation, possibly from a different process.
func (c *AMLClient) CreatePredictionResultOperation(name string) *CreatePredictionResultOperation {
	return c.internalClient.CreatePredictionResultOperation(name)
}

// UpdatePredictionResult updates the parameters of a single PredictionResult.
func (c *AMLClient) UpdatePredictionResult(ctx context.Context, req *financialservicespb.UpdatePredictionResultRequest, opts ...gax.CallOption) (*UpdatePredictionResultOperation, error) {
	return c.internalClient.UpdatePredictionResult(ctx, req, opts...)
}

// UpdatePredictionResultOperation returns a new UpdatePredictionResultOperation from a given name.
// The name must be that of a previously created UpdatePredictionResultOperation, possibly from a different process.
func (c *AMLClient) UpdatePredictionResultOperation(name string) *UpdatePredictionResultOperation {
	return c.internalClient.UpdatePredictionResultOperation(name)
}

// ExportPredictionResultMetadata export governance information for a PredictionResult resource. For
// information on the exported fields, see
// AML output data
// model (at https://cloud.google.com/financial-services/anti-money-laundering/docs/reference/schemas/aml-output-data-model#prediction-results).
func (c *AMLClient) ExportPredictionResultMetadata(ctx context.Context, req *financialservicespb.ExportPredictionResultMetadataRequest, opts ...gax.CallOption) (*ExportPredictionResultMetadataOperation, error) {
	return c.internalClient.ExportPredictionResultMetadata(ctx, req, opts...)
}

// ExportPredictionResultMetadataOperation returns a new ExportPredictionResultMetadataOperation from a given name.
// The name must be that of a previously created ExportPredictionResultMetadataOperation, possibly from a different process.
func (c *AMLClient) ExportPredictionResultMetadataOperation(name string) *ExportPredictionResultMetadataOperation {
	return c.internalClient.ExportPredictionResultMetadataOperation(name)
}

// DeletePredictionResult deletes a PredictionResult.
func (c *AMLClient) DeletePredictionResult(ctx context.Context, req *financialservicespb.DeletePredictionResultRequest, opts ...gax.CallOption) (*DeletePredictionResultOperation, error) {
	return c.internalClient.DeletePredictionResult(ctx, req, opts...)
}

// DeletePredictionResultOperation returns a new DeletePredictionResultOperation from a given name.
// The name must be that of a previously created DeletePredictionResultOperation, possibly from a different process.
func (c *AMLClient) DeletePredictionResultOperation(name string) *DeletePredictionResultOperation {
	return c.internalClient.DeletePredictionResultOperation(name)
}

// ListBacktestResults list BacktestResults.
func (c *AMLClient) ListBacktestResults(ctx context.Context, req *financialservicespb.ListBacktestResultsRequest, opts ...gax.CallOption) *BacktestResultIterator {
	return c.internalClient.ListBacktestResults(ctx, req, opts...)
}

// GetBacktestResult gets a BacktestResult.
func (c *AMLClient) GetBacktestResult(ctx context.Context, req *financialservicespb.GetBacktestResultRequest, opts ...gax.CallOption) (*financialservicespb.BacktestResult, error) {
	return c.internalClient.GetBacktestResult(ctx, req, opts...)
}

// CreateBacktestResult create a BacktestResult.
func (c *AMLClient) CreateBacktestResult(ctx context.Context, req *financialservicespb.CreateBacktestResultRequest, opts ...gax.CallOption) (*CreateBacktestResultOperation, error) {
	return c.internalClient.CreateBacktestResult(ctx, req, opts...)
}

// CreateBacktestResultOperation returns a new CreateBacktestResultOperation from a given name.
// The name must be that of a previously created CreateBacktestResultOperation, possibly from a different process.
func (c *AMLClient) CreateBacktestResultOperation(name string) *CreateBacktestResultOperation {
	return c.internalClient.CreateBacktestResultOperation(name)
}

// UpdateBacktestResult updates the parameters of a single BacktestResult.
func (c *AMLClient) UpdateBacktestResult(ctx context.Context, req *financialservicespb.UpdateBacktestResultRequest, opts ...gax.CallOption) (*UpdateBacktestResultOperation, error) {
	return c.internalClient.UpdateBacktestResult(ctx, req, opts...)
}

// UpdateBacktestResultOperation returns a new UpdateBacktestResultOperation from a given name.
// The name must be that of a previously created UpdateBacktestResultOperation, possibly from a different process.
func (c *AMLClient) UpdateBacktestResultOperation(name string) *UpdateBacktestResultOperation {
	return c.internalClient.UpdateBacktestResultOperation(name)
}

// ExportBacktestResultMetadata export governance information for a BacktestResult resource. For
// information on the exported fields, see
// AML output data
// model (at https://cloud.google.com/financial-services/anti-money-laundering/docs/reference/schemas/aml-output-data-model#backtest-results).
func (c *AMLClient) ExportBacktestResultMetadata(ctx context.Context, req *financialservicespb.ExportBacktestResultMetadataRequest, opts ...gax.CallOption) (*ExportBacktestResultMetadataOperation, error) {
	return c.internalClient.ExportBacktestResultMetadata(ctx, req, opts...)
}

// ExportBacktestResultMetadataOperation returns a new ExportBacktestResultMetadataOperation from a given name.
// The name must be that of a previously created ExportBacktestResultMetadataOperation, possibly from a different process.
func (c *AMLClient) ExportBacktestResultMetadataOperation(name string) *ExportBacktestResultMetadataOperation {
	return c.internalClient.ExportBacktestResultMetadataOperation(name)
}

// DeleteBacktestResult deletes a BacktestResult.
func (c *AMLClient) DeleteBacktestResult(ctx context.Context, req *financialservicespb.DeleteBacktestResultRequest, opts ...gax.CallOption) (*DeleteBacktestResultOperation, error) {
	return c.internalClient.DeleteBacktestResult(ctx, req, opts...)
}

// DeleteBacktestResultOperation returns a new DeleteBacktestResultOperation from a given name.
// The name must be that of a previously created DeleteBacktestResultOperation, possibly from a different process.
func (c *AMLClient) DeleteBacktestResultOperation(name string) *DeleteBacktestResultOperation {
	return c.internalClient.DeleteBacktestResultOperation(name)
}

// GetLocation gets information about a location.
func (c *AMLClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *AMLClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *AMLClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *AMLClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *AMLClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *AMLClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// aMLGRPCClient is a client for interacting with Financial Services API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type aMLGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing AMLClient
	CallOptions **AMLCallOptions

	// The gRPC API client.
	aMLClient financialservicespb.AMLClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewAMLClient creates a new aml client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The AML (Anti Money Laundering) service allows users to perform REST
// operations on aml.
func NewAMLClient(ctx context.Context, opts ...option.ClientOption) (*AMLClient, error) {
	clientOpts := defaultAMLGRPCClientOptions()
	if newAMLClientHook != nil {
		hookOpts, err := newAMLClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := AMLClient{CallOptions: defaultAMLCallOptions()}

	c := &aMLGRPCClient{
		connPool:         connPool,
		aMLClient:        financialservicespb.NewAMLClient(connPool),
		CallOptions:      &client.CallOptions,
		logger:           internaloption.GetLogger(opts),
		operationsClient: longrunningpb.NewOperationsClient(connPool),
		locationsClient:  locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *aMLGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *aMLGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *aMLGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type aMLRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing AMLClient
	CallOptions **AMLCallOptions

	logger *slog.Logger
}

// NewAMLRESTClient creates a new aml rest client.
//
// The AML (Anti Money Laundering) service allows users to perform REST
// operations on aml.
func NewAMLRESTClient(ctx context.Context, opts ...option.ClientOption) (*AMLClient, error) {
	clientOpts := append(defaultAMLRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultAMLRESTCallOptions()
	c := &aMLRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &AMLClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultAMLRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://financialservices.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://financialservices.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://financialservices.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://financialservices.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *aMLRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *aMLRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *aMLRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *aMLGRPCClient) ListInstances(ctx context.Context, req *financialservicespb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListInstances[0:len((*c.CallOptions).ListInstances):len((*c.CallOptions).ListInstances)], opts...)
	it := &InstanceIterator{}
	req = proto.Clone(req).(*financialservicespb.ListInstancesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.Instance, string, error) {
		resp := &financialservicespb.ListInstancesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.aMLClient.ListInstances, req, settings.GRPC, c.logger, "ListInstances")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetInstances(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *aMLGRPCClient) GetInstance(ctx context.Context, req *financialservicespb.GetInstanceRequest, opts ...gax.CallOption) (*financialservicespb.Instance, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetInstance[0:len((*c.CallOptions).GetInstance):len((*c.CallOptions).GetInstance)], opts...)
	var resp *financialservicespb.Instance
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.GetInstance, req, settings.GRPC, c.logger, "GetInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *aMLGRPCClient) CreateInstance(ctx context.Context, req *financialservicespb.CreateInstanceRequest, opts ...gax.CallOption) (*CreateInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateInstance[0:len((*c.CallOptions).CreateInstance):len((*c.CallOptions).CreateInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.CreateInstance, req, settings.GRPC, c.logger, "CreateInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) UpdateInstance(ctx context.Context, req *financialservicespb.UpdateInstanceRequest, opts ...gax.CallOption) (*UpdateInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "instance.name", url.QueryEscape(req.GetInstance().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateInstance[0:len((*c.CallOptions).UpdateInstance):len((*c.CallOptions).UpdateInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.UpdateInstance, req, settings.GRPC, c.logger, "UpdateInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) DeleteInstance(ctx context.Context, req *financialservicespb.DeleteInstanceRequest, opts ...gax.CallOption) (*DeleteInstanceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteInstance[0:len((*c.CallOptions).DeleteInstance):len((*c.CallOptions).DeleteInstance)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.DeleteInstance, req, settings.GRPC, c.logger, "DeleteInstance")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) ImportRegisteredParties(ctx context.Context, req *financialservicespb.ImportRegisteredPartiesRequest, opts ...gax.CallOption) (*ImportRegisteredPartiesOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ImportRegisteredParties[0:len((*c.CallOptions).ImportRegisteredParties):len((*c.CallOptions).ImportRegisteredParties)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.ImportRegisteredParties, req, settings.GRPC, c.logger, "ImportRegisteredParties")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ImportRegisteredPartiesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) ExportRegisteredParties(ctx context.Context, req *financialservicespb.ExportRegisteredPartiesRequest, opts ...gax.CallOption) (*ExportRegisteredPartiesOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ExportRegisteredParties[0:len((*c.CallOptions).ExportRegisteredParties):len((*c.CallOptions).ExportRegisteredParties)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.ExportRegisteredParties, req, settings.GRPC, c.logger, "ExportRegisteredParties")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ExportRegisteredPartiesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) ListDatasets(ctx context.Context, req *financialservicespb.ListDatasetsRequest, opts ...gax.CallOption) *DatasetIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListDatasets[0:len((*c.CallOptions).ListDatasets):len((*c.CallOptions).ListDatasets)], opts...)
	it := &DatasetIterator{}
	req = proto.Clone(req).(*financialservicespb.ListDatasetsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.Dataset, string, error) {
		resp := &financialservicespb.ListDatasetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.aMLClient.ListDatasets, req, settings.GRPC, c.logger, "ListDatasets")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDatasets(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *aMLGRPCClient) GetDataset(ctx context.Context, req *financialservicespb.GetDatasetRequest, opts ...gax.CallOption) (*financialservicespb.Dataset, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetDataset[0:len((*c.CallOptions).GetDataset):len((*c.CallOptions).GetDataset)], opts...)
	var resp *financialservicespb.Dataset
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.GetDataset, req, settings.GRPC, c.logger, "GetDataset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *aMLGRPCClient) CreateDataset(ctx context.Context, req *financialservicespb.CreateDatasetRequest, opts ...gax.CallOption) (*CreateDatasetOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateDataset[0:len((*c.CallOptions).CreateDataset):len((*c.CallOptions).CreateDataset)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.CreateDataset, req, settings.GRPC, c.logger, "CreateDataset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateDatasetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) UpdateDataset(ctx context.Context, req *financialservicespb.UpdateDatasetRequest, opts ...gax.CallOption) (*UpdateDatasetOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "dataset.name", url.QueryEscape(req.GetDataset().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateDataset[0:len((*c.CallOptions).UpdateDataset):len((*c.CallOptions).UpdateDataset)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.UpdateDataset, req, settings.GRPC, c.logger, "UpdateDataset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateDatasetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) DeleteDataset(ctx context.Context, req *financialservicespb.DeleteDatasetRequest, opts ...gax.CallOption) (*DeleteDatasetOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteDataset[0:len((*c.CallOptions).DeleteDataset):len((*c.CallOptions).DeleteDataset)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.DeleteDataset, req, settings.GRPC, c.logger, "DeleteDataset")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteDatasetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) ListModels(ctx context.Context, req *financialservicespb.ListModelsRequest, opts ...gax.CallOption) *ModelIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListModels[0:len((*c.CallOptions).ListModels):len((*c.CallOptions).ListModels)], opts...)
	it := &ModelIterator{}
	req = proto.Clone(req).(*financialservicespb.ListModelsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.Model, string, error) {
		resp := &financialservicespb.ListModelsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.aMLClient.ListModels, req, settings.GRPC, c.logger, "ListModels")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetModels(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *aMLGRPCClient) GetModel(ctx context.Context, req *financialservicespb.GetModelRequest, opts ...gax.CallOption) (*financialservicespb.Model, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetModel[0:len((*c.CallOptions).GetModel):len((*c.CallOptions).GetModel)], opts...)
	var resp *financialservicespb.Model
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.GetModel, req, settings.GRPC, c.logger, "GetModel")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *aMLGRPCClient) CreateModel(ctx context.Context, req *financialservicespb.CreateModelRequest, opts ...gax.CallOption) (*CreateModelOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateModel[0:len((*c.CallOptions).CreateModel):len((*c.CallOptions).CreateModel)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.CreateModel, req, settings.GRPC, c.logger, "CreateModel")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateModelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) UpdateModel(ctx context.Context, req *financialservicespb.UpdateModelRequest, opts ...gax.CallOption) (*UpdateModelOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "model.name", url.QueryEscape(req.GetModel().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateModel[0:len((*c.CallOptions).UpdateModel):len((*c.CallOptions).UpdateModel)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.UpdateModel, req, settings.GRPC, c.logger, "UpdateModel")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateModelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) ExportModelMetadata(ctx context.Context, req *financialservicespb.ExportModelMetadataRequest, opts ...gax.CallOption) (*ExportModelMetadataOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "model", url.QueryEscape(req.GetModel()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ExportModelMetadata[0:len((*c.CallOptions).ExportModelMetadata):len((*c.CallOptions).ExportModelMetadata)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.ExportModelMetadata, req, settings.GRPC, c.logger, "ExportModelMetadata")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ExportModelMetadataOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) DeleteModel(ctx context.Context, req *financialservicespb.DeleteModelRequest, opts ...gax.CallOption) (*DeleteModelOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteModel[0:len((*c.CallOptions).DeleteModel):len((*c.CallOptions).DeleteModel)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.DeleteModel, req, settings.GRPC, c.logger, "DeleteModel")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteModelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) ListEngineConfigs(ctx context.Context, req *financialservicespb.ListEngineConfigsRequest, opts ...gax.CallOption) *EngineConfigIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListEngineConfigs[0:len((*c.CallOptions).ListEngineConfigs):len((*c.CallOptions).ListEngineConfigs)], opts...)
	it := &EngineConfigIterator{}
	req = proto.Clone(req).(*financialservicespb.ListEngineConfigsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.EngineConfig, string, error) {
		resp := &financialservicespb.ListEngineConfigsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.aMLClient.ListEngineConfigs, req, settings.GRPC, c.logger, "ListEngineConfigs")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEngineConfigs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *aMLGRPCClient) GetEngineConfig(ctx context.Context, req *financialservicespb.GetEngineConfigRequest, opts ...gax.CallOption) (*financialservicespb.EngineConfig, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetEngineConfig[0:len((*c.CallOptions).GetEngineConfig):len((*c.CallOptions).GetEngineConfig)], opts...)
	var resp *financialservicespb.EngineConfig
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.GetEngineConfig, req, settings.GRPC, c.logger, "GetEngineConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *aMLGRPCClient) CreateEngineConfig(ctx context.Context, req *financialservicespb.CreateEngineConfigRequest, opts ...gax.CallOption) (*CreateEngineConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateEngineConfig[0:len((*c.CallOptions).CreateEngineConfig):len((*c.CallOptions).CreateEngineConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.CreateEngineConfig, req, settings.GRPC, c.logger, "CreateEngineConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateEngineConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) UpdateEngineConfig(ctx context.Context, req *financialservicespb.UpdateEngineConfigRequest, opts ...gax.CallOption) (*UpdateEngineConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "engine_config.name", url.QueryEscape(req.GetEngineConfig().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateEngineConfig[0:len((*c.CallOptions).UpdateEngineConfig):len((*c.CallOptions).UpdateEngineConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.UpdateEngineConfig, req, settings.GRPC, c.logger, "UpdateEngineConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateEngineConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) ExportEngineConfigMetadata(ctx context.Context, req *financialservicespb.ExportEngineConfigMetadataRequest, opts ...gax.CallOption) (*ExportEngineConfigMetadataOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "engine_config", url.QueryEscape(req.GetEngineConfig()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ExportEngineConfigMetadata[0:len((*c.CallOptions).ExportEngineConfigMetadata):len((*c.CallOptions).ExportEngineConfigMetadata)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.ExportEngineConfigMetadata, req, settings.GRPC, c.logger, "ExportEngineConfigMetadata")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ExportEngineConfigMetadataOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) DeleteEngineConfig(ctx context.Context, req *financialservicespb.DeleteEngineConfigRequest, opts ...gax.CallOption) (*DeleteEngineConfigOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteEngineConfig[0:len((*c.CallOptions).DeleteEngineConfig):len((*c.CallOptions).DeleteEngineConfig)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.DeleteEngineConfig, req, settings.GRPC, c.logger, "DeleteEngineConfig")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteEngineConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) GetEngineVersion(ctx context.Context, req *financialservicespb.GetEngineVersionRequest, opts ...gax.CallOption) (*financialservicespb.EngineVersion, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetEngineVersion[0:len((*c.CallOptions).GetEngineVersion):len((*c.CallOptions).GetEngineVersion)], opts...)
	var resp *financialservicespb.EngineVersion
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.GetEngineVersion, req, settings.GRPC, c.logger, "GetEngineVersion")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *aMLGRPCClient) ListEngineVersions(ctx context.Context, req *financialservicespb.ListEngineVersionsRequest, opts ...gax.CallOption) *EngineVersionIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListEngineVersions[0:len((*c.CallOptions).ListEngineVersions):len((*c.CallOptions).ListEngineVersions)], opts...)
	it := &EngineVersionIterator{}
	req = proto.Clone(req).(*financialservicespb.ListEngineVersionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.EngineVersion, string, error) {
		resp := &financialservicespb.ListEngineVersionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.aMLClient.ListEngineVersions, req, settings.GRPC, c.logger, "ListEngineVersions")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEngineVersions(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *aMLGRPCClient) ListPredictionResults(ctx context.Context, req *financialservicespb.ListPredictionResultsRequest, opts ...gax.CallOption) *PredictionResultIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListPredictionResults[0:len((*c.CallOptions).ListPredictionResults):len((*c.CallOptions).ListPredictionResults)], opts...)
	it := &PredictionResultIterator{}
	req = proto.Clone(req).(*financialservicespb.ListPredictionResultsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.PredictionResult, string, error) {
		resp := &financialservicespb.ListPredictionResultsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.aMLClient.ListPredictionResults, req, settings.GRPC, c.logger, "ListPredictionResults")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetPredictionResults(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *aMLGRPCClient) GetPredictionResult(ctx context.Context, req *financialservicespb.GetPredictionResultRequest, opts ...gax.CallOption) (*financialservicespb.PredictionResult, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetPredictionResult[0:len((*c.CallOptions).GetPredictionResult):len((*c.CallOptions).GetPredictionResult)], opts...)
	var resp *financialservicespb.PredictionResult
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.GetPredictionResult, req, settings.GRPC, c.logger, "GetPredictionResult")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *aMLGRPCClient) CreatePredictionResult(ctx context.Context, req *financialservicespb.CreatePredictionResultRequest, opts ...gax.CallOption) (*CreatePredictionResultOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreatePredictionResult[0:len((*c.CallOptions).CreatePredictionResult):len((*c.CallOptions).CreatePredictionResult)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.CreatePredictionResult, req, settings.GRPC, c.logger, "CreatePredictionResult")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreatePredictionResultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) UpdatePredictionResult(ctx context.Context, req *financialservicespb.UpdatePredictionResultRequest, opts ...gax.CallOption) (*UpdatePredictionResultOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "prediction_result.name", url.QueryEscape(req.GetPredictionResult().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdatePredictionResult[0:len((*c.CallOptions).UpdatePredictionResult):len((*c.CallOptions).UpdatePredictionResult)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.UpdatePredictionResult, req, settings.GRPC, c.logger, "UpdatePredictionResult")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdatePredictionResultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) ExportPredictionResultMetadata(ctx context.Context, req *financialservicespb.ExportPredictionResultMetadataRequest, opts ...gax.CallOption) (*ExportPredictionResultMetadataOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "prediction_result", url.QueryEscape(req.GetPredictionResult()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ExportPredictionResultMetadata[0:len((*c.CallOptions).ExportPredictionResultMetadata):len((*c.CallOptions).ExportPredictionResultMetadata)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.ExportPredictionResultMetadata, req, settings.GRPC, c.logger, "ExportPredictionResultMetadata")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ExportPredictionResultMetadataOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) DeletePredictionResult(ctx context.Context, req *financialservicespb.DeletePredictionResultRequest, opts ...gax.CallOption) (*DeletePredictionResultOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeletePredictionResult[0:len((*c.CallOptions).DeletePredictionResult):len((*c.CallOptions).DeletePredictionResult)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.DeletePredictionResult, req, settings.GRPC, c.logger, "DeletePredictionResult")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeletePredictionResultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) ListBacktestResults(ctx context.Context, req *financialservicespb.ListBacktestResultsRequest, opts ...gax.CallOption) *BacktestResultIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListBacktestResults[0:len((*c.CallOptions).ListBacktestResults):len((*c.CallOptions).ListBacktestResults)], opts...)
	it := &BacktestResultIterator{}
	req = proto.Clone(req).(*financialservicespb.ListBacktestResultsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.BacktestResult, string, error) {
		resp := &financialservicespb.ListBacktestResultsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.aMLClient.ListBacktestResults, req, settings.GRPC, c.logger, "ListBacktestResults")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetBacktestResults(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *aMLGRPCClient) GetBacktestResult(ctx context.Context, req *financialservicespb.GetBacktestResultRequest, opts ...gax.CallOption) (*financialservicespb.BacktestResult, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetBacktestResult[0:len((*c.CallOptions).GetBacktestResult):len((*c.CallOptions).GetBacktestResult)], opts...)
	var resp *financialservicespb.BacktestResult
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.GetBacktestResult, req, settings.GRPC, c.logger, "GetBacktestResult")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *aMLGRPCClient) CreateBacktestResult(ctx context.Context, req *financialservicespb.CreateBacktestResultRequest, opts ...gax.CallOption) (*CreateBacktestResultOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateBacktestResult[0:len((*c.CallOptions).CreateBacktestResult):len((*c.CallOptions).CreateBacktestResult)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.CreateBacktestResult, req, settings.GRPC, c.logger, "CreateBacktestResult")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateBacktestResultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) UpdateBacktestResult(ctx context.Context, req *financialservicespb.UpdateBacktestResultRequest, opts ...gax.CallOption) (*UpdateBacktestResultOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "backtest_result.name", url.QueryEscape(req.GetBacktestResult().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateBacktestResult[0:len((*c.CallOptions).UpdateBacktestResult):len((*c.CallOptions).UpdateBacktestResult)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.UpdateBacktestResult, req, settings.GRPC, c.logger, "UpdateBacktestResult")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateBacktestResultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) ExportBacktestResultMetadata(ctx context.Context, req *financialservicespb.ExportBacktestResultMetadataRequest, opts ...gax.CallOption) (*ExportBacktestResultMetadataOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "backtest_result", url.QueryEscape(req.GetBacktestResult()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ExportBacktestResultMetadata[0:len((*c.CallOptions).ExportBacktestResultMetadata):len((*c.CallOptions).ExportBacktestResultMetadata)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.ExportBacktestResultMetadata, req, settings.GRPC, c.logger, "ExportBacktestResultMetadata")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ExportBacktestResultMetadataOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) DeleteBacktestResult(ctx context.Context, req *financialservicespb.DeleteBacktestResultRequest, opts ...gax.CallOption) (*DeleteBacktestResultOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteBacktestResult[0:len((*c.CallOptions).DeleteBacktestResult):len((*c.CallOptions).DeleteBacktestResult)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.aMLClient.DeleteBacktestResult, req, settings.GRPC, c.logger, "DeleteBacktestResult")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteBacktestResultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *aMLGRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *aMLGRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *aMLGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *aMLGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *aMLGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *aMLGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListInstances lists instances.
func (c *aMLRESTClient) ListInstances(ctx context.Context, req *financialservicespb.ListInstancesRequest, opts ...gax.CallOption) *InstanceIterator {
	it := &InstanceIterator{}
	req = proto.Clone(req).(*financialservicespb.ListInstancesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.Instance, string, error) {
		resp := &financialservicespb.ListInstancesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/instances", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListInstances")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetInstances(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetInstance gets an instance.
func (c *aMLRESTClient) GetInstance(ctx context.Context, req *financialservicespb.GetInstanceRequest, opts ...gax.CallOption) (*financialservicespb.Instance, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetInstance[0:len((*c.CallOptions).GetInstance):len((*c.CallOptions).GetInstance)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &financialservicespb.Instance{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetInstance")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateInstance creates an instance.
func (c *aMLRESTClient) CreateInstance(ctx context.Context, req *financialservicespb.CreateInstanceRequest, opts ...gax.CallOption) (*CreateInstanceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetInstance()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/instances", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("instanceId", fmt.Sprintf("%v", req.GetInstanceId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateInstance")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateInstance updates the parameters of a single Instance.
func (c *aMLRESTClient) UpdateInstance(ctx context.Context, req *financialservicespb.UpdateInstanceRequest, opts ...gax.CallOption) (*UpdateInstanceOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetInstance()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetInstance().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "instance.name", url.QueryEscape(req.GetInstance().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateInstance")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteInstance deletes an instance.
func (c *aMLRESTClient) DeleteInstance(ctx context.Context, req *financialservicespb.DeleteInstanceRequest, opts ...gax.CallOption) (*DeleteInstanceOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteInstance")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ImportRegisteredParties imports the list of registered parties. See
// Create and manage
// instances (at https://cloud.google.com/financial-services/anti-money-laundering/docs/create-and-manage-instances#import-registered-parties)
// for information on the input schema and response for this method.
func (c *aMLRESTClient) ImportRegisteredParties(ctx context.Context, req *financialservicespb.ImportRegisteredPartiesRequest, opts ...gax.CallOption) (*ImportRegisteredPartiesOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:importRegisteredParties", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ImportRegisteredParties")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ImportRegisteredPartiesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ExportRegisteredParties exports the list of registered parties. See
// Create and manage
// instances (at https://cloud.google.com/financial-services/anti-money-laundering/docs/create-and-manage-instances#export-registered-parties)
// for information on the output schema for this method.
func (c *aMLRESTClient) ExportRegisteredParties(ctx context.Context, req *financialservicespb.ExportRegisteredPartiesRequest, opts ...gax.CallOption) (*ExportRegisteredPartiesOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:exportRegisteredParties", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ExportRegisteredParties")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ExportRegisteredPartiesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListDatasets lists datasets.
func (c *aMLRESTClient) ListDatasets(ctx context.Context, req *financialservicespb.ListDatasetsRequest, opts ...gax.CallOption) *DatasetIterator {
	it := &DatasetIterator{}
	req = proto.Clone(req).(*financialservicespb.ListDatasetsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.Dataset, string, error) {
		resp := &financialservicespb.ListDatasetsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/datasets", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListDatasets")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetDatasets(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetDataset gets a dataset.
func (c *aMLRESTClient) GetDataset(ctx context.Context, req *financialservicespb.GetDatasetRequest, opts ...gax.CallOption) (*financialservicespb.Dataset, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetDataset[0:len((*c.CallOptions).GetDataset):len((*c.CallOptions).GetDataset)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &financialservicespb.Dataset{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetDataset")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateDataset creates a dataset.
func (c *aMLRESTClient) CreateDataset(ctx context.Context, req *financialservicespb.CreateDatasetRequest, opts ...gax.CallOption) (*CreateDatasetOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDataset()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/datasets", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("datasetId", fmt.Sprintf("%v", req.GetDatasetId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateDataset")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateDatasetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateDataset updates the parameters of a single Dataset.
func (c *aMLRESTClient) UpdateDataset(ctx context.Context, req *financialservicespb.UpdateDatasetRequest, opts ...gax.CallOption) (*UpdateDatasetOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDataset()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetDataset().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "dataset.name", url.QueryEscape(req.GetDataset().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateDataset")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateDatasetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteDataset deletes a dataset.
func (c *aMLRESTClient) DeleteDataset(ctx context.Context, req *financialservicespb.DeleteDatasetRequest, opts ...gax.CallOption) (*DeleteDatasetOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteDataset")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteDatasetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListModels lists models.
func (c *aMLRESTClient) ListModels(ctx context.Context, req *financialservicespb.ListModelsRequest, opts ...gax.CallOption) *ModelIterator {
	it := &ModelIterator{}
	req = proto.Clone(req).(*financialservicespb.ListModelsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.Model, string, error) {
		resp := &financialservicespb.ListModelsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/models", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListModels")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetModels(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetModel gets a model.
func (c *aMLRESTClient) GetModel(ctx context.Context, req *financialservicespb.GetModelRequest, opts ...gax.CallOption) (*financialservicespb.Model, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetModel[0:len((*c.CallOptions).GetModel):len((*c.CallOptions).GetModel)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &financialservicespb.Model{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetModel")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateModel creates a model.
func (c *aMLRESTClient) CreateModel(ctx context.Context, req *financialservicespb.CreateModelRequest, opts ...gax.CallOption) (*CreateModelOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetModel()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/models", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("modelId", fmt.Sprintf("%v", req.GetModelId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateModel")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateModelOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateModel updates the parameters of a single Model.
func (c *aMLRESTClient) UpdateModel(ctx context.Context, req *financialservicespb.UpdateModelRequest, opts ...gax.CallOption) (*UpdateModelOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetModel()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetModel().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "model.name", url.QueryEscape(req.GetModel().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateModel")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateModelOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ExportModelMetadata export governance information for a Model resource. For
// information on the exported fields, see
// AML output data
// model (at https://cloud.google.com/financial-services/anti-money-laundering/docs/reference/schemas/aml-output-data-model#model).
func (c *aMLRESTClient) ExportModelMetadata(ctx context.Context, req *financialservicespb.ExportModelMetadataRequest, opts ...gax.CallOption) (*ExportModelMetadataOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:exportMetadata", req.GetModel())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "model", url.QueryEscape(req.GetModel()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ExportModelMetadata")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ExportModelMetadataOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteModel deletes a model.
func (c *aMLRESTClient) DeleteModel(ctx context.Context, req *financialservicespb.DeleteModelRequest, opts ...gax.CallOption) (*DeleteModelOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteModel")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteModelOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListEngineConfigs lists engine configs.
func (c *aMLRESTClient) ListEngineConfigs(ctx context.Context, req *financialservicespb.ListEngineConfigsRequest, opts ...gax.CallOption) *EngineConfigIterator {
	it := &EngineConfigIterator{}
	req = proto.Clone(req).(*financialservicespb.ListEngineConfigsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.EngineConfig, string, error) {
		resp := &financialservicespb.ListEngineConfigsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/engineConfigs", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListEngineConfigs")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetEngineConfigs(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetEngineConfig gets an engine config.
func (c *aMLRESTClient) GetEngineConfig(ctx context.Context, req *financialservicespb.GetEngineConfigRequest, opts ...gax.CallOption) (*financialservicespb.EngineConfig, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetEngineConfig[0:len((*c.CallOptions).GetEngineConfig):len((*c.CallOptions).GetEngineConfig)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &financialservicespb.EngineConfig{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetEngineConfig")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateEngineConfig creates an engine config.
func (c *aMLRESTClient) CreateEngineConfig(ctx context.Context, req *financialservicespb.CreateEngineConfigRequest, opts ...gax.CallOption) (*CreateEngineConfigOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetEngineConfig()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/engineConfigs", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("engineConfigId", fmt.Sprintf("%v", req.GetEngineConfigId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateEngineConfig")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateEngineConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateEngineConfig updates the parameters of a single EngineConfig.
func (c *aMLRESTClient) UpdateEngineConfig(ctx context.Context, req *financialservicespb.UpdateEngineConfigRequest, opts ...gax.CallOption) (*UpdateEngineConfigOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetEngineConfig()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetEngineConfig().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "engine_config.name", url.QueryEscape(req.GetEngineConfig().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateEngineConfig")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateEngineConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ExportEngineConfigMetadata export governance information for an EngineConfig resource. For
// information on the exported fields, see
// AML output data
// model (at https://cloud.google.com/financial-services/anti-money-laundering/docs/reference/schemas/aml-output-data-model#engine-config).
func (c *aMLRESTClient) ExportEngineConfigMetadata(ctx context.Context, req *financialservicespb.ExportEngineConfigMetadataRequest, opts ...gax.CallOption) (*ExportEngineConfigMetadataOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:exportMetadata", req.GetEngineConfig())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "engine_config", url.QueryEscape(req.GetEngineConfig()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ExportEngineConfigMetadata")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ExportEngineConfigMetadataOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteEngineConfig deletes an engine config.
func (c *aMLRESTClient) DeleteEngineConfig(ctx context.Context, req *financialservicespb.DeleteEngineConfigRequest, opts ...gax.CallOption) (*DeleteEngineConfigOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteEngineConfig")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteEngineConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetEngineVersion gets a single EngineVersion.
func (c *aMLRESTClient) GetEngineVersion(ctx context.Context, req *financialservicespb.GetEngineVersionRequest, opts ...gax.CallOption) (*financialservicespb.EngineVersion, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetEngineVersion[0:len((*c.CallOptions).GetEngineVersion):len((*c.CallOptions).GetEngineVersion)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &financialservicespb.EngineVersion{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetEngineVersion")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListEngineVersions lists EngineVersions for given location.
func (c *aMLRESTClient) ListEngineVersions(ctx context.Context, req *financialservicespb.ListEngineVersionsRequest, opts ...gax.CallOption) *EngineVersionIterator {
	it := &EngineVersionIterator{}
	req = proto.Clone(req).(*financialservicespb.ListEngineVersionsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.EngineVersion, string, error) {
		resp := &financialservicespb.ListEngineVersionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/engineVersions", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListEngineVersions")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetEngineVersions(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListPredictionResults list PredictionResults.
func (c *aMLRESTClient) ListPredictionResults(ctx context.Context, req *financialservicespb.ListPredictionResultsRequest, opts ...gax.CallOption) *PredictionResultIterator {
	it := &PredictionResultIterator{}
	req = proto.Clone(req).(*financialservicespb.ListPredictionResultsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.PredictionResult, string, error) {
		resp := &financialservicespb.ListPredictionResultsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/predictionResults", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListPredictionResults")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetPredictionResults(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetPredictionResult gets a PredictionResult.
func (c *aMLRESTClient) GetPredictionResult(ctx context.Context, req *financialservicespb.GetPredictionResultRequest, opts ...gax.CallOption) (*financialservicespb.PredictionResult, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetPredictionResult[0:len((*c.CallOptions).GetPredictionResult):len((*c.CallOptions).GetPredictionResult)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &financialservicespb.PredictionResult{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetPredictionResult")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreatePredictionResult create a PredictionResult.
func (c *aMLRESTClient) CreatePredictionResult(ctx context.Context, req *financialservicespb.CreatePredictionResultRequest, opts ...gax.CallOption) (*CreatePredictionResultOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetPredictionResult()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/predictionResults", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("predictionResultId", fmt.Sprintf("%v", req.GetPredictionResultId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreatePredictionResult")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreatePredictionResultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdatePredictionResult updates the parameters of a single PredictionResult.
func (c *aMLRESTClient) UpdatePredictionResult(ctx context.Context, req *financialservicespb.UpdatePredictionResultRequest, opts ...gax.CallOption) (*UpdatePredictionResultOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetPredictionResult()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetPredictionResult().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "prediction_result.name", url.QueryEscape(req.GetPredictionResult().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdatePredictionResult")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdatePredictionResultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ExportPredictionResultMetadata export governance information for a PredictionResult resource. For
// information on the exported fields, see
// AML output data
// model (at https://cloud.google.com/financial-services/anti-money-laundering/docs/reference/schemas/aml-output-data-model#prediction-results).
func (c *aMLRESTClient) ExportPredictionResultMetadata(ctx context.Context, req *financialservicespb.ExportPredictionResultMetadataRequest, opts ...gax.CallOption) (*ExportPredictionResultMetadataOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:exportMetadata", req.GetPredictionResult())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "prediction_result", url.QueryEscape(req.GetPredictionResult()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ExportPredictionResultMetadata")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ExportPredictionResultMetadataOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeletePredictionResult deletes a PredictionResult.
func (c *aMLRESTClient) DeletePredictionResult(ctx context.Context, req *financialservicespb.DeletePredictionResultRequest, opts ...gax.CallOption) (*DeletePredictionResultOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeletePredictionResult")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeletePredictionResultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListBacktestResults list BacktestResults.
func (c *aMLRESTClient) ListBacktestResults(ctx context.Context, req *financialservicespb.ListBacktestResultsRequest, opts ...gax.CallOption) *BacktestResultIterator {
	it := &BacktestResultIterator{}
	req = proto.Clone(req).(*financialservicespb.ListBacktestResultsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*financialservicespb.BacktestResult, string, error) {
		resp := &financialservicespb.ListBacktestResultsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/backtestResults", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListBacktestResults")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetBacktestResults(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetBacktestResult gets a BacktestResult.
func (c *aMLRESTClient) GetBacktestResult(ctx context.Context, req *financialservicespb.GetBacktestResultRequest, opts ...gax.CallOption) (*financialservicespb.BacktestResult, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetBacktestResult[0:len((*c.CallOptions).GetBacktestResult):len((*c.CallOptions).GetBacktestResult)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &financialservicespb.BacktestResult{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetBacktestResult")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateBacktestResult create a BacktestResult.
func (c *aMLRESTClient) CreateBacktestResult(ctx context.Context, req *financialservicespb.CreateBacktestResultRequest, opts ...gax.CallOption) (*CreateBacktestResultOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetBacktestResult()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/backtestResults", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("backtestResultId", fmt.Sprintf("%v", req.GetBacktestResultId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateBacktestResult")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateBacktestResultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// UpdateBacktestResult updates the parameters of a single BacktestResult.
func (c *aMLRESTClient) UpdateBacktestResult(ctx context.Context, req *financialservicespb.UpdateBacktestResultRequest, opts ...gax.CallOption) (*UpdateBacktestResultOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetBacktestResult()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetBacktestResult().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "backtest_result.name", url.QueryEscape(req.GetBacktestResult().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateBacktestResult")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &UpdateBacktestResultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ExportBacktestResultMetadata export governance information for a BacktestResult resource. For
// information on the exported fields, see
// AML output data
// model (at https://cloud.google.com/financial-services/anti-money-laundering/docs/reference/schemas/aml-output-data-model#backtest-results).
func (c *aMLRESTClient) ExportBacktestResultMetadata(ctx context.Context, req *financialservicespb.ExportBacktestResultMetadataRequest, opts ...gax.CallOption) (*ExportBacktestResultMetadataOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:exportMetadata", req.GetBacktestResult())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "backtest_result", url.QueryEscape(req.GetBacktestResult()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ExportBacktestResultMetadata")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &ExportBacktestResultMetadataOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteBacktestResult deletes a BacktestResult.
func (c *aMLRESTClient) DeleteBacktestResult(ctx context.Context, req *financialservicespb.DeleteBacktestResultRequest, opts ...gax.CallOption) (*DeleteBacktestResultOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteBacktestResult")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteBacktestResultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// GetLocation gets information about a location.
func (c *aMLRESTClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &locationpb.Location{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetLocation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLocations lists information about the supported locations for this service.
func (c *aMLRESTClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/locations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListLocations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *aMLRESTClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CancelOperation")
		return err
	}, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *aMLRESTClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteOperation")
		return err
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *aMLRESTClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *aMLRESTClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/operations", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOperations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateBacktestResultOperation returns a new CreateBacktestResultOperation from a given name.
// The name must be that of a previously created CreateBacktestResultOperation, possibly from a different process.
func (c *aMLGRPCClient) CreateBacktestResultOperation(name string) *CreateBacktestResultOperation {
	return &CreateBacktestResultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateBacktestResultOperation returns a new CreateBacktestResultOperation from a given name.
// The name must be that of a previously created CreateBacktestResultOperation, possibly from a different process.
func (c *aMLRESTClient) CreateBacktestResultOperation(name string) *CreateBacktestResultOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateBacktestResultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateDatasetOperation returns a new CreateDatasetOperation from a given name.
// The name must be that of a previously created CreateDatasetOperation, possibly from a different process.
func (c *aMLGRPCClient) CreateDatasetOperation(name string) *CreateDatasetOperation {
	return &CreateDatasetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateDatasetOperation returns a new CreateDatasetOperation from a given name.
// The name must be that of a previously created CreateDatasetOperation, possibly from a different process.
func (c *aMLRESTClient) CreateDatasetOperation(name string) *CreateDatasetOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateDatasetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateEngineConfigOperation returns a new CreateEngineConfigOperation from a given name.
// The name must be that of a previously created CreateEngineConfigOperation, possibly from a different process.
func (c *aMLGRPCClient) CreateEngineConfigOperation(name string) *CreateEngineConfigOperation {
	return &CreateEngineConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateEngineConfigOperation returns a new CreateEngineConfigOperation from a given name.
// The name must be that of a previously created CreateEngineConfigOperation, possibly from a different process.
func (c *aMLRESTClient) CreateEngineConfigOperation(name string) *CreateEngineConfigOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateEngineConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateInstanceOperation returns a new CreateInstanceOperation from a given name.
// The name must be that of a previously created CreateInstanceOperation, possibly from a different process.
func (c *aMLGRPCClient) CreateInstanceOperation(name string) *CreateInstanceOperation {
	return &CreateInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateInstanceOperation returns a new CreateInstanceOperation from a given name.
// The name must be that of a previously created CreateInstanceOperation, possibly from a different process.
func (c *aMLRESTClient) CreateInstanceOperation(name string) *CreateInstanceOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateModelOperation returns a new CreateModelOperation from a given name.
// The name must be that of a previously created CreateModelOperation, possibly from a different process.
func (c *aMLGRPCClient) CreateModelOperation(name string) *CreateModelOperation {
	return &CreateModelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateModelOperation returns a new CreateModelOperation from a given name.
// The name must be that of a previously created CreateModelOperation, possibly from a different process.
func (c *aMLRESTClient) CreateModelOperation(name string) *CreateModelOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateModelOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreatePredictionResultOperation returns a new CreatePredictionResultOperation from a given name.
// The name must be that of a previously created CreatePredictionResultOperation, possibly from a different process.
func (c *aMLGRPCClient) CreatePredictionResultOperation(name string) *CreatePredictionResultOperation {
	return &CreatePredictionResultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreatePredictionResultOperation returns a new CreatePredictionResultOperation from a given name.
// The name must be that of a previously created CreatePredictionResultOperation, possibly from a different process.
func (c *aMLRESTClient) CreatePredictionResultOperation(name string) *CreatePredictionResultOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreatePredictionResultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteBacktestResultOperation returns a new DeleteBacktestResultOperation from a given name.
// The name must be that of a previously created DeleteBacktestResultOperation, possibly from a different process.
func (c *aMLGRPCClient) DeleteBacktestResultOperation(name string) *DeleteBacktestResultOperation {
	return &DeleteBacktestResultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteBacktestResultOperation returns a new DeleteBacktestResultOperation from a given name.
// The name must be that of a previously created DeleteBacktestResultOperation, possibly from a different process.
func (c *aMLRESTClient) DeleteBacktestResultOperation(name string) *DeleteBacktestResultOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteBacktestResultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteDatasetOperation returns a new DeleteDatasetOperation from a given name.
// The name must be that of a previously created DeleteDatasetOperation, possibly from a different process.
func (c *aMLGRPCClient) DeleteDatasetOperation(name string) *DeleteDatasetOperation {
	return &DeleteDatasetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteDatasetOperation returns a new DeleteDatasetOperation from a given name.
// The name must be that of a previously created DeleteDatasetOperation, possibly from a different process.
func (c *aMLRESTClient) DeleteDatasetOperation(name string) *DeleteDatasetOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteDatasetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteEngineConfigOperation returns a new DeleteEngineConfigOperation from a given name.
// The name must be that of a previously created DeleteEngineConfigOperation, possibly from a different process.
func (c *aMLGRPCClient) DeleteEngineConfigOperation(name string) *DeleteEngineConfigOperation {
	return &DeleteEngineConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteEngineConfigOperation returns a new DeleteEngineConfigOperation from a given name.
// The name must be that of a previously created DeleteEngineConfigOperation, possibly from a different process.
func (c *aMLRESTClient) DeleteEngineConfigOperation(name string) *DeleteEngineConfigOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteEngineConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteInstanceOperation returns a new DeleteInstanceOperation from a given name.
// The name must be that of a previously created DeleteInstanceOperation, possibly from a different process.
func (c *aMLGRPCClient) DeleteInstanceOperation(name string) *DeleteInstanceOperation {
	return &DeleteInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteInstanceOperation returns a new DeleteInstanceOperation from a given name.
// The name must be that of a previously created DeleteInstanceOperation, possibly from a different process.
func (c *aMLRESTClient) DeleteInstanceOperation(name string) *DeleteInstanceOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteModelOperation returns a new DeleteModelOperation from a given name.
// The name must be that of a previously created DeleteModelOperation, possibly from a different process.
func (c *aMLGRPCClient) DeleteModelOperation(name string) *DeleteModelOperation {
	return &DeleteModelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteModelOperation returns a new DeleteModelOperation from a given name.
// The name must be that of a previously created DeleteModelOperation, possibly from a different process.
func (c *aMLRESTClient) DeleteModelOperation(name string) *DeleteModelOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteModelOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeletePredictionResultOperation returns a new DeletePredictionResultOperation from a given name.
// The name must be that of a previously created DeletePredictionResultOperation, possibly from a different process.
func (c *aMLGRPCClient) DeletePredictionResultOperation(name string) *DeletePredictionResultOperation {
	return &DeletePredictionResultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeletePredictionResultOperation returns a new DeletePredictionResultOperation from a given name.
// The name must be that of a previously created DeletePredictionResultOperation, possibly from a different process.
func (c *aMLRESTClient) DeletePredictionResultOperation(name string) *DeletePredictionResultOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeletePredictionResultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ExportBacktestResultMetadataOperation returns a new ExportBacktestResultMetadataOperation from a given name.
// The name must be that of a previously created ExportBacktestResultMetadataOperation, possibly from a different process.
func (c *aMLGRPCClient) ExportBacktestResultMetadataOperation(name string) *ExportBacktestResultMetadataOperation {
	return &ExportBacktestResultMetadataOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ExportBacktestResultMetadataOperation returns a new ExportBacktestResultMetadataOperation from a given name.
// The name must be that of a previously created ExportBacktestResultMetadataOperation, possibly from a different process.
func (c *aMLRESTClient) ExportBacktestResultMetadataOperation(name string) *ExportBacktestResultMetadataOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ExportBacktestResultMetadataOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ExportEngineConfigMetadataOperation returns a new ExportEngineConfigMetadataOperation from a given name.
// The name must be that of a previously created ExportEngineConfigMetadataOperation, possibly from a different process.
func (c *aMLGRPCClient) ExportEngineConfigMetadataOperation(name string) *ExportEngineConfigMetadataOperation {
	return &ExportEngineConfigMetadataOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ExportEngineConfigMetadataOperation returns a new ExportEngineConfigMetadataOperation from a given name.
// The name must be that of a previously created ExportEngineConfigMetadataOperation, possibly from a different process.
func (c *aMLRESTClient) ExportEngineConfigMetadataOperation(name string) *ExportEngineConfigMetadataOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ExportEngineConfigMetadataOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ExportModelMetadataOperation returns a new ExportModelMetadataOperation from a given name.
// The name must be that of a previously created ExportModelMetadataOperation, possibly from a different process.
func (c *aMLGRPCClient) ExportModelMetadataOperation(name string) *ExportModelMetadataOperation {
	return &ExportModelMetadataOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ExportModelMetadataOperation returns a new ExportModelMetadataOperation from a given name.
// The name must be that of a previously created ExportModelMetadataOperation, possibly from a different process.
func (c *aMLRESTClient) ExportModelMetadataOperation(name string) *ExportModelMetadataOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ExportModelMetadataOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ExportPredictionResultMetadataOperation returns a new ExportPredictionResultMetadataOperation from a given name.
// The name must be that of a previously created ExportPredictionResultMetadataOperation, possibly from a different process.
func (c *aMLGRPCClient) ExportPredictionResultMetadataOperation(name string) *ExportPredictionResultMetadataOperation {
	return &ExportPredictionResultMetadataOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ExportPredictionResultMetadataOperation returns a new ExportPredictionResultMetadataOperation from a given name.
// The name must be that of a previously created ExportPredictionResultMetadataOperation, possibly from a different process.
func (c *aMLRESTClient) ExportPredictionResultMetadataOperation(name string) *ExportPredictionResultMetadataOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ExportPredictionResultMetadataOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ExportRegisteredPartiesOperation returns a new ExportRegisteredPartiesOperation from a given name.
// The name must be that of a previously created ExportRegisteredPartiesOperation, possibly from a different process.
func (c *aMLGRPCClient) ExportRegisteredPartiesOperation(name string) *ExportRegisteredPartiesOperation {
	return &ExportRegisteredPartiesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ExportRegisteredPartiesOperation returns a new ExportRegisteredPartiesOperation from a given name.
// The name must be that of a previously created ExportRegisteredPartiesOperation, possibly from a different process.
func (c *aMLRESTClient) ExportRegisteredPartiesOperation(name string) *ExportRegisteredPartiesOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ExportRegisteredPartiesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// ImportRegisteredPartiesOperation returns a new ImportRegisteredPartiesOperation from a given name.
// The name must be that of a previously created ImportRegisteredPartiesOperation, possibly from a different process.
func (c *aMLGRPCClient) ImportRegisteredPartiesOperation(name string) *ImportRegisteredPartiesOperation {
	return &ImportRegisteredPartiesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ImportRegisteredPartiesOperation returns a new ImportRegisteredPartiesOperation from a given name.
// The name must be that of a previously created ImportRegisteredPartiesOperation, possibly from a different process.
func (c *aMLRESTClient) ImportRegisteredPartiesOperation(name string) *ImportRegisteredPartiesOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &ImportRegisteredPartiesOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateBacktestResultOperation returns a new UpdateBacktestResultOperation from a given name.
// The name must be that of a previously created UpdateBacktestResultOperation, possibly from a different process.
func (c *aMLGRPCClient) UpdateBacktestResultOperation(name string) *UpdateBacktestResultOperation {
	return &UpdateBacktestResultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateBacktestResultOperation returns a new UpdateBacktestResultOperation from a given name.
// The name must be that of a previously created UpdateBacktestResultOperation, possibly from a different process.
func (c *aMLRESTClient) UpdateBacktestResultOperation(name string) *UpdateBacktestResultOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateBacktestResultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateDatasetOperation returns a new UpdateDatasetOperation from a given name.
// The name must be that of a previously created UpdateDatasetOperation, possibly from a different process.
func (c *aMLGRPCClient) UpdateDatasetOperation(name string) *UpdateDatasetOperation {
	return &UpdateDatasetOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateDatasetOperation returns a new UpdateDatasetOperation from a given name.
// The name must be that of a previously created UpdateDatasetOperation, possibly from a different process.
func (c *aMLRESTClient) UpdateDatasetOperation(name string) *UpdateDatasetOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateDatasetOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateEngineConfigOperation returns a new UpdateEngineConfigOperation from a given name.
// The name must be that of a previously created UpdateEngineConfigOperation, possibly from a different process.
func (c *aMLGRPCClient) UpdateEngineConfigOperation(name string) *UpdateEngineConfigOperation {
	return &UpdateEngineConfigOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateEngineConfigOperation returns a new UpdateEngineConfigOperation from a given name.
// The name must be that of a previously created UpdateEngineConfigOperation, possibly from a different process.
func (c *aMLRESTClient) UpdateEngineConfigOperation(name string) *UpdateEngineConfigOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateEngineConfigOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateInstanceOperation returns a new UpdateInstanceOperation from a given name.
// The name must be that of a previously created UpdateInstanceOperation, possibly from a different process.
func (c *aMLGRPCClient) UpdateInstanceOperation(name string) *UpdateInstanceOperation {
	return &UpdateInstanceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateInstanceOperation returns a new UpdateInstanceOperation from a given name.
// The name must be that of a previously created UpdateInstanceOperation, possibly from a different process.
func (c *aMLRESTClient) UpdateInstanceOperation(name string) *UpdateInstanceOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateInstanceOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdateModelOperation returns a new UpdateModelOperation from a given name.
// The name must be that of a previously created UpdateModelOperation, possibly from a different process.
func (c *aMLGRPCClient) UpdateModelOperation(name string) *UpdateModelOperation {
	return &UpdateModelOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateModelOperation returns a new UpdateModelOperation from a given name.
// The name must be that of a previously created UpdateModelOperation, possibly from a different process.
func (c *aMLRESTClient) UpdateModelOperation(name string) *UpdateModelOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdateModelOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// UpdatePredictionResultOperation returns a new UpdatePredictionResultOperation from a given name.
// The name must be that of a previously created UpdatePredictionResultOperation, possibly from a different process.
func (c *aMLGRPCClient) UpdatePredictionResultOperation(name string) *UpdatePredictionResultOperation {
	return &UpdatePredictionResultOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdatePredictionResultOperation returns a new UpdatePredictionResultOperation from a given name.
// The name must be that of a previously created UpdatePredictionResultOperation, possibly from a different process.
func (c *aMLRESTClient) UpdatePredictionResultOperation(name string) *UpdatePredictionResultOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &UpdatePredictionResultOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
