// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1beta/answer.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enumeration of the state of the answer generation.
type Answer_State int32

const (
	// Unknown.
	Answer_STATE_UNSPECIFIED Answer_State = 0
	// Answer generation is currently in progress.
	Answer_IN_PROGRESS Answer_State = 1
	// Answer generation currently failed.
	Answer_FAILED Answer_State = 2
	// Answer generation has succeeded.
	Answer_SUCCEEDED Answer_State = 3
)

// Enum value maps for Answer_State.
var (
	Answer_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "FAILED",
		3: "SUCCEEDED",
	}
	Answer_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"IN_PROGRESS":       1,
		"FAILED":            2,
		"SUCCEEDED":         3,
	}
)

func (x Answer_State) Enum() *Answer_State {
	p := new(Answer_State)
	*p = x
	return p
}

func (x Answer_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Answer_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_enumTypes[0].Descriptor()
}

func (Answer_State) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_answer_proto_enumTypes[0]
}

func (x Answer_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Answer_State.Descriptor instead.
func (Answer_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 0}
}

// An enum for answer skipped reasons.
type Answer_AnswerSkippedReason int32

const (
	// Default value. The answer skipped reason is not specified.
	Answer_ANSWER_SKIPPED_REASON_UNSPECIFIED Answer_AnswerSkippedReason = 0
	// The adversarial query ignored case.
	Answer_ADVERSARIAL_QUERY_IGNORED Answer_AnswerSkippedReason = 1
	// The non-answer seeking query ignored case
	//
	// Google skips the answer if the query is chit chat.
	Answer_NON_ANSWER_SEEKING_QUERY_IGNORED Answer_AnswerSkippedReason = 2
	// The out-of-domain query ignored case.
	//
	// Google skips the answer if there are no high-relevance search results.
	Answer_OUT_OF_DOMAIN_QUERY_IGNORED Answer_AnswerSkippedReason = 3
	// The potential policy violation case.
	//
	// Google skips the answer if there is a potential policy violation
	// detected. This includes content that may be violent or toxic.
	Answer_POTENTIAL_POLICY_VIOLATION Answer_AnswerSkippedReason = 4
	// The no relevant content case.
	//
	// Google skips the answer if there is no relevant content in the
	// retrieved search results.
	Answer_NO_RELEVANT_CONTENT Answer_AnswerSkippedReason = 5
	// The jail-breaking query ignored case.
	//
	// For example, "Reply in the tone of a competing company's CEO".
	// Google skips the answer if the query is classified as a jail-breaking
	// query.
	Answer_JAIL_BREAKING_QUERY_IGNORED Answer_AnswerSkippedReason = 6
	// The customer policy violation case.
	//
	// Google skips the summary if there is a customer policy violation
	// detected. The policy is defined by the customer.
	Answer_CUSTOMER_POLICY_VIOLATION Answer_AnswerSkippedReason = 7
	// The non-answer seeking query ignored case.
	//
	// Google skips the answer if the query doesn't have clear intent.
	Answer_NON_ANSWER_SEEKING_QUERY_IGNORED_V2 Answer_AnswerSkippedReason = 8
	// The low-grounded answer case.
	//
	// Google skips the answer if a well grounded answer was unable to be
	// generated.
	Answer_LOW_GROUNDED_ANSWER Answer_AnswerSkippedReason = 9
)

// Enum value maps for Answer_AnswerSkippedReason.
var (
	Answer_AnswerSkippedReason_name = map[int32]string{
		0: "ANSWER_SKIPPED_REASON_UNSPECIFIED",
		1: "ADVERSARIAL_QUERY_IGNORED",
		2: "NON_ANSWER_SEEKING_QUERY_IGNORED",
		3: "OUT_OF_DOMAIN_QUERY_IGNORED",
		4: "POTENTIAL_POLICY_VIOLATION",
		5: "NO_RELEVANT_CONTENT",
		6: "JAIL_BREAKING_QUERY_IGNORED",
		7: "CUSTOMER_POLICY_VIOLATION",
		8: "NON_ANSWER_SEEKING_QUERY_IGNORED_V2",
		9: "LOW_GROUNDED_ANSWER",
	}
	Answer_AnswerSkippedReason_value = map[string]int32{
		"ANSWER_SKIPPED_REASON_UNSPECIFIED":   0,
		"ADVERSARIAL_QUERY_IGNORED":           1,
		"NON_ANSWER_SEEKING_QUERY_IGNORED":    2,
		"OUT_OF_DOMAIN_QUERY_IGNORED":         3,
		"POTENTIAL_POLICY_VIOLATION":          4,
		"NO_RELEVANT_CONTENT":                 5,
		"JAIL_BREAKING_QUERY_IGNORED":         6,
		"CUSTOMER_POLICY_VIOLATION":           7,
		"NON_ANSWER_SEEKING_QUERY_IGNORED_V2": 8,
		"LOW_GROUNDED_ANSWER":                 9,
	}
)

func (x Answer_AnswerSkippedReason) Enum() *Answer_AnswerSkippedReason {
	p := new(Answer_AnswerSkippedReason)
	*p = x
	return p
}

func (x Answer_AnswerSkippedReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Answer_AnswerSkippedReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_enumTypes[1].Descriptor()
}

func (Answer_AnswerSkippedReason) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_answer_proto_enumTypes[1]
}

func (x Answer_AnswerSkippedReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Answer_AnswerSkippedReason.Descriptor instead.
func (Answer_AnswerSkippedReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 1}
}

// Enumeration of the state of the step.
type Answer_Step_State int32

const (
	// Unknown.
	Answer_Step_STATE_UNSPECIFIED Answer_Step_State = 0
	// Step is currently in progress.
	Answer_Step_IN_PROGRESS Answer_Step_State = 1
	// Step currently failed.
	Answer_Step_FAILED Answer_Step_State = 2
	// Step has succeeded.
	Answer_Step_SUCCEEDED Answer_Step_State = 3
)

// Enum value maps for Answer_Step_State.
var (
	Answer_Step_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "FAILED",
		3: "SUCCEEDED",
	}
	Answer_Step_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"IN_PROGRESS":       1,
		"FAILED":            2,
		"SUCCEEDED":         3,
	}
)

func (x Answer_Step_State) Enum() *Answer_Step_State {
	p := new(Answer_Step_State)
	*p = x
	return p
}

func (x Answer_Step_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Answer_Step_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_enumTypes[2].Descriptor()
}

func (Answer_Step_State) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_answer_proto_enumTypes[2]
}

func (x Answer_Step_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Answer_Step_State.Descriptor instead.
func (Answer_Step_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 3, 0}
}

// Query classification types.
type Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type int32

const (
	// Unspecified query classification type.
	Answer_QueryUnderstandingInfo_QueryClassificationInfo_TYPE_UNSPECIFIED Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type = 0
	// Adversarial query classification type.
	Answer_QueryUnderstandingInfo_QueryClassificationInfo_ADVERSARIAL_QUERY Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type = 1
	// Non-answer-seeking query classification type, for chit chat.
	Answer_QueryUnderstandingInfo_QueryClassificationInfo_NON_ANSWER_SEEKING_QUERY Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type = 2
	// Jail-breaking query classification type.
	Answer_QueryUnderstandingInfo_QueryClassificationInfo_JAIL_BREAKING_QUERY Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type = 3
	// Non-answer-seeking query classification type, for no clear intent.
	Answer_QueryUnderstandingInfo_QueryClassificationInfo_NON_ANSWER_SEEKING_QUERY_V2 Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type = 4
)

// Enum value maps for Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type.
var (
	Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "ADVERSARIAL_QUERY",
		2: "NON_ANSWER_SEEKING_QUERY",
		3: "JAIL_BREAKING_QUERY",
		4: "NON_ANSWER_SEEKING_QUERY_V2",
	}
	Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":            0,
		"ADVERSARIAL_QUERY":           1,
		"NON_ANSWER_SEEKING_QUERY":    2,
		"JAIL_BREAKING_QUERY":         3,
		"NON_ANSWER_SEEKING_QUERY_V2": 4,
	}
)

func (x Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type) Enum() *Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type {
	p := new(Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type)
	*p = x
	return p
}

func (x Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_enumTypes[3].Descriptor()
}

func (Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_answer_proto_enumTypes[3]
}

func (x Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type.Descriptor instead.
func (Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 4, 0, 0}
}

// Defines an answer.
type Answer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Fully qualified name
	// `projects/{project}/locations/global/collections/{collection}/engines/{engine}/sessions/*/answers/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The state of the answer generation.
	State Answer_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.discoveryengine.v1beta.Answer_State" json:"state,omitempty"`
	// The textual answer.
	AnswerText string `protobuf:"bytes,3,opt,name=answer_text,json=answerText,proto3" json:"answer_text,omitempty"`
	// Citations.
	Citations []*Answer_Citation `protobuf:"bytes,4,rep,name=citations,proto3" json:"citations,omitempty"`
	// References.
	References []*Answer_Reference `protobuf:"bytes,5,rep,name=references,proto3" json:"references,omitempty"`
	// Suggested related questions.
	RelatedQuestions []string `protobuf:"bytes,6,rep,name=related_questions,json=relatedQuestions,proto3" json:"related_questions,omitempty"`
	// Answer generation steps.
	Steps []*Answer_Step `protobuf:"bytes,7,rep,name=steps,proto3" json:"steps,omitempty"`
	// Query understanding information.
	QueryUnderstandingInfo *Answer_QueryUnderstandingInfo `protobuf:"bytes,10,opt,name=query_understanding_info,json=queryUnderstandingInfo,proto3" json:"query_understanding_info,omitempty"`
	// Additional answer-skipped reasons. This provides the reason for ignored
	// cases. If nothing is skipped, this field is not set.
	AnswerSkippedReasons []Answer_AnswerSkippedReason `protobuf:"varint,11,rep,packed,name=answer_skipped_reasons,json=answerSkippedReasons,proto3,enum=google.cloud.discoveryengine.v1beta.Answer_AnswerSkippedReason" json:"answer_skipped_reasons,omitempty"`
	// Output only. Answer creation timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Answer completed timestamp.
	CompleteTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=complete_time,json=completeTime,proto3" json:"complete_time,omitempty"`
}

func (x *Answer) Reset() {
	*x = Answer{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer) ProtoMessage() {}

func (x *Answer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer.ProtoReflect.Descriptor instead.
func (*Answer) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0}
}

func (x *Answer) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Answer) GetState() Answer_State {
	if x != nil {
		return x.State
	}
	return Answer_STATE_UNSPECIFIED
}

func (x *Answer) GetAnswerText() string {
	if x != nil {
		return x.AnswerText
	}
	return ""
}

func (x *Answer) GetCitations() []*Answer_Citation {
	if x != nil {
		return x.Citations
	}
	return nil
}

func (x *Answer) GetReferences() []*Answer_Reference {
	if x != nil {
		return x.References
	}
	return nil
}

func (x *Answer) GetRelatedQuestions() []string {
	if x != nil {
		return x.RelatedQuestions
	}
	return nil
}

func (x *Answer) GetSteps() []*Answer_Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

func (x *Answer) GetQueryUnderstandingInfo() *Answer_QueryUnderstandingInfo {
	if x != nil {
		return x.QueryUnderstandingInfo
	}
	return nil
}

func (x *Answer) GetAnswerSkippedReasons() []Answer_AnswerSkippedReason {
	if x != nil {
		return x.AnswerSkippedReasons
	}
	return nil
}

func (x *Answer) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Answer) GetCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompleteTime
	}
	return nil
}

// Citation info for a segment.
type Answer_Citation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Index indicates the start of the segment, measured in bytes (UTF-8
	// unicode).
	StartIndex int64 `protobuf:"varint,1,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	// End of the attributed segment, exclusive.
	EndIndex int64 `protobuf:"varint,2,opt,name=end_index,json=endIndex,proto3" json:"end_index,omitempty"`
	// Citation sources for the attributed segment.
	Sources []*Answer_CitationSource `protobuf:"bytes,3,rep,name=sources,proto3" json:"sources,omitempty"`
}

func (x *Answer_Citation) Reset() {
	*x = Answer_Citation{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Citation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Citation) ProtoMessage() {}

func (x *Answer_Citation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Citation.ProtoReflect.Descriptor instead.
func (*Answer_Citation) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Answer_Citation) GetStartIndex() int64 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

func (x *Answer_Citation) GetEndIndex() int64 {
	if x != nil {
		return x.EndIndex
	}
	return 0
}

func (x *Answer_Citation) GetSources() []*Answer_CitationSource {
	if x != nil {
		return x.Sources
	}
	return nil
}

// Citation source.
type Answer_CitationSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID of the citation source.
	ReferenceId string `protobuf:"bytes,1,opt,name=reference_id,json=referenceId,proto3" json:"reference_id,omitempty"`
}

func (x *Answer_CitationSource) Reset() {
	*x = Answer_CitationSource{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_CitationSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_CitationSource) ProtoMessage() {}

func (x *Answer_CitationSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_CitationSource.ProtoReflect.Descriptor instead.
func (*Answer_CitationSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Answer_CitationSource) GetReferenceId() string {
	if x != nil {
		return x.ReferenceId
	}
	return ""
}

// Reference.
type Answer_Reference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Search result content.
	//
	// Types that are assignable to Content:
	//
	//	*Answer_Reference_UnstructuredDocumentInfo_
	//	*Answer_Reference_ChunkInfo_
	//	*Answer_Reference_StructuredDocumentInfo_
	Content isAnswer_Reference_Content `protobuf_oneof:"content"`
}

func (x *Answer_Reference) Reset() {
	*x = Answer_Reference{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Reference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Reference) ProtoMessage() {}

func (x *Answer_Reference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Reference.ProtoReflect.Descriptor instead.
func (*Answer_Reference) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 2}
}

func (m *Answer_Reference) GetContent() isAnswer_Reference_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (x *Answer_Reference) GetUnstructuredDocumentInfo() *Answer_Reference_UnstructuredDocumentInfo {
	if x, ok := x.GetContent().(*Answer_Reference_UnstructuredDocumentInfo_); ok {
		return x.UnstructuredDocumentInfo
	}
	return nil
}

func (x *Answer_Reference) GetChunkInfo() *Answer_Reference_ChunkInfo {
	if x, ok := x.GetContent().(*Answer_Reference_ChunkInfo_); ok {
		return x.ChunkInfo
	}
	return nil
}

func (x *Answer_Reference) GetStructuredDocumentInfo() *Answer_Reference_StructuredDocumentInfo {
	if x, ok := x.GetContent().(*Answer_Reference_StructuredDocumentInfo_); ok {
		return x.StructuredDocumentInfo
	}
	return nil
}

type isAnswer_Reference_Content interface {
	isAnswer_Reference_Content()
}

type Answer_Reference_UnstructuredDocumentInfo_ struct {
	// Unstructured document information.
	UnstructuredDocumentInfo *Answer_Reference_UnstructuredDocumentInfo `protobuf:"bytes,1,opt,name=unstructured_document_info,json=unstructuredDocumentInfo,proto3,oneof"`
}

type Answer_Reference_ChunkInfo_ struct {
	// Chunk information.
	ChunkInfo *Answer_Reference_ChunkInfo `protobuf:"bytes,2,opt,name=chunk_info,json=chunkInfo,proto3,oneof"`
}

type Answer_Reference_StructuredDocumentInfo_ struct {
	// Structured document information.
	StructuredDocumentInfo *Answer_Reference_StructuredDocumentInfo `protobuf:"bytes,3,opt,name=structured_document_info,json=structuredDocumentInfo,proto3,oneof"`
}

func (*Answer_Reference_UnstructuredDocumentInfo_) isAnswer_Reference_Content() {}

func (*Answer_Reference_ChunkInfo_) isAnswer_Reference_Content() {}

func (*Answer_Reference_StructuredDocumentInfo_) isAnswer_Reference_Content() {}

// Step information.
type Answer_Step struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the step.
	State Answer_Step_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.discoveryengine.v1beta.Answer_Step_State" json:"state,omitempty"`
	// The description of the step.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The thought of the step.
	Thought string `protobuf:"bytes,3,opt,name=thought,proto3" json:"thought,omitempty"`
	// Actions.
	Actions []*Answer_Step_Action `protobuf:"bytes,4,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *Answer_Step) Reset() {
	*x = Answer_Step{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Step) ProtoMessage() {}

func (x *Answer_Step) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Step.ProtoReflect.Descriptor instead.
func (*Answer_Step) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Answer_Step) GetState() Answer_Step_State {
	if x != nil {
		return x.State
	}
	return Answer_Step_STATE_UNSPECIFIED
}

func (x *Answer_Step) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Answer_Step) GetThought() string {
	if x != nil {
		return x.Thought
	}
	return ""
}

func (x *Answer_Step) GetActions() []*Answer_Step_Action {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Query understanding information.
type Answer_QueryUnderstandingInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Query classification information.
	QueryClassificationInfo []*Answer_QueryUnderstandingInfo_QueryClassificationInfo `protobuf:"bytes,1,rep,name=query_classification_info,json=queryClassificationInfo,proto3" json:"query_classification_info,omitempty"`
}

func (x *Answer_QueryUnderstandingInfo) Reset() {
	*x = Answer_QueryUnderstandingInfo{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_QueryUnderstandingInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_QueryUnderstandingInfo) ProtoMessage() {}

func (x *Answer_QueryUnderstandingInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_QueryUnderstandingInfo.ProtoReflect.Descriptor instead.
func (*Answer_QueryUnderstandingInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Answer_QueryUnderstandingInfo) GetQueryClassificationInfo() []*Answer_QueryUnderstandingInfo_QueryClassificationInfo {
	if x != nil {
		return x.QueryClassificationInfo
	}
	return nil
}

// Unstructured document information.
type Answer_Reference_UnstructuredDocumentInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Document resource name.
	Document string `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// URI for the document.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Title.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// List of cited chunk contents derived from document content.
	ChunkContents []*Answer_Reference_UnstructuredDocumentInfo_ChunkContent `protobuf:"bytes,4,rep,name=chunk_contents,json=chunkContents,proto3" json:"chunk_contents,omitempty"`
	// The structured JSON metadata for the document.
	// It is populated from the struct data from the Chunk in search result.
	StructData *structpb.Struct `protobuf:"bytes,5,opt,name=struct_data,json=structData,proto3" json:"struct_data,omitempty"`
}

func (x *Answer_Reference_UnstructuredDocumentInfo) Reset() {
	*x = Answer_Reference_UnstructuredDocumentInfo{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Reference_UnstructuredDocumentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Reference_UnstructuredDocumentInfo) ProtoMessage() {}

func (x *Answer_Reference_UnstructuredDocumentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Reference_UnstructuredDocumentInfo.ProtoReflect.Descriptor instead.
func (*Answer_Reference_UnstructuredDocumentInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *Answer_Reference_UnstructuredDocumentInfo) GetDocument() string {
	if x != nil {
		return x.Document
	}
	return ""
}

func (x *Answer_Reference_UnstructuredDocumentInfo) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Answer_Reference_UnstructuredDocumentInfo) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Answer_Reference_UnstructuredDocumentInfo) GetChunkContents() []*Answer_Reference_UnstructuredDocumentInfo_ChunkContent {
	if x != nil {
		return x.ChunkContents
	}
	return nil
}

func (x *Answer_Reference_UnstructuredDocumentInfo) GetStructData() *structpb.Struct {
	if x != nil {
		return x.StructData
	}
	return nil
}

// Chunk information.
type Answer_Reference_ChunkInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Chunk resource name.
	Chunk string `protobuf:"bytes,1,opt,name=chunk,proto3" json:"chunk,omitempty"`
	// Chunk textual content.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// The relevance of the chunk for a given query. Values range from 0.0
	// (completely irrelevant) to 1.0 (completely relevant).
	// This value is for informational purpose only. It may change for
	// the same query and chunk at any time due to a model retraining or
	// change in implementation.
	RelevanceScore *float32 `protobuf:"fixed32,3,opt,name=relevance_score,json=relevanceScore,proto3,oneof" json:"relevance_score,omitempty"`
	// Document metadata.
	DocumentMetadata *Answer_Reference_ChunkInfo_DocumentMetadata `protobuf:"bytes,4,opt,name=document_metadata,json=documentMetadata,proto3" json:"document_metadata,omitempty"`
}

func (x *Answer_Reference_ChunkInfo) Reset() {
	*x = Answer_Reference_ChunkInfo{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Reference_ChunkInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Reference_ChunkInfo) ProtoMessage() {}

func (x *Answer_Reference_ChunkInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Reference_ChunkInfo.ProtoReflect.Descriptor instead.
func (*Answer_Reference_ChunkInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 2, 1}
}

func (x *Answer_Reference_ChunkInfo) GetChunk() string {
	if x != nil {
		return x.Chunk
	}
	return ""
}

func (x *Answer_Reference_ChunkInfo) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *Answer_Reference_ChunkInfo) GetRelevanceScore() float32 {
	if x != nil && x.RelevanceScore != nil {
		return *x.RelevanceScore
	}
	return 0
}

func (x *Answer_Reference_ChunkInfo) GetDocumentMetadata() *Answer_Reference_ChunkInfo_DocumentMetadata {
	if x != nil {
		return x.DocumentMetadata
	}
	return nil
}

// Structured search information.
type Answer_Reference_StructuredDocumentInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Document resource name.
	Document string `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// Structured search data.
	StructData *structpb.Struct `protobuf:"bytes,2,opt,name=struct_data,json=structData,proto3" json:"struct_data,omitempty"`
}

func (x *Answer_Reference_StructuredDocumentInfo) Reset() {
	*x = Answer_Reference_StructuredDocumentInfo{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Reference_StructuredDocumentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Reference_StructuredDocumentInfo) ProtoMessage() {}

func (x *Answer_Reference_StructuredDocumentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Reference_StructuredDocumentInfo.ProtoReflect.Descriptor instead.
func (*Answer_Reference_StructuredDocumentInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 2, 2}
}

func (x *Answer_Reference_StructuredDocumentInfo) GetDocument() string {
	if x != nil {
		return x.Document
	}
	return ""
}

func (x *Answer_Reference_StructuredDocumentInfo) GetStructData() *structpb.Struct {
	if x != nil {
		return x.StructData
	}
	return nil
}

// Chunk content.
type Answer_Reference_UnstructuredDocumentInfo_ChunkContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Chunk textual content.
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Page identifier.
	PageIdentifier string `protobuf:"bytes,2,opt,name=page_identifier,json=pageIdentifier,proto3" json:"page_identifier,omitempty"`
	// The relevance of the chunk for a given query. Values range from 0.0
	// (completely irrelevant) to 1.0 (completely relevant).
	// This value is for informational purpose only. It may change for
	// the same query and chunk at any time due to a model retraining or
	// change in implementation.
	RelevanceScore *float32 `protobuf:"fixed32,3,opt,name=relevance_score,json=relevanceScore,proto3,oneof" json:"relevance_score,omitempty"`
}

func (x *Answer_Reference_UnstructuredDocumentInfo_ChunkContent) Reset() {
	*x = Answer_Reference_UnstructuredDocumentInfo_ChunkContent{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Reference_UnstructuredDocumentInfo_ChunkContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Reference_UnstructuredDocumentInfo_ChunkContent) ProtoMessage() {}

func (x *Answer_Reference_UnstructuredDocumentInfo_ChunkContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Reference_UnstructuredDocumentInfo_ChunkContent.ProtoReflect.Descriptor instead.
func (*Answer_Reference_UnstructuredDocumentInfo_ChunkContent) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 2, 0, 0}
}

func (x *Answer_Reference_UnstructuredDocumentInfo_ChunkContent) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *Answer_Reference_UnstructuredDocumentInfo_ChunkContent) GetPageIdentifier() string {
	if x != nil {
		return x.PageIdentifier
	}
	return ""
}

func (x *Answer_Reference_UnstructuredDocumentInfo_ChunkContent) GetRelevanceScore() float32 {
	if x != nil && x.RelevanceScore != nil {
		return *x.RelevanceScore
	}
	return 0
}

// Document metadata.
type Answer_Reference_ChunkInfo_DocumentMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Document resource name.
	Document string `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// URI for the document.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Title.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// Page identifier.
	PageIdentifier string `protobuf:"bytes,4,opt,name=page_identifier,json=pageIdentifier,proto3" json:"page_identifier,omitempty"`
	// The structured JSON metadata for the document.
	// It is populated from the struct data from the Chunk in search result.
	StructData *structpb.Struct `protobuf:"bytes,5,opt,name=struct_data,json=structData,proto3" json:"struct_data,omitempty"`
}

func (x *Answer_Reference_ChunkInfo_DocumentMetadata) Reset() {
	*x = Answer_Reference_ChunkInfo_DocumentMetadata{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Reference_ChunkInfo_DocumentMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Reference_ChunkInfo_DocumentMetadata) ProtoMessage() {}

func (x *Answer_Reference_ChunkInfo_DocumentMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Reference_ChunkInfo_DocumentMetadata.ProtoReflect.Descriptor instead.
func (*Answer_Reference_ChunkInfo_DocumentMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 2, 1, 0}
}

func (x *Answer_Reference_ChunkInfo_DocumentMetadata) GetDocument() string {
	if x != nil {
		return x.Document
	}
	return ""
}

func (x *Answer_Reference_ChunkInfo_DocumentMetadata) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Answer_Reference_ChunkInfo_DocumentMetadata) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Answer_Reference_ChunkInfo_DocumentMetadata) GetPageIdentifier() string {
	if x != nil {
		return x.PageIdentifier
	}
	return ""
}

func (x *Answer_Reference_ChunkInfo_DocumentMetadata) GetStructData() *structpb.Struct {
	if x != nil {
		return x.StructData
	}
	return nil
}

// Action.
type Answer_Step_Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The action.
	//
	// Types that are assignable to Action:
	//
	//	*Answer_Step_Action_SearchAction_
	Action isAnswer_Step_Action_Action `protobuf_oneof:"action"`
	// Observation.
	Observation *Answer_Step_Action_Observation `protobuf:"bytes,3,opt,name=observation,proto3" json:"observation,omitempty"`
}

func (x *Answer_Step_Action) Reset() {
	*x = Answer_Step_Action{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Step_Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Step_Action) ProtoMessage() {}

func (x *Answer_Step_Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Step_Action.ProtoReflect.Descriptor instead.
func (*Answer_Step_Action) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (m *Answer_Step_Action) GetAction() isAnswer_Step_Action_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *Answer_Step_Action) GetSearchAction() *Answer_Step_Action_SearchAction {
	if x, ok := x.GetAction().(*Answer_Step_Action_SearchAction_); ok {
		return x.SearchAction
	}
	return nil
}

func (x *Answer_Step_Action) GetObservation() *Answer_Step_Action_Observation {
	if x != nil {
		return x.Observation
	}
	return nil
}

type isAnswer_Step_Action_Action interface {
	isAnswer_Step_Action_Action()
}

type Answer_Step_Action_SearchAction_ struct {
	// Search action.
	SearchAction *Answer_Step_Action_SearchAction `protobuf:"bytes,2,opt,name=search_action,json=searchAction,proto3,oneof"`
}

func (*Answer_Step_Action_SearchAction_) isAnswer_Step_Action_Action() {}

// Search action.
type Answer_Step_Action_SearchAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The query to search.
	Query string `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
}

func (x *Answer_Step_Action_SearchAction) Reset() {
	*x = Answer_Step_Action_SearchAction{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Step_Action_SearchAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Step_Action_SearchAction) ProtoMessage() {}

func (x *Answer_Step_Action_SearchAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Step_Action_SearchAction.ProtoReflect.Descriptor instead.
func (*Answer_Step_Action_SearchAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 3, 0, 0}
}

func (x *Answer_Step_Action_SearchAction) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

// Observation.
type Answer_Step_Action_Observation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Search results observed by the search action, it can be snippets info
	// or chunk info, depending on the citation type set by the user.
	SearchResults []*Answer_Step_Action_Observation_SearchResult `protobuf:"bytes,2,rep,name=search_results,json=searchResults,proto3" json:"search_results,omitempty"`
}

func (x *Answer_Step_Action_Observation) Reset() {
	*x = Answer_Step_Action_Observation{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Step_Action_Observation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Step_Action_Observation) ProtoMessage() {}

func (x *Answer_Step_Action_Observation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Step_Action_Observation.ProtoReflect.Descriptor instead.
func (*Answer_Step_Action_Observation) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 3, 0, 1}
}

func (x *Answer_Step_Action_Observation) GetSearchResults() []*Answer_Step_Action_Observation_SearchResult {
	if x != nil {
		return x.SearchResults
	}
	return nil
}

type Answer_Step_Action_Observation_SearchResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Document resource name.
	Document string `protobuf:"bytes,1,opt,name=document,proto3" json:"document,omitempty"`
	// URI for the document.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Title.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// If citation_type is DOCUMENT_LEVEL_CITATION, populate document
	// level snippets.
	SnippetInfo []*Answer_Step_Action_Observation_SearchResult_SnippetInfo `protobuf:"bytes,4,rep,name=snippet_info,json=snippetInfo,proto3" json:"snippet_info,omitempty"`
	// If citation_type is CHUNK_LEVEL_CITATION and chunk mode is on,
	// populate chunk info.
	ChunkInfo []*Answer_Step_Action_Observation_SearchResult_ChunkInfo `protobuf:"bytes,5,rep,name=chunk_info,json=chunkInfo,proto3" json:"chunk_info,omitempty"`
	// Data representation.
	// The structured JSON data for the document.
	// It's populated from the struct data from the Document, or the
	// Chunk in search result.
	StructData *structpb.Struct `protobuf:"bytes,6,opt,name=struct_data,json=structData,proto3" json:"struct_data,omitempty"`
}

func (x *Answer_Step_Action_Observation_SearchResult) Reset() {
	*x = Answer_Step_Action_Observation_SearchResult{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Step_Action_Observation_SearchResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Step_Action_Observation_SearchResult) ProtoMessage() {}

func (x *Answer_Step_Action_Observation_SearchResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Step_Action_Observation_SearchResult.ProtoReflect.Descriptor instead.
func (*Answer_Step_Action_Observation_SearchResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 3, 0, 1, 0}
}

func (x *Answer_Step_Action_Observation_SearchResult) GetDocument() string {
	if x != nil {
		return x.Document
	}
	return ""
}

func (x *Answer_Step_Action_Observation_SearchResult) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Answer_Step_Action_Observation_SearchResult) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Answer_Step_Action_Observation_SearchResult) GetSnippetInfo() []*Answer_Step_Action_Observation_SearchResult_SnippetInfo {
	if x != nil {
		return x.SnippetInfo
	}
	return nil
}

func (x *Answer_Step_Action_Observation_SearchResult) GetChunkInfo() []*Answer_Step_Action_Observation_SearchResult_ChunkInfo {
	if x != nil {
		return x.ChunkInfo
	}
	return nil
}

func (x *Answer_Step_Action_Observation_SearchResult) GetStructData() *structpb.Struct {
	if x != nil {
		return x.StructData
	}
	return nil
}

// Snippet information.
type Answer_Step_Action_Observation_SearchResult_SnippetInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Snippet content.
	Snippet string `protobuf:"bytes,1,opt,name=snippet,proto3" json:"snippet,omitempty"`
	// Status of the snippet defined by the search team.
	SnippetStatus string `protobuf:"bytes,2,opt,name=snippet_status,json=snippetStatus,proto3" json:"snippet_status,omitempty"`
}

func (x *Answer_Step_Action_Observation_SearchResult_SnippetInfo) Reset() {
	*x = Answer_Step_Action_Observation_SearchResult_SnippetInfo{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Step_Action_Observation_SearchResult_SnippetInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Step_Action_Observation_SearchResult_SnippetInfo) ProtoMessage() {}

func (x *Answer_Step_Action_Observation_SearchResult_SnippetInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Step_Action_Observation_SearchResult_SnippetInfo.ProtoReflect.Descriptor instead.
func (*Answer_Step_Action_Observation_SearchResult_SnippetInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 3, 0, 1, 0, 0}
}

func (x *Answer_Step_Action_Observation_SearchResult_SnippetInfo) GetSnippet() string {
	if x != nil {
		return x.Snippet
	}
	return ""
}

func (x *Answer_Step_Action_Observation_SearchResult_SnippetInfo) GetSnippetStatus() string {
	if x != nil {
		return x.SnippetStatus
	}
	return ""
}

// Chunk information.
type Answer_Step_Action_Observation_SearchResult_ChunkInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Chunk resource name.
	Chunk string `protobuf:"bytes,1,opt,name=chunk,proto3" json:"chunk,omitempty"`
	// Chunk textual content.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// The relevance of the chunk for a given query. Values range from
	// 0.0 (completely irrelevant) to 1.0 (completely relevant).
	// This value is for informational purpose only. It may change for
	// the same query and chunk at any time due to a model retraining or
	// change in implementation.
	RelevanceScore *float32 `protobuf:"fixed32,3,opt,name=relevance_score,json=relevanceScore,proto3,oneof" json:"relevance_score,omitempty"`
}

func (x *Answer_Step_Action_Observation_SearchResult_ChunkInfo) Reset() {
	*x = Answer_Step_Action_Observation_SearchResult_ChunkInfo{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_Step_Action_Observation_SearchResult_ChunkInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_Step_Action_Observation_SearchResult_ChunkInfo) ProtoMessage() {}

func (x *Answer_Step_Action_Observation_SearchResult_ChunkInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_Step_Action_Observation_SearchResult_ChunkInfo.ProtoReflect.Descriptor instead.
func (*Answer_Step_Action_Observation_SearchResult_ChunkInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 3, 0, 1, 0, 1}
}

func (x *Answer_Step_Action_Observation_SearchResult_ChunkInfo) GetChunk() string {
	if x != nil {
		return x.Chunk
	}
	return ""
}

func (x *Answer_Step_Action_Observation_SearchResult_ChunkInfo) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *Answer_Step_Action_Observation_SearchResult_ChunkInfo) GetRelevanceScore() float32 {
	if x != nil && x.RelevanceScore != nil {
		return *x.RelevanceScore
	}
	return 0
}

// Query classification information.
type Answer_QueryUnderstandingInfo_QueryClassificationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Query classification type.
	Type Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.discoveryengine.v1beta.Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type" json:"type,omitempty"`
	// Classification output.
	Positive bool `protobuf:"varint,2,opt,name=positive,proto3" json:"positive,omitempty"`
}

func (x *Answer_QueryUnderstandingInfo_QueryClassificationInfo) Reset() {
	*x = Answer_QueryUnderstandingInfo_QueryClassificationInfo{}
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Answer_QueryUnderstandingInfo_QueryClassificationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Answer_QueryUnderstandingInfo_QueryClassificationInfo) ProtoMessage() {}

func (x *Answer_QueryUnderstandingInfo_QueryClassificationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Answer_QueryUnderstandingInfo_QueryClassificationInfo.ProtoReflect.Descriptor instead.
func (*Answer_QueryUnderstandingInfo_QueryClassificationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP(), []int{0, 4, 0}
}

func (x *Answer_QueryUnderstandingInfo_QueryClassificationInfo) GetType() Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type {
	if x != nil {
		return x.Type
	}
	return Answer_QueryUnderstandingInfo_QueryClassificationInfo_TYPE_UNSPECIFIED
}

func (x *Answer_QueryUnderstandingInfo_QueryClassificationInfo) GetPositive() bool {
	if x != nil {
		return x.Positive
	}
	return false
}

var File_google_cloud_discoveryengine_v1beta_answer_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1beta_answer_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xf3, 0x28, 0x0a, 0x06, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x54, 0x65, 0x78, 0x74,
	0x12, 0x52, 0x0a, 0x09, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x2e, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x63, 0x69, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x55, 0x0a, 0x0a, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x0a, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x72,
	0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x51,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73,
	0x12, 0x7c, 0x0a, 0x18, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73,
	0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x55, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x16, 0x71, 0x75, 0x65, 0x72, 0x79, 0x55, 0x6e, 0x64,
	0x65, 0x72, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x75,
	0x0a, 0x16, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64,
	0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52,
	0x14, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53, 0x6b, 0x69, 0x70, 0x70, 0x65, 0x64, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x9e, 0x01,
	0x0a, 0x08, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1b, 0x0a, 0x09, 0x65,
	0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08,
	0x65, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x54, 0x0a, 0x07, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x33,
	0x0a, 0x0e, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x49, 0x64, 0x1a, 0xab, 0x0c, 0x0a, 0x09, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x8e, 0x01, 0x0a, 0x1a, 0x75, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
	0x65, 0x64, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x55, 0x6e,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x18, 0x75, 0x6e, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x60, 0x0a, 0x0a, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x43, 0x68,
	0x75, 0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x09, 0x63, 0x68, 0x75, 0x6e, 0x6b,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x88, 0x01, 0x0a, 0x18, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x16, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x1a,
	0xe1, 0x03, 0x0a, 0x18, 0x55, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x48, 0x0a, 0x08,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x82,
	0x01, 0x0a, 0x0e, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x55,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x38, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x0a, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x1a, 0x93, 0x01,
	0x0a, 0x0c, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x18,
	0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0e, 0x70, 0x61, 0x67, 0x65, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x12, 0x2c, 0x0a, 0x0f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0e, 0x72, 0x65,
	0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x42,
	0x12, 0x0a, 0x10, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63,
	0x6f, 0x72, 0x65, 0x1a, 0x91, 0x04, 0x0a, 0x09, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x3f, 0x0a, 0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x05, 0x63, 0x68, 0x75,
	0x6e, 0x6b, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x0f,
	0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0e, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x7d, 0x0a, 0x11, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x2e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x10, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0xe7, 0x01, 0x0a, 0x10, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x48,
	0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2c, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
	0x69, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x61, 0x67, 0x65, 0x49,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x38, 0x0a, 0x0b, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x1a, 0x9c, 0x01, 0x0a, 0x16, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x48, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x0b,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x44, 0x61, 0x74, 0x61, 0x42, 0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x1a, 0xa1, 0x0a, 0x0a, 0x04, 0x53, 0x74, 0x65, 0x70, 0x12, 0x4c, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x74, 0x68,
	0x6f, 0x75, 0x67, 0x68, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x68, 0x6f,
	0x75, 0x67, 0x68, 0x74, 0x12, 0x51, 0x0a, 0x07, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xef, 0x07, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x6b, 0x0a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x65, 0x0a, 0x0b, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x62,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x6f, 0x62, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x24, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x1a, 0xe0, 0x05, 0x0a,
	0x0b, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x77, 0x0a, 0x0e,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x62,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0xd7, 0x04, 0x0a, 0x0c, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x75, 0x72, 0x69, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x7f, 0x0a, 0x0c, 0x73, 0x6e,
	0x69, 0x70, 0x70, 0x65, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x53, 0x74,
	0x65, 0x70, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x2e, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b,
	0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x79, 0x0a, 0x0a, 0x63,
	0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x53, 0x74, 0x65,
	0x70, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x63, 0x68, 0x75,
	0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x38, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x1a, 0x4e, 0x0a, 0x0b, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x18, 0x0a, 0x07, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x6e, 0x69,
	0x70, 0x70, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x1a, 0x7d, 0x0a, 0x09, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x14, 0x0a,
	0x05, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x63, 0x68,
	0x75, 0x6e, 0x6b, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a,
	0x0f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x0e, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61,
	0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42,
	0x08, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4a, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f,
	0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45,
	0x44, 0x45, 0x44, 0x10, 0x03, 0x1a, 0xec, 0x03, 0x0a, 0x16, 0x51, 0x75, 0x65, 0x72, 0x79, 0x55,
	0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x96, 0x01, 0x0a, 0x19, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x55, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x17, 0x71, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0xb8, 0x02, 0x0a, 0x17, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x73, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x5f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x55, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x70, 0x6f,
	0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x22, 0x8b, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x44, 0x56, 0x45, 0x52, 0x53, 0x41,
	0x52, 0x49, 0x41, 0x4c, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x1c, 0x0a, 0x18,
	0x4e, 0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x53, 0x57, 0x45, 0x52, 0x5f, 0x53, 0x45, 0x45, 0x4b, 0x49,
	0x4e, 0x47, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x4a, 0x41,
	0x49, 0x4c, 0x5f, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x51, 0x55, 0x45, 0x52,
	0x59, 0x10, 0x03, 0x12, 0x1f, 0x0a, 0x1b, 0x4e, 0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x53, 0x57, 0x45,
	0x52, 0x5f, 0x53, 0x45, 0x45, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f,
	0x56, 0x32, 0x10, 0x04, 0x22, 0x4a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52,
	0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03,
	0x22, 0xdd, 0x02, 0x0a, 0x13, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53, 0x6b, 0x69, 0x70, 0x70,
	0x65, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x21, 0x41, 0x4e, 0x53, 0x57,
	0x45, 0x52, 0x5f, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f,
	0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x1d, 0x0a, 0x19, 0x41, 0x44, 0x56, 0x45, 0x52, 0x53, 0x41, 0x52, 0x49, 0x41, 0x4c, 0x5f, 0x51,
	0x55, 0x45, 0x52, 0x59, 0x5f, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x44, 0x10, 0x01, 0x12, 0x24,
	0x0a, 0x20, 0x4e, 0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x53, 0x57, 0x45, 0x52, 0x5f, 0x53, 0x45, 0x45,
	0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x49, 0x47, 0x4e, 0x4f, 0x52,
	0x45, 0x44, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x4f, 0x55, 0x54, 0x5f, 0x4f, 0x46, 0x5f, 0x44,
	0x4f, 0x4d, 0x41, 0x49, 0x4e, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x49, 0x47, 0x4e, 0x4f,
	0x52, 0x45, 0x44, 0x10, 0x03, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x4f, 0x54, 0x45, 0x4e, 0x54, 0x49,
	0x41, 0x4c, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x56, 0x49, 0x4f, 0x4c, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x4e, 0x4f, 0x5f, 0x52, 0x45, 0x4c, 0x45,
	0x56, 0x41, 0x4e, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x05, 0x12, 0x1f,
	0x0a, 0x1b, 0x4a, 0x41, 0x49, 0x4c, 0x5f, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x49, 0x4e, 0x47, 0x5f,
	0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x44, 0x10, 0x06, 0x12,
	0x1d, 0x0a, 0x19, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x50, 0x4f, 0x4c, 0x49,
	0x43, 0x59, 0x5f, 0x56, 0x49, 0x4f, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x07, 0x12, 0x27,
	0x0a, 0x23, 0x4e, 0x4f, 0x4e, 0x5f, 0x41, 0x4e, 0x53, 0x57, 0x45, 0x52, 0x5f, 0x53, 0x45, 0x45,
	0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x51, 0x55, 0x45, 0x52, 0x59, 0x5f, 0x49, 0x47, 0x4e, 0x4f, 0x52,
	0x45, 0x44, 0x5f, 0x56, 0x32, 0x10, 0x08, 0x12, 0x17, 0x0a, 0x13, 0x4c, 0x4f, 0x57, 0x5f, 0x47,
	0x52, 0x4f, 0x55, 0x4e, 0x44, 0x45, 0x44, 0x5f, 0x41, 0x4e, 0x53, 0x57, 0x45, 0x52, 0x10, 0x09,
	0x3a, 0x85, 0x03, 0xea, 0x41, 0x81, 0x03, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x63,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x7d, 0x12, 0x7c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c,
	0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73,
	0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x2f, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x7d, 0x12, 0x75, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x2f,
	0x7b, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x7d, 0x42, 0x92, 0x02, 0x0a, 0x27, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x42, 0x0b, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x51, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45,
	0x52, 0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02,
	0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31,
	0x62, 0x65, 0x74, 0x61, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescData = file_google_cloud_discoveryengine_v1beta_answer_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1beta_answer_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1beta_answer_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_discoveryengine_v1beta_answer_proto_goTypes = []any{
	(Answer_State)(0),               // 0: google.cloud.discoveryengine.v1beta.Answer.State
	(Answer_AnswerSkippedReason)(0), // 1: google.cloud.discoveryengine.v1beta.Answer.AnswerSkippedReason
	(Answer_Step_State)(0),          // 2: google.cloud.discoveryengine.v1beta.Answer.Step.State
	(Answer_QueryUnderstandingInfo_QueryClassificationInfo_Type)(0), // 3: google.cloud.discoveryengine.v1beta.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type
	(*Answer)(nil),                                                  // 4: google.cloud.discoveryengine.v1beta.Answer
	(*Answer_Citation)(nil),                                         // 5: google.cloud.discoveryengine.v1beta.Answer.Citation
	(*Answer_CitationSource)(nil),                                   // 6: google.cloud.discoveryengine.v1beta.Answer.CitationSource
	(*Answer_Reference)(nil),                                        // 7: google.cloud.discoveryengine.v1beta.Answer.Reference
	(*Answer_Step)(nil),                                             // 8: google.cloud.discoveryengine.v1beta.Answer.Step
	(*Answer_QueryUnderstandingInfo)(nil),                           // 9: google.cloud.discoveryengine.v1beta.Answer.QueryUnderstandingInfo
	(*Answer_Reference_UnstructuredDocumentInfo)(nil),               // 10: google.cloud.discoveryengine.v1beta.Answer.Reference.UnstructuredDocumentInfo
	(*Answer_Reference_ChunkInfo)(nil),                              // 11: google.cloud.discoveryengine.v1beta.Answer.Reference.ChunkInfo
	(*Answer_Reference_StructuredDocumentInfo)(nil),                 // 12: google.cloud.discoveryengine.v1beta.Answer.Reference.StructuredDocumentInfo
	(*Answer_Reference_UnstructuredDocumentInfo_ChunkContent)(nil),  // 13: google.cloud.discoveryengine.v1beta.Answer.Reference.UnstructuredDocumentInfo.ChunkContent
	(*Answer_Reference_ChunkInfo_DocumentMetadata)(nil),             // 14: google.cloud.discoveryengine.v1beta.Answer.Reference.ChunkInfo.DocumentMetadata
	(*Answer_Step_Action)(nil),                                      // 15: google.cloud.discoveryengine.v1beta.Answer.Step.Action
	(*Answer_Step_Action_SearchAction)(nil),                         // 16: google.cloud.discoveryengine.v1beta.Answer.Step.Action.SearchAction
	(*Answer_Step_Action_Observation)(nil),                          // 17: google.cloud.discoveryengine.v1beta.Answer.Step.Action.Observation
	(*Answer_Step_Action_Observation_SearchResult)(nil),             // 18: google.cloud.discoveryengine.v1beta.Answer.Step.Action.Observation.SearchResult
	(*Answer_Step_Action_Observation_SearchResult_SnippetInfo)(nil), // 19: google.cloud.discoveryengine.v1beta.Answer.Step.Action.Observation.SearchResult.SnippetInfo
	(*Answer_Step_Action_Observation_SearchResult_ChunkInfo)(nil),   // 20: google.cloud.discoveryengine.v1beta.Answer.Step.Action.Observation.SearchResult.ChunkInfo
	(*Answer_QueryUnderstandingInfo_QueryClassificationInfo)(nil),   // 21: google.cloud.discoveryengine.v1beta.Answer.QueryUnderstandingInfo.QueryClassificationInfo
	(*timestamppb.Timestamp)(nil),                                   // 22: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                                         // 23: google.protobuf.Struct
}
var file_google_cloud_discoveryengine_v1beta_answer_proto_depIdxs = []int32{
	0,  // 0: google.cloud.discoveryengine.v1beta.Answer.state:type_name -> google.cloud.discoveryengine.v1beta.Answer.State
	5,  // 1: google.cloud.discoveryengine.v1beta.Answer.citations:type_name -> google.cloud.discoveryengine.v1beta.Answer.Citation
	7,  // 2: google.cloud.discoveryengine.v1beta.Answer.references:type_name -> google.cloud.discoveryengine.v1beta.Answer.Reference
	8,  // 3: google.cloud.discoveryengine.v1beta.Answer.steps:type_name -> google.cloud.discoveryengine.v1beta.Answer.Step
	9,  // 4: google.cloud.discoveryengine.v1beta.Answer.query_understanding_info:type_name -> google.cloud.discoveryengine.v1beta.Answer.QueryUnderstandingInfo
	1,  // 5: google.cloud.discoveryengine.v1beta.Answer.answer_skipped_reasons:type_name -> google.cloud.discoveryengine.v1beta.Answer.AnswerSkippedReason
	22, // 6: google.cloud.discoveryengine.v1beta.Answer.create_time:type_name -> google.protobuf.Timestamp
	22, // 7: google.cloud.discoveryengine.v1beta.Answer.complete_time:type_name -> google.protobuf.Timestamp
	6,  // 8: google.cloud.discoveryengine.v1beta.Answer.Citation.sources:type_name -> google.cloud.discoveryengine.v1beta.Answer.CitationSource
	10, // 9: google.cloud.discoveryengine.v1beta.Answer.Reference.unstructured_document_info:type_name -> google.cloud.discoveryengine.v1beta.Answer.Reference.UnstructuredDocumentInfo
	11, // 10: google.cloud.discoveryengine.v1beta.Answer.Reference.chunk_info:type_name -> google.cloud.discoveryengine.v1beta.Answer.Reference.ChunkInfo
	12, // 11: google.cloud.discoveryengine.v1beta.Answer.Reference.structured_document_info:type_name -> google.cloud.discoveryengine.v1beta.Answer.Reference.StructuredDocumentInfo
	2,  // 12: google.cloud.discoveryengine.v1beta.Answer.Step.state:type_name -> google.cloud.discoveryengine.v1beta.Answer.Step.State
	15, // 13: google.cloud.discoveryengine.v1beta.Answer.Step.actions:type_name -> google.cloud.discoveryengine.v1beta.Answer.Step.Action
	21, // 14: google.cloud.discoveryengine.v1beta.Answer.QueryUnderstandingInfo.query_classification_info:type_name -> google.cloud.discoveryengine.v1beta.Answer.QueryUnderstandingInfo.QueryClassificationInfo
	13, // 15: google.cloud.discoveryengine.v1beta.Answer.Reference.UnstructuredDocumentInfo.chunk_contents:type_name -> google.cloud.discoveryengine.v1beta.Answer.Reference.UnstructuredDocumentInfo.ChunkContent
	23, // 16: google.cloud.discoveryengine.v1beta.Answer.Reference.UnstructuredDocumentInfo.struct_data:type_name -> google.protobuf.Struct
	14, // 17: google.cloud.discoveryengine.v1beta.Answer.Reference.ChunkInfo.document_metadata:type_name -> google.cloud.discoveryengine.v1beta.Answer.Reference.ChunkInfo.DocumentMetadata
	23, // 18: google.cloud.discoveryengine.v1beta.Answer.Reference.StructuredDocumentInfo.struct_data:type_name -> google.protobuf.Struct
	23, // 19: google.cloud.discoveryengine.v1beta.Answer.Reference.ChunkInfo.DocumentMetadata.struct_data:type_name -> google.protobuf.Struct
	16, // 20: google.cloud.discoveryengine.v1beta.Answer.Step.Action.search_action:type_name -> google.cloud.discoveryengine.v1beta.Answer.Step.Action.SearchAction
	17, // 21: google.cloud.discoveryengine.v1beta.Answer.Step.Action.observation:type_name -> google.cloud.discoveryengine.v1beta.Answer.Step.Action.Observation
	18, // 22: google.cloud.discoveryengine.v1beta.Answer.Step.Action.Observation.search_results:type_name -> google.cloud.discoveryengine.v1beta.Answer.Step.Action.Observation.SearchResult
	19, // 23: google.cloud.discoveryengine.v1beta.Answer.Step.Action.Observation.SearchResult.snippet_info:type_name -> google.cloud.discoveryengine.v1beta.Answer.Step.Action.Observation.SearchResult.SnippetInfo
	20, // 24: google.cloud.discoveryengine.v1beta.Answer.Step.Action.Observation.SearchResult.chunk_info:type_name -> google.cloud.discoveryengine.v1beta.Answer.Step.Action.Observation.SearchResult.ChunkInfo
	23, // 25: google.cloud.discoveryengine.v1beta.Answer.Step.Action.Observation.SearchResult.struct_data:type_name -> google.protobuf.Struct
	3,  // 26: google.cloud.discoveryengine.v1beta.Answer.QueryUnderstandingInfo.QueryClassificationInfo.type:type_name -> google.cloud.discoveryengine.v1beta.Answer.QueryUnderstandingInfo.QueryClassificationInfo.Type
	27, // [27:27] is the sub-list for method output_type
	27, // [27:27] is the sub-list for method input_type
	27, // [27:27] is the sub-list for extension type_name
	27, // [27:27] is the sub-list for extension extendee
	0,  // [0:27] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1beta_answer_proto_init() }
func file_google_cloud_discoveryengine_v1beta_answer_proto_init() {
	if File_google_cloud_discoveryengine_v1beta_answer_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[3].OneofWrappers = []any{
		(*Answer_Reference_UnstructuredDocumentInfo_)(nil),
		(*Answer_Reference_ChunkInfo_)(nil),
		(*Answer_Reference_StructuredDocumentInfo_)(nil),
	}
	file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[7].OneofWrappers = []any{}
	file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[9].OneofWrappers = []any{}
	file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[11].OneofWrappers = []any{
		(*Answer_Step_Action_SearchAction_)(nil),
	}
	file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes[16].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1beta_answer_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1beta_answer_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1beta_answer_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1beta_answer_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1beta_answer_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1beta_answer_proto = out.File
	file_google_cloud_discoveryengine_v1beta_answer_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1beta_answer_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1beta_answer_proto_depIdxs = nil
}
