// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/clouddms/v1/conversionworkspace_resources.proto

package clouddmspb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum used by ValueListFilter to indicate whether the source value is in the
// supplied list
type ValuePresentInList int32

const (
	// Value present in list unspecified
	ValuePresentInList_VALUE_PRESENT_IN_LIST_UNSPECIFIED ValuePresentInList = 0
	// If the source value is in the supplied list at value_list
	ValuePresentInList_VALUE_PRESENT_IN_LIST_IF_VALUE_LIST ValuePresentInList = 1
	// If the source value is not in the supplied list at value_list
	ValuePresentInList_VALUE_PRESENT_IN_LIST_IF_VALUE_NOT_LIST ValuePresentInList = 2
)

// Enum value maps for ValuePresentInList.
var (
	ValuePresentInList_name = map[int32]string{
		0: "VALUE_PRESENT_IN_LIST_UNSPECIFIED",
		1: "VALUE_PRESENT_IN_LIST_IF_VALUE_LIST",
		2: "VALUE_PRESENT_IN_LIST_IF_VALUE_NOT_LIST",
	}
	ValuePresentInList_value = map[string]int32{
		"VALUE_PRESENT_IN_LIST_UNSPECIFIED":       0,
		"VALUE_PRESENT_IN_LIST_IF_VALUE_LIST":     1,
		"VALUE_PRESENT_IN_LIST_IF_VALUE_NOT_LIST": 2,
	}
)

func (x ValuePresentInList) Enum() *ValuePresentInList {
	p := new(ValuePresentInList)
	*p = x
	return p
}

func (x ValuePresentInList) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ValuePresentInList) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[0].Descriptor()
}

func (ValuePresentInList) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[0]
}

func (x ValuePresentInList) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ValuePresentInList.Descriptor instead.
func (ValuePresentInList) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{0}
}

// The type of database entities supported,
type DatabaseEntityType int32

const (
	// Unspecified database entity type.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED DatabaseEntityType = 0
	// Schema.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_SCHEMA DatabaseEntityType = 1
	// Table.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_TABLE DatabaseEntityType = 2
	// Column.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_COLUMN DatabaseEntityType = 3
	// Constraint.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_CONSTRAINT DatabaseEntityType = 4
	// Index.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_INDEX DatabaseEntityType = 5
	// Trigger.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_TRIGGER DatabaseEntityType = 6
	// View.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_VIEW DatabaseEntityType = 7
	// Sequence.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_SEQUENCE DatabaseEntityType = 8
	// Stored Procedure.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_STORED_PROCEDURE DatabaseEntityType = 9
	// Function.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_FUNCTION DatabaseEntityType = 10
	// Synonym.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_SYNONYM DatabaseEntityType = 11
	// Package.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_DATABASE_PACKAGE DatabaseEntityType = 12
	// UDT.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_UDT DatabaseEntityType = 13
	// Materialized View.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_MATERIALIZED_VIEW DatabaseEntityType = 14
	// Database.
	DatabaseEntityType_DATABASE_ENTITY_TYPE_DATABASE DatabaseEntityType = 15
)

// Enum value maps for DatabaseEntityType.
var (
	DatabaseEntityType_name = map[int32]string{
		0:  "DATABASE_ENTITY_TYPE_UNSPECIFIED",
		1:  "DATABASE_ENTITY_TYPE_SCHEMA",
		2:  "DATABASE_ENTITY_TYPE_TABLE",
		3:  "DATABASE_ENTITY_TYPE_COLUMN",
		4:  "DATABASE_ENTITY_TYPE_CONSTRAINT",
		5:  "DATABASE_ENTITY_TYPE_INDEX",
		6:  "DATABASE_ENTITY_TYPE_TRIGGER",
		7:  "DATABASE_ENTITY_TYPE_VIEW",
		8:  "DATABASE_ENTITY_TYPE_SEQUENCE",
		9:  "DATABASE_ENTITY_TYPE_STORED_PROCEDURE",
		10: "DATABASE_ENTITY_TYPE_FUNCTION",
		11: "DATABASE_ENTITY_TYPE_SYNONYM",
		12: "DATABASE_ENTITY_TYPE_DATABASE_PACKAGE",
		13: "DATABASE_ENTITY_TYPE_UDT",
		14: "DATABASE_ENTITY_TYPE_MATERIALIZED_VIEW",
		15: "DATABASE_ENTITY_TYPE_DATABASE",
	}
	DatabaseEntityType_value = map[string]int32{
		"DATABASE_ENTITY_TYPE_UNSPECIFIED":       0,
		"DATABASE_ENTITY_TYPE_SCHEMA":            1,
		"DATABASE_ENTITY_TYPE_TABLE":             2,
		"DATABASE_ENTITY_TYPE_COLUMN":            3,
		"DATABASE_ENTITY_TYPE_CONSTRAINT":        4,
		"DATABASE_ENTITY_TYPE_INDEX":             5,
		"DATABASE_ENTITY_TYPE_TRIGGER":           6,
		"DATABASE_ENTITY_TYPE_VIEW":              7,
		"DATABASE_ENTITY_TYPE_SEQUENCE":          8,
		"DATABASE_ENTITY_TYPE_STORED_PROCEDURE":  9,
		"DATABASE_ENTITY_TYPE_FUNCTION":          10,
		"DATABASE_ENTITY_TYPE_SYNONYM":           11,
		"DATABASE_ENTITY_TYPE_DATABASE_PACKAGE":  12,
		"DATABASE_ENTITY_TYPE_UDT":               13,
		"DATABASE_ENTITY_TYPE_MATERIALIZED_VIEW": 14,
		"DATABASE_ENTITY_TYPE_DATABASE":          15,
	}
)

func (x DatabaseEntityType) Enum() *DatabaseEntityType {
	p := new(DatabaseEntityType)
	*p = x
	return p
}

func (x DatabaseEntityType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseEntityType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[1].Descriptor()
}

func (DatabaseEntityType) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[1]
}

func (x DatabaseEntityType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseEntityType.Descriptor instead.
func (DatabaseEntityType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{1}
}

// Entity Name Transformation Types
type EntityNameTransformation int32

const (
	// Entity name transformation unspecified.
	EntityNameTransformation_ENTITY_NAME_TRANSFORMATION_UNSPECIFIED EntityNameTransformation = 0
	// No transformation.
	EntityNameTransformation_ENTITY_NAME_TRANSFORMATION_NO_TRANSFORMATION EntityNameTransformation = 1
	// Transform to lower case.
	EntityNameTransformation_ENTITY_NAME_TRANSFORMATION_LOWER_CASE EntityNameTransformation = 2
	// Transform to upper case.
	EntityNameTransformation_ENTITY_NAME_TRANSFORMATION_UPPER_CASE EntityNameTransformation = 3
	// Transform to capitalized case.
	EntityNameTransformation_ENTITY_NAME_TRANSFORMATION_CAPITALIZED_CASE EntityNameTransformation = 4
)

// Enum value maps for EntityNameTransformation.
var (
	EntityNameTransformation_name = map[int32]string{
		0: "ENTITY_NAME_TRANSFORMATION_UNSPECIFIED",
		1: "ENTITY_NAME_TRANSFORMATION_NO_TRANSFORMATION",
		2: "ENTITY_NAME_TRANSFORMATION_LOWER_CASE",
		3: "ENTITY_NAME_TRANSFORMATION_UPPER_CASE",
		4: "ENTITY_NAME_TRANSFORMATION_CAPITALIZED_CASE",
	}
	EntityNameTransformation_value = map[string]int32{
		"ENTITY_NAME_TRANSFORMATION_UNSPECIFIED":       0,
		"ENTITY_NAME_TRANSFORMATION_NO_TRANSFORMATION": 1,
		"ENTITY_NAME_TRANSFORMATION_LOWER_CASE":        2,
		"ENTITY_NAME_TRANSFORMATION_UPPER_CASE":        3,
		"ENTITY_NAME_TRANSFORMATION_CAPITALIZED_CASE":  4,
	}
)

func (x EntityNameTransformation) Enum() *EntityNameTransformation {
	p := new(EntityNameTransformation)
	*p = x
	return p
}

func (x EntityNameTransformation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntityNameTransformation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[2].Descriptor()
}

func (EntityNameTransformation) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[2]
}

func (x EntityNameTransformation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntityNameTransformation.Descriptor instead.
func (EntityNameTransformation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2}
}

// The types of jobs that can be executed in the background.
type BackgroundJobType int32

const (
	// Unspecified background job type.
	BackgroundJobType_BACKGROUND_JOB_TYPE_UNSPECIFIED BackgroundJobType = 0
	// Job to seed from the source database.
	BackgroundJobType_BACKGROUND_JOB_TYPE_SOURCE_SEED BackgroundJobType = 1
	// Job to convert the source database into a draft of the destination
	// database.
	BackgroundJobType_BACKGROUND_JOB_TYPE_CONVERT BackgroundJobType = 2
	// Job to apply the draft tree onto the destination.
	BackgroundJobType_BACKGROUND_JOB_TYPE_APPLY_DESTINATION BackgroundJobType = 3
	// Job to import and convert mapping rules from an external source such as an
	// ora2pg config file.
	BackgroundJobType_BACKGROUND_JOB_TYPE_IMPORT_RULES_FILE BackgroundJobType = 5
)

// Enum value maps for BackgroundJobType.
var (
	BackgroundJobType_name = map[int32]string{
		0: "BACKGROUND_JOB_TYPE_UNSPECIFIED",
		1: "BACKGROUND_JOB_TYPE_SOURCE_SEED",
		2: "BACKGROUND_JOB_TYPE_CONVERT",
		3: "BACKGROUND_JOB_TYPE_APPLY_DESTINATION",
		5: "BACKGROUND_JOB_TYPE_IMPORT_RULES_FILE",
	}
	BackgroundJobType_value = map[string]int32{
		"BACKGROUND_JOB_TYPE_UNSPECIFIED":       0,
		"BACKGROUND_JOB_TYPE_SOURCE_SEED":       1,
		"BACKGROUND_JOB_TYPE_CONVERT":           2,
		"BACKGROUND_JOB_TYPE_APPLY_DESTINATION": 3,
		"BACKGROUND_JOB_TYPE_IMPORT_RULES_FILE": 5,
	}
)

func (x BackgroundJobType) Enum() *BackgroundJobType {
	p := new(BackgroundJobType)
	*p = x
	return p
}

func (x BackgroundJobType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackgroundJobType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[3].Descriptor()
}

func (BackgroundJobType) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[3]
}

func (x BackgroundJobType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackgroundJobType.Descriptor instead.
func (BackgroundJobType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{3}
}

// The format for the import rules file.
type ImportRulesFileFormat int32

const (
	// Unspecified rules format.
	ImportRulesFileFormat_IMPORT_RULES_FILE_FORMAT_UNSPECIFIED ImportRulesFileFormat = 0
	// HarbourBridge session file.
	ImportRulesFileFormat_IMPORT_RULES_FILE_FORMAT_HARBOUR_BRIDGE_SESSION_FILE ImportRulesFileFormat = 1
	// Ora2Pg configuration file.
	ImportRulesFileFormat_IMPORT_RULES_FILE_FORMAT_ORATOPG_CONFIG_FILE ImportRulesFileFormat = 2
)

// Enum value maps for ImportRulesFileFormat.
var (
	ImportRulesFileFormat_name = map[int32]string{
		0: "IMPORT_RULES_FILE_FORMAT_UNSPECIFIED",
		1: "IMPORT_RULES_FILE_FORMAT_HARBOUR_BRIDGE_SESSION_FILE",
		2: "IMPORT_RULES_FILE_FORMAT_ORATOPG_CONFIG_FILE",
	}
	ImportRulesFileFormat_value = map[string]int32{
		"IMPORT_RULES_FILE_FORMAT_UNSPECIFIED":                 0,
		"IMPORT_RULES_FILE_FORMAT_HARBOUR_BRIDGE_SESSION_FILE": 1,
		"IMPORT_RULES_FILE_FORMAT_ORATOPG_CONFIG_FILE":         2,
	}
)

func (x ImportRulesFileFormat) Enum() *ImportRulesFileFormat {
	p := new(ImportRulesFileFormat)
	*p = x
	return p
}

func (x ImportRulesFileFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportRulesFileFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[4].Descriptor()
}

func (ImportRulesFileFormat) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[4]
}

func (x ImportRulesFileFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportRulesFileFormat.Descriptor instead.
func (ImportRulesFileFormat) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{4}
}

// Enum used by IntComparisonFilter and DoubleComparisonFilter to indicate the
// relation between source value and compare value.
type ValueComparison int32

const (
	// Value comparison unspecified.
	ValueComparison_VALUE_COMPARISON_UNSPECIFIED ValueComparison = 0
	// Value is smaller than the Compare value.
	ValueComparison_VALUE_COMPARISON_IF_VALUE_SMALLER_THAN ValueComparison = 1
	// Value is smaller or equal than the Compare value.
	ValueComparison_VALUE_COMPARISON_IF_VALUE_SMALLER_EQUAL_THAN ValueComparison = 2
	// Value is larger than the Compare value.
	ValueComparison_VALUE_COMPARISON_IF_VALUE_LARGER_THAN ValueComparison = 3
	// Value is larger or equal than the Compare value.
	ValueComparison_VALUE_COMPARISON_IF_VALUE_LARGER_EQUAL_THAN ValueComparison = 4
)

// Enum value maps for ValueComparison.
var (
	ValueComparison_name = map[int32]string{
		0: "VALUE_COMPARISON_UNSPECIFIED",
		1: "VALUE_COMPARISON_IF_VALUE_SMALLER_THAN",
		2: "VALUE_COMPARISON_IF_VALUE_SMALLER_EQUAL_THAN",
		3: "VALUE_COMPARISON_IF_VALUE_LARGER_THAN",
		4: "VALUE_COMPARISON_IF_VALUE_LARGER_EQUAL_THAN",
	}
	ValueComparison_value = map[string]int32{
		"VALUE_COMPARISON_UNSPECIFIED":                 0,
		"VALUE_COMPARISON_IF_VALUE_SMALLER_THAN":       1,
		"VALUE_COMPARISON_IF_VALUE_SMALLER_EQUAL_THAN": 2,
		"VALUE_COMPARISON_IF_VALUE_LARGER_THAN":        3,
		"VALUE_COMPARISON_IF_VALUE_LARGER_EQUAL_THAN":  4,
	}
)

func (x ValueComparison) Enum() *ValueComparison {
	p := new(ValueComparison)
	*p = x
	return p
}

func (x ValueComparison) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ValueComparison) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[5].Descriptor()
}

func (ValueComparison) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[5]
}

func (x ValueComparison) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ValueComparison.Descriptor instead.
func (ValueComparison) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{5}
}

// Specifies the columns on which numeric filter needs to be applied.
type NumericFilterOption int32

const (
	// Numeric filter option unspecified
	NumericFilterOption_NUMERIC_FILTER_OPTION_UNSPECIFIED NumericFilterOption = 0
	// Numeric filter option that matches all numeric columns.
	NumericFilterOption_NUMERIC_FILTER_OPTION_ALL NumericFilterOption = 1
	// Numeric filter option that matches columns having numeric datatypes with
	// specified precision and scale within the limited range of filter.
	NumericFilterOption_NUMERIC_FILTER_OPTION_LIMIT NumericFilterOption = 2
	// Numeric filter option that matches only the numeric columns with no
	// precision and scale specified.
	NumericFilterOption_NUMERIC_FILTER_OPTION_LIMITLESS NumericFilterOption = 3
)

// Enum value maps for NumericFilterOption.
var (
	NumericFilterOption_name = map[int32]string{
		0: "NUMERIC_FILTER_OPTION_UNSPECIFIED",
		1: "NUMERIC_FILTER_OPTION_ALL",
		2: "NUMERIC_FILTER_OPTION_LIMIT",
		3: "NUMERIC_FILTER_OPTION_LIMITLESS",
	}
	NumericFilterOption_value = map[string]int32{
		"NUMERIC_FILTER_OPTION_UNSPECIFIED": 0,
		"NUMERIC_FILTER_OPTION_ALL":         1,
		"NUMERIC_FILTER_OPTION_LIMIT":       2,
		"NUMERIC_FILTER_OPTION_LIMITLESS":   3,
	}
)

func (x NumericFilterOption) Enum() *NumericFilterOption {
	p := new(NumericFilterOption)
	*p = x
	return p
}

func (x NumericFilterOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NumericFilterOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[6].Descriptor()
}

func (NumericFilterOption) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[6]
}

func (x NumericFilterOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NumericFilterOption.Descriptor instead.
func (NumericFilterOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{6}
}

// Final state after a job completes.
type BackgroundJobLogEntry_JobCompletionState int32

const (
	// The status is not specified. This state is used when job is not yet
	// finished.
	BackgroundJobLogEntry_JOB_COMPLETION_STATE_UNSPECIFIED BackgroundJobLogEntry_JobCompletionState = 0
	// Success.
	BackgroundJobLogEntry_SUCCEEDED BackgroundJobLogEntry_JobCompletionState = 1
	// Error.
	BackgroundJobLogEntry_FAILED BackgroundJobLogEntry_JobCompletionState = 2
)

// Enum value maps for BackgroundJobLogEntry_JobCompletionState.
var (
	BackgroundJobLogEntry_JobCompletionState_name = map[int32]string{
		0: "JOB_COMPLETION_STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
	}
	BackgroundJobLogEntry_JobCompletionState_value = map[string]int32{
		"JOB_COMPLETION_STATE_UNSPECIFIED": 0,
		"SUCCEEDED":                        1,
		"FAILED":                           2,
	}
)

func (x BackgroundJobLogEntry_JobCompletionState) Enum() *BackgroundJobLogEntry_JobCompletionState {
	p := new(BackgroundJobLogEntry_JobCompletionState)
	*p = x
	return p
}

func (x BackgroundJobLogEntry_JobCompletionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackgroundJobLogEntry_JobCompletionState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[7].Descriptor()
}

func (BackgroundJobLogEntry_JobCompletionState) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[7]
}

func (x BackgroundJobLogEntry_JobCompletionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackgroundJobLogEntry_JobCompletionState.Descriptor instead.
func (BackgroundJobLogEntry_JobCompletionState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2, 0}
}

// The current mapping rule state such as enabled, disabled or deleted.
type MappingRule_State int32

const (
	// The state of the mapping rule is unknown.
	MappingRule_STATE_UNSPECIFIED MappingRule_State = 0
	// The rule is enabled.
	MappingRule_ENABLED MappingRule_State = 1
	// The rule is disabled.
	MappingRule_DISABLED MappingRule_State = 2
	// The rule is logically deleted.
	MappingRule_DELETED MappingRule_State = 3
)

// Enum value maps for MappingRule_State.
var (
	MappingRule_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ENABLED",
		2: "DISABLED",
		3: "DELETED",
	}
	MappingRule_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ENABLED":           1,
		"DISABLED":          2,
		"DELETED":           3,
	}
)

func (x MappingRule_State) Enum() *MappingRule_State {
	p := new(MappingRule_State)
	*p = x
	return p
}

func (x MappingRule_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MappingRule_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[8].Descriptor()
}

func (MappingRule_State) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[8]
}

func (x MappingRule_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MappingRule_State.Descriptor instead.
func (MappingRule_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{4, 0}
}

// The type of database entities tree.
type DatabaseEntity_TreeType int32

const (
	// Tree type unspecified.
	DatabaseEntity_TREE_TYPE_UNSPECIFIED DatabaseEntity_TreeType = 0
	// Tree of entities loaded from a source database.
	DatabaseEntity_SOURCE DatabaseEntity_TreeType = 1
	// Tree of entities converted from the source tree using the mapping rules.
	DatabaseEntity_DRAFT DatabaseEntity_TreeType = 2
	// Tree of entities observed on the destination database.
	DatabaseEntity_DESTINATION DatabaseEntity_TreeType = 3
)

// Enum value maps for DatabaseEntity_TreeType.
var (
	DatabaseEntity_TreeType_name = map[int32]string{
		0: "TREE_TYPE_UNSPECIFIED",
		1: "SOURCE",
		2: "DRAFT",
		3: "DESTINATION",
	}
	DatabaseEntity_TreeType_value = map[string]int32{
		"TREE_TYPE_UNSPECIFIED": 0,
		"SOURCE":                1,
		"DRAFT":                 2,
		"DESTINATION":           3,
	}
)

func (x DatabaseEntity_TreeType) Enum() *DatabaseEntity_TreeType {
	p := new(DatabaseEntity_TreeType)
	*p = x
	return p
}

func (x DatabaseEntity_TreeType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseEntity_TreeType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[9].Descriptor()
}

func (DatabaseEntity_TreeType) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[9]
}

func (x DatabaseEntity_TreeType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseEntity_TreeType.Descriptor instead.
func (DatabaseEntity_TreeType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{25, 0}
}

// Type of issue.
type EntityIssue_IssueType int32

const (
	// Unspecified issue type.
	EntityIssue_ISSUE_TYPE_UNSPECIFIED EntityIssue_IssueType = 0
	// Issue originated from the DDL
	EntityIssue_ISSUE_TYPE_DDL EntityIssue_IssueType = 1
	// Issue originated during the apply process
	EntityIssue_ISSUE_TYPE_APPLY EntityIssue_IssueType = 2
	// Issue originated during the convert process
	EntityIssue_ISSUE_TYPE_CONVERT EntityIssue_IssueType = 3
)

// Enum value maps for EntityIssue_IssueType.
var (
	EntityIssue_IssueType_name = map[int32]string{
		0: "ISSUE_TYPE_UNSPECIFIED",
		1: "ISSUE_TYPE_DDL",
		2: "ISSUE_TYPE_APPLY",
		3: "ISSUE_TYPE_CONVERT",
	}
	EntityIssue_IssueType_value = map[string]int32{
		"ISSUE_TYPE_UNSPECIFIED": 0,
		"ISSUE_TYPE_DDL":         1,
		"ISSUE_TYPE_APPLY":       2,
		"ISSUE_TYPE_CONVERT":     3,
	}
)

func (x EntityIssue_IssueType) Enum() *EntityIssue_IssueType {
	p := new(EntityIssue_IssueType)
	*p = x
	return p
}

func (x EntityIssue_IssueType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntityIssue_IssueType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[10].Descriptor()
}

func (EntityIssue_IssueType) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[10]
}

func (x EntityIssue_IssueType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntityIssue_IssueType.Descriptor instead.
func (EntityIssue_IssueType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{44, 0}
}

// Severity of issue.
type EntityIssue_IssueSeverity int32

const (
	// Unspecified issue severity
	EntityIssue_ISSUE_SEVERITY_UNSPECIFIED EntityIssue_IssueSeverity = 0
	// Info
	EntityIssue_ISSUE_SEVERITY_INFO EntityIssue_IssueSeverity = 1
	// Warning
	EntityIssue_ISSUE_SEVERITY_WARNING EntityIssue_IssueSeverity = 2
	// Error
	EntityIssue_ISSUE_SEVERITY_ERROR EntityIssue_IssueSeverity = 3
)

// Enum value maps for EntityIssue_IssueSeverity.
var (
	EntityIssue_IssueSeverity_name = map[int32]string{
		0: "ISSUE_SEVERITY_UNSPECIFIED",
		1: "ISSUE_SEVERITY_INFO",
		2: "ISSUE_SEVERITY_WARNING",
		3: "ISSUE_SEVERITY_ERROR",
	}
	EntityIssue_IssueSeverity_value = map[string]int32{
		"ISSUE_SEVERITY_UNSPECIFIED": 0,
		"ISSUE_SEVERITY_INFO":        1,
		"ISSUE_SEVERITY_WARNING":     2,
		"ISSUE_SEVERITY_ERROR":       3,
	}
)

func (x EntityIssue_IssueSeverity) Enum() *EntityIssue_IssueSeverity {
	p := new(EntityIssue_IssueSeverity)
	*p = x
	return p
}

func (x EntityIssue_IssueSeverity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntityIssue_IssueSeverity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[11].Descriptor()
}

func (EntityIssue_IssueSeverity) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes[11]
}

func (x EntityIssue_IssueSeverity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntityIssue_IssueSeverity.Descriptor instead.
func (EntityIssue_IssueSeverity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{44, 1}
}

// The type and version of a source or destination database.
type DatabaseEngineInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Engine type.
	Engine DatabaseEngine `protobuf:"varint,1,opt,name=engine,proto3,enum=google.cloud.clouddms.v1.DatabaseEngine" json:"engine,omitempty"`
	// Required. Engine named version, for example 12.c.1.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *DatabaseEngineInfo) Reset() {
	*x = DatabaseEngineInfo{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatabaseEngineInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseEngineInfo) ProtoMessage() {}

func (x *DatabaseEngineInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseEngineInfo.ProtoReflect.Descriptor instead.
func (*DatabaseEngineInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{0}
}

func (x *DatabaseEngineInfo) GetEngine() DatabaseEngine {
	if x != nil {
		return x.Engine
	}
	return DatabaseEngine_DATABASE_ENGINE_UNSPECIFIED
}

func (x *DatabaseEngineInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// The main conversion workspace resource entity.
type ConversionWorkspace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full name of the workspace resource, in the form of:
	// projects/{project}/locations/{location}/conversionWorkspaces/{conversion_workspace}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The source engine details.
	Source *DatabaseEngineInfo `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	// Required. The destination engine details.
	Destination *DatabaseEngineInfo `protobuf:"bytes,3,opt,name=destination,proto3" json:"destination,omitempty"`
	// Optional. A generic list of settings for the workspace.
	// The settings are database pair dependant and can indicate default behavior
	// for the mapping rules engine or turn on or off specific features.
	// Such examples can be: convert_foreign_key_to_interleave=true,
	// skip_triggers=false, ignore_non_table_synonyms=true
	GlobalSettings map[string]string `protobuf:"bytes,4,rep,name=global_settings,json=globalSettings,proto3" json:"global_settings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Whether the workspace has uncommitted changes (changes which
	// were made after the workspace was committed).
	HasUncommittedChanges bool `protobuf:"varint,5,opt,name=has_uncommitted_changes,json=hasUncommittedChanges,proto3" json:"has_uncommitted_changes,omitempty"`
	// Output only. The latest commit ID.
	LatestCommitId string `protobuf:"bytes,6,opt,name=latest_commit_id,json=latestCommitId,proto3" json:"latest_commit_id,omitempty"`
	// Output only. The timestamp when the workspace was committed.
	LatestCommitTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=latest_commit_time,json=latestCommitTime,proto3" json:"latest_commit_time,omitempty"`
	// Output only. The timestamp when the workspace resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the workspace resource was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The display name for the workspace.
	DisplayName string `protobuf:"bytes,11,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *ConversionWorkspace) Reset() {
	*x = ConversionWorkspace{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConversionWorkspace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConversionWorkspace) ProtoMessage() {}

func (x *ConversionWorkspace) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConversionWorkspace.ProtoReflect.Descriptor instead.
func (*ConversionWorkspace) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{1}
}

func (x *ConversionWorkspace) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConversionWorkspace) GetSource() *DatabaseEngineInfo {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *ConversionWorkspace) GetDestination() *DatabaseEngineInfo {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *ConversionWorkspace) GetGlobalSettings() map[string]string {
	if x != nil {
		return x.GlobalSettings
	}
	return nil
}

func (x *ConversionWorkspace) GetHasUncommittedChanges() bool {
	if x != nil {
		return x.HasUncommittedChanges
	}
	return false
}

func (x *ConversionWorkspace) GetLatestCommitId() string {
	if x != nil {
		return x.LatestCommitId
	}
	return ""
}

func (x *ConversionWorkspace) GetLatestCommitTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestCommitTime
	}
	return nil
}

func (x *ConversionWorkspace) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ConversionWorkspace) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ConversionWorkspace) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Execution log of a background job.
type BackgroundJobLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The background job log entry ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The type of job that was executed.
	JobType BackgroundJobType `protobuf:"varint,2,opt,name=job_type,json=jobType,proto3,enum=google.cloud.clouddms.v1.BackgroundJobType" json:"job_type,omitempty"`
	// The timestamp when the background job was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The timestamp when the background job was finished.
	FinishTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	// Output only. Job completion state, i.e. the final state after the job
	// completed.
	CompletionState BackgroundJobLogEntry_JobCompletionState `protobuf:"varint,5,opt,name=completion_state,json=completionState,proto3,enum=google.cloud.clouddms.v1.BackgroundJobLogEntry_JobCompletionState" json:"completion_state,omitempty"`
	// Output only. Job completion comment, such as how many entities were seeded,
	// how many warnings were found during conversion, and similar information.
	CompletionComment string `protobuf:"bytes,6,opt,name=completion_comment,json=completionComment,proto3" json:"completion_comment,omitempty"`
	// Output only. Whether the client requested the conversion workspace to be
	// committed after a successful completion of the job.
	RequestAutocommit bool `protobuf:"varint,7,opt,name=request_autocommit,json=requestAutocommit,proto3" json:"request_autocommit,omitempty"`
	// Types that are assignable to JobDetails:
	//
	//	*BackgroundJobLogEntry_SeedJobDetails_
	//	*BackgroundJobLogEntry_ImportRulesJobDetails_
	//	*BackgroundJobLogEntry_ConvertJobDetails_
	//	*BackgroundJobLogEntry_ApplyJobDetails_
	JobDetails isBackgroundJobLogEntry_JobDetails `protobuf_oneof:"job_details"`
}

func (x *BackgroundJobLogEntry) Reset() {
	*x = BackgroundJobLogEntry{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackgroundJobLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackgroundJobLogEntry) ProtoMessage() {}

func (x *BackgroundJobLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackgroundJobLogEntry.ProtoReflect.Descriptor instead.
func (*BackgroundJobLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2}
}

func (x *BackgroundJobLogEntry) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *BackgroundJobLogEntry) GetJobType() BackgroundJobType {
	if x != nil {
		return x.JobType
	}
	return BackgroundJobType_BACKGROUND_JOB_TYPE_UNSPECIFIED
}

func (x *BackgroundJobLogEntry) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *BackgroundJobLogEntry) GetFinishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FinishTime
	}
	return nil
}

func (x *BackgroundJobLogEntry) GetCompletionState() BackgroundJobLogEntry_JobCompletionState {
	if x != nil {
		return x.CompletionState
	}
	return BackgroundJobLogEntry_JOB_COMPLETION_STATE_UNSPECIFIED
}

func (x *BackgroundJobLogEntry) GetCompletionComment() string {
	if x != nil {
		return x.CompletionComment
	}
	return ""
}

func (x *BackgroundJobLogEntry) GetRequestAutocommit() bool {
	if x != nil {
		return x.RequestAutocommit
	}
	return false
}

func (m *BackgroundJobLogEntry) GetJobDetails() isBackgroundJobLogEntry_JobDetails {
	if m != nil {
		return m.JobDetails
	}
	return nil
}

func (x *BackgroundJobLogEntry) GetSeedJobDetails() *BackgroundJobLogEntry_SeedJobDetails {
	if x, ok := x.GetJobDetails().(*BackgroundJobLogEntry_SeedJobDetails_); ok {
		return x.SeedJobDetails
	}
	return nil
}

func (x *BackgroundJobLogEntry) GetImportRulesJobDetails() *BackgroundJobLogEntry_ImportRulesJobDetails {
	if x, ok := x.GetJobDetails().(*BackgroundJobLogEntry_ImportRulesJobDetails_); ok {
		return x.ImportRulesJobDetails
	}
	return nil
}

func (x *BackgroundJobLogEntry) GetConvertJobDetails() *BackgroundJobLogEntry_ConvertJobDetails {
	if x, ok := x.GetJobDetails().(*BackgroundJobLogEntry_ConvertJobDetails_); ok {
		return x.ConvertJobDetails
	}
	return nil
}

func (x *BackgroundJobLogEntry) GetApplyJobDetails() *BackgroundJobLogEntry_ApplyJobDetails {
	if x, ok := x.GetJobDetails().(*BackgroundJobLogEntry_ApplyJobDetails_); ok {
		return x.ApplyJobDetails
	}
	return nil
}

type isBackgroundJobLogEntry_JobDetails interface {
	isBackgroundJobLogEntry_JobDetails()
}

type BackgroundJobLogEntry_SeedJobDetails_ struct {
	// Output only. Seed job details.
	SeedJobDetails *BackgroundJobLogEntry_SeedJobDetails `protobuf:"bytes,100,opt,name=seed_job_details,json=seedJobDetails,proto3,oneof"`
}

type BackgroundJobLogEntry_ImportRulesJobDetails_ struct {
	// Output only. Import rules job details.
	ImportRulesJobDetails *BackgroundJobLogEntry_ImportRulesJobDetails `protobuf:"bytes,101,opt,name=import_rules_job_details,json=importRulesJobDetails,proto3,oneof"`
}

type BackgroundJobLogEntry_ConvertJobDetails_ struct {
	// Output only. Convert job details.
	ConvertJobDetails *BackgroundJobLogEntry_ConvertJobDetails `protobuf:"bytes,102,opt,name=convert_job_details,json=convertJobDetails,proto3,oneof"`
}

type BackgroundJobLogEntry_ApplyJobDetails_ struct {
	// Output only. Apply job details.
	ApplyJobDetails *BackgroundJobLogEntry_ApplyJobDetails `protobuf:"bytes,103,opt,name=apply_job_details,json=applyJobDetails,proto3,oneof"`
}

func (*BackgroundJobLogEntry_SeedJobDetails_) isBackgroundJobLogEntry_JobDetails() {}

func (*BackgroundJobLogEntry_ImportRulesJobDetails_) isBackgroundJobLogEntry_JobDetails() {}

func (*BackgroundJobLogEntry_ConvertJobDetails_) isBackgroundJobLogEntry_JobDetails() {}

func (*BackgroundJobLogEntry_ApplyJobDetails_) isBackgroundJobLogEntry_JobDetails() {}

// A filter defining the entities that a mapping rule should be applied to.
// When more than one field is specified, the rule is applied only to
// entities which match all the fields.
type MappingRuleFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The rule should be applied to entities whose parent entity
	// (fully qualified name) matches the given value.
	// For example, if the rule applies to a table entity, the expected value
	// should be a schema (schema). If the rule applies to a column or index
	// entity, the expected value can be either a schema (schema) or a table
	// (schema.table)
	ParentEntity string `protobuf:"bytes,1,opt,name=parent_entity,json=parentEntity,proto3" json:"parent_entity,omitempty"`
	// Optional. The rule should be applied to entities whose non-qualified name
	// starts with the given prefix.
	EntityNamePrefix string `protobuf:"bytes,2,opt,name=entity_name_prefix,json=entityNamePrefix,proto3" json:"entity_name_prefix,omitempty"`
	// Optional. The rule should be applied to entities whose non-qualified name
	// ends with the given suffix.
	EntityNameSuffix string `protobuf:"bytes,3,opt,name=entity_name_suffix,json=entityNameSuffix,proto3" json:"entity_name_suffix,omitempty"`
	// Optional. The rule should be applied to entities whose non-qualified name
	// contains the given string.
	EntityNameContains string `protobuf:"bytes,4,opt,name=entity_name_contains,json=entityNameContains,proto3" json:"entity_name_contains,omitempty"`
	// Optional. The rule should be applied to specific entities defined by their
	// fully qualified names.
	Entities []string `protobuf:"bytes,5,rep,name=entities,proto3" json:"entities,omitempty"`
}

func (x *MappingRuleFilter) Reset() {
	*x = MappingRuleFilter{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MappingRuleFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MappingRuleFilter) ProtoMessage() {}

func (x *MappingRuleFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MappingRuleFilter.ProtoReflect.Descriptor instead.
func (*MappingRuleFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{3}
}

func (x *MappingRuleFilter) GetParentEntity() string {
	if x != nil {
		return x.ParentEntity
	}
	return ""
}

func (x *MappingRuleFilter) GetEntityNamePrefix() string {
	if x != nil {
		return x.EntityNamePrefix
	}
	return ""
}

func (x *MappingRuleFilter) GetEntityNameSuffix() string {
	if x != nil {
		return x.EntityNameSuffix
	}
	return ""
}

func (x *MappingRuleFilter) GetEntityNameContains() string {
	if x != nil {
		return x.EntityNameContains
	}
	return ""
}

func (x *MappingRuleFilter) GetEntities() []string {
	if x != nil {
		return x.Entities
	}
	return nil
}

// Definition of a transformation that is to be applied to a group of entities
// in the source schema. Several such transformations can be applied to an
// entity sequentially to define the corresponding entity in the target schema.
type MappingRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full name of the mapping rule resource, in the form of:
	// projects/{project}/locations/{location}/conversionWorkspaces/{set}/mappingRule/{rule}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A human readable name
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The mapping rule state
	State MappingRule_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.clouddms.v1.MappingRule_State" json:"state,omitempty"`
	// Required. The rule scope
	RuleScope DatabaseEntityType `protobuf:"varint,4,opt,name=rule_scope,json=ruleScope,proto3,enum=google.cloud.clouddms.v1.DatabaseEntityType" json:"rule_scope,omitempty"`
	// Required. The rule filter
	Filter *MappingRuleFilter `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Required. The order in which the rule is applied. Lower order rules are
	// applied before higher value rules so they may end up being overridden.
	RuleOrder int64 `protobuf:"varint,6,opt,name=rule_order,json=ruleOrder,proto3" json:"rule_order,omitempty"`
	// Output only. The revision ID of the mapping rule.
	// A new revision is committed whenever the mapping rule is changed in any
	// way. The format is an 8-character hexadecimal string.
	RevisionId string `protobuf:"bytes,7,opt,name=revision_id,json=revisionId,proto3" json:"revision_id,omitempty"`
	// Output only. The timestamp that the revision was created.
	RevisionCreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=revision_create_time,json=revisionCreateTime,proto3" json:"revision_create_time,omitempty"`
	// The rule specific details.
	//
	// Types that are assignable to Details:
	//
	//	*MappingRule_SingleEntityRename
	//	*MappingRule_MultiEntityRename
	//	*MappingRule_EntityMove
	//	*MappingRule_SingleColumnChange
	//	*MappingRule_MultiColumnDataTypeChange
	//	*MappingRule_ConditionalColumnSetValue
	//	*MappingRule_ConvertRowidColumn
	//	*MappingRule_SetTablePrimaryKey
	//	*MappingRule_SinglePackageChange
	//	*MappingRule_SourceSqlChange
	//	*MappingRule_FilterTableColumns
	Details isMappingRule_Details `protobuf_oneof:"details"`
}

func (x *MappingRule) Reset() {
	*x = MappingRule{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MappingRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MappingRule) ProtoMessage() {}

func (x *MappingRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MappingRule.ProtoReflect.Descriptor instead.
func (*MappingRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{4}
}

func (x *MappingRule) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MappingRule) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *MappingRule) GetState() MappingRule_State {
	if x != nil {
		return x.State
	}
	return MappingRule_STATE_UNSPECIFIED
}

func (x *MappingRule) GetRuleScope() DatabaseEntityType {
	if x != nil {
		return x.RuleScope
	}
	return DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED
}

func (x *MappingRule) GetFilter() *MappingRuleFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *MappingRule) GetRuleOrder() int64 {
	if x != nil {
		return x.RuleOrder
	}
	return 0
}

func (x *MappingRule) GetRevisionId() string {
	if x != nil {
		return x.RevisionId
	}
	return ""
}

func (x *MappingRule) GetRevisionCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RevisionCreateTime
	}
	return nil
}

func (m *MappingRule) GetDetails() isMappingRule_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (x *MappingRule) GetSingleEntityRename() *SingleEntityRename {
	if x, ok := x.GetDetails().(*MappingRule_SingleEntityRename); ok {
		return x.SingleEntityRename
	}
	return nil
}

func (x *MappingRule) GetMultiEntityRename() *MultiEntityRename {
	if x, ok := x.GetDetails().(*MappingRule_MultiEntityRename); ok {
		return x.MultiEntityRename
	}
	return nil
}

func (x *MappingRule) GetEntityMove() *EntityMove {
	if x, ok := x.GetDetails().(*MappingRule_EntityMove); ok {
		return x.EntityMove
	}
	return nil
}

func (x *MappingRule) GetSingleColumnChange() *SingleColumnChange {
	if x, ok := x.GetDetails().(*MappingRule_SingleColumnChange); ok {
		return x.SingleColumnChange
	}
	return nil
}

func (x *MappingRule) GetMultiColumnDataTypeChange() *MultiColumnDatatypeChange {
	if x, ok := x.GetDetails().(*MappingRule_MultiColumnDataTypeChange); ok {
		return x.MultiColumnDataTypeChange
	}
	return nil
}

func (x *MappingRule) GetConditionalColumnSetValue() *ConditionalColumnSetValue {
	if x, ok := x.GetDetails().(*MappingRule_ConditionalColumnSetValue); ok {
		return x.ConditionalColumnSetValue
	}
	return nil
}

func (x *MappingRule) GetConvertRowidColumn() *ConvertRowIdToColumn {
	if x, ok := x.GetDetails().(*MappingRule_ConvertRowidColumn); ok {
		return x.ConvertRowidColumn
	}
	return nil
}

func (x *MappingRule) GetSetTablePrimaryKey() *SetTablePrimaryKey {
	if x, ok := x.GetDetails().(*MappingRule_SetTablePrimaryKey); ok {
		return x.SetTablePrimaryKey
	}
	return nil
}

func (x *MappingRule) GetSinglePackageChange() *SinglePackageChange {
	if x, ok := x.GetDetails().(*MappingRule_SinglePackageChange); ok {
		return x.SinglePackageChange
	}
	return nil
}

func (x *MappingRule) GetSourceSqlChange() *SourceSqlChange {
	if x, ok := x.GetDetails().(*MappingRule_SourceSqlChange); ok {
		return x.SourceSqlChange
	}
	return nil
}

func (x *MappingRule) GetFilterTableColumns() *FilterTableColumns {
	if x, ok := x.GetDetails().(*MappingRule_FilterTableColumns); ok {
		return x.FilterTableColumns
	}
	return nil
}

type isMappingRule_Details interface {
	isMappingRule_Details()
}

type MappingRule_SingleEntityRename struct {
	// Optional. Rule to specify how a single entity should be renamed.
	SingleEntityRename *SingleEntityRename `protobuf:"bytes,102,opt,name=single_entity_rename,json=singleEntityRename,proto3,oneof"`
}

type MappingRule_MultiEntityRename struct {
	// Optional. Rule to specify how multiple entities should be renamed.
	MultiEntityRename *MultiEntityRename `protobuf:"bytes,103,opt,name=multi_entity_rename,json=multiEntityRename,proto3,oneof"`
}

type MappingRule_EntityMove struct {
	// Optional. Rule to specify how multiple entities should be relocated into
	// a different schema.
	EntityMove *EntityMove `protobuf:"bytes,105,opt,name=entity_move,json=entityMove,proto3,oneof"`
}

type MappingRule_SingleColumnChange struct {
	// Optional. Rule to specify how a single column is converted.
	SingleColumnChange *SingleColumnChange `protobuf:"bytes,106,opt,name=single_column_change,json=singleColumnChange,proto3,oneof"`
}

type MappingRule_MultiColumnDataTypeChange struct {
	// Optional. Rule to specify how multiple columns should be converted to a
	// different data type.
	MultiColumnDataTypeChange *MultiColumnDatatypeChange `protobuf:"bytes,107,opt,name=multi_column_data_type_change,json=multiColumnDataTypeChange,proto3,oneof"`
}

type MappingRule_ConditionalColumnSetValue struct {
	// Optional. Rule to specify how the data contained in a column should be
	// transformed (such as trimmed, rounded, etc) provided that the data meets
	// certain criteria.
	ConditionalColumnSetValue *ConditionalColumnSetValue `protobuf:"bytes,108,opt,name=conditional_column_set_value,json=conditionalColumnSetValue,proto3,oneof"`
}

type MappingRule_ConvertRowidColumn struct {
	// Optional. Rule to specify how multiple tables should be converted with an
	// additional rowid column.
	ConvertRowidColumn *ConvertRowIdToColumn `protobuf:"bytes,114,opt,name=convert_rowid_column,json=convertRowidColumn,proto3,oneof"`
}

type MappingRule_SetTablePrimaryKey struct {
	// Optional. Rule to specify the primary key for a table
	SetTablePrimaryKey *SetTablePrimaryKey `protobuf:"bytes,115,opt,name=set_table_primary_key,json=setTablePrimaryKey,proto3,oneof"`
}

type MappingRule_SinglePackageChange struct {
	// Optional. Rule to specify how a single package is converted.
	SinglePackageChange *SinglePackageChange `protobuf:"bytes,116,opt,name=single_package_change,json=singlePackageChange,proto3,oneof"`
}

type MappingRule_SourceSqlChange struct {
	// Optional. Rule to change the sql code for an entity, for example,
	// function, procedure.
	SourceSqlChange *SourceSqlChange `protobuf:"bytes,117,opt,name=source_sql_change,json=sourceSqlChange,proto3,oneof"`
}

type MappingRule_FilterTableColumns struct {
	// Optional. Rule to specify the list of columns to include or exclude from
	// a table.
	FilterTableColumns *FilterTableColumns `protobuf:"bytes,118,opt,name=filter_table_columns,json=filterTableColumns,proto3,oneof"`
}

func (*MappingRule_SingleEntityRename) isMappingRule_Details() {}

func (*MappingRule_MultiEntityRename) isMappingRule_Details() {}

func (*MappingRule_EntityMove) isMappingRule_Details() {}

func (*MappingRule_SingleColumnChange) isMappingRule_Details() {}

func (*MappingRule_MultiColumnDataTypeChange) isMappingRule_Details() {}

func (*MappingRule_ConditionalColumnSetValue) isMappingRule_Details() {}

func (*MappingRule_ConvertRowidColumn) isMappingRule_Details() {}

func (*MappingRule_SetTablePrimaryKey) isMappingRule_Details() {}

func (*MappingRule_SinglePackageChange) isMappingRule_Details() {}

func (*MappingRule_SourceSqlChange) isMappingRule_Details() {}

func (*MappingRule_FilterTableColumns) isMappingRule_Details() {}

// Options to configure rule type SingleEntityRename.
// The rule is used to rename an entity.
//
// The rule filter field can refer to only one entity.
//
// The rule scope can be one of: Database, Schema, Table, Column, Constraint,
// Index, View, Function, Stored Procedure, Materialized View, Sequence, UDT,
// Synonym
type SingleEntityRename struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new name of the destination entity
	NewName string `protobuf:"bytes,1,opt,name=new_name,json=newName,proto3" json:"new_name,omitempty"`
}

func (x *SingleEntityRename) Reset() {
	*x = SingleEntityRename{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleEntityRename) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleEntityRename) ProtoMessage() {}

func (x *SingleEntityRename) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleEntityRename.ProtoReflect.Descriptor instead.
func (*SingleEntityRename) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{5}
}

func (x *SingleEntityRename) GetNewName() string {
	if x != nil {
		return x.NewName
	}
	return ""
}

// Options to configure rule type MultiEntityRename.
// The rule is used to rename multiple entities.
//
// The rule filter field can refer to one or more entities.
//
// The rule scope can be one of: Database, Schema, Table, Column, Constraint,
// Index, View, Function, Stored Procedure, Materialized View, Sequence, UDT
type MultiEntityRename struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The pattern used to generate the new entity's name. This pattern
	// must include the characters '{name}', which will be replaced with the name
	// of the original entity. For example, the pattern 't_{name}' for an entity
	// name jobs would be converted to 't_jobs'.
	//
	// If unspecified, the default value for this field is '{name}'
	NewNamePattern string `protobuf:"bytes,1,opt,name=new_name_pattern,json=newNamePattern,proto3" json:"new_name_pattern,omitempty"`
	// Optional. Additional transformation that can be done on the source entity
	// name before it is being used by the new_name_pattern, for example lower
	// case. If no transformation is desired, use NO_TRANSFORMATION
	SourceNameTransformation EntityNameTransformation `protobuf:"varint,2,opt,name=source_name_transformation,json=sourceNameTransformation,proto3,enum=google.cloud.clouddms.v1.EntityNameTransformation" json:"source_name_transformation,omitempty"`
}

func (x *MultiEntityRename) Reset() {
	*x = MultiEntityRename{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MultiEntityRename) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiEntityRename) ProtoMessage() {}

func (x *MultiEntityRename) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiEntityRename.ProtoReflect.Descriptor instead.
func (*MultiEntityRename) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{6}
}

func (x *MultiEntityRename) GetNewNamePattern() string {
	if x != nil {
		return x.NewNamePattern
	}
	return ""
}

func (x *MultiEntityRename) GetSourceNameTransformation() EntityNameTransformation {
	if x != nil {
		return x.SourceNameTransformation
	}
	return EntityNameTransformation_ENTITY_NAME_TRANSFORMATION_UNSPECIFIED
}

// Options to configure rule type EntityMove.
// The rule is used to move an entity to a new schema.
//
// The rule filter field can refer to one or more entities.
//
// The rule scope can be one of: Table, Column, Constraint, Index, View,
// Function, Stored Procedure, Materialized View, Sequence, UDT
type EntityMove struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new schema
	NewSchema string `protobuf:"bytes,1,opt,name=new_schema,json=newSchema,proto3" json:"new_schema,omitempty"`
}

func (x *EntityMove) Reset() {
	*x = EntityMove{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntityMove) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityMove) ProtoMessage() {}

func (x *EntityMove) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityMove.ProtoReflect.Descriptor instead.
func (*EntityMove) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{7}
}

func (x *EntityMove) GetNewSchema() string {
	if x != nil {
		return x.NewSchema
	}
	return ""
}

// Options to configure rule type SingleColumnChange.
// The rule is used to change the properties of a column.
//
// The rule filter field can refer to one entity.
//
// The rule scope can be one of: Column.
//
// When using this rule, if a field is not specified than the destination
// column's configuration will be the same as the one in the source column..
type SingleColumnChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Column data type name.
	DataType string `protobuf:"bytes,1,opt,name=data_type,json=dataType,proto3" json:"data_type,omitempty"`
	// Optional. Charset override - instead of table level charset.
	Charset string `protobuf:"bytes,2,opt,name=charset,proto3" json:"charset,omitempty"`
	// Optional. Collation override - instead of table level collation.
	Collation string `protobuf:"bytes,3,opt,name=collation,proto3" json:"collation,omitempty"`
	// Optional. Column length - e.g. 50 as in varchar (50) - when relevant.
	Length int64 `protobuf:"varint,4,opt,name=length,proto3" json:"length,omitempty"`
	// Optional. Column precision - e.g. 8 as in double (8,2) - when relevant.
	Precision int32 `protobuf:"varint,5,opt,name=precision,proto3" json:"precision,omitempty"`
	// Optional. Column scale - e.g. 2 as in double (8,2) - when relevant.
	Scale int32 `protobuf:"varint,6,opt,name=scale,proto3" json:"scale,omitempty"`
	// Optional. Column fractional seconds precision - e.g. 2 as in timestamp (2)
	// - when relevant.
	FractionalSecondsPrecision int32 `protobuf:"varint,7,opt,name=fractional_seconds_precision,json=fractionalSecondsPrecision,proto3" json:"fractional_seconds_precision,omitempty"`
	// Optional. Is the column of array type.
	Array bool `protobuf:"varint,8,opt,name=array,proto3" json:"array,omitempty"`
	// Optional. The length of the array, only relevant if the column type is an
	// array.
	ArrayLength int32 `protobuf:"varint,9,opt,name=array_length,json=arrayLength,proto3" json:"array_length,omitempty"`
	// Optional. Is the column nullable.
	Nullable bool `protobuf:"varint,10,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// Optional. Is the column auto-generated/identity.
	AutoGenerated bool `protobuf:"varint,11,opt,name=auto_generated,json=autoGenerated,proto3" json:"auto_generated,omitempty"`
	// Optional. Is the column a UDT (User-defined Type).
	Udt bool `protobuf:"varint,12,opt,name=udt,proto3" json:"udt,omitempty"`
	// Optional. Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,13,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
	// Optional. Specifies the list of values allowed in the column.
	SetValues []string `protobuf:"bytes,14,rep,name=set_values,json=setValues,proto3" json:"set_values,omitempty"`
	// Optional. Comment associated with the column.
	Comment string `protobuf:"bytes,15,opt,name=comment,proto3" json:"comment,omitempty"`
}

func (x *SingleColumnChange) Reset() {
	*x = SingleColumnChange{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SingleColumnChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SingleColumnChange) ProtoMessage() {}

func (x *SingleColumnChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SingleColumnChange.ProtoReflect.Descriptor instead.
func (*SingleColumnChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{8}
}

func (x *SingleColumnChange) GetDataType() string {
	if x != nil {
		return x.DataType
	}
	return ""
}

func (x *SingleColumnChange) GetCharset() string {
	if x != nil {
		return x.Charset
	}
	return ""
}

func (x *SingleColumnChange) GetCollation() string {
	if x != nil {
		return x.Collation
	}
	return ""
}

func (x *SingleColumnChange) GetLength() int64 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *SingleColumnChange) GetPrecision() int32 {
	if x != nil {
		return x.Precision
	}
	return 0
}

func (x *SingleColumnChange) GetScale() int32 {
	if x != nil {
		return x.Scale
	}
	return 0
}

func (x *SingleColumnChange) GetFractionalSecondsPrecision() int32 {
	if x != nil {
		return x.FractionalSecondsPrecision
	}
	return 0
}

func (x *SingleColumnChange) GetArray() bool {
	if x != nil {
		return x.Array
	}
	return false
}

func (x *SingleColumnChange) GetArrayLength() int32 {
	if x != nil {
		return x.ArrayLength
	}
	return 0
}

func (x *SingleColumnChange) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (x *SingleColumnChange) GetAutoGenerated() bool {
	if x != nil {
		return x.AutoGenerated
	}
	return false
}

func (x *SingleColumnChange) GetUdt() bool {
	if x != nil {
		return x.Udt
	}
	return false
}

func (x *SingleColumnChange) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

func (x *SingleColumnChange) GetSetValues() []string {
	if x != nil {
		return x.SetValues
	}
	return nil
}

func (x *SingleColumnChange) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

// Options to configure rule type MultiColumnDatatypeChange.
// The rule is used to change the data type and associated properties of
// multiple columns at once.
//
// The rule filter field can refer to one or more entities.
//
// The rule scope can be one of:Column.
//
// This rule requires additional filters to be specified beyond the basic rule
// filter field, which is the source data type, but the rule supports additional
// filtering capabilities such as the minimum and maximum field length. All
// additional filters which are specified are required to be met in order for
// the rule to be applied (logical AND between the fields).
type MultiColumnDatatypeChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Filter on source data type.
	SourceDataTypeFilter string `protobuf:"bytes,1,opt,name=source_data_type_filter,json=sourceDataTypeFilter,proto3" json:"source_data_type_filter,omitempty"`
	// Filter on source column parameters.
	//
	// Types that are assignable to SourceFilter:
	//
	//	*MultiColumnDatatypeChange_SourceTextFilter
	//	*MultiColumnDatatypeChange_SourceNumericFilter
	SourceFilter isMultiColumnDatatypeChange_SourceFilter `protobuf_oneof:"source_filter"`
	// Required. New data type.
	NewDataType string `protobuf:"bytes,2,opt,name=new_data_type,json=newDataType,proto3" json:"new_data_type,omitempty"`
	// Optional. Column length - e.g. varchar (50) - if not specified and relevant
	// uses the source column length.
	OverrideLength int64 `protobuf:"varint,3,opt,name=override_length,json=overrideLength,proto3" json:"override_length,omitempty"`
	// Optional. Column scale - when relevant - if not specified and relevant
	// uses the source column scale.
	OverrideScale int32 `protobuf:"varint,4,opt,name=override_scale,json=overrideScale,proto3" json:"override_scale,omitempty"`
	// Optional. Column precision - when relevant - if not specified and relevant
	// uses the source column precision.
	OverridePrecision int32 `protobuf:"varint,5,opt,name=override_precision,json=overridePrecision,proto3" json:"override_precision,omitempty"`
	// Optional. Column fractional seconds precision - used only for timestamp
	// based datatypes - if not specified and relevant uses the source column
	// fractional seconds precision.
	OverrideFractionalSecondsPrecision int32 `protobuf:"varint,6,opt,name=override_fractional_seconds_precision,json=overrideFractionalSecondsPrecision,proto3" json:"override_fractional_seconds_precision,omitempty"`
	// Optional. Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,7,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *MultiColumnDatatypeChange) Reset() {
	*x = MultiColumnDatatypeChange{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MultiColumnDatatypeChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MultiColumnDatatypeChange) ProtoMessage() {}

func (x *MultiColumnDatatypeChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MultiColumnDatatypeChange.ProtoReflect.Descriptor instead.
func (*MultiColumnDatatypeChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{9}
}

func (x *MultiColumnDatatypeChange) GetSourceDataTypeFilter() string {
	if x != nil {
		return x.SourceDataTypeFilter
	}
	return ""
}

func (m *MultiColumnDatatypeChange) GetSourceFilter() isMultiColumnDatatypeChange_SourceFilter {
	if m != nil {
		return m.SourceFilter
	}
	return nil
}

func (x *MultiColumnDatatypeChange) GetSourceTextFilter() *SourceTextFilter {
	if x, ok := x.GetSourceFilter().(*MultiColumnDatatypeChange_SourceTextFilter); ok {
		return x.SourceTextFilter
	}
	return nil
}

func (x *MultiColumnDatatypeChange) GetSourceNumericFilter() *SourceNumericFilter {
	if x, ok := x.GetSourceFilter().(*MultiColumnDatatypeChange_SourceNumericFilter); ok {
		return x.SourceNumericFilter
	}
	return nil
}

func (x *MultiColumnDatatypeChange) GetNewDataType() string {
	if x != nil {
		return x.NewDataType
	}
	return ""
}

func (x *MultiColumnDatatypeChange) GetOverrideLength() int64 {
	if x != nil {
		return x.OverrideLength
	}
	return 0
}

func (x *MultiColumnDatatypeChange) GetOverrideScale() int32 {
	if x != nil {
		return x.OverrideScale
	}
	return 0
}

func (x *MultiColumnDatatypeChange) GetOverridePrecision() int32 {
	if x != nil {
		return x.OverridePrecision
	}
	return 0
}

func (x *MultiColumnDatatypeChange) GetOverrideFractionalSecondsPrecision() int32 {
	if x != nil {
		return x.OverrideFractionalSecondsPrecision
	}
	return 0
}

func (x *MultiColumnDatatypeChange) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

type isMultiColumnDatatypeChange_SourceFilter interface {
	isMultiColumnDatatypeChange_SourceFilter()
}

type MultiColumnDatatypeChange_SourceTextFilter struct {
	// Optional. Filter for text-based data types like varchar.
	SourceTextFilter *SourceTextFilter `protobuf:"bytes,100,opt,name=source_text_filter,json=sourceTextFilter,proto3,oneof"`
}

type MultiColumnDatatypeChange_SourceNumericFilter struct {
	// Optional. Filter for fixed point number data types such as
	// NUMERIC/NUMBER.
	SourceNumericFilter *SourceNumericFilter `protobuf:"bytes,101,opt,name=source_numeric_filter,json=sourceNumericFilter,proto3,oneof"`
}

func (*MultiColumnDatatypeChange_SourceTextFilter) isMultiColumnDatatypeChange_SourceFilter() {}

func (*MultiColumnDatatypeChange_SourceNumericFilter) isMultiColumnDatatypeChange_SourceFilter() {}

// Filter for text-based data types like varchar.
type SourceTextFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The filter will match columns with length greater than or equal
	// to this number.
	SourceMinLengthFilter int64 `protobuf:"varint,1,opt,name=source_min_length_filter,json=sourceMinLengthFilter,proto3" json:"source_min_length_filter,omitempty"`
	// Optional. The filter will match columns with length smaller than or equal
	// to this number.
	SourceMaxLengthFilter int64 `protobuf:"varint,2,opt,name=source_max_length_filter,json=sourceMaxLengthFilter,proto3" json:"source_max_length_filter,omitempty"`
}

func (x *SourceTextFilter) Reset() {
	*x = SourceTextFilter{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SourceTextFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceTextFilter) ProtoMessage() {}

func (x *SourceTextFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceTextFilter.ProtoReflect.Descriptor instead.
func (*SourceTextFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{10}
}

func (x *SourceTextFilter) GetSourceMinLengthFilter() int64 {
	if x != nil {
		return x.SourceMinLengthFilter
	}
	return 0
}

func (x *SourceTextFilter) GetSourceMaxLengthFilter() int64 {
	if x != nil {
		return x.SourceMaxLengthFilter
	}
	return 0
}

// Filter for fixed point number data types such as NUMERIC/NUMBER
type SourceNumericFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The filter will match columns with scale greater than or equal to
	// this number.
	SourceMinScaleFilter int32 `protobuf:"varint,1,opt,name=source_min_scale_filter,json=sourceMinScaleFilter,proto3" json:"source_min_scale_filter,omitempty"`
	// Optional. The filter will match columns with scale smaller than or equal to
	// this number.
	SourceMaxScaleFilter int32 `protobuf:"varint,2,opt,name=source_max_scale_filter,json=sourceMaxScaleFilter,proto3" json:"source_max_scale_filter,omitempty"`
	// Optional. The filter will match columns with precision greater than or
	// equal to this number.
	SourceMinPrecisionFilter int32 `protobuf:"varint,3,opt,name=source_min_precision_filter,json=sourceMinPrecisionFilter,proto3" json:"source_min_precision_filter,omitempty"`
	// Optional. The filter will match columns with precision smaller than or
	// equal to this number.
	SourceMaxPrecisionFilter int32 `protobuf:"varint,4,opt,name=source_max_precision_filter,json=sourceMaxPrecisionFilter,proto3" json:"source_max_precision_filter,omitempty"`
	// Required. Enum to set the option defining the datatypes numeric filter has
	// to be applied to
	NumericFilterOption NumericFilterOption `protobuf:"varint,5,opt,name=numeric_filter_option,json=numericFilterOption,proto3,enum=google.cloud.clouddms.v1.NumericFilterOption" json:"numeric_filter_option,omitempty"`
}

func (x *SourceNumericFilter) Reset() {
	*x = SourceNumericFilter{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SourceNumericFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceNumericFilter) ProtoMessage() {}

func (x *SourceNumericFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceNumericFilter.ProtoReflect.Descriptor instead.
func (*SourceNumericFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{11}
}

func (x *SourceNumericFilter) GetSourceMinScaleFilter() int32 {
	if x != nil {
		return x.SourceMinScaleFilter
	}
	return 0
}

func (x *SourceNumericFilter) GetSourceMaxScaleFilter() int32 {
	if x != nil {
		return x.SourceMaxScaleFilter
	}
	return 0
}

func (x *SourceNumericFilter) GetSourceMinPrecisionFilter() int32 {
	if x != nil {
		return x.SourceMinPrecisionFilter
	}
	return 0
}

func (x *SourceNumericFilter) GetSourceMaxPrecisionFilter() int32 {
	if x != nil {
		return x.SourceMaxPrecisionFilter
	}
	return 0
}

func (x *SourceNumericFilter) GetNumericFilterOption() NumericFilterOption {
	if x != nil {
		return x.NumericFilterOption
	}
	return NumericFilterOption_NUMERIC_FILTER_OPTION_UNSPECIFIED
}

// Options to configure rule type ConditionalColumnSetValue.
// The rule is used to transform the data which is being replicated/migrated.
//
// The rule filter field can refer to one or more entities.
//
// The rule scope can be one of: Column.
type ConditionalColumnSetValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SourceFilter:
	//
	//	*ConditionalColumnSetValue_SourceTextFilter
	//	*ConditionalColumnSetValue_SourceNumericFilter
	SourceFilter isConditionalColumnSetValue_SourceFilter `protobuf_oneof:"source_filter"`
	// Required. Description of data transformation during migration.
	ValueTransformation *ValueTransformation `protobuf:"bytes,1,opt,name=value_transformation,json=valueTransformation,proto3" json:"value_transformation,omitempty"`
	// Optional. Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,2,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *ConditionalColumnSetValue) Reset() {
	*x = ConditionalColumnSetValue{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConditionalColumnSetValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionalColumnSetValue) ProtoMessage() {}

func (x *ConditionalColumnSetValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionalColumnSetValue.ProtoReflect.Descriptor instead.
func (*ConditionalColumnSetValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{12}
}

func (m *ConditionalColumnSetValue) GetSourceFilter() isConditionalColumnSetValue_SourceFilter {
	if m != nil {
		return m.SourceFilter
	}
	return nil
}

func (x *ConditionalColumnSetValue) GetSourceTextFilter() *SourceTextFilter {
	if x, ok := x.GetSourceFilter().(*ConditionalColumnSetValue_SourceTextFilter); ok {
		return x.SourceTextFilter
	}
	return nil
}

func (x *ConditionalColumnSetValue) GetSourceNumericFilter() *SourceNumericFilter {
	if x, ok := x.GetSourceFilter().(*ConditionalColumnSetValue_SourceNumericFilter); ok {
		return x.SourceNumericFilter
	}
	return nil
}

func (x *ConditionalColumnSetValue) GetValueTransformation() *ValueTransformation {
	if x != nil {
		return x.ValueTransformation
	}
	return nil
}

func (x *ConditionalColumnSetValue) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

type isConditionalColumnSetValue_SourceFilter interface {
	isConditionalColumnSetValue_SourceFilter()
}

type ConditionalColumnSetValue_SourceTextFilter struct {
	// Optional. Optional filter on source column length. Used for text based
	// data types like varchar.
	SourceTextFilter *SourceTextFilter `protobuf:"bytes,100,opt,name=source_text_filter,json=sourceTextFilter,proto3,oneof"`
}

type ConditionalColumnSetValue_SourceNumericFilter struct {
	// Optional. Optional filter on source column precision and scale. Used for
	// fixed point numbers such as NUMERIC/NUMBER data types.
	SourceNumericFilter *SourceNumericFilter `protobuf:"bytes,101,opt,name=source_numeric_filter,json=sourceNumericFilter,proto3,oneof"`
}

func (*ConditionalColumnSetValue_SourceTextFilter) isConditionalColumnSetValue_SourceFilter() {}

func (*ConditionalColumnSetValue_SourceNumericFilter) isConditionalColumnSetValue_SourceFilter() {}

// Description of data transformation during migration as part of the
// ConditionalColumnSetValue.
type ValueTransformation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Filter:
	//
	//	*ValueTransformation_IsNull
	//	*ValueTransformation_ValueList
	//	*ValueTransformation_IntComparison
	//	*ValueTransformation_DoubleComparison
	Filter isValueTransformation_Filter `protobuf_oneof:"filter"`
	// Types that are assignable to Action:
	//
	//	*ValueTransformation_AssignNull
	//	*ValueTransformation_AssignSpecificValue
	//	*ValueTransformation_AssignMinValue
	//	*ValueTransformation_AssignMaxValue
	//	*ValueTransformation_RoundScale
	//	*ValueTransformation_ApplyHash
	Action isValueTransformation_Action `protobuf_oneof:"action"`
}

func (x *ValueTransformation) Reset() {
	*x = ValueTransformation{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValueTransformation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueTransformation) ProtoMessage() {}

func (x *ValueTransformation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueTransformation.ProtoReflect.Descriptor instead.
func (*ValueTransformation) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{13}
}

func (m *ValueTransformation) GetFilter() isValueTransformation_Filter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (x *ValueTransformation) GetIsNull() *emptypb.Empty {
	if x, ok := x.GetFilter().(*ValueTransformation_IsNull); ok {
		return x.IsNull
	}
	return nil
}

func (x *ValueTransformation) GetValueList() *ValueListFilter {
	if x, ok := x.GetFilter().(*ValueTransformation_ValueList); ok {
		return x.ValueList
	}
	return nil
}

func (x *ValueTransformation) GetIntComparison() *IntComparisonFilter {
	if x, ok := x.GetFilter().(*ValueTransformation_IntComparison); ok {
		return x.IntComparison
	}
	return nil
}

func (x *ValueTransformation) GetDoubleComparison() *DoubleComparisonFilter {
	if x, ok := x.GetFilter().(*ValueTransformation_DoubleComparison); ok {
		return x.DoubleComparison
	}
	return nil
}

func (m *ValueTransformation) GetAction() isValueTransformation_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *ValueTransformation) GetAssignNull() *emptypb.Empty {
	if x, ok := x.GetAction().(*ValueTransformation_AssignNull); ok {
		return x.AssignNull
	}
	return nil
}

func (x *ValueTransformation) GetAssignSpecificValue() *AssignSpecificValue {
	if x, ok := x.GetAction().(*ValueTransformation_AssignSpecificValue); ok {
		return x.AssignSpecificValue
	}
	return nil
}

func (x *ValueTransformation) GetAssignMinValue() *emptypb.Empty {
	if x, ok := x.GetAction().(*ValueTransformation_AssignMinValue); ok {
		return x.AssignMinValue
	}
	return nil
}

func (x *ValueTransformation) GetAssignMaxValue() *emptypb.Empty {
	if x, ok := x.GetAction().(*ValueTransformation_AssignMaxValue); ok {
		return x.AssignMaxValue
	}
	return nil
}

func (x *ValueTransformation) GetRoundScale() *RoundToScale {
	if x, ok := x.GetAction().(*ValueTransformation_RoundScale); ok {
		return x.RoundScale
	}
	return nil
}

func (x *ValueTransformation) GetApplyHash() *ApplyHash {
	if x, ok := x.GetAction().(*ValueTransformation_ApplyHash); ok {
		return x.ApplyHash
	}
	return nil
}

type isValueTransformation_Filter interface {
	isValueTransformation_Filter()
}

type ValueTransformation_IsNull struct {
	// Optional. Value is null
	IsNull *emptypb.Empty `protobuf:"bytes,100,opt,name=is_null,json=isNull,proto3,oneof"`
}

type ValueTransformation_ValueList struct {
	// Optional. Value is found in the specified list.
	ValueList *ValueListFilter `protobuf:"bytes,101,opt,name=value_list,json=valueList,proto3,oneof"`
}

type ValueTransformation_IntComparison struct {
	// Optional. Filter on relation between source value and compare value of
	// type integer.
	IntComparison *IntComparisonFilter `protobuf:"bytes,102,opt,name=int_comparison,json=intComparison,proto3,oneof"`
}

type ValueTransformation_DoubleComparison struct {
	// Optional. Filter on relation between source value and compare value of
	// type double.
	DoubleComparison *DoubleComparisonFilter `protobuf:"bytes,103,opt,name=double_comparison,json=doubleComparison,proto3,oneof"`
}

func (*ValueTransformation_IsNull) isValueTransformation_Filter() {}

func (*ValueTransformation_ValueList) isValueTransformation_Filter() {}

func (*ValueTransformation_IntComparison) isValueTransformation_Filter() {}

func (*ValueTransformation_DoubleComparison) isValueTransformation_Filter() {}

type isValueTransformation_Action interface {
	isValueTransformation_Action()
}

type ValueTransformation_AssignNull struct {
	// Optional. Set to null
	AssignNull *emptypb.Empty `protobuf:"bytes,200,opt,name=assign_null,json=assignNull,proto3,oneof"`
}

type ValueTransformation_AssignSpecificValue struct {
	// Optional. Set to a specific value (value is converted to fit the target
	// data type)
	AssignSpecificValue *AssignSpecificValue `protobuf:"bytes,201,opt,name=assign_specific_value,json=assignSpecificValue,proto3,oneof"`
}

type ValueTransformation_AssignMinValue struct {
	// Optional. Set to min_value - if integer or numeric, will use
	// int.minvalue, etc
	AssignMinValue *emptypb.Empty `protobuf:"bytes,202,opt,name=assign_min_value,json=assignMinValue,proto3,oneof"`
}

type ValueTransformation_AssignMaxValue struct {
	// Optional. Set to max_value - if integer or numeric, will use
	// int.maxvalue, etc
	AssignMaxValue *emptypb.Empty `protobuf:"bytes,203,opt,name=assign_max_value,json=assignMaxValue,proto3,oneof"`
}

type ValueTransformation_RoundScale struct {
	// Optional. Allows the data to change scale
	RoundScale *RoundToScale `protobuf:"bytes,204,opt,name=round_scale,json=roundScale,proto3,oneof"`
}

type ValueTransformation_ApplyHash struct {
	// Optional. Applies a hash function on the data
	ApplyHash *ApplyHash `protobuf:"bytes,205,opt,name=apply_hash,json=applyHash,proto3,oneof"`
}

func (*ValueTransformation_AssignNull) isValueTransformation_Action() {}

func (*ValueTransformation_AssignSpecificValue) isValueTransformation_Action() {}

func (*ValueTransformation_AssignMinValue) isValueTransformation_Action() {}

func (*ValueTransformation_AssignMaxValue) isValueTransformation_Action() {}

func (*ValueTransformation_RoundScale) isValueTransformation_Action() {}

func (*ValueTransformation_ApplyHash) isValueTransformation_Action() {}

// Options to configure rule type ConvertROWIDToColumn.
// The rule is used to add column rowid to destination tables based on an Oracle
// rowid function/property.
//
// The rule filter field can refer to one or more entities.
//
// The rule scope can be one of: Table.
//
// This rule requires additional filter to be specified beyond the basic rule
// filter field, which is whether or not to work on tables which already have a
// primary key defined.
type ConvertRowIdToColumn struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Only work on tables without primary key defined
	OnlyIfNoPrimaryKey bool `protobuf:"varint,1,opt,name=only_if_no_primary_key,json=onlyIfNoPrimaryKey,proto3" json:"only_if_no_primary_key,omitempty"`
}

func (x *ConvertRowIdToColumn) Reset() {
	*x = ConvertRowIdToColumn{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConvertRowIdToColumn) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConvertRowIdToColumn) ProtoMessage() {}

func (x *ConvertRowIdToColumn) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConvertRowIdToColumn.ProtoReflect.Descriptor instead.
func (*ConvertRowIdToColumn) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{14}
}

func (x *ConvertRowIdToColumn) GetOnlyIfNoPrimaryKey() bool {
	if x != nil {
		return x.OnlyIfNoPrimaryKey
	}
	return false
}

// Options to configure rule type SetTablePrimaryKey.
// The rule is used to specify the columns and name to configure/alter the
// primary key of a table.
//
// The rule filter field can refer to one entity.
//
// The rule scope can be one of: Table.
type SetTablePrimaryKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of column names for the primary key
	PrimaryKeyColumns []string `protobuf:"bytes,1,rep,name=primary_key_columns,json=primaryKeyColumns,proto3" json:"primary_key_columns,omitempty"`
	// Optional. Name for the primary key
	PrimaryKey string `protobuf:"bytes,2,opt,name=primary_key,json=primaryKey,proto3" json:"primary_key,omitempty"`
}

func (x *SetTablePrimaryKey) Reset() {
	*x = SetTablePrimaryKey{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetTablePrimaryKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetTablePrimaryKey) ProtoMessage() {}

func (x *SetTablePrimaryKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetTablePrimaryKey.ProtoReflect.Descriptor instead.
func (*SetTablePrimaryKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{15}
}

func (x *SetTablePrimaryKey) GetPrimaryKeyColumns() []string {
	if x != nil {
		return x.PrimaryKeyColumns
	}
	return nil
}

func (x *SetTablePrimaryKey) GetPrimaryKey() string {
	if x != nil {
		return x.PrimaryKey
	}
	return ""
}

// Options to configure rule type SinglePackageChange.
// The rule is used to alter the sql code for a package entities.
//
// The rule filter field can refer to one entity.
//
// The rule scope can be: Package
type SinglePackageChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Sql code for package description
	PackageDescription string `protobuf:"bytes,1,opt,name=package_description,json=packageDescription,proto3" json:"package_description,omitempty"`
	// Optional. Sql code for package body
	PackageBody string `protobuf:"bytes,2,opt,name=package_body,json=packageBody,proto3" json:"package_body,omitempty"`
}

func (x *SinglePackageChange) Reset() {
	*x = SinglePackageChange{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SinglePackageChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SinglePackageChange) ProtoMessage() {}

func (x *SinglePackageChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SinglePackageChange.ProtoReflect.Descriptor instead.
func (*SinglePackageChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{16}
}

func (x *SinglePackageChange) GetPackageDescription() string {
	if x != nil {
		return x.PackageDescription
	}
	return ""
}

func (x *SinglePackageChange) GetPackageBody() string {
	if x != nil {
		return x.PackageBody
	}
	return ""
}

// Options to configure rule type SourceSqlChange.
// The rule is used to alter the sql code for database entities.
//
// The rule filter field can refer to one entity.
//
// The rule scope can be: StoredProcedure, Function, Trigger, View
type SourceSqlChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Sql code for source (stored procedure, function, trigger or view)
	SqlCode string `protobuf:"bytes,1,opt,name=sql_code,json=sqlCode,proto3" json:"sql_code,omitempty"`
}

func (x *SourceSqlChange) Reset() {
	*x = SourceSqlChange{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SourceSqlChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceSqlChange) ProtoMessage() {}

func (x *SourceSqlChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceSqlChange.ProtoReflect.Descriptor instead.
func (*SourceSqlChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{17}
}

func (x *SourceSqlChange) GetSqlCode() string {
	if x != nil {
		return x.SqlCode
	}
	return ""
}

// Options to configure rule type FilterTableColumns.
// The rule is used to filter the list of columns to include or exclude from a
// table.
//
// The rule filter field can refer to one entity.
//
// The rule scope can be: Table
//
// Only one of the two lists can be specified for the rule.
type FilterTableColumns struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. List of columns to be included for a particular table.
	IncludeColumns []string `protobuf:"bytes,1,rep,name=include_columns,json=includeColumns,proto3" json:"include_columns,omitempty"`
	// Optional. List of columns to be excluded for a particular table.
	ExcludeColumns []string `protobuf:"bytes,2,rep,name=exclude_columns,json=excludeColumns,proto3" json:"exclude_columns,omitempty"`
}

func (x *FilterTableColumns) Reset() {
	*x = FilterTableColumns{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FilterTableColumns) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterTableColumns) ProtoMessage() {}

func (x *FilterTableColumns) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterTableColumns.ProtoReflect.Descriptor instead.
func (*FilterTableColumns) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{18}
}

func (x *FilterTableColumns) GetIncludeColumns() []string {
	if x != nil {
		return x.IncludeColumns
	}
	return nil
}

func (x *FilterTableColumns) GetExcludeColumns() []string {
	if x != nil {
		return x.ExcludeColumns
	}
	return nil
}

// A list of values to filter by in ConditionalColumnSetValue
type ValueListFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Indicates whether the filter matches rows with values that are
	// present in the list or those with values not present in it.
	ValuePresentList ValuePresentInList `protobuf:"varint,1,opt,name=value_present_list,json=valuePresentList,proto3,enum=google.cloud.clouddms.v1.ValuePresentInList" json:"value_present_list,omitempty"`
	// Required. The list to be used to filter by
	Values []string `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
	// Required. Whether to ignore case when filtering by values. Defaults to
	// false
	IgnoreCase bool `protobuf:"varint,3,opt,name=ignore_case,json=ignoreCase,proto3" json:"ignore_case,omitempty"`
}

func (x *ValueListFilter) Reset() {
	*x = ValueListFilter{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValueListFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValueListFilter) ProtoMessage() {}

func (x *ValueListFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValueListFilter.ProtoReflect.Descriptor instead.
func (*ValueListFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{19}
}

func (x *ValueListFilter) GetValuePresentList() ValuePresentInList {
	if x != nil {
		return x.ValuePresentList
	}
	return ValuePresentInList_VALUE_PRESENT_IN_LIST_UNSPECIFIED
}

func (x *ValueListFilter) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *ValueListFilter) GetIgnoreCase() bool {
	if x != nil {
		return x.IgnoreCase
	}
	return false
}

// Filter based on relation between source value and compare value of type
// integer in ConditionalColumnSetValue
type IntComparisonFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Relation between source value and compare value
	ValueComparison ValueComparison `protobuf:"varint,1,opt,name=value_comparison,json=valueComparison,proto3,enum=google.cloud.clouddms.v1.ValueComparison" json:"value_comparison,omitempty"`
	// Required. Integer compare value to be used
	Value int64 `protobuf:"varint,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *IntComparisonFilter) Reset() {
	*x = IntComparisonFilter{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IntComparisonFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntComparisonFilter) ProtoMessage() {}

func (x *IntComparisonFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntComparisonFilter.ProtoReflect.Descriptor instead.
func (*IntComparisonFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{20}
}

func (x *IntComparisonFilter) GetValueComparison() ValueComparison {
	if x != nil {
		return x.ValueComparison
	}
	return ValueComparison_VALUE_COMPARISON_UNSPECIFIED
}

func (x *IntComparisonFilter) GetValue() int64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// Filter based on relation between source
// value and compare value of type double in ConditionalColumnSetValue
type DoubleComparisonFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Relation between source value and compare value
	ValueComparison ValueComparison `protobuf:"varint,1,opt,name=value_comparison,json=valueComparison,proto3,enum=google.cloud.clouddms.v1.ValueComparison" json:"value_comparison,omitempty"`
	// Required. Double compare value to be used
	Value float64 `protobuf:"fixed64,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *DoubleComparisonFilter) Reset() {
	*x = DoubleComparisonFilter{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DoubleComparisonFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DoubleComparisonFilter) ProtoMessage() {}

func (x *DoubleComparisonFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DoubleComparisonFilter.ProtoReflect.Descriptor instead.
func (*DoubleComparisonFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{21}
}

func (x *DoubleComparisonFilter) GetValueComparison() ValueComparison {
	if x != nil {
		return x.ValueComparison
	}
	return ValueComparison_VALUE_COMPARISON_UNSPECIFIED
}

func (x *DoubleComparisonFilter) GetValue() float64 {
	if x != nil {
		return x.Value
	}
	return 0
}

// Set to a specific value (value is converted to fit the target data type)
type AssignSpecificValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specific value to be assigned
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *AssignSpecificValue) Reset() {
	*x = AssignSpecificValue{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssignSpecificValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssignSpecificValue) ProtoMessage() {}

func (x *AssignSpecificValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssignSpecificValue.ProtoReflect.Descriptor instead.
func (*AssignSpecificValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{22}
}

func (x *AssignSpecificValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Apply a hash function on the value.
type ApplyHash struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to HashFunction:
	//
	//	*ApplyHash_UuidFromBytes
	HashFunction isApplyHash_HashFunction `protobuf_oneof:"hash_function"`
}

func (x *ApplyHash) Reset() {
	*x = ApplyHash{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplyHash) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyHash) ProtoMessage() {}

func (x *ApplyHash) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyHash.ProtoReflect.Descriptor instead.
func (*ApplyHash) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{23}
}

func (m *ApplyHash) GetHashFunction() isApplyHash_HashFunction {
	if m != nil {
		return m.HashFunction
	}
	return nil
}

func (x *ApplyHash) GetUuidFromBytes() *emptypb.Empty {
	if x, ok := x.GetHashFunction().(*ApplyHash_UuidFromBytes); ok {
		return x.UuidFromBytes
	}
	return nil
}

type isApplyHash_HashFunction interface {
	isApplyHash_HashFunction()
}

type ApplyHash_UuidFromBytes struct {
	// Optional. Generate UUID from the data's byte array
	UuidFromBytes *emptypb.Empty `protobuf:"bytes,100,opt,name=uuid_from_bytes,json=uuidFromBytes,proto3,oneof"`
}

func (*ApplyHash_UuidFromBytes) isApplyHash_HashFunction() {}

// This allows the data to change scale, for example if the source is 2 digits
// after the decimal point, specify round to scale value = 2. If for example the
// value needs to be converted to an integer, use round to scale value = 0.
type RoundToScale struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Scale value to be used
	Scale int32 `protobuf:"varint,1,opt,name=scale,proto3" json:"scale,omitempty"`
}

func (x *RoundToScale) Reset() {
	*x = RoundToScale{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RoundToScale) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RoundToScale) ProtoMessage() {}

func (x *RoundToScale) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RoundToScale.ProtoReflect.Descriptor instead.
func (*RoundToScale) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{24}
}

func (x *RoundToScale) GetScale() int32 {
	if x != nil {
		return x.Scale
	}
	return 0
}

// The base entity type for all the database related entities.
// The message contains the entity name, the name of its parent, the entity
// type, and the specific details per entity type.
type DatabaseEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The short name (e.g. table name) of the entity.
	ShortName string `protobuf:"bytes,1,opt,name=short_name,json=shortName,proto3" json:"short_name,omitempty"`
	// The full name of the parent entity (e.g. schema name).
	ParentEntity string `protobuf:"bytes,2,opt,name=parent_entity,json=parentEntity,proto3" json:"parent_entity,omitempty"`
	// The type of tree the entity belongs to.
	Tree DatabaseEntity_TreeType `protobuf:"varint,3,opt,name=tree,proto3,enum=google.cloud.clouddms.v1.DatabaseEntity_TreeType" json:"tree,omitempty"`
	// The type of the database entity (table, view, index, ...).
	EntityType DatabaseEntityType `protobuf:"varint,4,opt,name=entity_type,json=entityType,proto3,enum=google.cloud.clouddms.v1.DatabaseEntityType" json:"entity_type,omitempty"`
	// Details about entity mappings.
	// For source tree entities, this holds the draft entities which were
	// generated by the mapping rules.
	// For draft tree entities, this holds the source entities which were
	// converted to form the draft entity.
	// Destination entities will have no mapping details.
	Mappings []*EntityMapping `protobuf:"bytes,5,rep,name=mappings,proto3" json:"mappings,omitempty"`
	// Details about the entity DDL script. Multiple DDL scripts are provided for
	// child entities such as a table entity will have one DDL for the table with
	// additional DDLs for each index, constraint and such.
	EntityDdl []*EntityDdl `protobuf:"bytes,6,rep,name=entity_ddl,json=entityDdl,proto3" json:"entity_ddl,omitempty"`
	// Details about the various issues found for the entity.
	Issues []*EntityIssue `protobuf:"bytes,7,rep,name=issues,proto3" json:"issues,omitempty"`
	// The specific body for each entity type.
	//
	// Types that are assignable to EntityBody:
	//
	//	*DatabaseEntity_Database
	//	*DatabaseEntity_Schema
	//	*DatabaseEntity_Table
	//	*DatabaseEntity_View
	//	*DatabaseEntity_Sequence
	//	*DatabaseEntity_StoredProcedure
	//	*DatabaseEntity_DatabaseFunction
	//	*DatabaseEntity_Synonym
	//	*DatabaseEntity_DatabasePackage
	//	*DatabaseEntity_Udt
	//	*DatabaseEntity_MaterializedView
	EntityBody isDatabaseEntity_EntityBody `protobuf_oneof:"entity_body"`
}

func (x *DatabaseEntity) Reset() {
	*x = DatabaseEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatabaseEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseEntity) ProtoMessage() {}

func (x *DatabaseEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseEntity.ProtoReflect.Descriptor instead.
func (*DatabaseEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{25}
}

func (x *DatabaseEntity) GetShortName() string {
	if x != nil {
		return x.ShortName
	}
	return ""
}

func (x *DatabaseEntity) GetParentEntity() string {
	if x != nil {
		return x.ParentEntity
	}
	return ""
}

func (x *DatabaseEntity) GetTree() DatabaseEntity_TreeType {
	if x != nil {
		return x.Tree
	}
	return DatabaseEntity_TREE_TYPE_UNSPECIFIED
}

func (x *DatabaseEntity) GetEntityType() DatabaseEntityType {
	if x != nil {
		return x.EntityType
	}
	return DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED
}

func (x *DatabaseEntity) GetMappings() []*EntityMapping {
	if x != nil {
		return x.Mappings
	}
	return nil
}

func (x *DatabaseEntity) GetEntityDdl() []*EntityDdl {
	if x != nil {
		return x.EntityDdl
	}
	return nil
}

func (x *DatabaseEntity) GetIssues() []*EntityIssue {
	if x != nil {
		return x.Issues
	}
	return nil
}

func (m *DatabaseEntity) GetEntityBody() isDatabaseEntity_EntityBody {
	if m != nil {
		return m.EntityBody
	}
	return nil
}

func (x *DatabaseEntity) GetDatabase() *DatabaseInstanceEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_Database); ok {
		return x.Database
	}
	return nil
}

func (x *DatabaseEntity) GetSchema() *SchemaEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_Schema); ok {
		return x.Schema
	}
	return nil
}

func (x *DatabaseEntity) GetTable() *TableEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_Table); ok {
		return x.Table
	}
	return nil
}

func (x *DatabaseEntity) GetView() *ViewEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_View); ok {
		return x.View
	}
	return nil
}

func (x *DatabaseEntity) GetSequence() *SequenceEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_Sequence); ok {
		return x.Sequence
	}
	return nil
}

func (x *DatabaseEntity) GetStoredProcedure() *StoredProcedureEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_StoredProcedure); ok {
		return x.StoredProcedure
	}
	return nil
}

func (x *DatabaseEntity) GetDatabaseFunction() *FunctionEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_DatabaseFunction); ok {
		return x.DatabaseFunction
	}
	return nil
}

func (x *DatabaseEntity) GetSynonym() *SynonymEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_Synonym); ok {
		return x.Synonym
	}
	return nil
}

func (x *DatabaseEntity) GetDatabasePackage() *PackageEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_DatabasePackage); ok {
		return x.DatabasePackage
	}
	return nil
}

func (x *DatabaseEntity) GetUdt() *UDTEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_Udt); ok {
		return x.Udt
	}
	return nil
}

func (x *DatabaseEntity) GetMaterializedView() *MaterializedViewEntity {
	if x, ok := x.GetEntityBody().(*DatabaseEntity_MaterializedView); ok {
		return x.MaterializedView
	}
	return nil
}

type isDatabaseEntity_EntityBody interface {
	isDatabaseEntity_EntityBody()
}

type DatabaseEntity_Database struct {
	// Database.
	Database *DatabaseInstanceEntity `protobuf:"bytes,101,opt,name=database,proto3,oneof"`
}

type DatabaseEntity_Schema struct {
	// Schema.
	Schema *SchemaEntity `protobuf:"bytes,102,opt,name=schema,proto3,oneof"`
}

type DatabaseEntity_Table struct {
	// Table.
	Table *TableEntity `protobuf:"bytes,103,opt,name=table,proto3,oneof"`
}

type DatabaseEntity_View struct {
	// View.
	View *ViewEntity `protobuf:"bytes,104,opt,name=view,proto3,oneof"`
}

type DatabaseEntity_Sequence struct {
	// Sequence.
	Sequence *SequenceEntity `protobuf:"bytes,105,opt,name=sequence,proto3,oneof"`
}

type DatabaseEntity_StoredProcedure struct {
	// Stored procedure.
	StoredProcedure *StoredProcedureEntity `protobuf:"bytes,106,opt,name=stored_procedure,json=storedProcedure,proto3,oneof"`
}

type DatabaseEntity_DatabaseFunction struct {
	// Function.
	DatabaseFunction *FunctionEntity `protobuf:"bytes,107,opt,name=database_function,json=databaseFunction,proto3,oneof"`
}

type DatabaseEntity_Synonym struct {
	// Synonym.
	Synonym *SynonymEntity `protobuf:"bytes,108,opt,name=synonym,proto3,oneof"`
}

type DatabaseEntity_DatabasePackage struct {
	// Package.
	DatabasePackage *PackageEntity `protobuf:"bytes,109,opt,name=database_package,json=databasePackage,proto3,oneof"`
}

type DatabaseEntity_Udt struct {
	// UDT.
	Udt *UDTEntity `protobuf:"bytes,110,opt,name=udt,proto3,oneof"`
}

type DatabaseEntity_MaterializedView struct {
	// Materialized view.
	MaterializedView *MaterializedViewEntity `protobuf:"bytes,111,opt,name=materialized_view,json=materializedView,proto3,oneof"`
}

func (*DatabaseEntity_Database) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_Schema) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_Table) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_View) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_Sequence) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_StoredProcedure) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_DatabaseFunction) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_Synonym) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_DatabasePackage) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_Udt) isDatabaseEntity_EntityBody() {}

func (*DatabaseEntity_MaterializedView) isDatabaseEntity_EntityBody() {}

// DatabaseInstance acts as a parent entity to other database entities.
type DatabaseInstanceEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,1,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *DatabaseInstanceEntity) Reset() {
	*x = DatabaseInstanceEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatabaseInstanceEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseInstanceEntity) ProtoMessage() {}

func (x *DatabaseInstanceEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseInstanceEntity.ProtoReflect.Descriptor instead.
func (*DatabaseInstanceEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{26}
}

func (x *DatabaseInstanceEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Schema typically has no parent entity, but can have a parent entity
// DatabaseInstance (for database engines which support it).  For some database
// engines, the terms  schema and user can be used interchangeably when they
// refer to a namespace or a collection of other database entities. Can store
// additional information which is schema specific.
type SchemaEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,1,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *SchemaEntity) Reset() {
	*x = SchemaEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SchemaEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchemaEntity) ProtoMessage() {}

func (x *SchemaEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchemaEntity.ProtoReflect.Descriptor instead.
func (*SchemaEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{27}
}

func (x *SchemaEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Table's parent is a schema.
type TableEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Table columns.
	Columns []*ColumnEntity `protobuf:"bytes,1,rep,name=columns,proto3" json:"columns,omitempty"`
	// Table constraints.
	Constraints []*ConstraintEntity `protobuf:"bytes,2,rep,name=constraints,proto3" json:"constraints,omitempty"`
	// Table indices.
	Indices []*IndexEntity `protobuf:"bytes,3,rep,name=indices,proto3" json:"indices,omitempty"`
	// Table triggers.
	Triggers []*TriggerEntity `protobuf:"bytes,4,rep,name=triggers,proto3" json:"triggers,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,5,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
	// Comment associated with the table.
	Comment string `protobuf:"bytes,6,opt,name=comment,proto3" json:"comment,omitempty"`
}

func (x *TableEntity) Reset() {
	*x = TableEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TableEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableEntity) ProtoMessage() {}

func (x *TableEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableEntity.ProtoReflect.Descriptor instead.
func (*TableEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{28}
}

func (x *TableEntity) GetColumns() []*ColumnEntity {
	if x != nil {
		return x.Columns
	}
	return nil
}

func (x *TableEntity) GetConstraints() []*ConstraintEntity {
	if x != nil {
		return x.Constraints
	}
	return nil
}

func (x *TableEntity) GetIndices() []*IndexEntity {
	if x != nil {
		return x.Indices
	}
	return nil
}

func (x *TableEntity) GetTriggers() []*TriggerEntity {
	if x != nil {
		return x.Triggers
	}
	return nil
}

func (x *TableEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

func (x *TableEntity) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

// Column is not used as an independent entity, it is retrieved as part of a
// Table entity.
type ColumnEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Column name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Column data type.
	DataType string `protobuf:"bytes,2,opt,name=data_type,json=dataType,proto3" json:"data_type,omitempty"`
	// Charset override - instead of table level charset.
	Charset string `protobuf:"bytes,3,opt,name=charset,proto3" json:"charset,omitempty"`
	// Collation override - instead of table level collation.
	Collation string `protobuf:"bytes,4,opt,name=collation,proto3" json:"collation,omitempty"`
	// Column length - e.g. varchar (50).
	Length int64 `protobuf:"varint,5,opt,name=length,proto3" json:"length,omitempty"`
	// Column precision - when relevant.
	Precision int32 `protobuf:"varint,6,opt,name=precision,proto3" json:"precision,omitempty"`
	// Column scale - when relevant.
	Scale int32 `protobuf:"varint,7,opt,name=scale,proto3" json:"scale,omitempty"`
	// Column fractional second precision - used for timestamp based datatypes.
	FractionalSecondsPrecision int32 `protobuf:"varint,8,opt,name=fractional_seconds_precision,json=fractionalSecondsPrecision,proto3" json:"fractional_seconds_precision,omitempty"`
	// Is the column of array type.
	Array bool `protobuf:"varint,9,opt,name=array,proto3" json:"array,omitempty"`
	// If the column is array, of which length.
	ArrayLength int32 `protobuf:"varint,10,opt,name=array_length,json=arrayLength,proto3" json:"array_length,omitempty"`
	// Is the column nullable.
	Nullable bool `protobuf:"varint,11,opt,name=nullable,proto3" json:"nullable,omitempty"`
	// Is the column auto-generated/identity.
	AutoGenerated bool `protobuf:"varint,12,opt,name=auto_generated,json=autoGenerated,proto3" json:"auto_generated,omitempty"`
	// Is the column a UDT.
	Udt bool `protobuf:"varint,13,opt,name=udt,proto3" json:"udt,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,14,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
	// Specifies the list of values allowed in the column.
	// Only used for set data type.
	SetValues []string `protobuf:"bytes,15,rep,name=set_values,json=setValues,proto3" json:"set_values,omitempty"`
	// Comment associated with the column.
	Comment string `protobuf:"bytes,16,opt,name=comment,proto3" json:"comment,omitempty"`
	// Column order in the table.
	OrdinalPosition int32 `protobuf:"varint,17,opt,name=ordinal_position,json=ordinalPosition,proto3" json:"ordinal_position,omitempty"`
	// Default value of the column.
	DefaultValue string `protobuf:"bytes,18,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
}

func (x *ColumnEntity) Reset() {
	*x = ColumnEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ColumnEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ColumnEntity) ProtoMessage() {}

func (x *ColumnEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ColumnEntity.ProtoReflect.Descriptor instead.
func (*ColumnEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{29}
}

func (x *ColumnEntity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ColumnEntity) GetDataType() string {
	if x != nil {
		return x.DataType
	}
	return ""
}

func (x *ColumnEntity) GetCharset() string {
	if x != nil {
		return x.Charset
	}
	return ""
}

func (x *ColumnEntity) GetCollation() string {
	if x != nil {
		return x.Collation
	}
	return ""
}

func (x *ColumnEntity) GetLength() int64 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (x *ColumnEntity) GetPrecision() int32 {
	if x != nil {
		return x.Precision
	}
	return 0
}

func (x *ColumnEntity) GetScale() int32 {
	if x != nil {
		return x.Scale
	}
	return 0
}

func (x *ColumnEntity) GetFractionalSecondsPrecision() int32 {
	if x != nil {
		return x.FractionalSecondsPrecision
	}
	return 0
}

func (x *ColumnEntity) GetArray() bool {
	if x != nil {
		return x.Array
	}
	return false
}

func (x *ColumnEntity) GetArrayLength() int32 {
	if x != nil {
		return x.ArrayLength
	}
	return 0
}

func (x *ColumnEntity) GetNullable() bool {
	if x != nil {
		return x.Nullable
	}
	return false
}

func (x *ColumnEntity) GetAutoGenerated() bool {
	if x != nil {
		return x.AutoGenerated
	}
	return false
}

func (x *ColumnEntity) GetUdt() bool {
	if x != nil {
		return x.Udt
	}
	return false
}

func (x *ColumnEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

func (x *ColumnEntity) GetSetValues() []string {
	if x != nil {
		return x.SetValues
	}
	return nil
}

func (x *ColumnEntity) GetComment() string {
	if x != nil {
		return x.Comment
	}
	return ""
}

func (x *ColumnEntity) GetOrdinalPosition() int32 {
	if x != nil {
		return x.OrdinalPosition
	}
	return 0
}

func (x *ColumnEntity) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

// Constraint is not used as an independent entity, it is retrieved
// as part of another entity such as Table or View.
type ConstraintEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the table constraint.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of constraint, for example unique, primary key, foreign key (currently
	// only primary key is supported).
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Table columns used as part of the Constraint, for example primary key
	// constraint should list the columns which constitutes the key.
	TableColumns []string `protobuf:"bytes,3,rep,name=table_columns,json=tableColumns,proto3" json:"table_columns,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,4,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
	// Reference columns which may be associated with the constraint. For example,
	// if the constraint is a FOREIGN_KEY, this represents the list of full names
	// of referenced columns by the foreign key.
	ReferenceColumns []string `protobuf:"bytes,5,rep,name=reference_columns,json=referenceColumns,proto3" json:"reference_columns,omitempty"`
	// Reference table which may be associated with the constraint. For example,
	// if the constraint is a FOREIGN_KEY, this represents the list of full name
	// of the referenced table by the foreign key.
	ReferenceTable string `protobuf:"bytes,6,opt,name=reference_table,json=referenceTable,proto3" json:"reference_table,omitempty"`
	// Table which is associated with the constraint. In case the constraint
	// is defined on a table, this field is left empty as this information is
	// stored in parent_name. However, if constraint is defined on a view, this
	// field stores the table name on which the view is defined.
	TableName string `protobuf:"bytes,7,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
}

func (x *ConstraintEntity) Reset() {
	*x = ConstraintEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConstraintEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConstraintEntity) ProtoMessage() {}

func (x *ConstraintEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConstraintEntity.ProtoReflect.Descriptor instead.
func (*ConstraintEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{30}
}

func (x *ConstraintEntity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConstraintEntity) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *ConstraintEntity) GetTableColumns() []string {
	if x != nil {
		return x.TableColumns
	}
	return nil
}

func (x *ConstraintEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

func (x *ConstraintEntity) GetReferenceColumns() []string {
	if x != nil {
		return x.ReferenceColumns
	}
	return nil
}

func (x *ConstraintEntity) GetReferenceTable() string {
	if x != nil {
		return x.ReferenceTable
	}
	return ""
}

func (x *ConstraintEntity) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

// Index is not used as an independent entity, it is retrieved as part of a
// Table entity.
type IndexEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the index.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of index, for example B-TREE.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Table columns used as part of the Index, for example B-TREE index should
	// list the columns which constitutes the index.
	TableColumns []string `protobuf:"bytes,3,rep,name=table_columns,json=tableColumns,proto3" json:"table_columns,omitempty"`
	// Boolean value indicating whether the index is unique.
	Unique bool `protobuf:"varint,4,opt,name=unique,proto3" json:"unique,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,5,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *IndexEntity) Reset() {
	*x = IndexEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IndexEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IndexEntity) ProtoMessage() {}

func (x *IndexEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IndexEntity.ProtoReflect.Descriptor instead.
func (*IndexEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{31}
}

func (x *IndexEntity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *IndexEntity) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *IndexEntity) GetTableColumns() []string {
	if x != nil {
		return x.TableColumns
	}
	return nil
}

func (x *IndexEntity) GetUnique() bool {
	if x != nil {
		return x.Unique
	}
	return false
}

func (x *IndexEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Trigger is not used as an independent entity, it is retrieved as part of a
// Table entity.
type TriggerEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the trigger.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The DML, DDL, or database events that fire the trigger, for example
	// INSERT, UPDATE.
	TriggeringEvents []string `protobuf:"bytes,2,rep,name=triggering_events,json=triggeringEvents,proto3" json:"triggering_events,omitempty"`
	// Indicates when the trigger fires, for example BEFORE STATEMENT, AFTER EACH
	// ROW.
	TriggerType string `protobuf:"bytes,3,opt,name=trigger_type,json=triggerType,proto3" json:"trigger_type,omitempty"`
	// The SQL code which creates the trigger.
	SqlCode string `protobuf:"bytes,4,opt,name=sql_code,json=sqlCode,proto3" json:"sql_code,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,5,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *TriggerEntity) Reset() {
	*x = TriggerEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TriggerEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TriggerEntity) ProtoMessage() {}

func (x *TriggerEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TriggerEntity.ProtoReflect.Descriptor instead.
func (*TriggerEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{32}
}

func (x *TriggerEntity) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TriggerEntity) GetTriggeringEvents() []string {
	if x != nil {
		return x.TriggeringEvents
	}
	return nil
}

func (x *TriggerEntity) GetTriggerType() string {
	if x != nil {
		return x.TriggerType
	}
	return ""
}

func (x *TriggerEntity) GetSqlCode() string {
	if x != nil {
		return x.SqlCode
	}
	return ""
}

func (x *TriggerEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// View's parent is a schema.
type ViewEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL code which creates the view.
	SqlCode string `protobuf:"bytes,1,opt,name=sql_code,json=sqlCode,proto3" json:"sql_code,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,2,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
	// View constraints.
	Constraints []*ConstraintEntity `protobuf:"bytes,3,rep,name=constraints,proto3" json:"constraints,omitempty"`
}

func (x *ViewEntity) Reset() {
	*x = ViewEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ViewEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ViewEntity) ProtoMessage() {}

func (x *ViewEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ViewEntity.ProtoReflect.Descriptor instead.
func (*ViewEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{33}
}

func (x *ViewEntity) GetSqlCode() string {
	if x != nil {
		return x.SqlCode
	}
	return ""
}

func (x *ViewEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

func (x *ViewEntity) GetConstraints() []*ConstraintEntity {
	if x != nil {
		return x.Constraints
	}
	return nil
}

// Sequence's parent is a schema.
type SequenceEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Increment value for the sequence.
	Increment int64 `protobuf:"varint,1,opt,name=increment,proto3" json:"increment,omitempty"`
	// Start number for the sequence represented as bytes to accommodate large.
	// numbers
	StartValue []byte `protobuf:"bytes,2,opt,name=start_value,json=startValue,proto3" json:"start_value,omitempty"`
	// Maximum number for the sequence represented as bytes to accommodate large.
	// numbers
	MaxValue []byte `protobuf:"bytes,3,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// Minimum number for the sequence represented as bytes to accommodate large.
	// numbers
	MinValue []byte `protobuf:"bytes,4,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// Indicates whether the sequence value should cycle through.
	Cycle bool `protobuf:"varint,5,opt,name=cycle,proto3" json:"cycle,omitempty"`
	// Indicates number of entries to cache / precreate.
	Cache int64 `protobuf:"varint,6,opt,name=cache,proto3" json:"cache,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,7,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *SequenceEntity) Reset() {
	*x = SequenceEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SequenceEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SequenceEntity) ProtoMessage() {}

func (x *SequenceEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SequenceEntity.ProtoReflect.Descriptor instead.
func (*SequenceEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{34}
}

func (x *SequenceEntity) GetIncrement() int64 {
	if x != nil {
		return x.Increment
	}
	return 0
}

func (x *SequenceEntity) GetStartValue() []byte {
	if x != nil {
		return x.StartValue
	}
	return nil
}

func (x *SequenceEntity) GetMaxValue() []byte {
	if x != nil {
		return x.MaxValue
	}
	return nil
}

func (x *SequenceEntity) GetMinValue() []byte {
	if x != nil {
		return x.MinValue
	}
	return nil
}

func (x *SequenceEntity) GetCycle() bool {
	if x != nil {
		return x.Cycle
	}
	return false
}

func (x *SequenceEntity) GetCache() int64 {
	if x != nil {
		return x.Cache
	}
	return 0
}

func (x *SequenceEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Stored procedure's parent is a schema.
type StoredProcedureEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL code which creates the stored procedure.
	SqlCode string `protobuf:"bytes,1,opt,name=sql_code,json=sqlCode,proto3" json:"sql_code,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,2,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *StoredProcedureEntity) Reset() {
	*x = StoredProcedureEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StoredProcedureEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoredProcedureEntity) ProtoMessage() {}

func (x *StoredProcedureEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoredProcedureEntity.ProtoReflect.Descriptor instead.
func (*StoredProcedureEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{35}
}

func (x *StoredProcedureEntity) GetSqlCode() string {
	if x != nil {
		return x.SqlCode
	}
	return ""
}

func (x *StoredProcedureEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Function's parent is a schema.
type FunctionEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL code which creates the function.
	SqlCode string `protobuf:"bytes,1,opt,name=sql_code,json=sqlCode,proto3" json:"sql_code,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,2,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *FunctionEntity) Reset() {
	*x = FunctionEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FunctionEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FunctionEntity) ProtoMessage() {}

func (x *FunctionEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FunctionEntity.ProtoReflect.Descriptor instead.
func (*FunctionEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{36}
}

func (x *FunctionEntity) GetSqlCode() string {
	if x != nil {
		return x.SqlCode
	}
	return ""
}

func (x *FunctionEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// MaterializedView's parent is a schema.
type MaterializedViewEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL code which creates the view.
	SqlCode string `protobuf:"bytes,1,opt,name=sql_code,json=sqlCode,proto3" json:"sql_code,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,2,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *MaterializedViewEntity) Reset() {
	*x = MaterializedViewEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MaterializedViewEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MaterializedViewEntity) ProtoMessage() {}

func (x *MaterializedViewEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MaterializedViewEntity.ProtoReflect.Descriptor instead.
func (*MaterializedViewEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{37}
}

func (x *MaterializedViewEntity) GetSqlCode() string {
	if x != nil {
		return x.SqlCode
	}
	return ""
}

func (x *MaterializedViewEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Synonym's parent is a schema.
type SynonymEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the entity for which the synonym is being created (the source).
	SourceEntity string `protobuf:"bytes,1,opt,name=source_entity,json=sourceEntity,proto3" json:"source_entity,omitempty"`
	// The type of the entity for which the synonym is being created
	// (usually a table or a sequence).
	SourceType DatabaseEntityType `protobuf:"varint,2,opt,name=source_type,json=sourceType,proto3,enum=google.cloud.clouddms.v1.DatabaseEntityType" json:"source_type,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,3,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *SynonymEntity) Reset() {
	*x = SynonymEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SynonymEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SynonymEntity) ProtoMessage() {}

func (x *SynonymEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SynonymEntity.ProtoReflect.Descriptor instead.
func (*SynonymEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{38}
}

func (x *SynonymEntity) GetSourceEntity() string {
	if x != nil {
		return x.SourceEntity
	}
	return ""
}

func (x *SynonymEntity) GetSourceType() DatabaseEntityType {
	if x != nil {
		return x.SourceType
	}
	return DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED
}

func (x *SynonymEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Package's parent is a schema.
type PackageEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL code which creates the package.
	PackageSqlCode string `protobuf:"bytes,1,opt,name=package_sql_code,json=packageSqlCode,proto3" json:"package_sql_code,omitempty"`
	// The SQL code which creates the package body. If the package specification
	// has cursors or subprograms, then the package body is mandatory.
	PackageBody string `protobuf:"bytes,2,opt,name=package_body,json=packageBody,proto3" json:"package_body,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,3,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *PackageEntity) Reset() {
	*x = PackageEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PackageEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PackageEntity) ProtoMessage() {}

func (x *PackageEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PackageEntity.ProtoReflect.Descriptor instead.
func (*PackageEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{39}
}

func (x *PackageEntity) GetPackageSqlCode() string {
	if x != nil {
		return x.PackageSqlCode
	}
	return ""
}

func (x *PackageEntity) GetPackageBody() string {
	if x != nil {
		return x.PackageBody
	}
	return ""
}

func (x *PackageEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// UDT's parent is a schema.
type UDTEntity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SQL code which creates the udt.
	UdtSqlCode string `protobuf:"bytes,1,opt,name=udt_sql_code,json=udtSqlCode,proto3" json:"udt_sql_code,omitempty"`
	// The SQL code which creates the udt body.
	UdtBody string `protobuf:"bytes,2,opt,name=udt_body,json=udtBody,proto3" json:"udt_body,omitempty"`
	// Custom engine specific features.
	CustomFeatures *structpb.Struct `protobuf:"bytes,3,opt,name=custom_features,json=customFeatures,proto3" json:"custom_features,omitempty"`
}

func (x *UDTEntity) Reset() {
	*x = UDTEntity{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UDTEntity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UDTEntity) ProtoMessage() {}

func (x *UDTEntity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UDTEntity.ProtoReflect.Descriptor instead.
func (*UDTEntity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{40}
}

func (x *UDTEntity) GetUdtSqlCode() string {
	if x != nil {
		return x.UdtSqlCode
	}
	return ""
}

func (x *UDTEntity) GetUdtBody() string {
	if x != nil {
		return x.UdtBody
	}
	return ""
}

func (x *UDTEntity) GetCustomFeatures() *structpb.Struct {
	if x != nil {
		return x.CustomFeatures
	}
	return nil
}

// Details of the mappings of a database entity.
type EntityMapping struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source entity full name.
	// The source entity can also be a column, index or constraint using the
	// same naming notation schema.table.column.
	SourceEntity string `protobuf:"bytes,1,opt,name=source_entity,json=sourceEntity,proto3" json:"source_entity,omitempty"`
	// Target entity full name.
	// The draft entity can also include a column, index or constraint using the
	// same naming notation schema.table.column.
	DraftEntity string `protobuf:"bytes,2,opt,name=draft_entity,json=draftEntity,proto3" json:"draft_entity,omitempty"`
	// Type of source entity.
	SourceType DatabaseEntityType `protobuf:"varint,4,opt,name=source_type,json=sourceType,proto3,enum=google.cloud.clouddms.v1.DatabaseEntityType" json:"source_type,omitempty"`
	// Type of draft entity.
	DraftType DatabaseEntityType `protobuf:"varint,5,opt,name=draft_type,json=draftType,proto3,enum=google.cloud.clouddms.v1.DatabaseEntityType" json:"draft_type,omitempty"`
	// Entity mapping log entries.
	// Multiple rules can be effective and contribute changes to a converted
	// entity, such as a rule can handle the entity name, another rule can handle
	// an entity type. In addition, rules which did not change the entity are also
	// logged along with the reason preventing them to do so.
	MappingLog []*EntityMappingLogEntry `protobuf:"bytes,3,rep,name=mapping_log,json=mappingLog,proto3" json:"mapping_log,omitempty"`
}

func (x *EntityMapping) Reset() {
	*x = EntityMapping{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntityMapping) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityMapping) ProtoMessage() {}

func (x *EntityMapping) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityMapping.ProtoReflect.Descriptor instead.
func (*EntityMapping) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{41}
}

func (x *EntityMapping) GetSourceEntity() string {
	if x != nil {
		return x.SourceEntity
	}
	return ""
}

func (x *EntityMapping) GetDraftEntity() string {
	if x != nil {
		return x.DraftEntity
	}
	return ""
}

func (x *EntityMapping) GetSourceType() DatabaseEntityType {
	if x != nil {
		return x.SourceType
	}
	return DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED
}

func (x *EntityMapping) GetDraftType() DatabaseEntityType {
	if x != nil {
		return x.DraftType
	}
	return DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED
}

func (x *EntityMapping) GetMappingLog() []*EntityMappingLogEntry {
	if x != nil {
		return x.MappingLog
	}
	return nil
}

// A single record of a rule which was used for a mapping.
type EntityMappingLogEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Which rule caused this log entry.
	RuleId string `protobuf:"bytes,1,opt,name=rule_id,json=ruleId,proto3" json:"rule_id,omitempty"`
	// Rule revision ID.
	RuleRevisionId string `protobuf:"bytes,2,opt,name=rule_revision_id,json=ruleRevisionId,proto3" json:"rule_revision_id,omitempty"`
	// Comment.
	MappingComment string `protobuf:"bytes,3,opt,name=mapping_comment,json=mappingComment,proto3" json:"mapping_comment,omitempty"`
}

func (x *EntityMappingLogEntry) Reset() {
	*x = EntityMappingLogEntry{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntityMappingLogEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityMappingLogEntry) ProtoMessage() {}

func (x *EntityMappingLogEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityMappingLogEntry.ProtoReflect.Descriptor instead.
func (*EntityMappingLogEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{42}
}

func (x *EntityMappingLogEntry) GetRuleId() string {
	if x != nil {
		return x.RuleId
	}
	return ""
}

func (x *EntityMappingLogEntry) GetRuleRevisionId() string {
	if x != nil {
		return x.RuleRevisionId
	}
	return ""
}

func (x *EntityMappingLogEntry) GetMappingComment() string {
	if x != nil {
		return x.MappingComment
	}
	return ""
}

// A single DDL statement for a specific entity
type EntityDdl struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of DDL (Create, Alter).
	DdlType string `protobuf:"bytes,1,opt,name=ddl_type,json=ddlType,proto3" json:"ddl_type,omitempty"`
	// The name of the database entity the ddl refers to.
	Entity string `protobuf:"bytes,2,opt,name=entity,proto3" json:"entity,omitempty"`
	// The actual ddl code.
	Ddl string `protobuf:"bytes,3,opt,name=ddl,proto3" json:"ddl,omitempty"`
	// The entity type (if the DDL is for a sub entity).
	EntityType DatabaseEntityType `protobuf:"varint,4,opt,name=entity_type,json=entityType,proto3,enum=google.cloud.clouddms.v1.DatabaseEntityType" json:"entity_type,omitempty"`
	// EntityIssues found for this ddl.
	IssueId []string `protobuf:"bytes,100,rep,name=issue_id,json=issueId,proto3" json:"issue_id,omitempty"`
}

func (x *EntityDdl) Reset() {
	*x = EntityDdl{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntityDdl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityDdl) ProtoMessage() {}

func (x *EntityDdl) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityDdl.ProtoReflect.Descriptor instead.
func (*EntityDdl) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{43}
}

func (x *EntityDdl) GetDdlType() string {
	if x != nil {
		return x.DdlType
	}
	return ""
}

func (x *EntityDdl) GetEntity() string {
	if x != nil {
		return x.Entity
	}
	return ""
}

func (x *EntityDdl) GetDdl() string {
	if x != nil {
		return x.Ddl
	}
	return ""
}

func (x *EntityDdl) GetEntityType() DatabaseEntityType {
	if x != nil {
		return x.EntityType
	}
	return DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED
}

func (x *EntityDdl) GetIssueId() []string {
	if x != nil {
		return x.IssueId
	}
	return nil
}

// Issue related to the entity.
type EntityIssue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique Issue ID.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The type of the issue.
	Type EntityIssue_IssueType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.clouddms.v1.EntityIssue_IssueType" json:"type,omitempty"`
	// Severity of the issue
	Severity EntityIssue_IssueSeverity `protobuf:"varint,3,opt,name=severity,proto3,enum=google.cloud.clouddms.v1.EntityIssue_IssueSeverity" json:"severity,omitempty"`
	// Issue detailed message
	Message string `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
	// Error/Warning code
	Code string `protobuf:"bytes,5,opt,name=code,proto3" json:"code,omitempty"`
	// The ddl which caused the issue, if relevant.
	Ddl *string `protobuf:"bytes,6,opt,name=ddl,proto3,oneof" json:"ddl,omitempty"`
	// The position of the issue found, if relevant.
	Position *EntityIssue_Position `protobuf:"bytes,7,opt,name=position,proto3,oneof" json:"position,omitempty"`
	// The entity type (if the DDL is for a sub entity).
	EntityType DatabaseEntityType `protobuf:"varint,8,opt,name=entity_type,json=entityType,proto3,enum=google.cloud.clouddms.v1.DatabaseEntityType" json:"entity_type,omitempty"`
}

func (x *EntityIssue) Reset() {
	*x = EntityIssue{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntityIssue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityIssue) ProtoMessage() {}

func (x *EntityIssue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityIssue.ProtoReflect.Descriptor instead.
func (*EntityIssue) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{44}
}

func (x *EntityIssue) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *EntityIssue) GetType() EntityIssue_IssueType {
	if x != nil {
		return x.Type
	}
	return EntityIssue_ISSUE_TYPE_UNSPECIFIED
}

func (x *EntityIssue) GetSeverity() EntityIssue_IssueSeverity {
	if x != nil {
		return x.Severity
	}
	return EntityIssue_ISSUE_SEVERITY_UNSPECIFIED
}

func (x *EntityIssue) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *EntityIssue) GetCode() string {
	if x != nil {
		return x.Code
	}
	return ""
}

func (x *EntityIssue) GetDdl() string {
	if x != nil && x.Ddl != nil {
		return *x.Ddl
	}
	return ""
}

func (x *EntityIssue) GetPosition() *EntityIssue_Position {
	if x != nil {
		return x.Position
	}
	return nil
}

func (x *EntityIssue) GetEntityType() DatabaseEntityType {
	if x != nil {
		return x.EntityType
	}
	return DatabaseEntityType_DATABASE_ENTITY_TYPE_UNSPECIFIED
}

// Details regarding a Seed background job.
type BackgroundJobLogEntry_SeedJobDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The connection profile which was used for the seed job.
	ConnectionProfile string `protobuf:"bytes,1,opt,name=connection_profile,json=connectionProfile,proto3" json:"connection_profile,omitempty"`
}

func (x *BackgroundJobLogEntry_SeedJobDetails) Reset() {
	*x = BackgroundJobLogEntry_SeedJobDetails{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackgroundJobLogEntry_SeedJobDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackgroundJobLogEntry_SeedJobDetails) ProtoMessage() {}

func (x *BackgroundJobLogEntry_SeedJobDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackgroundJobLogEntry_SeedJobDetails.ProtoReflect.Descriptor instead.
func (*BackgroundJobLogEntry_SeedJobDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2, 0}
}

func (x *BackgroundJobLogEntry_SeedJobDetails) GetConnectionProfile() string {
	if x != nil {
		return x.ConnectionProfile
	}
	return ""
}

// Details regarding an Import Rules background job.
type BackgroundJobLogEntry_ImportRulesJobDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. File names used for the import rules job.
	Files []string `protobuf:"bytes,1,rep,name=files,proto3" json:"files,omitempty"`
	// Output only. The requested file format.
	FileFormat ImportRulesFileFormat `protobuf:"varint,2,opt,name=file_format,json=fileFormat,proto3,enum=google.cloud.clouddms.v1.ImportRulesFileFormat" json:"file_format,omitempty"`
}

func (x *BackgroundJobLogEntry_ImportRulesJobDetails) Reset() {
	*x = BackgroundJobLogEntry_ImportRulesJobDetails{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackgroundJobLogEntry_ImportRulesJobDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackgroundJobLogEntry_ImportRulesJobDetails) ProtoMessage() {}

func (x *BackgroundJobLogEntry_ImportRulesJobDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackgroundJobLogEntry_ImportRulesJobDetails.ProtoReflect.Descriptor instead.
func (*BackgroundJobLogEntry_ImportRulesJobDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2, 1}
}

func (x *BackgroundJobLogEntry_ImportRulesJobDetails) GetFiles() []string {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *BackgroundJobLogEntry_ImportRulesJobDetails) GetFileFormat() ImportRulesFileFormat {
	if x != nil {
		return x.FileFormat
	}
	return ImportRulesFileFormat_IMPORT_RULES_FILE_FORMAT_UNSPECIFIED
}

// Details regarding a Convert background job.
type BackgroundJobLogEntry_ConvertJobDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. AIP-160 based filter used to specify the entities to convert
	Filter string `protobuf:"bytes,1,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *BackgroundJobLogEntry_ConvertJobDetails) Reset() {
	*x = BackgroundJobLogEntry_ConvertJobDetails{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackgroundJobLogEntry_ConvertJobDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackgroundJobLogEntry_ConvertJobDetails) ProtoMessage() {}

func (x *BackgroundJobLogEntry_ConvertJobDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackgroundJobLogEntry_ConvertJobDetails.ProtoReflect.Descriptor instead.
func (*BackgroundJobLogEntry_ConvertJobDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2, 2}
}

func (x *BackgroundJobLogEntry_ConvertJobDetails) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Details regarding an Apply background job.
type BackgroundJobLogEntry_ApplyJobDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The connection profile which was used for the apply job.
	ConnectionProfile string `protobuf:"bytes,1,opt,name=connection_profile,json=connectionProfile,proto3" json:"connection_profile,omitempty"`
	// Output only. AIP-160 based filter used to specify the entities to apply
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *BackgroundJobLogEntry_ApplyJobDetails) Reset() {
	*x = BackgroundJobLogEntry_ApplyJobDetails{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackgroundJobLogEntry_ApplyJobDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackgroundJobLogEntry_ApplyJobDetails) ProtoMessage() {}

func (x *BackgroundJobLogEntry_ApplyJobDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackgroundJobLogEntry_ApplyJobDetails.ProtoReflect.Descriptor instead.
func (*BackgroundJobLogEntry_ApplyJobDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{2, 3}
}

func (x *BackgroundJobLogEntry_ApplyJobDetails) GetConnectionProfile() string {
	if x != nil {
		return x.ConnectionProfile
	}
	return ""
}

func (x *BackgroundJobLogEntry_ApplyJobDetails) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Issue position.
type EntityIssue_Position struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Issue line number
	Line int32 `protobuf:"varint,1,opt,name=line,proto3" json:"line,omitempty"`
	// Issue column number
	Column int32 `protobuf:"varint,2,opt,name=column,proto3" json:"column,omitempty"`
	// Issue offset
	Offset int32 `protobuf:"varint,3,opt,name=offset,proto3" json:"offset,omitempty"`
	// Issue length
	Length int32 `protobuf:"varint,4,opt,name=length,proto3" json:"length,omitempty"`
}

func (x *EntityIssue_Position) Reset() {
	*x = EntityIssue_Position{}
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntityIssue_Position) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntityIssue_Position) ProtoMessage() {}

func (x *EntityIssue_Position) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntityIssue_Position.ProtoReflect.Descriptor instead.
func (*EntityIssue_Position) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP(), []int{44, 0}
}

func (x *EntityIssue_Position) GetLine() int32 {
	if x != nil {
		return x.Line
	}
	return 0
}

func (x *EntityIssue_Position) GetColumn() int32 {
	if x != nil {
		return x.Column
	}
	return 0
}

func (x *EntityIssue_Position) GetOffset() int32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *EntityIssue_Position) GetLength() int32 {
	if x != nil {
		return x.Length
	}
	return 0
}

var File_google_cloud_clouddms_v1_conversionworkspace_resources_proto protoreflect.FileDescriptor

var file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x7a, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x45, 0x0a, 0x06, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x9d, 0x07, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f,
	0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6f, 0x0a, 0x0f, 0x67,
	0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x2e, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x67, 0x6c,
	0x6f, 0x62, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x17,
	0x68, 0x61, 0x73, 0x5f, 0x75, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x15, 0x68, 0x61, 0x73, 0x55, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74,
	0x65, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74,
	0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x12, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x1a, 0x41, 0x0a, 0x13, 0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xb6, 0x01, 0xea, 0x41, 0xb2, 0x01, 0x0a, 0x30, 0x64,
	0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x12,
	0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x7d, 0x2a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x32, 0x13, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22,
	0xf8, 0x0a, 0x0a, 0x15, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f,
	0x62, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x46, 0x0a, 0x08, 0x6a, 0x6f, 0x62,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x52, 0x07, 0x6a, 0x6f, 0x62, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b,
	0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x66,
	0x69, 0x6e, 0x69, 0x73, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x72, 0x0a, 0x10, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x4c, 0x6f, 0x67, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x32, 0x0a,
	0x12, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x32, 0x0a, 0x12, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x75, 0x74,
	0x6f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x12, 0x6f, 0x0a, 0x10, 0x73, 0x65, 0x65, 0x64, 0x5f, 0x6a, 0x6f,
	0x62, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x67,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x53, 0x65, 0x65, 0x64, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x65, 0x65, 0x64, 0x4a, 0x6f, 0x62, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x85, 0x01, 0x0a, 0x18, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a,
	0x6f, 0x62, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x15, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x75, 0x6c, 0x65, 0x73, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x78,
	0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x4a, 0x6f, 0x62, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x4a, 0x6f,
	0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x72, 0x0a, 0x11, 0x61, 0x70, 0x70, 0x6c,
	0x79, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x67, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x4c, 0x6f, 0x67, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x61, 0x70, 0x70,
	0x6c, 0x79, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x44, 0x0a, 0x0e,
	0x53, 0x65, 0x65, 0x64, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x32,
	0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x1a, 0x89, 0x01, 0x0a, 0x15, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6c,
	0x65, 0x73, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x19, 0x0a, 0x05,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x55, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75,
	0x6c, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x1a, 0x30,
	0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x1a, 0x62, 0x0a, 0x0f, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x4a, 0x6f, 0x62, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x32, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x22, 0x55, 0x0a, 0x12, 0x4a, 0x6f, 0x62, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x4a, 0x4f,
	0x42, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x6a,
	0x6f, 0x62, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xfb, 0x01, 0x0a, 0x11, 0x4d,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x28, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x31, 0x0a, 0x12, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x31, 0x0a,
	0x12, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x75, 0x66,
	0x66, 0x69, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78,
	0x12, 0x35, 0x0a, 0x14, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x12, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0xd5, 0x0e, 0x0a, 0x0b, 0x4d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x50, 0x0a, 0x0a,
	0x72, 0x75, 0x6c, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x72, 0x75, 0x6c, 0x65, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x48,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x52, 0x75, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x75, 0x6c, 0x65,
	0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x72, 0x75, 0x6c, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x24, 0x0a, 0x0b,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x51, 0x0a, 0x14, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x12, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x66, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x69, 0x6e, 0x67, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x6e, 0x61, 0x6d,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x62, 0x0a, 0x13,
	0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x11, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x4c, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x76, 0x65, 0x18,
	0x69, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x76, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x76, 0x65, 0x12, 0x65,
	0x0a, 0x14, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x6a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x43, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x12, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x7c, 0x0a, 0x1d, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x6b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x74, 0x79, 0x70, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x19, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x7b, 0x0a, 0x1c, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x6c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x19, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x67, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x5f, 0x72, 0x6f, 0x77, 0x69,
	0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x72, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x74, 0x52, 0x6f, 0x77, 0x49, 0x64, 0x54, 0x6f, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x52, 0x6f,
	0x77, 0x69, 0x64, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x66, 0x0a, 0x15, 0x73, 0x65, 0x74,
	0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x6b,
	0x65, 0x79, 0x18, 0x73, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x6d,
	0x61, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x73,
	0x65, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x4b, 0x65,
	0x79, 0x12, 0x68, 0x0a, 0x15, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x74, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x69, 0x6e, 0x67,
	0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x13, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x50, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x5c, 0x0a, 0x11, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x18, 0x75, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x71, 0x6c, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x53, 0x71, 0x6c, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x73, 0x18, 0x76, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73,
	0x22, 0x46, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x03, 0x3a, 0xba, 0x01, 0xea, 0x41, 0xb6, 0x01, 0x0a,
	0x28, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x6f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x6d,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x6d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x7d, 0x2a, 0x0c, 0x6d, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x32, 0x0b, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x22, 0x34, 0x0a, 0x12, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x6e, 0x65, 0x77, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6e,
	0x65, 0x77, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xb9, 0x01, 0x0a, 0x11, 0x4d, 0x75, 0x6c, 0x74, 0x69,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x10,
	0x6e, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x6e, 0x65, 0x77,
	0x4e, 0x61, 0x6d, 0x65, 0x50, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6e, 0x12, 0x75, 0x0a, 0x1a, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x30, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x76, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x6e, 0x65, 0x77, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6e, 0x65, 0x77, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x22, 0xcb, 0x04, 0x0a, 0x12, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a,
	0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x12, 0x21, 0x0a, 0x09,
	0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1b, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x21, 0x0a, 0x09,
	0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x19, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x45, 0x0a, 0x1c, 0x66, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73,
	0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x19, 0x0a, 0x05, 0x61, 0x72, 0x72, 0x61, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x61, 0x72, 0x72, 0x61, 0x79, 0x12, 0x26, 0x0a, 0x0c,
	0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x72, 0x72, 0x61, 0x79, 0x4c, 0x65,
	0x6e, 0x67, 0x74, 0x68, 0x12, 0x1f, 0x0a, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6e, 0x75, 0x6c,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x6f, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x64, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x64, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x03, 0x75, 0x64, 0x74, 0x12, 0x45, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12,
	0x22, 0x0a, 0x0a, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x0e, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x74, 0x22, 0x89, 0x05, 0x0a, 0x19, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x74, 0x79, 0x70, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x3a, 0x0a, 0x17, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5f, 0x0a, 0x12,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x65, 0x78, 0x74, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x54, 0x65, 0x78, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x68, 0x0a,
	0x15, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x75,
	0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x13, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69,
	0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0d, 0x6e, 0x65, 0x77, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6e, 0x65, 0x77, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x2c, 0x0a, 0x0f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x5f, 0x6c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x2a,
	0x0a, 0x0e, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x5f, 0x73, 0x63, 0x61, 0x6c, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x32, 0x0a, 0x12, 0x6f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6f, 0x76, 0x65,
	0x72, 0x72, 0x69, 0x64, 0x65, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x56,
	0x0a, 0x25, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x5f, 0x66, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x5f, 0x70, 0x72,
	0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x22, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x46, 0x72, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x50, 0x72, 0x65,
	0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x42, 0x0f, 0x0a,
	0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8e,
	0x01, 0x0a, 0x10, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x65, 0x78, 0x74, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x3c, 0x0a, 0x18, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x69,
	0x6e, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4d, 0x69, 0x6e, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x3c, 0x0a, 0x18, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x5f,
	0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x4d, 0x61, 0x78, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22,
	0xfd, 0x02, 0x0a, 0x13, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69,
	0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x3a, 0x0a, 0x17, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x69, 0x6e, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x3a, 0x0a, 0x17, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x61,
	0x78, 0x5f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4d, 0x61, 0x78, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x42, 0x0a, 0x1b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x72,
	0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4d, 0x69, 0x6e, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x42, 0x0a, 0x1b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x61,
	0x78, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x78, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x66, 0x0a, 0x15, 0x6e, 0x75, 0x6d, 0x65, 0x72,
	0x69, 0x63, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x6e, 0x75, 0x6d, 0x65,
	0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xa5, 0x03, 0x0a, 0x19, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x5f, 0x0a,
	0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x65, 0x78, 0x74, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x54, 0x65, 0x78, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x68,
	0x0a, 0x15, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e,
	0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x13, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x65, 0x72,
	0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x65, 0x0a, 0x14, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x45, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xd2, 0x06, 0x0a, 0x13, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x36, 0x0a, 0x07, 0x69, 0x73, 0x5f, 0x6e, 0x75, 0x6c, 0x6c, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x06, 0x69, 0x73, 0x4e, 0x75, 0x6c, 0x6c, 0x12, 0x4f, 0x0a, 0x0a, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x4c, 0x69, 0x73, 0x74,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x09, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x5b, 0x0a, 0x0e, 0x69, 0x6e, 0x74, 0x5f,
	0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x43,
	0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x61,
	0x72, 0x69, 0x73, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x11, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f,
	0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x75, 0x62,
	0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x64, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x0b, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x5f, 0x6e, 0x75, 0x6c, 0x6c, 0x18, 0xc8, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01,
	0x52, 0x0a, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x4e, 0x75, 0x6c, 0x6c, 0x12, 0x69, 0x0a, 0x15,
	0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0xc9, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x01, 0x52, 0x13, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66,
	0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x48, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0xca, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x01, 0x52, 0x0e, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x4d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x48, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x5f, 0x6d, 0x61, 0x78, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0xcb, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0e, 0x61, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x4d, 0x61, 0x78, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x4f, 0x0a, 0x0b, 0x72,
	0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0xcc, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75,
	0x6e, 0x64, 0x54, 0x6f, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01,
	0x52, 0x0a, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x4a, 0x0a, 0x0a,
	0x61, 0x70, 0x70, 0x6c, 0x79, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0xcd, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x79, 0x48, 0x61, 0x73, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x09, 0x61,
	0x70, 0x70, 0x6c, 0x79, 0x48, 0x61, 0x73, 0x68, 0x42, 0x08, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4f, 0x0a, 0x14,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x52, 0x6f, 0x77, 0x49, 0x64, 0x54, 0x6f, 0x43, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x37, 0x0a, 0x16, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x69, 0x66, 0x5f,
	0x6e, 0x6f, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x6f, 0x6e, 0x6c, 0x79, 0x49,
	0x66, 0x4e, 0x6f, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x22, 0x6f, 0x0a,
	0x12, 0x53, 0x65, 0x74, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
	0x4b, 0x65, 0x79, 0x12, 0x33, 0x0a, 0x13, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x4b, 0x65,
	0x79, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x6d,
	0x61, 0x72, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x4b, 0x65, 0x79, 0x22, 0x73,
	0x0a, 0x13, 0x53, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x34, 0x0a, 0x13, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x42,
	0x6f, 0x64, 0x79, 0x22, 0x31, 0x0a, 0x0f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x71, 0x6c,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73,
	0x71, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x70, 0x0a, 0x12, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x0f,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64,
	0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x22, 0xb5, 0x01, 0x0a, 0x0f, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5f, 0x0a, 0x12,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x69,
	0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
	0x49, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x1b, 0x0a,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x67,
	0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x61, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x43, 0x61, 0x73, 0x65,
	0x22, 0x8b, 0x01, 0x0a, 0x13, 0x49, 0x6e, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73,
	0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x59, 0x0a, 0x10, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69,
	0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x8e,
	0x01, 0x0a, 0x16, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69,
	0x73, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x59, 0x0a, 0x10, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72,
	0x69, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0x30, 0x0a, 0x13, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
	0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0x63, 0x0a, 0x09, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x48, 0x61, 0x73, 0x68, 0x12, 0x45,
	0x0a, 0x0f, 0x75, 0x75, 0x69, 0x64, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x75, 0x75, 0x69, 0x64, 0x46, 0x72, 0x6f, 0x6d,
	0x42, 0x79, 0x74, 0x65, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x29, 0x0a, 0x0c, 0x52, 0x6f, 0x75, 0x6e, 0x64, 0x54,
	0x6f, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c,
	0x65, 0x22, 0xd1, 0x0a, 0x0a, 0x0e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x45, 0x0a, 0x04, 0x74, 0x72, 0x65, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x2e, 0x54, 0x72, 0x65, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x72, 0x65, 0x65, 0x12,
	0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x43,
	0x0a, 0x08, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x6d, 0x61, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x42, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x64, 0x64,
	0x6c, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x44, 0x64, 0x6c, 0x52, 0x09, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x44, 0x64, 0x6c, 0x12, 0x3d, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x52, 0x06,
	0x69, 0x73, 0x73, 0x75, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x08, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00,
	0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x3d, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x67, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00,
	0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x3a, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x68, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x69, 0x65, 0x77, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x04, 0x76,
	0x69, 0x65, 0x77, 0x12, 0x46, 0x0a, 0x08, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x69, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48,
	0x00, 0x52, 0x08, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x64, 0x75, 0x72, 0x65, 0x18,
	0x6a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x64, 0x75, 0x72, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64,
	0x50, 0x72, 0x6f, 0x63, 0x65, 0x64, 0x75, 0x72, 0x65, 0x12, 0x57, 0x0a, 0x11, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x6b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00,
	0x52, 0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x43, 0x0a, 0x07, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x18, 0x6c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x07,
	0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x12, 0x54, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x6d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x0f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x37, 0x0a,
	0x03, 0x75, 0x64, 0x74, 0x18, 0x6e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x44, 0x54, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x48,
	0x00, 0x52, 0x03, 0x75, 0x64, 0x74, 0x12, 0x5f, 0x0a, 0x11, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x6f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x74,
	0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x10, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x22, 0x4d, 0x0a, 0x08, 0x54, 0x72, 0x65, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x52, 0x45, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x52,
	0x41, 0x46, 0x54, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x42, 0x0d, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x62, 0x6f, 0x64, 0x79, 0x22, 0x5a, 0x0a, 0x16, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12,
	0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x22, 0x50, 0x0a, 0x0c, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x22, 0xff, 0x02, 0x0a, 0x0b, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x12, 0x40, 0x0a, 0x07, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x07, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x73, 0x12, 0x3f, 0x0a, 0x07, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x07, 0x69, 0x6e, 0x64,
	0x69, 0x63, 0x65, 0x73, 0x12, 0x43, 0x0a, 0x08, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52,
	0x08, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f,
	0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xde, 0x04, 0x0a, 0x0c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73,
	0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65,
	0x74, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x1c, 0x66,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x73, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x1a, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x53, 0x65, 0x63,
	0x6f, 0x6e, 0x64, 0x73, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a,
	0x05, 0x61, 0x72, 0x72, 0x61, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x61, 0x72,
	0x72, 0x61, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x6c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x61, 0x72, 0x72, 0x61, 0x79,
	0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x1a, 0x0a, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6e, 0x75, 0x6c, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61, 0x75, 0x74, 0x6f,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x64, 0x74,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x75, 0x64, 0x74, 0x12, 0x40, 0x0a, 0x0f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x1d, 0x0a,
	0x0a, 0x73, 0x65, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x09, 0x73, 0x65, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63,
	0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61,
	0x6c, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0f, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x96, 0x02, 0x0a, 0x10, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22,
	0xb4, 0x01, 0x0a, 0x0b, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73, 0x12, 0x16, 0x0a, 0x06,
	0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x75, 0x6e,
	0x69, 0x71, 0x75, 0x65, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22, 0xd0, 0x01, 0x0a, 0x0d, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x11,
	0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08,
	0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x73, 0x71, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22, 0xb7, 0x01, 0x0a, 0x0a, 0x56, 0x69,
	0x65, 0x77, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x71, 0x6c, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x71, 0x6c, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x73, 0x22, 0xf7, 0x01, 0x0a, 0x0e, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x69, 0x6e, 0x63, 0x72, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05,
	0x63, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x61, 0x63, 0x68, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x61, 0x63, 0x68, 0x65, 0x12, 0x40, 0x0a, 0x0f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22, 0x74, 0x0a,
	0x15, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x64, 0x75, 0x72, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x22, 0x6d, 0x0a, 0x0e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x71, 0x6c, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x22, 0x75, 0x0a, 0x16, 0x4d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x19, 0x0a, 0x08,
	0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x73, 0x71, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22, 0xc5, 0x01, 0x0a, 0x0d, 0x53, 0x79,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x4d, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x73, 0x22, 0x9e, 0x01, 0x0a, 0x0d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x12, 0x28, 0x0a, 0x10, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x42, 0x6f, 0x64, 0x79,
	0x12, 0x40, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x73, 0x22, 0x8a, 0x01, 0x0a, 0x09, 0x55, 0x44, 0x54, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x12, 0x20, 0x0a, 0x0c, 0x75, 0x64, 0x74, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x75, 0x64, 0x74, 0x53, 0x71, 0x6c, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x75, 0x64, 0x74, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x75, 0x64, 0x74, 0x42, 0x6f, 0x64, 0x79, 0x12, 0x40, 0x0a,
	0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x22,
	0xc5, 0x02, 0x0a, 0x0d, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x72, 0x61, 0x66, 0x74, 0x5f,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x72,
	0x61, 0x66, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x4d, 0x0a, 0x0b, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4b, 0x0a, 0x0a, 0x64, 0x72, 0x61, 0x66,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x64, 0x72, 0x61, 0x66,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x50, 0x0a, 0x0b, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x5f, 0x6c, 0x6f, 0x67, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4d, 0x61, 0x70, 0x70,
	0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x6d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x67, 0x22, 0x83, 0x01, 0x0a, 0x15, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x67, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x17, 0x0a, 0x07, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x72, 0x75, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x72, 0x75,
	0x6c, 0x65, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x5f,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6d,
	0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xba, 0x01,
	0x0a, 0x09, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x44, 0x64, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x64,
	0x64, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64,
	0x64, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x64, 0x64, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x64, 0x64, 0x6c,
	0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x19, 0x0a, 0x08, 0x69, 0x73, 0x73, 0x75, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x64, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x07, 0x69, 0x73, 0x73, 0x75, 0x65, 0x49, 0x64, 0x22, 0x80, 0x06, 0x0a, 0x0b, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x43, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x2e,
	0x49, 0x73, 0x73, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x4f, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x49, 0x73, 0x73, 0x75, 0x65, 0x53, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x15,
	0x0a, 0x03, 0x64, 0x64, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x64,
	0x64, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x4f, 0x0a, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x49, 0x73, 0x73, 0x75, 0x65, 0x2e, 0x50,
	0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x01, 0x52, 0x08, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x4d, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x1a, 0x66, 0x0a, 0x08, 0x50, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x04, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x16, 0x0a,
	0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0x69, 0x0a,
	0x09, 0x49, 0x73, 0x73, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x49, 0x53,
	0x53, 0x55, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x53, 0x53, 0x55, 0x45, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x44, 0x4c, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x49, 0x53,
	0x53, 0x55, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x10, 0x02,
	0x12, 0x16, 0x0a, 0x12, 0x49, 0x53, 0x53, 0x55, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43,
	0x4f, 0x4e, 0x56, 0x45, 0x52, 0x54, 0x10, 0x03, 0x22, 0x7e, 0x0a, 0x0d, 0x49, 0x73, 0x73, 0x75,
	0x65, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1e, 0x0a, 0x1a, 0x49, 0x53, 0x53,
	0x55, 0x45, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x49, 0x53, 0x53,
	0x55, 0x45, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x49, 0x4e, 0x46, 0x4f,
	0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x49, 0x53, 0x53, 0x55, 0x45, 0x5f, 0x53, 0x45, 0x56, 0x45,
	0x52, 0x49, 0x54, 0x59, 0x5f, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x18,
	0x0a, 0x14, 0x49, 0x53, 0x53, 0x55, 0x45, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59,
	0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x64, 0x64, 0x6c,
	0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2a, 0x91, 0x01,
	0x0a, 0x12, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x49, 0x6e,
	0x4c, 0x69, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x21, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x50, 0x52,
	0x45, 0x53, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4e, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x27, 0x0a, 0x23, 0x56,
	0x41, 0x4c, 0x55, 0x45, 0x5f, 0x50, 0x52, 0x45, 0x53, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4e, 0x5f,
	0x4c, 0x49, 0x53, 0x54, 0x5f, 0x49, 0x46, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x4c, 0x49,
	0x53, 0x54, 0x10, 0x01, 0x12, 0x2b, 0x0a, 0x27, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x50, 0x52,
	0x45, 0x53, 0x45, 0x4e, 0x54, 0x5f, 0x49, 0x4e, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x5f, 0x49, 0x46,
	0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x4e, 0x4f, 0x54, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10,
	0x02, 0x2a, 0xcd, 0x04, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x44, 0x41, 0x54, 0x41,
	0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1f,
	0x0a, 0x1b, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54,
	0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x43, 0x48, 0x45, 0x4d, 0x41, 0x10, 0x01, 0x12,
	0x1e, 0x0a, 0x1a, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49,
	0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12,
	0x1f, 0x0a, 0x1b, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49,
	0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f, 0x4c, 0x55, 0x4d, 0x4e, 0x10, 0x03,
	0x12, 0x23, 0x0a, 0x1f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54,
	0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x53, 0x54, 0x52, 0x41,
	0x49, 0x4e, 0x54, 0x10, 0x04, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53,
	0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e,
	0x44, 0x45, 0x58, 0x10, 0x05, 0x12, 0x20, 0x0a, 0x1c, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53,
	0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x54, 0x52,
	0x49, 0x47, 0x47, 0x45, 0x52, 0x10, 0x06, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x41, 0x54, 0x41, 0x42,
	0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x56, 0x49, 0x45, 0x57, 0x10, 0x07, 0x12, 0x21, 0x0a, 0x1d, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41,
	0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53,
	0x45, 0x51, 0x55, 0x45, 0x4e, 0x43, 0x45, 0x10, 0x08, 0x12, 0x29, 0x0a, 0x25, 0x44, 0x41, 0x54,
	0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x44, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x44, 0x55,
	0x52, 0x45, 0x10, 0x09, 0x12, 0x21, 0x0a, 0x1d, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45,
	0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x46, 0x55, 0x4e,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0a, 0x12, 0x20, 0x0a, 0x1c, 0x44, 0x41, 0x54, 0x41, 0x42,
	0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x53, 0x59, 0x4e, 0x4f, 0x4e, 0x59, 0x4d, 0x10, 0x0b, 0x12, 0x29, 0x0a, 0x25, 0x44, 0x41, 0x54,
	0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50,
	0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x41,
	0x47, 0x45, 0x10, 0x0c, 0x12, 0x1c, 0x0a, 0x18, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45,
	0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x44, 0x54,
	0x10, 0x0d, 0x12, 0x2a, 0x0a, 0x26, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45,
	0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4d, 0x41, 0x54, 0x45, 0x52,
	0x49, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x10, 0x0e, 0x12, 0x21,
	0x0a, 0x1d, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x54, 0x49, 0x54,
	0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x10,
	0x0f, 0x2a, 0xff, 0x01, 0x0a, 0x18, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a,
	0x0a, 0x26, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x30, 0x0a, 0x2c, 0x45, 0x4e,
	0x54, 0x49, 0x54, 0x59, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46,
	0x4f, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4e, 0x4f, 0x5f, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x29, 0x0a, 0x25,
	0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x4f, 0x57, 0x45, 0x52,
	0x5f, 0x43, 0x41, 0x53, 0x45, 0x10, 0x02, 0x12, 0x29, 0x0a, 0x25, 0x45, 0x4e, 0x54, 0x49, 0x54,
	0x59, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x50, 0x50, 0x45, 0x52, 0x5f, 0x43, 0x41, 0x53, 0x45,
	0x10, 0x03, 0x12, 0x2f, 0x0a, 0x2b, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x4e, 0x41, 0x4d,
	0x45, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x43, 0x41, 0x50, 0x49, 0x54, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x43, 0x41, 0x53,
	0x45, 0x10, 0x04, 0x2a, 0xd4, 0x01, 0x0a, 0x11, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x4a, 0x6f, 0x62, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x42, 0x41, 0x43,
	0x4b, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x23,
	0x0a, 0x1f, 0x42, 0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x4a, 0x4f, 0x42,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x53, 0x45, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x42, 0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f, 0x55, 0x4e,
	0x44, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45,
	0x52, 0x54, 0x10, 0x02, 0x12, 0x29, 0x0a, 0x25, 0x42, 0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f, 0x55,
	0x4e, 0x44, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x41, 0x50, 0x50, 0x4c,
	0x59, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x49, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12,
	0x29, 0x0a, 0x25, 0x42, 0x41, 0x43, 0x4b, 0x47, 0x52, 0x4f, 0x55, 0x4e, 0x44, 0x5f, 0x4a, 0x4f,
	0x42, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x52, 0x55,
	0x4c, 0x45, 0x53, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x05, 0x2a, 0xad, 0x01, 0x0a, 0x15, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x65, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x12, 0x28, 0x0a, 0x24, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x52,
	0x55, 0x4c, 0x45, 0x53, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x38,
	0x0a, 0x34, 0x49, 0x4d, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x53, 0x5f, 0x46,
	0x49, 0x4c, 0x45, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x48, 0x41, 0x52, 0x42, 0x4f,
	0x55, 0x52, 0x5f, 0x42, 0x52, 0x49, 0x44, 0x47, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x30, 0x0a, 0x2c, 0x49, 0x4d, 0x50, 0x4f,
	0x52, 0x54, 0x5f, 0x52, 0x55, 0x4c, 0x45, 0x53, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x46, 0x4f,
	0x52, 0x4d, 0x41, 0x54, 0x5f, 0x4f, 0x52, 0x41, 0x54, 0x4f, 0x50, 0x47, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x10, 0x02, 0x2a, 0xed, 0x01, 0x0a, 0x0f, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x12, 0x20,
	0x0a, 0x1c, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x52, 0x49, 0x53,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x2a, 0x0a, 0x26, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x52,
	0x49, 0x53, 0x4f, 0x4e, 0x5f, 0x49, 0x46, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x53, 0x4d,
	0x41, 0x4c, 0x4c, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x01, 0x12, 0x30, 0x0a, 0x2c,
	0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x52, 0x49, 0x53, 0x4f, 0x4e,
	0x5f, 0x49, 0x46, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x53, 0x4d, 0x41, 0x4c, 0x4c, 0x45,
	0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x02, 0x12, 0x29,
	0x0a, 0x25, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x52, 0x49, 0x53,
	0x4f, 0x4e, 0x5f, 0x49, 0x46, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x4c, 0x41, 0x52, 0x47,
	0x45, 0x52, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x03, 0x12, 0x2f, 0x0a, 0x2b, 0x56, 0x41, 0x4c,
	0x55, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x52, 0x49, 0x53, 0x4f, 0x4e, 0x5f, 0x49, 0x46,
	0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0x5f, 0x4c, 0x41, 0x52, 0x47, 0x45, 0x52, 0x5f, 0x45, 0x51,
	0x55, 0x41, 0x4c, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x04, 0x2a, 0xa1, 0x01, 0x0a, 0x13, 0x4e,
	0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x21, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x46, 0x49,
	0x4c, 0x54, 0x45, 0x52, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x4e, 0x55, 0x4d,
	0x45, 0x52, 0x49, 0x43, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x4f, 0x50, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x4e, 0x55, 0x4d, 0x45,
	0x52, 0x49, 0x43, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x10, 0x02, 0x12, 0x23, 0x0a, 0x1f, 0x4e, 0x55, 0x4d,
	0x45, 0x52, 0x49, 0x43, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x4f, 0x50, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x4c, 0x49, 0x4d, 0x49, 0x54, 0x4c, 0x45, 0x53, 0x53, 0x10, 0x03, 0x42, 0xd1,
	0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x42,
	0x21, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x57, 0x6f, 0x72, 0x6b, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x70, 0x62, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x70, 0x62, 0xaa, 0x02,
	0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x44, 0x6d, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x6d,
	0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x4d, 0x53, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescOnce sync.Once
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescData = file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDesc
)

func file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescData)
	})
	return file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDescData
}

var file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 12)
var file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 51)
var file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_goTypes = []any{
	(ValuePresentInList)(0),                             // 0: google.cloud.clouddms.v1.ValuePresentInList
	(DatabaseEntityType)(0),                             // 1: google.cloud.clouddms.v1.DatabaseEntityType
	(EntityNameTransformation)(0),                       // 2: google.cloud.clouddms.v1.EntityNameTransformation
	(BackgroundJobType)(0),                              // 3: google.cloud.clouddms.v1.BackgroundJobType
	(ImportRulesFileFormat)(0),                          // 4: google.cloud.clouddms.v1.ImportRulesFileFormat
	(ValueComparison)(0),                                // 5: google.cloud.clouddms.v1.ValueComparison
	(NumericFilterOption)(0),                            // 6: google.cloud.clouddms.v1.NumericFilterOption
	(BackgroundJobLogEntry_JobCompletionState)(0),       // 7: google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState
	(MappingRule_State)(0),                              // 8: google.cloud.clouddms.v1.MappingRule.State
	(DatabaseEntity_TreeType)(0),                        // 9: google.cloud.clouddms.v1.DatabaseEntity.TreeType
	(EntityIssue_IssueType)(0),                          // 10: google.cloud.clouddms.v1.EntityIssue.IssueType
	(EntityIssue_IssueSeverity)(0),                      // 11: google.cloud.clouddms.v1.EntityIssue.IssueSeverity
	(*DatabaseEngineInfo)(nil),                          // 12: google.cloud.clouddms.v1.DatabaseEngineInfo
	(*ConversionWorkspace)(nil),                         // 13: google.cloud.clouddms.v1.ConversionWorkspace
	(*BackgroundJobLogEntry)(nil),                       // 14: google.cloud.clouddms.v1.BackgroundJobLogEntry
	(*MappingRuleFilter)(nil),                           // 15: google.cloud.clouddms.v1.MappingRuleFilter
	(*MappingRule)(nil),                                 // 16: google.cloud.clouddms.v1.MappingRule
	(*SingleEntityRename)(nil),                          // 17: google.cloud.clouddms.v1.SingleEntityRename
	(*MultiEntityRename)(nil),                           // 18: google.cloud.clouddms.v1.MultiEntityRename
	(*EntityMove)(nil),                                  // 19: google.cloud.clouddms.v1.EntityMove
	(*SingleColumnChange)(nil),                          // 20: google.cloud.clouddms.v1.SingleColumnChange
	(*MultiColumnDatatypeChange)(nil),                   // 21: google.cloud.clouddms.v1.MultiColumnDatatypeChange
	(*SourceTextFilter)(nil),                            // 22: google.cloud.clouddms.v1.SourceTextFilter
	(*SourceNumericFilter)(nil),                         // 23: google.cloud.clouddms.v1.SourceNumericFilter
	(*ConditionalColumnSetValue)(nil),                   // 24: google.cloud.clouddms.v1.ConditionalColumnSetValue
	(*ValueTransformation)(nil),                         // 25: google.cloud.clouddms.v1.ValueTransformation
	(*ConvertRowIdToColumn)(nil),                        // 26: google.cloud.clouddms.v1.ConvertRowIdToColumn
	(*SetTablePrimaryKey)(nil),                          // 27: google.cloud.clouddms.v1.SetTablePrimaryKey
	(*SinglePackageChange)(nil),                         // 28: google.cloud.clouddms.v1.SinglePackageChange
	(*SourceSqlChange)(nil),                             // 29: google.cloud.clouddms.v1.SourceSqlChange
	(*FilterTableColumns)(nil),                          // 30: google.cloud.clouddms.v1.FilterTableColumns
	(*ValueListFilter)(nil),                             // 31: google.cloud.clouddms.v1.ValueListFilter
	(*IntComparisonFilter)(nil),                         // 32: google.cloud.clouddms.v1.IntComparisonFilter
	(*DoubleComparisonFilter)(nil),                      // 33: google.cloud.clouddms.v1.DoubleComparisonFilter
	(*AssignSpecificValue)(nil),                         // 34: google.cloud.clouddms.v1.AssignSpecificValue
	(*ApplyHash)(nil),                                   // 35: google.cloud.clouddms.v1.ApplyHash
	(*RoundToScale)(nil),                                // 36: google.cloud.clouddms.v1.RoundToScale
	(*DatabaseEntity)(nil),                              // 37: google.cloud.clouddms.v1.DatabaseEntity
	(*DatabaseInstanceEntity)(nil),                      // 38: google.cloud.clouddms.v1.DatabaseInstanceEntity
	(*SchemaEntity)(nil),                                // 39: google.cloud.clouddms.v1.SchemaEntity
	(*TableEntity)(nil),                                 // 40: google.cloud.clouddms.v1.TableEntity
	(*ColumnEntity)(nil),                                // 41: google.cloud.clouddms.v1.ColumnEntity
	(*ConstraintEntity)(nil),                            // 42: google.cloud.clouddms.v1.ConstraintEntity
	(*IndexEntity)(nil),                                 // 43: google.cloud.clouddms.v1.IndexEntity
	(*TriggerEntity)(nil),                               // 44: google.cloud.clouddms.v1.TriggerEntity
	(*ViewEntity)(nil),                                  // 45: google.cloud.clouddms.v1.ViewEntity
	(*SequenceEntity)(nil),                              // 46: google.cloud.clouddms.v1.SequenceEntity
	(*StoredProcedureEntity)(nil),                       // 47: google.cloud.clouddms.v1.StoredProcedureEntity
	(*FunctionEntity)(nil),                              // 48: google.cloud.clouddms.v1.FunctionEntity
	(*MaterializedViewEntity)(nil),                      // 49: google.cloud.clouddms.v1.MaterializedViewEntity
	(*SynonymEntity)(nil),                               // 50: google.cloud.clouddms.v1.SynonymEntity
	(*PackageEntity)(nil),                               // 51: google.cloud.clouddms.v1.PackageEntity
	(*UDTEntity)(nil),                                   // 52: google.cloud.clouddms.v1.UDTEntity
	(*EntityMapping)(nil),                               // 53: google.cloud.clouddms.v1.EntityMapping
	(*EntityMappingLogEntry)(nil),                       // 54: google.cloud.clouddms.v1.EntityMappingLogEntry
	(*EntityDdl)(nil),                                   // 55: google.cloud.clouddms.v1.EntityDdl
	(*EntityIssue)(nil),                                 // 56: google.cloud.clouddms.v1.EntityIssue
	nil,                                                 // 57: google.cloud.clouddms.v1.ConversionWorkspace.GlobalSettingsEntry
	(*BackgroundJobLogEntry_SeedJobDetails)(nil),        // 58: google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
	(*BackgroundJobLogEntry_ImportRulesJobDetails)(nil), // 59: google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
	(*BackgroundJobLogEntry_ConvertJobDetails)(nil),     // 60: google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
	(*BackgroundJobLogEntry_ApplyJobDetails)(nil),       // 61: google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
	(*EntityIssue_Position)(nil),                        // 62: google.cloud.clouddms.v1.EntityIssue.Position
	(DatabaseEngine)(0),                                 // 63: google.cloud.clouddms.v1.DatabaseEngine
	(*timestamppb.Timestamp)(nil),                       // 64: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                             // 65: google.protobuf.Struct
	(*emptypb.Empty)(nil),                               // 66: google.protobuf.Empty
}
var file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_depIdxs = []int32{
	63,  // 0: google.cloud.clouddms.v1.DatabaseEngineInfo.engine:type_name -> google.cloud.clouddms.v1.DatabaseEngine
	12,  // 1: google.cloud.clouddms.v1.ConversionWorkspace.source:type_name -> google.cloud.clouddms.v1.DatabaseEngineInfo
	12,  // 2: google.cloud.clouddms.v1.ConversionWorkspace.destination:type_name -> google.cloud.clouddms.v1.DatabaseEngineInfo
	57,  // 3: google.cloud.clouddms.v1.ConversionWorkspace.global_settings:type_name -> google.cloud.clouddms.v1.ConversionWorkspace.GlobalSettingsEntry
	64,  // 4: google.cloud.clouddms.v1.ConversionWorkspace.latest_commit_time:type_name -> google.protobuf.Timestamp
	64,  // 5: google.cloud.clouddms.v1.ConversionWorkspace.create_time:type_name -> google.protobuf.Timestamp
	64,  // 6: google.cloud.clouddms.v1.ConversionWorkspace.update_time:type_name -> google.protobuf.Timestamp
	3,   // 7: google.cloud.clouddms.v1.BackgroundJobLogEntry.job_type:type_name -> google.cloud.clouddms.v1.BackgroundJobType
	64,  // 8: google.cloud.clouddms.v1.BackgroundJobLogEntry.start_time:type_name -> google.protobuf.Timestamp
	64,  // 9: google.cloud.clouddms.v1.BackgroundJobLogEntry.finish_time:type_name -> google.protobuf.Timestamp
	7,   // 10: google.cloud.clouddms.v1.BackgroundJobLogEntry.completion_state:type_name -> google.cloud.clouddms.v1.BackgroundJobLogEntry.JobCompletionState
	58,  // 11: google.cloud.clouddms.v1.BackgroundJobLogEntry.seed_job_details:type_name -> google.cloud.clouddms.v1.BackgroundJobLogEntry.SeedJobDetails
	59,  // 12: google.cloud.clouddms.v1.BackgroundJobLogEntry.import_rules_job_details:type_name -> google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails
	60,  // 13: google.cloud.clouddms.v1.BackgroundJobLogEntry.convert_job_details:type_name -> google.cloud.clouddms.v1.BackgroundJobLogEntry.ConvertJobDetails
	61,  // 14: google.cloud.clouddms.v1.BackgroundJobLogEntry.apply_job_details:type_name -> google.cloud.clouddms.v1.BackgroundJobLogEntry.ApplyJobDetails
	8,   // 15: google.cloud.clouddms.v1.MappingRule.state:type_name -> google.cloud.clouddms.v1.MappingRule.State
	1,   // 16: google.cloud.clouddms.v1.MappingRule.rule_scope:type_name -> google.cloud.clouddms.v1.DatabaseEntityType
	15,  // 17: google.cloud.clouddms.v1.MappingRule.filter:type_name -> google.cloud.clouddms.v1.MappingRuleFilter
	64,  // 18: google.cloud.clouddms.v1.MappingRule.revision_create_time:type_name -> google.protobuf.Timestamp
	17,  // 19: google.cloud.clouddms.v1.MappingRule.single_entity_rename:type_name -> google.cloud.clouddms.v1.SingleEntityRename
	18,  // 20: google.cloud.clouddms.v1.MappingRule.multi_entity_rename:type_name -> google.cloud.clouddms.v1.MultiEntityRename
	19,  // 21: google.cloud.clouddms.v1.MappingRule.entity_move:type_name -> google.cloud.clouddms.v1.EntityMove
	20,  // 22: google.cloud.clouddms.v1.MappingRule.single_column_change:type_name -> google.cloud.clouddms.v1.SingleColumnChange
	21,  // 23: google.cloud.clouddms.v1.MappingRule.multi_column_data_type_change:type_name -> google.cloud.clouddms.v1.MultiColumnDatatypeChange
	24,  // 24: google.cloud.clouddms.v1.MappingRule.conditional_column_set_value:type_name -> google.cloud.clouddms.v1.ConditionalColumnSetValue
	26,  // 25: google.cloud.clouddms.v1.MappingRule.convert_rowid_column:type_name -> google.cloud.clouddms.v1.ConvertRowIdToColumn
	27,  // 26: google.cloud.clouddms.v1.MappingRule.set_table_primary_key:type_name -> google.cloud.clouddms.v1.SetTablePrimaryKey
	28,  // 27: google.cloud.clouddms.v1.MappingRule.single_package_change:type_name -> google.cloud.clouddms.v1.SinglePackageChange
	29,  // 28: google.cloud.clouddms.v1.MappingRule.source_sql_change:type_name -> google.cloud.clouddms.v1.SourceSqlChange
	30,  // 29: google.cloud.clouddms.v1.MappingRule.filter_table_columns:type_name -> google.cloud.clouddms.v1.FilterTableColumns
	2,   // 30: google.cloud.clouddms.v1.MultiEntityRename.source_name_transformation:type_name -> google.cloud.clouddms.v1.EntityNameTransformation
	65,  // 31: google.cloud.clouddms.v1.SingleColumnChange.custom_features:type_name -> google.protobuf.Struct
	22,  // 32: google.cloud.clouddms.v1.MultiColumnDatatypeChange.source_text_filter:type_name -> google.cloud.clouddms.v1.SourceTextFilter
	23,  // 33: google.cloud.clouddms.v1.MultiColumnDatatypeChange.source_numeric_filter:type_name -> google.cloud.clouddms.v1.SourceNumericFilter
	65,  // 34: google.cloud.clouddms.v1.MultiColumnDatatypeChange.custom_features:type_name -> google.protobuf.Struct
	6,   // 35: google.cloud.clouddms.v1.SourceNumericFilter.numeric_filter_option:type_name -> google.cloud.clouddms.v1.NumericFilterOption
	22,  // 36: google.cloud.clouddms.v1.ConditionalColumnSetValue.source_text_filter:type_name -> google.cloud.clouddms.v1.SourceTextFilter
	23,  // 37: google.cloud.clouddms.v1.ConditionalColumnSetValue.source_numeric_filter:type_name -> google.cloud.clouddms.v1.SourceNumericFilter
	25,  // 38: google.cloud.clouddms.v1.ConditionalColumnSetValue.value_transformation:type_name -> google.cloud.clouddms.v1.ValueTransformation
	65,  // 39: google.cloud.clouddms.v1.ConditionalColumnSetValue.custom_features:type_name -> google.protobuf.Struct
	66,  // 40: google.cloud.clouddms.v1.ValueTransformation.is_null:type_name -> google.protobuf.Empty
	31,  // 41: google.cloud.clouddms.v1.ValueTransformation.value_list:type_name -> google.cloud.clouddms.v1.ValueListFilter
	32,  // 42: google.cloud.clouddms.v1.ValueTransformation.int_comparison:type_name -> google.cloud.clouddms.v1.IntComparisonFilter
	33,  // 43: google.cloud.clouddms.v1.ValueTransformation.double_comparison:type_name -> google.cloud.clouddms.v1.DoubleComparisonFilter
	66,  // 44: google.cloud.clouddms.v1.ValueTransformation.assign_null:type_name -> google.protobuf.Empty
	34,  // 45: google.cloud.clouddms.v1.ValueTransformation.assign_specific_value:type_name -> google.cloud.clouddms.v1.AssignSpecificValue
	66,  // 46: google.cloud.clouddms.v1.ValueTransformation.assign_min_value:type_name -> google.protobuf.Empty
	66,  // 47: google.cloud.clouddms.v1.ValueTransformation.assign_max_value:type_name -> google.protobuf.Empty
	36,  // 48: google.cloud.clouddms.v1.ValueTransformation.round_scale:type_name -> google.cloud.clouddms.v1.RoundToScale
	35,  // 49: google.cloud.clouddms.v1.ValueTransformation.apply_hash:type_name -> google.cloud.clouddms.v1.ApplyHash
	0,   // 50: google.cloud.clouddms.v1.ValueListFilter.value_present_list:type_name -> google.cloud.clouddms.v1.ValuePresentInList
	5,   // 51: google.cloud.clouddms.v1.IntComparisonFilter.value_comparison:type_name -> google.cloud.clouddms.v1.ValueComparison
	5,   // 52: google.cloud.clouddms.v1.DoubleComparisonFilter.value_comparison:type_name -> google.cloud.clouddms.v1.ValueComparison
	66,  // 53: google.cloud.clouddms.v1.ApplyHash.uuid_from_bytes:type_name -> google.protobuf.Empty
	9,   // 54: google.cloud.clouddms.v1.DatabaseEntity.tree:type_name -> google.cloud.clouddms.v1.DatabaseEntity.TreeType
	1,   // 55: google.cloud.clouddms.v1.DatabaseEntity.entity_type:type_name -> google.cloud.clouddms.v1.DatabaseEntityType
	53,  // 56: google.cloud.clouddms.v1.DatabaseEntity.mappings:type_name -> google.cloud.clouddms.v1.EntityMapping
	55,  // 57: google.cloud.clouddms.v1.DatabaseEntity.entity_ddl:type_name -> google.cloud.clouddms.v1.EntityDdl
	56,  // 58: google.cloud.clouddms.v1.DatabaseEntity.issues:type_name -> google.cloud.clouddms.v1.EntityIssue
	38,  // 59: google.cloud.clouddms.v1.DatabaseEntity.database:type_name -> google.cloud.clouddms.v1.DatabaseInstanceEntity
	39,  // 60: google.cloud.clouddms.v1.DatabaseEntity.schema:type_name -> google.cloud.clouddms.v1.SchemaEntity
	40,  // 61: google.cloud.clouddms.v1.DatabaseEntity.table:type_name -> google.cloud.clouddms.v1.TableEntity
	45,  // 62: google.cloud.clouddms.v1.DatabaseEntity.view:type_name -> google.cloud.clouddms.v1.ViewEntity
	46,  // 63: google.cloud.clouddms.v1.DatabaseEntity.sequence:type_name -> google.cloud.clouddms.v1.SequenceEntity
	47,  // 64: google.cloud.clouddms.v1.DatabaseEntity.stored_procedure:type_name -> google.cloud.clouddms.v1.StoredProcedureEntity
	48,  // 65: google.cloud.clouddms.v1.DatabaseEntity.database_function:type_name -> google.cloud.clouddms.v1.FunctionEntity
	50,  // 66: google.cloud.clouddms.v1.DatabaseEntity.synonym:type_name -> google.cloud.clouddms.v1.SynonymEntity
	51,  // 67: google.cloud.clouddms.v1.DatabaseEntity.database_package:type_name -> google.cloud.clouddms.v1.PackageEntity
	52,  // 68: google.cloud.clouddms.v1.DatabaseEntity.udt:type_name -> google.cloud.clouddms.v1.UDTEntity
	49,  // 69: google.cloud.clouddms.v1.DatabaseEntity.materialized_view:type_name -> google.cloud.clouddms.v1.MaterializedViewEntity
	65,  // 70: google.cloud.clouddms.v1.DatabaseInstanceEntity.custom_features:type_name -> google.protobuf.Struct
	65,  // 71: google.cloud.clouddms.v1.SchemaEntity.custom_features:type_name -> google.protobuf.Struct
	41,  // 72: google.cloud.clouddms.v1.TableEntity.columns:type_name -> google.cloud.clouddms.v1.ColumnEntity
	42,  // 73: google.cloud.clouddms.v1.TableEntity.constraints:type_name -> google.cloud.clouddms.v1.ConstraintEntity
	43,  // 74: google.cloud.clouddms.v1.TableEntity.indices:type_name -> google.cloud.clouddms.v1.IndexEntity
	44,  // 75: google.cloud.clouddms.v1.TableEntity.triggers:type_name -> google.cloud.clouddms.v1.TriggerEntity
	65,  // 76: google.cloud.clouddms.v1.TableEntity.custom_features:type_name -> google.protobuf.Struct
	65,  // 77: google.cloud.clouddms.v1.ColumnEntity.custom_features:type_name -> google.protobuf.Struct
	65,  // 78: google.cloud.clouddms.v1.ConstraintEntity.custom_features:type_name -> google.protobuf.Struct
	65,  // 79: google.cloud.clouddms.v1.IndexEntity.custom_features:type_name -> google.protobuf.Struct
	65,  // 80: google.cloud.clouddms.v1.TriggerEntity.custom_features:type_name -> google.protobuf.Struct
	65,  // 81: google.cloud.clouddms.v1.ViewEntity.custom_features:type_name -> google.protobuf.Struct
	42,  // 82: google.cloud.clouddms.v1.ViewEntity.constraints:type_name -> google.cloud.clouddms.v1.ConstraintEntity
	65,  // 83: google.cloud.clouddms.v1.SequenceEntity.custom_features:type_name -> google.protobuf.Struct
	65,  // 84: google.cloud.clouddms.v1.StoredProcedureEntity.custom_features:type_name -> google.protobuf.Struct
	65,  // 85: google.cloud.clouddms.v1.FunctionEntity.custom_features:type_name -> google.protobuf.Struct
	65,  // 86: google.cloud.clouddms.v1.MaterializedViewEntity.custom_features:type_name -> google.protobuf.Struct
	1,   // 87: google.cloud.clouddms.v1.SynonymEntity.source_type:type_name -> google.cloud.clouddms.v1.DatabaseEntityType
	65,  // 88: google.cloud.clouddms.v1.SynonymEntity.custom_features:type_name -> google.protobuf.Struct
	65,  // 89: google.cloud.clouddms.v1.PackageEntity.custom_features:type_name -> google.protobuf.Struct
	65,  // 90: google.cloud.clouddms.v1.UDTEntity.custom_features:type_name -> google.protobuf.Struct
	1,   // 91: google.cloud.clouddms.v1.EntityMapping.source_type:type_name -> google.cloud.clouddms.v1.DatabaseEntityType
	1,   // 92: google.cloud.clouddms.v1.EntityMapping.draft_type:type_name -> google.cloud.clouddms.v1.DatabaseEntityType
	54,  // 93: google.cloud.clouddms.v1.EntityMapping.mapping_log:type_name -> google.cloud.clouddms.v1.EntityMappingLogEntry
	1,   // 94: google.cloud.clouddms.v1.EntityDdl.entity_type:type_name -> google.cloud.clouddms.v1.DatabaseEntityType
	10,  // 95: google.cloud.clouddms.v1.EntityIssue.type:type_name -> google.cloud.clouddms.v1.EntityIssue.IssueType
	11,  // 96: google.cloud.clouddms.v1.EntityIssue.severity:type_name -> google.cloud.clouddms.v1.EntityIssue.IssueSeverity
	62,  // 97: google.cloud.clouddms.v1.EntityIssue.position:type_name -> google.cloud.clouddms.v1.EntityIssue.Position
	1,   // 98: google.cloud.clouddms.v1.EntityIssue.entity_type:type_name -> google.cloud.clouddms.v1.DatabaseEntityType
	4,   // 99: google.cloud.clouddms.v1.BackgroundJobLogEntry.ImportRulesJobDetails.file_format:type_name -> google.cloud.clouddms.v1.ImportRulesFileFormat
	100, // [100:100] is the sub-list for method output_type
	100, // [100:100] is the sub-list for method input_type
	100, // [100:100] is the sub-list for extension type_name
	100, // [100:100] is the sub-list for extension extendee
	0,   // [0:100] is the sub-list for field type_name
}

func init() { file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_init() }
func file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_init() {
	if File_google_cloud_clouddms_v1_conversionworkspace_resources_proto != nil {
		return
	}
	file_google_cloud_clouddms_v1_clouddms_resources_proto_init()
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[2].OneofWrappers = []any{
		(*BackgroundJobLogEntry_SeedJobDetails_)(nil),
		(*BackgroundJobLogEntry_ImportRulesJobDetails_)(nil),
		(*BackgroundJobLogEntry_ConvertJobDetails_)(nil),
		(*BackgroundJobLogEntry_ApplyJobDetails_)(nil),
	}
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[4].OneofWrappers = []any{
		(*MappingRule_SingleEntityRename)(nil),
		(*MappingRule_MultiEntityRename)(nil),
		(*MappingRule_EntityMove)(nil),
		(*MappingRule_SingleColumnChange)(nil),
		(*MappingRule_MultiColumnDataTypeChange)(nil),
		(*MappingRule_ConditionalColumnSetValue)(nil),
		(*MappingRule_ConvertRowidColumn)(nil),
		(*MappingRule_SetTablePrimaryKey)(nil),
		(*MappingRule_SinglePackageChange)(nil),
		(*MappingRule_SourceSqlChange)(nil),
		(*MappingRule_FilterTableColumns)(nil),
	}
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[9].OneofWrappers = []any{
		(*MultiColumnDatatypeChange_SourceTextFilter)(nil),
		(*MultiColumnDatatypeChange_SourceNumericFilter)(nil),
	}
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[12].OneofWrappers = []any{
		(*ConditionalColumnSetValue_SourceTextFilter)(nil),
		(*ConditionalColumnSetValue_SourceNumericFilter)(nil),
	}
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[13].OneofWrappers = []any{
		(*ValueTransformation_IsNull)(nil),
		(*ValueTransformation_ValueList)(nil),
		(*ValueTransformation_IntComparison)(nil),
		(*ValueTransformation_DoubleComparison)(nil),
		(*ValueTransformation_AssignNull)(nil),
		(*ValueTransformation_AssignSpecificValue)(nil),
		(*ValueTransformation_AssignMinValue)(nil),
		(*ValueTransformation_AssignMaxValue)(nil),
		(*ValueTransformation_RoundScale)(nil),
		(*ValueTransformation_ApplyHash)(nil),
	}
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[23].OneofWrappers = []any{
		(*ApplyHash_UuidFromBytes)(nil),
	}
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[25].OneofWrappers = []any{
		(*DatabaseEntity_Database)(nil),
		(*DatabaseEntity_Schema)(nil),
		(*DatabaseEntity_Table)(nil),
		(*DatabaseEntity_View)(nil),
		(*DatabaseEntity_Sequence)(nil),
		(*DatabaseEntity_StoredProcedure)(nil),
		(*DatabaseEntity_DatabaseFunction)(nil),
		(*DatabaseEntity_Synonym)(nil),
		(*DatabaseEntity_DatabasePackage)(nil),
		(*DatabaseEntity_Udt)(nil),
		(*DatabaseEntity_MaterializedView)(nil),
	}
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes[44].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDesc,
			NumEnums:      12,
			NumMessages:   51,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_clouddms_v1_conversionworkspace_resources_proto = out.File
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_rawDesc = nil
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_goTypes = nil
	file_google_cloud_clouddms_v1_conversionworkspace_resources_proto_depIdxs = nil
}
