// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/chat/v1/reaction.proto

package chatpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A reaction to a message.
type Reaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the reaction.
	//
	// Format: `spaces/{space}/messages/{message}/reactions/{reaction}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The user who created the reaction.
	User *User `protobuf:"bytes,2,opt,name=user,proto3" json:"user,omitempty"`
	// Required. The emoji used in the reaction.
	Emoji *Emoji `protobuf:"bytes,3,opt,name=emoji,proto3" json:"emoji,omitempty"`
}

func (x *Reaction) Reset() {
	*x = Reaction{}
	mi := &file_google_chat_v1_reaction_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Reaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Reaction) ProtoMessage() {}

func (x *Reaction) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_reaction_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Reaction.ProtoReflect.Descriptor instead.
func (*Reaction) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_reaction_proto_rawDescGZIP(), []int{0}
}

func (x *Reaction) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Reaction) GetUser() *User {
	if x != nil {
		return x.User
	}
	return nil
}

func (x *Reaction) GetEmoji() *Emoji {
	if x != nil {
		return x.Emoji
	}
	return nil
}

// An emoji that is used as a reaction to a message.
type Emoji struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The content of the emoji.
	//
	// Types that are assignable to Content:
	//
	//	*Emoji_Unicode
	//	*Emoji_CustomEmoji
	Content isEmoji_Content `protobuf_oneof:"content"`
}

func (x *Emoji) Reset() {
	*x = Emoji{}
	mi := &file_google_chat_v1_reaction_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Emoji) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Emoji) ProtoMessage() {}

func (x *Emoji) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_reaction_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Emoji.ProtoReflect.Descriptor instead.
func (*Emoji) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_reaction_proto_rawDescGZIP(), []int{1}
}

func (m *Emoji) GetContent() isEmoji_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (x *Emoji) GetUnicode() string {
	if x, ok := x.GetContent().(*Emoji_Unicode); ok {
		return x.Unicode
	}
	return ""
}

func (x *Emoji) GetCustomEmoji() *CustomEmoji {
	if x, ok := x.GetContent().(*Emoji_CustomEmoji); ok {
		return x.CustomEmoji
	}
	return nil
}

type isEmoji_Content interface {
	isEmoji_Content()
}

type Emoji_Unicode struct {
	// Optional. A basic emoji represented by a unicode string.
	Unicode string `protobuf:"bytes,1,opt,name=unicode,proto3,oneof"`
}

type Emoji_CustomEmoji struct {
	// A custom emoji.
	CustomEmoji *CustomEmoji `protobuf:"bytes,2,opt,name=custom_emoji,json=customEmoji,proto3,oneof"`
}

func (*Emoji_Unicode) isEmoji_Content() {}

func (*Emoji_CustomEmoji) isEmoji_Content() {}

// Represents a custom emoji.
type CustomEmoji struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Unique key for the custom emoji resource.
	Uid string `protobuf:"bytes,1,opt,name=uid,proto3" json:"uid,omitempty"`
}

func (x *CustomEmoji) Reset() {
	*x = CustomEmoji{}
	mi := &file_google_chat_v1_reaction_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomEmoji) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomEmoji) ProtoMessage() {}

func (x *CustomEmoji) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_reaction_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomEmoji.ProtoReflect.Descriptor instead.
func (*CustomEmoji) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_reaction_proto_rawDescGZIP(), []int{2}
}

func (x *CustomEmoji) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

// The number of people who reacted to a message with a specific emoji.
type EmojiReactionSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Emoji associated with the reactions.
	Emoji *Emoji `protobuf:"bytes,1,opt,name=emoji,proto3" json:"emoji,omitempty"`
	// Output only. The total number of reactions using the associated emoji.
	ReactionCount *int32 `protobuf:"varint,2,opt,name=reaction_count,json=reactionCount,proto3,oneof" json:"reaction_count,omitempty"`
}

func (x *EmojiReactionSummary) Reset() {
	*x = EmojiReactionSummary{}
	mi := &file_google_chat_v1_reaction_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EmojiReactionSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EmojiReactionSummary) ProtoMessage() {}

func (x *EmojiReactionSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_reaction_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EmojiReactionSummary.ProtoReflect.Descriptor instead.
func (*EmojiReactionSummary) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_reaction_proto_rawDescGZIP(), []int{3}
}

func (x *EmojiReactionSummary) GetEmoji() *Emoji {
	if x != nil {
		return x.Emoji
	}
	return nil
}

func (x *EmojiReactionSummary) GetReactionCount() int32 {
	if x != nil && x.ReactionCount != nil {
		return *x.ReactionCount
	}
	return 0
}

// Creates a reaction to a message.
type CreateReactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The message where the reaction is created.
	//
	// Format: `spaces/{space}/messages/{message}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The reaction to create.
	Reaction *Reaction `protobuf:"bytes,2,opt,name=reaction,proto3" json:"reaction,omitempty"`
}

func (x *CreateReactionRequest) Reset() {
	*x = CreateReactionRequest{}
	mi := &file_google_chat_v1_reaction_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateReactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateReactionRequest) ProtoMessage() {}

func (x *CreateReactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_reaction_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateReactionRequest.ProtoReflect.Descriptor instead.
func (*CreateReactionRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_reaction_proto_rawDescGZIP(), []int{4}
}

func (x *CreateReactionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateReactionRequest) GetReaction() *Reaction {
	if x != nil {
		return x.Reaction
	}
	return nil
}

// Lists reactions to a message.
type ListReactionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The message users reacted to.
	//
	// Format: `spaces/{space}/messages/{message}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of reactions returned. The service can return
	// fewer reactions than this value. If unspecified, the default value is 25.
	// The maximum value is 200; values above 200 are changed to 200.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. (If resuming from a previous query.)
	//
	// A page token received from a previous list reactions call. Provide this
	// to retrieve the subsequent page.
	//
	// When paginating, the filter value should match the call that provided the
	// page token. Passing a different value might lead to unexpected results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A query filter.
	//
	// You can filter reactions by
	// [emoji](https://developers.google.com/workspace/chat/api/reference/rest/v1/Emoji)
	// (either `emoji.unicode` or `emoji.custom_emoji.uid`) and
	// [user](https://developers.google.com/workspace/chat/api/reference/rest/v1/User)
	// (`user.name`).
	//
	// To filter reactions for multiple emojis or users, join similar fields
	// with the `OR` operator, such as `emoji.unicode = "🙂" OR emoji.unicode =
	// "👍"` and `user.name = "users/AAAAAA" OR user.name = "users/BBBBBB"`.
	//
	// To filter reactions by emoji and user, use the `AND` operator, such as
	// `emoji.unicode = "🙂" AND user.name = "users/AAAAAA"`.
	//
	// If your query uses both `AND` and `OR`, group them with parentheses.
	//
	// For example, the following queries are valid:
	//
	// ```
	// user.name = "users/{user}"
	// emoji.unicode = "🙂"
	// emoji.custom_emoji.uid = "{uid}"
	// emoji.unicode = "🙂" OR emoji.unicode = "👍"
	// emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "{uid}"
	// emoji.unicode = "🙂" AND user.name = "users/{user}"
	// (emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "{uid}")
	// AND user.name = "users/{user}"
	// ```
	//
	// The following queries are invalid:
	//
	// ```
	// emoji.unicode = "🙂" AND emoji.unicode = "👍"
	// emoji.unicode = "🙂" AND emoji.custom_emoji.uid = "{uid}"
	// emoji.unicode = "🙂" OR user.name = "users/{user}"
	// emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "{uid}" OR
	// user.name = "users/{user}"
	// emoji.unicode = "🙂" OR emoji.custom_emoji.uid = "{uid}"
	// AND user.name = "users/{user}"
	// ```
	//
	// Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
	// error.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListReactionsRequest) Reset() {
	*x = ListReactionsRequest{}
	mi := &file_google_chat_v1_reaction_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReactionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReactionsRequest) ProtoMessage() {}

func (x *ListReactionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_reaction_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReactionsRequest.ProtoReflect.Descriptor instead.
func (*ListReactionsRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_reaction_proto_rawDescGZIP(), []int{5}
}

func (x *ListReactionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReactionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReactionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListReactionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response to a list reactions request.
type ListReactionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of reactions in the requested (or first) page.
	Reactions []*Reaction `protobuf:"bytes,1,rep,name=reactions,proto3" json:"reactions,omitempty"`
	// Continuation token to retrieve the next page of results. It's empty
	// for the last page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListReactionsResponse) Reset() {
	*x = ListReactionsResponse{}
	mi := &file_google_chat_v1_reaction_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReactionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReactionsResponse) ProtoMessage() {}

func (x *ListReactionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_reaction_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReactionsResponse.ProtoReflect.Descriptor instead.
func (*ListReactionsResponse) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_reaction_proto_rawDescGZIP(), []int{6}
}

func (x *ListReactionsResponse) GetReactions() []*Reaction {
	if x != nil {
		return x.Reactions
	}
	return nil
}

func (x *ListReactionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Deletes a reaction to a message.
type DeleteReactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the reaction to delete.
	//
	// Format: `spaces/{space}/messages/{message}/reactions/{reaction}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteReactionRequest) Reset() {
	*x = DeleteReactionRequest{}
	mi := &file_google_chat_v1_reaction_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteReactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteReactionRequest) ProtoMessage() {}

func (x *DeleteReactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_reaction_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteReactionRequest.ProtoReflect.Descriptor instead.
func (*DeleteReactionRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_reaction_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteReactionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_chat_v1_reaction_proto protoreflect.FileDescriptor

var file_google_chat_v1_reaction_proto_rawDesc = []byte{
	0x0a, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x73, 0x65, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xdf, 0x01, 0x0a, 0x08, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x04, 0x75, 0x73, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x30, 0x0a, 0x05, 0x65, 0x6d, 0x6f, 0x6a,
	0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6d, 0x6f, 0x6a, 0x69, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x65, 0x6d, 0x6f, 0x6a, 0x69, 0x3a, 0x59, 0xea, 0x41, 0x56, 0x0a,
	0x1c, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x7d,
	0x2f, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0x75, 0x0a, 0x05, 0x45, 0x6d, 0x6f, 0x6a, 0x69, 0x12, 0x1f,
	0x0a, 0x07, 0x75, 0x6e, 0x69, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x07, 0x75, 0x6e, 0x69, 0x63, 0x6f, 0x64, 0x65, 0x12,
	0x40, 0x0a, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x65, 0x6d, 0x6f, 0x6a, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x45, 0x6d, 0x6f,
	0x6a, 0x69, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x45, 0x6d, 0x6f, 0x6a,
	0x69, 0x42, 0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x2c, 0x0a, 0x0b,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x45, 0x6d, 0x6f, 0x6a, 0x69, 0x12, 0x1d, 0x0a, 0x03, 0x75,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf,
	0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x03, 0x75, 0x69, 0x64, 0x22, 0x8c, 0x01, 0x0a, 0x14, 0x45,
	0x6d, 0x6f, 0x6a, 0x69, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x12, 0x30, 0x0a, 0x05, 0x65, 0x6d, 0x6f, 0x6a, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6d, 0x6f, 0x6a, 0x69, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x65, 0x6d, 0x6f, 0x6a, 0x69, 0x12, 0x2f, 0x0a, 0x0e, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x72, 0x65, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x90, 0x01, 0x0a, 0x15, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x12, 0x1c, 0x63, 0x68, 0x61,
	0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x39, 0x0a, 0x08, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb7, 0x01, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x12, 0x1c, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x77, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x36, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x72, 0x65,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x51, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x42, 0xa6, 0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x52, 0x65, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2c, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x63, 0x68, 0x61, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x70,
	0x62, 0x3b, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0xa2, 0x02, 0x0b, 0x44, 0x59, 0x4e, 0x41, 0x50,
	0x49, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x41, 0x70, 0x70, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70, 0x73, 0x5c, 0x43, 0x68, 0x61, 0x74, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x70,
	0x73, 0x3a, 0x3a, 0x43, 0x68, 0x61, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_chat_v1_reaction_proto_rawDescOnce sync.Once
	file_google_chat_v1_reaction_proto_rawDescData = file_google_chat_v1_reaction_proto_rawDesc
)

func file_google_chat_v1_reaction_proto_rawDescGZIP() []byte {
	file_google_chat_v1_reaction_proto_rawDescOnce.Do(func() {
		file_google_chat_v1_reaction_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chat_v1_reaction_proto_rawDescData)
	})
	return file_google_chat_v1_reaction_proto_rawDescData
}

var file_google_chat_v1_reaction_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_chat_v1_reaction_proto_goTypes = []any{
	(*Reaction)(nil),              // 0: google.chat.v1.Reaction
	(*Emoji)(nil),                 // 1: google.chat.v1.Emoji
	(*CustomEmoji)(nil),           // 2: google.chat.v1.CustomEmoji
	(*EmojiReactionSummary)(nil),  // 3: google.chat.v1.EmojiReactionSummary
	(*CreateReactionRequest)(nil), // 4: google.chat.v1.CreateReactionRequest
	(*ListReactionsRequest)(nil),  // 5: google.chat.v1.ListReactionsRequest
	(*ListReactionsResponse)(nil), // 6: google.chat.v1.ListReactionsResponse
	(*DeleteReactionRequest)(nil), // 7: google.chat.v1.DeleteReactionRequest
	(*User)(nil),                  // 8: google.chat.v1.User
}
var file_google_chat_v1_reaction_proto_depIdxs = []int32{
	8, // 0: google.chat.v1.Reaction.user:type_name -> google.chat.v1.User
	1, // 1: google.chat.v1.Reaction.emoji:type_name -> google.chat.v1.Emoji
	2, // 2: google.chat.v1.Emoji.custom_emoji:type_name -> google.chat.v1.CustomEmoji
	1, // 3: google.chat.v1.EmojiReactionSummary.emoji:type_name -> google.chat.v1.Emoji
	0, // 4: google.chat.v1.CreateReactionRequest.reaction:type_name -> google.chat.v1.Reaction
	0, // 5: google.chat.v1.ListReactionsResponse.reactions:type_name -> google.chat.v1.Reaction
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_chat_v1_reaction_proto_init() }
func file_google_chat_v1_reaction_proto_init() {
	if File_google_chat_v1_reaction_proto != nil {
		return
	}
	file_google_chat_v1_user_proto_init()
	file_google_chat_v1_reaction_proto_msgTypes[1].OneofWrappers = []any{
		(*Emoji_Unicode)(nil),
		(*Emoji_CustomEmoji)(nil),
	}
	file_google_chat_v1_reaction_proto_msgTypes[3].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chat_v1_reaction_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_chat_v1_reaction_proto_goTypes,
		DependencyIndexes: file_google_chat_v1_reaction_proto_depIdxs,
		MessageInfos:      file_google_chat_v1_reaction_proto_msgTypes,
	}.Build()
	File_google_chat_v1_reaction_proto = out.File
	file_google_chat_v1_reaction_proto_rawDesc = nil
	file_google_chat_v1_reaction_proto_goTypes = nil
	file_google_chat_v1_reaction_proto_depIdxs = nil
}
