// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/chat/v1/annotation.proto

package chatpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of the annotation.
type AnnotationType int32

const (
	// Default value for the enum. Don't use.
	AnnotationType_ANNOTATION_TYPE_UNSPECIFIED AnnotationType = 0
	// A user is mentioned.
	AnnotationType_USER_MENTION AnnotationType = 1
	// A slash command is invoked.
	AnnotationType_SLASH_COMMAND AnnotationType = 2
	// A rich link annotation.
	AnnotationType_RICH_LINK AnnotationType = 3
	// A custom emoji annotation.
	AnnotationType_CUSTOM_EMOJI AnnotationType = 4
)

// Enum value maps for AnnotationType.
var (
	AnnotationType_name = map[int32]string{
		0: "ANNOTATION_TYPE_UNSPECIFIED",
		1: "USER_MENTION",
		2: "SLASH_COMMAND",
		3: "RICH_LINK",
		4: "CUSTOM_EMOJI",
	}
	AnnotationType_value = map[string]int32{
		"ANNOTATION_TYPE_UNSPECIFIED": 0,
		"USER_MENTION":                1,
		"SLASH_COMMAND":               2,
		"RICH_LINK":                   3,
		"CUSTOM_EMOJI":                4,
	}
)

func (x AnnotationType) Enum() *AnnotationType {
	p := new(AnnotationType)
	*p = x
	return p
}

func (x AnnotationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnnotationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_annotation_proto_enumTypes[0].Descriptor()
}

func (AnnotationType) Type() protoreflect.EnumType {
	return &file_google_chat_v1_annotation_proto_enumTypes[0]
}

func (x AnnotationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnnotationType.Descriptor instead.
func (AnnotationType) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_annotation_proto_rawDescGZIP(), []int{0}
}

type UserMentionMetadata_Type int32

const (
	// Default value for the enum. Don't use.
	UserMentionMetadata_TYPE_UNSPECIFIED UserMentionMetadata_Type = 0
	// Add user to space.
	UserMentionMetadata_ADD UserMentionMetadata_Type = 1
	// Mention user in space.
	UserMentionMetadata_MENTION UserMentionMetadata_Type = 2
)

// Enum value maps for UserMentionMetadata_Type.
var (
	UserMentionMetadata_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "ADD",
		2: "MENTION",
	}
	UserMentionMetadata_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"ADD":              1,
		"MENTION":          2,
	}
)

func (x UserMentionMetadata_Type) Enum() *UserMentionMetadata_Type {
	p := new(UserMentionMetadata_Type)
	*p = x
	return p
}

func (x UserMentionMetadata_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UserMentionMetadata_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_annotation_proto_enumTypes[1].Descriptor()
}

func (UserMentionMetadata_Type) Type() protoreflect.EnumType {
	return &file_google_chat_v1_annotation_proto_enumTypes[1]
}

func (x UserMentionMetadata_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UserMentionMetadata_Type.Descriptor instead.
func (UserMentionMetadata_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_annotation_proto_rawDescGZIP(), []int{1, 0}
}

type SlashCommandMetadata_Type int32

const (
	// Default value for the enum. Don't use.
	SlashCommandMetadata_TYPE_UNSPECIFIED SlashCommandMetadata_Type = 0
	// Add Chat app to space.
	SlashCommandMetadata_ADD SlashCommandMetadata_Type = 1
	// Invoke slash command in space.
	SlashCommandMetadata_INVOKE SlashCommandMetadata_Type = 2
)

// Enum value maps for SlashCommandMetadata_Type.
var (
	SlashCommandMetadata_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "ADD",
		2: "INVOKE",
	}
	SlashCommandMetadata_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"ADD":              1,
		"INVOKE":           2,
	}
)

func (x SlashCommandMetadata_Type) Enum() *SlashCommandMetadata_Type {
	p := new(SlashCommandMetadata_Type)
	*p = x
	return p
}

func (x SlashCommandMetadata_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SlashCommandMetadata_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_annotation_proto_enumTypes[2].Descriptor()
}

func (SlashCommandMetadata_Type) Type() protoreflect.EnumType {
	return &file_google_chat_v1_annotation_proto_enumTypes[2]
}

func (x SlashCommandMetadata_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SlashCommandMetadata_Type.Descriptor instead.
func (SlashCommandMetadata_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_annotation_proto_rawDescGZIP(), []int{2, 0}
}

// The rich link type. More types might be added in the future.
type RichLinkMetadata_RichLinkType int32

const (
	// Default value for the enum. Don't use.
	RichLinkMetadata_RICH_LINK_TYPE_UNSPECIFIED RichLinkMetadata_RichLinkType = 0
	// A Google Drive rich link type.
	RichLinkMetadata_DRIVE_FILE RichLinkMetadata_RichLinkType = 1
	// A Chat space rich link type. For example, a space smart chip.
	RichLinkMetadata_CHAT_SPACE RichLinkMetadata_RichLinkType = 2
)

// Enum value maps for RichLinkMetadata_RichLinkType.
var (
	RichLinkMetadata_RichLinkType_name = map[int32]string{
		0: "RICH_LINK_TYPE_UNSPECIFIED",
		1: "DRIVE_FILE",
		2: "CHAT_SPACE",
	}
	RichLinkMetadata_RichLinkType_value = map[string]int32{
		"RICH_LINK_TYPE_UNSPECIFIED": 0,
		"DRIVE_FILE":                 1,
		"CHAT_SPACE":                 2,
	}
)

func (x RichLinkMetadata_RichLinkType) Enum() *RichLinkMetadata_RichLinkType {
	p := new(RichLinkMetadata_RichLinkType)
	*p = x
	return p
}

func (x RichLinkMetadata_RichLinkType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RichLinkMetadata_RichLinkType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_chat_v1_annotation_proto_enumTypes[3].Descriptor()
}

func (RichLinkMetadata_RichLinkType) Type() protoreflect.EnumType {
	return &file_google_chat_v1_annotation_proto_enumTypes[3]
}

func (x RichLinkMetadata_RichLinkType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RichLinkMetadata_RichLinkType.Descriptor instead.
func (RichLinkMetadata_RichLinkType) EnumDescriptor() ([]byte, []int) {
	return file_google_chat_v1_annotation_proto_rawDescGZIP(), []int{3, 0}
}

// Output only. Annotations associated with the plain-text body of the message.
// To add basic formatting to a text message, see
// [Format text
// messages](https://developers.google.com/workspace/chat/format-messages).
//
// Example plain-text message body:
// ```
// Hello @FooBot how are you!"
// ```
//
// The corresponding annotations metadata:
// ```
//
//	"annotations":[{
//	  "type":"USER_MENTION",
//	  "startIndex":6,
//	  "length":7,
//	  "userMention": {
//	    "user": {
//	      "name":"users/{user}",
//	      "displayName":"FooBot",
//	      "avatarUrl":"https://goo.gl/aeDtrS",
//	      "type":"BOT"
//	    },
//	    "type":"MENTION"
//	   }
//	}]
//
// ```
type Annotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of this annotation.
	Type AnnotationType `protobuf:"varint,1,opt,name=type,proto3,enum=google.chat.v1.AnnotationType" json:"type,omitempty"`
	// Start index (0-based, inclusive) in the plain-text message body this
	// annotation corresponds to.
	StartIndex *int32 `protobuf:"varint,2,opt,name=start_index,json=startIndex,proto3,oneof" json:"start_index,omitempty"`
	// Length of the substring in the plain-text message body this annotation
	// corresponds to.
	Length int32 `protobuf:"varint,3,opt,name=length,proto3" json:"length,omitempty"`
	// Additional metadata about the annotation.
	//
	// Types that are assignable to Metadata:
	//
	//	*Annotation_UserMention
	//	*Annotation_SlashCommand
	//	*Annotation_RichLinkMetadata
	//	*Annotation_CustomEmojiMetadata
	Metadata isAnnotation_Metadata `protobuf_oneof:"metadata"`
}

func (x *Annotation) Reset() {
	*x = Annotation{}
	mi := &file_google_chat_v1_annotation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Annotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Annotation) ProtoMessage() {}

func (x *Annotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_annotation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Annotation.ProtoReflect.Descriptor instead.
func (*Annotation) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_annotation_proto_rawDescGZIP(), []int{0}
}

func (x *Annotation) GetType() AnnotationType {
	if x != nil {
		return x.Type
	}
	return AnnotationType_ANNOTATION_TYPE_UNSPECIFIED
}

func (x *Annotation) GetStartIndex() int32 {
	if x != nil && x.StartIndex != nil {
		return *x.StartIndex
	}
	return 0
}

func (x *Annotation) GetLength() int32 {
	if x != nil {
		return x.Length
	}
	return 0
}

func (m *Annotation) GetMetadata() isAnnotation_Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (x *Annotation) GetUserMention() *UserMentionMetadata {
	if x, ok := x.GetMetadata().(*Annotation_UserMention); ok {
		return x.UserMention
	}
	return nil
}

func (x *Annotation) GetSlashCommand() *SlashCommandMetadata {
	if x, ok := x.GetMetadata().(*Annotation_SlashCommand); ok {
		return x.SlashCommand
	}
	return nil
}

func (x *Annotation) GetRichLinkMetadata() *RichLinkMetadata {
	if x, ok := x.GetMetadata().(*Annotation_RichLinkMetadata); ok {
		return x.RichLinkMetadata
	}
	return nil
}

func (x *Annotation) GetCustomEmojiMetadata() *CustomEmojiMetadata {
	if x, ok := x.GetMetadata().(*Annotation_CustomEmojiMetadata); ok {
		return x.CustomEmojiMetadata
	}
	return nil
}

type isAnnotation_Metadata interface {
	isAnnotation_Metadata()
}

type Annotation_UserMention struct {
	// The metadata of user mention.
	UserMention *UserMentionMetadata `protobuf:"bytes,4,opt,name=user_mention,json=userMention,proto3,oneof"`
}

type Annotation_SlashCommand struct {
	// The metadata for a slash command.
	SlashCommand *SlashCommandMetadata `protobuf:"bytes,5,opt,name=slash_command,json=slashCommand,proto3,oneof"`
}

type Annotation_RichLinkMetadata struct {
	// The metadata for a rich link.
	RichLinkMetadata *RichLinkMetadata `protobuf:"bytes,6,opt,name=rich_link_metadata,json=richLinkMetadata,proto3,oneof"`
}

type Annotation_CustomEmojiMetadata struct {
	// The metadata for a custom emoji.
	CustomEmojiMetadata *CustomEmojiMetadata `protobuf:"bytes,7,opt,name=custom_emoji_metadata,json=customEmojiMetadata,proto3,oneof"`
}

func (*Annotation_UserMention) isAnnotation_Metadata() {}

func (*Annotation_SlashCommand) isAnnotation_Metadata() {}

func (*Annotation_RichLinkMetadata) isAnnotation_Metadata() {}

func (*Annotation_CustomEmojiMetadata) isAnnotation_Metadata() {}

// Annotation metadata for user mentions (@).
type UserMentionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user mentioned.
	User *User `protobuf:"bytes,1,opt,name=user,proto3" json:"user,omitempty"`
	// The type of user mention.
	Type UserMentionMetadata_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.chat.v1.UserMentionMetadata_Type" json:"type,omitempty"`
}

func (x *UserMentionMetadata) Reset() {
	*x = UserMentionMetadata{}
	mi := &file_google_chat_v1_annotation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserMentionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserMentionMetadata) ProtoMessage() {}

func (x *UserMentionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_annotation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserMentionMetadata.ProtoReflect.Descriptor instead.
func (*UserMentionMetadata) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_annotation_proto_rawDescGZIP(), []int{1}
}

func (x *UserMentionMetadata) GetUser() *User {
	if x != nil {
		return x.User
	}
	return nil
}

func (x *UserMentionMetadata) GetType() UserMentionMetadata_Type {
	if x != nil {
		return x.Type
	}
	return UserMentionMetadata_TYPE_UNSPECIFIED
}

// Annotation metadata for slash commands (/).
type SlashCommandMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Chat app whose command was invoked.
	Bot *User `protobuf:"bytes,1,opt,name=bot,proto3" json:"bot,omitempty"`
	// The type of slash command.
	Type SlashCommandMetadata_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.chat.v1.SlashCommandMetadata_Type" json:"type,omitempty"`
	// The name of the invoked slash command.
	CommandName string `protobuf:"bytes,3,opt,name=command_name,json=commandName,proto3" json:"command_name,omitempty"`
	// The command ID of the invoked slash command.
	CommandId int64 `protobuf:"varint,4,opt,name=command_id,json=commandId,proto3" json:"command_id,omitempty"`
	// Indicates whether the slash command is for a dialog.
	TriggersDialog bool `protobuf:"varint,5,opt,name=triggers_dialog,json=triggersDialog,proto3" json:"triggers_dialog,omitempty"`
}

func (x *SlashCommandMetadata) Reset() {
	*x = SlashCommandMetadata{}
	mi := &file_google_chat_v1_annotation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SlashCommandMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SlashCommandMetadata) ProtoMessage() {}

func (x *SlashCommandMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_annotation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SlashCommandMetadata.ProtoReflect.Descriptor instead.
func (*SlashCommandMetadata) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_annotation_proto_rawDescGZIP(), []int{2}
}

func (x *SlashCommandMetadata) GetBot() *User {
	if x != nil {
		return x.Bot
	}
	return nil
}

func (x *SlashCommandMetadata) GetType() SlashCommandMetadata_Type {
	if x != nil {
		return x.Type
	}
	return SlashCommandMetadata_TYPE_UNSPECIFIED
}

func (x *SlashCommandMetadata) GetCommandName() string {
	if x != nil {
		return x.CommandName
	}
	return ""
}

func (x *SlashCommandMetadata) GetCommandId() int64 {
	if x != nil {
		return x.CommandId
	}
	return 0
}

func (x *SlashCommandMetadata) GetTriggersDialog() bool {
	if x != nil {
		return x.TriggersDialog
	}
	return false
}

// A rich link to a resource.
type RichLinkMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI of this link.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// The rich link type.
	RichLinkType RichLinkMetadata_RichLinkType `protobuf:"varint,2,opt,name=rich_link_type,json=richLinkType,proto3,enum=google.chat.v1.RichLinkMetadata_RichLinkType" json:"rich_link_type,omitempty"`
	// Data for the linked resource.
	//
	// Types that are assignable to Data:
	//
	//	*RichLinkMetadata_DriveLinkData
	//	*RichLinkMetadata_ChatSpaceLinkData
	Data isRichLinkMetadata_Data `protobuf_oneof:"data"`
}

func (x *RichLinkMetadata) Reset() {
	*x = RichLinkMetadata{}
	mi := &file_google_chat_v1_annotation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RichLinkMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RichLinkMetadata) ProtoMessage() {}

func (x *RichLinkMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_annotation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RichLinkMetadata.ProtoReflect.Descriptor instead.
func (*RichLinkMetadata) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_annotation_proto_rawDescGZIP(), []int{3}
}

func (x *RichLinkMetadata) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *RichLinkMetadata) GetRichLinkType() RichLinkMetadata_RichLinkType {
	if x != nil {
		return x.RichLinkType
	}
	return RichLinkMetadata_RICH_LINK_TYPE_UNSPECIFIED
}

func (m *RichLinkMetadata) GetData() isRichLinkMetadata_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *RichLinkMetadata) GetDriveLinkData() *DriveLinkData {
	if x, ok := x.GetData().(*RichLinkMetadata_DriveLinkData); ok {
		return x.DriveLinkData
	}
	return nil
}

func (x *RichLinkMetadata) GetChatSpaceLinkData() *ChatSpaceLinkData {
	if x, ok := x.GetData().(*RichLinkMetadata_ChatSpaceLinkData); ok {
		return x.ChatSpaceLinkData
	}
	return nil
}

type isRichLinkMetadata_Data interface {
	isRichLinkMetadata_Data()
}

type RichLinkMetadata_DriveLinkData struct {
	// Data for a drive link.
	DriveLinkData *DriveLinkData `protobuf:"bytes,3,opt,name=drive_link_data,json=driveLinkData,proto3,oneof"`
}

type RichLinkMetadata_ChatSpaceLinkData struct {
	// Data for a chat space link.
	ChatSpaceLinkData *ChatSpaceLinkData `protobuf:"bytes,4,opt,name=chat_space_link_data,json=chatSpaceLinkData,proto3,oneof"`
}

func (*RichLinkMetadata_DriveLinkData) isRichLinkMetadata_Data() {}

func (*RichLinkMetadata_ChatSpaceLinkData) isRichLinkMetadata_Data() {}

// Annotation metadata for custom emoji.
type CustomEmojiMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The custom emoji.
	CustomEmoji *CustomEmoji `protobuf:"bytes,1,opt,name=custom_emoji,json=customEmoji,proto3" json:"custom_emoji,omitempty"`
}

func (x *CustomEmojiMetadata) Reset() {
	*x = CustomEmojiMetadata{}
	mi := &file_google_chat_v1_annotation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomEmojiMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomEmojiMetadata) ProtoMessage() {}

func (x *CustomEmojiMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_annotation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomEmojiMetadata.ProtoReflect.Descriptor instead.
func (*CustomEmojiMetadata) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_annotation_proto_rawDescGZIP(), []int{4}
}

func (x *CustomEmojiMetadata) GetCustomEmoji() *CustomEmoji {
	if x != nil {
		return x.CustomEmoji
	}
	return nil
}

// Data for Google Drive links.
type DriveLinkData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A
	// [DriveDataRef](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.attachments#drivedataref)
	// which references a Google Drive file.
	DriveDataRef *DriveDataRef `protobuf:"bytes,1,opt,name=drive_data_ref,json=driveDataRef,proto3" json:"drive_data_ref,omitempty"`
	// The mime type of the linked Google Drive resource.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
}

func (x *DriveLinkData) Reset() {
	*x = DriveLinkData{}
	mi := &file_google_chat_v1_annotation_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DriveLinkData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DriveLinkData) ProtoMessage() {}

func (x *DriveLinkData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_annotation_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DriveLinkData.ProtoReflect.Descriptor instead.
func (*DriveLinkData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_annotation_proto_rawDescGZIP(), []int{5}
}

func (x *DriveLinkData) GetDriveDataRef() *DriveDataRef {
	if x != nil {
		return x.DriveDataRef
	}
	return nil
}

func (x *DriveLinkData) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

// Data for Chat space links.
type ChatSpaceLinkData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The space of the linked Chat space resource.
	//
	// Format: `spaces/{space}`
	Space string `protobuf:"bytes,1,opt,name=space,proto3" json:"space,omitempty"`
	// The thread of the linked Chat space resource.
	//
	// Format: `spaces/{space}/threads/{thread}`
	Thread string `protobuf:"bytes,2,opt,name=thread,proto3" json:"thread,omitempty"`
	// The message of the linked Chat space resource.
	//
	// Format: `spaces/{space}/messages/{message}`
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *ChatSpaceLinkData) Reset() {
	*x = ChatSpaceLinkData{}
	mi := &file_google_chat_v1_annotation_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChatSpaceLinkData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChatSpaceLinkData) ProtoMessage() {}

func (x *ChatSpaceLinkData) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_annotation_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChatSpaceLinkData.ProtoReflect.Descriptor instead.
func (*ChatSpaceLinkData) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_annotation_proto_rawDescGZIP(), []int{6}
}

func (x *ChatSpaceLinkData) GetSpace() string {
	if x != nil {
		return x.Space
	}
	return ""
}

func (x *ChatSpaceLinkData) GetThread() string {
	if x != nil {
		return x.Thread
	}
	return ""
}

func (x *ChatSpaceLinkData) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_google_chat_v1_annotation_proto protoreflect.FileDescriptor

var file_google_chat_v1_annotation_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76,
	0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x74, 0x74,
	0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x75, 0x73, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xde, 0x03, 0x0a, 0x0a, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x01, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x88, 0x01, 0x01,
	0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x48, 0x0a, 0x0c, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x4d, 0x65, 0x6e, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x0d, 0x73, 0x6c, 0x61, 0x73, 0x68, 0x5f, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x73, 0x68,
	0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48,
	0x00, 0x52, 0x0c, 0x73, 0x6c, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12,
	0x50, 0x0a, 0x12, 0x72, 0x69, 0x63, 0x68, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x69, 0x63,
	0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52,
	0x10, 0x72, 0x69, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x59, 0x0a, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x65, 0x6d, 0x6f, 0x6a,
	0x69, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x45, 0x6d, 0x6f, 0x6a, 0x69, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x13, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x45,
	0x6d, 0x6f, 0x6a, 0x69, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x0a, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xb1, 0x01, 0x0a, 0x13, 0x55, 0x73, 0x65,
	0x72, 0x4d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x28, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x73, 0x65, 0x72, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x12, 0x3c, 0x0a, 0x04, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x4d, 0x65,
	0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x32, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x44, 0x44, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x4d, 0x45, 0x4e, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0x9b, 0x02, 0x0a,
	0x14, 0x53, 0x6c, 0x61, 0x73, 0x68, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x26, 0x0a, 0x03, 0x62, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x52, 0x03, 0x62, 0x6f, 0x74, 0x12, 0x3d, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x61,
	0x73, 0x68, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x49, 0x64, 0x12, 0x27,
	0x0a, 0x0f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x5f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x73, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x22, 0x31, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x44, 0x44, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x49, 0x4e, 0x56, 0x4f, 0x4b, 0x45, 0x10, 0x02, 0x22, 0xf0, 0x02, 0x0a, 0x10, 0x52,
	0x69, 0x63, 0x68, 0x4c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72,
	0x69, 0x12, 0x53, 0x0a, 0x0e, 0x72, 0x69, 0x63, 0x68, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x69, 0x63, 0x68, 0x4c,
	0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x52, 0x69, 0x63, 0x68,
	0x4c, 0x69, 0x6e, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x69, 0x63, 0x68, 0x4c, 0x69,
	0x6e, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x47, 0x0a, 0x0f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x72, 0x69, 0x76, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00,
	0x52, 0x0d, 0x64, 0x72, 0x69, 0x76, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x44, 0x61, 0x74, 0x61, 0x12,
	0x54, 0x0a, 0x14, 0x63, 0x68, 0x61, 0x74, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x68, 0x61, 0x74, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x44, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x11, 0x63, 0x68, 0x61, 0x74, 0x53, 0x70, 0x61, 0x63, 0x65, 0x4c, 0x69, 0x6e,
	0x6b, 0x44, 0x61, 0x74, 0x61, 0x22, 0x4e, 0x0a, 0x0c, 0x52, 0x69, 0x63, 0x68, 0x4c, 0x69, 0x6e,
	0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x49, 0x43, 0x48, 0x5f, 0x4c, 0x49,
	0x4e, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x52, 0x49, 0x56, 0x45, 0x5f, 0x46,
	0x49, 0x4c, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x48, 0x41, 0x54, 0x5f, 0x53, 0x50,
	0x41, 0x43, 0x45, 0x10, 0x02, 0x42, 0x06, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x55, 0x0a,
	0x13, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x45, 0x6d, 0x6f, 0x6a, 0x69, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x3e, 0x0a, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x65,
	0x6d, 0x6f, 0x6a, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74,
	0x6f, 0x6d, 0x45, 0x6d, 0x6f, 0x6a, 0x69, 0x52, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x45,
	0x6d, 0x6f, 0x6a, 0x69, 0x22, 0x70, 0x0a, 0x0d, 0x44, 0x72, 0x69, 0x76, 0x65, 0x4c, 0x69, 0x6e,
	0x6b, 0x44, 0x61, 0x74, 0x61, 0x12, 0x42, 0x0a, 0x0e, 0x64, 0x72, 0x69, 0x76, 0x65, 0x5f, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x72, 0x69, 0x76, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x66, 0x52, 0x0c, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x66, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69,
	0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0xbe, 0x01, 0x0a, 0x11, 0x43, 0x68, 0x61, 0x74, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x44, 0x61, 0x74, 0x61, 0x12, 0x34, 0x0a, 0x05,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1e, 0xfa, 0x41, 0x1b,
	0x0a, 0x19, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x52, 0x05, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x1f, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x68, 0x72,
	0x65, 0x61, 0x64, 0x52, 0x06, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x12, 0x3a, 0x0a, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41,
	0x1d, 0x0a, 0x1b, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2a, 0x77, 0x0a, 0x0e, 0x41, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x41, 0x4e, 0x4e,
	0x4f, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x53,
	0x45, 0x52, 0x5f, 0x4d, 0x45, 0x4e, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d,
	0x53, 0x4c, 0x41, 0x53, 0x48, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x41, 0x4e, 0x44, 0x10, 0x02, 0x12,
	0x0d, 0x0a, 0x09, 0x52, 0x49, 0x43, 0x48, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x10, 0x03, 0x12, 0x10,
	0x0a, 0x0c, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x45, 0x4d, 0x4f, 0x4a, 0x49, 0x10, 0x04,
	0x42, 0xa8, 0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2c, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x63, 0x68, 0x61, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x70,
	0x62, 0x3b, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0xa2, 0x02, 0x0b, 0x44, 0x59, 0x4e, 0x41, 0x50,
	0x49, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x41, 0x70, 0x70, 0x73, 0x2e, 0x43, 0x68, 0x61, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70, 0x70, 0x73, 0x5c, 0x43, 0x68, 0x61, 0x74, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x70,
	0x73, 0x3a, 0x3a, 0x43, 0x68, 0x61, 0x74, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_chat_v1_annotation_proto_rawDescOnce sync.Once
	file_google_chat_v1_annotation_proto_rawDescData = file_google_chat_v1_annotation_proto_rawDesc
)

func file_google_chat_v1_annotation_proto_rawDescGZIP() []byte {
	file_google_chat_v1_annotation_proto_rawDescOnce.Do(func() {
		file_google_chat_v1_annotation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chat_v1_annotation_proto_rawDescData)
	})
	return file_google_chat_v1_annotation_proto_rawDescData
}

var file_google_chat_v1_annotation_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_chat_v1_annotation_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_chat_v1_annotation_proto_goTypes = []any{
	(AnnotationType)(0),                // 0: google.chat.v1.AnnotationType
	(UserMentionMetadata_Type)(0),      // 1: google.chat.v1.UserMentionMetadata.Type
	(SlashCommandMetadata_Type)(0),     // 2: google.chat.v1.SlashCommandMetadata.Type
	(RichLinkMetadata_RichLinkType)(0), // 3: google.chat.v1.RichLinkMetadata.RichLinkType
	(*Annotation)(nil),                 // 4: google.chat.v1.Annotation
	(*UserMentionMetadata)(nil),        // 5: google.chat.v1.UserMentionMetadata
	(*SlashCommandMetadata)(nil),       // 6: google.chat.v1.SlashCommandMetadata
	(*RichLinkMetadata)(nil),           // 7: google.chat.v1.RichLinkMetadata
	(*CustomEmojiMetadata)(nil),        // 8: google.chat.v1.CustomEmojiMetadata
	(*DriveLinkData)(nil),              // 9: google.chat.v1.DriveLinkData
	(*ChatSpaceLinkData)(nil),          // 10: google.chat.v1.ChatSpaceLinkData
	(*User)(nil),                       // 11: google.chat.v1.User
	(*CustomEmoji)(nil),                // 12: google.chat.v1.CustomEmoji
	(*DriveDataRef)(nil),               // 13: google.chat.v1.DriveDataRef
}
var file_google_chat_v1_annotation_proto_depIdxs = []int32{
	0,  // 0: google.chat.v1.Annotation.type:type_name -> google.chat.v1.AnnotationType
	5,  // 1: google.chat.v1.Annotation.user_mention:type_name -> google.chat.v1.UserMentionMetadata
	6,  // 2: google.chat.v1.Annotation.slash_command:type_name -> google.chat.v1.SlashCommandMetadata
	7,  // 3: google.chat.v1.Annotation.rich_link_metadata:type_name -> google.chat.v1.RichLinkMetadata
	8,  // 4: google.chat.v1.Annotation.custom_emoji_metadata:type_name -> google.chat.v1.CustomEmojiMetadata
	11, // 5: google.chat.v1.UserMentionMetadata.user:type_name -> google.chat.v1.User
	1,  // 6: google.chat.v1.UserMentionMetadata.type:type_name -> google.chat.v1.UserMentionMetadata.Type
	11, // 7: google.chat.v1.SlashCommandMetadata.bot:type_name -> google.chat.v1.User
	2,  // 8: google.chat.v1.SlashCommandMetadata.type:type_name -> google.chat.v1.SlashCommandMetadata.Type
	3,  // 9: google.chat.v1.RichLinkMetadata.rich_link_type:type_name -> google.chat.v1.RichLinkMetadata.RichLinkType
	9,  // 10: google.chat.v1.RichLinkMetadata.drive_link_data:type_name -> google.chat.v1.DriveLinkData
	10, // 11: google.chat.v1.RichLinkMetadata.chat_space_link_data:type_name -> google.chat.v1.ChatSpaceLinkData
	12, // 12: google.chat.v1.CustomEmojiMetadata.custom_emoji:type_name -> google.chat.v1.CustomEmoji
	13, // 13: google.chat.v1.DriveLinkData.drive_data_ref:type_name -> google.chat.v1.DriveDataRef
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_chat_v1_annotation_proto_init() }
func file_google_chat_v1_annotation_proto_init() {
	if File_google_chat_v1_annotation_proto != nil {
		return
	}
	file_google_chat_v1_attachment_proto_init()
	file_google_chat_v1_reaction_proto_init()
	file_google_chat_v1_user_proto_init()
	file_google_chat_v1_annotation_proto_msgTypes[0].OneofWrappers = []any{
		(*Annotation_UserMention)(nil),
		(*Annotation_SlashCommand)(nil),
		(*Annotation_RichLinkMetadata)(nil),
		(*Annotation_CustomEmojiMetadata)(nil),
	}
	file_google_chat_v1_annotation_proto_msgTypes[3].OneofWrappers = []any{
		(*RichLinkMetadata_DriveLinkData)(nil),
		(*RichLinkMetadata_ChatSpaceLinkData)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chat_v1_annotation_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_chat_v1_annotation_proto_goTypes,
		DependencyIndexes: file_google_chat_v1_annotation_proto_depIdxs,
		EnumInfos:         file_google_chat_v1_annotation_proto_enumTypes,
		MessageInfos:      file_google_chat_v1_annotation_proto_msgTypes,
	}.Build()
	File_google_chat_v1_annotation_proto = out.File
	file_google_chat_v1_annotation_proto_rawDesc = nil
	file_google_chat_v1_annotation_proto_goTypes = nil
	file_google_chat_v1_annotation_proto_depIdxs = nil
}
