// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/backupdr/v1/backupplanassociation.proto

package backupdrpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum for State of BackupPlan Association
type BackupPlanAssociation_State int32

const (
	// State not set.
	BackupPlanAssociation_STATE_UNSPECIFIED BackupPlanAssociation_State = 0
	// The resource is being created.
	BackupPlanAssociation_CREATING BackupPlanAssociation_State = 1
	// The resource has been created and is fully usable.
	BackupPlanAssociation_ACTIVE BackupPlanAssociation_State = 2
	// The resource is being deleted.
	BackupPlanAssociation_DELETING BackupPlanAssociation_State = 3
	// The resource has been created but is not usable.
	BackupPlanAssociation_INACTIVE BackupPlanAssociation_State = 4
)

// Enum value maps for BackupPlanAssociation_State.
var (
	BackupPlanAssociation_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "DELETING",
		4: "INACTIVE",
	}
	BackupPlanAssociation_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"DELETING":          3,
		"INACTIVE":          4,
	}
)

func (x BackupPlanAssociation_State) Enum() *BackupPlanAssociation_State {
	p := new(BackupPlanAssociation_State)
	*p = x
	return p
}

func (x BackupPlanAssociation_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BackupPlanAssociation_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_enumTypes[0].Descriptor()
}

func (BackupPlanAssociation_State) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupplanassociation_proto_enumTypes[0]
}

func (x BackupPlanAssociation_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BackupPlanAssociation_State.Descriptor instead.
func (BackupPlanAssociation_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescGZIP(), []int{0, 0}
}

// Enum for LastBackupState
type RuleConfigInfo_LastBackupState int32

const (
	// State not set.
	RuleConfigInfo_LAST_BACKUP_STATE_UNSPECIFIED RuleConfigInfo_LastBackupState = 0
	// The first backup is pending.
	RuleConfigInfo_FIRST_BACKUP_PENDING RuleConfigInfo_LastBackupState = 1
	// The most recent backup could not be run/failed because of the lack of
	// permissions.
	RuleConfigInfo_PERMISSION_DENIED RuleConfigInfo_LastBackupState = 2
	// The last backup operation succeeded.
	RuleConfigInfo_SUCCEEDED RuleConfigInfo_LastBackupState = 3
	// The last backup operation failed.
	RuleConfigInfo_FAILED RuleConfigInfo_LastBackupState = 4
)

// Enum value maps for RuleConfigInfo_LastBackupState.
var (
	RuleConfigInfo_LastBackupState_name = map[int32]string{
		0: "LAST_BACKUP_STATE_UNSPECIFIED",
		1: "FIRST_BACKUP_PENDING",
		2: "PERMISSION_DENIED",
		3: "SUCCEEDED",
		4: "FAILED",
	}
	RuleConfigInfo_LastBackupState_value = map[string]int32{
		"LAST_BACKUP_STATE_UNSPECIFIED": 0,
		"FIRST_BACKUP_PENDING":          1,
		"PERMISSION_DENIED":             2,
		"SUCCEEDED":                     3,
		"FAILED":                        4,
	}
)

func (x RuleConfigInfo_LastBackupState) Enum() *RuleConfigInfo_LastBackupState {
	p := new(RuleConfigInfo_LastBackupState)
	*p = x
	return p
}

func (x RuleConfigInfo_LastBackupState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RuleConfigInfo_LastBackupState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_enumTypes[1].Descriptor()
}

func (RuleConfigInfo_LastBackupState) Type() protoreflect.EnumType {
	return &file_google_cloud_backupdr_v1_backupplanassociation_proto_enumTypes[1]
}

func (x RuleConfigInfo_LastBackupState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RuleConfigInfo_LastBackupState.Descriptor instead.
func (RuleConfigInfo_LastBackupState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescGZIP(), []int{1, 0}
}

// A BackupPlanAssociation represents a single BackupPlanAssociation which
// contains details like workload, backup plan etc
type BackupPlanAssociation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The resource name of BackupPlanAssociation in
	// below format Format :
	// projects/{project}/locations/{location}/backupPlanAssociations/{backupPlanAssociationId}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. Resource type of workload on which backupplan is
	// applied
	ResourceType string `protobuf:"bytes,2,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Required. Immutable. Resource name of workload on which backupplan is
	// applied
	Resource string `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
	// Required. Resource name of backup plan which needs to be applied on
	// workload. Format:
	// projects/{project}/locations/{location}/backupPlans/{backupPlanId}
	BackupPlan string `protobuf:"bytes,4,opt,name=backup_plan,json=backupPlan,proto3" json:"backup_plan,omitempty"`
	// Output only. The time when the instance was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the instance was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The BackupPlanAssociation resource state.
	State BackupPlanAssociation_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.backupdr.v1.BackupPlanAssociation_State" json:"state,omitempty"`
	// Output only. The config info related to backup rules.
	RulesConfigInfo []*RuleConfigInfo `protobuf:"bytes,8,rep,name=rules_config_info,json=rulesConfigInfo,proto3" json:"rules_config_info,omitempty"`
	// Output only. Resource name of data source which will be used as storage
	// location for backups taken. Format :
	// projects/{project}/locations/{location}/backupVaults/{backupvault}/dataSources/{datasource}
	DataSource string `protobuf:"bytes,9,opt,name=data_source,json=dataSource,proto3" json:"data_source,omitempty"`
}

func (x *BackupPlanAssociation) Reset() {
	*x = BackupPlanAssociation{}
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BackupPlanAssociation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupPlanAssociation) ProtoMessage() {}

func (x *BackupPlanAssociation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupPlanAssociation.ProtoReflect.Descriptor instead.
func (*BackupPlanAssociation) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescGZIP(), []int{0}
}

func (x *BackupPlanAssociation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *BackupPlanAssociation) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *BackupPlanAssociation) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *BackupPlanAssociation) GetBackupPlan() string {
	if x != nil {
		return x.BackupPlan
	}
	return ""
}

func (x *BackupPlanAssociation) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BackupPlanAssociation) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *BackupPlanAssociation) GetState() BackupPlanAssociation_State {
	if x != nil {
		return x.State
	}
	return BackupPlanAssociation_STATE_UNSPECIFIED
}

func (x *BackupPlanAssociation) GetRulesConfigInfo() []*RuleConfigInfo {
	if x != nil {
		return x.RulesConfigInfo
	}
	return nil
}

func (x *BackupPlanAssociation) GetDataSource() string {
	if x != nil {
		return x.DataSource
	}
	return ""
}

// Message for rules config info.
type RuleConfigInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Backup Rule id fetched from backup plan.
	RuleId string `protobuf:"bytes,1,opt,name=rule_id,json=ruleId,proto3" json:"rule_id,omitempty"`
	// Output only. The last backup state for rule.
	LastBackupState RuleConfigInfo_LastBackupState `protobuf:"varint,3,opt,name=last_backup_state,json=lastBackupState,proto3,enum=google.cloud.backupdr.v1.RuleConfigInfo_LastBackupState" json:"last_backup_state,omitempty"`
	// Output only. google.rpc.Status object to store the last backup error.
	LastBackupError *status.Status `protobuf:"bytes,4,opt,name=last_backup_error,json=lastBackupError,proto3" json:"last_backup_error,omitempty"`
	// Output only. The point in time when the last successful backup was captured
	// from the source.
	LastSuccessfulBackupConsistencyTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=last_successful_backup_consistency_time,json=lastSuccessfulBackupConsistencyTime,proto3" json:"last_successful_backup_consistency_time,omitempty"`
}

func (x *RuleConfigInfo) Reset() {
	*x = RuleConfigInfo{}
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuleConfigInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuleConfigInfo) ProtoMessage() {}

func (x *RuleConfigInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuleConfigInfo.ProtoReflect.Descriptor instead.
func (*RuleConfigInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescGZIP(), []int{1}
}

func (x *RuleConfigInfo) GetRuleId() string {
	if x != nil {
		return x.RuleId
	}
	return ""
}

func (x *RuleConfigInfo) GetLastBackupState() RuleConfigInfo_LastBackupState {
	if x != nil {
		return x.LastBackupState
	}
	return RuleConfigInfo_LAST_BACKUP_STATE_UNSPECIFIED
}

func (x *RuleConfigInfo) GetLastBackupError() *status.Status {
	if x != nil {
		return x.LastBackupError
	}
	return nil
}

func (x *RuleConfigInfo) GetLastSuccessfulBackupConsistencyTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSuccessfulBackupConsistencyTime
	}
	return nil
}

// Request message for creating a backup plan.
type CreateBackupPlanAssociationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The backup plan association project and location in the format
	// `projects/{project_id}/locations/{location}`. In Cloud BackupDR locations
	// map to GCP regions, for example **us-central1**.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name of the backup plan association to create. The name must
	// be unique for the specified project and location.
	BackupPlanAssociationId string `protobuf:"bytes,2,opt,name=backup_plan_association_id,json=backupPlanAssociationId,proto3" json:"backup_plan_association_id,omitempty"`
	// Required. The resource being created
	BackupPlanAssociation *BackupPlanAssociation `protobuf:"bytes,3,opt,name=backup_plan_association,json=backupPlanAssociation,proto3" json:"backup_plan_association,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateBackupPlanAssociationRequest) Reset() {
	*x = CreateBackupPlanAssociationRequest{}
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateBackupPlanAssociationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupPlanAssociationRequest) ProtoMessage() {}

func (x *CreateBackupPlanAssociationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupPlanAssociationRequest.ProtoReflect.Descriptor instead.
func (*CreateBackupPlanAssociationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescGZIP(), []int{2}
}

func (x *CreateBackupPlanAssociationRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBackupPlanAssociationRequest) GetBackupPlanAssociationId() string {
	if x != nil {
		return x.BackupPlanAssociationId
	}
	return ""
}

func (x *CreateBackupPlanAssociationRequest) GetBackupPlanAssociation() *BackupPlanAssociation {
	if x != nil {
		return x.BackupPlanAssociation
	}
	return nil
}

func (x *CreateBackupPlanAssociationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for List BackupPlanAssociation
type ListBackupPlanAssociationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location for which to retrieve backup Plan
	// Associations information, in the format
	// `projects/{project_id}/locations/{location}`. In Cloud BackupDR, locations
	// map to GCP regions, for example **us-central1**. To retrieve backup plan
	// associations for all locations, use "-" for the
	// `{location}` value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListBackupPlanAssociationsRequest) Reset() {
	*x = ListBackupPlanAssociationsRequest{}
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupPlanAssociationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupPlanAssociationsRequest) ProtoMessage() {}

func (x *ListBackupPlanAssociationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupPlanAssociationsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupPlanAssociationsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescGZIP(), []int{3}
}

func (x *ListBackupPlanAssociationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupPlanAssociationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupPlanAssociationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBackupPlanAssociationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for List BackupPlanAssociation
type ListBackupPlanAssociationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Backup Plan Associations in the project for the specified
	// location.
	//
	// If the `{location}` value in the request is "-", the response contains a
	// list of instances from all locations. In case any location is unreachable,
	// the response will only return backup plan associations in reachable
	// locations and the 'unreachable' field will be populated with a list of
	// unreachable locations.
	BackupPlanAssociations []*BackupPlanAssociation `protobuf:"bytes,1,rep,name=backup_plan_associations,json=backupPlanAssociations,proto3" json:"backup_plan_associations,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupPlanAssociationsResponse) Reset() {
	*x = ListBackupPlanAssociationsResponse{}
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBackupPlanAssociationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupPlanAssociationsResponse) ProtoMessage() {}

func (x *ListBackupPlanAssociationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupPlanAssociationsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupPlanAssociationsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescGZIP(), []int{4}
}

func (x *ListBackupPlanAssociationsResponse) GetBackupPlanAssociations() []*BackupPlanAssociation {
	if x != nil {
		return x.BackupPlanAssociations
	}
	return nil
}

func (x *ListBackupPlanAssociationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupPlanAssociationsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for getting a BackupPlanAssociation resource.
type GetBackupPlanAssociationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the backup plan association resource, in the format
	// `projects/{project}/locations/{location}/backupPlanAssociations/{backupPlanAssociationId}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupPlanAssociationRequest) Reset() {
	*x = GetBackupPlanAssociationRequest{}
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBackupPlanAssociationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupPlanAssociationRequest) ProtoMessage() {}

func (x *GetBackupPlanAssociationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupPlanAssociationRequest.ProtoReflect.Descriptor instead.
func (*GetBackupPlanAssociationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescGZIP(), []int{5}
}

func (x *GetBackupPlanAssociationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for deleting a backup plan association.
type DeleteBackupPlanAssociationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the backup plan association resource, in the format
	// `projects/{project}/locations/{location}/backupPlanAssociations/{backupPlanAssociationId}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteBackupPlanAssociationRequest) Reset() {
	*x = DeleteBackupPlanAssociationRequest{}
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBackupPlanAssociationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupPlanAssociationRequest) ProtoMessage() {}

func (x *DeleteBackupPlanAssociationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupPlanAssociationRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupPlanAssociationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteBackupPlanAssociationRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteBackupPlanAssociationRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for triggering a backup.
type TriggerBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the backup plan association resource, in the format
	// `projects/{project}/locations/{location}/backupPlanAssociations/{backupPlanAssociationId}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. backup rule_id for which a backup needs to be triggered.
	RuleId string `protobuf:"bytes,2,opt,name=rule_id,json=ruleId,proto3" json:"rule_id,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *TriggerBackupRequest) Reset() {
	*x = TriggerBackupRequest{}
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TriggerBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TriggerBackupRequest) ProtoMessage() {}

func (x *TriggerBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TriggerBackupRequest.ProtoReflect.Descriptor instead.
func (*TriggerBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescGZIP(), []int{7}
}

func (x *TriggerBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TriggerBackupRequest) GetRuleId() string {
	if x != nil {
		return x.RuleId
	}
	return ""
}

func (x *TriggerBackupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

var File_google_cloud_backupdr_v1_backupplanassociation_proto protoreflect.FileDescriptor

var file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xbd, 0x06, 0x0a, 0x15, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c,
	0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x08,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0d, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4b, 0x0a, 0x0b, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x52, 0x0a, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x50, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x59, 0x0a,
	0x11, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e,
	0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x54,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x10, 0x04, 0x3a, 0xbc, 0x01, 0xea, 0x41, 0xb8, 0x01, 0x0a, 0x2d, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41,
	0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73,
	0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x16, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e,
	0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x15, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xd8, 0x03, 0x0a, 0x0e, 0x52, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1c, 0x0a, 0x07, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x72, 0x75,
	0x6c, 0x65, 0x49, 0x64, 0x12, 0x69, 0x0a, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4c, 0x61, 0x73, 0x74, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f,
	0x6c, 0x61, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x43, 0x0a, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6c, 0x61, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x45,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x75, 0x0a, 0x27, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x75, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x63,
	0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x23, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x75, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x80, 0x01, 0x0a, 0x0f,
	0x4c, 0x61, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x21, 0x0a, 0x1d, 0x4c, 0x41, 0x53, 0x54, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x42, 0x41, 0x43, 0x4b,
	0x55, 0x50, 0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11,
	0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45,
	0x44, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44,
	0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x22, 0xcf,
	0x02, 0x0a, 0x22, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x1a, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x5f, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x17, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x6c, 0x0a, 0x17, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73,
	0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf,
	0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0xd5, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4d, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x12, 0x2d,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c,
	0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xd9, 0x01, 0x0a, 0x22, 0x4c, 0x69, 0x73,
	0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63,
	0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x69, 0x0a, 0x18, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x61,
	0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x16, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73,
	0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x6c, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61,
	0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x9b, 0x01, 0x0a, 0x22, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a,
	0x2d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf,
	0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0xab, 0x01, 0x0a, 0x14, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2f, 0x0a,
	0x2d, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50,
	0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x07, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x72, 0x75, 0x6c, 0x65,
	0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08,
	0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x42, 0xca,
	0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2e, 0x76, 0x31, 0x42,
	0x1a, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x41, 0x73, 0x73, 0x6f, 0x63,
	0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x64, 0x72, 0x70, 0x62, 0x3b, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x64, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x2e,
	0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x52, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescOnce sync.Once
	file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescData = file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDesc
)

func file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescGZIP() []byte {
	file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescOnce.Do(func() {
		file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescData)
	})
	return file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDescData
}

var file_google_cloud_backupdr_v1_backupplanassociation_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_backupdr_v1_backupplanassociation_proto_goTypes = []any{
	(BackupPlanAssociation_State)(0),           // 0: google.cloud.backupdr.v1.BackupPlanAssociation.State
	(RuleConfigInfo_LastBackupState)(0),        // 1: google.cloud.backupdr.v1.RuleConfigInfo.LastBackupState
	(*BackupPlanAssociation)(nil),              // 2: google.cloud.backupdr.v1.BackupPlanAssociation
	(*RuleConfigInfo)(nil),                     // 3: google.cloud.backupdr.v1.RuleConfigInfo
	(*CreateBackupPlanAssociationRequest)(nil), // 4: google.cloud.backupdr.v1.CreateBackupPlanAssociationRequest
	(*ListBackupPlanAssociationsRequest)(nil),  // 5: google.cloud.backupdr.v1.ListBackupPlanAssociationsRequest
	(*ListBackupPlanAssociationsResponse)(nil), // 6: google.cloud.backupdr.v1.ListBackupPlanAssociationsResponse
	(*GetBackupPlanAssociationRequest)(nil),    // 7: google.cloud.backupdr.v1.GetBackupPlanAssociationRequest
	(*DeleteBackupPlanAssociationRequest)(nil), // 8: google.cloud.backupdr.v1.DeleteBackupPlanAssociationRequest
	(*TriggerBackupRequest)(nil),               // 9: google.cloud.backupdr.v1.TriggerBackupRequest
	(*timestamppb.Timestamp)(nil),              // 10: google.protobuf.Timestamp
	(*status.Status)(nil),                      // 11: google.rpc.Status
}
var file_google_cloud_backupdr_v1_backupplanassociation_proto_depIdxs = []int32{
	10, // 0: google.cloud.backupdr.v1.BackupPlanAssociation.create_time:type_name -> google.protobuf.Timestamp
	10, // 1: google.cloud.backupdr.v1.BackupPlanAssociation.update_time:type_name -> google.protobuf.Timestamp
	0,  // 2: google.cloud.backupdr.v1.BackupPlanAssociation.state:type_name -> google.cloud.backupdr.v1.BackupPlanAssociation.State
	3,  // 3: google.cloud.backupdr.v1.BackupPlanAssociation.rules_config_info:type_name -> google.cloud.backupdr.v1.RuleConfigInfo
	1,  // 4: google.cloud.backupdr.v1.RuleConfigInfo.last_backup_state:type_name -> google.cloud.backupdr.v1.RuleConfigInfo.LastBackupState
	11, // 5: google.cloud.backupdr.v1.RuleConfigInfo.last_backup_error:type_name -> google.rpc.Status
	10, // 6: google.cloud.backupdr.v1.RuleConfigInfo.last_successful_backup_consistency_time:type_name -> google.protobuf.Timestamp
	2,  // 7: google.cloud.backupdr.v1.CreateBackupPlanAssociationRequest.backup_plan_association:type_name -> google.cloud.backupdr.v1.BackupPlanAssociation
	2,  // 8: google.cloud.backupdr.v1.ListBackupPlanAssociationsResponse.backup_plan_associations:type_name -> google.cloud.backupdr.v1.BackupPlanAssociation
	9,  // [9:9] is the sub-list for method output_type
	9,  // [9:9] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_backupdr_v1_backupplanassociation_proto_init() }
func file_google_cloud_backupdr_v1_backupplanassociation_proto_init() {
	if File_google_cloud_backupdr_v1_backupplanassociation_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_backupdr_v1_backupplanassociation_proto_goTypes,
		DependencyIndexes: file_google_cloud_backupdr_v1_backupplanassociation_proto_depIdxs,
		EnumInfos:         file_google_cloud_backupdr_v1_backupplanassociation_proto_enumTypes,
		MessageInfos:      file_google_cloud_backupdr_v1_backupplanassociation_proto_msgTypes,
	}.Build()
	File_google_cloud_backupdr_v1_backupplanassociation_proto = out.File
	file_google_cloud_backupdr_v1_backupplanassociation_proto_rawDesc = nil
	file_google_cloud_backupdr_v1_backupplanassociation_proto_goTypes = nil
	file_google_cloud_backupdr_v1_backupplanassociation_proto_depIdxs = nil
}
