#!/usr/bin/env sh

# This script generates internal/vm/opcodes/all.go.

set -e

(
	# shellcheck disable=SC2016
	echo '// Generated by generate_opcodes_all.sh. Run `make fix` to update. DO NOT EDIT.'
	echo
	echo 'package opcodes'
	echo
	echo 'import "github.com/git-town/git-town/v22/internal/vm/shared"'
	echo
	echo '// All provides all existing opcodes.'
	echo '// This is used to iterate all opcode types.'
	echo 'func All() []shared.Opcode {'
	echo '	return []shared.Opcode{'
	cat internal/vm/opcodes/*.go | grep '^type .* struct' | sed -e 's/type /\t\t\&/' -e 's/ struct.*/{},/' | LC_COLLATE=C sort
	echo '	} //exhaustruct:ignore'
	echo '}'
) >internal/vm/opcodes/all.go
echo "Generated internal/vm/opcodes/all.go"
