// Copyright 2022-2023 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package serial

import (
	"strconv"

	flatbuffers "github.com/dolthub/flatbuffers/v23/go"
)

type DistanceType byte

const (
	DistanceTypeNull       DistanceType = 0
	DistanceTypeL2_Squared DistanceType = 1
)

var EnumNamesDistanceType = map[DistanceType]string{
	DistanceTypeNull:       "Null",
	DistanceTypeL2_Squared: "L2_Squared",
}

var EnumValuesDistanceType = map[string]DistanceType{
	"Null":       DistanceTypeNull,
	"L2_Squared": DistanceTypeL2_Squared,
}

func (v DistanceType) String() string {
	if s, ok := EnumNamesDistanceType[v]; ok {
		return s
	}
	return "DistanceType(" + strconv.FormatInt(int64(v), 10) + ")"
}

type TableSchema struct {
	_tab flatbuffers.Table
}

func InitTableSchemaRoot(o *TableSchema, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	return o.Init(buf, n+offset)
}

func TryGetRootAsTableSchema(buf []byte, offset flatbuffers.UOffsetT) (*TableSchema, error) {
	x := &TableSchema{}
	return x, InitTableSchemaRoot(x, buf, offset)
}

func TryGetSizePrefixedRootAsTableSchema(buf []byte, offset flatbuffers.UOffsetT) (*TableSchema, error) {
	x := &TableSchema{}
	return x, InitTableSchemaRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func (rcv *TableSchema) Init(buf []byte, i flatbuffers.UOffsetT) error {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
	if TableSchemaNumFields < rcv.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func (rcv *TableSchema) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *TableSchema) TryColumns(obj *Column, j int) (bool, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		if ColumnNumFields < obj.Table().NumFields() {
			return false, flatbuffers.ErrTableHasUnknownFields
		}
		return true, nil
	}
	return false, nil
}

func (rcv *TableSchema) ColumnsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *TableSchema) TryClusteredIndex(obj *Index) (*Index, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(Index)
		}
		obj.Init(rcv._tab.Bytes, x)
		if IndexNumFields < obj.Table().NumFields() {
			return nil, flatbuffers.ErrTableHasUnknownFields
		}
		return obj, nil
	}
	return nil, nil
}

func (rcv *TableSchema) TrySecondaryIndexes(obj *Index, j int) (bool, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		if IndexNumFields < obj.Table().NumFields() {
			return false, flatbuffers.ErrTableHasUnknownFields
		}
		return true, nil
	}
	return false, nil
}

func (rcv *TableSchema) SecondaryIndexesLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *TableSchema) TryChecks(obj *CheckConstraint, j int) (bool, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		x := rcv._tab.Vector(o)
		x += flatbuffers.UOffsetT(j) * 4
		x = rcv._tab.Indirect(x)
		obj.Init(rcv._tab.Bytes, x)
		if CheckConstraintNumFields < obj.Table().NumFields() {
			return false, flatbuffers.ErrTableHasUnknownFields
		}
		return true, nil
	}
	return false, nil
}

func (rcv *TableSchema) ChecksLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *TableSchema) Collation() Collation {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return Collation(rcv._tab.GetUint16(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *TableSchema) MutateCollation(n Collation) bool {
	return rcv._tab.MutateUint16Slot(12, uint16(n))
}

func (rcv *TableSchema) HasFeaturesAfterTryAccessors() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *TableSchema) MutateHasFeaturesAfterTryAccessors(n bool) bool {
	return rcv._tab.MutateBoolSlot(14, n)
}

func (rcv *TableSchema) Comment() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

const TableSchemaNumFields = 7

func TableSchemaStart(builder *flatbuffers.Builder) {
	builder.StartObject(TableSchemaNumFields)
}
func TableSchemaAddColumns(builder *flatbuffers.Builder, columns flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(columns), 0)
}
func TableSchemaStartColumnsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func TableSchemaAddClusteredIndex(builder *flatbuffers.Builder, clusteredIndex flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(clusteredIndex), 0)
}
func TableSchemaAddSecondaryIndexes(builder *flatbuffers.Builder, secondaryIndexes flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(secondaryIndexes), 0)
}
func TableSchemaStartSecondaryIndexesVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func TableSchemaAddChecks(builder *flatbuffers.Builder, checks flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(checks), 0)
}
func TableSchemaStartChecksVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func TableSchemaAddCollation(builder *flatbuffers.Builder, collation Collation) {
	builder.PrependUint16Slot(4, uint16(collation), 0)
}
func TableSchemaAddHasFeaturesAfterTryAccessors(builder *flatbuffers.Builder, hasFeaturesAfterTryAccessors bool) {
	builder.PrependBoolSlot(5, hasFeaturesAfterTryAccessors, false)
}
func TableSchemaAddComment(builder *flatbuffers.Builder, comment flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(6, flatbuffers.UOffsetT(comment), 0)
}
func TableSchemaEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Column struct {
	_tab flatbuffers.Table
}

func InitColumnRoot(o *Column, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	return o.Init(buf, n+offset)
}

func TryGetRootAsColumn(buf []byte, offset flatbuffers.UOffsetT) (*Column, error) {
	x := &Column{}
	return x, InitColumnRoot(x, buf, offset)
}

func TryGetSizePrefixedRootAsColumn(buf []byte, offset flatbuffers.UOffsetT) (*Column, error) {
	x := &Column{}
	return x, InitColumnRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func (rcv *Column) Init(buf []byte, i flatbuffers.UOffsetT) error {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
	if ColumnNumFields < rcv.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func (rcv *Column) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Column) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *Column) SqlType() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *Column) DefaultValue() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *Column) Comment() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *Column) DisplayOrder() int16 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return rcv._tab.GetInt16(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *Column) MutateDisplayOrder(n int16) bool {
	return rcv._tab.MutateInt16Slot(12, n)
}

func (rcv *Column) Tag() uint64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		return rcv._tab.GetUint64(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *Column) MutateTag(n uint64) bool {
	return rcv._tab.MutateUint64Slot(14, n)
}

func (rcv *Column) Encoding() Encoding {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		return Encoding(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *Column) MutateEncoding(n Encoding) bool {
	return rcv._tab.MutateByteSlot(16, byte(n))
}

func (rcv *Column) PrimaryKey() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Column) MutatePrimaryKey(n bool) bool {
	return rcv._tab.MutateBoolSlot(18, n)
}

func (rcv *Column) Nullable() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(20))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Column) MutateNullable(n bool) bool {
	return rcv._tab.MutateBoolSlot(20, n)
}

func (rcv *Column) AutoIncrement() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(22))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Column) MutateAutoIncrement(n bool) bool {
	return rcv._tab.MutateBoolSlot(22, n)
}

func (rcv *Column) Hidden() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(24))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Column) MutateHidden(n bool) bool {
	return rcv._tab.MutateBoolSlot(24, n)
}

func (rcv *Column) Generated() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(26))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Column) MutateGenerated(n bool) bool {
	return rcv._tab.MutateBoolSlot(26, n)
}

func (rcv *Column) Virtual() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(28))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Column) MutateVirtual(n bool) bool {
	return rcv._tab.MutateBoolSlot(28, n)
}

func (rcv *Column) OnUpdateValue() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(30))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

const ColumnNumFields = 14

func ColumnStart(builder *flatbuffers.Builder) {
	builder.StartObject(ColumnNumFields)
}
func ColumnAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(name), 0)
}
func ColumnAddSqlType(builder *flatbuffers.Builder, sqlType flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(sqlType), 0)
}
func ColumnAddDefaultValue(builder *flatbuffers.Builder, defaultValue flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(defaultValue), 0)
}
func ColumnAddComment(builder *flatbuffers.Builder, comment flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(comment), 0)
}
func ColumnAddDisplayOrder(builder *flatbuffers.Builder, displayOrder int16) {
	builder.PrependInt16Slot(4, displayOrder, 0)
}
func ColumnAddTag(builder *flatbuffers.Builder, tag uint64) {
	builder.PrependUint64Slot(5, tag, 0)
}
func ColumnAddEncoding(builder *flatbuffers.Builder, encoding Encoding) {
	builder.PrependByteSlot(6, byte(encoding), 0)
}
func ColumnAddPrimaryKey(builder *flatbuffers.Builder, primaryKey bool) {
	builder.PrependBoolSlot(7, primaryKey, false)
}
func ColumnAddNullable(builder *flatbuffers.Builder, nullable bool) {
	builder.PrependBoolSlot(8, nullable, false)
}
func ColumnAddAutoIncrement(builder *flatbuffers.Builder, autoIncrement bool) {
	builder.PrependBoolSlot(9, autoIncrement, false)
}
func ColumnAddHidden(builder *flatbuffers.Builder, hidden bool) {
	builder.PrependBoolSlot(10, hidden, false)
}
func ColumnAddGenerated(builder *flatbuffers.Builder, generated bool) {
	builder.PrependBoolSlot(11, generated, false)
}
func ColumnAddVirtual(builder *flatbuffers.Builder, virtual bool) {
	builder.PrependBoolSlot(12, virtual, false)
}
func ColumnAddOnUpdateValue(builder *flatbuffers.Builder, onUpdateValue flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(13, flatbuffers.UOffsetT(onUpdateValue), 0)
}
func ColumnEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type Index struct {
	_tab flatbuffers.Table
}

func InitIndexRoot(o *Index, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	return o.Init(buf, n+offset)
}

func TryGetRootAsIndex(buf []byte, offset flatbuffers.UOffsetT) (*Index, error) {
	x := &Index{}
	return x, InitIndexRoot(x, buf, offset)
}

func TryGetSizePrefixedRootAsIndex(buf []byte, offset flatbuffers.UOffsetT) (*Index, error) {
	x := &Index{}
	return x, InitIndexRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func (rcv *Index) Init(buf []byte, i flatbuffers.UOffsetT) error {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
	if IndexNumFields < rcv.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func (rcv *Index) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *Index) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *Index) Comment() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *Index) IndexColumns(j int) uint16 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetUint16(a + flatbuffers.UOffsetT(j*2))
	}
	return 0
}

func (rcv *Index) IndexColumnsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *Index) MutateIndexColumns(j int, n uint16) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateUint16(a+flatbuffers.UOffsetT(j*2), n)
	}
	return false
}

func (rcv *Index) KeyColumns(j int) uint16 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetUint16(a + flatbuffers.UOffsetT(j*2))
	}
	return 0
}

func (rcv *Index) KeyColumnsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *Index) MutateKeyColumns(j int, n uint16) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateUint16(a+flatbuffers.UOffsetT(j*2), n)
	}
	return false
}

func (rcv *Index) ValueColumns(j int) uint16 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetUint16(a + flatbuffers.UOffsetT(j*2))
	}
	return 0
}

func (rcv *Index) ValueColumnsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *Index) MutateValueColumns(j int, n uint16) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateUint16(a+flatbuffers.UOffsetT(j*2), n)
	}
	return false
}

func (rcv *Index) PrimaryKey() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Index) MutatePrimaryKey(n bool) bool {
	return rcv._tab.MutateBoolSlot(14, n)
}

func (rcv *Index) UniqueKey() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Index) MutateUniqueKey(n bool) bool {
	return rcv._tab.MutateBoolSlot(16, n)
}

func (rcv *Index) SystemDefined() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Index) MutateSystemDefined(n bool) bool {
	return rcv._tab.MutateBoolSlot(18, n)
}

func (rcv *Index) PrefixLengths(j int) uint16 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(20))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetUint16(a + flatbuffers.UOffsetT(j*2))
	}
	return 0
}

func (rcv *Index) PrefixLengthsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(20))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *Index) MutatePrefixLengths(j int, n uint16) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(20))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateUint16(a+flatbuffers.UOffsetT(j*2), n)
	}
	return false
}

func (rcv *Index) SpatialKey() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(22))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Index) MutateSpatialKey(n bool) bool {
	return rcv._tab.MutateBoolSlot(22, n)
}

func (rcv *Index) FulltextKey() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(24))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Index) MutateFulltextKey(n bool) bool {
	return rcv._tab.MutateBoolSlot(24, n)
}

func (rcv *Index) TryFulltextInfo(obj *FulltextInfo) (*FulltextInfo, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(26))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(FulltextInfo)
		}
		obj.Init(rcv._tab.Bytes, x)
		if FulltextInfoNumFields < obj.Table().NumFields() {
			return nil, flatbuffers.ErrTableHasUnknownFields
		}
		return obj, nil
	}
	return nil, nil
}

func (rcv *Index) VectorKey() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(28))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *Index) MutateVectorKey(n bool) bool {
	return rcv._tab.MutateBoolSlot(28, n)
}

func (rcv *Index) TryVectorInfo(obj *VectorInfo) (*VectorInfo, error) {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(30))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(VectorInfo)
		}
		obj.Init(rcv._tab.Bytes, x)
		if VectorInfoNumFields < obj.Table().NumFields() {
			return nil, flatbuffers.ErrTableHasUnknownFields
		}
		return obj, nil
	}
	return nil, nil
}

const IndexNumFields = 14

func IndexStart(builder *flatbuffers.Builder) {
	builder.StartObject(IndexNumFields)
}
func IndexAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(name), 0)
}
func IndexAddComment(builder *flatbuffers.Builder, comment flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(comment), 0)
}
func IndexAddIndexColumns(builder *flatbuffers.Builder, indexColumns flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(indexColumns), 0)
}
func IndexStartIndexColumnsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(2, numElems, 2)
}
func IndexAddKeyColumns(builder *flatbuffers.Builder, keyColumns flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(keyColumns), 0)
}
func IndexStartKeyColumnsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(2, numElems, 2)
}
func IndexAddValueColumns(builder *flatbuffers.Builder, valueColumns flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(valueColumns), 0)
}
func IndexStartValueColumnsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(2, numElems, 2)
}
func IndexAddPrimaryKey(builder *flatbuffers.Builder, primaryKey bool) {
	builder.PrependBoolSlot(5, primaryKey, false)
}
func IndexAddUniqueKey(builder *flatbuffers.Builder, uniqueKey bool) {
	builder.PrependBoolSlot(6, uniqueKey, false)
}
func IndexAddSystemDefined(builder *flatbuffers.Builder, systemDefined bool) {
	builder.PrependBoolSlot(7, systemDefined, false)
}
func IndexAddPrefixLengths(builder *flatbuffers.Builder, prefixLengths flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(8, flatbuffers.UOffsetT(prefixLengths), 0)
}
func IndexStartPrefixLengthsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(2, numElems, 2)
}
func IndexAddSpatialKey(builder *flatbuffers.Builder, spatialKey bool) {
	builder.PrependBoolSlot(9, spatialKey, false)
}
func IndexAddFulltextKey(builder *flatbuffers.Builder, fulltextKey bool) {
	builder.PrependBoolSlot(10, fulltextKey, false)
}
func IndexAddFulltextInfo(builder *flatbuffers.Builder, fulltextInfo flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(11, flatbuffers.UOffsetT(fulltextInfo), 0)
}
func IndexAddVectorKey(builder *flatbuffers.Builder, vectorKey bool) {
	builder.PrependBoolSlot(12, vectorKey, false)
}
func IndexAddVectorInfo(builder *flatbuffers.Builder, vectorInfo flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(13, flatbuffers.UOffsetT(vectorInfo), 0)
}
func IndexEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type FulltextInfo struct {
	_tab flatbuffers.Table
}

func InitFulltextInfoRoot(o *FulltextInfo, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	return o.Init(buf, n+offset)
}

func TryGetRootAsFulltextInfo(buf []byte, offset flatbuffers.UOffsetT) (*FulltextInfo, error) {
	x := &FulltextInfo{}
	return x, InitFulltextInfoRoot(x, buf, offset)
}

func TryGetSizePrefixedRootAsFulltextInfo(buf []byte, offset flatbuffers.UOffsetT) (*FulltextInfo, error) {
	x := &FulltextInfo{}
	return x, InitFulltextInfoRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func (rcv *FulltextInfo) Init(buf []byte, i flatbuffers.UOffsetT) error {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
	if FulltextInfoNumFields < rcv.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func (rcv *FulltextInfo) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *FulltextInfo) ConfigTable() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *FulltextInfo) PositionTable() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *FulltextInfo) DocCountTable() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *FulltextInfo) GlobalCountTable() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *FulltextInfo) RowCountTable() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *FulltextInfo) KeyType() byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		return rcv._tab.GetByte(o + rcv._tab.Pos)
	}
	return 0
}

func (rcv *FulltextInfo) MutateKeyType(n byte) bool {
	return rcv._tab.MutateByteSlot(14, n)
}

func (rcv *FulltextInfo) KeyName() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *FulltextInfo) KeyPositions(j int) uint16 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.GetUint16(a + flatbuffers.UOffsetT(j*2))
	}
	return 0
}

func (rcv *FulltextInfo) KeyPositionsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

func (rcv *FulltextInfo) MutateKeyPositions(j int, n uint16) bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(18))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.MutateUint16(a+flatbuffers.UOffsetT(j*2), n)
	}
	return false
}

const FulltextInfoNumFields = 8

func FulltextInfoStart(builder *flatbuffers.Builder) {
	builder.StartObject(FulltextInfoNumFields)
}
func FulltextInfoAddConfigTable(builder *flatbuffers.Builder, configTable flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(configTable), 0)
}
func FulltextInfoAddPositionTable(builder *flatbuffers.Builder, positionTable flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(positionTable), 0)
}
func FulltextInfoAddDocCountTable(builder *flatbuffers.Builder, docCountTable flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(docCountTable), 0)
}
func FulltextInfoAddGlobalCountTable(builder *flatbuffers.Builder, globalCountTable flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(globalCountTable), 0)
}
func FulltextInfoAddRowCountTable(builder *flatbuffers.Builder, rowCountTable flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(rowCountTable), 0)
}
func FulltextInfoAddKeyType(builder *flatbuffers.Builder, keyType byte) {
	builder.PrependByteSlot(5, keyType, 0)
}
func FulltextInfoAddKeyName(builder *flatbuffers.Builder, keyName flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(6, flatbuffers.UOffsetT(keyName), 0)
}
func FulltextInfoAddKeyPositions(builder *flatbuffers.Builder, keyPositions flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(7, flatbuffers.UOffsetT(keyPositions), 0)
}
func FulltextInfoStartKeyPositionsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(2, numElems, 2)
}
func FulltextInfoEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type VectorInfo struct {
	_tab flatbuffers.Table
}

func InitVectorInfoRoot(o *VectorInfo, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	return o.Init(buf, n+offset)
}

func TryGetRootAsVectorInfo(buf []byte, offset flatbuffers.UOffsetT) (*VectorInfo, error) {
	x := &VectorInfo{}
	return x, InitVectorInfoRoot(x, buf, offset)
}

func TryGetSizePrefixedRootAsVectorInfo(buf []byte, offset flatbuffers.UOffsetT) (*VectorInfo, error) {
	x := &VectorInfo{}
	return x, InitVectorInfoRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func (rcv *VectorInfo) Init(buf []byte, i flatbuffers.UOffsetT) error {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
	if VectorInfoNumFields < rcv.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func (rcv *VectorInfo) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *VectorInfo) DistanceType() DistanceType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return DistanceType(rcv._tab.GetByte(o + rcv._tab.Pos))
	}
	return 0
}

func (rcv *VectorInfo) MutateDistanceType(n DistanceType) bool {
	return rcv._tab.MutateByteSlot(4, byte(n))
}

const VectorInfoNumFields = 1

func VectorInfoStart(builder *flatbuffers.Builder) {
	builder.StartObject(VectorInfoNumFields)
}
func VectorInfoAddDistanceType(builder *flatbuffers.Builder, distanceType DistanceType) {
	builder.PrependByteSlot(0, byte(distanceType), 0)
}
func VectorInfoEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}

type CheckConstraint struct {
	_tab flatbuffers.Table
}

func InitCheckConstraintRoot(o *CheckConstraint, buf []byte, offset flatbuffers.UOffsetT) error {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	return o.Init(buf, n+offset)
}

func TryGetRootAsCheckConstraint(buf []byte, offset flatbuffers.UOffsetT) (*CheckConstraint, error) {
	x := &CheckConstraint{}
	return x, InitCheckConstraintRoot(x, buf, offset)
}

func TryGetSizePrefixedRootAsCheckConstraint(buf []byte, offset flatbuffers.UOffsetT) (*CheckConstraint, error) {
	x := &CheckConstraint{}
	return x, InitCheckConstraintRoot(x, buf, offset+flatbuffers.SizeUint32)
}

func (rcv *CheckConstraint) Init(buf []byte, i flatbuffers.UOffsetT) error {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
	if CheckConstraintNumFields < rcv.Table().NumFields() {
		return flatbuffers.ErrTableHasUnknownFields
	}
	return nil
}

func (rcv *CheckConstraint) Table() flatbuffers.Table {
	return rcv._tab
}

func (rcv *CheckConstraint) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *CheckConstraint) Expression() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

func (rcv *CheckConstraint) Enforced() bool {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.GetBool(o + rcv._tab.Pos)
	}
	return false
}

func (rcv *CheckConstraint) MutateEnforced(n bool) bool {
	return rcv._tab.MutateBoolSlot(8, n)
}

const CheckConstraintNumFields = 3

func CheckConstraintStart(builder *flatbuffers.Builder) {
	builder.StartObject(CheckConstraintNumFields)
}
func CheckConstraintAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(name), 0)
}
func CheckConstraintAddExpression(builder *flatbuffers.Builder, expression flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(1, flatbuffers.UOffsetT(expression), 0)
}
func CheckConstraintAddEnforced(builder *flatbuffers.Builder, enforced bool) {
	builder.PrependBoolSlot(2, enforced, false)
}
func CheckConstraintEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
