package cmd

import (
	"github.com/carapace-sh/carapace"
	"github.com/carapace-sh/carapace-bin/completers/common/gh_completer/cmd/action"
	"github.com/spf13/cobra"
)

var run_downloadCmd = &cobra.Command{
	Use:   "download [<run-id>]",
	Short: "Download artifacts generated by a workflow run",
	Run:   func(cmd *cobra.Command, args []string) {},
}

func init() {
	carapace.Gen(run_downloadCmd).Standalone()

	run_downloadCmd.Flags().StringP("dir", "D", "", "The directory to download artifacts into")
	run_downloadCmd.Flags().StringSliceP("name", "n", nil, "Download artifacts that match any of the given names")
	run_downloadCmd.Flags().StringSliceP("pattern", "p", nil, "Download artifacts that match a glob pattern")
	runCmd.AddCommand(run_downloadCmd)

	carapace.Gen(run_downloadCmd).FlagCompletion(carapace.ActionMap{
		"dir": carapace.ActionDirectories(),
		// TODO name
	})

	carapace.Gen(run_downloadCmd).FlagCompletion(carapace.ActionMap{
		"dir": carapace.ActionDirectories(),
		"name": carapace.ActionCallback(func(c carapace.Context) carapace.Action {
			if len(c.Args) > 0 {
				return action.ActionWorkflowArtifactNames(run_downloadCmd, c.Args[0])
			}
			return carapace.ActionValues()
		}),
	})

	carapace.Gen(run_downloadCmd).PositionalCompletion(
		action.ActionWorkflowRuns(run_downloadCmd, action.RunOpts{All: true}),
	)
}
