// Code generated by smithy-go-codegen DO NOT EDIT.

package omics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/omics/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Gets information about a workflow version. For more information, see [Workflow versioning in Amazon Web Services HealthOmics] in the
// Amazon Web Services HealthOmics User Guide.
//
// [Workflow versioning in Amazon Web Services HealthOmics]: https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html
func (c *Client) GetWorkflowVersion(ctx context.Context, params *GetWorkflowVersionInput, optFns ...func(*Options)) (*GetWorkflowVersionOutput, error) {
	if params == nil {
		params = &GetWorkflowVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetWorkflowVersion", params, optFns, c.addOperationGetWorkflowVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetWorkflowVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetWorkflowVersionInput struct {

	// The workflow version name.
	//
	// This member is required.
	VersionName *string

	// The workflow's ID.
	//
	// This member is required.
	WorkflowId *string

	// The export format for the workflow.
	Export []types.WorkflowExport

	// The workflow's type.
	Type types.WorkflowType

	// Amazon Web Services Id of the owner of the workflow.
	WorkflowOwnerId *string

	noSmithyDocumentSerde
}

type GetWorkflowVersionOutput struct {

	// The accelerator for this workflow version.
	Accelerators types.Accelerators

	// ARN of the workflow version.
	Arn *string

	// When the workflow version was created.
	CreationTime *time.Time

	// Definition of the workflow version.
	Definition *string

	// Details about the source code repository that hosts the workflow version
	// definition files.
	DefinitionRepositoryDetails *types.DefinitionRepositoryDetails

	// Description of the workflow version.
	Description *string

	// The workflow version's digest.
	Digest *string

	// The workflow engine for this workflow version.
	Engine types.WorkflowEngine

	// The path of the main definition file for the workflow.
	Main *string

	// The metadata for the workflow version.
	Metadata map[string]string

	// The parameter template for the workflow version.
	ParameterTemplate map[string]types.WorkflowParameter

	// The README content for the workflow version, providing documentation and usage
	// information specific to this version.
	Readme *string

	// The path to the workflow version README markdown file within the repository.
	// This file provides documentation and usage information for the workflow. If not
	// specified, the README.md file from the root directory of the repository will be
	// used.
	ReadmePath *string

	// The workflow version status
	Status types.WorkflowStatus

	// The workflow version status message
	StatusMessage *string

	// The default run storage capacity for static storage.
	StorageCapacity *int32

	// The default storage type for the run.
	StorageType types.StorageType

	// The workflow version tags
	Tags map[string]string

	// The workflow version type
	Type types.WorkflowType

	// The universally unique identifier (UUID) value for this workflow version
	Uuid *string

	// The workflow version name.
	VersionName *string

	// Amazon Web Services Id of the owner of the bucket.
	WorkflowBucketOwnerId *string

	// The workflow's ID.
	WorkflowId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetWorkflowVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetWorkflowVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetWorkflowVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetWorkflowVersion"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opGetWorkflowVersionMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetWorkflowVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetWorkflowVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// WorkflowVersionActiveWaiterOptions are waiter options for
// WorkflowVersionActiveWaiter
type WorkflowVersionActiveWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// WorkflowVersionActiveWaiter will use default minimum delay of 3 seconds. Note
	// that MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, WorkflowVersionActiveWaiter will use default max delay of 30
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetWorkflowVersionInput, *GetWorkflowVersionOutput, error) (bool, error)
}

// WorkflowVersionActiveWaiter defines the waiters for WorkflowVersionActive
type WorkflowVersionActiveWaiter struct {
	client GetWorkflowVersionAPIClient

	options WorkflowVersionActiveWaiterOptions
}

// NewWorkflowVersionActiveWaiter constructs a WorkflowVersionActiveWaiter.
func NewWorkflowVersionActiveWaiter(client GetWorkflowVersionAPIClient, optFns ...func(*WorkflowVersionActiveWaiterOptions)) *WorkflowVersionActiveWaiter {
	options := WorkflowVersionActiveWaiterOptions{}
	options.MinDelay = 3 * time.Second
	options.MaxDelay = 30 * time.Second
	options.Retryable = workflowVersionActiveStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &WorkflowVersionActiveWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for WorkflowVersionActive waiter. The maxWaitDur
// is the maximum wait duration the waiter will wait. The maxWaitDur is required
// and must be greater than zero.
func (w *WorkflowVersionActiveWaiter) Wait(ctx context.Context, params *GetWorkflowVersionInput, maxWaitDur time.Duration, optFns ...func(*WorkflowVersionActiveWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for WorkflowVersionActive waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *WorkflowVersionActiveWaiter) WaitForOutput(ctx context.Context, params *GetWorkflowVersionInput, maxWaitDur time.Duration, optFns ...func(*WorkflowVersionActiveWaiterOptions)) (*GetWorkflowVersionOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 30 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetWorkflowVersion(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for WorkflowVersionActive waiter")
}

func workflowVersionActiveStateRetryable(ctx context.Context, input *GetWorkflowVersionInput, output *GetWorkflowVersionOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Status
		expectedValue := "ACTIVE"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "CREATING"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "UPDATING"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "FAILED"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

type endpointPrefix_opGetWorkflowVersionMiddleware struct {
}

func (*endpointPrefix_opGetWorkflowVersionMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opGetWorkflowVersionMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "workflows-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opGetWorkflowVersionMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opGetWorkflowVersionMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// GetWorkflowVersionAPIClient is a client that implements the GetWorkflowVersion
// operation.
type GetWorkflowVersionAPIClient interface {
	GetWorkflowVersion(context.Context, *GetWorkflowVersionInput, ...func(*Options)) (*GetWorkflowVersionOutput, error)
}

var _ GetWorkflowVersionAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetWorkflowVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetWorkflowVersion",
	}
}
