// Code generated by smithy-go-codegen DO NOT EDIT.

package iotmanagedintegrations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotmanagedintegrations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all account associations for a specific managed thing.
func (c *Client) ListManagedThingAccountAssociations(ctx context.Context, params *ListManagedThingAccountAssociationsInput, optFns ...func(*Options)) (*ListManagedThingAccountAssociationsOutput, error) {
	if params == nil {
		params = &ListManagedThingAccountAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListManagedThingAccountAssociations", params, optFns, c.addOperationListManagedThingAccountAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListManagedThingAccountAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListManagedThingAccountAssociationsInput struct {

	// The identifier of the account association to filter results by. When specified,
	// only associations with this account association ID will be returned.
	AccountAssociationId *string

	// The identifier of the managed thing to list account associations for.
	ManagedThingId *string

	// The maximum number of account associations to return in a single response.
	MaxResults *int32

	// A token used for pagination of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListManagedThingAccountAssociationsOutput struct {

	// The list of managed thing associations that match the specified criteria,
	// including the managed thing ID and account association ID for each association.
	Items []types.ManagedThingAssociation

	// A token used for pagination of results when there are more account associations
	// than can be returned in a single response.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListManagedThingAccountAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListManagedThingAccountAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListManagedThingAccountAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListManagedThingAccountAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListManagedThingAccountAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListManagedThingAccountAssociationsPaginatorOptions is the paginator options
// for ListManagedThingAccountAssociations
type ListManagedThingAccountAssociationsPaginatorOptions struct {
	// The maximum number of account associations to return in a single response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListManagedThingAccountAssociationsPaginator is a paginator for
// ListManagedThingAccountAssociations
type ListManagedThingAccountAssociationsPaginator struct {
	options   ListManagedThingAccountAssociationsPaginatorOptions
	client    ListManagedThingAccountAssociationsAPIClient
	params    *ListManagedThingAccountAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListManagedThingAccountAssociationsPaginator returns a new
// ListManagedThingAccountAssociationsPaginator
func NewListManagedThingAccountAssociationsPaginator(client ListManagedThingAccountAssociationsAPIClient, params *ListManagedThingAccountAssociationsInput, optFns ...func(*ListManagedThingAccountAssociationsPaginatorOptions)) *ListManagedThingAccountAssociationsPaginator {
	if params == nil {
		params = &ListManagedThingAccountAssociationsInput{}
	}

	options := ListManagedThingAccountAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListManagedThingAccountAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListManagedThingAccountAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListManagedThingAccountAssociations page.
func (p *ListManagedThingAccountAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListManagedThingAccountAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListManagedThingAccountAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListManagedThingAccountAssociationsAPIClient is a client that implements the
// ListManagedThingAccountAssociations operation.
type ListManagedThingAccountAssociationsAPIClient interface {
	ListManagedThingAccountAssociations(context.Context, *ListManagedThingAccountAssociationsInput, ...func(*Options)) (*ListManagedThingAccountAssociationsOutput, error)
}

var _ ListManagedThingAccountAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListManagedThingAccountAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListManagedThingAccountAssociations",
	}
}
