// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The details of your linked WhatsApp Business Account.
type LinkedWhatsAppBusinessAccount struct {

	// The ARN of the linked WhatsApp Business Account.
	//
	// This member is required.
	Arn *string

	// The event destinations for the linked WhatsApp Business Account.
	//
	// This member is required.
	EventDestinations []WhatsAppBusinessAccountEventDestination

	// The ID of the linked WhatsApp Business Account, formatted as
	// waba-01234567890123456789012345678901 .
	//
	// This member is required.
	Id *string

	// The date the WhatsApp Business Account was linked.
	//
	// This member is required.
	LinkDate *time.Time

	// The phone numbers associated with the Linked WhatsApp Business Account.
	//
	// This member is required.
	PhoneNumbers []WhatsAppPhoneNumberSummary

	// The registration status of the linked WhatsApp Business Account.
	//
	// This member is required.
	RegistrationStatus RegistrationStatus

	// The WhatsApp Business Account ID from meta.
	//
	// This member is required.
	WabaId *string

	// The name of the linked WhatsApp Business Account.
	//
	// This member is required.
	WabaName *string

	noSmithyDocumentSerde
}

// Contains your WhatsApp registration status and details of any unregistered
// WhatsApp phone number.
type LinkedWhatsAppBusinessAccountIdMetaData struct {

	// The name of your account.
	AccountName *string

	// The registration status of the linked WhatsApp Business Account.
	RegistrationStatus RegistrationStatus

	// The details for unregistered WhatsApp phone numbers.
	UnregisteredWhatsAppPhoneNumbers []WhatsAppPhoneNumberDetail

	// The Amazon Resource Name (ARN) of the WhatsApp Business Account ID.
	WabaId *string

	noSmithyDocumentSerde
}

// The details of a linked WhatsApp Business Account.
type LinkedWhatsAppBusinessAccountSummary struct {

	// The ARN of the linked WhatsApp Business Account.
	//
	// This member is required.
	Arn *string

	// The event destinations for the linked WhatsApp Business Account.
	//
	// This member is required.
	EventDestinations []WhatsAppBusinessAccountEventDestination

	// The ID of the linked WhatsApp Business Account, formatted as
	// waba-01234567890123456789012345678901 .
	//
	// This member is required.
	Id *string

	// The date the WhatsApp Business Account was linked.
	//
	// This member is required.
	LinkDate *time.Time

	// The registration status of the linked WhatsApp Business Account.
	//
	// This member is required.
	RegistrationStatus RegistrationStatus

	// The WhatsApp Business Account ID provided by Meta.
	//
	// This member is required.
	WabaId *string

	// The name of the linked WhatsApp Business Account.
	//
	// This member is required.
	WabaName *string

	noSmithyDocumentSerde
}

// Contains information for the S3 bucket that contains media files.
type S3File struct {

	// The bucket name.
	//
	// This member is required.
	BucketName *string

	// The object key of the media file.
	//
	// This member is required.
	Key *string

	noSmithyDocumentSerde
}

// You can use presigned URLs to grant time-limited access to objects in Amazon S3
// without updating your bucket policy. For more information, see [Working with presigned URLs]in the Amazon S3
// User Guide.
//
// [Working with presigned URLs]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-presigned-url.html
type S3PresignedUrl struct {

	// A map of headers and their values. You must specify the Content-Type header
	// when using PostWhatsAppMessageMedia . For a list of common headers, see [Common Request Headers] in the
	// Amazon S3 API Reference
	//
	// [Common Request Headers]: https://docs.aws.amazon.com/AmazonS3/latest/API/RESTCommonRequestHeaders.html
	//
	// This member is required.
	Headers map[string]string

	// The presign url to the object.
	//
	// This member is required.
	Url *string

	noSmithyDocumentSerde
}

// The tag for a resource.
type Tag struct {

	// The tag key.
	//
	// This member is required.
	Key *string

	// The tag value.
	Value *string

	noSmithyDocumentSerde
}

// The registration details for a linked phone number.
type WabaPhoneNumberSetupFinalization struct {

	// The unique identifier of the originating phone number associated with the
	// media. Phone number identifiers are formatted as
	// phone-number-id-01234567890123456789012345678901 . Use [GetLinkedWhatsAppBusinessAccount] to find a phone
	// number's id.
	//
	// [GetLinkedWhatsAppBusinessAccount]: https://docs.aws.amazon.com/social-messaging/latest/APIReference/API_GetLinkedWhatsAppBusinessAccountPhoneNumber.html
	//
	// This member is required.
	Id *string

	// The PIN to use for two-step verification. To reset your PIN follow the
	// directions in [Updating PIN]in the WhatsApp Business Platform Cloud API Reference.
	//
	// [Updating PIN]: https://developers.facebook.com/docs/whatsapp/cloud-api/reference/two-step-verification/#updating-pin
	//
	// This member is required.
	TwoFactorPin *string

	// The two letter ISO region for the location of where Meta will store data.
	//
	// Asia–Pacific (APAC)
	//
	//   - Australia AU
	//
	//   - Indonesia ID
	//
	//   - India IN
	//
	//   - Japan JP
	//
	//   - Singapore SG
	//
	//   - South Korea KR
	//
	// Europe
	//
	//   - Germany DE
	//
	//   - Switzerland CH
	//
	//   - United Kingdom GB
	//
	// Latin America (LATAM)
	//
	//   - Brazil BR
	//
	// Middle East and Africa (MEA)
	//
	//   - Bahrain BH
	//
	//   - South Africa ZA
	//
	//   - United Arab Emirates AE
	//
	// North America (NORAM)
	//
	//   - Canada CA
	DataLocalizationRegion *string

	// An array of key and value pair tags.
	Tags []Tag

	noSmithyDocumentSerde
}

// The registration details for a linked WhatsApp Business Account.
type WabaSetupFinalization struct {

	// The event destinations for the linked WhatsApp Business Account.
	EventDestinations []WhatsAppBusinessAccountEventDestination

	// The ID of the linked WhatsApp Business Account, formatted as
	// waba-01234567890123456789012345678901 .
	Id *string

	// An array of key and value pair tags.
	Tags []Tag

	noSmithyDocumentSerde
}

// Contains information on the event destination.
type WhatsAppBusinessAccountEventDestination struct {

	// The ARN of the event destination.
	//
	// This member is required.
	EventDestinationArn *string

	// The Amazon Resource Name (ARN) of an Identity and Access Management role that
	// is able to import phone numbers and write events.
	RoleArn *string

	noSmithyDocumentSerde
}

// The details of your WhatsApp phone number.
type WhatsAppPhoneNumberDetail struct {

	// The ARN of the WhatsApp phone number.
	//
	// This member is required.
	Arn *string

	// The phone number that appears in the recipients display.
	//
	// This member is required.
	DisplayPhoneNumber *string

	// The display name for this phone number.
	//
	// This member is required.
	DisplayPhoneNumberName *string

	// The phone number ID from Meta.
	//
	// This member is required.
	MetaPhoneNumberId *string

	// The phone number for sending WhatsApp.
	//
	// This member is required.
	PhoneNumber *string

	// The phone number ID. Phone number identifiers are formatted as
	// phone-number-id-01234567890123456789012345678901 .
	//
	// This member is required.
	PhoneNumberId *string

	// The quality rating of the phone number.
	//
	// This member is required.
	QualityRating *string

	noSmithyDocumentSerde
}

// The details of a linked phone number.
type WhatsAppPhoneNumberSummary struct {

	// The full Amazon Resource Name (ARN) for the phone number.
	//
	// This member is required.
	Arn *string

	// The phone number that appears in the recipients display.
	//
	// This member is required.
	DisplayPhoneNumber *string

	// The display name for this phone number.
	//
	// This member is required.
	DisplayPhoneNumberName *string

	// The phone number ID from Meta.
	//
	// This member is required.
	MetaPhoneNumberId *string

	// The phone number associated with the Linked WhatsApp Business Account.
	//
	// This member is required.
	PhoneNumber *string

	// The phone number ID. Phone number identifiers are formatted as
	// phone-number-id-01234567890123456789012345678901 .
	//
	// This member is required.
	PhoneNumberId *string

	// The quality rating of the phone number. This is from Meta.
	//
	// This member is required.
	QualityRating *string

	noSmithyDocumentSerde
}

// The details of linking a WhatsApp Business Account to your Amazon Web Services
// account.
type WhatsAppSetupFinalization struct {

	// An Amazon Web Services access token generated by WhatsAppSignupCallback and
	// used by WhatsAppSetupFinalization .
	//
	// This member is required.
	AssociateInProgressToken *string

	// An array of WabaPhoneNumberSetupFinalization objects containing the details of
	// each phone number associated with the WhatsApp Business Account.
	//
	// This member is required.
	PhoneNumbers []WabaPhoneNumberSetupFinalization

	// Used to add a new phone number to an existing WhatsApp Business Account. This
	// field can't be used when the waba field is present.
	PhoneNumberParent *string

	// Used to create a new WhatsApp Business Account and add a phone number. This
	// field can't be used when the phoneNumberParent field is present.
	Waba *WabaSetupFinalization

	noSmithyDocumentSerde
}

// Contains the accessToken provided by Meta during signup.
type WhatsAppSignupCallback struct {

	// The access token for your WhatsApp Business Account. The accessToken value is
	// provided by Meta.
	//
	// This member is required.
	AccessToken *string

	noSmithyDocumentSerde
}

// Contains the results of WhatsAppSignupCallback.
type WhatsAppSignupCallbackResult struct {

	// An Amazon Web Services access token generated by WhatsAppSignupCallback and
	// used by WhatsAppSetupFinalization .
	AssociateInProgressToken *string

	// A LinkedWhatsAppBusinessAccountIdMetaData object map containing the details of
	// any WhatsAppBusiness accounts that have incomplete setup.
	LinkedAccountsWithIncompleteSetup map[string]LinkedWhatsAppBusinessAccountIdMetaData

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
