// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A complex type that contains information about the Amazon Route 53 DNS records
// that you want Cloud Map to create when you register an instance.
type DnsConfig struct {

	// An array that contains one DnsRecord object for each Route 53 DNS record that
	// you want Cloud Map to create when you register an instance.
	//
	// The record type of a service specified in a DnsRecord object can't be updated.
	// To change a record type, you need to delete the service and recreate it with a
	// new DnsConfig .
	//
	// This member is required.
	DnsRecords []DnsRecord

	//  Use NamespaceId in [Service] instead.
	//
	// The ID of the namespace to use for DNS configuration.
	//
	// [Service]: https://docs.aws.amazon.com/cloud-map/latest/api/API_Service.html
	//
	// Deprecated: Top level attribute in request should be used to reference
	// namespace-id
	NamespaceId *string

	// The routing policy that you want to apply to all Route 53 DNS records that
	// Cloud Map creates when you register an instance and specify this service.
	//
	// If you want to use this service to register instances that create alias
	// records, specify WEIGHTED for the routing policy.
	//
	// You can specify the following values:
	//
	// MULTIVALUE If you define a health check for the service and the health check is
	// healthy, Route 53 returns the applicable value for up to eight instances.
	//
	// For example, suppose that the service includes configurations for one A record
	// and a health check. You use the service to register 10 instances. Route 53
	// responds to DNS queries with IP addresses for up to eight healthy instances. If
	// fewer than eight instances are healthy, Route 53 responds to every DNS query
	// with the IP addresses for all of the healthy instances.
	//
	// If you don't define a health check for the service, Route 53 assumes that all
	// instances are healthy and returns the values for up to eight instances.
	//
	// For more information about the multivalue routing policy, see [Multivalue Answer Routing] in the Route 53
	// Developer Guide.
	//
	// WEIGHTED Route 53 returns the applicable value from one randomly selected
	// instance from among the instances that you registered using the same service.
	// Currently, all records have the same weight, so you can't route more or less
	// traffic to any instances.
	//
	// For example, suppose that the service includes configurations for one A record
	// and a health check. You use the service to register 10 instances. Route 53
	// responds to DNS queries with the IP address for one randomly selected instance
	// from among the healthy instances. If no instances are healthy, Route 53 responds
	// to DNS queries as if all of the instances were healthy.
	//
	// If you don't define a health check for the service, Route 53 assumes that all
	// instances are healthy and returns the applicable value for one randomly selected
	// instance.
	//
	// For more information about the weighted routing policy, see [Weighted Routing] in the Route 53
	// Developer Guide.
	//
	// [Weighted Routing]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted
	// [Multivalue Answer Routing]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-multivalue
	RoutingPolicy RoutingPolicy

	noSmithyDocumentSerde
}

// A complex type that contains information about changes to the Route 53 DNS
// records that Cloud Map creates when you register an instance.
type DnsConfigChange struct {

	// An array that contains one DnsRecord object for each Route 53 record that you
	// want Cloud Map to create when you register an instance.
	//
	// This member is required.
	DnsRecords []DnsRecord

	noSmithyDocumentSerde
}

// A complex type that contains the ID for the Route 53 hosted zone that Cloud Map
// creates when you create a namespace.
type DnsProperties struct {

	// The ID for the Route 53 hosted zone that Cloud Map creates when you create a
	// namespace.
	HostedZoneId *string

	// Start of Authority (SOA) record for the hosted zone.
	SOA *SOA

	noSmithyDocumentSerde
}

// A complex type that contains information about the Route 53 DNS records that
// you want Cloud Map to create when you register an instance.
type DnsRecord struct {

	// The amount of time, in seconds, that you want DNS resolvers to cache the
	// settings for this record.
	//
	// Alias records don't include a TTL because Route 53 uses the TTL for the Amazon
	// Web Services resource that an alias record routes traffic to. If you include the
	// AWS_ALIAS_DNS_NAME attribute when you submit a [RegisterInstance] request, the TTL value is
	// ignored. Always specify a TTL for the service; you can use a service to register
	// instances that create either alias or non-alias records.
	//
	// [RegisterInstance]: https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html
	//
	// This member is required.
	TTL *int64

	// The type of the resource, which indicates the type of value that Route 53
	// returns in response to DNS queries. You can specify values for Type in the
	// following combinations:
	//
	//   - A
	//
	//   - AAAA
	//
	//   - A and AAAA
	//
	//   - SRV
	//
	//   - CNAME
	//
	// If you want Cloud Map to create a Route 53 alias record when you register an
	// instance, specify A or AAAA for Type .
	//
	// You specify other settings, such as the IP address for A and AAAA records, when
	// you register an instance. For more information, see [RegisterInstance].
	//
	// The following values are supported:
	//
	// A Route 53 returns the IP address of the resource in IPv4 format, such as
	// 192.0.2.44.
	//
	// AAAA Route 53 returns the IP address of the resource in IPv6 format, such as
	// 2001:0db8:85a3:0000:0000:abcd:0001:2345.
	//
	// CNAME Route 53 returns the domain name of the resource, such as
	// www.example.com. Note the following:
	//
	//   - You specify the domain name that you want to route traffic to when you
	//   register an instance. For more information, see [Attributes]in the topic [RegisterInstance].
	//
	//   - You must specify WEIGHTED for the value of RoutingPolicy .
	//
	//   - You can't specify both CNAME for Type and settings for HealthCheckConfig .
	//   If you do, the request will fail with an InvalidInput error.
	//
	// SRV Route 53 returns the value for an SRV record. The value for an SRV record
	// uses the following values:
	//
	//     priority weight port service-hostname
	//
	// Note the following about the values:
	//
	//   - The values of priority and weight are both set to 1 and can't be changed.
	//
	//   - The value of port comes from the value that you specify for the
	//   AWS_INSTANCE_PORT attribute when you submit a [RegisterInstance]request.
	//
	//   - The value of service-hostname is a concatenation of the following values:
	//
	//   - The value that you specify for InstanceId when you register an instance.
	//
	//   - The name of the service.
	//
	//   - The name of the namespace.
	//
	// For example, if the value of InstanceId is test , the name of the service is
	//   backend , and the name of the namespace is example.com , the value of
	//   service-hostname is the following:
	//
	// test.backend.example.com
	//
	// If you specify settings for an SRV record, note the following:
	//
	//   - If you specify values for AWS_INSTANCE_IPV4 , AWS_INSTANCE_IPV6 , or both in
	//   the RegisterInstance request, Cloud Map automatically creates A and/or AAAA
	//   records that have the same name as the value of service-hostname in the SRV
	//   record. You can ignore these records.
	//
	//   - If you're using a system that requires a specific SRV format, such as
	//   HAProxy, see the [Name]element in the documentation about CreateService for
	//   information about how to specify the correct name format.
	//
	// [Attributes]: https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#cloudmap-RegisterInstance-request-Attributes
	// [RegisterInstance]: https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html
	// [Name]: https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html#cloudmap-CreateService-request-Name
	//
	// This member is required.
	Type RecordType

	noSmithyDocumentSerde
}

//	Public DNS and HTTP namespaces only. A complex type that contains settings for
//
// an optional health check. If you specify settings for a health check, Cloud Map
// associates the health check with the records that you specify in DnsConfig .
//
// If you specify a health check configuration, you can specify either
// HealthCheckCustomConfig or HealthCheckConfig but not both.
//
// Health checks are basic Route 53 health checks that monitor an Amazon Web
// Services endpoint. For information about pricing for health checks, see [Amazon Route 53 Pricing].
//
// Note the following about configuring health checks.
//
// A and AAAA records If DnsConfig includes configurations for both A and AAAA
// records, Cloud Map creates a health check that uses the IPv4 address to check
// the health of the resource. If the endpoint tthat's specified by the IPv4
// address is unhealthy, Route 53 considers both the A and AAAA records to be
// unhealthy.
//
// CNAME records You can't specify settings for HealthCheckConfig when the
// DNSConfig includes CNAME for the value of Type . If you do, the CreateService
// request will fail with an InvalidInput error.
//
// Request interval A Route 53 health checker in each health-checking Amazon Web
// Services Region sends a health check request to an endpoint every 30 seconds. On
// average, your endpoint receives a health check request about every two seconds.
// However, health checkers don't coordinate with one another. Therefore, you might
// sometimes see several requests in one second that's followed by a few seconds
// with no health checks at all.
//
// Health checking regions Health checkers perform checks from all Route 53
// health-checking Regions. For a list of the current Regions, see [Regions].
//
// Alias records When you register an instance, if you include the
// AWS_ALIAS_DNS_NAME attribute, Cloud Map creates a Route 53 alias record. Note
// the following:
//
//   - Route 53 automatically sets EvaluateTargetHealth to true for alias records.
//     When EvaluateTargetHealth is true, the alias record inherits the health of the
//     referenced Amazon Web Services resource. such as an ELB load balancer. For more
//     information, see [EvaluateTargetHealth].
//
//   - If you include HealthCheckConfig and then use the service to register an
//     instance that creates an alias record, Route 53 doesn't create the health check.
//
// Charges for health checks Health checks are basic Route 53 health checks that
// monitor an Amazon Web Services endpoint. For information about pricing for
// health checks, see [Amazon Route 53 Pricing].
//
// [Regions]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions
// [Amazon Route 53 Pricing]: http://aws.amazon.com/route53/pricing/
// [EvaluateTargetHealth]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-EvaluateTargetHealth
type HealthCheckConfig struct {

	// The type of health check that you want to create, which indicates how Route 53
	// determines whether an endpoint is healthy.
	//
	// You can't change the value of Type after you create a health check.
	//
	// You can create the following types of health checks:
	//
	//   - HTTP: Route 53 tries to establish a TCP connection. If successful, Route 53
	//   submits an HTTP request and waits for an HTTP status code of 200 or greater and
	//   less than 400.
	//
	//   - HTTPS: Route 53 tries to establish a TCP connection. If successful, Route
	//   53 submits an HTTPS request and waits for an HTTP status code of 200 or greater
	//   and less than 400.
	//
	// If you specify HTTPS for the value of Type , the endpoint must support TLS v1.0
	//   or later.
	//
	//   - TCP: Route 53 tries to establish a TCP connection.
	//
	// If you specify TCP for Type , don't specify a value for ResourcePath .
	//
	// For more information, see [How Route 53 Determines Whether an Endpoint Is Healthy] in the Route 53 Developer Guide.
	//
	// [How Route 53 Determines Whether an Endpoint Is Healthy]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html
	//
	// This member is required.
	Type HealthCheckType

	// The number of consecutive health checks that an endpoint must pass or fail for
	// Route 53 to change the current status of the endpoint from unhealthy to healthy
	// or the other way around. For more information, see [How Route 53 Determines Whether an Endpoint Is Healthy]in the Route 53 Developer
	// Guide.
	//
	// [How Route 53 Determines Whether an Endpoint Is Healthy]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html
	FailureThreshold *int32

	// The path that you want Route 53 to request when performing health checks. The
	// path can be any value that your endpoint returns an HTTP status code of a 2xx or
	// 3xx format for when the endpoint is healthy. An example file is
	// /docs/route53-health-check.html . Route 53 automatically adds the DNS name for
	// the service. If you don't specify a value for ResourcePath , the default value
	// is / .
	//
	// If you specify TCP for Type , you must not specify a value for ResourcePath .
	ResourcePath *string

	noSmithyDocumentSerde
}

// A complex type that contains information about an optional custom health check.
// A custom health check, which requires that you use a third-party health checker
// to evaluate the health of your resources, is useful in the following
// circumstances:
//
//   - You can't use a health check that's defined by HealthCheckConfig because the
//     resource isn't available over the internet. For example, you can use a custom
//     health check when the instance is in an Amazon VPC. (To check the health of
//     resources in a VPC, the health checker must also be in the VPC.)
//
//   - You want to use a third-party health checker regardless of where your
//     resources are located.
//
// If you specify a health check configuration, you can specify either
// HealthCheckCustomConfig or HealthCheckConfig but not both.
//
// To change the status of a custom health check, submit an
// UpdateInstanceCustomHealthStatus request. Cloud Map doesn't monitor the status
// of the resource, it just keeps a record of the status specified in the most
// recent UpdateInstanceCustomHealthStatus request.
//
// Here's how custom health checks work:
//
//   - You create a service.
//
//   - You register an instance.
//
//   - You configure a third-party health checker to monitor the resource that's
//     associated with the new instance.
//
// Cloud Map doesn't check the health of the resource directly.
//
//   - The third-party health-checker determines that the resource is unhealthy
//     and notifies your application.
//
//   - Your application submits an UpdateInstanceCustomHealthStatus request.
//
//   - Cloud Map waits for 30 seconds.
//
//   - If another UpdateInstanceCustomHealthStatus request doesn't arrive during
//     that time to change the status back to healthy, Cloud Map stops routing traffic
//     to the resource.
type HealthCheckCustomConfig struct {

	// This parameter is no longer supported and is always set to 1. Cloud Map waits
	// for approximately 30 seconds after receiving an UpdateInstanceCustomHealthStatus
	// request before changing the status of the service instance.
	//
	// The number of 30-second intervals that you want Cloud Map to wait after
	// receiving an UpdateInstanceCustomHealthStatus request before it changes the
	// health status of a service instance.
	//
	// Sending a second or subsequent UpdateInstanceCustomHealthStatus request with
	// the same value before 30 seconds has passed doesn't accelerate the change. Cloud
	// Map still waits 30 seconds after the first request to make the change.
	//
	// Deprecated: Configurable FailureThreshold of HealthCheckCustomConfig is
	// deprecated. It will always have value 1.
	FailureThreshold *int32

	noSmithyDocumentSerde
}

// In a response to a [DiscoverInstances] request, HttpInstanceSummary contains information about one
// instance that matches the values that you specified in the request.
//
// [DiscoverInstances]: https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html
type HttpInstanceSummary struct {

	// If you included any attributes when you registered the instance, the values of
	// those attributes.
	Attributes map[string]string

	// If you configured health checking in the service, the current health status of
	// the service instance.
	HealthStatus HealthStatus

	// The ID of an instance that matches the values that you specified in the request.
	InstanceId *string

	// The HttpName name of the namespace. It's found in the HttpProperties member of
	// the Properties member of the namespace.
	NamespaceName *string

	// The name of the service that you specified when you registered the instance.
	ServiceName *string

	noSmithyDocumentSerde
}

// Updated properties for the HTTP namespace.
type HttpNamespaceChange struct {

	// An updated description for the HTTP namespace.
	//
	// This member is required.
	Description *string

	noSmithyDocumentSerde
}

// A complex type that contains the name of an HTTP namespace.
type HttpProperties struct {

	// The name of an HTTP namespace.
	HttpName *string

	noSmithyDocumentSerde
}

// A complex type that contains information about an instance that Cloud Map
// creates when you submit a RegisterInstance request.
type Instance struct {

	// An identifier that you want to associate with the instance. Note the following:
	//
	//   - If the service that's specified by ServiceId includes settings for an SRV
	//   record, the value of InstanceId is automatically included as part of the value
	//   for the SRV record. For more information, see [DnsRecord > Type].
	//
	//   - You can use this value to update an existing instance.
	//
	//   - To register a new instance, you must specify a value that's unique among
	//   instances that you register by using the same service.
	//
	//   - If you specify an existing InstanceId and ServiceId , Cloud Map updates the
	//   existing DNS records. If there's also an existing health check, Cloud Map
	//   deletes the old health check and creates a new one.
	//
	// The health check isn't deleted immediately, so it will still appear for a while
	//   if you submit a ListHealthChecks request, for example.
	//
	// [DnsRecord > Type]: https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type
	//
	// This member is required.
	Id *string

	// A string map that contains the following information for the service that you
	// specify in ServiceId :
	//
	//   - The attributes that apply to the records that are defined in the service.
	//
	//   - For each attribute, the applicable value.
	//
	// Do not include sensitive information in the attributes if the namespace is
	// discoverable by public DNS queries.
	//
	// Supported attribute keys include the following:
	//
	// AWS_ALIAS_DNS_NAME If you want Cloud Map to create a Route 53 alias record that
	// routes traffic to an Elastic Load Balancing load balancer, specify the DNS name
	// that's associated with the load balancer. For information about how to get the
	// DNS name, see [AliasTarget->DNSName]in the Route 53 API Reference.
	//
	// Note the following:
	//
	//   - The configuration for the service that's specified by ServiceId must include
	//   settings for an A record, an AAAA record, or both.
	//
	//   - In the service that's specified by ServiceId , the value of RoutingPolicy
	//   must be WEIGHTED .
	//
	//   - If the service that's specified by ServiceId includes HealthCheckConfig
	//   settings, Cloud Map creates the health check, but it won't associate the health
	//   check with the alias record.
	//
	//   - Auto naming currently doesn't support creating alias records that route
	//   traffic to Amazon Web Services resources other than ELB load balancers.
	//
	//   - If you specify a value for AWS_ALIAS_DNS_NAME , don't specify values for any
	//   of the AWS_INSTANCE attributes.
	//
	// AWS_EC2_INSTANCE_ID  HTTP namespaces only. The Amazon EC2 instance ID for the
	// instance. The AWS_INSTANCE_IPV4 attribute contains the primary private IPv4
	// address.
	//
	// AWS_INIT_HEALTH_STATUS If the service configuration includes
	// HealthCheckCustomConfig , you can optionally use AWS_INIT_HEALTH_STATUS to
	// specify the initial status of the custom health check, HEALTHY or UNHEALTHY . If
	// you don't specify a value for AWS_INIT_HEALTH_STATUS , the initial status is
	// HEALTHY .
	//
	// AWS_INSTANCE_CNAME If the service configuration includes a CNAME record, the
	// domain name that you want Route 53 to return in response to DNS queries (for
	// example, example.com ).
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an CNAME record.
	//
	// AWS_INSTANCE_IPV4 If the service configuration includes an A record, the IPv4
	// address that you want Route 53 to return in response to DNS queries (for
	// example, 192.0.2.44 ).
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an A record. If the service includes settings for an SRV record, you must
	// specify a value for AWS_INSTANCE_IPV4 , AWS_INSTANCE_IPV6 , or both.
	//
	// AWS_INSTANCE_IPV6 If the service configuration includes an AAAA record, the
	// IPv6 address that you want Route 53 to return in response to DNS queries (for
	// example, 2001:0db8:85a3:0000:0000:abcd:0001:2345 ).
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an AAAA record. If the service includes settings for an SRV record, you
	// must specify a value for AWS_INSTANCE_IPV4 , AWS_INSTANCE_IPV6 , or both.
	//
	// AWS_INSTANCE_PORT If the service includes an SRV record, the value that you
	// want Route 53 to return for the port.
	//
	// If the service includes HealthCheckConfig , the port on the endpoint that you
	// want Route 53 to send requests to.
	//
	// This value is required if you specified settings for an SRV record or a Route
	// 53 health check when you created the service.
	//
	// [AliasTarget->DNSName]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-DNSName
	Attributes map[string]string

	// A unique string that identifies the request and that allows failed
	// RegisterInstance requests to be retried without the risk of executing the
	// operation twice. You must use a unique CreatorRequestId string every time you
	// submit a RegisterInstance request if you're registering additional instances
	// for the same namespace and service. CreatorRequestId can be any unique string
	// (for example, a date/time stamp).
	CreatorRequestId *string

	noSmithyDocumentSerde
}

// A complex type that contains information about the instances that you
// registered by using a specified service.
type InstanceSummary struct {

	// A string map that contains the following information:
	//
	//   - The attributes that are associated with the instance.
	//
	//   - For each attribute, the applicable value.
	//
	// Supported attribute keys include the following:
	//
	// AWS_ALIAS_DNS_NAME For an alias record that routes traffic to an Elastic Load
	// Balancing load balancer, the DNS name that's associated with the load balancer.
	//
	// AWS_EC2_INSTANCE_ID (HTTP namespaces only) The Amazon EC2 instance ID for the
	// instance. When the AWS_EC2_INSTANCE_ID attribute is specified, then the
	// AWS_INSTANCE_IPV4 attribute contains the primary private IPv4 address.
	//
	// AWS_INIT_HEALTH_STATUS If the service configuration includes
	// HealthCheckCustomConfig , you can optionally use AWS_INIT_HEALTH_STATUS to
	// specify the initial status of the custom health check, HEALTHY or UNHEALTHY . If
	// you don't specify a value for AWS_INIT_HEALTH_STATUS , the initial status is
	// HEALTHY .
	//
	// AWS_INSTANCE_CNAME For a CNAME record, the domain name that Route 53 returns in
	// response to DNS queries (for example, example.com ).
	//
	// AWS_INSTANCE_IPV4 For an A record, the IPv4 address that Route 53 returns in
	// response to DNS queries (for example, 192.0.2.44 ).
	//
	// AWS_INSTANCE_IPV6 For an AAAA record, the IPv6 address that Route 53 returns in
	// response to DNS queries (for example, 2001:0db8:85a3:0000:0000:abcd:0001:2345 ).
	//
	// AWS_INSTANCE_PORT For an SRV record, the value that Route 53 returns for the
	// port. In addition, if the service includes HealthCheckConfig , the port on the
	// endpoint that Route 53 sends requests to.
	Attributes map[string]string

	// The ID for an instance that you created by using a specified service.
	Id *string

	noSmithyDocumentSerde
}

// A complex type that contains information about a specified namespace.
type Namespace struct {

	// The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you
	// create it.
	Arn *string

	// The date that the namespace was created, in Unix date/time format and
	// Coordinated Universal Time (UTC). The value of CreateDate is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CreateDate *time.Time

	// A unique string that identifies the request and that allows failed requests to
	// be retried without the risk of running an operation twice.
	CreatorRequestId *string

	// The description that you specify for the namespace when you create it.
	Description *string

	// The ID of a namespace.
	Id *string

	// The name of the namespace, such as example.com .
	Name *string

	// A complex type that contains information that's specific to the type of the
	// namespace.
	Properties *NamespaceProperties

	// The number of services that are associated with the namespace.
	ServiceCount *int32

	// The type of the namespace. The methods for discovering instances depends on the
	// value that you specify:
	//
	// HTTP Instances can be discovered only programmatically, using the Cloud Map
	// DiscoverInstances API.
	//
	// DNS_PUBLIC Instances can be discovered using public DNS queries and using the
	// DiscoverInstances API.
	//
	// DNS_PRIVATE Instances can be discovered using DNS queries in VPCs and using the
	// DiscoverInstances API.
	Type NamespaceType

	noSmithyDocumentSerde
}

// A complex type that identifies the namespaces that you want to list. You can
// choose to list public or private namespaces.
type NamespaceFilter struct {

	// Specify the namespaces that you want to get using one of the following.
	//
	//   - TYPE : Gets the namespaces of the specified type.
	//
	//   - NAME : Gets the namespaces with the specified name.
	//
	//   - HTTP_NAME : Gets the namespaces with the specified HTTP name.
	//
	// This member is required.
	Name NamespaceFilterName

	// Specify the values that are applicable to the value that you specify for Name .
	//
	//   - TYPE : Specify HTTP , DNS_PUBLIC , or DNS_PRIVATE .
	//
	//   - NAME : Specify the name of the namespace, which is found in Namespace.Name .
	//
	//   - HTTP_NAME : Specify the HTTP name of the namespace, which is found in
	//   Namespace.Properties.HttpProperties.HttpName .
	//
	// This member is required.
	Values []string

	// Specify the operator that you want to use to determine whether a namespace
	// matches the specified value. Valid values for Condition are one of the
	// following.
	//
	//   - EQ : When you specify EQ for Condition , you can specify only one value. EQ
	//   is supported for TYPE , NAME , and HTTP_NAME . EQ is the default condition and
	//   can be omitted.
	//
	//   - BEGINS_WITH : When you specify BEGINS_WITH for Condition , you can specify
	//   only one value. BEGINS_WITH is supported for TYPE , NAME , and HTTP_NAME .
	Condition FilterCondition

	noSmithyDocumentSerde
}

// A complex type that contains information that's specific to the namespace type.
type NamespaceProperties struct {

	// A complex type that contains the ID for the Route 53 hosted zone that Cloud Map
	// creates when you create a namespace.
	DnsProperties *DnsProperties

	// A complex type that contains the name of an HTTP namespace.
	HttpProperties *HttpProperties

	noSmithyDocumentSerde
}

// A complex type that contains information about a namespace.
type NamespaceSummary struct {

	// The Amazon Resource Name (ARN) that Cloud Map assigns to the namespace when you
	// create it.
	Arn *string

	// The date and time that the namespace was created.
	CreateDate *time.Time

	// A description for the namespace.
	Description *string

	// The ID of the namespace.
	Id *string

	// The name of the namespace. When you create a namespace, Cloud Map automatically
	// creates a Route 53 hosted zone that has the same name as the namespace.
	Name *string

	// The properties of the namespace.
	Properties *NamespaceProperties

	// The number of services that were created using the namespace.
	ServiceCount *int32

	// The type of the namespace, either public or private.
	Type NamespaceType

	noSmithyDocumentSerde
}

// A complex type that contains information about a specified operation.
type Operation struct {

	// The date and time that the request was submitted, in Unix date/time format and
	// Coordinated Universal Time (UTC). The value of CreateDate is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CreateDate *time.Time

	// The code associated with ErrorMessage . Values for ErrorCode include the
	// following:
	//
	//   - ACCESS_DENIED
	//
	//   - CANNOT_CREATE_HOSTED_ZONE
	//
	//   - EXPIRED_TOKEN
	//
	//   - HOSTED_ZONE_NOT_FOUND
	//
	//   - INTERNAL_FAILURE
	//
	//   - INVALID_CHANGE_BATCH
	//
	//   - THROTTLED_REQUEST
	ErrorCode *string

	// If the value of Status is FAIL , the reason that the operation failed.
	ErrorMessage *string

	// The ID of the operation that you want to get information about.
	Id *string

	// The status of the operation. Values include the following:
	//
	// SUBMITTED This is the initial state that occurs immediately after you submit a
	// request.
	//
	// PENDING Cloud Map is performing the operation.
	//
	// SUCCESS The operation succeeded.
	//
	// FAIL The operation failed. For the failure reason, see ErrorMessage .
	Status OperationStatus

	// The name of the target entity that's associated with the operation:
	//
	// NAMESPACE The namespace ID is returned in the ResourceId property.
	//
	// SERVICE The service ID is returned in the ResourceId property.
	//
	// INSTANCE The instance ID is returned in the ResourceId property.
	Targets map[string]string

	// The name of the operation that's associated with the specified ID.
	Type OperationType

	// The date and time that the value of Status changed to the current value, in
	// Unix date/time format and Coordinated Universal Time (UTC). The value of
	// UpdateDate is accurate to milliseconds. For example, the value 1516925490.087
	// represents Friday, January 26, 2018 12:11:30.087 AM.
	UpdateDate *time.Time

	noSmithyDocumentSerde
}

// A complex type that lets you select the operations that you want to list.
type OperationFilter struct {

	// Specify the operations that you want to get:
	//
	//   - NAMESPACE_ID: Gets operations related to specified namespaces.
	//
	//   - SERVICE_ID: Gets operations related to specified services.
	//
	//   - STATUS: Gets operations based on the status of the operations: SUBMITTED ,
	//   PENDING , SUCCEED , or FAIL .
	//
	//   - TYPE: Gets specified types of operation.
	//
	//   - UPDATE_DATE: Gets operations that changed status during a specified
	//   date/time range.
	//
	// This member is required.
	Name OperationFilterName

	// Specify values that are applicable to the value that you specify for Name :
	//
	//   - NAMESPACE_ID: Specify one namespace ID.
	//
	//   - SERVICE_ID: Specify one service ID.
	//
	//   - STATUS: Specify one or more statuses: SUBMITTED , PENDING , SUCCEED , or
	//   FAIL .
	//
	//   - TYPE: Specify one or more of the following types: CREATE_NAMESPACE ,
	//   DELETE_NAMESPACE , UPDATE_SERVICE , REGISTER_INSTANCE , or DEREGISTER_INSTANCE
	//   .
	//
	//   - UPDATE_DATE: Specify a start date and an end date in Unix date/time format
	//   and Coordinated Universal Time (UTC). The start date must be the first value.
	//
	// This member is required.
	Values []string

	// The operator that you want to use to determine whether an operation matches the
	// specified value. Valid values for condition include:
	//
	//   - EQ : When you specify EQ for the condition, you can specify only one value.
	//   EQ is supported for NAMESPACE_ID , SERVICE_ID , STATUS , and TYPE . EQ is the
	//   default condition and can be omitted.
	//
	//   - IN : When you specify IN for the condition, you can specify a list of one or
	//   more values. IN is supported for STATUS and TYPE . An operation must match one
	//   of the specified values to be returned in the response.
	//
	//   - BETWEEN : Specify a start date and an end date in Unix date/time format and
	//   Coordinated Universal Time (UTC). The start date must be the first value.
	//   BETWEEN is supported for UPDATE_DATE .
	Condition FilterCondition

	noSmithyDocumentSerde
}

// A complex type that contains information about an operation that matches the
// criteria that you specified in a [ListOperations]request.
//
// [ListOperations]: https://docs.aws.amazon.com/cloud-map/latest/api/API_ListOperations.html
type OperationSummary struct {

	// The ID for an operation.
	Id *string

	// The status of the operation. Values include the following:
	//
	//   - SUBMITTED: This is the initial state immediately after you submit a request.
	//
	//   - PENDING: Cloud Map is performing the operation.
	//
	//   - SUCCESS: The operation succeeded.
	//
	//   - FAIL: The operation failed. For the failure reason, see ErrorMessage .
	Status OperationStatus

	noSmithyDocumentSerde
}

// Updated properties for the private DNS namespace.
type PrivateDnsNamespaceChange struct {

	// An updated description for the private DNS namespace.
	Description *string

	// Properties to be updated in the private DNS namespace.
	Properties *PrivateDnsNamespacePropertiesChange

	noSmithyDocumentSerde
}

// DNS properties for the private DNS namespace.
type PrivateDnsNamespaceProperties struct {

	// DNS properties for the private DNS namespace.
	//
	// This member is required.
	DnsProperties *PrivateDnsPropertiesMutable

	noSmithyDocumentSerde
}

// Updated properties for the private DNS namespace.
type PrivateDnsNamespacePropertiesChange struct {

	// Updated DNS properties for the private DNS namespace.
	//
	// This member is required.
	DnsProperties *PrivateDnsPropertiesMutableChange

	noSmithyDocumentSerde
}

// DNS properties for the private DNS namespace.
type PrivateDnsPropertiesMutable struct {

	// Fields for the Start of Authority (SOA) record for the hosted zone for the
	// private DNS namespace.
	//
	// This member is required.
	SOA *SOA

	noSmithyDocumentSerde
}

// Updated DNS properties for the private DNS namespace.
type PrivateDnsPropertiesMutableChange struct {

	// Updated fields for the Start of Authority (SOA) record for the hosted zone for
	// the private DNS namespace.
	//
	// This member is required.
	SOA *SOAChange

	noSmithyDocumentSerde
}

// Updated properties for the public DNS namespace.
type PublicDnsNamespaceChange struct {

	// An updated description for the public DNS namespace.
	Description *string

	// Properties to be updated in the public DNS namespace.
	Properties *PublicDnsNamespacePropertiesChange

	noSmithyDocumentSerde
}

// DNS properties for the public DNS namespace.
type PublicDnsNamespaceProperties struct {

	// DNS properties for the public DNS namespace.
	//
	// This member is required.
	DnsProperties *PublicDnsPropertiesMutable

	noSmithyDocumentSerde
}

// Updated properties for the public DNS namespace.
type PublicDnsNamespacePropertiesChange struct {

	// Updated DNS properties for the hosted zone for the public DNS namespace.
	//
	// This member is required.
	DnsProperties *PublicDnsPropertiesMutableChange

	noSmithyDocumentSerde
}

// DNS properties for the public DNS namespace.
type PublicDnsPropertiesMutable struct {

	// Start of Authority (SOA) record for the hosted zone for the public DNS
	// namespace.
	//
	// This member is required.
	SOA *SOA

	noSmithyDocumentSerde
}

// Updated DNS properties for the public DNS namespace.
type PublicDnsPropertiesMutableChange struct {

	// Updated fields for the Start of Authority (SOA) record for the hosted zone for
	// the public DNS namespace.
	//
	// This member is required.
	SOA *SOAChange

	noSmithyDocumentSerde
}

// A complex type that contains information about the specified service.
type Service struct {

	// The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you
	// create it.
	Arn *string

	// The date and time that the service was created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreateDate is accurate to milliseconds. For
	// example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreateDate *time.Time

	// A unique string that identifies the request and that allows failed requests to
	// be retried without the risk of running the operation twice. CreatorRequestId
	// can be any unique string (for example, a date/timestamp).
	CreatorRequestId *string

	// The description of the service.
	Description *string

	// A complex type that contains information about the Route 53 DNS records that
	// you want Cloud Map to create when you register an instance.
	//
	// The record types of a service can only be changed by deleting the service and
	// recreating it with a new Dnsconfig .
	DnsConfig *DnsConfig

	//  Public DNS and HTTP namespaces only. A complex type that contains settings for
	// an optional health check. If you specify settings for a health check, Cloud Map
	// associates the health check with the records that you specify in DnsConfig .
	//
	// For information about the charges for health checks, see [Amazon Route 53 Pricing].
	//
	// [Amazon Route 53 Pricing]: http://aws.amazon.com/route53/pricing/
	HealthCheckConfig *HealthCheckConfig

	// A complex type that contains information about an optional custom health check.
	//
	// If you specify a health check configuration, you can specify either
	// HealthCheckCustomConfig or HealthCheckConfig but not both.
	HealthCheckCustomConfig *HealthCheckCustomConfig

	// The ID that Cloud Map assigned to the service when you created it.
	Id *string

	// The number of instances that are currently associated with the service.
	// Instances that were previously associated with the service but that are deleted
	// aren't included in the count. The count might not reflect pending registrations
	// and deregistrations.
	InstanceCount *int32

	// The name of the service.
	Name *string

	// The ID of the namespace that was used to create the service.
	NamespaceId *string

	// Describes the systems that can be used to discover the service instances.
	//
	// DNS_HTTP The service instances can be discovered using either DNS queries or
	// the DiscoverInstances API operation.
	//
	// HTTP The service instances can only be discovered using the DiscoverInstances
	// API operation.
	//
	// DNS Reserved.
	Type ServiceType

	noSmithyDocumentSerde
}

// A complex type that contains information about attributes associated with a
// specific service.
type ServiceAttributes struct {

	// A string map that contains the following information for the service that you
	// specify in ServiceArn :
	//
	//   - The attributes that apply to the service.
	//
	//   - For each attribute, the applicable value.
	//
	// You can specify a total of 30 attributes.
	Attributes map[string]string

	// The ARN of the service that the attributes are associated with.
	ServiceArn *string

	noSmithyDocumentSerde
}

// A complex type that contains changes to an existing service.
type ServiceChange struct {

	// A description for the service.
	Description *string

	// Information about the Route 53 DNS records that you want Cloud Map to create
	// when you register an instance.
	DnsConfig *DnsConfigChange

	//  Public DNS and HTTP namespaces only. Settings for an optional health check. If
	// you specify settings for a health check, Cloud Map associates the health check
	// with the records that you specify in DnsConfig .
	HealthCheckConfig *HealthCheckConfig

	noSmithyDocumentSerde
}

// A complex type that lets you specify the namespaces that you want to list
// services for.
type ServiceFilter struct {

	// Specify NAMESPACE_ID .
	//
	// This member is required.
	Name ServiceFilterName

	// The values that are applicable to the value that you specify for Condition to
	// filter the list of services.
	//
	// This member is required.
	Values []string

	// The operator that you want to use to determine whether a service is returned by
	// ListServices . Valid values for Condition include the following:
	//
	//   - EQ : When you specify EQ , specify one namespace ID for Values . EQ is the
	//   default condition and can be omitted.
	Condition FilterCondition

	noSmithyDocumentSerde
}

// A complex type that contains information about a specified service.
type ServiceSummary struct {

	// The Amazon Resource Name (ARN) that Cloud Map assigns to the service when you
	// create it.
	Arn *string

	// The date and time that the service was created.
	CreateDate *time.Time

	// The description that you specify when you create the service.
	Description *string

	// Information about the Route 53 DNS records that you want Cloud Map to create
	// when you register an instance.
	DnsConfig *DnsConfig

	//  Public DNS and HTTP namespaces only. Settings for an optional health check. If
	// you specify settings for a health check, Cloud Map associates the health check
	// with the records that you specify in DnsConfig .
	HealthCheckConfig *HealthCheckConfig

	// Information about an optional custom health check. A custom health check, which
	// requires that you use a third-party health checker to evaluate the health of
	// your resources, is useful in the following circumstances:
	//
	//   - You can't use a health check that's defined by HealthCheckConfig because the
	//   resource isn't available over the internet. For example, you can use a custom
	//   health check when the instance is in an Amazon VPC. (To check the health of
	//   resources in a VPC, the health checker must also be in the VPC.)
	//
	//   - You want to use a third-party health checker regardless of where your
	//   resources are located.
	//
	// If you specify a health check configuration, you can specify either
	// HealthCheckCustomConfig or HealthCheckConfig but not both.
	HealthCheckCustomConfig *HealthCheckCustomConfig

	// The ID that Cloud Map assigned to the service when you created it.
	Id *string

	// The number of instances that are currently associated with the service.
	// Instances that were previously associated with the service but that are deleted
	// aren't included in the count. The count might not reflect pending registrations
	// and deregistrations.
	InstanceCount *int32

	// The name of the service.
	Name *string

	// Describes the systems that can be used to discover the service instances.
	//
	// DNS_HTTP The service instances can be discovered using either DNS queries or
	// the DiscoverInstances API operation.
	//
	// HTTP The service instances can only be discovered using the DiscoverInstances
	// API operation.
	//
	// DNS Reserved.
	Type ServiceType

	noSmithyDocumentSerde
}

// Start of Authority (SOA) properties for a public or private DNS namespace.
type SOA struct {

	// The time to live (TTL) for purposes of negative caching.
	//
	// This member is required.
	TTL *int64

	noSmithyDocumentSerde
}

// Updated Start of Authority (SOA) properties for a public or private DNS
// namespace.
type SOAChange struct {

	// The updated time to live (TTL) for purposes of negative caching.
	//
	// This member is required.
	TTL *int64

	noSmithyDocumentSerde
}

// A custom key-value pair that's associated with a resource.
type Tag struct {

	// The key identifier, or name, of the tag.
	//
	// This member is required.
	Key *string

	// The string value that's associated with the key of the tag. You can set the
	// value of a tag to an empty string, but you can't set the value of a tag to null.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
