// Code generated by smithy-go-codegen DO NOT EDIT.

package securityir

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityir/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Grant permission to view a designated case.
func (c *Client) GetCase(ctx context.Context, params *GetCaseInput, optFns ...func(*Options)) (*GetCaseOutput, error) {
	if params == nil {
		params = &GetCaseInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCase", params, optFns, c.addOperationGetCaseMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCaseOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCaseInput struct {

	// Required element for GetCase to identify the requested case ID.
	//
	// This member is required.
	CaseId *string

	noSmithyDocumentSerde
}

type GetCaseOutput struct {

	// Response element for GetCase that provides the actual incident start date as
	// identified by data analysis during the investigation.
	ActualIncidentStartDate *time.Time

	// Response element for GetCase that provides the case ARN
	CaseArn *string

	// Response element for GetCase that provides a list of current case attachments.
	CaseAttachments []types.CaseAttachmentAttributes

	// Response element for GetCase that provides the case status. Options for
	// statuses include Submitted | Detection and Analysis | Eradication, Containment
	// and Recovery | Post-Incident Activities | Closed
	CaseStatus types.CaseStatus

	// Response element for GetCase that provides the date a specified case was closed.
	ClosedDate *time.Time

	// Response element for GetCase that provides the summary code for why a case was
	// closed.
	ClosureCode types.ClosureCode

	// Response element for GetCase that provides the date the case was created.
	CreatedDate *time.Time

	// Response element for GetCase that provides contents of the case description.
	Description *string

	// Response element for GetCase that provides the engagement type. Options for
	// engagement type include Active Security Event | Investigations
	EngagementType types.EngagementType

	// Response element for GetCase that provides a list of impacted accounts.
	ImpactedAccounts []string

	// Response element for GetCase that provides the impacted regions.
	ImpactedAwsRegions []types.ImpactedAwsRegion

	// Response element for GetCase that provides a list of impacted services.
	ImpactedServices []string

	// Response element for GetCase that provides the date a case was last modified.
	LastUpdatedDate *time.Time

	// Response element for GetCase that provides identifies the case is waiting on
	// customer input.
	PendingAction types.PendingAction

	// Response element for GetCase that provides the customer provided incident start
	// date.
	ReportedIncidentStartDate *time.Time

	// Response element for GetCase that provides the current resolver types. Options
	// include self-supported | AWS-supported .
	ResolverType types.ResolverType

	// Response element for GetCase that provides a list of suspicious IP addresses
	// associated with unauthorized activity.
	ThreatActorIpAddresses []types.ThreatActorIp

	// Response element for GetCase that provides the case title.
	Title *string

	// Response element for GetCase that provides a list of Watchers added to the case.
	Watchers []types.Watcher

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCaseMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCase{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCase{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCase"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCaseValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCase(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCase(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCase",
	}
}
