// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates properties of an existing MLflow Tracking Server.
func (c *Client) UpdateMlflowTrackingServer(ctx context.Context, params *UpdateMlflowTrackingServerInput, optFns ...func(*Options)) (*UpdateMlflowTrackingServerOutput, error) {
	if params == nil {
		params = &UpdateMlflowTrackingServerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateMlflowTrackingServer", params, optFns, c.addOperationUpdateMlflowTrackingServerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateMlflowTrackingServerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateMlflowTrackingServerInput struct {

	// The name of the MLflow Tracking Server to update.
	//
	// This member is required.
	TrackingServerName *string

	// The new S3 URI for the general purpose bucket to use as the artifact store for
	// the MLflow Tracking Server.
	ArtifactStoreUri *string

	// Whether to enable or disable automatic registration of new MLflow models to the
	// SageMaker Model Registry. To enable automatic model registration, set this value
	// to True . To disable automatic model registration, set this value to False . If
	// not specified, AutomaticModelRegistration defaults to False
	AutomaticModelRegistration *bool

	// The new size for the MLflow Tracking Server.
	TrackingServerSize types.TrackingServerSize

	// The new weekly maintenance window start day and time to update. The maintenance
	// window day and time should be in Coordinated Universal Time (UTC) 24-hour
	// standard time. For example: TUE:03:30.
	WeeklyMaintenanceWindowStart *string

	noSmithyDocumentSerde
}

type UpdateMlflowTrackingServerOutput struct {

	// The ARN of the updated MLflow Tracking Server.
	TrackingServerArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateMlflowTrackingServerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateMlflowTrackingServer{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateMlflowTrackingServer{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateMlflowTrackingServer"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateMlflowTrackingServerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateMlflowTrackingServer(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateMlflowTrackingServer(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateMlflowTrackingServer",
	}
}
