// Code generated by smithy-go-codegen DO NOT EDIT.

package s3control

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	s3controlcust "github.com/aws/aws-sdk-go-v2/service/s3control/internal/customizations"
	"github.com/aws/aws-sdk-go-v2/service/s3control/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"strings"
)

// Use this API to list the access grants that grant the caller access to Amazon
// S3 data through S3 Access Grants. The caller (grantee) can be an Identity and
// Access Management (IAM) identity or Amazon Web Services Identity Center
// corporate directory identity. You must pass the Amazon Web Services account of
// the S3 data owner (grantor) in the request. You can, optionally, narrow the
// results by GrantScope , using a fragment of the data's S3 path, and S3 Access
// Grants will return only the grants with a path that contains the path fragment.
// You can also pass the AllowedByApplication filter in the request, which returns
// only the grants authorized for applications, whether the application is the
// caller's Identity Center application or any other application ( ALL ). For more
// information, see [List the caller's access grants]in the Amazon S3 User Guide.
//
// Permissions You must have the s3:ListCallerAccessGrants permission to use this
// operation.
//
// [List the caller's access grants]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-grants-list-grants.html
func (c *Client) ListCallerAccessGrants(ctx context.Context, params *ListCallerAccessGrantsInput, optFns ...func(*Options)) (*ListCallerAccessGrantsOutput, error) {
	if params == nil {
		params = &ListCallerAccessGrantsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCallerAccessGrants", params, optFns, c.addOperationListCallerAccessGrantsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCallerAccessGrantsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCallerAccessGrantsInput struct {

	// The Amazon Web Services account ID of the S3 Access Grants instance.
	//
	// This member is required.
	AccountId *string

	// If this optional parameter is passed in the request, a filter is applied to the
	// results. The results will include only the access grants for the caller's
	// Identity Center application or for any other applications ( ALL ).
	AllowedByApplication bool

	// The S3 path of the data that you would like to access. Must start with s3:// .
	// You can optionally pass only the beginning characters of a path, and S3 Access
	// Grants will search for all applicable grants for the path fragment.
	GrantScope *string

	// The maximum number of access grants that you would like returned in the List
	// Caller Access Grants response. If the results include the pagination token
	// NextToken , make another call using the NextToken to determine if there are
	// more results.
	MaxResults int32

	// A pagination token to request the next page of results. Pass this value into a
	// subsequent List Caller Access Grants request in order to retrieve the next page
	// of results.
	NextToken *string

	noSmithyDocumentSerde
}

func (in *ListCallerAccessGrantsInput) bindEndpointParams(p *EndpointParameters) {

	p.AccountId = in.AccountId
	p.RequiresAccountId = ptr.Bool(true)
}

type ListCallerAccessGrantsOutput struct {

	// A list of the caller's access grants that were created using S3 Access Grants
	// and that grant the caller access to the S3 data of the Amazon Web Services
	// account ID that was specified in the request.
	CallerAccessGrantsList []types.ListCallerAccessGrantsEntry

	// A pagination token that you can use to request the next page of results. Pass
	// this value into a subsequent List Caller Access Grants request in order to
	// retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCallerAccessGrantsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListCallerAccessGrants{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListCallerAccessGrants{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCallerAccessGrants"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = s3controlcust.AddUpdateOutpostARN(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddContentChecksumMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opListCallerAccessGrantsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListCallerAccessGrantsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCallerAccessGrants(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addMetadataRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addListCallerAccessGrantsUpdateEndpoint(stack, options); err != nil {
		return err
	}
	if err = addStashOperationInput(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = v4.AddContentSHA256HeaderMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = s3controlcust.AddDisableHostPrefixMiddleware(stack); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListCallerAccessGrantsPaginatorOptions is the paginator options for
// ListCallerAccessGrants
type ListCallerAccessGrantsPaginatorOptions struct {
	// The maximum number of access grants that you would like returned in the List
	// Caller Access Grants response. If the results include the pagination token
	// NextToken , make another call using the NextToken to determine if there are
	// more results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCallerAccessGrantsPaginator is a paginator for ListCallerAccessGrants
type ListCallerAccessGrantsPaginator struct {
	options   ListCallerAccessGrantsPaginatorOptions
	client    ListCallerAccessGrantsAPIClient
	params    *ListCallerAccessGrantsInput
	nextToken *string
	firstPage bool
}

// NewListCallerAccessGrantsPaginator returns a new ListCallerAccessGrantsPaginator
func NewListCallerAccessGrantsPaginator(client ListCallerAccessGrantsAPIClient, params *ListCallerAccessGrantsInput, optFns ...func(*ListCallerAccessGrantsPaginatorOptions)) *ListCallerAccessGrantsPaginator {
	if params == nil {
		params = &ListCallerAccessGrantsInput{}
	}

	options := ListCallerAccessGrantsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCallerAccessGrantsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCallerAccessGrantsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCallerAccessGrants page.
func (p *ListCallerAccessGrantsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCallerAccessGrantsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCallerAccessGrants(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

type endpointPrefix_opListCallerAccessGrantsMiddleware struct {
}

func (*endpointPrefix_opListCallerAccessGrantsMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opListCallerAccessGrantsMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	opaqueInput := getOperationInput(ctx)
	input, ok := opaqueInput.(*ListCallerAccessGrantsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input type %T", opaqueInput)
	}

	var prefix strings.Builder
	if input.AccountId == nil {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so may not be nil")}
	} else if !smithyhttp.ValidHostLabel(*input.AccountId) {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so must match \"[a-zA-Z0-9-]{1,63}\", but was \"%s\"", *input.AccountId)}
	} else {
		prefix.WriteString(*input.AccountId)
	}
	prefix.WriteString(".")
	req.URL.Host = prefix.String() + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opListCallerAccessGrantsMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opListCallerAccessGrantsMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// ListCallerAccessGrantsAPIClient is a client that implements the
// ListCallerAccessGrants operation.
type ListCallerAccessGrantsAPIClient interface {
	ListCallerAccessGrants(context.Context, *ListCallerAccessGrantsInput, ...func(*Options)) (*ListCallerAccessGrantsOutput, error)
}

var _ ListCallerAccessGrantsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCallerAccessGrants(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCallerAccessGrants",
	}
}

func copyListCallerAccessGrantsInputForUpdateEndpoint(params interface{}) (interface{}, error) {
	input, ok := params.(*ListCallerAccessGrantsInput)
	if !ok {
		return nil, fmt.Errorf("expect *ListCallerAccessGrantsInput type, got %T", params)
	}
	cpy := *input
	return &cpy, nil
}
func (in *ListCallerAccessGrantsInput) copy() interface{} {
	v := *in
	return &v
}
func backFillListCallerAccessGrantsAccountID(input interface{}, v string) error {
	in := input.(*ListCallerAccessGrantsInput)
	if in.AccountId != nil {
		if !strings.EqualFold(*in.AccountId, v) {
			return fmt.Errorf("error backfilling account id")
		}
		return nil
	}
	in.AccountId = &v
	return nil
}
func addListCallerAccessGrantsUpdateEndpoint(stack *middleware.Stack, options Options) error {
	return s3controlcust.UpdateEndpoint(stack, s3controlcust.UpdateEndpointOptions{
		Accessor: s3controlcust.UpdateEndpointParameterAccessor{GetARNInput: nopGetARNAccessor,
			BackfillAccountID: nopBackfillAccountIDAccessor,
			GetOutpostIDInput: nopGetOutpostIDFromInput,
			UpdateARNField:    nopSetARNAccessor,
			CopyInput:         copyListCallerAccessGrantsInputForUpdateEndpoint,
		},
		EndpointResolver:        options.EndpointResolver,
		EndpointResolverOptions: options.EndpointOptions,
		UseARNRegion:            options.UseARNRegion,
	})
}
