// Code generated by smithy-go-codegen DO NOT EDIT.

package qconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List AI Agent versions.
func (c *Client) ListAIAgentVersions(ctx context.Context, params *ListAIAgentVersionsInput, optFns ...func(*Options)) (*ListAIAgentVersionsOutput, error) {
	if params == nil {
		params = &ListAIAgentVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAIAgentVersions", params, optFns, c.addOperationListAIAgentVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAIAgentVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAIAgentVersionsInput struct {

	// The identifier of the Amazon Q in Connect AI Agent for which versions are to be
	// listed.
	//
	// This member is required.
	AiAgentId *string

	// The identifier of the Amazon Q in Connect assistant. Can be either the ID or
	// the ARN. URLs cannot contain the ARN.
	//
	// This member is required.
	AssistantId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	// The origin of the AI Agent versions to be listed. SYSTEM for a default AI Agent
	// created by Q in Connect or CUSTOMER for an AI Agent created by calling AI Agent
	// creation APIs.
	Origin types.Origin

	noSmithyDocumentSerde
}

type ListAIAgentVersionsOutput struct {

	// The summaries of AI Agent versions.
	//
	// This member is required.
	AiAgentVersionSummaries []types.AIAgentVersionSummary

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAIAgentVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAIAgentVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAIAgentVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAIAgentVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAIAgentVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAIAgentVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAIAgentVersionsPaginatorOptions is the paginator options for
// ListAIAgentVersions
type ListAIAgentVersionsPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAIAgentVersionsPaginator is a paginator for ListAIAgentVersions
type ListAIAgentVersionsPaginator struct {
	options   ListAIAgentVersionsPaginatorOptions
	client    ListAIAgentVersionsAPIClient
	params    *ListAIAgentVersionsInput
	nextToken *string
	firstPage bool
}

// NewListAIAgentVersionsPaginator returns a new ListAIAgentVersionsPaginator
func NewListAIAgentVersionsPaginator(client ListAIAgentVersionsAPIClient, params *ListAIAgentVersionsInput, optFns ...func(*ListAIAgentVersionsPaginatorOptions)) *ListAIAgentVersionsPaginator {
	if params == nil {
		params = &ListAIAgentVersionsInput{}
	}

	options := ListAIAgentVersionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAIAgentVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAIAgentVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAIAgentVersions page.
func (p *ListAIAgentVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAIAgentVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAIAgentVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAIAgentVersionsAPIClient is a client that implements the
// ListAIAgentVersions operation.
type ListAIAgentVersionsAPIClient interface {
	ListAIAgentVersions(context.Context, *ListAIAgentVersionsInput, ...func(*Options)) (*ListAIAgentVersionsOutput, error)
}

var _ ListAIAgentVersionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAIAgentVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAIAgentVersions",
	}
}
