// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new data accessor for an ISV to access data from a Amazon Q Business
// application. The data accessor is an entity that represents the ISV's access to
// the Amazon Q Business application's data. It includes the IAM role ARN for the
// ISV, a friendly name, and a set of action configurations that define the
// specific actions the ISV is allowed to perform and any associated data filters.
// When the data accessor is created, an IAM Identity Center application is also
// created to manage the ISV's identity and authentication for accessing the Amazon
// Q Business application.
func (c *Client) CreateDataAccessor(ctx context.Context, params *CreateDataAccessorInput, optFns ...func(*Options)) (*CreateDataAccessorOutput, error) {
	if params == nil {
		params = &CreateDataAccessorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDataAccessor", params, optFns, c.addOperationCreateDataAccessorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDataAccessorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDataAccessorInput struct {

	// A list of action configurations specifying the allowed actions and any
	// associated filters.
	//
	// This member is required.
	ActionConfigurations []types.ActionConfiguration

	// The unique identifier of the Amazon Q Business application.
	//
	// This member is required.
	ApplicationId *string

	// A friendly name for the data accessor.
	//
	// This member is required.
	DisplayName *string

	// The Amazon Resource Name (ARN) of the IAM role for the ISV that will be
	// accessing the data.
	//
	// This member is required.
	Principal *string

	// A unique, case-sensitive identifier you provide to ensure idempotency of the
	// request.
	ClientToken *string

	// The tags to associate with the data accessor.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateDataAccessorOutput struct {

	// The Amazon Resource Name (ARN) of the created data accessor.
	//
	// This member is required.
	DataAccessorArn *string

	// The unique identifier of the created data accessor.
	//
	// This member is required.
	DataAccessorId *string

	// The Amazon Resource Name (ARN) of the IAM Identity Center application created
	// for this data accessor.
	//
	// This member is required.
	IdcApplicationArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDataAccessorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateDataAccessor{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateDataAccessor{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDataAccessor"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateDataAccessorMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDataAccessorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDataAccessor(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateDataAccessor struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateDataAccessor) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateDataAccessor) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateDataAccessorInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateDataAccessorInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateDataAccessorMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateDataAccessor{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateDataAccessor(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDataAccessor",
	}
}
